/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompoundNBT
implements INBT {
    private static final Logger field_191551_b = LogManager.getLogger();
    private static final Pattern field_193583_c = Pattern.compile("[A-Za-z0-9._+-]+");
    private final Map<String, INBT> field_74784_a = Maps.newHashMap();

    public void func_74734_a(DataOutput output) throws IOException {
        for (String s : this.field_74784_a.keySet()) {
            INBT inbt = this.field_74784_a.get(s);
            CompoundNBT.func_150298_a(s, inbt, output);
        }
        output.writeByte(0);
    }

    public void func_152446_a(DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        byte b0;
        sizeTracker.func_152450_a(384L);
        if (depth > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.field_74784_a.clear();
        while ((b0 = CompoundNBT.func_152447_a(input, sizeTracker)) != 0) {
            String s = CompoundNBT.func_152448_b(input, sizeTracker);
            sizeTracker.func_152450_a(224 + 16 * s.length());
            INBT inbt = CompoundNBT.func_152449_a(b0, s, input, depth + 1, sizeTracker);
            if (this.field_74784_a.put(s, inbt) == null) continue;
            sizeTracker.func_152450_a(288L);
        }
    }

    public Set<String> func_150296_c() {
        return this.field_74784_a.keySet();
    }

    public byte func_74732_a() {
        return 10;
    }

    public int func_186856_d() {
        return this.field_74784_a.size();
    }

    @Nullable
    public INBT func_218657_a(String key, INBT p_218657_2_) {
        if (p_218657_2_ == null) {
            throw new IllegalArgumentException("Invalid null NBT value with key " + key);
        }
        return this.field_74784_a.put(key, p_218657_2_);
    }

    public void func_74774_a(String key, byte value) {
        this.field_74784_a.put(key, (INBT)new ByteNBT(value));
    }

    public void func_74777_a(String key, short value) {
        this.field_74784_a.put(key, (INBT)new ShortNBT(value));
    }

    public void func_74768_a(String key, int value) {
        this.field_74784_a.put(key, (INBT)new IntNBT(value));
    }

    public void func_74772_a(String key, long value) {
        this.field_74784_a.put(key, (INBT)new LongNBT(value));
    }

    public void func_186854_a(String key, UUID value) {
        this.func_74772_a(key + "Most", value.getMostSignificantBits());
        this.func_74772_a(key + "Least", value.getLeastSignificantBits());
    }

    public UUID func_186857_a(String key) {
        return new UUID(this.func_74763_f(key + "Most"), this.func_74763_f(key + "Least"));
    }

    public boolean func_186855_b(String key) {
        return this.func_150297_b(key + "Most", 99) && this.func_150297_b(key + "Least", 99);
    }

    public void func_74776_a(String key, float value) {
        this.field_74784_a.put(key, (INBT)new FloatNBT(value));
    }

    public void func_74780_a(String key, double value) {
        this.field_74784_a.put(key, (INBT)new DoubleNBT(value));
    }

    public void func_74778_a(String key, String value) {
        this.field_74784_a.put(key, new StringNBT(value));
    }

    public void func_74773_a(String key, byte[] value) {
        this.field_74784_a.put(key, (INBT)new ByteArrayNBT(value));
    }

    public void func_74783_a(String key, int[] value) {
        this.field_74784_a.put(key, (INBT)new IntArrayNBT(value));
    }

    public void func_197646_b(String key, List<Integer> value) {
        this.field_74784_a.put(key, (INBT)new IntArrayNBT(value));
    }

    public void func_197644_a(String key, long[] value) {
        this.field_74784_a.put(key, (INBT)new LongArrayNBT(value));
    }

    public void func_202168_c(String key, List<Long> value) {
        this.field_74784_a.put(key, (INBT)new LongArrayNBT(value));
    }

    public void func_74757_a(String key, boolean value) {
        this.func_74774_a(key, (byte)(value ? 1 : 0));
    }

    @Nullable
    public INBT func_74781_a(String key) {
        return this.field_74784_a.get(key);
    }

    public byte func_150299_b(String key) {
        INBT inbt = this.field_74784_a.get(key);
        return inbt == null ? (byte)0 : inbt.func_74732_a();
    }

    public boolean func_74764_b(String key) {
        return this.field_74784_a.containsKey(key);
    }

    public boolean func_150297_b(String key, int type) {
        byte i = this.func_150299_b(key);
        if (i == type) {
            return true;
        }
        if (type != 99) {
            return false;
        }
        return i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6;
    }

    public byte func_74771_c(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NumberNBT)this.field_74784_a.get(key)).func_150290_f();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short func_74765_d(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NumberNBT)this.field_74784_a.get(key)).func_150289_e();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int func_74762_e(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NumberNBT)this.field_74784_a.get(key)).func_150287_d();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long func_74763_f(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NumberNBT)this.field_74784_a.get(key)).func_150291_c();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float func_74760_g(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NumberNBT)this.field_74784_a.get(key)).func_150288_h();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double func_74769_h(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NumberNBT)this.field_74784_a.get(key)).func_150286_g();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String func_74779_i(String key) {
        try {
            if (this.func_150297_b(key, 8)) {
                return this.field_74784_a.get(key).func_150285_a_();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] func_74770_j(String key) {
        try {
            if (this.func_150297_b(key, 7)) {
                return ((ByteArrayNBT)this.field_74784_a.get(key)).func_150292_c();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_82581_a(key, 7, classcastexception));
        }
        return new byte[0];
    }

    public int[] func_74759_k(String key) {
        try {
            if (this.func_150297_b(key, 11)) {
                return ((IntArrayNBT)this.field_74784_a.get(key)).func_150302_c();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_82581_a(key, 11, classcastexception));
        }
        return new int[0];
    }

    public long[] func_197645_o(String key) {
        try {
            if (this.func_150297_b(key, 12)) {
                return ((LongArrayNBT)this.field_74784_a.get(key)).func_197652_h();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_82581_a(key, 12, classcastexception));
        }
        return new long[0];
    }

    public CompoundNBT func_74775_l(String key) {
        try {
            if (this.func_150297_b(key, 10)) {
                return (CompoundNBT)this.field_74784_a.get(key);
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_82581_a(key, 10, classcastexception));
        }
        return new CompoundNBT();
    }

    public ListNBT func_150295_c(String key, int type) {
        try {
            if (this.func_150299_b(key) == 9) {
                ListNBT listnbt = (ListNBT)this.field_74784_a.get(key);
                if (!listnbt.isEmpty() && listnbt.func_150303_d() != type) {
                    return new ListNBT();
                }
                return listnbt;
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_82581_a(key, 9, classcastexception));
        }
        return new ListNBT();
    }

    public boolean func_74767_n(String key) {
        return this.func_74771_c(key) != 0;
    }

    public void func_82580_o(String key) {
        this.field_74784_a.remove(key);
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("{");
        Collection<String> collection = this.field_74784_a.keySet();
        if (field_191551_b.isDebugEnabled()) {
            ArrayList list = Lists.newArrayList(this.field_74784_a.keySet());
            Collections.sort(list);
            collection = list;
        }
        for (String s : collection) {
            if (stringbuilder.length() != 1) {
                stringbuilder.append(',');
            }
            stringbuilder.append(CompoundNBT.func_193582_s(s)).append(':').append(this.field_74784_a.get(s));
        }
        return stringbuilder.append('}').toString();
    }

    public boolean isEmpty() {
        return this.field_74784_a.isEmpty();
    }

    private CrashReport func_82581_a(String key, int expectedType, ClassCastException ex) {
        CrashReport crashreport = CrashReport.func_85055_a(ex, "Reading NBT data");
        CrashReportCategory crashreportcategory = crashreport.func_85057_a("Corrupt NBT tag", 1);
        crashreportcategory.func_189529_a("Tag type found", (ICrashReportDetail<String>)((ICrashReportDetail)() -> field_82578_b[this.field_74784_a.get(key).func_74732_a()]));
        crashreportcategory.func_189529_a("Tag type expected", (ICrashReportDetail<String>)((ICrashReportDetail)() -> field_82578_b[expectedType]));
        crashreportcategory.func_71507_a("Tag name", key);
        return crashreport;
    }

    public CompoundNBT func_74737_b() {
        CompoundNBT compoundnbt = new CompoundNBT();
        for (String s : this.field_74784_a.keySet()) {
            compoundnbt.func_218657_a(s, this.field_74784_a.get(s).func_74737_b());
        }
        return compoundnbt;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        return p_equals_1_ instanceof CompoundNBT && Objects.equals(this.field_74784_a, ((CompoundNBT)p_equals_1_).field_74784_a);
    }

    public int hashCode() {
        return this.field_74784_a.hashCode();
    }

    private static void func_150298_a(String name, INBT data, DataOutput output) throws IOException {
        output.writeByte(data.func_74732_a());
        if (data.func_74732_a() != 0) {
            output.writeUTF(name);
            data.func_74734_a(output);
        }
    }

    private static byte func_152447_a(DataInput input, NBTSizeTracker sizeTracker) throws IOException {
        sizeTracker.func_152450_a(8L);
        return input.readByte();
    }

    private static String func_152448_b(DataInput input, NBTSizeTracker sizeTracker) throws IOException {
        return input.readUTF();
    }

    static INBT func_152449_a(byte id, String key, DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        sizeTracker.func_152450_a(32L);
        INBT inbt = INBT.func_150284_a((byte)id);
        try {
            inbt.func_152446_a(input, depth, sizeTracker);
            return inbt;
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.func_85055_a(ioexception, "Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("NBT Tag");
            crashreportcategory.func_71507_a("Tag name", key);
            crashreportcategory.func_71507_a("Tag type", id);
            throw new ReportedException(crashreport);
        }
    }

    public CompoundNBT func_197643_a(CompoundNBT other) {
        for (String s : other.field_74784_a.keySet()) {
            INBT inbt = other.field_74784_a.get(s);
            if (inbt.func_74732_a() == 10) {
                if (this.func_150297_b(s, 10)) {
                    CompoundNBT compoundnbt = this.func_74775_l(s);
                    compoundnbt.func_197643_a((CompoundNBT)inbt);
                    continue;
                }
                this.func_218657_a(s, inbt.func_74737_b());
                continue;
            }
            this.func_218657_a(s, inbt.func_74737_b());
        }
        return this;
    }

    protected static String func_193582_s(String p_193582_0_) {
        return field_193583_c.matcher(p_193582_0_).matches() ? p_193582_0_ : StringNBT.func_197654_a(p_193582_0_);
    }

    protected static ITextComponent func_197642_t(String p_197642_0_) {
        if (field_193583_c.matcher(p_197642_0_).matches()) {
            return new StringTextComponent(p_197642_0_).func_211708_a(field_197638_b);
        }
        String s = StringNBT.func_197654_a(p_197642_0_);
        String s1 = s.substring(0, 1);
        ITextComponent itextcomponent = new StringTextComponent(s.substring(1, s.length() - 1)).func_211708_a(field_197638_b);
        return new StringTextComponent(s1).func_150257_a(itextcomponent).func_150258_a(s1);
    }

    public ITextComponent func_199850_a(String indentation, int indentDepth) {
        if (this.field_74784_a.isEmpty()) {
            return new StringTextComponent("{}");
        }
        StringTextComponent itextcomponent = new StringTextComponent("{");
        Collection<String> collection = this.field_74784_a.keySet();
        if (field_191551_b.isDebugEnabled()) {
            ArrayList list = Lists.newArrayList(this.field_74784_a.keySet());
            Collections.sort(list);
            collection = list;
        }
        if (!indentation.isEmpty()) {
            itextcomponent.func_150258_a("\n");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            ITextComponent itextcomponent1 = new StringTextComponent(Strings.repeat((String)indentation, (int)(indentDepth + 1))).func_150257_a(CompoundNBT.func_197642_t(s)).func_150258_a(String.valueOf(':')).func_150258_a(" ").func_150257_a(this.field_74784_a.get(s).func_199850_a(indentation, indentDepth + 1));
            if (iterator.hasNext()) {
                itextcomponent1.func_150258_a(String.valueOf(',')).func_150258_a(indentation.isEmpty() ? " " : "\n");
            }
            itextcomponent.func_150257_a(itextcomponent1);
        }
        if (!indentation.isEmpty()) {
            itextcomponent.func_150258_a("\n").func_150258_a(Strings.repeat((String)indentation, (int)indentDepth));
        }
        itextcomponent.func_150258_a("}");
        return itextcomponent;
    }
}

