/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class RavagerEntity
extends AbstractRaiderEntity {
    private static final Predicate<Entity> field_213690_b = p_213685_0_ -> p_213685_0_.func_70089_S() && !(p_213685_0_ instanceof RavagerEntity);
    private int field_213691_bz;
    private int field_213692_bA;
    private int field_213689_bB;

    public RavagerEntity(EntityType<? extends RavagerEntity> p_i50197_1_, World p_i50197_2_) {
        super(p_i50197_1_, p_i50197_2_);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 20;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.4));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)((Object)this), MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), IronGolemEntity.class, true));
    }

    protected void func_213385_F() {
        boolean flag = !(this.func_184179_bs() instanceof MobEntity) || this.func_184179_bs().func_200600_R().func_220341_a(EntityTypeTags.field_219765_b);
        boolean flag1 = !(this.func_184187_bx() instanceof BoatEntity);
        this.field_70714_bg.func_220878_a(Goal.Flag.MOVE, flag);
        this.field_70714_bg.func_220878_a(Goal.Flag.JUMP, flag && flag1);
        this.field_70714_bg.func_220878_a(Goal.Flag.LOOK, flag);
        this.field_70714_bg.func_220878_a(Goal.Flag.TARGET, flag);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111128_a(1.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("AttackTick", this.field_213691_bz);
        compound.func_74768_a("StunTick", this.field_213692_bA);
        compound.func_74768_a("RoarTick", this.field_213689_bB);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_213691_bz = compound.func_74762_e("AttackTick");
        this.field_213692_bA = compound.func_74762_e("StunTick");
        this.field_213689_bB = compound.func_74762_e("RoarTick");
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219645_fe;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new Navigator((MobEntity)((Object)this), worldIn);
    }

    public int func_184649_cE() {
        return 45;
    }

    public double func_70042_X() {
        return 2.1;
    }

    public boolean func_82171_bF() {
        return !this.func_175446_cd() && this.func_184179_bs() instanceof LivingEntity;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)((Object)this.func_184188_bt().get(0));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70089_S()) {
            if (this.func_70610_aX()) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
            } else {
                double d0 = this.func_70638_az() != null ? 0.35 : 0.3;
                double d1 = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(MathHelper.func_219803_d((double)0.1, (double)d1, (double)d0));
            }
            if (this.field_70123_F && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)((Object)this))) {
                boolean flag = false;
                AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(0.2);
                for (BlockPos blockpos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)axisalignedbb.field_72340_a), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72338_b), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72339_c), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72336_d), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72337_e), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72334_f))) {
                    BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = blockstate.func_177230_c();
                    if (!(block instanceof LeavesBlock)) continue;
                    flag = this.field_70170_p.func_175655_b(blockpos, true) || flag;
                }
                if (!flag && this.field_70122_E) {
                    this.func_70664_aZ();
                }
            }
            if (this.field_213689_bB > 0) {
                --this.field_213689_bB;
                if (this.field_213689_bB == 10) {
                    this.func_213686_ei();
                }
            }
            if (this.field_213691_bz > 0) {
                --this.field_213691_bz;
            }
            if (this.field_213692_bA > 0) {
                --this.field_213692_bA;
                this.func_213682_eh();
                if (this.field_213692_bA == 0) {
                    this.func_184185_a(SoundEvents.field_219650_fj, 1.0f, 1.0f);
                    this.field_213689_bB = 20;
                }
            }
        }
    }

    private void func_213682_eh() {
        if (this.field_70146_Z.nextInt(6) == 0) {
            double d0 = this.field_70165_t - (double)this.func_213311_cf() * Math.sin(this.field_70761_aq * ((float)Math.PI / 180)) + (this.field_70146_Z.nextDouble() * 0.6 - 0.3);
            double d1 = this.field_70163_u + (double)this.func_213302_cg() - 0.3;
            double d2 = this.field_70161_v + (double)this.func_213311_cf() * Math.cos(this.field_70761_aq * ((float)Math.PI / 180)) + (this.field_70146_Z.nextDouble() * 0.6 - 0.3);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, d0, d1, d2, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.field_213691_bz > 0 || this.field_213692_bA > 0 || this.field_213689_bB > 0;
    }

    public boolean func_70685_l(Entity entityIn) {
        return this.field_213692_bA <= 0 && this.field_213689_bB <= 0 ? super.func_70685_l(entityIn) : false;
    }

    protected void func_213371_e(LivingEntity p_213371_1_) {
        if (this.field_213689_bB == 0) {
            if (this.field_70146_Z.nextDouble() < 0.5) {
                this.field_213692_bA = 40;
                this.func_184185_a(SoundEvents.field_219649_fi, 1.0f, 1.0f);
                this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)39);
                p_213371_1_.func_70108_f((Entity)((Object)this));
            } else {
                this.func_213688_a(p_213371_1_);
            }
            p_213371_1_.field_70133_I = true;
        }
    }

    private void func_213686_ei() {
        if (this.func_70089_S()) {
            for (Entity entity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(4.0), field_213690_b)) {
                if (!(entity instanceof AbstractIllagerEntity)) {
                    entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)((Object)this)), 6.0f);
                }
                this.func_213688_a(entity);
            }
            Vec3d vec3d = this.func_174813_aQ().func_189972_c();
            for (int i = 0; i < 40; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.2;
                double d1 = this.field_70146_Z.nextGaussian() * 0.2;
                double d2 = this.field_70146_Z.nextGaussian() * 0.2;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, d0, d1, d2);
            }
        }
    }

    private void func_213688_a(Entity p_213688_1_) {
        double d0 = p_213688_1_.field_70165_t - this.field_70165_t;
        double d1 = p_213688_1_.field_70161_v - this.field_70161_v;
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_213688_1_.func_70024_g(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.field_213691_bz = 10;
            this.func_184185_a(SoundEvents.field_219644_fd, 1.0f, 1.0f);
        } else if (id == 39) {
            this.field_213692_bA = 40;
        }
        super.func_70103_a(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_213683_l() {
        return this.field_213691_bz;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_213684_dX() {
        return this.field_213692_bA;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_213687_eg() {
        return this.field_213689_bB;
    }

    public boolean func_70652_k(Entity entityIn) {
        this.field_213691_bz = 10;
        this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)4);
        this.func_184185_a(SoundEvents.field_219644_fd, 1.0f, 1.0f);
        return super.func_70652_k(entityIn);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_219643_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_219647_fg;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219646_ff;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_219648_fh, 0.15f, 1.0f);
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return !worldIn.func_72953_d(this.func_174813_aQ());
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    public boolean func_213637_dY() {
        return false;
    }

    static class Processor
    extends WalkNodeProcessor {
        private Processor() {
        }

        @Override
        protected PathNodeType func_215744_a(IBlockReader p_215744_1_, boolean p_215744_2_, boolean p_215744_3_, BlockPos p_215744_4_, PathNodeType p_215744_5_) {
            return p_215744_5_ == PathNodeType.LEAVES ? PathNodeType.OPEN : super.func_215744_a(p_215744_1_, p_215744_2_, p_215744_3_, p_215744_4_, p_215744_5_);
        }
    }

    static class Navigator
    extends GroundPathNavigator {
        public Navigator(MobEntity p_i50754_1_, World p_i50754_2_) {
            super(p_i50754_1_, p_i50754_2_);
        }

        protected PathFinder func_179679_a(int p_179679_1_) {
            this.field_179695_a = new Processor();
            return new PathFinder(this.field_179695_a, p_179679_1_);
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((CreatureEntity)RavagerEntity.this, 1.0, true);
        }

        @Override
        protected double func_179512_a(LivingEntity attackTarget) {
            float f = RavagerEntity.this.func_213311_cf() - 0.1f;
            return f * 2.0f * f * 2.0f + attackTarget.func_213311_cf();
        }
    }
}

