/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemFrameEntity
extends HangingEntity {
    private static final Logger field_195052_c = LogManager.getLogger();
    private static final DataParameter<ItemStack> field_184525_c = EntityDataManager.func_187226_a(ItemFrameEntity.class, DataSerializers.field_187196_f);
    private static final DataParameter<Integer> field_184526_d = EntityDataManager.func_187226_a(ItemFrameEntity.class, DataSerializers.field_187192_b);
    private float field_82337_e = 1.0f;

    public ItemFrameEntity(EntityType<? extends ItemFrameEntity> p_i50224_1_, World p_i50224_2_) {
        super((EntityType<? extends HangingEntity>)p_i50224_1_, p_i50224_2_);
    }

    public ItemFrameEntity(World worldIn, BlockPos p_i45852_2_, Direction p_i45852_3_) {
        super(EntityType.field_200766_F, worldIn, p_i45852_2_);
        this.func_174859_a(p_i45852_3_);
    }

    @Override
    protected float func_213316_a(Pose p_213316_1_, EntitySize p_213316_2_) {
        return 0.0f;
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184525_c, ItemStack.field_190927_a);
        this.func_184212_Q().func_187214_a(field_184526_d, 0);
    }

    @Override
    protected void func_174859_a(Direction facingDirectionIn) {
        Validate.notNull((Object)((Object)facingDirectionIn));
        this.field_174860_b = facingDirectionIn;
        if (facingDirectionIn.func_176740_k().func_176722_c()) {
            this.field_70125_A = 0.0f;
            this.field_70177_z = this.field_174860_b.func_176736_b() * 90;
        } else {
            this.field_70125_A = -90 * facingDirectionIn.func_176743_c().func_179524_a();
            this.field_70177_z = 0.0f;
        }
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.func_174856_o();
    }

    @Override
    protected void func_174856_o() {
        if (this.field_174860_b != null) {
            double d0 = 0.46875;
            this.field_70165_t = (double)this.field_174861_a.func_177958_n() + 0.5 - (double)this.field_174860_b.func_82601_c() * 0.46875;
            this.field_70163_u = (double)this.field_174861_a.func_177956_o() + 0.5 - (double)this.field_174860_b.func_96559_d() * 0.46875;
            this.field_70161_v = (double)this.field_174861_a.func_177952_p() + 0.5 - (double)this.field_174860_b.func_82599_e() * 0.46875;
            double d1 = this.func_82329_d();
            double d2 = this.func_82330_g();
            double d3 = this.func_82329_d();
            Direction.Axis direction$axis = this.field_174860_b.func_176740_k();
            switch (direction$axis) {
                case X: {
                    d1 = 1.0;
                    break;
                }
                case Y: {
                    d2 = 1.0;
                    break;
                }
                case Z: {
                    d3 = 1.0;
                }
            }
            this.func_174826_a(new AxisAlignedBB(this.field_70165_t - (d1 /= 32.0), this.field_70163_u - (d2 /= 32.0), this.field_70161_v - (d3 /= 32.0), this.field_70165_t + d1, this.field_70163_u + d2, this.field_70161_v + d3));
        }
    }

    @Override
    public boolean func_70518_d() {
        if (!this.field_70170_p.func_217345_j(this)) {
            return false;
        }
        BlockState blockstate = this.field_70170_p.func_180495_p(this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d()));
        return blockstate.func_185904_a().func_76220_a() || this.field_174860_b.func_176740_k().func_176722_c() && RedstoneDiodeBlock.func_185546_B(blockstate) ? this.field_70170_p.func_175674_a(this, this.func_174813_aQ(), field_184524_c).isEmpty() : false;
    }

    @Override
    public float func_70111_Y() {
        return 0.0f;
    }

    @Override
    public void func_174812_G() {
        this.func_110131_b(this.func_82335_i());
        super.func_174812_G();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!source.func_94541_c() && !this.func_82335_i().func_190926_b()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_146065_b(source.func_76346_g(), false);
                this.func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
            }
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public int func_82329_d() {
        return 12;
    }

    @Override
    public int func_82330_g() {
        return 12;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 16.0;
        return distance < (d0 = d0 * 64.0 * ItemFrameEntity.func_184183_bd()) * d0;
    }

    @Override
    public void func_110128_b(@Nullable Entity brokenEntity) {
        this.func_184185_a(SoundEvents.field_187623_cM, 1.0f, 1.0f);
        this.func_146065_b(brokenEntity, true);
    }

    @Override
    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187626_cN, 1.0f, 1.0f);
    }

    private void func_146065_b(@Nullable Entity entityIn, boolean p_146065_2_) {
        if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            if (entityIn == null) {
                this.func_110131_b(this.func_82335_i());
            }
        } else {
            ItemStack itemstack = this.func_82335_i();
            this.func_82334_a(ItemStack.field_190927_a);
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                if (playerentity.field_71075_bZ.field_75098_d) {
                    this.func_110131_b(itemstack);
                    return;
                }
            }
            if (p_146065_2_) {
                this.func_199703_a(Items.field_151160_bD);
            }
            if (!itemstack.func_190926_b()) {
                itemstack = itemstack.func_77946_l();
                this.func_110131_b(itemstack);
                if (this.field_70146_Z.nextFloat() < this.field_82337_e) {
                    this.func_199701_a_(itemstack);
                }
            }
        }
    }

    private void func_110131_b(ItemStack stack) {
        if (stack.func_77973_b() instanceof FilledMapItem) {
            MapData mapdata = FilledMapItem.func_195950_a(stack, this.field_70170_p);
            mapdata.func_212441_a(this.field_174861_a, this.func_145782_y());
            mapdata.func_76186_a(true);
        }
        stack.func_82842_a(null);
    }

    public ItemStack func_82335_i() {
        return this.func_184212_Q().func_187225_a(field_184525_c);
    }

    public void func_82334_a(ItemStack stack) {
        this.func_174864_a(stack, true);
    }

    public void func_174864_a(ItemStack stack, boolean p_174864_2_) {
        if (!stack.func_190926_b()) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            stack.func_82842_a(this);
        }
        this.func_184212_Q().func_187227_b(field_184525_c, stack);
        if (!stack.func_190926_b()) {
            this.func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
        }
        if (p_174864_2_ && this.field_174861_a != null) {
            this.field_70170_p.func_175666_e(this.field_174861_a, Blocks.field_150350_a);
        }
    }

    @Override
    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (inventorySlot == 0) {
            this.func_82334_a(itemStackIn);
            return true;
        }
        return false;
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        ItemStack itemstack;
        if (key.equals(field_184525_c) && !(itemstack = this.func_82335_i()).func_190926_b() && itemstack.func_82836_z() != this) {
            itemstack.func_82842_a(this);
        }
    }

    public int func_82333_j() {
        return this.func_184212_Q().func_187225_a(field_184526_d);
    }

    public void func_82336_g(int rotationIn) {
        this.func_174865_a(rotationIn, true);
    }

    private void func_174865_a(int rotationIn, boolean p_174865_2_) {
        this.func_184212_Q().func_187227_b(field_184526_d, rotationIn % 8);
        if (p_174865_2_ && this.field_174861_a != null) {
            this.field_70170_p.func_175666_e(this.field_174861_a, Blocks.field_150350_a);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (!this.func_82335_i().func_190926_b()) {
            compound.func_218657_a("Item", this.func_82335_i().func_77955_b(new CompoundNBT()));
            compound.func_74774_a("ItemRotation", (byte)this.func_82333_j());
            compound.func_74776_a("ItemDropChance", this.field_82337_e);
        }
        compound.func_74774_a("Facing", (byte)this.field_174860_b.func_176745_a());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        CompoundNBT compoundnbt = compound.func_74775_l("Item");
        if (compoundnbt != null && !compoundnbt.isEmpty()) {
            ItemStack itemstack1;
            ItemStack itemstack = ItemStack.func_199557_a(compoundnbt);
            if (itemstack.func_190926_b()) {
                field_195052_c.warn("Unable to load item from: {}", (Object)compoundnbt);
            }
            if (!(itemstack1 = this.func_82335_i()).func_190926_b() && !ItemStack.func_77989_b(itemstack, itemstack1)) {
                this.func_110131_b(itemstack1);
            }
            this.func_174864_a(itemstack, false);
            this.func_174865_a(compound.func_74771_c("ItemRotation"), false);
            if (compound.func_150297_b("ItemDropChance", 99)) {
                this.field_82337_e = compound.func_74760_g("ItemDropChance");
            }
        }
        this.func_174859_a(Direction.func_82600_a(compound.func_74771_c("Facing")));
    }

    @Override
    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_82335_i().func_190926_b()) {
                if (!itemstack.func_190926_b()) {
                    this.func_82334_a(itemstack);
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                }
            } else {
                this.func_184185_a(SoundEvents.field_187632_cP, 1.0f, 1.0f);
                this.func_82336_g(this.func_82333_j() + 1);
            }
        }
        return true;
    }

    public int func_174866_q() {
        return this.func_82335_i().func_190926_b() ? 0 : this.func_82333_j() % 8 + 1;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this, this.func_200600_R(), this.field_174860_b.func_176745_a(), this.func_174857_n());
    }
}

