/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Enchantment
extends ForgeRegistryEntry<Enchantment> {
    private final EquipmentSlotType[] field_185263_a;
    private final Rarity field_77333_a;
    @Nullable
    public EnchantmentType field_77351_y;
    @Nullable
    protected String field_77350_z;

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static Enchantment func_185262_c(int id) {
        return (Enchantment)((Object)Registry.field_212628_q.func_148745_a(id));
    }

    protected Enchantment(Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType[] slots) {
        this.field_77333_a = rarityIn;
        this.field_77351_y = typeIn;
        this.field_185263_a = slots;
    }

    public Map<EquipmentSlotType, ItemStack> func_222181_a(LivingEntity livingEntityIn) {
        EnumMap map = Maps.newEnumMap(EquipmentSlotType.class);
        for (EquipmentSlotType equipmentslottype : this.field_185263_a) {
            ItemStack itemstack = livingEntityIn.func_184582_a(equipmentslottype);
            if (itemstack.func_190926_b()) continue;
            map.put(equipmentslottype, itemstack);
        }
        return map;
    }

    public Rarity func_77324_c() {
        return this.field_77333_a;
    }

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 1;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 1 + enchantmentLevel * 10;
    }

    public int func_223551_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 5;
    }

    public int func_77318_a(int level, DamageSource source) {
        return 0;
    }

    public float func_152376_a(int level, CreatureAttribute creatureType) {
        return 0.0f;
    }

    public final boolean func_191560_c(Enchantment enchantmentIn) {
        return this.func_77326_a(enchantmentIn) && enchantmentIn.func_77326_a(this);
    }

    protected boolean func_77326_a(Enchantment ench) {
        return this != ench;
    }

    protected String func_210771_f() {
        if (this.field_77350_z == null) {
            this.field_77350_z = Util.func_200697_a((String)"enchantment", (ResourceLocation)Registry.field_212628_q.func_177774_c(this));
        }
        return this.field_77350_z;
    }

    public String func_77320_a() {
        return this.func_210771_f();
    }

    public ITextComponent func_200305_d(int level) {
        TranslationTextComponent itextcomponent = new TranslationTextComponent(this.func_77320_a(), new Object[0]);
        if (this.func_190936_d()) {
            itextcomponent.func_211708_a(TextFormatting.RED);
        } else {
            itextcomponent.func_211708_a(TextFormatting.GRAY);
        }
        if (level != 1 || this.func_77325_b() != 1) {
            itextcomponent.func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("enchantment.level." + level, new Object[0]));
        }
        return itextcomponent;
    }

    public boolean func_92089_a(ItemStack stack) {
        return this.canApplyAtEnchantingTable(stack);
    }

    public void func_151368_a(LivingEntity user, Entity target, int level) {
    }

    public void func_151367_b(LivingEntity user, Entity attacker, int level) {
    }

    public boolean func_185261_e() {
        return false;
    }

    public boolean func_190936_d() {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.canApplyAtEnchantingTable(this);
    }

    public boolean isAllowedOnBooks() {
        return true;
    }

    public static enum Rarity {
        COMMON(10),
        UNCOMMON(5),
        RARE(2),
        VERY_RARE(1);

        private final int field_185275_e;

        private Rarity(int rarityWeight) {
            this.field_185275_e = rarityWeight;
        }

        public int func_185270_a() {
            return this.field_185275_e;
        }
    }
}

