/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.ItemModelMesherForge;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

@OnlyIn(value=Dist.CLIENT)
public class ItemRenderer
implements IResourceManagerReloadListener {
    public static final ResourceLocation field_110798_h = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final Set<Item> field_195411_c = Sets.newHashSet((Object[])new Item[]{Items.field_190931_a});
    public float field_77023_b;
    private final ItemModelMesher field_175059_m;
    private final TextureManager field_175057_n;
    private final ItemColors field_184395_f;

    public ItemRenderer(TextureManager textureManagerIn, ModelManager modelManagerIn, ItemColors itemColorsIn) {
        this.field_175057_n = textureManagerIn;
        this.field_175059_m = new ItemModelMesherForge(modelManagerIn);
        for (Item item : Registry.field_212630_s) {
            if (field_195411_c.contains((Object)item)) continue;
            this.field_175059_m.func_199311_a(item, new ModelResourceLocation(Registry.field_212630_s.func_177774_c((Object)item), "inventory"));
        }
        this.field_184395_f = itemColorsIn;
    }

    public ItemModelMesher func_175037_a() {
        return this.field_175059_m;
    }

    private void func_191961_a(IBakedModel model, ItemStack stack) {
        this.func_191967_a(model, -1, stack);
    }

    private void func_191965_a(IBakedModel model, int color) {
        this.func_191967_a(model, color, ItemStack.field_190927_a);
    }

    private void func_191967_a(IBakedModel model, int color, ItemStack stack) {
        if (((Boolean)ForgeConfig.CLIENT.allowEmissiveItems.get()).booleanValue()) {
            ForgeHooksClient.renderLitItem((ItemRenderer)this, (IBakedModel)model, (int)color, (ItemStack)stack);
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            this.func_191970_a(bufferbuilder, model.func_200117_a(null, direction, random), color, stack);
        }
        random.setSeed(42L);
        this.func_191970_a(bufferbuilder, model.func_200117_a(null, null, random), color, stack);
        tessellator.func_78381_a();
    }

    public void func_180454_a(ItemStack stack, IBakedModel model) {
        if (!stack.func_190926_b()) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (model.func_188618_c()) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.enableRescaleNormal();
                stack.func_77973_b().getTileEntityItemStackRenderer().func_179022_a(stack);
            } else {
                this.func_191961_a(model, stack);
                if (stack.func_77962_s()) {
                    ItemRenderer.func_211128_a(this.field_175057_n, () -> this.func_191965_a(model, -8372020), 8);
                }
            }
            GlStateManager.popMatrix();
        }
    }

    public static void func_211128_a(TextureManager textureManagerIn, Runnable renderModelFunction, int scale) {
        GlStateManager.depthMask((boolean)false);
        GlStateManager.depthFunc((int)514);
        GlStateManager.disableLighting();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        textureManagerIn.func_110577_a(field_110798_h);
        GlStateManager.matrixMode((int)5890);
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        float f = (float)(Util.func_211177_b() % 3000L) / 3000.0f / (float)scale;
        GlStateManager.translatef((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderModelFunction.run();
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        float f1 = (float)(Util.func_211177_b() % 4873L) / 4873.0f / (float)scale;
        GlStateManager.translatef((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderModelFunction.run();
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.enableLighting();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        textureManagerIn.func_110577_a(AtlasTexture.field_110575_b);
    }

    private void func_175038_a(BufferBuilder renderer, BakedQuad quad) {
        Vec3i vec3i = quad.func_178210_d().func_176730_m();
        renderer.func_178975_e(vec3i.func_177958_n(), vec3i.func_177956_o(), vec3i.func_177952_p());
    }

    private void func_191969_a(BufferBuilder renderer, BakedQuad quad, int color) {
        renderer.func_178981_a(quad.func_178209_a());
        renderer.func_178968_d(color);
        this.func_175038_a(renderer, quad);
    }

    public void func_191970_a(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        boolean flag = color == -1 && !stack.func_190926_b();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = this.field_184395_f.func_186728_a(stack, bakedquad.func_178211_c());
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    public boolean func_175050_a(ItemStack stack) {
        IBakedModel ibakedmodel = this.field_175059_m.func_178089_a(stack);
        return ibakedmodel == null ? false : ibakedmodel.func_177556_c();
    }

    public void func_181564_a(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType) {
        if (!stack.func_190926_b()) {
            IBakedModel ibakedmodel = this.func_204206_b(stack);
            this.func_184394_a(stack, ibakedmodel, cameraTransformType, false);
        }
    }

    public IBakedModel func_184393_a(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entitylivingbaseIn) {
        IBakedModel ibakedmodel = this.field_175059_m.func_178089_a(stack);
        Item item = stack.func_77973_b();
        return !item.func_185040_i() ? ibakedmodel : this.func_204207_a(ibakedmodel, stack, worldIn, entitylivingbaseIn);
    }

    public IBakedModel func_204205_b(ItemStack stack, World worldIn, LivingEntity entityIn) {
        Item item = stack.func_77973_b();
        IBakedModel ibakedmodel = item == Items.field_203184_eO ? this.field_175059_m.func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident_in_hand#inventory")) : this.field_175059_m.func_178089_a(stack);
        return !item.func_185040_i() ? ibakedmodel : this.func_204207_a(ibakedmodel, stack, worldIn, entityIn);
    }

    public IBakedModel func_204206_b(ItemStack stack) {
        return this.func_184393_a(stack, null, null);
    }

    private IBakedModel func_204207_a(IBakedModel model, ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
        IBakedModel ibakedmodel = model.func_188617_f().func_209581_a(model, stack, worldIn, entityIn);
        return ibakedmodel == null ? this.field_175059_m.func_178083_a().func_174951_a() : ibakedmodel;
    }

    public void func_184392_a(ItemStack stack, LivingEntity entitylivingbaseIn, ItemCameraTransforms.TransformType transform, boolean leftHanded) {
        if (!stack.func_190926_b() && entitylivingbaseIn != null) {
            IBakedModel ibakedmodel = this.func_204205_b(stack, entitylivingbaseIn.field_70170_p, entitylivingbaseIn);
            this.func_184394_a(stack, ibakedmodel, transform, leftHanded);
        }
    }

    protected void func_184394_a(ItemStack stack, IBakedModel bakedmodel, ItemCameraTransforms.TransformType transform, boolean leftHanded) {
        if (!stack.func_190926_b()) {
            this.field_175057_n.func_110577_a(AtlasTexture.field_110575_b);
            this.field_175057_n.func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableRescaleNormal();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.pushMatrix();
            bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)transform, (boolean)leftHanded);
            this.func_180454_a(stack, bakedmodel);
            GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            GlStateManager.popMatrix();
            GlStateManager.disableRescaleNormal();
            GlStateManager.disableBlend();
            this.field_175057_n.func_110577_a(AtlasTexture.field_110575_b);
            this.field_175057_n.func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
        }
    }

    private boolean func_183005_a(ItemTransformVec3f itemTranformVec) {
        return itemTranformVec.field_178363_d.func_195899_a() < 0.0f ^ itemTranformVec.field_178363_d.func_195900_b() < 0.0f ^ itemTranformVec.field_178363_d.func_195902_c() < 0.0f;
    }

    public void func_175042_a(ItemStack stack, int x, int y) {
        this.func_191962_a(stack, x, y, this.func_204206_b(stack));
    }

    protected void func_191962_a(ItemStack stack, int x, int y, IBakedModel bakedmodel) {
        GlStateManager.pushMatrix();
        this.field_175057_n.func_110577_a(AtlasTexture.field_110575_b);
        this.field_175057_n.func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_180452_a(x, y, bakedmodel.func_177556_c());
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        this.func_180454_a(stack, bakedmodel);
        GlStateManager.disableAlphaTest();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableLighting();
        GlStateManager.popMatrix();
        this.field_175057_n.func_110577_a(AtlasTexture.field_110575_b);
        this.field_175057_n.func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
    }

    private void func_180452_a(int xPosition, int yPosition, boolean isGui3d) {
        GlStateManager.translatef((float)xPosition, (float)yPosition, (float)(100.0f + this.field_77023_b));
        GlStateManager.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        if (isGui3d) {
            GlStateManager.enableLighting();
        } else {
            GlStateManager.disableLighting();
        }
    }

    public void func_180450_b(ItemStack stack, int xPosition, int yPosition) {
        this.func_184391_a(Minecraft.func_71410_x().field_71439_g, stack, xPosition, yPosition);
    }

    public void func_184391_a(@Nullable LivingEntity entityIn, ItemStack itemIn, int x, int y) {
        if (!itemIn.func_190926_b()) {
            this.field_77023_b += 50.0f;
            try {
                this.func_191962_a(itemIn, x, y, this.func_184393_a(itemIn, null, entityIn));
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Rendering item");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being rendered");
                crashreportcategory.func_189529_a("Item Type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf((Object)itemIn.func_77973_b())));
                crashreportcategory.func_189529_a("Registry Name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(itemIn.func_77973_b().getRegistryName())));
                crashreportcategory.func_189529_a("Item Damage", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(itemIn.func_77952_i())));
                crashreportcategory.func_189529_a("Item NBT", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(itemIn.func_77978_p())));
                crashreportcategory.func_189529_a("Item Foil", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(itemIn.func_77962_s())));
                throw new ReportedException(crashreport);
            }
            this.field_77023_b -= 50.0f;
        }
    }

    public void func_175030_a(FontRenderer fr, ItemStack stack, int xPosition, int yPosition) {
        this.func_180453_a(fr, stack, xPosition, yPosition, null);
    }

    public void func_180453_a(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text) {
        if (!stack.func_190926_b()) {
            ClientPlayerEntity clientplayerentity;
            float f3;
            if (stack.func_190916_E() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                GlStateManager.disableLighting();
                GlStateManager.disableDepthTest();
                GlStateManager.disableBlend();
                fr.func_175063_a(s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
                GlStateManager.enableBlend();
                GlStateManager.enableLighting();
                GlStateManager.enableDepthTest();
                GlStateManager.enableBlend();
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                GlStateManager.disableLighting();
                GlStateManager.disableDepthTest();
                GlStateManager.disableTexture();
                GlStateManager.disableAlphaTest();
                GlStateManager.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                this.func_181565_a(bufferbuilder, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                this.func_181565_a(bufferbuilder, xPosition + 2, yPosition + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                GlStateManager.enableBlend();
                GlStateManager.enableAlphaTest();
                GlStateManager.enableTexture();
                GlStateManager.enableLighting();
                GlStateManager.enableDepthTest();
            }
            float f = f3 = (clientplayerentity = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : clientplayerentity.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f3 > 0.0f) {
                GlStateManager.disableLighting();
                GlStateManager.disableDepthTest();
                GlStateManager.disableTexture();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
                this.func_181565_a(bufferbuilder1, xPosition, yPosition + MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                GlStateManager.enableTexture();
                GlStateManager.enableLighting();
                GlStateManager.enableDepthTest();
            }
        }
    }

    private void func_181565_a(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b(x + 0, y + 0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b(x + 0, y + height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b(x + width, y + height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b(x + width, y + 0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @Override
    public void func_195410_a(IResourceManager resourceManager) {
        this.field_175059_m.func_178085_b();
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }
}

