/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.LightUtil;

@OnlyIn(value=Dist.CLIENT)
public class BlockModelRenderer {
    private final BlockColors field_187499_a;
    private static final ThreadLocal<Cache> field_210267_b = ThreadLocal.withInitial(() -> new Cache());

    public BlockModelRenderer(BlockColors blockColorsIn) {
        this.field_187499_a = blockColorsIn;
    }

    @Deprecated
    public boolean func_217631_a(IEnviromentBlockReader p_217631_1_, IBakedModel p_217631_2_, BlockState p_217631_3_, BlockPos p_217631_4_, BufferBuilder p_217631_5_, boolean p_217631_6_, Random p_217631_7_, long p_217631_8_) {
        return this.renderModel(p_217631_1_, p_217631_2_, p_217631_3_, p_217631_4_, p_217631_5_, p_217631_6_, p_217631_7_, p_217631_8_, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModel(IEnviromentBlockReader p_217631_1_, IBakedModel p_217631_2_, BlockState p_217631_3_, BlockPos p_217631_4_, BufferBuilder p_217631_5_, boolean p_217631_6_, Random p_217631_7_, long p_217631_8_, IModelData modelData) {
        boolean flag = Minecraft.func_71379_u() && p_217631_3_.getLightValue(p_217631_1_, p_217631_4_) == 0 && p_217631_2_.func_177555_b();
        modelData = p_217631_2_.getModelData(p_217631_1_, p_217631_4_, p_217631_3_, modelData);
        try {
            return flag ? this.renderModelSmooth(p_217631_1_, p_217631_2_, p_217631_3_, p_217631_4_, p_217631_5_, p_217631_6_, p_217631_7_, p_217631_8_, modelData) : this.renderModelFlat(p_217631_1_, p_217631_2_, p_217631_3_, p_217631_4_, p_217631_5_, p_217631_6_, p_217631_7_, p_217631_8_, modelData);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block model being tesselated");
            CrashReportCategory.func_175750_a(crashreportcategory, p_217631_4_, p_217631_3_);
            crashreportcategory.func_71507_a("Using AO", flag);
            throw new ReportedException(crashreport);
        }
    }

    @Deprecated
    public boolean func_217634_b(IEnviromentBlockReader p_217634_1_, IBakedModel p_217634_2_, BlockState p_217634_3_, BlockPos p_217634_4_, BufferBuilder p_217634_5_, boolean p_217634_6_, Random p_217634_7_, long p_217634_8_) {
        return this.renderModelSmooth(p_217634_1_, p_217634_2_, p_217634_3_, p_217634_4_, p_217634_5_, p_217634_6_, p_217634_7_, p_217634_8_, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModelSmooth(IEnviromentBlockReader p_217634_1_, IBakedModel p_217634_2_, BlockState p_217634_3_, BlockPos p_217634_4_, BufferBuilder p_217634_5_, boolean p_217634_6_, Random p_217634_7_, long p_217634_8_, IModelData modelData) {
        boolean flag = false;
        float[] afloat = new float[Direction.values().length * 2];
        BitSet bitset = new BitSet(3);
        AmbientOcclusionFace blockmodelrenderer$ambientocclusionface = new AmbientOcclusionFace();
        for (Direction direction : Direction.values()) {
            p_217634_7_.setSeed(p_217634_8_);
            List list = p_217634_2_.getQuads(p_217634_3_, direction, p_217634_7_, modelData);
            if (list.isEmpty() || p_217634_6_ && !Block.func_176225_a(p_217634_3_, (IBlockReader)p_217634_1_, p_217634_4_, direction)) continue;
            this.func_217630_a(p_217634_1_, p_217634_3_, p_217634_4_, p_217634_5_, list, afloat, bitset, blockmodelrenderer$ambientocclusionface);
            flag = true;
        }
        p_217634_7_.setSeed(p_217634_8_);
        List list1 = p_217634_2_.getQuads(p_217634_3_, null, p_217634_7_, modelData);
        if (!list1.isEmpty()) {
            this.func_217630_a(p_217634_1_, p_217634_3_, p_217634_4_, p_217634_5_, list1, afloat, bitset, blockmodelrenderer$ambientocclusionface);
            flag = true;
        }
        return flag;
    }

    @Deprecated
    public boolean func_217635_c(IEnviromentBlockReader p_217635_1_, IBakedModel p_217635_2_, BlockState p_217635_3_, BlockPos p_217635_4_, BufferBuilder p_217635_5_, boolean p_217635_6_, Random p_217635_7_, long p_217635_8_) {
        return this.renderModelFlat(p_217635_1_, p_217635_2_, p_217635_3_, p_217635_4_, p_217635_5_, p_217635_6_, p_217635_7_, p_217635_8_, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModelFlat(IEnviromentBlockReader p_217635_1_, IBakedModel p_217635_2_, BlockState p_217635_3_, BlockPos p_217635_4_, BufferBuilder p_217635_5_, boolean p_217635_6_, Random p_217635_7_, long p_217635_8_, IModelData modelData) {
        boolean flag = false;
        BitSet bitset = new BitSet(3);
        for (Direction direction : Direction.values()) {
            p_217635_7_.setSeed(p_217635_8_);
            List list = p_217635_2_.getQuads(p_217635_3_, direction, p_217635_7_, modelData);
            if (list.isEmpty() || p_217635_6_ && !Block.func_176225_a(p_217635_3_, (IBlockReader)p_217635_1_, p_217635_4_, direction)) continue;
            int i = p_217635_3_.func_215684_a(p_217635_1_, p_217635_4_.func_177972_a(direction));
            this.func_217636_a(p_217635_1_, p_217635_3_, p_217635_4_, i, false, p_217635_5_, list, bitset);
            flag = true;
        }
        p_217635_7_.setSeed(p_217635_8_);
        List list1 = p_217635_2_.getQuads(p_217635_3_, null, p_217635_7_, modelData);
        if (!list1.isEmpty()) {
            this.func_217636_a(p_217635_1_, p_217635_3_, p_217635_4_, -1, true, p_217635_5_, list1, bitset);
            flag = true;
        }
        return flag;
    }

    private void func_217630_a(IEnviromentBlockReader p_217630_1_, BlockState p_217630_2_, BlockPos p_217630_3_, BufferBuilder p_217630_4_, List<BakedQuad> p_217630_5_, float[] p_217630_6_, BitSet p_217630_7_, AmbientOcclusionFace p_217630_8_) {
        Vec3d vec3d = p_217630_2_.func_191059_e((IBlockReader)p_217630_1_, p_217630_3_);
        double d0 = (double)p_217630_3_.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)p_217630_3_.func_177956_o() + vec3d.field_72448_b;
        double d2 = (double)p_217630_3_.func_177952_p() + vec3d.field_72449_c;
        int j = p_217630_5_.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = p_217630_5_.get(i);
            this.func_217633_a(p_217630_1_, p_217630_2_, p_217630_3_, bakedquad.func_178209_a(), bakedquad.func_178210_d(), p_217630_6_, p_217630_7_);
            p_217630_8_.func_217629_a(p_217630_1_, p_217630_2_, p_217630_3_, bakedquad.func_178210_d(), p_217630_6_, p_217630_7_);
            p_217630_4_.func_178981_a(bakedquad.func_178209_a());
            p_217630_4_.func_178962_a(p_217630_8_.field_178207_c[0], p_217630_8_.field_178207_c[1], p_217630_8_.field_178207_c[2], p_217630_8_.field_178207_c[3]);
            if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((Direction)bakedquad.func_178210_d());
                float[] fArray = p_217630_8_.field_178206_b;
                fArray[0] = fArray[0] * diffuse;
                float[] fArray2 = p_217630_8_.field_178206_b;
                fArray2[1] = fArray2[1] * diffuse;
                float[] fArray3 = p_217630_8_.field_178206_b;
                fArray3[2] = fArray3[2] * diffuse;
                float[] fArray4 = p_217630_8_.field_178206_b;
                fArray4[3] = fArray4[3] * diffuse;
            }
            if (bakedquad.func_178212_b()) {
                int k = this.field_187499_a.func_216860_a(p_217630_2_, p_217630_1_, p_217630_3_, bakedquad.func_178211_c());
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                p_217630_4_.func_178978_a(p_217630_8_.field_178206_b[0] * f, p_217630_8_.field_178206_b[0] * f1, p_217630_8_.field_178206_b[0] * f2, 4);
                p_217630_4_.func_178978_a(p_217630_8_.field_178206_b[1] * f, p_217630_8_.field_178206_b[1] * f1, p_217630_8_.field_178206_b[1] * f2, 3);
                p_217630_4_.func_178978_a(p_217630_8_.field_178206_b[2] * f, p_217630_8_.field_178206_b[2] * f1, p_217630_8_.field_178206_b[2] * f2, 2);
                p_217630_4_.func_178978_a(p_217630_8_.field_178206_b[3] * f, p_217630_8_.field_178206_b[3] * f1, p_217630_8_.field_178206_b[3] * f2, 1);
            } else {
                p_217630_4_.func_178978_a(p_217630_8_.field_178206_b[0], p_217630_8_.field_178206_b[0], p_217630_8_.field_178206_b[0], 4);
                p_217630_4_.func_178978_a(p_217630_8_.field_178206_b[1], p_217630_8_.field_178206_b[1], p_217630_8_.field_178206_b[1], 3);
                p_217630_4_.func_178978_a(p_217630_8_.field_178206_b[2], p_217630_8_.field_178206_b[2], p_217630_8_.field_178206_b[2], 2);
                p_217630_4_.func_178978_a(p_217630_8_.field_178206_b[3], p_217630_8_.field_178206_b[3], p_217630_8_.field_178206_b[3], 1);
            }
            p_217630_4_.func_178987_a(d0, d1, d2);
        }
    }

    private void func_217633_a(IEnviromentBlockReader p_217633_1_, BlockState p_217633_2_, BlockPos p_217633_3_, int[] p_217633_4_, Direction p_217633_5_, @Nullable float[] p_217633_6_, BitSet p_217633_7_) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(p_217633_4_[i * 7]);
            float f7 = Float.intBitsToFloat(p_217633_4_[i * 7 + 1]);
            float f8 = Float.intBitsToFloat(p_217633_4_[i * 7 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (p_217633_6_ != null) {
            p_217633_6_[Direction.WEST.func_176745_a()] = f;
            p_217633_6_[Direction.EAST.func_176745_a()] = f3;
            p_217633_6_[Direction.DOWN.func_176745_a()] = f1;
            p_217633_6_[Direction.UP.func_176745_a()] = f4;
            p_217633_6_[Direction.NORTH.func_176745_a()] = f2;
            p_217633_6_[Direction.SOUTH.func_176745_a()] = f5;
            int j = Direction.values().length;
            p_217633_6_[Direction.WEST.func_176745_a() + j] = 1.0f - f;
            p_217633_6_[Direction.EAST.func_176745_a() + j] = 1.0f - f3;
            p_217633_6_[Direction.DOWN.func_176745_a() + j] = 1.0f - f1;
            p_217633_6_[Direction.UP.func_176745_a() + j] = 1.0f - f4;
            p_217633_6_[Direction.NORTH.func_176745_a() + j] = 1.0f - f2;
            p_217633_6_[Direction.SOUTH.func_176745_a() + j] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (p_217633_5_) {
            case DOWN: {
                p_217633_7_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_217633_7_.set(0, f1 == f4 && (f1 < 1.0E-4f || p_217633_2_.func_224756_o((IBlockReader)p_217633_1_, p_217633_3_)));
                break;
            }
            case UP: {
                p_217633_7_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_217633_7_.set(0, f1 == f4 && (f4 > 0.9999f || p_217633_2_.func_224756_o((IBlockReader)p_217633_1_, p_217633_3_)));
                break;
            }
            case NORTH: {
                p_217633_7_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_217633_7_.set(0, f2 == f5 && (f2 < 1.0E-4f || p_217633_2_.func_224756_o((IBlockReader)p_217633_1_, p_217633_3_)));
                break;
            }
            case SOUTH: {
                p_217633_7_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_217633_7_.set(0, f2 == f5 && (f5 > 0.9999f || p_217633_2_.func_224756_o((IBlockReader)p_217633_1_, p_217633_3_)));
                break;
            }
            case WEST: {
                p_217633_7_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_217633_7_.set(0, f == f3 && (f < 1.0E-4f || p_217633_2_.func_224756_o((IBlockReader)p_217633_1_, p_217633_3_)));
                break;
            }
            case EAST: {
                p_217633_7_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_217633_7_.set(0, f == f3 && (f3 > 0.9999f || p_217633_2_.func_224756_o((IBlockReader)p_217633_1_, p_217633_3_)));
            }
        }
    }

    private void func_217636_a(IEnviromentBlockReader p_217636_1_, BlockState p_217636_2_, BlockPos p_217636_3_, int p_217636_4_, boolean p_217636_5_, BufferBuilder p_217636_6_, List<BakedQuad> p_217636_7_, BitSet p_217636_8_) {
        Vec3d vec3d = p_217636_2_.func_191059_e((IBlockReader)p_217636_1_, p_217636_3_);
        double d0 = (double)p_217636_3_.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)p_217636_3_.func_177956_o() + vec3d.field_72448_b;
        double d2 = (double)p_217636_3_.func_177952_p() + vec3d.field_72449_c;
        int j = p_217636_7_.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = p_217636_7_.get(i);
            if (p_217636_5_) {
                this.func_217633_a(p_217636_1_, p_217636_2_, p_217636_3_, bakedquad.func_178209_a(), bakedquad.func_178210_d(), null, p_217636_8_);
                BlockPos blockpos = p_217636_8_.get(0) ? p_217636_3_.func_177972_a(bakedquad.func_178210_d()) : p_217636_3_;
                p_217636_4_ = p_217636_2_.func_215684_a(p_217636_1_, blockpos);
            }
            p_217636_6_.func_178981_a(bakedquad.func_178209_a());
            p_217636_6_.func_178962_a(p_217636_4_, p_217636_4_, p_217636_4_, p_217636_4_);
            if (bakedquad.func_178212_b()) {
                int k = this.field_187499_a.func_216860_a(p_217636_2_, p_217636_1_, p_217636_3_, bakedquad.func_178211_c());
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                if (bakedquad.shouldApplyDiffuseLighting()) {
                    float diffuse = LightUtil.diffuseLight((Direction)bakedquad.func_178210_d());
                    f *= diffuse;
                    f1 *= diffuse;
                    f2 *= diffuse;
                }
                p_217636_6_.func_178978_a(f, f1, f2, 4);
                p_217636_6_.func_178978_a(f, f1, f2, 3);
                p_217636_6_.func_178978_a(f, f1, f2, 2);
                p_217636_6_.func_178978_a(f, f1, f2, 1);
            } else if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((Direction)bakedquad.func_178210_d());
                p_217636_6_.func_178978_a(diffuse, diffuse, diffuse, 4);
                p_217636_6_.func_178978_a(diffuse, diffuse, diffuse, 3);
                p_217636_6_.func_178978_a(diffuse, diffuse, diffuse, 2);
                p_217636_6_.func_178978_a(diffuse, diffuse, diffuse, 1);
            }
            p_217636_6_.func_178987_a(d0, d1, d2);
        }
    }

    public void func_178262_a(IBakedModel bakedModel, float brightness, float red, float green, float blue) {
        this.func_187495_a(null, bakedModel, brightness, red, green, blue);
    }

    public void func_187495_a(@Nullable BlockState state, IBakedModel modelIn, float brightness, float red, float green, float blue) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            this.func_178264_a(brightness, red, green, blue, modelIn.func_200117_a(state, direction, random));
        }
        random.setSeed(42L);
        this.func_178264_a(brightness, red, green, blue, modelIn.func_200117_a(state, null, random));
    }

    public void func_178266_a(IBakedModel model, BlockState state, float brightness, boolean glDisabled) {
        GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        int i = this.field_187499_a.func_216860_a(state, null, null, 0);
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        if (!glDisabled) {
            GlStateManager.color4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        }
        this.func_187495_a(state, model, brightness, f, f1, f2);
    }

    private void func_178264_a(float brightness, float red, float green, float blue, List<BakedQuad> listQuads) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = listQuads.get(i);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            bufferbuilder.func_178981_a(bakedquad.func_178209_a());
            if (bakedquad.func_178212_b()) {
                bufferbuilder.func_178990_f(red * brightness, green * brightness, blue * brightness);
            } else {
                bufferbuilder.func_178990_f(brightness, brightness, brightness);
            }
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            bufferbuilder.func_178975_e(vec3i.func_177958_n(), vec3i.func_177956_o(), vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    public static void func_211847_a() {
        field_210267_b.get().func_222895_a();
    }

    public static void func_210266_a() {
        field_210267_b.get().func_222897_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum VertexTranslations {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int field_178191_g;
        private final int field_178200_h;
        private final int field_178201_i;
        private final int field_178198_j;
        private static final VertexTranslations[] field_178199_k;

        private VertexTranslations(int vert0In, int vert1In, int vert2In, int vert3In) {
            this.field_178191_g = vert0In;
            this.field_178200_h = vert1In;
            this.field_178201_i = vert2In;
            this.field_178198_j = vert3In;
        }

        public static VertexTranslations func_178184_a(Direction facingIn) {
            return field_178199_k[facingIn.func_176745_a()];
        }

        static {
            field_178199_k = (VertexTranslations[])Util.func_200696_a((Object)new VertexTranslations[6], p_209261_0_ -> {
                p_209261_0_[Direction.DOWN.func_176745_a()] = DOWN;
                p_209261_0_[Direction.UP.func_176745_a()] = UP;
                p_209261_0_[Direction.NORTH.func_176745_a()] = NORTH;
                p_209261_0_[Direction.SOUTH.func_176745_a()] = SOUTH;
                p_209261_0_[Direction.WEST.func_176745_a()] = WEST;
                p_209261_0_[Direction.EAST.func_176745_a()] = EAST;
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Orientation {
        DOWN(Direction.DOWN, false),
        UP(Direction.UP, false),
        NORTH(Direction.NORTH, false),
        SOUTH(Direction.SOUTH, false),
        WEST(Direction.WEST, false),
        EAST(Direction.EAST, false),
        FLIP_DOWN(Direction.DOWN, true),
        FLIP_UP(Direction.UP, true),
        FLIP_NORTH(Direction.NORTH, true),
        FLIP_SOUTH(Direction.SOUTH, true),
        FLIP_WEST(Direction.WEST, true),
        FLIP_EAST(Direction.EAST, true);

        private final int field_178229_m;

        private Orientation(Direction facingIn, boolean flip) {
            this.field_178229_m = facingIn.func_176745_a() + (flip ? Direction.values().length : 0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum NeighborInfo {
        DOWN(new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}, 0.5f, true, new Orientation[]{Orientation.FLIP_WEST, Orientation.SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_WEST, Orientation.NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.SOUTH}),
        UP(new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, 1.0f, true, new Orientation[]{Orientation.EAST, Orientation.SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.SOUTH}, new Orientation[]{Orientation.EAST, Orientation.NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.SOUTH}),
        NORTH(new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST}),
        SOUTH(new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.UP, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.DOWN, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.DOWN, Orientation.EAST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.UP, Orientation.EAST}),
        WEST(new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new Orientation[]{Orientation.UP, Orientation.SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.SOUTH}, new Orientation[]{Orientation.UP, Orientation.NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.SOUTH}),
        EAST(new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new Orientation[]{Orientation.FLIP_DOWN, Orientation.SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_DOWN, Orientation.NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.SOUTH});

        private final Direction[] field_178276_g;
        private final boolean field_178289_i;
        private final Orientation[] field_178286_j;
        private final Orientation[] field_178287_k;
        private final Orientation[] field_178284_l;
        private final Orientation[] field_178285_m;
        private static final NeighborInfo[] field_178282_n;

        private NeighborInfo(Direction[] cornersIn, float brightness, boolean doNonCubicWeightIn, Orientation[] vert0WeightsIn, Orientation[] vert1WeightsIn, Orientation[] vert2WeightsIn, Orientation[] vert3WeightsIn) {
            this.field_178276_g = cornersIn;
            this.field_178289_i = doNonCubicWeightIn;
            this.field_178286_j = vert0WeightsIn;
            this.field_178287_k = vert1WeightsIn;
            this.field_178284_l = vert2WeightsIn;
            this.field_178285_m = vert3WeightsIn;
        }

        public static NeighborInfo func_178273_a(Direction facing) {
            return field_178282_n[facing.func_176745_a()];
        }

        static {
            field_178282_n = (NeighborInfo[])Util.func_200696_a((Object)new NeighborInfo[6], p_209260_0_ -> {
                p_209260_0_[Direction.DOWN.func_176745_a()] = DOWN;
                p_209260_0_[Direction.UP.func_176745_a()] = UP;
                p_209260_0_[Direction.NORTH.func_176745_a()] = NORTH;
                p_209260_0_[Direction.SOUTH.func_176745_a()] = SOUTH;
                p_209260_0_[Direction.WEST.func_176745_a()] = WEST;
                p_209260_0_[Direction.EAST.func_176745_a()] = EAST;
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Cache {
        private boolean field_222898_a;
        private final Long2IntLinkedOpenHashMap field_222899_b = (Long2IntLinkedOpenHashMap)Util.func_199748_a(() -> {
            Long2IntLinkedOpenHashMap long2intlinkedopenhashmap = new Long2IntLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_rehash_1_) {
                }
            };
            long2intlinkedopenhashmap.defaultReturnValue(Integer.MAX_VALUE);
            return long2intlinkedopenhashmap;
        });
        private final Long2FloatLinkedOpenHashMap field_222900_c = (Long2FloatLinkedOpenHashMap)Util.func_199748_a(() -> {
            Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = new Long2FloatLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_rehash_1_) {
                }
            };
            long2floatlinkedopenhashmap.defaultReturnValue(Float.NaN);
            return long2floatlinkedopenhashmap;
        });

        private Cache() {
        }

        public void func_222895_a() {
            this.field_222898_a = true;
        }

        public void func_222897_b() {
            this.field_222898_a = false;
            this.field_222899_b.clear();
            this.field_222900_c.clear();
        }

        public int func_222893_a(BlockState p_222893_1_, IEnviromentBlockReader p_222893_2_, BlockPos p_222893_3_) {
            int j;
            long i = p_222893_3_.func_218275_a();
            if (this.field_222898_a && (j = this.field_222899_b.get(i)) != Integer.MAX_VALUE) {
                return j;
            }
            int k = p_222893_1_.func_215684_a(p_222893_2_, p_222893_3_);
            if (this.field_222898_a) {
                if (this.field_222899_b.size() == 100) {
                    this.field_222899_b.removeFirstInt();
                }
                this.field_222899_b.put(i, k);
            }
            return k;
        }

        public float func_222896_b(BlockState p_222896_1_, IEnviromentBlockReader p_222896_2_, BlockPos p_222896_3_) {
            float f;
            long i = p_222896_3_.func_218275_a();
            if (this.field_222898_a && !Float.isNaN(f = this.field_222900_c.get(i))) {
                return f;
            }
            float f1 = p_222896_1_.func_215703_d((IBlockReader)p_222896_2_, p_222896_3_);
            if (this.field_222898_a) {
                if (this.field_222900_c.size() == 100) {
                    this.field_222900_c.removeFirstFloat();
                }
                this.field_222900_c.put(i, f1);
            }
            return f1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class AmbientOcclusionFace {
        private final float[] field_178206_b = new float[4];
        private final int[] field_178207_c = new int[4];

        AmbientOcclusionFace() {
        }

        public void func_217629_a(IEnviromentBlockReader reader, BlockState state, BlockPos pos, Direction dir, float[] p_217629_5_, BitSet bits) {
            int l1;
            float f7;
            int k1;
            float f6;
            int j1;
            float f5;
            int i1;
            float f4;
            boolean flag3;
            BlockPos blockpos = bits.get(0) ? pos.func_177972_a(dir) : pos;
            NeighborInfo blockmodelrenderer$neighborinfo = NeighborInfo.func_178273_a(dir);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            Cache blockmodelrenderer$cache = (Cache)field_210267_b.get();
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[0]);
            BlockState blockstate = reader.func_180495_p((BlockPos)blockpos$mutableblockpos);
            int i = blockmodelrenderer$cache.func_222893_a(blockstate, reader, (BlockPos)blockpos$mutableblockpos);
            float f = blockmodelrenderer$cache.func_222896_b(blockstate, reader, (BlockPos)blockpos$mutableblockpos);
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[1]);
            BlockState blockstate1 = reader.func_180495_p((BlockPos)blockpos$mutableblockpos);
            int j = blockmodelrenderer$cache.func_222893_a(blockstate1, reader, (BlockPos)blockpos$mutableblockpos);
            float f1 = blockmodelrenderer$cache.func_222896_b(blockstate1, reader, (BlockPos)blockpos$mutableblockpos);
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[2]);
            BlockState blockstate2 = reader.func_180495_p((BlockPos)blockpos$mutableblockpos);
            int k = blockmodelrenderer$cache.func_222893_a(blockstate2, reader, (BlockPos)blockpos$mutableblockpos);
            float f2 = blockmodelrenderer$cache.func_222896_b(blockstate2, reader, (BlockPos)blockpos$mutableblockpos);
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[3]);
            BlockState blockstate3 = reader.func_180495_p((BlockPos)blockpos$mutableblockpos);
            int l = blockmodelrenderer$cache.func_222893_a(blockstate3, reader, (BlockPos)blockpos$mutableblockpos);
            float f3 = blockmodelrenderer$cache.func_222896_b(blockstate3, reader, (BlockPos)blockpos$mutableblockpos);
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[0]).func_189536_c(dir);
            boolean flag = reader.func_180495_p((BlockPos)blockpos$mutableblockpos).func_200016_a((IBlockReader)reader, (BlockPos)blockpos$mutableblockpos) == 0;
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[1]).func_189536_c(dir);
            boolean flag1 = reader.func_180495_p((BlockPos)blockpos$mutableblockpos).func_200016_a((IBlockReader)reader, (BlockPos)blockpos$mutableblockpos) == 0;
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[2]).func_189536_c(dir);
            boolean flag2 = reader.func_180495_p((BlockPos)blockpos$mutableblockpos).func_200016_a((IBlockReader)reader, (BlockPos)blockpos$mutableblockpos) == 0;
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[3]).func_189536_c(dir);
            boolean bl = flag3 = reader.func_180495_p((BlockPos)blockpos$mutableblockpos).func_200016_a((IBlockReader)reader, (BlockPos)blockpos$mutableblockpos) == 0;
            if (!flag2 && !flag) {
                f4 = f;
                i1 = i;
            } else {
                blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[0]).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[2]);
                BlockState blockstate4 = reader.func_180495_p((BlockPos)blockpos$mutableblockpos);
                f4 = blockmodelrenderer$cache.func_222896_b(blockstate4, reader, (BlockPos)blockpos$mutableblockpos);
                i1 = blockmodelrenderer$cache.func_222893_a(blockstate4, reader, (BlockPos)blockpos$mutableblockpos);
            }
            if (!flag3 && !flag) {
                f5 = f;
                j1 = i;
            } else {
                blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[0]).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[3]);
                BlockState blockstate6 = reader.func_180495_p((BlockPos)blockpos$mutableblockpos);
                f5 = blockmodelrenderer$cache.func_222896_b(blockstate6, reader, (BlockPos)blockpos$mutableblockpos);
                j1 = blockmodelrenderer$cache.func_222893_a(blockstate6, reader, (BlockPos)blockpos$mutableblockpos);
            }
            if (!flag2 && !flag1) {
                f6 = f;
                k1 = i;
            } else {
                blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[1]).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[2]);
                BlockState blockstate7 = reader.func_180495_p((BlockPos)blockpos$mutableblockpos);
                f6 = blockmodelrenderer$cache.func_222896_b(blockstate7, reader, (BlockPos)blockpos$mutableblockpos);
                k1 = blockmodelrenderer$cache.func_222893_a(blockstate7, reader, (BlockPos)blockpos$mutableblockpos);
            }
            if (!flag3 && !flag1) {
                f7 = f;
                l1 = i;
            } else {
                blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[1]).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[3]);
                BlockState blockstate8 = reader.func_180495_p((BlockPos)blockpos$mutableblockpos);
                f7 = blockmodelrenderer$cache.func_222896_b(blockstate8, reader, (BlockPos)blockpos$mutableblockpos);
                l1 = blockmodelrenderer$cache.func_222893_a(blockstate8, reader, (BlockPos)blockpos$mutableblockpos);
            }
            int i3 = blockmodelrenderer$cache.func_222893_a(state, reader, pos);
            blockpos$mutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(dir);
            BlockState blockstate5 = reader.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (bits.get(0) || !blockstate5.func_200015_d((IBlockReader)reader, (BlockPos)blockpos$mutableblockpos)) {
                i3 = blockmodelrenderer$cache.func_222893_a(blockstate5, reader, (BlockPos)blockpos$mutableblockpos);
            }
            float f8 = bits.get(0) ? blockmodelrenderer$cache.func_222896_b(reader.func_180495_p(blockpos), reader, blockpos) : blockmodelrenderer$cache.func_222896_b(reader.func_180495_p(pos), reader, pos);
            VertexTranslations blockmodelrenderer$vertextranslations = VertexTranslations.func_178184_a(dir);
            if (bits.get(1) && blockmodelrenderer$neighborinfo.field_178289_i) {
                float f29 = (f3 + f + f5 + f8) * 0.25f;
                float f30 = (f2 + f + f4 + f8) * 0.25f;
                float f31 = (f2 + f1 + f6 + f8) * 0.25f;
                float f32 = (f3 + f1 + f7 + f8) * 0.25f;
                float f13 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178286_j[0].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178286_j[1].field_178229_m];
                float f14 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178286_j[2].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178286_j[3].field_178229_m];
                float f15 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178286_j[4].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178286_j[5].field_178229_m];
                float f16 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178286_j[6].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178286_j[7].field_178229_m];
                float f17 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178287_k[0].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178287_k[1].field_178229_m];
                float f18 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178287_k[2].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178287_k[3].field_178229_m];
                float f19 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178287_k[4].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178287_k[5].field_178229_m];
                float f20 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178287_k[6].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178287_k[7].field_178229_m];
                float f21 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178284_l[0].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178284_l[1].field_178229_m];
                float f22 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178284_l[2].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178284_l[3].field_178229_m];
                float f23 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178284_l[4].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178284_l[5].field_178229_m];
                float f24 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178284_l[6].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178284_l[7].field_178229_m];
                float f25 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178285_m[0].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178285_m[1].field_178229_m];
                float f26 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178285_m[2].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178285_m[3].field_178229_m];
                float f27 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178285_m[4].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178285_m[5].field_178229_m];
                float f28 = p_217629_5_[blockmodelrenderer$neighborinfo.field_178285_m[6].field_178229_m] * p_217629_5_[blockmodelrenderer$neighborinfo.field_178285_m[7].field_178229_m];
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = f29 * f13 + f30 * f14 + f31 * f15 + f32 * f16;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = f29 * f17 + f30 * f18 + f31 * f19 + f32 * f20;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = f29 * f21 + f30 * f22 + f31 * f23 + f32 * f24;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = f29 * f25 + f30 * f26 + f31 * f27 + f32 * f28;
                int i2 = this.func_147778_a(l, i, j1, i3);
                int j2 = this.func_147778_a(k, i, i1, i3);
                int k2 = this.func_147778_a(k, j, k1, i3);
                int l2 = this.func_147778_a(l, j, l1, i3);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = this.func_178203_a(i2, j2, k2, l2, f13, f14, f15, f16);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = this.func_178203_a(i2, j2, k2, l2, f17, f18, f19, f20);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = this.func_178203_a(i2, j2, k2, l2, f21, f22, f23, f24);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = this.func_178203_a(i2, j2, k2, l2, f25, f26, f27, f28);
            } else {
                float f9 = (f3 + f + f5 + f8) * 0.25f;
                float f10 = (f2 + f + f4 + f8) * 0.25f;
                float f11 = (f2 + f1 + f6 + f8) * 0.25f;
                float f12 = (f3 + f1 + f7 + f8) * 0.25f;
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = this.func_147778_a(l, i, j1, i3);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = this.func_147778_a(k, i, i1, i3);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = this.func_147778_a(k, j, k1, i3);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = this.func_147778_a(l, j, l1, i3);
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = f9;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = f10;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = f11;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = f12;
            }
        }

        private int func_147778_a(int br1, int br2, int br3, int br4) {
            if (br1 == 0) {
                br1 = br4;
            }
            if (br2 == 0) {
                br2 = br4;
            }
            if (br3 == 0) {
                br3 = br4;
            }
            return br1 + br2 + br3 + br4 >> 2 & 0xFF00FF;
        }

        private int func_178203_a(int b1, int b2, int b3, int b4, float w1, float w2, float w3, float w4) {
            int i = (int)((float)(b1 >> 16 & 0xFF) * w1 + (float)(b2 >> 16 & 0xFF) * w2 + (float)(b3 >> 16 & 0xFF) * w3 + (float)(b4 >> 16 & 0xFF) * w4) & 0xFF;
            int j = (int)((float)(b1 & 0xFF) * w1 + (float)(b2 & 0xFF) * w2 + (float)(b3 & 0xFF) * w3 + (float)(b4 & 0xFF) * w4) & 0xFF;
            return i << 16 | j;
        }
    }
}

