/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgespi.language;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.MavenVersionAdapter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;

public interface IModInfo {
    public static final VersionRange UNBOUNDED = MavenVersionAdapter.createFromVersionSpec("");

    public IModFileInfo getOwningFile();

    public String getModId();

    public String getDisplayName();

    public String getDescription();

    public ArtifactVersion getVersion();

    public List<ModVersion> getDependencies();

    public UnmodifiableConfig getModConfig();

    public String getNamespace();

    public Map<String, Object> getModProperties();

    public URL getUpdateURL();

    public static class ModVersion {
        private IModInfo owner;
        private final String modId;
        private final VersionRange versionRange;
        private final boolean mandatory;
        private final Ordering ordering;
        private final DependencySide side;

        public ModVersion(IModInfo owner, UnmodifiableConfig config) {
            this.owner = owner;
            this.modId = (String)config.get("modId");
            this.versionRange = config.getOptional("versionRange").map(String.class::cast).map(MavenVersionAdapter::createFromVersionSpec).orElse(UNBOUNDED);
            this.mandatory = (Boolean)config.get("mandatory");
            this.ordering = config.getOptional("ordering").map(String.class::cast).map(Ordering::valueOf).orElse(Ordering.NONE);
            this.side = config.getOptional("side").map(String.class::cast).map(DependencySide::valueOf).orElse(DependencySide.BOTH);
        }

        public String getModId() {
            return this.modId;
        }

        public VersionRange getVersionRange() {
            return this.versionRange;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public Ordering getOrdering() {
            return this.ordering;
        }

        public DependencySide getSide() {
            return this.side;
        }

        public void setOwner(IModInfo owner) {
            this.owner = owner;
        }

        public IModInfo getOwner() {
            return this.owner;
        }
    }

    public static enum DependencySide {
        CLIENT(Dist.CLIENT),
        SERVER(Dist.DEDICATED_SERVER),
        BOTH(Dist.values());

        private final Dist[] dist;

        private DependencySide(Dist ... dist) {
            this.dist = dist;
        }

        public boolean isCorrectSide() {
            return this == BOTH || Environment.get().getDist().equals((Object)this.dist[0]);
        }
    }

    public static enum Ordering {
        BEFORE,
        AFTER,
        NONE;

    }
}

