/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ILootGenerator;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.functions.ILootFunction;

public class TagLootEntry
extends StandaloneLootEntry {
    private final Tag<Item> field_216180_c;
    private final boolean field_216181_h;

    private TagLootEntry(Tag<Item> tag, boolean bl, int n, int n2, ILootCondition[] iLootConditionArray, ILootFunction[] iLootFunctionArray) {
        super(n, n2, iLootConditionArray, iLootFunctionArray);
        this.field_216180_c = tag;
        this.field_216181_h = bl;
    }

    @Override
    public void func_216154_a(Consumer<ItemStack> consumer, LootContext lootContext) {
        this.field_216180_c.func_199885_a().forEach(item -> consumer.accept(new ItemStack((IItemProvider)item)));
    }

    private boolean func_216179_a(LootContext lootContext, Consumer<ILootGenerator> consumer) {
        if (this.func_216141_a(lootContext)) {
            for (final Item item : this.field_216180_c.func_199885_a()) {
                consumer.accept(new StandaloneLootEntry.Generator(){

                    @Override
                    public void func_216188_a(Consumer<ItemStack> consumer, LootContext lootContext) {
                        consumer.accept(new ItemStack(item));
                    }
                });
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean expand(LootContext lootContext, Consumer<ILootGenerator> consumer) {
        if (this.field_216181_h) {
            return this.func_216179_a(lootContext, consumer);
        }
        return super.expand(lootContext, consumer);
    }

    public static StandaloneLootEntry.Builder<?> func_216176_b(Tag<Item> tag) {
        return TagLootEntry.func_216156_a((n, n2, iLootConditionArray, iLootFunctionArray) -> new TagLootEntry(tag, true, n, n2, iLootConditionArray, iLootFunctionArray));
    }

    public static class Serializer
    extends StandaloneLootEntry.Serializer<TagLootEntry> {
        public Serializer() {
            super(new ResourceLocation("tag"), TagLootEntry.class);
        }

        @Override
        public void func_212830_a_(JsonObject jsonObject, TagLootEntry tagLootEntry, JsonSerializationContext jsonSerializationContext) {
            super.func_212830_a_(jsonObject, tagLootEntry, jsonSerializationContext);
            jsonObject.addProperty("name", tagLootEntry.field_216180_c.func_199886_b().toString());
            jsonObject.addProperty("expand", Boolean.valueOf(tagLootEntry.field_216181_h));
        }

        @Override
        protected TagLootEntry func_212829_b_(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, int n, int n2, ILootCondition[] iLootConditionArray, ILootFunction[] iLootFunctionArray) {
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "name"));
            Tag<Item> \u26032 = ItemTags.func_199903_a().func_199910_a(resourceLocation);
            if (\u26032 == null) {
                throw new JsonParseException("Can't find tag: " + resourceLocation);
            }
            boolean \u26033 = JSONUtils.func_151212_i(jsonObject, "expand");
            return new TagLootEntry(\u26032, \u26033, n, n2, iLootConditionArray, iLootFunctionArray);
        }

        @Override
        protected /* synthetic */ StandaloneLootEntry func_212829_b_(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, int n, int n2, ILootCondition[] iLootConditionArray, ILootFunction[] iLootFunctionArray) {
            return this.func_212829_b_(jsonObject, jsonDeserializationContext, n, n2, iLootConditionArray, iLootFunctionArray);
        }
    }
}

