/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.lighting;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.SectionDistanceGraph;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.LightDataMap;
import net.minecraft.world.lighting.LightEngine;

public abstract class SectionLightStorage<M extends LightDataMap<M>>
extends SectionDistanceGraph {
    protected static final NibbleArray field_215534_a = new NibbleArray();
    private static final Direction[] field_215544_k = Direction.values();
    private final LightType field_215545_l;
    private final IChunkLightProvider field_215546_m;
    protected final LongSet field_215535_b = new LongOpenHashSet();
    protected final LongSet field_215536_c = new LongOpenHashSet();
    protected final LongSet field_215537_d = new LongOpenHashSet();
    protected volatile M field_215538_e;
    protected final M field_215539_f;
    protected final LongSet field_215540_g = new LongOpenHashSet();
    protected final LongSet field_215541_h = new LongOpenHashSet();
    protected final Long2ObjectMap<NibbleArray> field_215542_i = new Long2ObjectOpenHashMap();
    private final LongSet field_223114_n = new LongOpenHashSet();
    private final LongSet field_215547_n = new LongOpenHashSet();
    protected volatile boolean field_215543_j;

    protected SectionLightStorage(LightType lightType, IChunkLightProvider iChunkLightProvider, M m) {
        super(3, 16, 256);
        this.field_215545_l = lightType;
        this.field_215546_m = iChunkLightProvider;
        this.field_215539_f = m;
        this.field_215538_e = ((LightDataMap)m).func_212858_b_();
        ((LightDataMap)this.field_215538_e).func_215644_d();
    }

    protected boolean func_215518_g(long l) {
        return this.func_215520_a(l, true) != null;
    }

    @Nullable
    protected NibbleArray func_215520_a(long l, boolean bl) {
        return this.func_215531_a(bl ? this.field_215539_f : this.field_215538_e, l);
    }

    @Nullable
    protected NibbleArray func_215531_a(M m, long l) {
        return ((LightDataMap)m).func_215638_c(l);
    }

    @Nullable
    public NibbleArray func_222858_h(long l) {
        NibbleArray nibbleArray = (NibbleArray)this.field_215542_i.get(l);
        if (nibbleArray != null) {
            return nibbleArray;
        }
        return this.func_215520_a(l, false);
    }

    protected abstract int func_215525_d(long var1);

    protected int func_215521_h(long l) {
        \u2603 = SectionPos.func_218162_e(l);
        NibbleArray nibbleArray = this.func_215520_a(\u2603, true);
        return nibbleArray.func_76582_a(SectionPos.func_218171_b(BlockPos.func_218290_b(l)), SectionPos.func_218171_b(BlockPos.func_218274_c(l)), SectionPos.func_218171_b(BlockPos.func_218282_d(l)));
    }

    protected void func_215517_b(long l, int n) {
        long l2 = SectionPos.func_218162_e(l);
        if (this.field_215540_g.add(l2)) {
            ((LightDataMap)this.field_215539_f).func_215641_a(l2);
        }
        NibbleArray \u26032 = this.func_215520_a(l2, true);
        \u26032.func_76581_a(SectionPos.func_218171_b(BlockPos.func_218290_b(l)), SectionPos.func_218171_b(BlockPos.func_218274_c(l)), SectionPos.func_218171_b(BlockPos.func_218282_d(l)), n);
        for (int i = -1; i <= 1; ++i) {
            for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                    this.field_215541_h.add(SectionPos.func_218162_e(BlockPos.func_218291_a(l, \u2603, \u2603, i)));
                }
            }
        }
    }

    @Override
    protected int func_215471_c(long l) {
        if (l == Long.MAX_VALUE) {
            return 2;
        }
        if (this.field_215535_b.contains(l)) {
            return 0;
        }
        if (!this.field_215547_n.contains(l) && ((LightDataMap)this.field_215539_f).func_215642_b(l)) {
            return 1;
        }
        return 2;
    }

    @Override
    protected int func_215516_b(long l) {
        if (this.field_215536_c.contains(l)) {
            return 2;
        }
        if (this.field_215535_b.contains(l) || this.field_215537_d.contains(l)) {
            return 0;
        }
        return 2;
    }

    @Override
    protected void func_215476_a(long l, int n) {
        \u2603 = this.func_215471_c(l);
        if (\u2603 != 0 && n == 0) {
            this.field_215535_b.add(l);
            this.field_215537_d.remove(l);
        }
        if (\u2603 == 0 && n != 0) {
            this.field_215535_b.remove(l);
            this.field_215536_c.remove(l);
        }
        if (\u2603 >= 2 && n != 2) {
            if (this.field_215547_n.contains(l)) {
                this.field_215547_n.remove(l);
            } else {
                ((LightDataMap)this.field_215539_f).func_215640_a(l, this.func_215530_i(l));
                this.field_215540_g.add(l);
                this.func_215524_j(l);
                for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                    for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                        for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                            this.field_215541_h.add(SectionPos.func_218162_e(BlockPos.func_218291_a(l, \u2603, \u2603, \u2603)));
                        }
                    }
                }
            }
        }
        if (\u2603 != 2 && n >= 2) {
            this.field_215547_n.add(l);
        }
        this.field_215543_j = !this.field_215547_n.isEmpty();
    }

    protected NibbleArray func_215530_i(long l) {
        NibbleArray nibbleArray = (NibbleArray)this.field_215542_i.get(l);
        if (nibbleArray != null) {
            return nibbleArray;
        }
        return new NibbleArray();
    }

    protected void func_215528_a(LightEngine<?, ?> lightEngine, long l) {
        int n = SectionPos.func_218142_c(SectionPos.func_218173_b(l));
        \u2603 = SectionPos.func_218142_c(SectionPos.func_218144_c(l));
        \u2603 = SectionPos.func_218142_c(SectionPos.func_218153_d(l));
        for (\u2603 = 0; \u2603 < 16; ++\u2603) {
            for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                    long l2 = BlockPos.func_218276_a(n + \u2603, \u2603 + \u2603, \u2603 + \u2603);
                    lightEngine.func_215479_e(l2);
                }
            }
        }
    }

    protected boolean func_215527_a() {
        return this.field_215543_j;
    }

    protected void func_215522_a(LightEngine<M, ?> lightEngine, boolean bl, boolean bl2) {
        NibbleArray \u26033;
        if (!this.func_215527_a() && this.field_215542_i.isEmpty()) {
            return;
        }
        LongIterator longIterator = this.field_215547_n.iterator();
        while (longIterator.hasNext()) {
            long l = (Long)longIterator.next();
            this.func_215528_a(lightEngine, l);
            NibbleArray \u26032 = (NibbleArray)this.field_215542_i.remove(l);
            \u26033 = ((LightDataMap)this.field_215539_f).func_223130_d(l);
            if (!this.field_223114_n.contains(SectionPos.func_218169_f(l))) continue;
            if (\u26032 != null) {
                this.field_215542_i.put(l, (Object)\u26032);
                continue;
            }
            if (\u26033 == null) continue;
            this.field_215542_i.put(l, (Object)\u26033);
        }
        ((LightDataMap)this.field_215539_f).func_215643_c();
        longIterator = this.field_215547_n.iterator();
        while (longIterator.hasNext()) {
            l = (Long)longIterator.next();
            this.func_215523_k(l);
        }
        this.field_215547_n.clear();
        this.field_215543_j = false;
        for (Long2ObjectMap.Entry \u26034 : this.field_215542_i.long2ObjectEntrySet()) {
            \u26037 = \u26034.getLongKey();
            if (!this.func_215518_g(\u26037)) continue;
            \u26033 = (NibbleArray)\u26034.getValue();
            if (((LightDataMap)this.field_215539_f).func_215638_c(\u26037) == \u26033) continue;
            this.func_215528_a(lightEngine, \u26037);
            ((LightDataMap)this.field_215539_f).func_215640_a(\u26037, \u26033);
            this.field_215540_g.add(\u26037);
        }
        ((LightDataMap)this.field_215539_f).func_215643_c();
        if (!bl2) {
            longIterator = this.field_215542_i.keySet().iterator();
            while (longIterator.hasNext()) {
                \u2603 = (Long)longIterator.next();
                if (!this.func_215518_g(\u2603)) continue;
                int n = SectionPos.func_218142_c(SectionPos.func_218173_b(\u2603));
                \u2603 = SectionPos.func_218142_c(SectionPos.func_218144_c(\u2603));
                \u2603 = SectionPos.func_218142_c(SectionPos.func_218153_d(\u2603));
                for (Direction direction : field_215544_k) {
                    long l = SectionPos.func_218172_a(\u2603, direction);
                    if (this.field_215542_i.containsKey(l) || !this.func_215518_g(l)) continue;
                    for (int i = 0; i < 16; ++i) {
                        for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                            long \u26036;
                            long \u26035;
                            switch (direction) {
                                case DOWN: {
                                    \u26035 = BlockPos.func_218276_a(n + \u2603, \u2603, \u2603 + i);
                                    \u26036 = BlockPos.func_218276_a(n + \u2603, \u2603 - 1, \u2603 + i);
                                    break;
                                }
                                case UP: {
                                    \u26035 = BlockPos.func_218276_a(n + \u2603, \u2603 + 16 - 1, \u2603 + i);
                                    \u26036 = BlockPos.func_218276_a(n + \u2603, \u2603 + 16, \u2603 + i);
                                    break;
                                }
                                case NORTH: {
                                    \u26035 = BlockPos.func_218276_a(n + i, \u2603 + \u2603, \u2603);
                                    \u26036 = BlockPos.func_218276_a(n + i, \u2603 + \u2603, \u2603 - 1);
                                    break;
                                }
                                case SOUTH: {
                                    \u26035 = BlockPos.func_218276_a(n + i, \u2603 + \u2603, \u2603 + 16 - 1);
                                    \u26036 = BlockPos.func_218276_a(n + i, \u2603 + \u2603, \u2603 + 16);
                                    break;
                                }
                                case WEST: {
                                    \u26035 = BlockPos.func_218276_a(n, \u2603 + i, \u2603 + \u2603);
                                    \u26036 = BlockPos.func_218276_a(n - 1, \u2603 + i, \u2603 + \u2603);
                                    break;
                                }
                                default: {
                                    \u26035 = BlockPos.func_218276_a(n + 16 - 1, \u2603 + i, \u2603 + \u2603);
                                    \u26036 = BlockPos.func_218276_a(n + 16, \u2603 + i, \u2603 + \u2603);
                                }
                            }
                            lightEngine.func_215469_a(\u26035, \u26036, lightEngine.func_215480_b(\u26035, \u26036, lightEngine.func_215471_c(\u26035)), false);
                            lightEngine.func_215469_a(\u26036, \u26035, lightEngine.func_215480_b(\u26036, \u26035, lightEngine.func_215471_c(\u26036)), false);
                        }
                    }
                }
            }
        }
        ObjectIterator objectIterator = this.field_215542_i.long2ObjectEntrySet().iterator();
        while (objectIterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectIterator.next();
            long \u26037 = entry.getLongKey();
            if (!this.func_215518_g(\u26037)) continue;
            objectIterator.remove();
        }
    }

    protected void func_215524_j(long l) {
    }

    protected void func_215523_k(long l) {
    }

    protected void func_215526_b(long l, boolean bl) {
    }

    public void func_223113_c(long l, boolean bl) {
        if (bl) {
            this.field_223114_n.add(l);
        } else {
            this.field_223114_n.remove(l);
        }
    }

    protected void func_215529_a(long l, @Nullable NibbleArray nibbleArray) {
        if (nibbleArray != null) {
            this.field_215542_i.put(l, (Object)nibbleArray);
        } else {
            this.field_215542_i.remove(l);
        }
    }

    protected void func_215519_c(long l, boolean bl) {
        \u2603 = this.field_215535_b.contains(l);
        if (!\u2603 && !bl) {
            this.field_215537_d.add(l);
            this.func_215469_a(Long.MAX_VALUE, l, 0, true);
        }
        if (\u2603 && bl) {
            this.field_215536_c.add(l);
            this.func_215469_a(Long.MAX_VALUE, l, 2, false);
        }
    }

    protected void func_215532_c() {
        if (this.func_215481_b()) {
            this.func_215483_b(Integer.MAX_VALUE);
        }
    }

    protected void func_215533_d() {
        Object object;
        if (!this.field_215540_g.isEmpty()) {
            object = ((LightDataMap)this.field_215539_f).func_212858_b_();
            ((LightDataMap)object).func_215644_d();
            this.field_215538_e = object;
            this.field_215540_g.clear();
        }
        if (!this.field_215541_h.isEmpty()) {
            object = this.field_215541_h.iterator();
            while (object.hasNext()) {
                long l = object.nextLong();
                this.field_215546_m.func_217201_a(this.field_215545_l, SectionPos.func_218170_a(l));
            }
            this.field_215541_h.clear();
        }
    }
}

