/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.placement;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.AtHeight64;
import net.minecraft.world.gen.placement.AtSurface;
import net.minecraft.world.gen.placement.AtSurfaceRandomCount;
import net.minecraft.world.gen.placement.AtSurfaceWithChance;
import net.minecraft.world.gen.placement.AtSurfaceWithChanceMultiple;
import net.minecraft.world.gen.placement.AtSurfaceWithExtra;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.CaveEdge;
import net.minecraft.world.gen.placement.CaveEdgeConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.ChanceRange;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.ChorusPlant;
import net.minecraft.world.gen.placement.CountRange;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.DarkOakTreePlacement;
import net.minecraft.world.gen.placement.DepthAverage;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.DungeonRoom;
import net.minecraft.world.gen.placement.DungeonRoomConfig;
import net.minecraft.world.gen.placement.EndGateway;
import net.minecraft.world.gen.placement.EndIsland;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.Height4To32;
import net.minecraft.world.gen.placement.HeightBiasedRange;
import net.minecraft.world.gen.placement.HeightVeryBiasedRange;
import net.minecraft.world.gen.placement.HeightWithChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.IcebergPlacement;
import net.minecraft.world.gen.placement.LakeChanceConfig;
import net.minecraft.world.gen.placement.LakeLava;
import net.minecraft.world.gen.placement.LakeWater;
import net.minecraft.world.gen.placement.NetherFire;
import net.minecraft.world.gen.placement.NetherGlowstone;
import net.minecraft.world.gen.placement.NetherMagma;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Passthrough;
import net.minecraft.world.gen.placement.RandomCountWithRange;
import net.minecraft.world.gen.placement.SurfacePlus32;
import net.minecraft.world.gen.placement.SurfacePlus32WithNoise;
import net.minecraft.world.gen.placement.TopSolid;
import net.minecraft.world.gen.placement.TopSolidOnce;
import net.minecraft.world.gen.placement.TopSolidRange;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.placement.TopSolidWithChance;
import net.minecraft.world.gen.placement.TopSolidWithNoise;
import net.minecraft.world.gen.placement.TopSolidWithNoiseConfig;
import net.minecraft.world.gen.placement.TwiceSurface;
import net.minecraft.world.gen.placement.TwiceSurfaceWithChance;
import net.minecraft.world.gen.placement.TwiceSurfaceWithChanceMultiple;
import net.minecraft.world.gen.placement.TwiceSurfaceWithNoise;
import net.minecraft.world.gen.placement.WithChance;

public abstract class Placement<DC extends IPlacementConfig> {
    public static final Placement<FrequencyConfig> field_215015_a = Placement.func_214999_a("count_heightmap", new AtSurface((Function<Dynamic<?>, ? extends FrequencyConfig>)((Function<Dynamic<?>, FrequencyConfig>)FrequencyConfig::func_214721_a)));
    public static final Placement<FrequencyConfig> field_215016_b = Placement.func_214999_a("count_top_solid", new TopSolid((Function<Dynamic<?>, ? extends FrequencyConfig>)((Function<Dynamic<?>, FrequencyConfig>)FrequencyConfig::func_214721_a)));
    public static final Placement<FrequencyConfig> field_215017_c = Placement.func_214999_a("count_heightmap_32", new SurfacePlus32((Function<Dynamic<?>, ? extends FrequencyConfig>)((Function<Dynamic<?>, FrequencyConfig>)FrequencyConfig::func_214721_a)));
    public static final Placement<FrequencyConfig> field_215018_d = Placement.func_214999_a("count_heightmap_double", new TwiceSurface((Function<Dynamic<?>, ? extends FrequencyConfig>)((Function<Dynamic<?>, FrequencyConfig>)FrequencyConfig::func_214721_a)));
    public static final Placement<FrequencyConfig> field_215019_e = Placement.func_214999_a("count_height_64", new AtHeight64((Function<Dynamic<?>, ? extends FrequencyConfig>)((Function<Dynamic<?>, FrequencyConfig>)FrequencyConfig::func_214721_a)));
    public static final Placement<NoiseDependant> field_215020_f = Placement.func_214999_a("noise_heightmap_32", new SurfacePlus32WithNoise((Function<Dynamic<?>, ? extends NoiseDependant>)((Function<Dynamic<?>, NoiseDependant>)NoiseDependant::func_214734_a)));
    public static final Placement<NoiseDependant> field_215021_g = Placement.func_214999_a("noise_heightmap_double", new TwiceSurfaceWithNoise((Function<Dynamic<?>, ? extends NoiseDependant>)((Function<Dynamic<?>, NoiseDependant>)NoiseDependant::func_214734_a)));
    public static final Placement<NoPlacementConfig> field_215022_h = Placement.func_214999_a("nope", new Passthrough((Function<Dynamic<?>, ? extends NoPlacementConfig>)((Function<Dynamic<?>, NoPlacementConfig>)NoPlacementConfig::func_214735_a)));
    public static final Placement<ChanceConfig> field_215023_i = Placement.func_214999_a("chance_heightmap", new AtSurfaceWithChance((Function<Dynamic<?>, ? extends ChanceConfig>)((Function<Dynamic<?>, ChanceConfig>)ChanceConfig::func_214722_a)));
    public static final Placement<ChanceConfig> field_215024_j = Placement.func_214999_a("chance_heightmap_double", new TwiceSurfaceWithChance((Function<Dynamic<?>, ? extends ChanceConfig>)((Function<Dynamic<?>, ChanceConfig>)ChanceConfig::func_214722_a)));
    public static final Placement<ChanceConfig> field_215025_k = Placement.func_214999_a("chance_passthrough", new WithChance((Function<Dynamic<?>, ? extends ChanceConfig>)((Function<Dynamic<?>, ChanceConfig>)ChanceConfig::func_214722_a)));
    public static final Placement<ChanceConfig> field_215026_l = Placement.func_214999_a("chance_top_solid_heightmap", new TopSolidWithChance((Function<Dynamic<?>, ? extends ChanceConfig>)((Function<Dynamic<?>, ChanceConfig>)ChanceConfig::func_214722_a)));
    public static final Placement<AtSurfaceWithExtraConfig> field_215027_m = Placement.func_214999_a("count_extra_heightmap", new AtSurfaceWithExtra((Function<Dynamic<?>, ? extends AtSurfaceWithExtraConfig>)((Function<Dynamic<?>, AtSurfaceWithExtraConfig>)AtSurfaceWithExtraConfig::func_214723_a)));
    public static final Placement<CountRangeConfig> field_215028_n = Placement.func_214999_a("count_range", new CountRange((Function<Dynamic<?>, ? extends CountRangeConfig>)((Function<Dynamic<?>, CountRangeConfig>)CountRangeConfig::func_214733_a)));
    public static final Placement<CountRangeConfig> field_215029_o = Placement.func_214999_a("count_biased_range", new HeightBiasedRange((Function<Dynamic<?>, ? extends CountRangeConfig>)((Function<Dynamic<?>, CountRangeConfig>)CountRangeConfig::func_214733_a)));
    public static final Placement<CountRangeConfig> field_215030_p = Placement.func_214999_a("count_very_biased_range", new HeightVeryBiasedRange((Function<Dynamic<?>, ? extends CountRangeConfig>)((Function<Dynamic<?>, CountRangeConfig>)CountRangeConfig::func_214733_a)));
    public static final Placement<CountRangeConfig> field_215031_q = Placement.func_214999_a("random_count_range", new RandomCountWithRange((Function<Dynamic<?>, ? extends CountRangeConfig>)((Function<Dynamic<?>, CountRangeConfig>)CountRangeConfig::func_214733_a)));
    public static final Placement<ChanceRangeConfig> field_215032_r = Placement.func_214999_a("chance_range", new ChanceRange((Function<Dynamic<?>, ? extends ChanceRangeConfig>)((Function<Dynamic<?>, ChanceRangeConfig>)ChanceRangeConfig::func_214732_a)));
    public static final Placement<HeightWithChanceConfig> field_215033_s = Placement.func_214999_a("count_chance_heightmap", new AtSurfaceWithChanceMultiple((Function<Dynamic<?>, ? extends HeightWithChanceConfig>)((Function<Dynamic<?>, HeightWithChanceConfig>)HeightWithChanceConfig::func_214724_a)));
    public static final Placement<HeightWithChanceConfig> field_215034_t = Placement.func_214999_a("count_chance_heightmap_double", new TwiceSurfaceWithChanceMultiple((Function<Dynamic<?>, ? extends HeightWithChanceConfig>)((Function<Dynamic<?>, HeightWithChanceConfig>)HeightWithChanceConfig::func_214724_a)));
    public static final Placement<DepthAverageConfig> field_215035_u = Placement.func_214999_a("count_depth_average", new DepthAverage((Function<Dynamic<?>, ? extends DepthAverageConfig>)((Function<Dynamic<?>, DepthAverageConfig>)DepthAverageConfig::func_214729_a)));
    public static final Placement<NoPlacementConfig> field_215036_v = Placement.func_214999_a("top_solid_heightmap", new TopSolidOnce((Function<Dynamic<?>, ? extends NoPlacementConfig>)((Function<Dynamic<?>, NoPlacementConfig>)NoPlacementConfig::func_214735_a)));
    public static final Placement<TopSolidRangeConfig> field_215037_w = Placement.func_214999_a("top_solid_heightmap_range", new TopSolidRange((Function<Dynamic<?>, ? extends TopSolidRangeConfig>)((Function<Dynamic<?>, TopSolidRangeConfig>)TopSolidRangeConfig::func_214725_a)));
    public static final Placement<TopSolidWithNoiseConfig> field_215038_x = Placement.func_214999_a("top_solid_heightmap_noise_biased", new TopSolidWithNoise((Function<Dynamic<?>, ? extends TopSolidWithNoiseConfig>)((Function<Dynamic<?>, TopSolidWithNoiseConfig>)TopSolidWithNoiseConfig::func_214726_a)));
    public static final Placement<CaveEdgeConfig> field_215039_y = Placement.func_214999_a("carving_mask", new CaveEdge((Function<Dynamic<?>, ? extends CaveEdgeConfig>)((Function<Dynamic<?>, CaveEdgeConfig>)CaveEdgeConfig::func_214720_a)));
    public static final Placement<FrequencyConfig> field_215040_z = Placement.func_214999_a("forest_rock", new AtSurfaceRandomCount((Function<Dynamic<?>, ? extends FrequencyConfig>)((Function<Dynamic<?>, FrequencyConfig>)FrequencyConfig::func_214721_a)));
    public static final Placement<FrequencyConfig> field_215002_A = Placement.func_214999_a("hell_fire", new NetherFire((Function<Dynamic<?>, ? extends FrequencyConfig>)((Function<Dynamic<?>, FrequencyConfig>)FrequencyConfig::func_214721_a)));
    public static final Placement<FrequencyConfig> field_215003_B = Placement.func_214999_a("magma", new NetherMagma((Function<Dynamic<?>, ? extends FrequencyConfig>)((Function<Dynamic<?>, FrequencyConfig>)FrequencyConfig::func_214721_a)));
    public static final Placement<NoPlacementConfig> field_215004_C = Placement.func_214999_a("emerald_ore", new Height4To32((Function<Dynamic<?>, ? extends NoPlacementConfig>)((Function<Dynamic<?>, NoPlacementConfig>)NoPlacementConfig::func_214735_a)));
    public static final Placement<LakeChanceConfig> field_215005_D = Placement.func_214999_a("lava_lake", new LakeLava((Function<Dynamic<?>, ? extends LakeChanceConfig>)((Function<Dynamic<?>, LakeChanceConfig>)LakeChanceConfig::func_214730_a)));
    public static final Placement<LakeChanceConfig> field_215006_E = Placement.func_214999_a("water_lake", new LakeWater((Function<Dynamic<?>, ? extends LakeChanceConfig>)((Function<Dynamic<?>, LakeChanceConfig>)LakeChanceConfig::func_214730_a)));
    public static final Placement<DungeonRoomConfig> field_215007_F = Placement.func_214999_a("dungeons", new DungeonRoom((Function<Dynamic<?>, ? extends DungeonRoomConfig>)((Function<Dynamic<?>, DungeonRoomConfig>)DungeonRoomConfig::func_214731_a)));
    public static final Placement<NoPlacementConfig> field_215008_G = Placement.func_214999_a("dark_oak_tree", new DarkOakTreePlacement((Function<Dynamic<?>, ? extends NoPlacementConfig>)((Function<Dynamic<?>, NoPlacementConfig>)NoPlacementConfig::func_214735_a)));
    public static final Placement<ChanceConfig> field_215009_H = Placement.func_214999_a("iceberg", new IcebergPlacement((Function<Dynamic<?>, ? extends ChanceConfig>)((Function<Dynamic<?>, ChanceConfig>)ChanceConfig::func_214722_a)));
    public static final Placement<FrequencyConfig> field_215010_I = Placement.func_214999_a("light_gem_chance", new NetherGlowstone((Function<Dynamic<?>, ? extends FrequencyConfig>)((Function<Dynamic<?>, FrequencyConfig>)FrequencyConfig::func_214721_a)));
    public static final Placement<NoPlacementConfig> field_215011_J = Placement.func_214999_a("end_island", new EndIsland((Function<Dynamic<?>, ? extends NoPlacementConfig>)((Function<Dynamic<?>, NoPlacementConfig>)NoPlacementConfig::func_214735_a)));
    public static final Placement<NoPlacementConfig> field_215012_K = Placement.func_214999_a("chorus_plant", new ChorusPlant((Function<Dynamic<?>, ? extends NoPlacementConfig>)((Function<Dynamic<?>, NoPlacementConfig>)NoPlacementConfig::func_214735_a)));
    public static final Placement<NoPlacementConfig> field_215013_L = Placement.func_214999_a("end_gateway", new EndGateway((Function<Dynamic<?>, ? extends NoPlacementConfig>)((Function<Dynamic<?>, NoPlacementConfig>)NoPlacementConfig::func_214735_a)));
    private final Function<Dynamic<?>, ? extends DC> field_215014_M;

    private static <T extends IPlacementConfig, G extends Placement<T>> G func_214999_a(String string, G g) {
        return (G)Registry.func_218325_a(Registry.field_218380_r, string, g);
    }

    public Placement(Function<Dynamic<?>, ? extends DC> function) {
        this.field_215014_M = function;
    }

    public DC func_215001_a(Dynamic<?> dynamic) {
        return (DC)((IPlacementConfig)this.field_215014_M.apply(dynamic));
    }

    protected <FC extends IFeatureConfig> boolean func_214998_a(IWorld iWorld, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, BlockPos blockPos2, DC DC, ConfiguredFeature<FC> configuredFeature) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.func_212848_a_(iWorld, chunkGenerator, random, DC, blockPos2).forEach(blockPos -> {
            boolean bl = configuredFeature.func_222734_a(iWorld, (ChunkGenerator<GenerationSettings>)chunkGenerator, random, (BlockPos)blockPos);
            atomicBoolean.set(atomicBoolean.get() || bl);
        });
        return atomicBoolean.get();
    }

    public abstract Stream<BlockPos> func_212848_a_(IWorld var1, ChunkGenerator<? extends GenerationSettings> var2, Random var3, DC var4, BlockPos var5);

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }
}

