/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.WoodlandMansionPieces;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class WoodlandMansionStructure
extends Structure<NoFeatureConfig> {
    public WoodlandMansionStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> function) {
        super(function);
    }

    @Override
    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int n, int n2, int n3, int n4) {
        \u2603 = ((GenerationSettings)chunkGenerator.func_201496_a_()).func_202179_i();
        \u2603 = ((GenerationSettings)chunkGenerator.func_201496_a_()).func_211726_q();
        \u2603 = n + \u2603 * n3;
        \u2603 = n2 + \u2603 * n4;
        \u2603 = \u2603 < 0 ? \u2603 - \u2603 + 1 : \u2603;
        \u2603 = \u2603 < 0 ? \u2603 - \u2603 + 1 : \u2603;
        \u2603 = \u2603 / \u2603;
        \u2603 = \u2603 / \u2603;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), \u2603, \u2603, 10387319);
        \u2603 *= \u2603;
        \u2603 *= \u2603;
        return new ChunkPos(\u2603 += (random.nextInt(\u2603 - \u2603) + random.nextInt(\u2603 - \u2603)) / 2, \u2603 += (random.nextInt(\u2603 - \u2603) + random.nextInt(\u2603 - \u2603)) / 2);
    }

    @Override
    public boolean func_202372_a(ChunkGenerator<?> chunkGenerator, Random random, int n, int n2) {
        ChunkPos chunkPos = this.func_211744_a(chunkGenerator, random, n, n2, 0, 0);
        if (n == chunkPos.field_77276_a && n2 == chunkPos.field_77275_b) {
            Set<Biome> set = chunkGenerator.func_202090_b().func_201538_a(n * 16 + 9, n2 * 16 + 9, 32);
            for (Biome biome : set) {
                if (chunkGenerator.func_202094_a(biome, Feature.field_202330_h)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    @Override
    public String func_143025_a() {
        return "Mansion";
    }

    @Override
    public int func_202367_b() {
        return 8;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int n, int n2, Biome biome, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, biome, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_214625_a(ChunkGenerator<?> chunkGenerator, TemplateManager templateManager, int n, int n2, Biome biome) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int \u26032 = 5;
            int \u26033 = 5;
            if (rotation == Rotation.CLOCKWISE_90) {
                \u26032 = -5;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                \u26032 = -5;
                \u26033 = -5;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                \u26033 = -5;
            }
            int \u26034 = (n << 4) + 7;
            int \u26035 = (n2 << 4) + 7;
            int \u26036 = chunkGenerator.func_222531_c(\u26034, \u26035, Heightmap.Type.WORLD_SURFACE_WG);
            int \u26037 = chunkGenerator.func_222531_c(\u26034, \u26035 + \u26033, Heightmap.Type.WORLD_SURFACE_WG);
            int \u26038 = chunkGenerator.func_222531_c(\u26034 + \u26032, \u26035, Heightmap.Type.WORLD_SURFACE_WG);
            int \u26039 = chunkGenerator.func_222531_c(\u26034 + \u26032, \u26035 + \u26033, Heightmap.Type.WORLD_SURFACE_WG);
            int \u260310 = Math.min(Math.min(\u26036, \u26037), Math.min(\u26038, \u26039));
            if (\u260310 < 60) {
                return;
            }
            BlockPos \u260311 = new BlockPos(n * 16 + 8, \u260310 + 1, n2 * 16 + 8);
            LinkedList \u260312 = Lists.newLinkedList();
            WoodlandMansionPieces.func_191152_a(templateManager, \u260311, rotation, \u260312, this.field_214631_d);
            this.field_75075_a.addAll(\u260312);
            this.func_202500_a();
        }

        @Override
        public void func_75068_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            super.func_75068_a(iWorld, random, mutableBoundingBox, chunkPos);
            int n = this.field_75074_b.field_78895_b;
            for (\u2603 = mutableBoundingBox.field_78897_a; \u2603 <= mutableBoundingBox.field_78893_d; ++\u2603) {
                for (\u2603 = mutableBoundingBox.field_78896_c; \u2603 <= mutableBoundingBox.field_78892_f; ++\u2603) {
                    BlockPos blockPos = new BlockPos(\u2603, n, \u2603);
                    if (iWorld.func_175623_d(blockPos) || !this.field_75074_b.func_175898_b(blockPos)) continue;
                    boolean \u26032 = false;
                    for (Object object : this.field_75075_a) {
                        if (!((StructurePiece)object).func_74874_b().func_175898_b(blockPos)) continue;
                        \u26032 = true;
                        break;
                    }
                    if (!\u26032) continue;
                    for (int i = n - 1; i > 1 && (iWorld.func_175623_d((BlockPos)(object = new BlockPos(\u2603, i, \u2603))) || iWorld.func_180495_p((BlockPos)object).func_185904_a().func_76224_d()); --i) {
                        iWorld.func_180501_a((BlockPos)object, Blocks.field_150347_e.func_176223_P(), 2);
                    }
                }
            }
        }
    }
}

