/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldOptimizer {
    private static final Logger field_212219_a = LogManager.getLogger();
    private static final ThreadFactory field_212220_b = new ThreadFactoryBuilder().setDaemon(true).build();
    private final String field_212237_s;
    private final boolean field_219957_d;
    private final SaveHandler field_212221_c;
    private final Thread field_212223_e;
    private final File field_219958_g;
    private volatile boolean field_212224_f = true;
    private volatile boolean field_212225_g;
    private volatile float field_212232_n;
    private volatile int field_212233_o;
    private volatile int field_212234_p;
    private volatile int field_212235_q;
    private final Object2FloatMap<DimensionType> field_212544_m = Object2FloatMaps.synchronize((Object2FloatMap)new Object2FloatOpenCustomHashMap(Util.func_212443_g()));
    private volatile ITextComponent field_212236_r = new TranslationTextComponent("optimizeWorld.stage.counting", new Object[0]);
    private static final Pattern field_219959_p = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final DimensionSavedDataManager field_219960_q;

    public WorldOptimizer(String string, SaveFormat saveFormat, WorldInfo worldInfo, boolean bl) {
        this.field_212237_s = worldInfo.func_76065_j();
        this.field_219957_d = bl;
        this.field_212221_c = saveFormat.func_197715_a(string, null);
        this.field_212221_c.func_75761_a(worldInfo);
        this.field_219960_q = new DimensionSavedDataManager(new File(DimensionType.field_223227_a_.func_212679_a(this.field_212221_c.func_75765_b()), "data"), this.field_212221_c.func_197718_i());
        this.field_219958_g = this.field_212221_c.func_75765_b();
        this.field_212223_e = field_212220_b.newThread(this::func_212216_o);
        this.field_212223_e.setUncaughtExceptionHandler((thread, throwable) -> {
            field_212219_a.error("Error upgrading world", throwable);
            this.field_212236_r = new TranslationTextComponent("optimizeWorld.stage.failed", new Object[0]);
        });
        this.field_212223_e.start();
    }

    public void func_212217_a() {
        this.field_212224_f = false;
        try {
            this.field_212223_e.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void func_212216_o() {
        ImmutableMap.Builder \u26034;
        DimensionType \u260332;
        File file = this.field_212221_c.func_75765_b();
        this.field_212233_o = 0;
        ImmutableMap.Builder \u26032 = ImmutableMap.builder();
        for (DimensionType \u260332 : DimensionType.func_212681_b()) {
            \u26034 = this.func_219953_b(\u260332);
            \u26032.put((Object)\u260332, \u26034.listIterator());
            this.field_212233_o += \u26034.size();
        }
        if (this.field_212233_o == 0) {
            this.field_212225_g = true;
            return;
        }
        float f = this.field_212233_o;
        \u260332 = \u26032.build();
        \u26034 = ImmutableMap.builder();
        for (DimensionType dimensionType : DimensionType.func_212681_b()) {
            File file2 = dimensionType.func_212679_a(file);
            \u26034.put((Object)dimensionType, (Object)new ChunkLoader(new File(file2, "region"), this.field_212221_c.func_197718_i()));
        }
        ImmutableMap immutableMap = \u26034.build();
        long \u26035 = Util.func_211177_b();
        this.field_212236_r = new TranslationTextComponent("optimizeWorld.stage.upgrading", new Object[0]);
        while (this.field_212224_f) {
            boolean bl = false;
            float \u26036 = 0.0f;
            for (DimensionType dimensionType : DimensionType.func_212681_b()) {
                ListIterator listIterator = (ListIterator)\u260332.get(dimensionType);
                ChunkLoader \u26037 = (ChunkLoader)immutableMap.get((Object)dimensionType);
                if (listIterator.hasNext()) {
                    ChunkPos chunkPos = (ChunkPos)listIterator.next();
                    boolean \u26038 = false;
                    try {
                        CompoundNBT compoundNBT = \u26037.func_219099_e(chunkPos);
                        if (compoundNBT != null) {
                            boolean \u260310;
                            int n = ChunkLoader.func_219165_a(compoundNBT);
                            CompoundNBT \u26039 = \u26037.func_219166_a(dimensionType, () -> this.field_219960_q, compoundNBT);
                            boolean bl2 = \u260310 = n < SharedConstants.func_215069_a().getWorldVersion();
                            if (this.field_219957_d) {
                                CompoundNBT compoundNBT2 = \u26039.func_74775_l("Level");
                                \u260310 = \u260310 || compoundNBT2.func_74764_b("Heightmaps");
                                compoundNBT2.func_82580_o("Heightmaps");
                                \u260310 = \u260310 || compoundNBT2.func_74764_b("isLightOn");
                                compoundNBT2.func_82580_o("isLightOn");
                            }
                            if (\u260310) {
                                \u26037.func_219100_a(chunkPos, \u26039);
                                \u26038 = true;
                            }
                        }
                    }
                    catch (ReportedException reportedException) {
                        Throwable throwable = reportedException.getCause();
                        if (throwable instanceof IOException) {
                            field_212219_a.error("Error upgrading chunk {}", (Object)chunkPos, (Object)throwable);
                        }
                        throw reportedException;
                    }
                    catch (IOException iOException) {
                        field_212219_a.error("Error upgrading chunk {}", (Object)chunkPos, (Object)iOException);
                    }
                    if (\u26038) {
                        ++this.field_212234_p;
                    } else {
                        ++this.field_212235_q;
                    }
                    bl = true;
                }
                float \u260311 = (float)listIterator.nextIndex() / f;
                this.field_212544_m.put((Object)dimensionType, \u260311);
                \u26036 += \u260311;
            }
            this.field_212232_n = \u26036;
            if (bl) continue;
            this.field_212224_f = false;
        }
        this.field_212236_r = new TranslationTextComponent("optimizeWorld.stage.finished", new Object[0]);
        for (ChunkLoader chunkLoader : immutableMap.values()) {
            try {
                chunkLoader.close();
            }
            catch (IOException iOException) {
                field_212219_a.error("Error upgrading chunk", (Throwable)iOException);
            }
        }
        this.field_219960_q.func_212775_b();
        \u26035 = Util.func_211177_b() - \u26035;
        field_212219_a.info("World optimizaton finished after {} ms", (Object)\u26035);
        this.field_212225_g = true;
    }

    private List<ChunkPos> func_219953_b(DimensionType dimensionType) {
        File file2 = dimensionType.func_212679_a(this.field_219958_g);
        \u2603 = new File(file2, "region");
        File[] \u26032 = \u2603.listFiles((file, string) -> string.endsWith(".mca"));
        if (\u26032 == null) {
            return ImmutableList.of();
        }
        ArrayList \u26033 = Lists.newArrayList();
        for (File file3 : \u26032) {
            Matcher matcher = field_219959_p.matcher(file3.getName());
            if (!matcher.matches()) continue;
            int \u26034 = Integer.parseInt(matcher.group(1)) << 5;
            int \u26035 = Integer.parseInt(matcher.group(2)) << 5;
            try (RegionFile regionFile = new RegionFile(file3);){
                for (int i = 0; i < 32; ++i) {
                    for (\u2603 = 0; \u2603 < 32; ++\u2603) {
                        ChunkPos chunkPos = new ChunkPos(i + \u26034, \u2603 + \u26035);
                        if (!regionFile.func_222662_b(chunkPos)) continue;
                        \u26033.add(chunkPos);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return \u26033;
    }

    public boolean func_212218_b() {
        return this.field_212225_g;
    }

    public int func_212211_j() {
        return this.field_212233_o;
    }

    public int func_212208_k() {
        return this.field_212234_p;
    }

    public int func_212209_l() {
        return this.field_212235_q;
    }

    public ITextComponent func_212215_m() {
        return this.field_212236_r;
    }
}

