/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.state.IProperty;
import net.minecraft.state.IStateHolder;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.StringUtils;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NBTUtil {
    private static final Logger field_193591_a = LogManager.getLogger();

    @Nullable
    public static GameProfile func_152459_a(CompoundNBT compoundNBT) {
        String string = null;
        \u2603 = null;
        if (compoundNBT.func_150297_b("Name", 8)) {
            string = compoundNBT.func_74779_i("Name");
        }
        if (compoundNBT.func_150297_b("Id", 8)) {
            \u2603 = compoundNBT.func_74779_i("Id");
        }
        try {
            UUID uUID;
            try {
                uUID = UUID.fromString(\u2603);
            }
            catch (Throwable throwable) {
                uUID = null;
            }
            GameProfile \u26032 = new GameProfile(uUID, string);
            if (compoundNBT.func_150297_b("Properties", 10)) {
                CompoundNBT compoundNBT2 = compoundNBT.func_74775_l("Properties");
                for (String string2 : compoundNBT2.func_150296_c()) {
                    ListNBT listNBT = compoundNBT2.func_150295_c(string2, 10);
                    for (int i = 0; i < listNBT.size(); ++i) {
                        CompoundNBT compoundNBT3 = listNBT.func_150305_b(i);
                        String \u26033 = compoundNBT3.func_74779_i("Value");
                        if (compoundNBT3.func_150297_b("Signature", 8)) {
                            \u26032.getProperties().put((Object)string2, (Object)new Property(string2, \u26033, compoundNBT3.func_74779_i("Signature")));
                            continue;
                        }
                        \u26032.getProperties().put((Object)string2, (Object)new Property(string2, \u26033));
                    }
                }
            }
            return \u26032;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static CompoundNBT func_180708_a(CompoundNBT compoundNBT2, GameProfile gameProfile) {
        CompoundNBT compoundNBT2;
        if (!StringUtils.func_151246_b(gameProfile.getName())) {
            compoundNBT2.func_74778_a("Name", gameProfile.getName());
        }
        if (gameProfile.getId() != null) {
            compoundNBT2.func_74778_a("Id", gameProfile.getId().toString());
        }
        if (!gameProfile.getProperties().isEmpty()) {
            CompoundNBT compoundNBT3 = new CompoundNBT();
            for (String string : gameProfile.getProperties().keySet()) {
                ListNBT listNBT = new ListNBT();
                for (Property property : gameProfile.getProperties().get((Object)string)) {
                    CompoundNBT compoundNBT4 = new CompoundNBT();
                    compoundNBT4.func_74778_a("Value", property.getValue());
                    if (property.hasSignature()) {
                        compoundNBT4.func_74778_a("Signature", property.getSignature());
                    }
                    listNBT.add(compoundNBT4);
                }
                compoundNBT3.func_218657_a(string, listNBT);
            }
            compoundNBT2.func_218657_a("Properties", compoundNBT3);
        }
        return compoundNBT2;
    }

    @VisibleForTesting
    public static boolean func_181123_a(@Nullable INBT iNBT3, @Nullable INBT iNBT2, boolean bl) {
        INBT iNBT3;
        if (iNBT3 == iNBT2) {
            return true;
        }
        if (iNBT3 == null) {
            return true;
        }
        if (iNBT2 == null) {
            return false;
        }
        if (!iNBT3.getClass().equals(iNBT2.getClass())) {
            return false;
        }
        if (iNBT3 instanceof CompoundNBT) {
            CompoundNBT compoundNBT = (CompoundNBT)iNBT3;
            \u2603 = (CompoundNBT)iNBT2;
            for (String string : compoundNBT.func_150296_c()) {
                INBT iNBT4 = compoundNBT.func_74781_a(string);
                if (NBTUtil.func_181123_a(iNBT4, \u2603.func_74781_a(string), bl)) continue;
                return false;
            }
            return true;
        }
        if (iNBT3 instanceof ListNBT && bl) {
            ListNBT listNBT = (ListNBT)iNBT3;
            \u2603 = (ListNBT)iNBT2;
            if (listNBT.isEmpty()) {
                return \u2603.isEmpty();
            }
            for (int i = 0; i < listNBT.size(); ++i) {
                INBT iNBT5 = listNBT.get(i);
                boolean \u26032 = false;
                for (int j = 0; j < \u2603.size(); ++j) {
                    if (!NBTUtil.func_181123_a(iNBT5, \u2603.get(j), bl)) continue;
                    \u26032 = true;
                    break;
                }
                if (\u26032) continue;
                return false;
            }
            return true;
        }
        return iNBT3.equals(iNBT2);
    }

    public static CompoundNBT func_186862_a(UUID uUID) {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74772_a("M", uUID.getMostSignificantBits());
        compoundNBT.func_74772_a("L", uUID.getLeastSignificantBits());
        return compoundNBT;
    }

    public static UUID func_186860_b(CompoundNBT compoundNBT) {
        return new UUID(compoundNBT.func_74763_f("M"), compoundNBT.func_74763_f("L"));
    }

    public static BlockPos func_186861_c(CompoundNBT compoundNBT) {
        return new BlockPos(compoundNBT.func_74762_e("X"), compoundNBT.func_74762_e("Y"), compoundNBT.func_74762_e("Z"));
    }

    public static CompoundNBT func_186859_a(BlockPos blockPos) {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("X", blockPos.func_177958_n());
        compoundNBT.func_74768_a("Y", blockPos.func_177956_o());
        compoundNBT.func_74768_a("Z", blockPos.func_177952_p());
        return compoundNBT;
    }

    public static BlockState func_190008_d(CompoundNBT compoundNBT) {
        if (!compoundNBT.func_150297_b("Name", 8)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        Block block = Registry.field_212618_g.func_82594_a(new ResourceLocation(compoundNBT.func_74779_i("Name")));
        BlockState \u26032 = block.func_176223_P();
        if (compoundNBT.func_150297_b("Properties", 10)) {
            CompoundNBT compoundNBT2 = compoundNBT.func_74775_l("Properties");
            StateContainer<Block, BlockState> \u26033 = block.func_176194_O();
            for (String string : compoundNBT2.func_150296_c()) {
                IProperty<?> iProperty = \u26033.func_185920_a(string);
                if (iProperty == null) continue;
                \u26032 = NBTUtil.func_193590_a(\u26032, iProperty, string, compoundNBT2, compoundNBT);
            }
        }
        return \u26032;
    }

    private static <S extends IStateHolder<S>, T extends Comparable<T>> S func_193590_a(S s, IProperty<T> iProperty, String string, CompoundNBT compoundNBT, CompoundNBT compoundNBT2) {
        Optional<T> optional = iProperty.func_185929_b(compoundNBT.func_74779_i(string));
        if (optional.isPresent()) {
            return (S)((IStateHolder)s.func_206870_a(iProperty, (Comparable)((Comparable)optional.get())));
        }
        field_193591_a.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)string, (Object)compoundNBT.func_74779_i(string), (Object)compoundNBT2.toString());
        return s;
    }

    public static CompoundNBT func_190009_a(BlockState blockState) {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74778_a("Name", Registry.field_212618_g.func_177774_c(blockState.func_177230_c()).toString());
        ImmutableMap<IProperty<?>, Comparable<?>> \u26032 = blockState.func_206871_b();
        if (!\u26032.isEmpty()) {
            \u2603 = new CompoundNBT();
            for (Map.Entry entry : \u26032.entrySet()) {
                IProperty iProperty = (IProperty)entry.getKey();
                \u2603.func_74778_a(iProperty.func_177701_a(), NBTUtil.func_190010_a(iProperty, (Comparable)entry.getValue()));
            }
            compoundNBT.func_218657_a("Properties", \u2603);
        }
        return compoundNBT;
    }

    private static <T extends Comparable<T>> String func_190010_a(IProperty<T> iProperty, Comparable<?> comparable) {
        return iProperty.func_177702_a(comparable);
    }

    public static CompoundNBT func_210822_a(DataFixer dataFixer, DefaultTypeReferences defaultTypeReferences, CompoundNBT compoundNBT, int n) {
        return NBTUtil.func_210821_a(dataFixer, defaultTypeReferences, compoundNBT, n, SharedConstants.func_215069_a().getWorldVersion());
    }

    public static CompoundNBT func_210821_a(DataFixer dataFixer, DefaultTypeReferences defaultTypeReferences, CompoundNBT compoundNBT, int n, int n2) {
        return (CompoundNBT)dataFixer.update(defaultTypeReferences.func_219816_a(), new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compoundNBT), n, n2).getValue();
    }
}

