/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.ArrayUtils;

public class ByteArrayNBT
extends CollectionNBT<ByteNBT> {
    private byte[] field_74754_a;

    ByteArrayNBT() {
    }

    public ByteArrayNBT(byte[] byArray) {
        this.field_74754_a = byArray;
    }

    public ByteArrayNBT(List<Byte> list) {
        this(ByteArrayNBT.func_193589_a(list));
    }

    private static byte[] func_193589_a(List<Byte> list) {
        byte[] byArray = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Byte by = list.get(i);
            byArray[i] = by == null ? (byte)0 : by;
        }
        return byArray;
    }

    @Override
    public void func_74734_a(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.field_74754_a.length);
        dataOutput.write(this.field_74754_a);
    }

    @Override
    public void func_152446_a(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
        nBTSizeTracker.func_152450_a(192L);
        int n2 = dataInput.readInt();
        nBTSizeTracker.func_152450_a(8 * n2);
        this.field_74754_a = new byte[n2];
        dataInput.readFully(this.field_74754_a);
    }

    @Override
    public byte func_74732_a() {
        return 7;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[B;");
        for (int i = 0; i < this.field_74754_a.length; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.field_74754_a[i]).append('B');
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public INBT func_74737_b() {
        byte[] byArray = new byte[this.field_74754_a.length];
        System.arraycopy(this.field_74754_a, 0, byArray, 0, this.field_74754_a.length);
        return new ByteArrayNBT(byArray);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ByteArrayNBT && Arrays.equals(this.field_74754_a, ((ByteArrayNBT)object).field_74754_a);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.field_74754_a);
    }

    @Override
    public ITextComponent func_199850_a(String string, int n) {
        ITextComponent iTextComponent;
        ITextComponent iTextComponent2 = new StringTextComponent("B").func_211708_a(field_197641_e);
        iTextComponent = new StringTextComponent("[").func_150257_a(iTextComponent2).func_150258_a(";");
        for (int i = 0; i < this.field_74754_a.length; ++i) {
            ITextComponent iTextComponent3 = new StringTextComponent(String.valueOf(this.field_74754_a[i])).func_211708_a(field_197640_d);
            iTextComponent.func_150258_a(" ").func_150257_a(iTextComponent3).func_150257_a(iTextComponent2);
            if (i == this.field_74754_a.length - 1) continue;
            iTextComponent.func_150258_a(",");
        }
        iTextComponent.func_150258_a("]");
        return iTextComponent;
    }

    public byte[] func_150292_c() {
        return this.field_74754_a;
    }

    @Override
    public int size() {
        return this.field_74754_a.length;
    }

    @Override
    public ByteNBT get(int n) {
        return new ByteNBT(this.field_74754_a[n]);
    }

    @Override
    public ByteNBT set(int n, ByteNBT byteNBT) {
        byte by = this.field_74754_a[n];
        this.field_74754_a[n] = byteNBT.func_150290_f();
        return new ByteNBT(by);
    }

    @Override
    public void add(int n, ByteNBT byteNBT) {
        this.field_74754_a = ArrayUtils.add((byte[])this.field_74754_a, (int)n, (byte)byteNBT.func_150290_f());
    }

    @Override
    public boolean func_218659_a(int n, INBT iNBT) {
        if (iNBT instanceof NumberNBT) {
            this.field_74754_a[n] = ((NumberNBT)iNBT).func_150290_f();
            return true;
        }
        return false;
    }

    @Override
    public boolean func_218660_b(int n, INBT iNBT) {
        if (iNBT instanceof NumberNBT) {
            this.field_74754_a = ArrayUtils.add((byte[])this.field_74754_a, (int)n, (byte)((NumberNBT)iNBT).func_150290_f());
            return true;
        }
        return false;
    }

    @Override
    public ByteNBT remove(int n) {
        byte by = this.field_74754_a[n];
        this.field_74754_a = ArrayUtils.remove((byte[])this.field_74754_a, (int)n);
        return new ByteNBT(by);
    }

    @Override
    public void clear() {
        this.field_74754_a = new byte[0];
    }

    @Override
    public /* synthetic */ INBT remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, INBT iNBT) {
        this.add(n, (ByteNBT)iNBT);
    }

    @Override
    public /* synthetic */ INBT set(int n, INBT iNBT) {
        return this.set(n, (ByteNBT)iNBT);
    }

    @Override
    public /* synthetic */ Object remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, Object object) {
        this.add(n, (ByteNBT)object);
    }

    @Override
    public /* synthetic */ Object set(int n, Object object) {
        return this.set(n, (ByteNBT)object);
    }

    @Override
    public /* synthetic */ Object get(int n) {
        return this.get(n);
    }
}

