/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.server.ServerWorld;

public class PlacedBlockTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation field_193174_a = new ResourceLocation("placed_block");
    private final Map<PlayerAdvancements, Listeners> field_193175_b = Maps.newHashMap();

    @Override
    public ResourceLocation func_192163_a() {
        return field_193174_a;
    }

    @Override
    public void func_192165_a(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.field_193175_b.get(playerAdvancements);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancements);
            this.field_193175_b.put(playerAdvancements, listeners);
        }
        listeners.func_193490_a(listener);
    }

    @Override
    public void func_192164_b(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.field_193175_b.get(playerAdvancements);
        if (listeners != null) {
            listeners.func_193487_b(listener);
            if (listeners.func_193488_a()) {
                this.field_193175_b.remove(playerAdvancements);
            }
        }
    }

    @Override
    public void func_192167_a(PlayerAdvancements playerAdvancements) {
        this.field_193175_b.remove(playerAdvancements);
    }

    @Override
    public Instance func_192166_a(JsonObject jsonObject2, JsonDeserializationContext jsonDeserializationContext) {
        JsonObject jsonObject2;
        Object object;
        Block \u26032 = null;
        if (jsonObject2.has("block")) {
            object = new ResourceLocation(JSONUtils.func_151200_h(jsonObject2, "block"));
            \u26032 = (Block)Registry.field_212618_g.func_218349_b((ResourceLocation)object).orElseThrow(() -> PlacedBlockTrigger.func_215109_a((ResourceLocation)object));
        }
        object = null;
        if (jsonObject2.has("state")) {
            if (\u26032 == null) {
                throw new JsonSyntaxException("Can't define block state without a specific block type");
            }
            \u26035 = \u26032.func_176194_O();
            for (Map.Entry entry2 : JSONUtils.func_152754_s(jsonObject2, "state").entrySet()) {
                Map.Entry entry2;
                IProperty<?> iProperty = ((StateContainer)\u26035).func_185920_a((String)entry2.getKey());
                if (iProperty == null) {
                    throw new JsonSyntaxException("Unknown block state property '" + (String)entry2.getKey() + "' for block '" + Registry.field_212618_g.func_177774_c(\u26032) + "'");
                }
                String \u26033 = JSONUtils.func_151206_a((JsonElement)entry2.getValue(), (String)entry2.getKey());
                Optional<?> \u26034 = iProperty.func_185929_b(\u26033);
                if (\u26034.isPresent()) {
                    if (object == null) {
                        object = Maps.newHashMap();
                    }
                    object.put(iProperty, \u26034.get());
                    continue;
                }
                throw new JsonSyntaxException("Invalid block state value '" + \u26033 + "' for property '" + (String)entry2.getKey() + "' on block '" + Registry.field_212618_g.func_177774_c(\u26032) + "'");
            }
        }
        Object \u26035 = LocationPredicate.func_193454_a(jsonObject2.get("location"));
        ItemPredicate \u26036 = ItemPredicate.func_192492_a(jsonObject2.get("item"));
        return new Instance(\u26032, (Map<IProperty<?>, Object>)object, (LocationPredicate)\u26035, \u26036);
    }

    public void func_193173_a(ServerPlayerEntity serverPlayerEntity, BlockPos blockPos, ItemStack itemStack) {
        BlockState blockState = serverPlayerEntity.field_70170_p.func_180495_p(blockPos);
        Listeners \u26032 = this.field_193175_b.get(serverPlayerEntity.func_192039_O());
        if (\u26032 != null) {
            \u26032.func_193489_a(blockState, blockPos, serverPlayerEntity.func_71121_q(), itemStack);
        }
    }

    @Override
    public /* synthetic */ ICriterionInstance func_192166_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
        return this.func_192166_a(jsonObject, jsonDeserializationContext);
    }

    private static /* synthetic */ JsonSyntaxException func_215109_a(ResourceLocation resourceLocation) {
        return new JsonSyntaxException("Unknown block type '" + resourceLocation + "'");
    }

    static class Listeners {
        private final PlayerAdvancements field_193491_a;
        private final Set<ICriterionTrigger.Listener<Instance>> field_193492_b = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancements) {
            this.field_193491_a = playerAdvancements;
        }

        public boolean func_193488_a() {
            return this.field_193492_b.isEmpty();
        }

        public void func_193490_a(ICriterionTrigger.Listener<Instance> listener) {
            this.field_193492_b.add(listener);
        }

        public void func_193487_b(ICriterionTrigger.Listener<Instance> listener) {
            this.field_193492_b.remove(listener);
        }

        public void func_193489_a(BlockState blockState, BlockPos blockPos, ServerWorld serverWorld, ItemStack itemStack) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.field_193492_b) {
                if (!listener.func_192158_a().func_193210_a(blockState, blockPos, serverWorld, itemStack)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener<Instance> listener : list) {
                    listener.func_192159_a(this.field_193491_a);
                }
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        private final Block field_193211_a;
        private final Map<IProperty<?>, Object> field_193212_b;
        private final LocationPredicate field_193213_c;
        private final ItemPredicate field_193214_d;

        public Instance(@Nullable Block block, @Nullable Map<IProperty<?>, Object> map, LocationPredicate locationPredicate, ItemPredicate itemPredicate) {
            super(field_193174_a);
            this.field_193211_a = block;
            this.field_193212_b = map;
            this.field_193213_c = locationPredicate;
            this.field_193214_d = itemPredicate;
        }

        public static Instance func_203934_a(Block block) {
            return new Instance(block, null, LocationPredicate.field_193455_a, ItemPredicate.field_192495_a);
        }

        public boolean func_193210_a(BlockState blockState, BlockPos blockPos, ServerWorld serverWorld2, ItemStack itemStack) {
            ServerWorld serverWorld2;
            if (this.field_193211_a != null && blockState.func_177230_c() != this.field_193211_a) {
                return false;
            }
            if (this.field_193212_b != null) {
                for (Map.Entry<IProperty<?>, Object> entry : this.field_193212_b.entrySet()) {
                    if (blockState.func_177229_b(entry.getKey()) == entry.getValue()) continue;
                    return false;
                }
            }
            if (!this.field_193213_c.func_193453_a(serverWorld2, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p())) {
                return false;
            }
            return this.field_193214_d.func_192493_a(itemStack);
        }

        @Override
        public JsonElement func_200288_b() {
            JsonObject jsonObject = new JsonObject();
            if (this.field_193211_a != null) {
                jsonObject.addProperty("block", Registry.field_212618_g.func_177774_c(this.field_193211_a).toString());
            }
            if (this.field_193212_b != null) {
                \u2603 = new JsonObject();
                for (Map.Entry<IProperty<?>, Object> entry : this.field_193212_b.entrySet()) {
                    \u2603.addProperty(entry.getKey().func_177701_a(), Util.func_200269_a(entry.getKey(), entry.getValue()));
                }
                jsonObject.add("state", (JsonElement)\u2603);
            }
            jsonObject.add("location", this.field_193213_c.func_204009_a());
            jsonObject.add("item", this.field_193214_d.func_200319_a());
            return jsonObject;
        }
    }
}

