/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;

public class LocationPredicate {
    public static final LocationPredicate field_193455_a = new LocationPredicate(MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, null, null, null);
    private final MinMaxBounds.FloatBound field_193457_c;
    private final MinMaxBounds.FloatBound field_193458_d;
    private final MinMaxBounds.FloatBound field_193459_e;
    @Nullable
    private final Biome field_193456_b;
    @Nullable
    private final Structure<?> field_193460_f;
    @Nullable
    private final DimensionType field_193461_g;

    public LocationPredicate(MinMaxBounds.FloatBound floatBound, MinMaxBounds.FloatBound floatBound2, MinMaxBounds.FloatBound floatBound3, @Nullable Biome biome, @Nullable Structure<?> structure, @Nullable DimensionType dimensionType) {
        this.field_193457_c = floatBound;
        this.field_193458_d = floatBound2;
        this.field_193459_e = floatBound3;
        this.field_193456_b = biome;
        this.field_193460_f = structure;
        this.field_193461_g = dimensionType;
    }

    public static LocationPredicate func_204010_a(Biome biome) {
        return new LocationPredicate(MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, biome, null, null);
    }

    public static LocationPredicate func_204008_a(DimensionType dimensionType) {
        return new LocationPredicate(MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, null, null, dimensionType);
    }

    public static LocationPredicate func_218020_a(Structure<?> structure) {
        return new LocationPredicate(MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, MinMaxBounds.FloatBound.field_211359_e, null, structure, null);
    }

    public boolean func_193452_a(ServerWorld serverWorld, double d, double d2, double d3) {
        return this.func_193453_a(serverWorld, (float)d, (float)d2, (float)d3);
    }

    public boolean func_193453_a(ServerWorld serverWorld, float f, float f2, float f3) {
        if (!this.field_193457_c.func_211354_d(f)) {
            return false;
        }
        if (!this.field_193458_d.func_211354_d(f2)) {
            return false;
        }
        if (!this.field_193459_e.func_211354_d(f3)) {
            return false;
        }
        if (this.field_193461_g != null && this.field_193461_g != serverWorld.field_73011_w.func_186058_p()) {
            return false;
        }
        BlockPos blockPos = new BlockPos(f, f2, f3);
        if (this.field_193456_b != null && this.field_193456_b != serverWorld.func_180494_b(blockPos)) {
            return false;
        }
        return this.field_193460_f == null || this.field_193460_f.func_202366_b(serverWorld, blockPos);
    }

    public JsonElement func_204009_a() {
        if (this == field_193455_a) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (!(this.field_193457_c.func_211335_c() && this.field_193458_d.func_211335_c() && this.field_193459_e.func_211335_c())) {
            \u2603 = new JsonObject();
            \u2603.add("x", this.field_193457_c.func_200321_c());
            \u2603.add("y", this.field_193458_d.func_200321_c());
            \u2603.add("z", this.field_193459_e.func_200321_c());
            jsonObject.add("position", (JsonElement)\u2603);
        }
        if (this.field_193461_g != null) {
            jsonObject.addProperty("dimension", DimensionType.func_212678_a(this.field_193461_g).toString());
        }
        if (this.field_193460_f != null) {
            jsonObject.addProperty("feature", (String)Feature.field_202300_at.inverse().get(this.field_193460_f));
        }
        if (this.field_193456_b != null) {
            jsonObject.addProperty("biome", Registry.field_212624_m.func_177774_c(this.field_193456_b).toString());
        }
        return jsonObject;
    }

    public static LocationPredicate func_193454_a(@Nullable JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return field_193455_a;
        }
        JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "location");
        \u2603 = JSONUtils.func_151218_a(jsonObject, "position", new JsonObject());
        MinMaxBounds.FloatBound \u26032 = MinMaxBounds.FloatBound.func_211356_a(\u2603.get("x"));
        MinMaxBounds.FloatBound \u26033 = MinMaxBounds.FloatBound.func_211356_a(\u2603.get("y"));
        MinMaxBounds.FloatBound \u26034 = MinMaxBounds.FloatBound.func_211356_a(\u2603.get("z"));
        DimensionType \u26035 = jsonObject.has("dimension") ? DimensionType.func_193417_a(new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "dimension"))) : null;
        Structure \u26036 = jsonObject.has("feature") ? (Structure)Feature.field_202300_at.get((Object)JSONUtils.func_151200_h(jsonObject, "feature")) : null;
        Biome \u26037 = null;
        if (jsonObject.has("biome")) {
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "biome"));
            \u26037 = Registry.field_212624_m.func_218349_b(resourceLocation).orElseThrow(() -> new JsonSyntaxException("Unknown biome '" + resourceLocation + "'"));
        }
        return new LocationPredicate(\u26032, \u26033, \u26034, \u26037, \u26036, \u26035);
    }

    public static class Builder {
        private MinMaxBounds.FloatBound field_218014_a = MinMaxBounds.FloatBound.field_211359_e;
        private MinMaxBounds.FloatBound field_218015_b = MinMaxBounds.FloatBound.field_211359_e;
        private MinMaxBounds.FloatBound field_218016_c = MinMaxBounds.FloatBound.field_211359_e;
        @Nullable
        private Biome field_218017_d;
        @Nullable
        private Structure<?> field_218018_e;
        @Nullable
        private DimensionType field_218019_f;

        public Builder func_218012_a(@Nullable Biome biome) {
            this.field_218017_d = biome;
            return this;
        }

        public LocationPredicate func_218013_a() {
            return new LocationPredicate(this.field_218014_a, this.field_218015_b, this.field_218016_c, this.field_218017_d, this.field_218018_e, this.field_218019_f);
        }
    }
}

