/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss.dragon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.boss.dragon.phase.IPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseManager;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.EndDimension;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnderDragonEntity
extends MobEntity
implements IMob {
    private static final Logger field_184675_bH = LogManager.getLogger();
    public static final DataParameter<Integer> field_184674_a = EntityDataManager.func_187226_a(EnderDragonEntity.class, DataSerializers.field_187192_b);
    private static final EntityPredicate field_213405_bO = new EntityPredicate().func_221013_a(64.0);
    public final double[][] field_70979_e = new double[64][3];
    public int field_70976_f = -1;
    public final EnderDragonPartEntity[] field_70977_g;
    public final EnderDragonPartEntity field_70986_h;
    public final EnderDragonPartEntity field_184673_bv;
    public final EnderDragonPartEntity field_70987_i;
    public final EnderDragonPartEntity field_70985_j;
    public final EnderDragonPartEntity field_70984_by;
    public final EnderDragonPartEntity field_70982_bz;
    public final EnderDragonPartEntity field_70983_bA;
    public final EnderDragonPartEntity field_70990_bB;
    public float field_70991_bC;
    public float field_70988_bD;
    public boolean field_70994_bF;
    public int field_70995_bG;
    public EnderCrystalEntity field_70992_bH;
    private final DragonFightManager field_184676_bI;
    private final PhaseManager field_184677_bJ;
    private int field_184678_bK = 100;
    private int field_184679_bL;
    private final PathPoint[] field_184680_bM = new PathPoint[24];
    private final int[] field_184681_bN = new int[24];
    private final PathHeap field_184682_bO = new PathHeap();

    public EnderDragonEntity(EntityType<? extends EnderDragonEntity> p_i50230_1_, World p_i50230_2_) {
        super((EntityType<? extends MobEntity>)EntityType.field_200802_p, p_i50230_2_);
        this.field_70986_h = new EnderDragonPartEntity(this, "head", 1.0f, 1.0f);
        this.field_184673_bv = new EnderDragonPartEntity(this, "neck", 3.0f, 3.0f);
        this.field_70987_i = new EnderDragonPartEntity(this, "body", 5.0f, 3.0f);
        this.field_70985_j = new EnderDragonPartEntity(this, "tail", 2.0f, 2.0f);
        this.field_70984_by = new EnderDragonPartEntity(this, "tail", 2.0f, 2.0f);
        this.field_70982_bz = new EnderDragonPartEntity(this, "tail", 2.0f, 2.0f);
        this.field_70983_bA = new EnderDragonPartEntity(this, "wing", 4.0f, 2.0f);
        this.field_70990_bB = new EnderDragonPartEntity(this, "wing", 4.0f, 2.0f);
        this.field_70977_g = new EnderDragonPartEntity[]{this.field_70986_h, this.field_184673_bv, this.field_70987_i, this.field_70985_j, this.field_70984_by, this.field_70982_bz, this.field_70983_bA, this.field_70990_bB};
        this.func_70606_j(this.func_110138_aP());
        this.field_70145_X = true;
        this.field_70158_ak = true;
        this.field_184676_bI = !p_i50230_2_.field_72995_K && p_i50230_2_.field_73011_w instanceof EndDimension ? ((EndDimension)p_i50230_2_.field_73011_w).func_186063_s() : null;
        this.field_184677_bJ = new PhaseManager(this);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(field_184674_a, PhaseType.field_188751_k.func_188740_b());
    }

    public double[] func_70974_a(int p_70974_1_, float p_70974_2_) {
        if (this.func_110143_aJ() <= 0.0f) {
            p_70974_2_ = 0.0f;
        }
        p_70974_2_ = 1.0f - p_70974_2_;
        int i = this.field_70976_f - p_70974_1_ & 0x3F;
        int j = this.field_70976_f - p_70974_1_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.field_70979_e[i][0];
        double d1 = MathHelper.func_76138_g((double)(this.field_70979_e[j][0] - d0));
        adouble[0] = d0 + d1 * (double)p_70974_2_;
        d0 = this.field_70979_e[i][1];
        d1 = this.field_70979_e[j][1] - d0;
        adouble[1] = d0 + d1 * (double)p_70974_2_;
        adouble[2] = MathHelper.func_219803_d((double)p_70974_2_, (double)this.field_70979_e[i][2], (double)this.field_70979_e[j][2]);
        return adouble;
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.func_70606_j(this.func_110143_aJ());
            if (!this.func_174814_R()) {
                float f = MathHelper.func_76134_b((float)(this.field_70988_bD * ((float)Math.PI * 2)));
                float f1 = MathHelper.func_76134_b((float)(this.field_70991_bC * ((float)Math.PI * 2)));
                if (f1 <= -0.3f && f >= -0.3f) {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, this.func_184176_by(), 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
                }
                if (!this.field_184677_bJ.func_188756_a().func_188654_a() && --this.field_184678_bK < 0) {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187525_aO, this.func_184176_by(), 2.5f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
                    this.field_184678_bK = 200 + this.field_70146_Z.nextInt(200);
                }
            }
        }
        this.field_70991_bC = this.field_70988_bD;
        if (this.func_110143_aJ() <= 0.0f) {
            float f11 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f13 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f14 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.field_70165_t + (double)f11, this.field_70163_u + 2.0 + (double)f13, this.field_70161_v + (double)f14, 0.0, 0.0, 0.0);
        } else {
            this.func_70969_j();
            Vec3d vec3d4 = this.func_213322_ci();
            float f12 = 0.2f / (MathHelper.func_76133_a((double)EnderDragonEntity.func_213296_b(vec3d4)) * 10.0f + 1.0f);
            this.field_70988_bD = this.field_184677_bJ.func_188756_a().func_188654_a() ? (this.field_70988_bD += 0.1f) : (this.field_70994_bF ? (this.field_70988_bD += f12 * 0.5f) : (this.field_70988_bD += (f12 *= (float)Math.pow(2.0, vec3d4.field_72448_b))));
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
            if (this.func_175446_cd()) {
                this.field_70988_bD = 0.5f;
            } else {
                if (this.field_70976_f < 0) {
                    for (int i = 0; i < this.field_70979_e.length; ++i) {
                        this.field_70979_e[i][0] = this.field_70177_z;
                        this.field_70979_e[i][1] = this.field_70163_u;
                    }
                }
                if (++this.field_70976_f == this.field_70979_e.length) {
                    this.field_70976_f = 0;
                }
                this.field_70979_e[this.field_70976_f][0] = this.field_70177_z;
                this.field_70979_e[this.field_70976_f][1] = this.field_70163_u;
                if (this.field_70170_p.field_72995_K) {
                    if (this.field_70716_bi > 0) {
                        double d7 = this.field_70165_t + (this.field_184623_bh - this.field_70165_t) / (double)this.field_70716_bi;
                        double d0 = this.field_70163_u + (this.field_184624_bi - this.field_70163_u) / (double)this.field_70716_bi;
                        double d1 = this.field_70161_v + (this.field_184625_bj - this.field_70161_v) / (double)this.field_70716_bi;
                        double d2 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
                        this.field_70177_z = (float)((double)this.field_70177_z + d2 / (double)this.field_70716_bi);
                        this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
                        --this.field_70716_bi;
                        this.func_70107_b(d7, d0, d1);
                        this.func_70101_b(this.field_70177_z, this.field_70125_A);
                    }
                    this.field_184677_bJ.func_188756_a().func_188657_b();
                } else {
                    Vec3d vec3d;
                    IPhase iphase = this.field_184677_bJ.func_188756_a();
                    iphase.func_188659_c();
                    if (this.field_184677_bJ.func_188756_a() != iphase) {
                        iphase = this.field_184677_bJ.func_188756_a();
                        iphase.func_188659_c();
                    }
                    if ((vec3d = iphase.func_188650_g()) != null) {
                        double d8 = vec3d.field_72450_a - this.field_70165_t;
                        double d9 = vec3d.field_72448_b - this.field_70163_u;
                        double d10 = vec3d.field_72449_c - this.field_70161_v;
                        double d3 = d8 * d8 + d9 * d9 + d10 * d10;
                        float f5 = iphase.func_188651_f();
                        double d4 = MathHelper.func_76133_a((double)(d8 * d8 + d10 * d10));
                        if (d4 > 0.0) {
                            d9 = MathHelper.func_151237_a((double)(d9 / d4), (double)(-f5), (double)f5);
                        }
                        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, d9 * 0.01, 0.0));
                        this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
                        double d5 = MathHelper.func_151237_a((double)MathHelper.func_76138_g((double)(180.0 - MathHelper.func_181159_b((double)d8, (double)d10) * 57.2957763671875 - (double)this.field_70177_z)), (double)-50.0, (double)50.0);
                        Vec3d vec3d1 = vec3d.func_178786_a(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72432_b();
                        Vec3d vec3d2 = new Vec3d(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), this.func_213322_ci().field_72448_b, -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))).func_72432_b();
                        float f8 = Math.max(((float)vec3d2.func_72430_b(vec3d1) + 0.5f) / 1.5f, 0.0f);
                        this.field_70704_bt *= 0.8f;
                        this.field_70704_bt = (float)((double)this.field_70704_bt + d5 * (double)iphase.func_188653_h());
                        this.field_70177_z += this.field_70704_bt * 0.1f;
                        float f9 = (float)(2.0 / (d3 + 1.0));
                        float f10 = 0.06f;
                        this.func_213309_a(0.06f * (f8 * f9 + (1.0f - f9)), new Vec3d(0.0, 0.0, -1.0));
                        if (this.field_70994_bF) {
                            this.func_213315_a(MoverType.SELF, this.func_213322_ci().func_186678_a(0.8f));
                        } else {
                            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                        }
                        Vec3d vec3d3 = this.func_213322_ci().func_72432_b();
                        double d6 = 0.8 + 0.15 * (vec3d3.func_72430_b(vec3d2) + 1.0) / 2.0;
                        this.func_213317_d(this.func_213322_ci().func_216372_d(d6, 0.91f, d6));
                    }
                }
                this.field_70761_aq = this.field_70177_z;
                Vec3d[] avec3d = new Vec3d[this.field_70977_g.length];
                for (int j = 0; j < this.field_70977_g.length; ++j) {
                    avec3d[j] = new Vec3d(this.field_70977_g[j].field_70165_t, this.field_70977_g[j].field_70163_u, this.field_70977_g[j].field_70161_v);
                }
                float f15 = (float)(this.func_70974_a(5, 1.0f)[1] - this.func_70974_a(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f16 = MathHelper.func_76134_b((float)f15);
                float f2 = MathHelper.func_76126_a((float)f15);
                float f17 = this.field_70177_z * ((float)Math.PI / 180);
                float f3 = MathHelper.func_76126_a((float)f17);
                float f18 = MathHelper.func_76134_b((float)f17);
                this.field_70987_i.func_70071_h_();
                this.field_70987_i.func_70012_b(this.field_70165_t + (double)(f3 * 0.5f), this.field_70163_u, this.field_70161_v - (double)(f18 * 0.5f), 0.0f, 0.0f);
                this.field_70983_bA.func_70071_h_();
                this.field_70983_bA.func_70012_b(this.field_70165_t + (double)(f18 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v + (double)(f3 * 4.5f), 0.0f, 0.0f);
                this.field_70990_bB.func_70071_h_();
                this.field_70990_bB.func_70012_b(this.field_70165_t - (double)(f18 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v - (double)(f3 * 4.5f), 0.0f, 0.0f);
                if (!this.field_70170_p.field_72995_K && this.field_70737_aN == 0) {
                    this.func_70970_a(this.field_70170_p.func_175674_a(this, this.field_70983_bA.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0), EntityPredicates.field_188444_d));
                    this.func_70970_a(this.field_70170_p.func_175674_a(this, this.field_70990_bB.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0), EntityPredicates.field_188444_d));
                    this.func_70971_b(this.field_70170_p.func_175674_a(this, this.field_70986_h.func_174813_aQ().func_186662_g(1.0), EntityPredicates.field_188444_d));
                    this.func_70971_b(this.field_70170_p.func_175674_a(this, this.field_184673_bv.func_174813_aQ().func_186662_g(1.0), EntityPredicates.field_188444_d));
                }
                double[] adouble = this.func_70974_a(5, 1.0f);
                float f19 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180) - this.field_70704_bt * 0.01f));
                float f4 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180) - this.field_70704_bt * 0.01f));
                this.field_70986_h.func_70071_h_();
                this.field_184673_bv.func_70071_h_();
                float f20 = this.func_184662_q(1.0f);
                this.field_70986_h.func_70012_b(this.field_70165_t + (double)(f19 * 6.5f * f16), this.field_70163_u + (double)f20 + (double)(f2 * 6.5f), this.field_70161_v - (double)(f4 * 6.5f * f16), 0.0f, 0.0f);
                this.field_184673_bv.func_70012_b(this.field_70165_t + (double)(f19 * 5.5f * f16), this.field_70163_u + (double)f20 + (double)(f2 * 5.5f), this.field_70161_v - (double)(f4 * 5.5f * f16), 0.0f, 0.0f);
                for (int k = 0; k < 3; ++k) {
                    EnderDragonPartEntity enderdragonpartentity = null;
                    if (k == 0) {
                        enderdragonpartentity = this.field_70985_j;
                    }
                    if (k == 1) {
                        enderdragonpartentity = this.field_70984_by;
                    }
                    if (k == 2) {
                        enderdragonpartentity = this.field_70982_bz;
                    }
                    double[] adouble1 = this.func_70974_a(12 + k * 2, 1.0f);
                    float f21 = this.field_70177_z * ((float)Math.PI / 180) + this.func_70973_b(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f6 = MathHelper.func_76126_a((float)f21);
                    float f22 = MathHelper.func_76134_b((float)f21);
                    float f7 = 1.5f;
                    float f23 = (float)(k + 1) * 2.0f;
                    enderdragonpartentity.func_70071_h_();
                    enderdragonpartentity.func_70012_b(this.field_70165_t - (double)((f3 * 1.5f + f6 * f23) * f16), this.field_70163_u + (adouble1[1] - adouble[1]) - (double)((f23 + 1.5f) * f2) + 1.5, this.field_70161_v + (double)((f18 * 1.5f + f22 * f23) * f16), 0.0f, 0.0f);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70994_bF = this.func_70972_a(this.field_70986_h.func_174813_aQ()) | this.func_70972_a(this.field_184673_bv.func_174813_aQ()) | this.func_70972_a(this.field_70987_i.func_174813_aQ());
                    if (this.field_184676_bI != null) {
                        this.field_184676_bI.func_186099_b(this);
                    }
                }
                for (int l = 0; l < this.field_70977_g.length; ++l) {
                    this.field_70977_g[l].field_70169_q = avec3d[l].field_72450_a;
                    this.field_70977_g[l].field_70167_r = avec3d[l].field_72448_b;
                    this.field_70977_g[l].field_70166_s = avec3d[l].field_72449_c;
                }
            }
        }
    }

    private float func_184662_q(float p_184662_1_) {
        double d0;
        if (this.field_184677_bJ.func_188756_a().func_188654_a()) {
            d0 = -1.0;
        } else {
            double[] adouble = this.func_70974_a(5, 1.0f);
            double[] adouble1 = this.func_70974_a(0, 1.0f);
            d0 = adouble[1] - adouble1[1];
        }
        return (float)d0;
    }

    private void func_70969_j() {
        if (this.field_70992_bH != null) {
            if (this.field_70992_bH.field_70128_L) {
                this.field_70992_bH = null;
            } else if (this.field_70173_aa % 10 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70606_j(this.func_110143_aJ() + 1.0f);
            }
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            List list = this.field_70170_p.func_217357_a(EnderCrystalEntity.class, this.func_174813_aQ().func_186662_g(32.0));
            EnderCrystalEntity endercrystalentity = null;
            double d0 = Double.MAX_VALUE;
            for (EnderCrystalEntity endercrystalentity1 : list) {
                double d1 = endercrystalentity1.func_70068_e((Entity)this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                endercrystalentity = endercrystalentity1;
            }
            this.field_70992_bH = endercrystalentity;
        }
    }

    private void func_70970_a(List<Entity> p_70970_1_) {
        double d0 = (this.field_70987_i.func_174813_aQ().field_72340_a + this.field_70987_i.func_174813_aQ().field_72336_d) / 2.0;
        double d1 = (this.field_70987_i.func_174813_aQ().field_72339_c + this.field_70987_i.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (!(entity instanceof LivingEntity)) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.field_184677_bJ.func_188756_a().func_188654_a() || ((LivingEntity)entity).func_142015_aE() >= entity.field_70173_aa - 2) continue;
            entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 5.0f);
            this.func_174815_a(this, entity);
        }
    }

    private void func_70971_b(List<Entity> p_70971_1_) {
        for (int i = 0; i < p_70971_1_.size(); ++i) {
            Entity entity = p_70971_1_.get(i);
            if (!(entity instanceof LivingEntity)) continue;
            entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 10.0f);
            this.func_174815_a(this, entity);
        }
    }

    private float func_70973_b(double p_70973_1_) {
        return (float)MathHelper.func_76138_g((double)p_70973_1_);
    }

    private boolean func_70972_a(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = blockstate.func_177230_c();
                    if (blockstate.isAir((IBlockReader)this.field_70170_p, blockpos) || blockstate.func_185904_a() == Material.field_151581_o) continue;
                    if (ForgeHooks.canEntityDestroy((World)this.field_70170_p, (BlockPos)blockpos, (LivingEntity)this) && !BlockTags.field_219754_W.func_199685_a_(block)) {
                        flag1 = this.field_70170_p.func_217377_a(blockpos, false) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.field_70146_Z.nextInt(l - i + 1), j + this.field_70146_Z.nextInt(i1 - j + 1), k + this.field_70146_Z.nextInt(j1 - k + 1));
            this.field_70170_p.func_217379_c(2008, blockpos1, 0);
        }
        return flag;
    }

    public boolean func_213403_a(EnderDragonPartEntity p_213403_1_, DamageSource p_213403_2_, float p_213403_3_) {
        p_213403_3_ = this.field_184677_bJ.func_188756_a().func_221113_a(p_213403_2_, p_213403_3_);
        if (p_213403_1_ != this.field_70986_h) {
            p_213403_3_ = p_213403_3_ / 4.0f + Math.min(p_213403_3_, 1.0f);
        }
        if (p_213403_3_ < 0.01f) {
            return false;
        }
        if (p_213403_2_.func_76346_g() instanceof PlayerEntity || p_213403_2_.func_94541_c()) {
            float f = this.func_110143_aJ();
            this.func_82195_e(p_213403_2_, p_213403_3_);
            if (this.func_110143_aJ() <= 0.0f && !this.field_184677_bJ.func_188756_a().func_188654_a()) {
                this.func_70606_j(1.0f);
                this.field_184677_bJ.func_188758_a(PhaseType.field_188750_j);
            }
            if (this.field_184677_bJ.func_188756_a().func_188654_a()) {
                this.field_184679_bL = (int)((float)this.field_184679_bL + (f - this.func_110143_aJ()));
                if ((float)this.field_184679_bL > 0.25f * this.func_110138_aP()) {
                    this.field_184679_bL = 0;
                    this.field_184677_bJ.func_188758_a(PhaseType.field_188745_e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
            this.func_213403_a(this.field_70987_i, source, amount);
        }
        return false;
    }

    protected boolean func_82195_e(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_174812_G() {
        this.func_70106_y();
        if (this.field_184676_bI != null) {
            this.field_184676_bI.func_186099_b(this);
            this.field_184676_bI.func_186096_a(this);
        }
    }

    @Override
    protected void func_70609_aI() {
        if (this.field_184676_bI != null) {
            this.field_184676_bI.func_186099_b(this);
        }
        ++this.field_70995_bG;
        if (this.field_70995_bG >= 180 && this.field_70995_bG <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        }
        boolean flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e);
        int i = 500;
        if (this.field_184676_bI != null && !this.field_184676_bI.func_186102_d()) {
            i = 12000;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70995_bG > 150 && this.field_70995_bG % 5 == 0 && flag) {
                this.func_184668_a(MathHelper.func_76141_d((float)((float)i * 0.08f)));
            }
            if (this.field_70995_bG == 1) {
                this.field_70170_p.func_175669_a(1028, new BlockPos((Entity)this), 0);
            }
        }
        this.func_213315_a(MoverType.SELF, new Vec3d(0.0, 0.1f, 0.0));
        this.field_70177_z += 20.0f;
        this.field_70761_aq = this.field_70177_z;
        if (this.field_70995_bG == 200 && !this.field_70170_p.field_72995_K) {
            if (flag) {
                this.func_184668_a(MathHelper.func_76141_d((float)((float)i * 0.2f)));
            }
            if (this.field_184676_bI != null) {
                this.field_184676_bI.func_186096_a(this);
            }
            this.func_70106_y();
        }
    }

    private void func_184668_a(int p_184668_1_) {
        while (p_184668_1_ > 0) {
            int i = ExperienceOrbEntity.func_70527_a(p_184668_1_);
            p_184668_1_ -= i;
            this.field_70170_p.func_217376_c(new ExperienceOrbEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, i));
        }
    }

    public int func_184671_o() {
        if (this.field_184680_bM[0] == null) {
            for (int i = 0; i < 24; ++i) {
                int i1;
                int l;
                int j = 5;
                if (i < 12) {
                    l = MathHelper.func_76141_d((float)(60.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)))));
                    i1 = MathHelper.func_76141_d((float)(60.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)))));
                } else if (i < 20) {
                    int lvt_3_1_ = i - 12;
                    l = MathHelper.func_76141_d((float)(40.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)lvt_3_1_)))));
                    i1 = MathHelper.func_76141_d((float)(40.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)lvt_3_1_)))));
                    j += 10;
                } else {
                    int k1 = i - 20;
                    l = MathHelper.func_76141_d((float)(20.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)))));
                    i1 = MathHelper.func_76141_d((float)(20.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)))));
                }
                int j1 = Math.max(this.field_70170_p.func_181545_F() + 10, this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(l, 0, i1)).func_177956_o() + j);
                this.field_184680_bM[i] = new PathPoint(l, j1, i1);
            }
            this.field_184681_bN[0] = 6146;
            this.field_184681_bN[1] = 8197;
            this.field_184681_bN[2] = 8202;
            this.field_184681_bN[3] = 16404;
            this.field_184681_bN[4] = 32808;
            this.field_184681_bN[5] = 32848;
            this.field_184681_bN[6] = 65696;
            this.field_184681_bN[7] = 131392;
            this.field_184681_bN[8] = 131712;
            this.field_184681_bN[9] = 263424;
            this.field_184681_bN[10] = 526848;
            this.field_184681_bN[11] = 525313;
            this.field_184681_bN[12] = 1581057;
            this.field_184681_bN[13] = 3166214;
            this.field_184681_bN[14] = 2138120;
            this.field_184681_bN[15] = 6373424;
            this.field_184681_bN[16] = 4358208;
            this.field_184681_bN[17] = 12910976;
            this.field_184681_bN[18] = 9044480;
            this.field_184681_bN[19] = 9706496;
            this.field_184681_bN[20] = 15216640;
            this.field_184681_bN[21] = 0xD0E000;
            this.field_184681_bN[22] = 11763712;
            this.field_184681_bN[23] = 0x7E0000;
        }
        return this.func_184663_l(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public int func_184663_l(double x, double y, double z) {
        float f = 10000.0f;
        int i = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
        int j = 0;
        if (this.field_184676_bI == null || this.field_184676_bI.func_186092_c() == 0) {
            j = 12;
        }
        for (int k = j; k < 24; ++k) {
            float f1;
            if (this.field_184680_bM[k] == null || !((f1 = this.field_184680_bM[k].func_75832_b(pathpoint)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    @Nullable
    public Path func_184666_a(int startIdx, int finishIdx, @Nullable PathPoint andThen) {
        for (int i = 0; i < 24; ++i) {
            PathPoint pathpoint = this.field_184680_bM[i];
            pathpoint.field_75842_i = false;
            pathpoint.field_75834_g = 0.0f;
            pathpoint.field_75836_e = 0.0f;
            pathpoint.field_75833_f = 0.0f;
            pathpoint.field_75841_h = null;
            pathpoint.field_75835_d = -1;
        }
        PathPoint pathpoint4 = this.field_184680_bM[startIdx];
        PathPoint pathpoint5 = this.field_184680_bM[finishIdx];
        pathpoint4.field_75836_e = 0.0f;
        pathpoint4.field_75834_g = pathpoint4.field_75833_f = pathpoint4.func_75829_a(pathpoint5);
        this.field_184682_bO.func_75848_a();
        this.field_184682_bO.func_75849_a(pathpoint4);
        PathPoint pathpoint1 = pathpoint4;
        int j = 0;
        if (this.field_184676_bI == null || this.field_184676_bI.func_186092_c() == 0) {
            j = 12;
        }
        while (!this.field_184682_bO.func_75845_e()) {
            PathPoint pathpoint2 = this.field_184682_bO.func_75844_c();
            if (pathpoint2.equals((Object)pathpoint5)) {
                if (andThen != null) {
                    andThen.field_75841_h = pathpoint5;
                    pathpoint5 = andThen;
                }
                return this.func_184669_a(pathpoint4, pathpoint5);
            }
            if (pathpoint2.func_75829_a(pathpoint5) < pathpoint1.func_75829_a(pathpoint5)) {
                pathpoint1 = pathpoint2;
            }
            pathpoint2.field_75842_i = true;
            int k = 0;
            for (int l = 0; l < 24; ++l) {
                if (this.field_184680_bM[l] != pathpoint2) continue;
                k = l;
                break;
            }
            for (int i1 = j; i1 < 24; ++i1) {
                if ((this.field_184681_bN[k] & 1 << i1) <= 0) continue;
                PathPoint pathpoint3 = this.field_184680_bM[i1];
                if (pathpoint3.field_75842_i) continue;
                float f = pathpoint2.field_75836_e + pathpoint2.func_75829_a(pathpoint3);
                if (pathpoint3.func_75831_a() && !(f < pathpoint3.field_75836_e)) continue;
                pathpoint3.field_75841_h = pathpoint2;
                pathpoint3.field_75836_e = f;
                pathpoint3.field_75833_f = pathpoint3.func_75829_a(pathpoint5);
                if (pathpoint3.func_75831_a()) {
                    this.field_184682_bO.func_75850_a(pathpoint3, pathpoint3.field_75836_e + pathpoint3.field_75833_f);
                    continue;
                }
                pathpoint3.field_75834_g = pathpoint3.field_75836_e + pathpoint3.field_75833_f;
                this.field_184682_bO.func_75849_a(pathpoint3);
            }
        }
        if (pathpoint1 == pathpoint4) {
            return null;
        }
        field_184675_bH.debug("Failed to find path from {} to {}", (Object)startIdx, (Object)finishIdx);
        if (andThen != null) {
            andThen.field_75841_h = pathpoint1;
            pathpoint1 = andThen;
        }
        return this.func_184669_a(pathpoint4, pathpoint1);
    }

    private Path func_184669_a(PathPoint start, PathPoint finish) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint = finish;
        list.add(0, finish);
        while (pathpoint.field_75841_h != null) {
            pathpoint = pathpoint.field_75841_h;
            list.add(0, pathpoint);
        }
        return new Path((List)list, new BlockPos(finish.field_75839_a, finish.field_75837_b, finish.field_75838_c), true);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("DragonPhase", this.field_184677_bJ.func_188756_a().func_188652_i().func_188740_b());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("DragonPhase")) {
            this.field_184677_bJ.func_188758_a(PhaseType.func_188738_a((int)compound.func_74762_e("DragonPhase")));
        }
    }

    @Override
    protected void func_70623_bb() {
    }

    public EnderDragonPartEntity[] func_213404_dT() {
        return this.field_70977_g;
    }

    @Override
    public boolean func_70067_L() {
        return false;
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187521_aK;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187526_aP;
    }

    @Override
    protected float func_70599_aP() {
        return 5.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_184667_a(int p_184667_1_, double[] p_184667_2_, double[] p_184667_3_) {
        double d0;
        IPhase iphase = this.field_184677_bJ.func_188756_a();
        PhaseType phasetype = iphase.func_188652_i();
        if (phasetype != PhaseType.field_188744_d && phasetype != PhaseType.field_188745_e) {
            d0 = iphase.func_188654_a() ? (double)p_184667_1_ : (p_184667_1_ == 6 ? 0.0 : p_184667_3_[1] - p_184667_2_[1]);
        } else {
            BlockPos blockpos = this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a);
            float f = Math.max(MathHelper.func_76133_a((double)blockpos.func_218138_a((IPosition)this.func_213303_ch(), true)) / 4.0f, 1.0f);
            d0 = (float)p_184667_1_ / f;
        }
        return (float)d0;
    }

    public Vec3d func_184665_a(float p_184665_1_) {
        Vec3d vec3d;
        IPhase iphase = this.field_184677_bJ.func_188756_a();
        PhaseType phasetype = iphase.func_188652_i();
        if (phasetype != PhaseType.field_188744_d && phasetype != PhaseType.field_188745_e) {
            if (iphase.func_188654_a()) {
                float f4 = this.field_70125_A;
                float f5 = 1.5f;
                this.field_70125_A = -45.0f;
                vec3d = this.func_70676_i(p_184665_1_);
                this.field_70125_A = f4;
            } else {
                vec3d = this.func_70676_i(p_184665_1_);
            }
        } else {
            BlockPos blockpos = this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a);
            float f = Math.max(MathHelper.func_76133_a((double)blockpos.func_218138_a((IPosition)this.func_213303_ch(), true)) / 4.0f, 1.0f);
            float f1 = 6.0f / f;
            float f2 = this.field_70125_A;
            float f3 = 1.5f;
            this.field_70125_A = -f1 * 1.5f * 5.0f;
            vec3d = this.func_70676_i(p_184665_1_);
            this.field_70125_A = f2;
        }
        return vec3d;
    }

    public void func_184672_a(EnderCrystalEntity crystal, BlockPos pos, DamageSource dmgSrc) {
        PlayerEntity playerentity = dmgSrc.func_76346_g() instanceof PlayerEntity ? (PlayerEntity)dmgSrc.func_76346_g() : this.field_70170_p.func_217359_a(field_213405_bO, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (crystal == this.field_70992_bH) {
            this.func_213403_a(this.field_70986_h, DamageSource.func_188405_b((LivingEntity)playerentity), 10.0f);
        }
        this.field_184677_bJ.func_188756_a().func_188655_a(crystal, pos, dmgSrc, playerentity);
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (field_184674_a.equals(key) && this.field_70170_p.field_72995_K) {
            this.field_184677_bJ.func_188758_a(PhaseType.func_188738_a((int)this.func_184212_Q().func_187225_a(field_184674_a)));
        }
        super.func_184206_a(key);
    }

    public PhaseManager func_184670_cT() {
        return this.field_184677_bJ;
    }

    @Nullable
    public DragonFightManager func_184664_cU() {
        return this.field_184676_bI;
    }

    @Override
    public boolean func_195064_c(EffectInstance p_195064_1_) {
        return false;
    }

    @Override
    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    @Override
    public boolean func_184222_aU() {
        return false;
    }
}

