/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.settings;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.IForgeKeybinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;

@OnlyIn(value=Dist.CLIENT)
public class KeyBinding
implements Comparable<KeyBinding>,
IForgeKeybinding {
    private static final Map<String, KeyBinding> field_74516_a = Maps.newHashMap();
    private static final KeyBindingMap field_74514_b = new KeyBindingMap();
    private static final Set<String> field_151473_c = Sets.newHashSet();
    private static final Map<String, Integer> field_193627_d = (Map)Util.func_200696_a((Object)Maps.newHashMap(), p_205215_0_ -> {
        p_205215_0_.put("key.categories.movement", 1);
        p_205215_0_.put("key.categories.gameplay", 2);
        p_205215_0_.put("key.categories.inventory", 3);
        p_205215_0_.put("key.categories.creative", 4);
        p_205215_0_.put("key.categories.multiplayer", 5);
        p_205215_0_.put("key.categories.ui", 6);
        p_205215_0_.put("key.categories.misc", 7);
    });
    private final String field_74515_c;
    private final InputMappings.Input field_151472_e;
    private final String field_151471_f;
    private InputMappings.Input field_74512_d;
    private boolean field_74513_e;
    private int field_151474_i;
    private KeyModifier keyModifierDefault = KeyModifier.NONE;
    private KeyModifier keyModifier = KeyModifier.NONE;
    private IKeyConflictContext keyConflictContext = KeyConflictContext.UNIVERSAL;

    public static void func_197981_a(InputMappings.Input key) {
        for (KeyBinding keybinding : field_74514_b.lookupAll(key)) {
            if (keybinding == null) continue;
            ++keybinding.field_151474_i;
        }
    }

    public static void func_197980_a(InputMappings.Input key, boolean held) {
        for (KeyBinding keybinding : field_74514_b.lookupAll(key)) {
            if (keybinding == null) continue;
            keybinding.field_74513_e = held;
        }
    }

    public static void func_186704_a() {
        for (KeyBinding keybinding : field_74516_a.values()) {
            if (keybinding.field_74512_d.func_197938_b() != InputMappings.Type.KEYSYM || keybinding.field_74512_d.func_197937_c() == InputMappings.field_197958_a.func_197937_c()) continue;
            keybinding.field_74513_e = InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)keybinding.field_74512_d.func_197937_c());
        }
    }

    public static void func_74506_a() {
        for (KeyBinding keybinding : field_74516_a.values()) {
            keybinding.func_74505_d();
        }
    }

    public static void func_74508_b() {
        field_74514_b.clearMap();
        for (KeyBinding keybinding : field_74516_a.values()) {
            field_74514_b.addKey(keybinding.field_74512_d, keybinding);
        }
    }

    public KeyBinding(String description, int keyCode, String category) {
        this(description, InputMappings.Type.KEYSYM, keyCode, category);
    }

    public KeyBinding(String description, InputMappings.Type type, int code, String category) {
        this.field_74515_c = description;
        this.field_151472_e = this.field_74512_d = type.func_197944_a(code);
        this.field_151471_f = category;
        field_74516_a.put(description, this);
        field_74514_b.addKey(this.field_74512_d, this);
        field_151473_c.add(category);
    }

    public boolean func_151470_d() {
        return this.field_74513_e && this.getKeyConflictContext().isActive() && this.getKeyModifier().isActive(this.getKeyConflictContext());
    }

    public String func_151466_e() {
        return this.field_151471_f;
    }

    public boolean func_151468_f() {
        if (this.field_151474_i == 0) {
            return false;
        }
        --this.field_151474_i;
        return true;
    }

    private void func_74505_d() {
        this.field_151474_i = 0;
        this.field_74513_e = false;
    }

    public String func_151464_g() {
        return this.field_74515_c;
    }

    public InputMappings.Input func_197977_i() {
        return this.field_151472_e;
    }

    public void func_197979_b(InputMappings.Input key) {
        this.field_74512_d = key;
    }

    @Override
    public int compareTo(KeyBinding p_compareTo_1_) {
        if (this.field_151471_f.equals(p_compareTo_1_.field_151471_f)) {
            return I18n.func_135052_a(this.field_74515_c, new Object[0]).compareTo(I18n.func_135052_a(p_compareTo_1_.field_74515_c, new Object[0]));
        }
        Integer tCat = field_193627_d.get(this.field_151471_f);
        Integer oCat = field_193627_d.get(p_compareTo_1_.field_151471_f);
        if (tCat == null && oCat != null) {
            return 1;
        }
        if (tCat != null && oCat == null) {
            return -1;
        }
        if (tCat == null && oCat == null) {
            return I18n.func_135052_a(this.field_151471_f, new Object[0]).compareTo(I18n.func_135052_a(p_compareTo_1_.field_151471_f, new Object[0]));
        }
        return tCat.compareTo(oCat);
    }

    public static Supplier<String> func_193626_b(String key) {
        KeyBinding keybinding = field_74516_a.get(key);
        return keybinding == null ? () -> key : keybinding::func_197978_k;
    }

    public boolean func_197983_b(KeyBinding binding) {
        if (this.getKeyConflictContext().conflicts(binding.getKeyConflictContext()) || binding.getKeyConflictContext().conflicts(this.getKeyConflictContext())) {
            KeyModifier keyModifier = this.getKeyModifier();
            KeyModifier otherKeyModifier = binding.getKeyModifier();
            if (keyModifier.matches(binding.getKey()) || otherKeyModifier.matches(this.getKey())) {
                return true;
            }
            if (this.getKey().equals((Object)binding.getKey())) {
                return keyModifier == otherKeyModifier || this.getKeyConflictContext().conflicts((IKeyConflictContext)KeyConflictContext.IN_GAME) && (keyModifier == KeyModifier.NONE || otherKeyModifier == KeyModifier.NONE);
            }
        }
        return this.field_74512_d.equals((Object)binding.field_74512_d);
    }

    public boolean func_197986_j() {
        return this.field_74512_d.equals((Object)InputMappings.field_197958_a);
    }

    public boolean func_197976_a(int keysym, int scancode) {
        if (keysym == InputMappings.field_197958_a.func_197937_c()) {
            return this.field_74512_d.func_197938_b() == InputMappings.Type.SCANCODE && this.field_74512_d.func_197937_c() == scancode;
        }
        return this.field_74512_d.func_197938_b() == InputMappings.Type.KEYSYM && this.field_74512_d.func_197937_c() == keysym;
    }

    public boolean func_197984_a(int key) {
        return this.field_74512_d.func_197938_b() == InputMappings.Type.MOUSE && this.field_74512_d.func_197937_c() == key;
    }

    public String func_197978_k() {
        return this.getKeyModifier().getLocalizedComboName(this.field_74512_d, () -> {
            String s = this.field_74512_d.func_197935_d();
            int i = this.field_74512_d.func_197937_c();
            String s1 = null;
            switch (this.field_74512_d.func_197938_b()) {
                case KEYSYM: {
                    s1 = InputMappings.func_216507_a((int)i);
                    break;
                }
                case SCANCODE: {
                    s1 = InputMappings.func_216502_b((int)i);
                    break;
                }
                case MOUSE: {
                    String s2 = I18n.func_135052_a(s, new Object[0]);
                    s1 = Objects.equals(s2, s) ? I18n.func_135052_a(InputMappings.Type.MOUSE.func_216500_a(), i + 1) : s2;
                }
            }
            return s1 == null ? I18n.func_135052_a(s, new Object[0]) : s1;
        });
    }

    public boolean func_197985_l() {
        return this.field_74512_d.equals((Object)this.field_151472_e) && this.getKeyModifier() == this.getKeyModifierDefault();
    }

    public String func_197982_m() {
        return this.field_74512_d.func_197935_d();
    }

    public KeyBinding(String description, IKeyConflictContext keyConflictContext, InputMappings.Type inputType, int keyCode, String category) {
        this(description, keyConflictContext, inputType.func_197944_a(keyCode), category);
    }

    public KeyBinding(String description, IKeyConflictContext keyConflictContext, InputMappings.Input keyCode, String category) {
        this(description, keyConflictContext, KeyModifier.NONE, keyCode, category);
    }

    public KeyBinding(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, InputMappings.Type inputType, int keyCode, String category) {
        this(description, keyConflictContext, keyModifier, inputType.func_197944_a(keyCode), category);
    }

    public KeyBinding(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, InputMappings.Input keyCode, String category) {
        this.field_74515_c = description;
        this.field_74512_d = keyCode;
        this.field_151472_e = keyCode;
        this.field_151471_f = category;
        this.keyConflictContext = keyConflictContext;
        this.keyModifier = keyModifier;
        this.keyModifierDefault = keyModifier;
        if (this.keyModifier.matches(keyCode)) {
            this.keyModifier = KeyModifier.NONE;
        }
        field_74516_a.put(description, this);
        field_74514_b.addKey(keyCode, this);
        field_151473_c.add(category);
    }

    public InputMappings.Input getKey() {
        return this.field_74512_d;
    }

    public void setKeyConflictContext(IKeyConflictContext keyConflictContext) {
        this.keyConflictContext = keyConflictContext;
    }

    public IKeyConflictContext getKeyConflictContext() {
        return this.keyConflictContext;
    }

    public KeyModifier getKeyModifierDefault() {
        return this.keyModifierDefault;
    }

    public KeyModifier getKeyModifier() {
        return this.keyModifier;
    }

    public void setKeyModifierAndCode(KeyModifier keyModifier, InputMappings.Input keyCode) {
        this.field_74512_d = keyCode;
        if (keyModifier.matches(keyCode)) {
            keyModifier = KeyModifier.NONE;
        }
        field_74514_b.removeKey(this);
        this.keyModifier = keyModifier;
        field_74514_b.addKey(keyCode, this);
    }
}

