/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.GlStateManager;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.network.LanServerInfo;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.ClientHooks;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ServerSelectionList
extends ExtendedList<Entry> {
    private static final Logger field_214357_a = LogManager.getLogger();
    private static final ThreadPoolExecutor field_214358_b = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_214357_a)).build());
    private static final ResourceLocation field_214359_c = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation field_214360_d = new ResourceLocation("textures/gui/server_selection.png");
    private final MultiplayerScreen field_148200_k;
    private final List<NormalEntry> field_148198_l = Lists.newArrayList();
    private final Entry field_148196_n = new LanScanEntry();
    private final List<LanDetectedEntry> field_148199_m = Lists.newArrayList();

    public ServerSelectionList(MultiplayerScreen ownerIn, Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
        super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        this.field_148200_k = ownerIn;
    }

    private void func_195094_h() {
        this.clearEntries();
        this.field_148198_l.forEach(arg_0 -> this.addEntry(arg_0));
        this.addEntry((AbstractList.AbstractListEntry)((Object)this.field_148196_n));
        this.field_148199_m.forEach(arg_0 -> this.addEntry(arg_0));
    }

    public void setSelected(Entry p_setSelected_1_) {
        super.setSelected((AbstractList.AbstractListEntry)((Object)p_setSelected_1_));
        if (this.getSelected() instanceof NormalEntry) {
            NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", ((NormalEntry)((NormalEntry)((Object)this.getSelected()))).field_148301_e.field_78847_a).getString());
        }
    }

    protected void moveSelection(int p_moveSelection_1_) {
        int i = this.children().indexOf(this.getSelected());
        int j = MathHelper.func_76125_a((int)(i + p_moveSelection_1_), (int)0, (int)(this.getItemCount() - 1));
        Entry serverselectionlist$entry = (Entry)((Object)this.children().get(j));
        super.setSelected((AbstractList.AbstractListEntry)((Object)serverselectionlist$entry));
        if (serverselectionlist$entry instanceof LanScanEntry) {
            if (!(p_moveSelection_1_ > 0 && j == this.getItemCount() - 1 || p_moveSelection_1_ < 0 && j == 0)) {
                this.moveSelection(p_moveSelection_1_);
            }
        } else {
            this.ensureVisible((AbstractList.AbstractListEntry)((Object)serverselectionlist$entry));
            this.field_148200_k.func_214295_b();
        }
    }

    public void func_148195_a(ServerList p_148195_1_) {
        this.field_148198_l.clear();
        for (int i = 0; i < p_148195_1_.func_78856_c(); ++i) {
            this.field_148198_l.add(new NormalEntry(this.field_148200_k, p_148195_1_.func_78850_a(i)));
        }
        this.func_195094_h();
    }

    public void func_148194_a(List<LanServerInfo> p_148194_1_) {
        this.field_148199_m.clear();
        for (LanServerInfo lanserverinfo : p_148194_1_) {
            this.field_148199_m.add(new LanDetectedEntry(this.field_148200_k, lanserverinfo));
        }
        this.func_195094_h();
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 30;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 85;
    }

    protected boolean isFocused() {
        return this.field_148200_k.getFocused() == this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class NormalEntry
    extends Entry {
        private final MultiplayerScreen field_148303_c;
        private final Minecraft field_148300_d;
        private final ServerData field_148301_e;
        private final ResourceLocation field_148306_i;
        private String field_148299_g;
        private DynamicTexture field_148305_h;
        private long field_148298_f;

        protected NormalEntry(MultiplayerScreen p_i50669_2_, ServerData p_i50669_3_) {
            this.field_148303_c = p_i50669_2_;
            this.field_148301_e = p_i50669_3_;
            this.field_148300_d = Minecraft.func_71410_x();
            this.field_148306_i = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)p_i50669_3_.field_78845_b) + "/icon");
            this.field_148305_h = (DynamicTexture)this.field_148300_d.func_110434_K().func_110581_b(this.field_148306_i);
        }

        public void render(int p_render_1_, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
            String s1;
            int l;
            if (!this.field_148301_e.field_78841_f) {
                this.field_148301_e.field_78841_f = true;
                this.field_148301_e.field_78844_e = -2L;
                this.field_148301_e.field_78843_d = "";
                this.field_148301_e.field_78846_c = "";
                field_214358_b.submit(() -> {
                    try {
                        this.field_148303_c.func_146789_i().func_147224_a(this.field_148301_e);
                    }
                    catch (UnknownHostException var2) {
                        this.field_148301_e.field_78844_e = -1L;
                        this.field_148301_e.field_78843_d = TextFormatting.DARK_RED + I18n.func_135052_a("multiplayer.status.cannot_resolve", new Object[0]);
                    }
                    catch (Exception var3) {
                        this.field_148301_e.field_78844_e = -1L;
                        this.field_148301_e.field_78843_d = TextFormatting.DARK_RED + I18n.func_135052_a("multiplayer.status.cannot_connect", new Object[0]);
                    }
                });
            }
            boolean flag = this.field_148301_e.field_82821_f > SharedConstants.func_215069_a().getProtocolVersion();
            boolean flag1 = this.field_148301_e.field_82821_f < SharedConstants.func_215069_a().getProtocolVersion();
            boolean flag2 = flag || flag1;
            this.field_148300_d.field_71466_p.func_211126_b(this.field_148301_e.field_78847_a, (float)(p_render_3_ + 32 + 3), (float)(p_render_2_ + 1), 0xFFFFFF);
            List list = this.field_148300_d.field_71466_p.func_78271_c(this.field_148301_e.field_78843_d, p_render_4_ - 32 - 2);
            for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                this.field_148300_d.field_71466_p.func_211126_b((String)list.get(i), (float)(p_render_3_ + 32 + 3), (float)(p_render_2_ + 12 + 9 * i), 0x808080);
            }
            String s2 = flag2 ? TextFormatting.DARK_RED + this.field_148301_e.field_82822_g : this.field_148301_e.field_78846_c;
            int j = this.field_148300_d.field_71466_p.func_78256_a(s2);
            this.field_148300_d.field_71466_p.func_211126_b(s2, (float)(p_render_3_ + p_render_4_ - j - 15 - 2), (float)(p_render_2_ + 1), 0x808080);
            int k = 0;
            String s = null;
            if (flag2) {
                l = 5;
                s1 = I18n.func_135052_a(flag ? "multiplayer.status.client_out_of_date" : "multiplayer.status.server_out_of_date", new Object[0]);
                s = this.field_148301_e.field_147412_i;
            } else if (this.field_148301_e.field_78841_f && this.field_148301_e.field_78844_e != -2L) {
                l = this.field_148301_e.field_78844_e < 0L ? 5 : (this.field_148301_e.field_78844_e < 150L ? 0 : (this.field_148301_e.field_78844_e < 300L ? 1 : (this.field_148301_e.field_78844_e < 600L ? 2 : (this.field_148301_e.field_78844_e < 1000L ? 3 : 4))));
                if (this.field_148301_e.field_78844_e < 0L) {
                    s1 = I18n.func_135052_a("multiplayer.status.no_connection", new Object[0]);
                } else {
                    s1 = this.field_148301_e.field_78844_e + "ms";
                    s = this.field_148301_e.field_147412_i;
                }
            } else {
                k = 1;
                l = (int)(Util.func_211177_b() / 100L + (long)(p_render_1_ * 2) & 7L);
                if (l > 4) {
                    l = 8 - l;
                }
                s1 = I18n.func_135052_a("multiplayer.status.pinging", new Object[0]);
            }
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_148300_d.func_110434_K().func_110577_a(AbstractGui.GUI_ICONS_LOCATION);
            AbstractGui.blit((int)(p_render_3_ + p_render_4_ - 15), (int)p_render_2_, (float)(k * 10), (float)(176 + l * 8), (int)10, (int)8, (int)256, (int)256);
            if (this.field_148301_e.func_147409_e() != null && !this.field_148301_e.func_147409_e().equals(this.field_148299_g)) {
                this.field_148299_g = this.field_148301_e.func_147409_e();
                this.func_148297_b();
                this.field_148303_c.func_146795_p().func_78855_b();
            }
            if (this.field_148305_h != null) {
                this.func_178012_a(p_render_3_, p_render_2_, this.field_148306_i);
            } else {
                this.func_178012_a(p_render_3_, p_render_2_, field_214359_c);
            }
            int i1 = p_render_6_ - p_render_3_;
            int j1 = p_render_7_ - p_render_2_;
            if (i1 >= p_render_4_ - 15 && i1 <= p_render_4_ - 5 && j1 >= 0 && j1 <= 8) {
                this.field_148303_c.func_146793_a(s1);
            } else if (i1 >= p_render_4_ - j - 15 - 2 && i1 <= p_render_4_ - 15 - 2 && j1 >= 0 && j1 <= 8) {
                this.field_148303_c.func_146793_a(s);
            }
            ClientHooks.drawForgePingInfo((MultiplayerScreen)this.field_148303_c, (ServerData)this.field_148301_e, (int)p_render_3_, (int)p_render_2_, (int)p_render_4_, (int)i1, (int)j1);
            if (this.field_148300_d.field_71474_y.field_85185_A || p_render_8_) {
                this.field_148300_d.func_110434_K().func_110577_a(field_214360_d);
                AbstractGui.fill((int)p_render_3_, (int)p_render_2_, (int)(p_render_3_ + 32), (int)(p_render_2_ + 32), (int)-1601138544);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int k1 = p_render_6_ - p_render_3_;
                int l1 = p_render_7_ - p_render_2_;
                if (this.func_178013_b()) {
                    if (k1 < 32 && k1 > 16) {
                        AbstractGui.blit((int)p_render_3_, (int)p_render_2_, (float)0.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                    } else {
                        AbstractGui.blit((int)p_render_3_, (int)p_render_2_, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                    }
                }
                if (p_render_1_ > 0) {
                    if (k1 < 16 && l1 < 16) {
                        AbstractGui.blit((int)p_render_3_, (int)p_render_2_, (float)96.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                    } else {
                        AbstractGui.blit((int)p_render_3_, (int)p_render_2_, (float)96.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                    }
                }
                if (p_render_1_ < this.field_148303_c.func_146795_p().func_78856_c() - 1) {
                    if (k1 < 16 && l1 > 16) {
                        AbstractGui.blit((int)p_render_3_, (int)p_render_2_, (float)64.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                    } else {
                        AbstractGui.blit((int)p_render_3_, (int)p_render_2_, (float)64.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                    }
                }
            }
        }

        protected void func_178012_a(int p_178012_1_, int p_178012_2_, ResourceLocation p_178012_3_) {
            this.field_148300_d.func_110434_K().func_110577_a(p_178012_3_);
            GlStateManager.enableBlend();
            AbstractGui.blit((int)p_178012_1_, (int)p_178012_2_, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            GlStateManager.disableBlend();
        }

        private boolean func_178013_b() {
            return true;
        }

        private void func_148297_b() {
            String s = this.field_148301_e.func_147409_e();
            if (s == null) {
                this.field_148300_d.func_110434_K().func_147645_c(this.field_148306_i);
                if (this.field_148305_h != null && this.field_148305_h.func_195414_e() != null) {
                    this.field_148305_h.func_195414_e().close();
                }
                this.field_148305_h = null;
            } else {
                try {
                    NativeImage nativeimage = NativeImage.func_216511_b((String)s);
                    Validate.validState((nativeimage.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((nativeimage.func_195714_b() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    if (this.field_148305_h == null) {
                        this.field_148305_h = new DynamicTexture(nativeimage);
                    } else {
                        this.field_148305_h.func_195415_a(nativeimage);
                        this.field_148305_h.func_110564_a();
                    }
                    this.field_148300_d.func_110434_K().func_110579_a(this.field_148306_i, (ITextureObject)this.field_148305_h);
                }
                catch (Throwable throwable) {
                    field_214357_a.error("Invalid icon for server {} ({})", (Object)this.field_148301_e.field_78847_a, (Object)this.field_148301_e.field_78845_b, (Object)throwable);
                    this.field_148301_e.func_147407_a(null);
                }
            }
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            double d0 = p_mouseClicked_1_ - (double)ServerSelectionList.this.getRowLeft();
            double d1 = p_mouseClicked_3_ - (double)ServerSelectionList.this.getRowTop(ServerSelectionList.this.children().indexOf((Object)this));
            if (d0 <= 32.0) {
                if (d0 < 32.0 && d0 > 16.0 && this.func_178013_b()) {
                    this.field_148303_c.func_214287_a((Entry)this);
                    this.field_148303_c.func_146796_h();
                    return true;
                }
                int i = this.field_148303_c.field_146803_h.children().indexOf((Object)this);
                if (d0 < 16.0 && d1 < 16.0 && i > 0) {
                    int k = Screen.hasShiftDown() ? 0 : i - 1;
                    this.field_148303_c.func_146795_p().func_78857_a(i, k);
                    if (this.field_148303_c.field_146803_h.getSelected() == this) {
                        this.field_148303_c.func_214287_a((Entry)this);
                    }
                    this.field_148303_c.field_146803_h.func_148195_a(this.field_148303_c.func_146795_p());
                    return true;
                }
                if (d0 < 16.0 && d1 > 16.0 && i < this.field_148303_c.func_146795_p().func_78856_c() - 1) {
                    ServerList serverlist = this.field_148303_c.func_146795_p();
                    int j = Screen.hasShiftDown() ? serverlist.func_78856_c() - 1 : i + 1;
                    serverlist.func_78857_a(i, j);
                    if (this.field_148303_c.field_146803_h.getSelected() == this) {
                        this.field_148303_c.func_214287_a((Entry)this);
                    }
                    this.field_148303_c.field_146803_h.func_148195_a(serverlist);
                    return true;
                }
            }
            this.field_148303_c.func_214287_a((Entry)this);
            if (Util.func_211177_b() - this.field_148298_f < 250L) {
                this.field_148303_c.func_146796_h();
            }
            this.field_148298_f = Util.func_211177_b();
            return false;
        }

        public ServerData func_148296_a() {
            return this.field_148301_e;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LanScanEntry
    extends Entry {
        private final Minecraft field_148288_a = Minecraft.func_71410_x();

        public void render(int p_render_1_, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
            String s;
            int i = p_render_2_ + p_render_5_ / 2 - 4;
            this.field_148288_a.field_71466_p.func_211126_b(I18n.func_135052_a("lanServer.scanning", new Object[0]), (float)(this.field_148288_a.field_71462_r.width / 2 - this.field_148288_a.field_71466_p.func_78256_a(I18n.func_135052_a("lanServer.scanning", new Object[0])) / 2), (float)i, 0xFFFFFF);
            switch ((int)(Util.func_211177_b() / 300L % 4L)) {
                default: {
                    s = "O o o";
                    break;
                }
                case 1: 
                case 3: {
                    s = "o O o";
                    break;
                }
                case 2: {
                    s = "o o O";
                }
            }
            this.field_148288_a.field_71466_p.func_211126_b(s, (float)(this.field_148288_a.field_71462_r.width / 2 - this.field_148288_a.field_71466_p.func_78256_a(s) / 2), (float)(i + 9), 0x808080);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LanDetectedEntry
    extends Entry {
        private final MultiplayerScreen field_148292_c;
        protected final Minecraft field_148293_a;
        protected final LanServerInfo field_148291_b;
        private long field_148290_d;

        protected LanDetectedEntry(MultiplayerScreen p_i47141_1_, LanServerInfo p_i47141_2_) {
            this.field_148292_c = p_i47141_1_;
            this.field_148291_b = p_i47141_2_;
            this.field_148293_a = Minecraft.func_71410_x();
        }

        public void render(int p_render_1_, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
            this.field_148293_a.field_71466_p.func_211126_b(I18n.func_135052_a("lanServer.title", new Object[0]), (float)(p_render_3_ + 32 + 3), (float)(p_render_2_ + 1), 0xFFFFFF);
            this.field_148293_a.field_71466_p.func_211126_b(this.field_148291_b.func_77487_a(), (float)(p_render_3_ + 32 + 3), (float)(p_render_2_ + 12), 0x808080);
            if (this.field_148293_a.field_71474_y.field_80005_w) {
                this.field_148293_a.field_71466_p.func_211126_b(I18n.func_135052_a("selectServer.hiddenAddress", new Object[0]), (float)(p_render_3_ + 32 + 3), (float)(p_render_2_ + 12 + 11), 0x303030);
            } else {
                this.field_148293_a.field_71466_p.func_211126_b(this.field_148291_b.func_77488_b(), (float)(p_render_3_ + 32 + 3), (float)(p_render_2_ + 12 + 11), 0x303030);
            }
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.field_148292_c.func_214287_a((Entry)this);
            if (Util.func_211177_b() - this.field_148290_d < 250L) {
                this.field_148292_c.func_146796_h();
            }
            this.field_148290_d = Util.func_211177_b();
            return false;
        }

        public LanServerInfo func_189995_a() {
            return this.field_148291_b;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ExtendedList.AbstractListEntry<Entry> {
    }
}

