/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public abstract class DisplayEffectsScreen<T extends Container>
extends ContainerScreen<T> {
    protected boolean field_147045_u;

    public DisplayEffectsScreen(T p_i51091_1_, PlayerInventory p_i51091_2_, ITextComponent p_i51091_3_) {
        super(p_i51091_1_, p_i51091_2_, p_i51091_3_);
    }

    @Override
    protected void init() {
        super.init();
        this.func_175378_g();
    }

    protected void func_175378_g() {
        if (this.minecraft.field_71439_g.func_70651_bq().isEmpty()) {
            this.field_147003_i = (this.width - this.field_146999_f) / 2;
            this.field_147045_u = false;
        } else {
            this.field_147003_i = MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.PotionShiftEvent((Screen)this)) ? (this.width - this.field_146999_f) / 2 : 160 + (this.width - this.field_146999_f - 200) / 2;
            this.field_147045_u = true;
        }
    }

    @Override
    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        super.render(p_render_1_, p_render_2_, p_render_3_);
        if (this.field_147045_u) {
            this.func_147044_g();
        }
    }

    private void func_147044_g() {
        int i = this.field_147003_i - 124;
        Collection<EffectInstance> collection = this.minecraft.field_71439_g.func_70651_bq();
        if (!collection.isEmpty()) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.disableLighting();
            int j = 33;
            if (collection.size() > 5) {
                j = 132 / (collection.size() - 1);
            }
            List iterable = Ordering.natural().sortedCopy(collection);
            this.func_214079_a(i, j, iterable);
            this.func_214077_b(i, j, iterable);
            this.func_214078_c(i, j, iterable);
        }
    }

    private void func_214079_a(int p_214079_1_, int p_214079_2_, Iterable<EffectInstance> p_214079_3_) {
        this.minecraft.func_110434_K().func_110577_a(field_147001_a);
        int i = this.field_147009_r;
        for (EffectInstance effectinstance : p_214079_3_) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.blit(p_214079_1_, i, 0, 166, 140, 32);
            i += p_214079_2_;
        }
    }

    private void func_214077_b(int p_214077_1_, int p_214077_2_, Iterable<EffectInstance> p_214077_3_) {
        this.minecraft.func_110434_K().func_110577_a(AtlasTexture.field_215264_i);
        PotionSpriteUploader potionspriteuploader = this.minecraft.func_213248_ap();
        int i = this.field_147009_r;
        for (EffectInstance effectinstance : p_214077_3_) {
            if (!effectinstance.func_188419_a().shouldRender(effectinstance)) continue;
            Effect effect = effectinstance.func_188419_a();
            DisplayEffectsScreen.blit((int)(p_214077_1_ + 6), (int)(i + 7), (int)this.blitOffset, (int)18, (int)18, (TextureAtlasSprite)potionspriteuploader.func_215288_a(effect));
            i += p_214077_2_;
        }
    }

    private void func_214078_c(int p_214078_1_, int p_214078_2_, Iterable<EffectInstance> p_214078_3_) {
        int i = this.field_147009_r;
        for (EffectInstance effectinstance : p_214078_3_) {
            if (!effectinstance.func_188419_a().shouldRender(effectinstance)) continue;
            effectinstance.func_188419_a().renderInventoryEffect(effectinstance, this, p_214078_1_, i, this.blitOffset);
            if (!effectinstance.func_188419_a().shouldRenderInvText(effectinstance)) {
                i += p_214078_2_;
                continue;
            }
            String s = I18n.func_135052_a(effectinstance.func_188419_a().func_76393_a(), new Object[0]);
            if (effectinstance.func_76458_c() >= 1 && effectinstance.func_76458_c() <= 9) {
                s = s + ' ' + I18n.func_135052_a("enchantment.level." + (effectinstance.func_76458_c() + 1), new Object[0]);
            }
            this.font.func_175063_a(s, (float)(p_214078_1_ + 10 + 18), (float)(i + 6), 0xFFFFFF);
            String s1 = EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)1.0f);
            this.font.func_175063_a(s1, (float)(p_214078_1_ + 10 + 18), (float)(i + 6 + 10), 0x7F7F7F);
            i += p_214078_2_;
        }
    }
}

