/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class LootingEnchantBonus
extends LootFunction {
    private final RandomValueRange field_186563_a;
    private final int field_189971_b;

    public LootingEnchantBonus(LootCondition[] conditions, RandomValueRange countIn, int limitIn) {
        super(conditions);
        this.field_186563_a = countIn;
        this.field_189971_b = limitIn;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        Entity entity = context.func_186492_c();
        if (entity instanceof EntityLivingBase) {
            int i = context.getLootingModifier();
            if (i == 0) {
                return stack;
            }
            float f = (float)i * this.field_186563_a.func_186507_b(rand);
            stack.func_190917_f(Math.round(f));
            if (this.field_189971_b != 0 && stack.func_190916_E() > this.field_189971_b) {
                stack.func_190920_e(this.field_189971_b);
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<LootingEnchantBonus> {
        protected Serializer() {
            super(new ResourceLocation("looting_enchant"), LootingEnchantBonus.class);
        }

        public void func_186532_a(JsonObject object, LootingEnchantBonus functionClazz, JsonSerializationContext serializationContext) {
            object.add("count", serializationContext.serialize((Object)functionClazz.field_186563_a));
            if (functionClazz.field_189971_b > 0) {
                object.add("limit", serializationContext.serialize((Object)functionClazz.field_189971_b));
            }
        }

        public LootingEnchantBonus func_186530_b(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            int i = JsonUtils.func_151208_a((JsonObject)object, (String)"limit", (int)0);
            return new LootingEnchantBonus(conditionsIn, (RandomValueRange)JsonUtils.func_188174_a((JsonObject)object, (String)"count", (JsonDeserializationContext)deserializationContext, RandomValueRange.class), i);
        }
    }
}

