/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WorldInfo {
    private String field_186349_b;
    private int field_186350_c;
    private boolean field_186351_d;
    public static final EnumDifficulty field_176156_a = EnumDifficulty.NORMAL;
    private long field_76100_a;
    private WorldType field_76098_b = WorldType.field_77137_b;
    private NBTTagCompound field_82576_c = new NBTTagCompound();
    @Nullable
    private String field_211931_h;
    private int field_76099_c;
    private int field_76096_d;
    private int field_76097_e;
    private long field_82575_g;
    private long field_76094_f;
    private long field_76095_g;
    private long field_76107_h;
    @Nullable
    private final DataFixer field_209226_o;
    private final int field_209227_p;
    private boolean field_209228_q;
    private NBTTagCompound field_76108_i;
    private int field_76105_j;
    private String field_76106_k;
    private int field_76103_l;
    private int field_176157_p;
    private boolean field_76104_m;
    private int field_76101_n;
    private boolean field_76102_o;
    private int field_76114_p;
    private GameType field_76113_q;
    private boolean field_76112_r;
    private boolean field_76111_s;
    private boolean field_76110_t;
    private boolean field_76109_u;
    private EnumDifficulty field_176158_z;
    private boolean field_176150_A;
    private double field_176151_B;
    private double field_176152_C;
    private double field_176146_D = 6.0E7;
    private long field_176147_E;
    private double field_176148_F;
    private double field_176149_G = 5.0;
    private double field_176153_H = 0.2;
    private int field_176154_I = 5;
    private int field_176155_J = 15;
    private final Set<String> field_197721_N = Sets.newHashSet();
    private final Set<String> field_197722_O = Sets.newLinkedHashSet();
    private final Map<DimensionType, NBTTagCompound> field_186348_N = Maps.newIdentityHashMap();
    private NBTTagCompound field_201358_Q;
    private final GameRules field_82577_x = new GameRules();

    protected WorldInfo() {
        this.field_209226_o = null;
        this.field_209227_p = 1631;
        this.func_212242_b(new NBTTagCompound());
    }

    public WorldInfo(NBTTagCompound p_i49564_1_, DataFixer p_i49564_2_, int p_i49564_3_, @Nullable NBTTagCompound p_i49564_4_) {
        this.field_209226_o = p_i49564_2_;
        if (p_i49564_1_.func_150297_b("Version", 10)) {
            NBTTagCompound nbttagcompound = p_i49564_1_.func_74775_l("Version");
            this.field_186349_b = nbttagcompound.func_74779_i("Name");
            this.field_186350_c = nbttagcompound.func_74762_e("Id");
            this.field_186351_d = nbttagcompound.func_74767_n("Snapshot");
        }
        this.field_76100_a = p_i49564_1_.func_74763_f("RandomSeed");
        if (p_i49564_1_.func_150297_b("generatorName", 8)) {
            String s1 = p_i49564_1_.func_74779_i("generatorName");
            this.field_76098_b = WorldType.func_77130_a(s1);
            if (this.field_76098_b == null) {
                this.field_76098_b = WorldType.field_77137_b;
            } else if (this.field_76098_b == WorldType.field_180271_f) {
                this.field_211931_h = p_i49564_1_.func_74779_i("generatorOptions");
            } else if (this.field_76098_b.func_77125_e()) {
                int i = 0;
                if (p_i49564_1_.func_150297_b("generatorVersion", 99)) {
                    i = p_i49564_1_.func_74762_e("generatorVersion");
                }
                this.field_76098_b = this.field_76098_b.func_77132_a(i);
            }
            this.func_212242_b(p_i49564_1_.func_74775_l("generatorOptions"));
        }
        this.field_76113_q = GameType.func_77146_a((int)p_i49564_1_.func_74762_e("GameType"));
        if (p_i49564_1_.func_150297_b("legacy_custom_options", 8)) {
            this.field_211931_h = p_i49564_1_.func_74779_i("legacy_custom_options");
        }
        this.field_76112_r = p_i49564_1_.func_150297_b("MapFeatures", 99) ? p_i49564_1_.func_74767_n("MapFeatures") : true;
        this.field_76099_c = p_i49564_1_.func_74762_e("SpawnX");
        this.field_76096_d = p_i49564_1_.func_74762_e("SpawnY");
        this.field_76097_e = p_i49564_1_.func_74762_e("SpawnZ");
        this.field_82575_g = p_i49564_1_.func_74763_f("Time");
        this.field_76094_f = p_i49564_1_.func_150297_b("DayTime", 99) ? p_i49564_1_.func_74763_f("DayTime") : this.field_82575_g;
        this.field_76095_g = p_i49564_1_.func_74763_f("LastPlayed");
        this.field_76107_h = p_i49564_1_.func_74763_f("SizeOnDisk");
        this.field_76106_k = p_i49564_1_.func_74779_i("LevelName");
        this.field_76103_l = p_i49564_1_.func_74762_e("version");
        this.field_176157_p = p_i49564_1_.func_74762_e("clearWeatherTime");
        this.field_76101_n = p_i49564_1_.func_74762_e("rainTime");
        this.field_76104_m = p_i49564_1_.func_74767_n("raining");
        this.field_76114_p = p_i49564_1_.func_74762_e("thunderTime");
        this.field_76102_o = p_i49564_1_.func_74767_n("thundering");
        this.field_76111_s = p_i49564_1_.func_74767_n("hardcore");
        this.field_76109_u = p_i49564_1_.func_150297_b("initialized", 99) ? p_i49564_1_.func_74767_n("initialized") : true;
        this.field_76110_t = p_i49564_1_.func_150297_b("allowCommands", 99) ? p_i49564_1_.func_74767_n("allowCommands") : this.field_76113_q == GameType.CREATIVE;
        this.field_209227_p = p_i49564_3_;
        if (p_i49564_4_ != null) {
            this.field_76108_i = p_i49564_4_;
        }
        if (p_i49564_1_.func_150297_b("GameRules", 10)) {
            this.field_82577_x.func_82768_a(p_i49564_1_.func_74775_l("GameRules"));
        }
        if (p_i49564_1_.func_150297_b("Difficulty", 99)) {
            this.field_176158_z = EnumDifficulty.func_151523_a((int)p_i49564_1_.func_74771_c("Difficulty"));
        }
        if (p_i49564_1_.func_150297_b("DifficultyLocked", 1)) {
            this.field_176150_A = p_i49564_1_.func_74767_n("DifficultyLocked");
        }
        if (p_i49564_1_.func_150297_b("BorderCenterX", 99)) {
            this.field_176151_B = p_i49564_1_.func_74769_h("BorderCenterX");
        }
        if (p_i49564_1_.func_150297_b("BorderCenterZ", 99)) {
            this.field_176152_C = p_i49564_1_.func_74769_h("BorderCenterZ");
        }
        if (p_i49564_1_.func_150297_b("BorderSize", 99)) {
            this.field_176146_D = p_i49564_1_.func_74769_h("BorderSize");
        }
        if (p_i49564_1_.func_150297_b("BorderSizeLerpTime", 99)) {
            this.field_176147_E = p_i49564_1_.func_74763_f("BorderSizeLerpTime");
        }
        if (p_i49564_1_.func_150297_b("BorderSizeLerpTarget", 99)) {
            this.field_176148_F = p_i49564_1_.func_74769_h("BorderSizeLerpTarget");
        }
        if (p_i49564_1_.func_150297_b("BorderSafeZone", 99)) {
            this.field_176149_G = p_i49564_1_.func_74769_h("BorderSafeZone");
        }
        if (p_i49564_1_.func_150297_b("BorderDamagePerBlock", 99)) {
            this.field_176153_H = p_i49564_1_.func_74769_h("BorderDamagePerBlock");
        }
        if (p_i49564_1_.func_150297_b("BorderWarningBlocks", 99)) {
            this.field_176154_I = p_i49564_1_.func_74762_e("BorderWarningBlocks");
        }
        if (p_i49564_1_.func_150297_b("BorderWarningTime", 99)) {
            this.field_176155_J = p_i49564_1_.func_74762_e("BorderWarningTime");
        }
        if (p_i49564_1_.func_150297_b("DimensionData", 10)) {
            NBTTagCompound nbttagcompound1 = p_i49564_1_.func_74775_l("DimensionData");
            for (String s : nbttagcompound1.func_150296_c()) {
                this.field_186348_N.put(DimensionType.func_186069_a(Integer.parseInt(s)), nbttagcompound1.func_74775_l(s));
            }
        }
        if (p_i49564_1_.func_150297_b("DataPacks", 10)) {
            NBTTagCompound nbttagcompound2 = p_i49564_1_.func_74775_l("DataPacks");
            NBTTagList nbttaglist = nbttagcompound2.func_150295_c("Disabled", 8);
            for (int k = 0; k < nbttaglist.size(); ++k) {
                this.field_197721_N.add(nbttaglist.func_150307_f(k));
            }
            NBTTagList nbttaglist1 = nbttagcompound2.func_150295_c("Enabled", 8);
            for (int j = 0; j < nbttaglist1.size(); ++j) {
                this.field_197722_O.add(nbttaglist1.func_150307_f(j));
            }
        }
        if (p_i49564_1_.func_150297_b("CustomBossEvents", 10)) {
            this.field_201358_Q = p_i49564_1_.func_74775_l("CustomBossEvents");
        }
    }

    public WorldInfo(WorldSettings settings, String name) {
        this.field_209226_o = null;
        this.field_209227_p = 1631;
        this.func_176127_a(settings);
        this.field_76106_k = name;
        this.field_176158_z = field_176156_a;
        this.field_76109_u = false;
    }

    public void func_176127_a(WorldSettings settings) {
        this.field_76100_a = settings.func_77160_d();
        this.field_76113_q = settings.func_77162_e();
        this.field_76112_r = settings.func_77164_g();
        this.field_76111_s = settings.func_77158_f();
        this.field_76098_b = settings.func_77165_h();
        this.func_212242_b((NBTTagCompound)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)NBTDynamicOps.field_210820_a, (Object)settings.func_205391_j()));
        this.field_76110_t = settings.func_77163_i();
    }

    public NBTTagCompound func_76082_a(@Nullable NBTTagCompound nbt) {
        this.func_209225_Q();
        if (nbt == null) {
            nbt = this.field_76108_i;
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_76064_a(nbttagcompound, nbt);
        return nbttagcompound;
    }

    private void func_76064_a(NBTTagCompound nbt, NBTTagCompound playerNbt) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74778_a("Name", "1.13.2");
        nbttagcompound.func_74768_a("Id", 1631);
        nbttagcompound.func_74757_a("Snapshot", false);
        nbt.func_74782_a("Version", nbttagcompound);
        nbt.func_74768_a("DataVersion", 1631);
        nbt.func_74772_a("RandomSeed", this.field_76100_a);
        nbt.func_74778_a("generatorName", this.field_76098_b.func_211889_b());
        nbt.func_74768_a("generatorVersion", this.field_76098_b.func_77131_c());
        if (!this.field_82576_c.isEmpty()) {
            nbt.func_74782_a("generatorOptions", this.field_82576_c);
        }
        if (this.field_211931_h != null) {
            nbt.func_74778_a("legacy_custom_options", this.field_211931_h);
        }
        nbt.func_74768_a("GameType", this.field_76113_q.func_77148_a());
        nbt.func_74757_a("MapFeatures", this.field_76112_r);
        nbt.func_74768_a("SpawnX", this.field_76099_c);
        nbt.func_74768_a("SpawnY", this.field_76096_d);
        nbt.func_74768_a("SpawnZ", this.field_76097_e);
        nbt.func_74772_a("Time", this.field_82575_g);
        nbt.func_74772_a("DayTime", this.field_76094_f);
        nbt.func_74772_a("SizeOnDisk", this.field_76107_h);
        nbt.func_74772_a("LastPlayed", Util.func_211179_d());
        nbt.func_74778_a("LevelName", this.field_76106_k);
        nbt.func_74768_a("version", this.field_76103_l);
        nbt.func_74768_a("clearWeatherTime", this.field_176157_p);
        nbt.func_74768_a("rainTime", this.field_76101_n);
        nbt.func_74757_a("raining", this.field_76104_m);
        nbt.func_74768_a("thunderTime", this.field_76114_p);
        nbt.func_74757_a("thundering", this.field_76102_o);
        nbt.func_74757_a("hardcore", this.field_76111_s);
        nbt.func_74757_a("allowCommands", this.field_76110_t);
        nbt.func_74757_a("initialized", this.field_76109_u);
        nbt.func_74780_a("BorderCenterX", this.field_176151_B);
        nbt.func_74780_a("BorderCenterZ", this.field_176152_C);
        nbt.func_74780_a("BorderSize", this.field_176146_D);
        nbt.func_74772_a("BorderSizeLerpTime", this.field_176147_E);
        nbt.func_74780_a("BorderSafeZone", this.field_176149_G);
        nbt.func_74780_a("BorderDamagePerBlock", this.field_176153_H);
        nbt.func_74780_a("BorderSizeLerpTarget", this.field_176148_F);
        nbt.func_74780_a("BorderWarningBlocks", this.field_176154_I);
        nbt.func_74780_a("BorderWarningTime", this.field_176155_J);
        if (this.field_176158_z != null) {
            nbt.func_74774_a("Difficulty", (byte)this.field_176158_z.func_151525_a());
        }
        nbt.func_74757_a("DifficultyLocked", this.field_176150_A);
        nbt.func_74782_a("GameRules", this.field_82577_x.func_82770_a());
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        for (Map.Entry<DimensionType, NBTTagCompound> entry : this.field_186348_N.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            nbttagcompound1.func_74782_a(String.valueOf(entry.getKey().func_186068_a()), entry.getValue());
        }
        nbt.func_74782_a("DimensionData", nbttagcompound1);
        if (playerNbt != null) {
            nbt.func_74782_a("Player", playerNbt);
        }
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        for (String s : this.field_197722_O) {
            nbttaglist.add((INBTBase)new NBTTagString(s));
        }
        nbttagcompound2.func_74782_a("Enabled", (INBTBase)nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (String s1 : this.field_197721_N) {
            nbttaglist1.add((INBTBase)new NBTTagString(s1));
        }
        nbttagcompound2.func_74782_a("Disabled", (INBTBase)nbttaglist1);
        nbt.func_74782_a("DataPacks", nbttagcompound2);
        if (this.field_201358_Q != null) {
            nbt.func_74782_a("CustomBossEvents", this.field_201358_Q);
        }
    }

    public long func_76063_b() {
        return this.field_76100_a;
    }

    public int func_76079_c() {
        return this.field_76099_c;
    }

    public int func_76075_d() {
        return this.field_76096_d;
    }

    public int func_76074_e() {
        return this.field_76097_e;
    }

    public long func_82573_f() {
        return this.field_82575_g;
    }

    public long func_76073_f() {
        return this.field_76094_f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_76092_g() {
        return this.field_76107_h;
    }

    private void func_209225_Q() {
        if (!this.field_209228_q && this.field_76108_i != null) {
            if (this.field_209227_p < 1631) {
                if (this.field_209226_o == null) {
                    throw new NullPointerException("Fixer Upper not set inside LevelData, and the player tag is not upgraded.");
                }
                this.field_76108_i = NBTUtil.func_210822_a((DataFixer)this.field_209226_o, (DSL.TypeReference)DataFixTypes.PLAYER, (NBTTagCompound)this.field_76108_i, (int)this.field_209227_p);
            }
            this.field_76105_j = this.field_76108_i.func_74762_e("Dimension");
            this.field_209228_q = true;
        }
    }

    public NBTTagCompound func_76072_h() {
        this.func_209225_Q();
        return this.field_76108_i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_202836_i() {
        this.func_209225_Q();
        return this.field_76105_j;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_76058_a(int x) {
        this.field_76099_c = x;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_76056_b(int y) {
        this.field_76096_d = y;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_76087_c(int z) {
        this.field_76097_e = z;
    }

    public void func_82572_b(long time) {
        this.field_82575_g = time;
    }

    public void func_76068_b(long time) {
        this.field_76094_f = time;
    }

    public void func_176143_a(BlockPos spawnPoint) {
        this.field_76099_c = spawnPoint.func_177958_n();
        this.field_76096_d = spawnPoint.func_177956_o();
        this.field_76097_e = spawnPoint.func_177952_p();
    }

    public String func_76065_j() {
        return this.field_76106_k;
    }

    public void func_76062_a(String worldName) {
        this.field_76106_k = worldName;
    }

    public int func_76088_k() {
        return this.field_76103_l;
    }

    public void func_76078_e(int version) {
        this.field_76103_l = version;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_76057_l() {
        return this.field_76095_g;
    }

    public int func_176133_A() {
        return this.field_176157_p;
    }

    public void func_176142_i(int cleanWeatherTimeIn) {
        this.field_176157_p = cleanWeatherTimeIn;
    }

    public boolean func_76061_m() {
        return this.field_76102_o;
    }

    public void func_76069_a(boolean thunderingIn) {
        this.field_76102_o = thunderingIn;
    }

    public int func_76071_n() {
        return this.field_76114_p;
    }

    public void func_76090_f(int time) {
        this.field_76114_p = time;
    }

    public boolean func_76059_o() {
        return this.field_76104_m;
    }

    public void func_76084_b(boolean isRaining) {
        this.field_76104_m = isRaining;
    }

    public int func_76083_p() {
        return this.field_76101_n;
    }

    public void func_76080_g(int time) {
        this.field_76101_n = time;
    }

    public GameType func_76077_q() {
        return this.field_76113_q;
    }

    public boolean func_76089_r() {
        return this.field_76112_r;
    }

    public void func_176128_f(boolean enabled) {
        this.field_76112_r = enabled;
    }

    public void func_76060_a(GameType type) {
        this.field_76113_q = type;
    }

    public boolean func_76093_s() {
        return this.field_76111_s;
    }

    public void func_176119_g(boolean hardcoreIn) {
        this.field_76111_s = hardcoreIn;
    }

    public WorldType func_76067_t() {
        return this.field_76098_b;
    }

    public void func_76085_a(WorldType type) {
        this.field_76098_b = type;
    }

    public NBTTagCompound func_211027_A() {
        return this.field_82576_c;
    }

    public void func_212242_b(NBTTagCompound p_212242_1_) {
        this.field_82576_c = p_212242_1_;
    }

    public boolean func_76086_u() {
        return this.field_76110_t;
    }

    public void func_176121_c(boolean allow) {
        this.field_76110_t = allow;
    }

    public boolean func_76070_v() {
        return this.field_76109_u;
    }

    public void func_76091_d(boolean initializedIn) {
        this.field_76109_u = initializedIn;
    }

    public GameRules func_82574_x() {
        return this.field_82577_x;
    }

    public double func_176120_C() {
        return this.field_176151_B;
    }

    public double func_176126_D() {
        return this.field_176152_C;
    }

    public double func_176137_E() {
        return this.field_176146_D;
    }

    public void func_176145_a(double size) {
        this.field_176146_D = size;
    }

    public long func_176134_F() {
        return this.field_176147_E;
    }

    public void func_176135_e(long time) {
        this.field_176147_E = time;
    }

    public double func_176132_G() {
        return this.field_176148_F;
    }

    public void func_176118_b(double lerpSize) {
        this.field_176148_F = lerpSize;
    }

    public void func_176141_c(double posZ) {
        this.field_176152_C = posZ;
    }

    public void func_176124_d(double posX) {
        this.field_176151_B = posX;
    }

    public double func_176138_H() {
        return this.field_176149_G;
    }

    public void func_176129_e(double amount) {
        this.field_176149_G = amount;
    }

    public double func_176140_I() {
        return this.field_176153_H;
    }

    public void func_176125_f(double damage) {
        this.field_176153_H = damage;
    }

    public int func_176131_J() {
        return this.field_176154_I;
    }

    public int func_176139_K() {
        return this.field_176155_J;
    }

    public void func_176122_j(int amountOfBlocks) {
        this.field_176154_I = amountOfBlocks;
    }

    public void func_176136_k(int ticks) {
        this.field_176155_J = ticks;
    }

    public EnumDifficulty func_176130_y() {
        return this.field_176158_z;
    }

    public void func_176144_a(EnumDifficulty newDifficulty) {
        this.field_176158_z = newDifficulty;
    }

    public boolean func_176123_z() {
        return this.field_176150_A;
    }

    public void func_180783_e(boolean locked) {
        this.field_176150_A = locked;
    }

    public void func_85118_a(CrashReportCategory category) {
        category.func_189529_a("Level seed", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(this.func_76063_b())));
        category.func_189529_a("Level generator", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.format("ID %02d - %s, ver %d. Features enabled: %b", this.field_76098_b.func_82747_f(), this.field_76098_b.func_211888_a(), this.field_76098_b.func_77131_c(), this.field_76112_r)));
        category.func_189529_a("Level generator options", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_82576_c.toString()));
        category.func_189529_a("Level spawn location", (ICrashReportDetail<String>)((ICrashReportDetail)() -> CrashReportCategory.func_184876_a(this.field_76099_c, this.field_76096_d, this.field_76097_e)));
        category.func_189529_a("Level time", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.format("%d game time, %d day time", this.field_82575_g, this.field_76094_f)));
        category.func_189529_a("Level dimension", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(this.field_76105_j)));
        category.func_189529_a("Level storage version", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
            String s = "Unknown?";
            try {
                switch (this.field_76103_l) {
                    case 19132: {
                        s = "McRegion";
                        break;
                    }
                    case 19133: {
                        s = "Anvil";
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return String.format("0x%05X - %s", this.field_76103_l, s);
        }));
        category.func_189529_a("Level weather", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.format("Rain time: %d (now: %b), thunder time: %d (now: %b)", this.field_76101_n, this.field_76104_m, this.field_76114_p, this.field_76102_o)));
        category.func_189529_a("Level game mode", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.format("Game mode: %s (ID %d). Hardcore: %b. Cheats: %b", this.field_76113_q.func_77149_b(), this.field_76113_q.func_77148_a(), this.field_76111_s, this.field_76110_t)));
    }

    public NBTTagCompound func_186347_a(DimensionType dimensionIn) {
        NBTTagCompound nbttagcompound = this.field_186348_N.get((Object)dimensionIn);
        return nbttagcompound == null ? new NBTTagCompound() : nbttagcompound;
    }

    public void func_186345_a(DimensionType dimensionIn, NBTTagCompound compound) {
        this.field_186348_N.put(dimensionIn, compound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_186344_K() {
        return this.field_186350_c;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_186343_L() {
        return this.field_186351_d;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_186346_M() {
        return this.field_186349_b;
    }

    public Set<String> func_197719_N() {
        return this.field_197721_N;
    }

    public Set<String> func_197720_O() {
        return this.field_197722_O;
    }

    @Nullable
    public NBTTagCompound func_201357_P() {
        return this.field_201358_Q;
    }

    public void func_201356_c(@Nullable NBTTagCompound p_201356_1_) {
        this.field_201358_Q = p_201356_1_;
    }
}

