/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CanopyTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final IBlockState field_181640_a = Blocks.field_196623_P.func_176223_P();
    private static final IBlockState field_181641_b = Blocks.field_196574_ab.func_176223_P();

    public CanopyTreeFeature(boolean notify) {
        super(notify);
    }

    @Override
    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorld worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(3) + rand.nextInt(2) + 6;
        int j = position.func_177958_n();
        int k = position.func_177956_o();
        int l = position.func_177952_p();
        if (k >= 1 && k + i + 1 < 256) {
            BlockPos blockpos = position.func_177977_b();
            Block block = worldIn.func_180495_p(blockpos).func_177230_c();
            boolean isSoil = worldIn.func_180495_p(blockpos).canSustainPlant((IBlockReader)worldIn, blockpos, EnumFacing.UP, (BlockSapling)Blocks.field_196680_y);
            if (!isSoil) {
                return false;
            }
            if (!this.func_181638_a((IBlockReader)worldIn, position, i)) {
                return false;
            }
            this.setDirtAt(worldIn, blockpos, blockpos.func_177984_a());
            this.setDirtAt(worldIn, blockpos.func_177974_f(), blockpos.func_177984_a());
            this.setDirtAt(worldIn, blockpos.func_177968_d(), blockpos.func_177984_a());
            this.setDirtAt(worldIn, blockpos.func_177968_d().func_177974_f(), blockpos.func_177984_a());
            EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
            int i1 = i - rand.nextInt(4);
            int j1 = 2 - rand.nextInt(3);
            int k1 = j;
            int l1 = l;
            int i2 = k + i - 1;
            for (int j2 = 0; j2 < i; ++j2) {
                int k2;
                BlockPos blockpos1;
                IBlockState iblockstate;
                if (j2 >= i1 && j1 > 0) {
                    k1 += enumfacing.func_82601_c();
                    l1 += enumfacing.func_82599_e();
                    --j1;
                }
                if (!(iblockstate = worldIn.func_180495_p(blockpos1 = new BlockPos(k1, k2 = k + j2, l1))).isAir((IBlockReader)worldIn, blockpos1) && !iblockstate.func_203425_a(BlockTags.field_206952_E)) continue;
                this.func_208533_a(changedBlocks, worldIn, blockpos1);
                this.func_208533_a(changedBlocks, worldIn, blockpos1.func_177974_f());
                this.func_208533_a(changedBlocks, worldIn, blockpos1.func_177968_d());
                this.func_208533_a(changedBlocks, worldIn, blockpos1.func_177974_f().func_177968_d());
            }
            for (int i3 = -2; i3 <= 0; ++i3) {
                for (int l3 = -2; l3 <= 0; ++l3) {
                    int k4 = -1;
                    this.func_202414_a(worldIn, k1 + i3, i2 + k4, l1 + l3);
                    this.func_202414_a(worldIn, 1 + k1 - i3, i2 + k4, l1 + l3);
                    this.func_202414_a(worldIn, k1 + i3, i2 + k4, 1 + l1 - l3);
                    this.func_202414_a(worldIn, 1 + k1 - i3, i2 + k4, 1 + l1 - l3);
                    if (i3 <= -2 && l3 <= -1 || i3 == -1 && l3 == -2) continue;
                    k4 = 1;
                    this.func_202414_a(worldIn, k1 + i3, i2 + k4, l1 + l3);
                    this.func_202414_a(worldIn, 1 + k1 - i3, i2 + k4, l1 + l3);
                    this.func_202414_a(worldIn, k1 + i3, i2 + k4, 1 + l1 - l3);
                    this.func_202414_a(worldIn, 1 + k1 - i3, i2 + k4, 1 + l1 - l3);
                }
            }
            if (rand.nextBoolean()) {
                this.func_202414_a(worldIn, k1, i2 + 2, l1);
                this.func_202414_a(worldIn, k1 + 1, i2 + 2, l1);
                this.func_202414_a(worldIn, k1 + 1, i2 + 2, l1 + 1);
                this.func_202414_a(worldIn, k1, i2 + 2, l1 + 1);
            }
            for (int j3 = -3; j3 <= 4; ++j3) {
                for (int i4 = -3; i4 <= 4; ++i4) {
                    if (j3 == -3 && i4 == -3 || j3 == -3 && i4 == 4 || j3 == 4 && i4 == -3 || j3 == 4 && i4 == 4 || Math.abs(j3) >= 3 && Math.abs(i4) >= 3) continue;
                    this.func_202414_a(worldIn, k1 + j3, i2, l1 + i4);
                }
            }
            for (int k3 = -1; k3 <= 2; ++k3) {
                for (int j4 = -1; j4 <= 2; ++j4) {
                    if (k3 >= 0 && k3 <= 1 && j4 >= 0 && j4 <= 1 || rand.nextInt(3) > 0) continue;
                    int l4 = rand.nextInt(3) + 2;
                    for (int i5 = 0; i5 < l4; ++i5) {
                        this.func_208533_a(changedBlocks, worldIn, new BlockPos(j + k3, i2 - i5 - 1, l + j4));
                    }
                    for (int j5 = -1; j5 <= 1; ++j5) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            this.func_202414_a(worldIn, k1 + k3 + j5, i2, l1 + j4 + l2);
                        }
                    }
                    for (int k5 = -2; k5 <= 2; ++k5) {
                        for (int l5 = -2; l5 <= 2; ++l5) {
                            if (Math.abs(k5) == 2 && Math.abs(l5) == 2) continue;
                            this.func_202414_a(worldIn, k1 + k3 + k5, i2 - 1, l1 + j4 + l5);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean func_181638_a(IBlockReader worldIn, BlockPos pos, int height) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l = 0; l <= height + 1; ++l) {
            int i1 = 1;
            if (l == 0) {
                i1 = 0;
            }
            if (l >= height - 1) {
                i1 = 2;
            }
            for (int j1 = -i1; j1 <= i1; ++j1) {
                for (int k1 = -i1; k1 <= i1; ++k1) {
                    if (this.canGrowInto(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(i + j1, j + l, k + k1))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void func_208533_a(Set<BlockPos> p_208533_1_, IWorld p_208533_2_, BlockPos p_208533_3_) {
        if (this.canGrowInto((IBlockReader)p_208533_2_, p_208533_3_)) {
            this.func_208520_a(p_208533_1_, p_208533_2_, p_208533_3_, field_181640_a);
        }
    }

    private void func_202414_a(IWorld p_202414_1_, int p_202414_2_, int p_202414_3_, int p_202414_4_) {
        BlockPos blockpos = new BlockPos(p_202414_2_, p_202414_3_, p_202414_4_);
        if (p_202414_1_.func_180495_p(blockpos).isAir((IBlockReader)p_202414_1_, blockpos)) {
            this.func_202278_a(p_202414_1_, blockpos, field_181641_b);
        }
    }
}

