/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.PhantomSpawner;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.AbstractChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.SwampHutStructure;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkGeneratorOverworld
extends AbstractChunkGenerator<OverworldGenSettings> {
    private static final Logger field_202111_e = LogManager.getLogger();
    private NoiseGeneratorOctaves field_185991_j;
    private NoiseGeneratorOctaves field_185992_k;
    private NoiseGeneratorOctaves field_185993_l;
    private NoiseGeneratorPerlin field_185994_m;
    private final OverworldGenSettings field_186000_s;
    private NoiseGeneratorOctaves field_185983_b;
    private NoiseGeneratorOctaves field_185984_c;
    private final WorldType field_185997_p;
    private final float[] field_185999_r;
    private final PhantomSpawner field_203230_r = new PhantomSpawner();
    private final IBlockState field_205475_r;
    private final IBlockState field_205476_s;

    public ChunkGeneratorOverworld(IWorld worldIn, BiomeProvider provider, OverworldGenSettings settingsIn) {
        super(worldIn, provider);
        this.field_185997_p = worldIn.func_72912_H().func_76067_t();
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom(this.field_202096_b);
        this.field_185991_j = new NoiseGeneratorOctaves((Random)sharedseedrandom, 16);
        this.field_185992_k = new NoiseGeneratorOctaves((Random)sharedseedrandom, 16);
        this.field_185993_l = new NoiseGeneratorOctaves((Random)sharedseedrandom, 8);
        this.field_185994_m = new NoiseGeneratorPerlin((Random)sharedseedrandom, 4);
        this.field_185983_b = new NoiseGeneratorOctaves((Random)sharedseedrandom, 10);
        this.field_185984_c = new NoiseGeneratorOctaves((Random)sharedseedrandom, 16);
        this.field_185999_r = new float[25];
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                this.field_185999_r[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
        this.field_186000_s = settingsIn;
        this.field_205475_r = this.field_186000_s.func_205532_l();
        this.field_205476_s = this.field_186000_s.func_205533_m();
        InitNoiseGensEvent.ContextOverworld ctx = new InitNoiseGensEvent.ContextOverworld(this.field_185991_j, this.field_185992_k, this.field_185993_l, this.field_185994_m, this.field_185983_b, this.field_185984_c);
        ctx = (InitNoiseGensEvent.ContextOverworld)TerrainGen.getModdedNoiseGenerators((IWorld)worldIn, (Random)sharedseedrandom, (InitNoiseGensEvent.Context)ctx);
        this.field_185991_j = ctx.getLPerlin1();
        this.field_185992_k = ctx.getLPerlin2();
        this.field_185993_l = ctx.getPerlin();
        this.field_185994_m = ctx.getHeight();
        this.field_185983_b = ctx.getScale();
        this.field_185984_c = ctx.getDepth();
    }

    public void func_202088_a(IChunk chunkIn) {
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(i, j);
        Biome[] abiome = this.field_202097_c.func_201539_b(i * 16, j * 16, 16, 16);
        chunkIn.func_201577_a(abiome);
        this.func_185976_a(i, j, chunkIn);
        chunkIn.func_201588_a(Heightmap.Type.WORLD_SURFACE_WG, Heightmap.Type.OCEAN_FLOOR_WG);
        this.func_205471_a(chunkIn, abiome, sharedseedrandom, this.field_202095_a.func_181545_F());
        this.func_205472_a(chunkIn, (Random)sharedseedrandom);
        chunkIn.func_201588_a(Heightmap.Type.WORLD_SURFACE_WG, Heightmap.Type.OCEAN_FLOOR_WG);
        chunkIn.func_201574_a(ChunkStatus.BASE);
    }

    public void func_202093_c(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        Biome biome = region.func_72964_e(i, j).func_201590_e()[0];
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202424_a(region.func_72905_C(), i << 4, j << 4);
        WorldEntitySpawner.func_77191_a(region, biome, i, j, (Random)sharedseedrandom);
    }

    public void func_185976_a(int x, int z, IChunk primer) {
        Biome[] abiome = this.field_202097_c.func_201535_a(primer.func_76632_l().field_77276_a * 4 - 2, primer.func_76632_l().field_77275_b * 4 - 2, 10, 10);
        double[] adouble = new double[825];
        this.func_202108_a(abiome, primer.func_76632_l().field_77276_a * 4, 0, primer.func_76632_l().field_77275_b * 4, adouble);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 4; ++i) {
            int j = i * 5;
            int k = (i + 1) * 5;
            for (int l = 0; l < 4; ++l) {
                int i1 = (j + l) * 33;
                int j1 = (j + l + 1) * 33;
                int k1 = (k + l) * 33;
                int l1 = (k + l + 1) * 33;
                for (int i2 = 0; i2 < 32; ++i2) {
                    double d0 = 0.125;
                    double d1 = adouble[i1 + i2];
                    double d2 = adouble[j1 + i2];
                    double d3 = adouble[k1 + i2];
                    double d4 = adouble[l1 + i2];
                    double d5 = (adouble[i1 + i2 + 1] - d1) * 0.125;
                    double d6 = (adouble[j1 + i2 + 1] - d2) * 0.125;
                    double d7 = (adouble[k1 + i2 + 1] - d3) * 0.125;
                    double d8 = (adouble[l1 + i2 + 1] - d4) * 0.125;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * 0.25;
                            double lvt_48_1_ = d10 - d16;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                blockpos$mutableblockpos.func_181079_c(i * 4 + k2, i2 * 8 + j2, l * 4 + l2);
                                lvt_48_1_ += d16;
                                if (d > 0.0) {
                                    primer.func_177436_a((BlockPos)blockpos$mutableblockpos, this.field_205475_r, false);
                                    continue;
                                }
                                if (i2 * 8 + j2 >= this.field_186000_s.func_202197_m()) continue;
                                primer.func_177436_a((BlockPos)blockpos$mutableblockpos, this.field_205476_s, false);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void func_202108_a(Biome[] p_202108_1_, int x, int y, int z, double[] p_202108_5_) {
        double[] adouble = this.field_185984_c.func_202646_a(x, z, 5, 5, this.field_186000_s.func_202193_n(), this.field_186000_s.func_202194_o(), this.field_186000_s.func_202189_p());
        float f = this.field_186000_s.func_202195_q();
        float f1 = this.field_186000_s.func_202196_r();
        double[] adouble1 = this.field_185993_l.func_202647_a(x, y, z, 5, 33, 5, (double)(f / this.field_186000_s.func_202192_s()), (double)(f1 / this.field_186000_s.func_202190_t()), (double)(f / this.field_186000_s.func_202191_u()));
        double[] adouble2 = this.field_185991_j.func_202647_a(x, y, z, 5, 33, 5, (double)f, (double)f1, (double)f);
        double[] adouble3 = this.field_185992_k.func_202647_a(x, y, z, 5, 33, 5, (double)f, (double)f1, (double)f);
        int i = 0;
        int j = 0;
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                int i1 = 2;
                Biome biome = p_202108_1_[k + 2 + (l + 2) * 10];
                for (int j1 = -2; j1 <= 2; ++j1) {
                    for (int k1 = -2; k1 <= 2; ++k1) {
                        Biome biome1 = p_202108_1_[k + j1 + 2 + (l + k1 + 2) * 10];
                        float f5 = this.field_186000_s.func_202203_v() + biome1.func_185355_j() * this.field_186000_s.func_202202_w();
                        float f6 = this.field_186000_s.func_202204_x() + biome1.func_185360_m() * this.field_186000_s.func_202205_y();
                        if (this.field_185997_p == WorldType.field_151360_e && f5 > 0.0f) {
                            f5 = 1.0f + f5 * 2.0f;
                            f6 = 1.0f + f6 * 4.0f;
                        }
                        float f7 = this.field_185999_r[j1 + 2 + (k1 + 2) * 5] / (f5 + 2.0f);
                        if (biome1.func_185355_j() > biome.func_185355_j()) {
                            f7 /= 2.0f;
                        }
                        f2 += f6 * f7;
                        f3 += f5 * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                double d7 = adouble[j] / 8000.0;
                if (d7 < 0.0) {
                    d7 = -d7 * 0.3;
                }
                if ((d7 = d7 * 3.0 - 2.0) < 0.0) {
                    if ((d7 /= 2.0) < -1.0) {
                        d7 = -1.0;
                    }
                    d7 /= 1.4;
                    d7 /= 2.0;
                } else {
                    if (d7 > 1.0) {
                        d7 = 1.0;
                    }
                    d7 /= 8.0;
                }
                ++j;
                double d8 = f3;
                double d9 = f2;
                d8 += d7 * 0.2;
                d8 = d8 * this.field_186000_s.func_202201_z() / 8.0;
                double d0 = this.field_186000_s.func_202201_z() + d8 * 4.0;
                for (int l1 = 0; l1 < 33; ++l1) {
                    double d1 = ((double)l1 - d0) * this.field_186000_s.func_202206_A() * 128.0 / 256.0 / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d2 = adouble2[i] / this.field_186000_s.func_202207_B();
                    double d3 = adouble3[i] / this.field_186000_s.func_202208_C();
                    double d4 = (adouble1[i] / 10.0 + 1.0) / 2.0;
                    double d5 = MathHelper.func_151238_b((double)d2, (double)d3, (double)d4) - d1;
                    if (l1 > 29) {
                        double d6 = (float)(l1 - 29) / 3.0f;
                        d5 = d5 * (1.0 - d6) - 10.0 * d6;
                    }
                    p_202108_5_[i] = d5;
                    ++i;
                }
            }
        }
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.field_202095_a.func_180494_b(pos);
        if (creatureType == EnumCreatureType.MONSTER && ((SwampHutStructure)Feature.field_202334_l).func_202383_b(this.field_202095_a, pos)) {
            return Feature.field_202334_l.func_202279_e();
        }
        return creatureType == EnumCreatureType.MONSTER && Feature.field_202336_n.func_175796_a(this.field_202095_a, pos) ? Feature.field_202336_n.func_202279_e() : biome.func_76747_a(creatureType);
    }

    public int func_203222_a(World worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        int i = 0;
        return i += this.field_203230_r.func_203232_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
    }

    @Override
    public OverworldGenSettings func_201496_a_() {
        return this.field_186000_s;
    }

    @Override
    public double[] func_205473_a(int x, int z) {
        double d0 = 0.03125;
        return this.field_185994_m.func_202644_a((double)(x << 4), (double)(z << 4), 16, 16, 0.0625, 0.0625, 1.0);
    }

    public int func_205470_d() {
        return this.field_202095_a.func_181545_F() + 1;
    }
}

