/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegionFile {
    private static final boolean FORGE_ENABLE_EXTENDED_SAVE = Boolean.parseBoolean(System.getProperty("forge.enableExtendedSave", "true"));
    private static final Logger LOGGER = LogManager.getLogger();
    private static final byte[] field_76720_a = new byte[4096];
    private final File field_76718_b;
    private RandomAccessFile field_76719_c;
    private final int[] field_76716_d = new int[1024];
    private final int[] field_76717_e = new int[1024];
    private List<Boolean> field_76714_f;
    private int field_76715_g;
    private long field_76721_h;

    public RegionFile(File fileNameIn) {
        this.field_76718_b = fileNameIn;
        this.field_76715_g = 0;
        try {
            if (fileNameIn.exists()) {
                this.field_76721_h = fileNameIn.lastModified();
            }
            this.field_76719_c = new RandomAccessFile(fileNameIn, "rw");
            if (this.field_76719_c.length() < 4096L) {
                this.field_76719_c.write(field_76720_a);
                this.field_76719_c.write(field_76720_a);
                this.field_76715_g += 8192;
            }
            if ((this.field_76719_c.length() & 0xFFFL) != 0L) {
                int i = 0;
                while ((long)i < (this.field_76719_c.length() & 0xFFFL)) {
                    this.field_76719_c.write(0);
                    ++i;
                }
            }
            int i1 = (int)this.field_76719_c.length() / 4096;
            this.field_76714_f = Lists.newArrayListWithCapacity((int)i1);
            for (int j = 0; j < i1; ++j) {
                this.field_76714_f.add(true);
            }
            this.field_76714_f.set(0, false);
            this.field_76714_f.set(1, false);
            this.field_76719_c.seek(0L);
            for (int j1 = 0; j1 < 1024; ++j1) {
                int k;
                this.field_76716_d[j1] = k = this.field_76719_c.readInt();
                int length = k & 0xFF;
                if (length == 255 && k >> 8 <= this.field_76714_f.size()) {
                    this.field_76719_c.seek((k >> 8) * 4096);
                    length = (this.field_76719_c.readInt() + 4) / 4096 + 1;
                    this.field_76719_c.seek(j1 * 4 + 4);
                }
                if (k != 0 && (k >> 8) + length <= this.field_76714_f.size()) {
                    for (int l = 0; l < length; ++l) {
                        this.field_76714_f.set((k >> 8) + l, false);
                    }
                    continue;
                }
                if (length <= 0) continue;
                LOGGER.warn("Invalid chunk: ({}, {}) Offset: {} Length: {} runs off end file. {}", (Object)(j1 % 32), (Object)(j1 / 32), (Object)(k >> 8), (Object)length, (Object)fileNameIn);
            }
            for (int k1 = 0; k1 < 1024; ++k1) {
                int l1;
                this.field_76717_e[k1] = l1 = this.field_76719_c.readInt();
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    @Nullable
    public synchronized DataInputStream func_76704_a(int x, int z) {
        if (this.func_76705_d(x, z)) {
            return null;
        }
        try {
            int i = this.func_76707_e(x, z);
            if (i == 0) {
                return null;
            }
            int j = i >> 8;
            int k = i & 0xFF;
            if (k == 255) {
                this.field_76719_c.seek(j * 4096);
                k = (this.field_76719_c.readInt() + 4) / 4096 + 1;
            }
            if (j + k > this.field_76714_f.size()) {
                return null;
            }
            this.field_76719_c.seek(j * 4096);
            int l = this.field_76719_c.readInt();
            if (l > 4096 * k) {
                LOGGER.warn("Invalid chunk: ({}, {}) Offset: {} Invalid Size: {}>{} {}", (Object)x, (Object)z, (Object)j, (Object)l, (Object)(k * 4096), (Object)this.field_76718_b);
                return null;
            }
            if (l <= 0) {
                LOGGER.warn("Invalid chunk: ({}, {}) Offset: {} Invalid Size: {} {}", (Object)x, (Object)z, (Object)j, (Object)l, (Object)this.field_76718_b);
                return null;
            }
            byte b0 = this.field_76719_c.readByte();
            if (b0 == 1) {
                byte[] abyte1 = new byte[l - 1];
                this.field_76719_c.read(abyte1);
                return new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(abyte1))));
            }
            if (b0 == 2) {
                byte[] abyte = new byte[l - 1];
                this.field_76719_c.read(abyte);
                return new DataInputStream(new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(abyte))));
            }
            return null;
        }
        catch (IOException var9) {
            return null;
        }
    }

    public boolean func_212167_b(int p_212167_1_, int p_212167_2_) {
        if (this.func_76705_d(p_212167_1_, p_212167_2_)) {
            return false;
        }
        int i = this.func_76707_e(p_212167_1_, p_212167_2_);
        if (i == 0) {
            return false;
        }
        int j = i >> 8;
        int k = i & 0xFF;
        if (j + k > this.field_76714_f.size()) {
            return false;
        }
        try {
            this.field_76719_c.seek(j * 4096);
            int l = this.field_76719_c.readInt();
            if (l > 4096 * k) {
                return false;
            }
            return l > 0;
        }
        catch (IOException var7) {
            return false;
        }
    }

    @Nullable
    public DataOutputStream func_76710_b(int x, int z) {
        return this.func_76705_d(x, z) ? null : new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream(new ChunkBuffer(x, z))));
    }

    protected synchronized void func_76706_a(int x, int z, byte[] data, int length) {
        try {
            int l;
            int i = this.func_76707_e(x, z);
            int j = i >> 8;
            int k = i & 0xFF;
            if (k == 255) {
                this.field_76719_c.seek(j * 4096);
                k = (this.field_76719_c.readInt() + 4) / 4096 + 1;
            }
            if ((l = (length + 5) / 4096 + 1) >= 256) {
                if (!FORGE_ENABLE_EXTENDED_SAVE) {
                    return;
                }
                LOGGER.warn("Large Chunk Detected: ({}, {}) Size: {} {}", (Object)x, (Object)z, (Object)l, (Object)this.field_76718_b);
            }
            if (j != 0 && k == l) {
                this.func_76712_a(j, data, length);
            } else {
                for (int i1 = 0; i1 < k; ++i1) {
                    this.field_76714_f.set(j + i1, true);
                }
                int l1 = this.field_76714_f.indexOf(true);
                int j1 = 0;
                if (l1 != -1) {
                    for (int k1 = l1; k1 < this.field_76714_f.size(); ++k1) {
                        if (j1 != 0) {
                            j1 = this.field_76714_f.get(k1).booleanValue() ? ++j1 : 0;
                        } else if (this.field_76714_f.get(k1).booleanValue()) {
                            l1 = k1;
                            j1 = 1;
                        }
                        if (j1 >= l) break;
                    }
                }
                if (j1 >= l) {
                    j = l1;
                    this.func_76711_a(x, z, l1 << 8 | (l > 255 ? 255 : l));
                    for (int j2 = 0; j2 < l; ++j2) {
                        this.field_76714_f.set(j + j2, false);
                    }
                    this.func_76712_a(j, data, length);
                } else {
                    this.field_76719_c.seek(this.field_76719_c.length());
                    j = this.field_76714_f.size();
                    for (int i2 = 0; i2 < l; ++i2) {
                        this.field_76719_c.write(field_76720_a);
                        this.field_76714_f.add(false);
                    }
                    this.field_76715_g += 4096 * l;
                    this.func_76712_a(j, data, length);
                    this.func_76711_a(x, z, j << 8 | (l > 255 ? 255 : l));
                }
            }
            this.func_76713_b(x, z, (int)(Util.func_211179_d() / 1000L));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private void func_76712_a(int sectorNumber, byte[] data, int length) throws IOException {
        this.field_76719_c.seek(sectorNumber * 4096);
        this.field_76719_c.writeInt(length + 1);
        this.field_76719_c.writeByte(2);
        this.field_76719_c.write(data, 0, length);
    }

    private boolean func_76705_d(int x, int z) {
        return x < 0 || x >= 32 || z < 0 || z >= 32;
    }

    private int func_76707_e(int x, int z) {
        return this.field_76716_d[x + z * 32];
    }

    public boolean func_76709_c(int x, int z) {
        return this.func_76707_e(x, z) != 0;
    }

    private void func_76711_a(int x, int z, int offset) throws IOException {
        this.field_76716_d[x + z * 32] = offset;
        this.field_76719_c.seek((x + z * 32) * 4);
        this.field_76719_c.writeInt(offset);
    }

    private void func_76713_b(int x, int z, int timestamp) throws IOException {
        this.field_76717_e[x + z * 32] = timestamp;
        this.field_76719_c.seek(4096 + (x + z * 32) * 4);
        this.field_76719_c.writeInt(timestamp);
    }

    public void func_76708_c() throws IOException {
        if (this.field_76719_c != null) {
            this.field_76719_c.close();
        }
    }

    class ChunkBuffer
    extends ByteArrayOutputStream {
        private final int field_76722_b;
        private final int field_76723_c;

        public ChunkBuffer(int x, int z) {
            super(8096);
            this.field_76722_b = x;
            this.field_76723_c = z;
        }

        @Override
        public void close() {
            RegionFile.this.func_76706_a(this.field_76722_b, this.field_76723_c, this.buf, this.count);
        }
    }
}

