/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.init.Biomes;
import net.minecraft.init.Fluids;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.ServerTickList;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.UpgradeData;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.LegacyStructureDataUtil;
import net.minecraft.world.gen.feature.structure.StructureIO;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.storage.IThreadedFileIO;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraft.world.storage.WorldSavedDataStorage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnvilChunkLoader
implements IChunkLoader,
IThreadedFileIO {
    private static final Logger field_151505_a = LogManager.getLogger();
    private final Map<ChunkPos, NBTTagCompound> field_75828_a = Maps.newHashMap();
    public final File field_75825_d;
    private final DataFixer field_193416_e;
    private LegacyStructureDataUtil field_208031_e;
    private boolean field_183014_e;

    public AnvilChunkLoader(File chunkSaveLocationIn, DataFixer fixerIn) {
        this.field_75825_d = chunkSaveLocationIn;
        this.field_193416_e = fixerIn;
    }

    @Nullable
    private NBTTagCompound func_208030_a(IWorld worldIn, int chunkX, int chunkZ) throws IOException {
        return this.func_212146_a(worldIn.func_201675_m().func_186058_p(), worldIn.func_175693_T(), chunkX, chunkZ);
    }

    @Nullable
    private NBTTagCompound func_212146_a(DimensionType p_212146_1_, @Nullable WorldSavedDataStorage storage, int chunkX, int chunkZ) throws IOException {
        int i;
        NBTTagCompound nbttagcompound = this.field_75828_a.get(new ChunkPos(chunkX, chunkZ));
        if (nbttagcompound != null) {
            return nbttagcompound;
        }
        DataInputStream datainputstream = RegionFileCache.func_76549_c((File)this.field_75825_d, (int)chunkX, (int)chunkZ);
        if (datainputstream == null) {
            return null;
        }
        NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_74794_a(datainputstream);
        datainputstream.close();
        int n = i = nbttagcompound1.func_150297_b("DataVersion", 99) ? nbttagcompound1.func_74762_e("DataVersion") : -1;
        if (i < 1493 && (nbttagcompound1 = NBTUtil.func_210821_a((DataFixer)this.field_193416_e, (DSL.TypeReference)DataFixTypes.CHUNK, (NBTTagCompound)nbttagcompound1, (int)i, (int)1493)).func_74775_l("Level").func_74767_n("hasLegacyStructureData")) {
            this.func_212429_a(p_212146_1_, storage);
            nbttagcompound1 = this.field_208031_e.func_212181_a(nbttagcompound1);
        }
        nbttagcompound1 = NBTUtil.func_210822_a((DataFixer)this.field_193416_e, (DSL.TypeReference)DataFixTypes.CHUNK, (NBTTagCompound)nbttagcompound1, (int)Math.max(1493, i));
        if (i < 1631) {
            nbttagcompound1.func_74768_a("DataVersion", 1631);
            this.func_75824_a(new ChunkPos(chunkX, chunkZ), nbttagcompound1);
        }
        return nbttagcompound1;
    }

    public void func_212429_a(DimensionType p_212429_1_, @Nullable WorldSavedDataStorage p_212429_2_) {
        if (this.field_208031_e == null) {
            this.field_208031_e = LegacyStructureDataUtil.func_212183_a((DimensionType)p_212429_1_, (WorldSavedDataStorage)p_212429_2_);
        }
    }

    @Nullable
    public Chunk func_199813_a(IWorld worldIn, int x, int z, Consumer<Chunk> consumer) throws IOException {
        NBTTagCompound nbttagcompound = this.func_208030_a(worldIn, x, z);
        if (nbttagcompound == null) {
            return null;
        }
        Chunk chunk = this.func_75822_a(worldIn, x, z, nbttagcompound);
        if (chunk != null) {
            consumer.accept(chunk);
            this.func_199814_a(nbttagcompound.func_74775_l("Level"), chunk);
        }
        return chunk;
    }

    @Nullable
    public ChunkPrimer func_202152_b(IWorld worldIn, int x, int z, Consumer<IChunk> consumer) throws IOException {
        NBTTagCompound nbttagcompound;
        try {
            nbttagcompound = this.func_208030_a(worldIn, x, z);
        }
        catch (ReportedException reportedexception) {
            if (reportedexception.getCause() instanceof IOException) {
                throw (IOException)reportedexception.getCause();
            }
            throw reportedexception;
        }
        if (nbttagcompound == null) {
            return null;
        }
        ChunkPrimer chunkprimer = this.func_202165_b(worldIn, x, z, nbttagcompound);
        if (chunkprimer != null) {
            consumer.accept((IChunk)chunkprimer);
        }
        return chunkprimer;
    }

    @Nullable
    protected Chunk func_75822_a(IWorld worldIn, int x, int z, NBTTagCompound compound) {
        if (compound.func_150297_b("Level", 10) && compound.func_74775_l("Level").func_150297_b("Status", 8)) {
            ChunkStatus.Type chunkstatus$type = this.func_202161_a(compound);
            if (chunkstatus$type != ChunkStatus.Type.LEVELCHUNK) {
                return null;
            }
            NBTTagCompound nbttagcompound = compound.func_74775_l("Level");
            if (!nbttagcompound.func_150297_b("Sections", 9)) {
                field_151505_a.error("Chunk file at {},{} is missing block data, skipping", (Object)x, (Object)z);
                return null;
            }
            Chunk chunk = this.func_75823_a(worldIn, nbttagcompound);
            if (!chunk.func_76600_a(x, z)) {
                field_151505_a.error("Chunk file at {},{} is in the wrong location; relocating. (Expected {}, {}, got {}, {})", (Object)x, (Object)z, (Object)x, (Object)z, (Object)chunk.field_76635_g, (Object)chunk.field_76647_h);
                nbttagcompound.func_74768_a("xPos", x);
                nbttagcompound.func_74768_a("zPos", z);
                chunk = this.func_75823_a(worldIn, nbttagcompound);
            }
            return chunk;
        }
        field_151505_a.error("Chunk file at {},{} is missing level data, skipping", (Object)x, (Object)z);
        return null;
    }

    @Nullable
    protected ChunkPrimer func_202165_b(IWorld worldIn, int x, int z, NBTTagCompound nbt) {
        if (nbt.func_150297_b("Level", 10) && nbt.func_74775_l("Level").func_150297_b("Status", 8)) {
            ChunkStatus.Type chunkstatus$type = this.func_202161_a(nbt);
            if (chunkstatus$type == ChunkStatus.Type.LEVELCHUNK) {
                return new ChunkPrimerWrapper((IChunk)this.func_75822_a(worldIn, x, z, nbt));
            }
            NBTTagCompound nbttagcompound = nbt.func_74775_l("Level");
            return this.func_202155_b(worldIn, nbttagcompound);
        }
        field_151505_a.error("Chunk file at {},{} is missing level data, skipping", (Object)x, (Object)z);
        return null;
    }

    public void func_75816_a(World worldIn, IChunk chunkIn) throws IOException, SessionLockException {
        worldIn.func_72906_B();
        try {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound.func_74768_a("DataVersion", 1631);
            ChunkPos chunkpos = chunkIn.func_76632_l();
            nbttagcompound.func_74782_a("Level", nbttagcompound1);
            if (chunkIn.func_201589_g().func_202129_d() == ChunkStatus.Type.LEVELCHUNK) {
                this.func_75820_a((Chunk)chunkIn, worldIn, nbttagcompound1);
            } else {
                NBTTagCompound nbttagcompound2 = this.func_208030_a(worldIn, chunkpos.field_77276_a, chunkpos.field_77275_b);
                if (nbttagcompound2 != null && this.func_202161_a(nbttagcompound2) == ChunkStatus.Type.LEVELCHUNK) {
                    return;
                }
                this.func_202156_a((ChunkPrimer)chunkIn, worldIn, nbttagcompound1);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ChunkDataEvent.Save(chunkIn, nbttagcompound));
            this.func_75824_a(chunkpos, nbttagcompound);
        }
        catch (Exception exception) {
            field_151505_a.error("Failed to save chunk", (Throwable)exception);
        }
    }

    protected void func_75824_a(ChunkPos pos, NBTTagCompound compound) {
        this.field_75828_a.put(pos, compound);
        ThreadedFileIOBase.func_178779_a().func_75735_a((IThreadedFileIO)this);
    }

    public boolean func_75814_c() {
        Iterator<Map.Entry<ChunkPos, NBTTagCompound>> iterator = this.field_75828_a.entrySet().iterator();
        if (!iterator.hasNext()) {
            if (this.field_183014_e) {
                field_151505_a.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)this.field_75825_d.getName());
            }
            return false;
        }
        Map.Entry<ChunkPos, NBTTagCompound> entry = iterator.next();
        iterator.remove();
        ChunkPos chunkpos = entry.getKey();
        NBTTagCompound nbttagcompound = entry.getValue();
        if (nbttagcompound == null) {
            return true;
        }
        try {
            DataOutputStream dataoutputstream = RegionFileCache.func_76552_d((File)this.field_75825_d, (int)chunkpos.field_77276_a, (int)chunkpos.field_77275_b);
            CompressedStreamTools.func_74800_a(nbttagcompound, dataoutputstream);
            dataoutputstream.close();
            if (this.field_208031_e != null) {
                this.field_208031_e.func_208216_a(chunkpos.func_201841_a());
            }
        }
        catch (Exception exception) {
            field_151505_a.error("Failed to save chunk", (Throwable)exception);
        }
        return true;
    }

    private ChunkStatus.Type func_202161_a(@Nullable NBTTagCompound nbt) {
        ChunkStatus chunkstatus;
        if (nbt != null && (chunkstatus = ChunkStatus.func_202127_a((String)nbt.func_74775_l("Level").func_74779_i("Status"))) != null) {
            return chunkstatus.func_202129_d();
        }
        return ChunkStatus.Type.PROTOCHUNK;
    }

    public void func_75818_b() {
        try {
            this.field_183014_e = true;
            while (this.func_75814_c()) {
            }
        }
        finally {
            this.field_183014_e = false;
        }
    }

    private void func_202156_a(ChunkPrimer primer, World worldIn, NBTTagCompound compound) {
        int[] aint;
        int i = primer.func_76632_l().field_77276_a;
        int j = primer.func_76632_l().field_77275_b;
        compound.func_74768_a("xPos", i);
        compound.func_74768_a("zPos", j);
        compound.func_74772_a("LastUpdate", worldIn.func_82737_E());
        compound.func_74772_a("InhabitedTime", primer.func_209216_m());
        compound.func_74778_a("Status", primer.func_201589_g().func_202125_b());
        UpgradeData upgradedata = primer.func_201631_p();
        if (!upgradedata.func_196988_a()) {
            compound.func_74782_a("UpgradeData", upgradedata.func_196992_b());
        }
        ChunkSection[] achunksection = primer.func_76587_i();
        NBTTagList nbttaglist = this.func_202159_a(worldIn, achunksection);
        compound.func_74782_a("Sections", (INBTBase)nbttaglist);
        Biome[] abiome = primer.func_201590_e();
        int[] nArray = aint = abiome != null ? new int[abiome.length] : new int[]{};
        if (abiome != null) {
            for (int k = 0; k < abiome.length; ++k) {
                aint[k] = IRegistry.field_212624_m.func_148757_b(abiome[k]);
            }
        }
        compound.func_74783_a("Biomes", aint);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (Object nbttagcompound : primer.func_201652_l()) {
            nbttaglist1.add((INBTBase)nbttagcompound);
        }
        compound.func_74782_a("Entities", (INBTBase)nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (Object blockpos : primer.func_201638_j()) {
            TileEntity tileentity = primer.func_175625_s((BlockPos)blockpos);
            if (tileentity != null) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                tileentity.func_189515_b(nbttagcompound1);
                nbttaglist2.add((INBTBase)nbttagcompound1);
                continue;
            }
            nbttaglist2.add((INBTBase)primer.func_201579_g((BlockPos)blockpos));
        }
        compound.func_74782_a("TileEntities", (INBTBase)nbttaglist2);
        compound.func_74782_a("Lights", (INBTBase)AnvilChunkLoader.func_202163_a(primer.func_201647_i()));
        compound.func_74782_a("PostProcessing", (INBTBase)AnvilChunkLoader.func_202163_a(primer.func_201645_n()));
        compound.func_74782_a("ToBeTicked", (INBTBase)primer.func_205218_i_().func_205379_a());
        compound.func_74782_a("LiquidsToBeTicked", (INBTBase)primer.func_212247_j().func_205379_a());
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        for (Heightmap.Type heightmap$type : primer.func_201634_m()) {
            nbttagcompound2.func_74782_a(heightmap$type.func_203500_b(), (INBTBase)new NBTTagLongArray(primer.func_201642_a(heightmap$type).func_202269_a()));
        }
        compound.func_74782_a("Heightmaps", nbttagcompound2);
        NBTTagCompound nbttagcompound3 = new NBTTagCompound();
        for (GenerationStage.Carving generationstage$carving : GenerationStage.Carving.values()) {
            nbttagcompound3.func_74773_a(generationstage$carving.toString(), primer.func_205749_a(generationstage$carving).toByteArray());
        }
        compound.func_74782_a("CarvingMasks", nbttagcompound3);
        compound.func_74782_a("Structures", this.func_202160_a(i, j, primer.func_201609_c(), primer.func_201604_d()));
    }

    private void func_75820_a(Chunk chunkIn, World worldIn, NBTTagCompound compound) {
        compound.func_74768_a("xPos", chunkIn.field_76635_g);
        compound.func_74768_a("zPos", chunkIn.field_76647_h);
        compound.func_74772_a("LastUpdate", worldIn.func_82737_E());
        compound.func_74772_a("InhabitedTime", chunkIn.func_177416_w());
        compound.func_74778_a("Status", chunkIn.func_201589_g().func_202125_b());
        UpgradeData upgradedata = chunkIn.func_196966_y();
        if (!upgradedata.func_196988_a()) {
            compound.func_74782_a("UpgradeData", upgradedata.func_196992_b());
        }
        ChunkSection[] achunksection = chunkIn.func_76587_i();
        NBTTagList nbttaglist = this.func_202159_a(worldIn, achunksection);
        compound.func_74782_a("Sections", (INBTBase)nbttaglist);
        Biome[] abiome = chunkIn.func_201590_e();
        int[] aint = new int[abiome.length];
        for (int i = 0; i < abiome.length; ++i) {
            aint[i] = IRegistry.field_212624_m.func_148757_b(abiome[i]);
        }
        compound.func_74783_a("Biomes", aint);
        chunkIn.func_177409_g(false);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (int j = 0; j < chunkIn.func_177429_s().length; ++j) {
            for (Entity entity : chunkIn.func_177429_s()[j]) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                try {
                    if (!entity.func_70039_c(nbttagcompound)) continue;
                    chunkIn.func_177409_g(true);
                    nbttaglist1.add((INBTBase)nbttagcompound);
                }
                catch (Exception e) {
                    LogManager.getLogger().error("An Entity type {} has thrown an exception trying to write state. It will not persist. Report this to the mod author", entity.func_200600_R(), (Object)e);
                }
            }
        }
        compound.func_74782_a("Entities", (INBTBase)nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (BlockPos blockPos : chunkIn.func_203066_o()) {
            TileEntity tileentity = chunkIn.func_175625_s(blockPos);
            if (tileentity != null) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                try {
                    tileentity.func_189515_b(nbttagcompound1);
                }
                catch (Exception e) {
                    LogManager.getLogger().error("A TileEntity type {} has thrown an exception trying to write state. It will not persist, Report this to the mod author", (Object)((Object)((Object)tileentity)).getClass().getName(), (Object)e);
                }
                nbttagcompound1.func_74757_a("keepPacked", false);
                nbttaglist2.add((INBTBase)nbttagcompound1);
                continue;
            }
            NBTTagCompound nbttagcompound3 = chunkIn.func_201579_g(blockPos);
            if (nbttagcompound3 == null) continue;
            nbttagcompound3.func_74757_a("keepPacked", true);
            nbttaglist2.add((INBTBase)nbttagcompound3);
        }
        compound.func_74782_a("TileEntities", (INBTBase)nbttaglist2);
        if (worldIn.func_205220_G_() instanceof ServerTickList) {
            compound.func_74782_a("TileTicks", (INBTBase)((ServerTickList)worldIn.func_205220_G_()).func_205363_a(chunkIn));
        }
        if (worldIn.func_205219_F_() instanceof ServerTickList) {
            compound.func_74782_a("LiquidTicks", (INBTBase)((ServerTickList)worldIn.func_205219_F_()).func_205363_a(chunkIn));
        }
        compound.func_74782_a("PostProcessing", (INBTBase)AnvilChunkLoader.func_202163_a(chunkIn.func_201614_D()));
        if (chunkIn.func_205218_i_() instanceof ChunkPrimerTickList) {
            compound.func_74782_a("ToBeTicked", (INBTBase)((ChunkPrimerTickList)chunkIn.func_205218_i_()).func_205379_a());
        }
        if (chunkIn.func_212247_j() instanceof ChunkPrimerTickList) {
            compound.func_74782_a("LiquidsToBeTicked", (INBTBase)((ChunkPrimerTickList)chunkIn.func_212247_j()).func_205379_a());
        }
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        for (Heightmap.Type heightmap$type : chunkIn.func_201615_v()) {
            if (heightmap$type.func_207512_c() != Heightmap.Usage.LIVE_WORLD) continue;
            nbttagcompound2.func_74782_a(heightmap$type.func_203500_b(), (INBTBase)new NBTTagLongArray(chunkIn.func_201608_a(heightmap$type).func_202269_a()));
        }
        compound.func_74782_a("Heightmaps", nbttagcompound2);
        compound.func_74782_a("Structures", this.func_202160_a(chunkIn.field_76635_g, chunkIn.field_76647_h, chunkIn.func_201609_c(), chunkIn.func_201604_d()));
        try {
            NBTTagCompound nBTTagCompound = chunkIn.writeCapsToNBT();
            if (nBTTagCompound != null) {
                compound.func_74782_a("ForgeCaps", nBTTagCompound);
            }
        }
        catch (Exception exception) {
            LogManager.getLogger().error("A capability provider has thrown an exception trying to write state. It will not persist. Report this to the mod author", (Throwable)exception);
        }
    }

    private Chunk func_75823_a(IWorld worldIn, NBTTagCompound compound) {
        int i = compound.func_74762_e("xPos");
        int j = compound.func_74762_e("zPos");
        Biome[] abiome = new Biome[256];
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        if (compound.func_150297_b("Biomes", 11)) {
            int[] aint = compound.func_74759_k("Biomes");
            for (int k = 0; k < aint.length; ++k) {
                abiome[k] = IRegistry.field_212624_m.func_148754_a(aint[k]);
                if (abiome[k] != null) continue;
                abiome[k] = worldIn.func_72863_F().func_201711_g().func_202090_b().func_180300_a((BlockPos)blockpos$mutableblockpos.func_181079_c((k & 0xF) + (i << 4), 0, (k >> 4 & 0xF) + (j << 4)), Biomes.field_76772_c);
            }
        } else {
            for (int i1 = 0; i1 < abiome.length; ++i1) {
                abiome[i1] = worldIn.func_72863_F().func_201711_g().func_202090_b().func_180300_a((BlockPos)blockpos$mutableblockpos.func_181079_c((i1 & 0xF) + (i << 4), 0, (i1 >> 4 & 0xF) + (j << 4)), Biomes.field_76772_c);
            }
        }
        UpgradeData upgradedata = compound.func_150297_b("UpgradeData", 10) ? new UpgradeData(compound.func_74775_l("UpgradeData")) : UpgradeData.field_196994_a;
        ChunkPrimerTickList chunkprimerticklist1 = new ChunkPrimerTickList(p_205531_0_ -> p_205531_0_.func_176223_P().func_196958_f(), IRegistry.field_212618_g::func_177774_c, IRegistry.field_212618_g::func_82594_a, new ChunkPos(i, j));
        ChunkPrimerTickList chunkprimerticklist = new ChunkPrimerTickList(p_206242_0_ -> p_206242_0_ == Fluids.field_204541_a, IRegistry.field_212619_h::func_177774_c, IRegistry.field_212619_h::func_82594_a, new ChunkPos(i, j));
        long l = compound.func_74763_f("InhabitedTime");
        Chunk chunk = new Chunk(worldIn.func_201672_e(), i, j, abiome, upgradedata, (ITickList<Block>)chunkprimerticklist1, (ITickList<Fluid>)chunkprimerticklist, l);
        chunk.func_201613_c(compound.func_74779_i("Status"));
        NBTTagList nbttaglist = compound.func_150295_c("Sections", 10);
        chunk.func_76602_a(this.func_202158_a(worldIn, nbttaglist));
        NBTTagCompound nbttagcompound = compound.func_74775_l("Heightmaps");
        for (Heightmap.Type heightmap$type : Heightmap.Type.values()) {
            if (heightmap$type.func_207512_c() != Heightmap.Usage.LIVE_WORLD) continue;
            String s = heightmap$type.func_203500_b();
            if (nbttagcompound.func_150297_b(s, 12)) {
                chunk.func_201607_a(heightmap$type, nbttagcompound.func_197645_o(s));
                continue;
            }
            chunk.func_201608_a(heightmap$type).func_202266_a();
        }
        NBTTagCompound nbttagcompound1 = compound.func_74775_l("Structures");
        chunk.func_201612_a(this.func_202162_c(worldIn, nbttagcompound1));
        chunk.func_201606_b(this.func_202167_b(nbttagcompound1));
        NBTTagList nbttaglist1 = compound.func_150295_c("PostProcessing", 9);
        for (int j1 = 0; j1 < nbttaglist1.size(); ++j1) {
            NBTTagList nbttaglist2 = nbttaglist1.func_202169_e(j1);
            for (int k1 = 0; k1 < nbttaglist2.size(); ++k1) {
                chunk.func_201610_a(nbttaglist2.func_202170_f(k1), j1);
            }
        }
        chunkprimerticklist1.func_205380_a(compound.func_150295_c("ToBeTicked", 9));
        chunkprimerticklist.func_205380_a(compound.func_150295_c("LiquidsToBeTicked", 9));
        if (compound.func_74767_n("shouldSave")) {
            chunk.func_177427_f(true);
        }
        if (compound.func_74764_b("ForgeCaps")) {
            chunk.readCapsFromNBT(compound.func_74775_l("ForgeCaps"));
        }
        return chunk;
    }

    private void func_199814_a(NBTTagCompound nbt, Chunk chunkIn) {
        NBTTagList nbttaglist = nbt.func_150295_c("Entities", 10);
        World world = chunkIn.func_177412_p();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            AnvilChunkLoader.func_186050_a(nbttagcompound, world, chunkIn);
            chunkIn.func_177409_g(true);
        }
        NBTTagList nbttaglist1 = nbt.func_150295_c("TileEntities", 10);
        for (int j = 0; j < nbttaglist1.size(); ++j) {
            NBTTagCompound nbttagcompound1 = nbttaglist1.func_150305_b(j);
            boolean flag = nbttagcompound1.func_74767_n("keepPacked");
            if (flag) {
                chunkIn.func_201591_a(nbttagcompound1);
                continue;
            }
            TileEntity tileentity = TileEntity.func_203403_c(nbttagcompound1);
            if (tileentity == null) continue;
            chunkIn.func_150813_a(tileentity);
        }
        if (nbt.func_150297_b("TileTicks", 9) && world.func_205220_G_() instanceof ServerTickList) {
            ((ServerTickList)world.func_205220_G_()).func_205369_a(nbt.func_150295_c("TileTicks", 10));
        }
        if (nbt.func_150297_b("LiquidTicks", 9) && world.func_205219_F_() instanceof ServerTickList) {
            ((ServerTickList)world.func_205219_F_()).func_205369_a(nbt.func_150295_c("LiquidTicks", 10));
        }
    }

    private ChunkPrimer func_202155_b(IWorld worldIn, NBTTagCompound nbt) {
        int i = nbt.func_74762_e("xPos");
        int j = nbt.func_74762_e("zPos");
        Biome[] abiome = new Biome[256];
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        if (nbt.func_150297_b("Biomes", 11)) {
            int[] aint = nbt.func_74759_k("Biomes");
            for (int k = 0; k < aint.length; ++k) {
                abiome[k] = IRegistry.field_212624_m.func_148754_a(aint[k]);
                if (abiome[k] != null) continue;
                abiome[k] = worldIn.func_72863_F().func_201711_g().func_202090_b().func_180300_a((BlockPos)blockpos$mutableblockpos.func_181079_c((k & 0xF) + (i << 4), 0, (k >> 4 & 0xF) + (j << 4)), Biomes.field_76772_c);
            }
        } else {
            for (int l1 = 0; l1 < abiome.length; ++l1) {
                abiome[l1] = worldIn.func_72863_F().func_201711_g().func_202090_b().func_180300_a((BlockPos)blockpos$mutableblockpos.func_181079_c((l1 & 0xF) + (i << 4), 0, (l1 >> 4 & 0xF) + (j << 4)), Biomes.field_76772_c);
            }
        }
        UpgradeData upgradedata = nbt.func_150297_b("UpgradeData", 10) ? new UpgradeData(nbt.func_74775_l("UpgradeData")) : UpgradeData.field_196994_a;
        ChunkPrimer chunkprimer = new ChunkPrimer(i, j, upgradedata);
        chunkprimer.func_201577_a(abiome);
        chunkprimer.func_209215_b(nbt.func_74763_f("InhabitedTime"));
        chunkprimer.func_201650_c(nbt.func_74779_i("Status"));
        NBTTagList nbttaglist = nbt.func_150295_c("Sections", 10);
        chunkprimer.func_201630_a(this.func_202158_a(worldIn, nbttaglist));
        NBTTagList nbttaglist1 = nbt.func_150295_c("Entities", 10);
        for (int l = 0; l < nbttaglist1.size(); ++l) {
            chunkprimer.func_201626_b(nbttaglist1.func_150305_b(l));
        }
        NBTTagList nbttaglist3 = nbt.func_150295_c("TileEntities", 10);
        for (int i1 = 0; i1 < nbttaglist3.size(); ++i1) {
            NBTTagCompound nbttagcompound = nbttaglist3.func_150305_b(i1);
            chunkprimer.func_201591_a(nbttagcompound);
        }
        NBTTagList nbttaglist4 = nbt.func_150295_c("Lights", 9);
        for (int i2 = 0; i2 < nbttaglist4.size(); ++i2) {
            NBTTagList nbttaglist2 = nbttaglist4.func_202169_e(i2);
            for (int j1 = 0; j1 < nbttaglist2.size(); ++j1) {
                chunkprimer.func_201646_a(nbttaglist2.func_202170_f(j1), i2);
            }
        }
        NBTTagList nbttaglist5 = nbt.func_150295_c("PostProcessing", 9);
        for (int j2 = 0; j2 < nbttaglist5.size(); ++j2) {
            NBTTagList nbttaglist6 = nbttaglist5.func_202169_e(j2);
            for (int k1 = 0; k1 < nbttaglist6.size(); ++k1) {
                chunkprimer.func_201636_b(nbttaglist6.func_202170_f(k1), j2);
            }
        }
        chunkprimer.func_205218_i_().func_205380_a(nbt.func_150295_c("ToBeTicked", 9));
        chunkprimer.func_212247_j().func_205380_a(nbt.func_150295_c("LiquidsToBeTicked", 9));
        NBTTagCompound nbttagcompound1 = nbt.func_74775_l("Heightmaps");
        for (String s1 : nbttagcompound1.func_150296_c()) {
            chunkprimer.func_201643_a(Heightmap.Type.func_203501_a((String)s1), nbttagcompound1.func_197645_o(s1));
        }
        NBTTagCompound nbttagcompound2 = nbt.func_74775_l("Structures");
        chunkprimer.func_201648_a(this.func_202162_c(worldIn, nbttagcompound2));
        chunkprimer.func_201641_b(this.func_202167_b(nbttagcompound2));
        NBTTagCompound nbttagcompound3 = nbt.func_74775_l("CarvingMasks");
        for (String s : nbttagcompound3.func_150296_c()) {
            GenerationStage.Carving generationstage$carving = GenerationStage.Carving.valueOf((String)s);
            chunkprimer.func_205767_a(generationstage$carving, BitSet.valueOf(nbttagcompound3.func_74770_j(s)));
        }
        return chunkprimer;
    }

    private NBTTagList func_202159_a(World worldIn, ChunkSection[] chunkSections) {
        NBTTagList nbttaglist = new NBTTagList();
        boolean flag = worldIn.field_73011_w.func_191066_m();
        for (ChunkSection chunksection : chunkSections) {
            if (chunksection == Chunk.field_186036_a) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Y", (byte)(chunksection.func_76662_d() >> 4 & 0xFF));
            chunksection.func_186049_g().func_196963_b(nbttagcompound, "Palette", "BlockStates");
            nbttagcompound.func_74773_a("BlockLight", chunksection.func_76661_k().func_177481_a());
            if (flag) {
                nbttagcompound.func_74773_a("SkyLight", chunksection.func_76671_l().func_177481_a());
            } else {
                nbttagcompound.func_74773_a("SkyLight", new byte[chunksection.func_76661_k().func_177481_a().length]);
            }
            nbttaglist.add((INBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    private ChunkSection[] func_202158_a(IWorldReaderBase worldIn, NBTTagList nbt) {
        int i = 16;
        ChunkSection[] achunksection = new ChunkSection[16];
        boolean flag = worldIn.func_201675_m().func_191066_m();
        for (int j = 0; j < nbt.size(); ++j) {
            NBTTagCompound nbttagcompound = nbt.func_150305_b(j);
            byte k = nbttagcompound.func_74771_c("Y");
            ChunkSection chunksection = new ChunkSection(k << 4, flag);
            chunksection.func_186049_g().func_196964_a(nbttagcompound, "Palette", "BlockStates");
            chunksection.func_76659_c(new NibbleArray(nbttagcompound.func_74770_j("BlockLight")));
            if (flag) {
                chunksection.func_76666_d(new NibbleArray(nbttagcompound.func_74770_j("SkyLight")));
            }
            chunksection.func_76672_e();
            achunksection[k] = chunksection;
        }
        return achunksection;
    }

    private NBTTagCompound func_202160_a(int chunkX, int chunkZ, Map<String, StructureStart> structureStarts, Map<String, LongSet> structureReferences) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        for (Map.Entry<String, StructureStart> entry : structureStarts.entrySet()) {
            nbttagcompound1.func_74782_a(entry.getKey(), entry.getValue().func_143021_a(chunkX, chunkZ));
        }
        nbttagcompound.func_74782_a("Starts", nbttagcompound1);
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        for (Map.Entry<String, LongSet> entry1 : structureReferences.entrySet()) {
            nbttagcompound2.func_74782_a(entry1.getKey(), (INBTBase)new NBTTagLongArray(entry1.getValue()));
        }
        nbttagcompound.func_74782_a("References", nbttagcompound2);
        return nbttagcompound;
    }

    private Map<String, StructureStart> func_202162_c(IWorld worldIn, NBTTagCompound nbt) {
        HashMap map = Maps.newHashMap();
        NBTTagCompound nbttagcompound = nbt.func_74775_l("Starts");
        for (String s : nbttagcompound.func_150296_c()) {
            map.put(s, StructureIO.func_202602_a((NBTTagCompound)nbttagcompound.func_74775_l(s), (IWorld)worldIn));
        }
        return map;
    }

    private Map<String, LongSet> func_202167_b(NBTTagCompound nbt) {
        HashMap map = Maps.newHashMap();
        NBTTagCompound nbttagcompound = nbt.func_74775_l("References");
        for (String s : nbttagcompound.func_150296_c()) {
            map.put(s, new LongOpenHashSet(nbttagcompound.func_197645_o(s)));
        }
        return map;
    }

    public static NBTTagList func_202163_a(ShortList[] list) {
        NBTTagList nbttaglist = new NBTTagList();
        for (ShortList shortlist : list) {
            NBTTagList nbttaglist1 = new NBTTagList();
            if (shortlist != null) {
                for (Short oshort : shortlist) {
                    nbttaglist1.add((INBTBase)new NBTTagShort(oshort.shortValue()));
                }
            }
            nbttaglist.add((INBTBase)nbttaglist1);
        }
        return nbttaglist;
    }

    @Nullable
    private static Entity func_206240_a(NBTTagCompound compound, World worldIn, Function<Entity, Entity> func) {
        Entity entity = AnvilChunkLoader.func_186053_a(compound, worldIn);
        if (entity == null) {
            return null;
        }
        if ((entity = func.apply(entity)) != null && compound.func_150297_b("Passengers", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("Passengers", 10);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                Entity entity1 = AnvilChunkLoader.func_206240_a(nbttaglist.func_150305_b(i), worldIn, func);
                if (entity1 == null) continue;
                entity1.func_184205_a(entity, true);
            }
        }
        return entity;
    }

    @Nullable
    public static Entity func_186050_a(NBTTagCompound compound, World worldIn, Chunk chunkIn) {
        return AnvilChunkLoader.func_206240_a(compound, worldIn, p_206241_1_ -> {
            chunkIn.func_76612_a((Entity)((Object)p_206241_1_));
            return p_206241_1_;
        });
    }

    @Nullable
    public static Entity func_186054_a(NBTTagCompound compound, World worldIn, double x, double y, double z, boolean attemptSpawn) {
        return AnvilChunkLoader.func_206240_a(compound, worldIn, p_206238_8_ -> {
            p_206238_8_.func_70012_b(x, y, z, p_206238_8_.field_70177_z, p_206238_8_.field_70125_A);
            return attemptSpawn && !worldIn.func_72838_d((Entity)((Object)p_206238_8_)) ? null : p_206238_8_;
        });
    }

    @Nullable
    public static Entity func_186051_a(NBTTagCompound compound, World worldIn, boolean p_186051_2_) {
        return AnvilChunkLoader.func_206240_a(compound, worldIn, p_206239_2_ -> p_186051_2_ && !worldIn.func_72838_d((Entity)((Object)p_206239_2_)) ? null : p_206239_2_);
    }

    @Nullable
    protected static Entity func_186053_a(NBTTagCompound compound, World worldIn) {
        try {
            return EntityType.func_200716_a(compound, worldIn);
        }
        catch (RuntimeException runtimeexception) {
            field_151505_a.warn("Exception loading entity: ", (Throwable)runtimeexception);
            return null;
        }
    }

    public static void func_186052_a(Entity entityIn, IWorld worldIn) {
        if (worldIn.func_72838_d(entityIn) && entityIn.func_184207_aI()) {
            for (Entity entity : entityIn.func_184188_bt()) {
                AnvilChunkLoader.func_186052_a(entity, worldIn);
            }
        }
    }

    public boolean func_212147_a(ChunkPos p_212147_1_, DimensionType p_212147_2_, WorldSavedDataStorage p_212147_3_) {
        boolean flag = false;
        try {
            this.func_212146_a(p_212147_2_, p_212147_3_, p_212147_1_.field_77276_a, p_212147_1_.field_77275_b);
            while (this.func_75814_c()) {
                flag = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return flag;
    }

    public int getPendingSaveCount() {
        return this.field_75828_a.size();
    }
}

