/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.UpgradeData;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.gen.ChunkGeneratorDebug;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeChunk;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Chunk
extends CapabilityProvider<Chunk>
implements IChunk,
IForgeChunk {
    private static final Logger field_150817_t = LogManager.getLogger();
    public static final ChunkSection field_186036_a = null;
    private final ChunkSection[] field_76652_q = new ChunkSection[16];
    private final Biome[] field_76651_r;
    private final boolean[] field_76639_c = new boolean[256];
    private final Map<BlockPos, NBTTagCompound> field_201618_i = Maps.newHashMap();
    private boolean field_76636_d;
    private final World field_76637_e;
    private final Map<Heightmap.Type, Heightmap> field_76634_f = Maps.newEnumMap(Heightmap.Type.class);
    public final int field_76635_g;
    public final int field_76647_h;
    private boolean field_76650_s;
    private final UpgradeData field_196967_n;
    private final Map<BlockPos, TileEntity> field_150816_i = Maps.newHashMap();
    private final ClassInheritanceMultiMap<Entity>[] field_76645_j;
    private final Map<String, StructureStart> field_201619_q = Maps.newHashMap();
    private final Map<String, LongSet> field_201620_r = Maps.newHashMap();
    private final ShortList[] field_201622_t = new ShortList[16];
    private final ITickList<Block> field_201621_s;
    private final ITickList<Fluid> field_205325_u;
    private boolean field_150815_m;
    private boolean field_76644_m;
    private long field_76641_n;
    private boolean field_76643_l;
    private int field_82912_p;
    private long field_111204_q;
    private int field_76649_t = 4096;
    private final ConcurrentLinkedQueue<BlockPos> field_177447_w = Queues.newConcurrentLinkedQueue();
    private ChunkStatus field_201616_C = ChunkStatus.EMPTY;
    private int field_201617_D;
    private final AtomicInteger field_205757_F = new AtomicInteger();
    private final ChunkPos field_212816_F;

    @OnlyIn(value=Dist.CLIENT)
    public Chunk(World worldIn, int cx, int cz, Biome[] biomesIn) {
        this(worldIn, cx, cz, biomesIn, UpgradeData.field_196994_a, (ITickList<Block>)EmptyTickList.func_205388_a(), (ITickList<Fluid>)EmptyTickList.func_205388_a(), 0L);
    }

    public Chunk(World worldIn, int cx, int cz, Biome[] biomesIn, UpgradeData upgradeDataIn, ITickList<Block> blocksToBeTickedIn, ITickList<Fluid> fluidsToBeTickedIn, long inhabitedTimeIn) {
        super(Chunk.class);
        this.field_76645_j = new ClassInheritanceMultiMap[16];
        this.field_76637_e = worldIn;
        this.field_76635_g = cx;
        this.field_76647_h = cz;
        this.field_212816_F = new ChunkPos(cx, cz);
        this.field_196967_n = upgradeDataIn;
        for (Heightmap.Type heightmap$type : Heightmap.Type.values()) {
            if (heightmap$type.func_207512_c() != Heightmap.Usage.LIVE_WORLD) continue;
            this.field_76634_f.put(heightmap$type, new Heightmap((IChunk)this, heightmap$type));
        }
        for (int i = 0; i < this.field_76645_j.length; ++i) {
            this.field_76645_j[i] = new ClassInheritanceMultiMap<Entity>(Entity.class);
        }
        this.field_76651_r = biomesIn;
        this.field_201621_s = blocksToBeTickedIn;
        this.field_205325_u = fluidsToBeTickedIn;
        this.field_111204_q = inhabitedTimeIn;
        this.gatherCapabilities();
    }

    public Chunk(World worldIn, ChunkPrimer primer, int cx, int cz) {
        this(worldIn, cx, cz, primer.func_201590_e(), primer.func_201631_p(), (ITickList<Block>)primer.func_205218_i_(), (ITickList<Fluid>)primer.func_212247_j(), primer.func_209216_m());
        for (int i = 0; i < this.field_76652_q.length; ++i) {
            this.field_76652_q[i] = primer.func_76587_i()[i];
        }
        for (NBTTagCompound nbttagcompound : primer.func_201652_l()) {
            AnvilChunkLoader.func_186050_a(nbttagcompound, worldIn, this);
        }
        for (TileEntity tileentity : primer.func_201627_k().values()) {
            this.func_150813_a(tileentity);
        }
        this.field_201618_i.putAll(primer.func_201632_q());
        for (int j = 0; j < primer.func_201645_n().length; ++j) {
            this.field_201622_t[j] = primer.func_201645_n()[j];
        }
        this.func_201612_a(primer.func_201609_c());
        this.func_201606_b(primer.func_201604_d());
        for (Heightmap.Type heightmap$type : primer.func_201634_m()) {
            if (heightmap$type.func_207512_c() != Heightmap.Usage.LIVE_WORLD) continue;
            this.field_76634_f.computeIfAbsent(heightmap$type, p_205750_1_ -> new Heightmap((IChunk)this, p_205750_1_)).func_202268_a(primer.func_201642_a(heightmap$type).func_202269_a());
        }
        this.field_76643_l = true;
        this.func_201574_a(ChunkStatus.FULLCHUNK);
    }

    public Set<BlockPos> func_203066_o() {
        HashSet set = Sets.newHashSet(this.field_201618_i.keySet());
        set.addAll(this.field_150816_i.keySet());
        return set;
    }

    public boolean func_76600_a(int x, int z) {
        return x == this.field_76635_g && z == this.field_76647_h;
    }

    @Override
    public ChunkSection[] func_76587_i() {
        return this.field_76652_q;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void func_76590_a() {
        for (Heightmap heightmap : this.field_76634_f.values()) {
            heightmap.func_202266_a();
        }
        this.field_76643_l = true;
    }

    public void func_76603_b() {
        int i = this.func_76625_h();
        this.field_82912_p = Integer.MAX_VALUE;
        for (Heightmap heightmap : this.field_76634_f.values()) {
            heightmap.func_202266_a();
        }
        for (int i1 = 0; i1 < 16; ++i1) {
            for (int j1 = 0; j1 < 16; ++j1) {
                if (!this.field_76637_e.field_73011_w.func_191066_m()) continue;
                int j = 15;
                int k = i + 16 - 1;
                do {
                    ChunkSection chunksection;
                    int l;
                    if ((l = this.func_150808_b(i1, k, j1)) == 0 && j != 15) {
                        l = 1;
                    }
                    if ((j -= l) <= 0 || (chunksection = this.field_76652_q[k >> 4]) == field_186036_a) continue;
                    chunksection.func_76657_c(i1, k & 0xF, j1, j);
                    this.field_76637_e.func_175679_n(new BlockPos((this.field_76635_g << 4) + i1, k, (this.field_76647_h << 4) + j1));
                } while (--k > 0 && j > 0);
            }
        }
        this.field_76643_l = true;
    }

    private void func_76595_e(int x, int z) {
        this.field_76639_c[x + z * 16] = true;
        this.field_76650_s = true;
    }

    private void func_150803_c(boolean onlyOne) {
        this.field_76637_e.field_72984_F.func_76320_a("recheckGaps");
        if (this.field_76637_e.func_205050_e(new BlockPos(this.field_76635_g * 16 + 8, 0, this.field_76647_h * 16 + 8), 16)) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    if (!this.field_76639_c[i + j * 16]) continue;
                    this.field_76639_c[i + j * 16] = false;
                    int k = this.func_201576_a(Heightmap.Type.LIGHT_BLOCKING, i, j);
                    int l = this.field_76635_g * 16 + i;
                    int i1 = this.field_76647_h * 16 + j;
                    int j1 = Integer.MAX_VALUE;
                    for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                        j1 = Math.min(j1, this.field_76637_e.func_82734_g(l + enumfacing.func_82601_c(), i1 + enumfacing.func_82599_e()));
                    }
                    this.func_76599_g(l, i1, j1);
                    for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                        this.func_76599_g(l + enumfacing1.func_82601_c(), i1 + enumfacing1.func_82599_e(), k);
                    }
                    if (!onlyOne) continue;
                    this.field_76637_e.field_72984_F.func_76319_b();
                    return;
                }
            }
            this.field_76650_s = false;
        }
        this.field_76637_e.field_72984_F.func_76319_b();
    }

    private void func_76599_g(int x, int z, int maxValue) {
        int i = this.field_76637_e.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(x, 0, z)).func_177956_o();
        if (i > maxValue) {
            this.func_76609_d(x, z, maxValue, i + 1);
        } else if (i < maxValue) {
            this.func_76609_d(x, z, i, maxValue + 1);
        }
    }

    private void func_76609_d(int x, int z, int startY, int endY) {
        if (endY > startY && this.field_76637_e.func_205050_e(new BlockPos(x, 0, z), 16)) {
            for (int i = startY; i < endY; ++i) {
                this.field_76637_e.func_180500_c(EnumLightType.SKY, new BlockPos(x, i, z));
            }
            this.field_76643_l = true;
        }
    }

    private void func_76615_h(int x, int y, int z, IBlockState p_76615_4_) {
        Heightmap heightmap = this.field_76634_f.get(Heightmap.Type.LIGHT_BLOCKING);
        int i = heightmap.func_202273_a(x & 0xF, z & 0xF) & 0xFF;
        if (heightmap.func_202270_a(x, y, z, p_76615_4_)) {
            int j = heightmap.func_202273_a(x & 0xF, z & 0xF);
            int k = this.field_76635_g * 16 + x;
            int l = this.field_76647_h * 16 + z;
            this.field_76637_e.func_72975_g(k, l, j, i);
            if (this.field_76637_e.field_73011_w.func_191066_m()) {
                int i1 = Math.min(i, j);
                int j1 = Math.max(i, j);
                int k1 = j < i ? 15 : 0;
                for (int l1 = i1; l1 < j1; ++l1) {
                    ChunkSection chunksection = this.field_76652_q[l1 >> 4];
                    if (chunksection == field_186036_a) continue;
                    chunksection.func_76657_c(x, l1 & 0xF, z, k1);
                    this.field_76637_e.func_175679_n(new BlockPos((this.field_76635_g << 4) + x, l1, (this.field_76647_h << 4) + z));
                }
                int l2 = 15;
                while (j > 0 && l2 > 0) {
                    int i3;
                    i3 = (i3 = this.func_150808_b(x, --j, z)) == 0 ? 1 : i3;
                    l2 -= i3;
                    l2 = Math.max(0, l2);
                    ChunkSection chunksection1 = this.field_76652_q[j >> 4];
                    if (chunksection1 == field_186036_a) continue;
                    chunksection1.func_76657_c(x, j & 0xF, z, l2);
                }
            }
            if (j < this.field_82912_p) {
                this.field_82912_p = j;
            }
            if (this.field_76637_e.field_73011_w.func_191066_m()) {
                int i2 = heightmap.func_202273_a(x & 0xF, z & 0xF);
                int j2 = Math.min(i, i2);
                int k2 = Math.max(i, i2);
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    this.func_76609_d(k + enumfacing.func_82601_c(), l + enumfacing.func_82599_e(), j2, k2);
                }
                this.func_76609_d(k, l, j2, k2);
            }
            this.field_76643_l = true;
        }
    }

    private int func_150808_b(int x, int y, int z) {
        return this.func_186032_a(x, y, z).func_200016_a((IBlockReader)this.field_76637_e, new BlockPos(x, y, z));
    }

    public IBlockState func_180495_p(BlockPos pos) {
        return this.func_186032_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public IBlockState func_186032_a(int x, int y, int z) {
        if (this.field_76637_e.func_175624_G() == WorldType.field_180272_g) {
            IBlockState iblockstate = null;
            if (y == 60) {
                iblockstate = Blocks.field_180401_cv.func_176223_P();
            }
            if (y == 70) {
                iblockstate = ChunkGeneratorDebug.func_177461_b((int)x, (int)z);
            }
            return iblockstate == null ? Blocks.field_150350_a.func_176223_P() : iblockstate;
        }
        try {
            ChunkSection chunksection;
            if (y >= 0 && y >> 4 < this.field_76652_q.length && (chunksection = this.field_76652_q[y >> 4]) != field_186036_a) {
                return chunksection.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Getting block state");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being got");
            crashreportcategory.func_189529_a("Location", (ICrashReportDetail<String>)((ICrashReportDetail)() -> CrashReportCategory.func_184876_a(x, y, z)));
            throw new ReportedException(crashreport);
        }
    }

    public IFluidState func_204610_c(BlockPos pos) {
        return this.func_205751_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public IFluidState func_205751_b(int bx, int by, int bz) {
        try {
            ChunkSection chunksection;
            if (by >= 0 && by >> 4 < this.field_76652_q.length && (chunksection = this.field_76652_q[by >> 4]) != field_186036_a) {
                return chunksection.func_206914_b(bx & 0xF, by & 0xF, bz & 0xF);
            }
            return Fluids.field_204541_a.func_207188_f();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Getting fluid state");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being got");
            crashreportcategory.func_189529_a("Location", (ICrashReportDetail<String>)((ICrashReportDetail)() -> CrashReportCategory.func_184876_a(bx, by, bz)));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    @Nullable
    public IBlockState func_177436_a(BlockPos pos, IBlockState state, boolean isMoving) {
        TileEntity tileentity;
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        int k = pos.func_177952_p() & 0xF;
        int l = this.field_76634_f.get(Heightmap.Type.LIGHT_BLOCKING).func_202273_a(i, k);
        IBlockState iblockstate = this.func_180495_p(pos);
        if (iblockstate == state) {
            return null;
        }
        Block block = state.func_177230_c();
        Block block1 = iblockstate.func_177230_c();
        ChunkSection chunksection = this.field_76652_q[j >> 4];
        int j1 = iblockstate.func_200016_a((IBlockReader)this.field_76637_e, pos);
        boolean flag = false;
        if (chunksection == field_186036_a) {
            if (state.func_196958_f()) {
                return null;
            }
            this.field_76652_q[j >> 4] = chunksection = new ChunkSection(j >> 4 << 4, this.field_76637_e.field_73011_w.func_191066_m());
            flag = j >= l;
        }
        chunksection.func_177484_a(i, j & 0xF, k, state);
        this.field_76634_f.get(Heightmap.Type.MOTION_BLOCKING).func_202270_a(i, j, k, state);
        this.field_76634_f.get(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES).func_202270_a(i, j, k, state);
        this.field_76634_f.get(Heightmap.Type.OCEAN_FLOOR).func_202270_a(i, j, k, state);
        this.field_76634_f.get(Heightmap.Type.WORLD_SURFACE).func_202270_a(i, j, k, state);
        if (!this.field_76637_e.field_72995_K) {
            iblockstate.func_196947_b(this.field_76637_e, pos, state, isMoving);
        } else if (block1 != block && iblockstate.hasTileEntity()) {
            this.field_76637_e.func_175713_t(pos);
        }
        if (chunksection.func_177485_a(i, j & 0xF, k).func_177230_c() != block) {
            return null;
        }
        if (flag) {
            this.func_76603_b();
        } else {
            int i1 = state.func_200016_a((IBlockReader)this.field_76637_e, pos);
            this.func_76615_h(i, j, k, state);
            if (i1 != j1 && (i1 < j1 || this.func_177413_a(EnumLightType.SKY, pos) > 0 || this.func_177413_a(EnumLightType.BLOCK, pos) > 0)) {
                this.func_76595_e(i, k);
            }
        }
        if (iblockstate.hasTileEntity() && (tileentity = this.func_177424_a(pos, EnumCreateEntityType.CHECK)) != null) {
            tileentity.func_145836_u();
        }
        if (!this.field_76637_e.field_72995_K) {
            state.func_196945_a(this.field_76637_e, pos, iblockstate);
        }
        if (state.hasTileEntity()) {
            TileEntity tileentity1 = this.func_177424_a(pos, EnumCreateEntityType.CHECK);
            if (tileentity1 == null) {
                tileentity1 = state.createTileEntity((IBlockReader)this.field_76637_e);
                this.field_76637_e.func_175690_a(pos, tileentity1);
            } else {
                tileentity1.func_145836_u();
            }
        }
        this.field_76643_l = true;
        return iblockstate;
    }

    public int func_177413_a(EnumLightType type, BlockPos pos) {
        return this.func_201587_a(type, pos, this.field_76637_e.func_201675_m().func_191066_m());
    }

    @Override
    public int func_201587_a(EnumLightType lightType, BlockPos pos, boolean hasSkylight) {
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        int k = pos.func_177952_p() & 0xF;
        int l = j >> 4;
        if (l >= 0 && l <= this.field_76652_q.length - 1) {
            ChunkSection chunksection = this.field_76652_q[l];
            if (chunksection == field_186036_a) {
                return this.func_177444_d(pos) ? lightType.field_77198_c : 0;
            }
            if (lightType == EnumLightType.SKY) {
                return !hasSkylight ? 0 : chunksection.func_76670_c(i, j & 0xF, k);
            }
            return lightType == EnumLightType.BLOCK ? chunksection.func_76674_d(i, j & 0xF, k) : lightType.field_77198_c;
        }
        return (lightType != EnumLightType.SKY || !hasSkylight) && lightType != EnumLightType.BLOCK ? 0 : lightType.field_77198_c;
    }

    public void func_177431_a(EnumLightType type, BlockPos pos, int value) {
        this.func_201580_a(type, this.field_76637_e.func_201675_m().func_191066_m(), pos, value);
    }

    @Override
    public void func_201580_a(EnumLightType light, boolean hasSkylight, BlockPos pos, int lightValue) {
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        int k = pos.func_177952_p() & 0xF;
        int l = j >> 4;
        if (l < 16 && l >= 0) {
            ChunkSection chunksection = this.field_76652_q[l];
            if (chunksection == field_186036_a) {
                if (lightValue == light.field_77198_c) {
                    return;
                }
                this.field_76652_q[l] = chunksection = new ChunkSection(l << 4, hasSkylight);
                this.func_76603_b();
            }
            if (light == EnumLightType.SKY) {
                if (this.field_76637_e.field_73011_w.func_191066_m()) {
                    chunksection.func_76657_c(i, j & 0xF, k, lightValue);
                }
            } else if (light == EnumLightType.BLOCK) {
                chunksection.func_76677_d(i, j & 0xF, k, lightValue);
            }
            this.field_76643_l = true;
        }
    }

    public int func_177443_a(BlockPos pos, int amount) {
        return this.func_201586_a(pos, amount, this.field_76637_e.func_201675_m().func_191066_m());
    }

    @Override
    public int func_201586_a(BlockPos pos, int amount, boolean hasSkylight) {
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        int k = pos.func_177952_p() & 0xF;
        int l = j >> 4;
        if (l >= 0 && l <= this.field_76652_q.length - 1) {
            ChunkSection chunksection = this.field_76652_q[l];
            if (chunksection == field_186036_a) {
                return hasSkylight && amount < EnumLightType.SKY.field_77198_c ? EnumLightType.SKY.field_77198_c - amount : 0;
            }
            int i1 = hasSkylight ? chunksection.func_76670_c(i, j & 0xF, k) : 0;
            int j1 = chunksection.func_76674_d(i, j & 0xF, k);
            if (j1 > (i1 -= amount)) {
                i1 = j1;
            }
            return i1;
        }
        return 0;
    }

    @Override
    public void func_76612_a(Entity entityIn) {
        int k;
        this.field_76644_m = true;
        int i = MathHelper.func_76128_c((double)(entityIn.field_70165_t / 16.0));
        int j = MathHelper.func_76128_c((double)(entityIn.field_70161_v / 16.0));
        if (i != this.field_76635_g || j != this.field_76647_h) {
            field_150817_t.warn("Wrong location! ({}, {}) should be ({}, {}), {}", (Object)i, (Object)j, (Object)this.field_76635_g, (Object)this.field_76647_h, (Object)entityIn);
            entityIn.func_70106_y();
        }
        if ((k = MathHelper.func_76128_c((double)(entityIn.field_70163_u / 16.0))) < 0) {
            k = 0;
        }
        if (k >= this.field_76645_j.length) {
            k = this.field_76645_j.length - 1;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EntityEvent.EnteringChunk(entityIn, this.field_76635_g, this.field_76647_h, entityIn.field_70176_ah, entityIn.field_70164_aj));
        entityIn.field_70175_ag = true;
        entityIn.field_70176_ah = this.field_76635_g;
        entityIn.field_70162_ai = k;
        entityIn.field_70164_aj = this.field_76647_h;
        this.field_76645_j[k].add(entityIn);
        this.func_76630_e();
    }

    public void func_201607_a(Heightmap.Type type, long[] data) {
        this.field_76634_f.get(type).func_202268_a(data);
    }

    public void func_76622_b(Entity entityIn) {
        this.func_76608_a(entityIn, entityIn.field_70162_ai);
    }

    public void func_76608_a(Entity entityIn, int index) {
        if (index < 0) {
            index = 0;
        }
        if (index >= this.field_76645_j.length) {
            index = this.field_76645_j.length - 1;
        }
        this.field_76645_j[index].remove((Object)entityIn);
        this.func_76630_e();
    }

    @Override
    public boolean func_177444_d(BlockPos pos) {
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        int k = pos.func_177952_p() & 0xF;
        return j >= this.field_76634_f.get(Heightmap.Type.LIGHT_BLOCKING).func_202273_a(i, k);
    }

    @Override
    public int func_201576_a(Heightmap.Type heightmapType, int x, int z) {
        return this.field_76634_f.get(heightmapType).func_202273_a(x & 0xF, z & 0xF) - 1;
    }

    @Nullable
    private TileEntity func_177422_i(BlockPos pos) {
        IBlockState iblockstate = this.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        return !iblockstate.hasTileEntity() ? null : iblockstate.createTileEntity((IBlockReader)this.field_76637_e);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.func_177424_a(pos, EnumCreateEntityType.CHECK);
    }

    @Nullable
    public TileEntity func_177424_a(BlockPos pos, EnumCreateEntityType creationMode) {
        TileEntity tileentity1;
        NBTTagCompound nbttagcompound;
        TileEntity tileentity = this.field_150816_i.get(pos);
        if (tileentity != null && tileentity.func_145837_r()) {
            this.field_150816_i.remove(pos);
            tileentity = null;
        }
        if (tileentity == null && (nbttagcompound = this.field_201618_i.remove(pos)) != null && (tileentity1 = this.func_212815_a(pos, nbttagcompound)) != null) {
            return tileentity1;
        }
        if (tileentity == null) {
            if (creationMode == EnumCreateEntityType.IMMEDIATE) {
                tileentity = this.func_177422_i(pos);
                this.field_76637_e.func_175690_a(pos, tileentity);
            } else if (creationMode == EnumCreateEntityType.QUEUED) {
                this.field_177447_w.add(pos.func_185334_h());
            }
        }
        return tileentity;
    }

    public void func_150813_a(TileEntity tileEntityIn) {
        this.func_177426_a(tileEntityIn.func_174877_v(), tileEntityIn);
        if (this.field_76636_d) {
            this.field_76637_e.func_175700_a(tileEntityIn);
        }
    }

    @Override
    public void func_177426_a(BlockPos pos, TileEntity tileEntityIn) {
        if (tileEntityIn.func_145831_w() != this.field_76637_e) {
            tileEntityIn.func_145834_a(this.field_76637_e);
        }
        tileEntityIn.func_174878_a(pos);
        if (this.func_180495_p(pos).hasTileEntity()) {
            if (this.field_150816_i.containsKey(pos)) {
                this.field_150816_i.get(pos).func_145843_s();
            }
            tileEntityIn.func_145829_t();
            this.field_150816_i.put(pos.func_185334_h(), tileEntityIn);
        }
    }

    @Override
    public void func_201591_a(NBTTagCompound nbt) {
        this.field_201618_i.put(new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")), nbt);
    }

    @Override
    public void func_177425_e(BlockPos pos) {
        TileEntity tileentity;
        if (this.field_76636_d && (tileentity = this.field_150816_i.remove(pos)) != null) {
            tileentity.func_145843_s();
        }
    }

    public void func_76631_c() {
        this.field_76636_d = true;
        this.field_76637_e.func_147448_a(this.field_150816_i.values());
        for (ClassInheritanceMultiMap<Entity> classinheritancemultimap : this.field_76645_j) {
            this.field_76637_e.func_212420_a(classinheritancemultimap.stream().filter(p_212383_0_ -> !(p_212383_0_ instanceof EntityPlayer)));
        }
        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((IChunk)this));
    }

    public void func_76623_d() {
        Arrays.stream(this.field_76645_j).forEach(multimap -> Lists.newArrayList(multimap.func_180215_b(EntityPlayer.class)).forEach(player -> this.field_76637_e.func_72866_a((Entity)((Object)((Object)player)), false)));
        this.field_76636_d = false;
        for (TileEntity tileentity : this.field_150816_i.values()) {
            this.field_76637_e.func_147457_a(tileentity);
        }
        for (ClassInheritanceMultiMap<Entity> classinheritancemultimap : this.field_76645_j) {
            this.field_76637_e.func_175681_c(classinheritancemultimap);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((IChunk)this));
    }

    public void func_76630_e() {
        this.field_76643_l = true;
    }

    public void func_177414_a(@Nullable Entity entityIn, AxisAlignedBB aabb, List<Entity> listToFill, Predicate<? super Entity> filter) {
        int i = MathHelper.func_76128_c((double)((aabb.field_72338_b - this.field_76637_e.getMaxEntityRadius()) / 16.0));
        int j = MathHelper.func_76128_c((double)((aabb.field_72337_e + this.field_76637_e.getMaxEntityRadius()) / 16.0));
        i = MathHelper.func_76125_a((int)i, (int)0, (int)(this.field_76645_j.length - 1));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)(this.field_76645_j.length - 1));
        for (int k = i; k <= j; ++k) {
            if (this.field_76645_j[k].isEmpty()) continue;
            for (Entity entity : this.field_76645_j[k]) {
                Entity[] aentity;
                if (!entity.func_174813_aQ().func_72326_a(aabb) || entity == entityIn) continue;
                if (filter == null || filter.test(entity)) {
                    listToFill.add(entity);
                }
                if ((aentity = entity.func_70021_al()) == null) continue;
                for (Entity entity1 : aentity) {
                    if (entity1 == entityIn || !entity1.func_174813_aQ().func_72326_a(aabb) || filter != null && !filter.test(entity1)) continue;
                    listToFill.add(entity1);
                }
            }
        }
    }

    public <T extends Entity> void func_177430_a(Class<? extends T> entityClass, AxisAlignedBB aabb, List<T> listToFill, @Nullable Predicate<? super T> filter) {
        int i = MathHelper.func_76128_c((double)((aabb.field_72338_b - this.field_76637_e.getMaxEntityRadius()) / 16.0));
        int j = MathHelper.func_76128_c((double)((aabb.field_72337_e + this.field_76637_e.getMaxEntityRadius()) / 16.0));
        i = MathHelper.func_76125_a((int)i, (int)0, (int)(this.field_76645_j.length - 1));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)(this.field_76645_j.length - 1));
        for (int k = i; k <= j; ++k) {
            for (Entity t : this.field_76645_j[k].func_180215_b(entityClass)) {
                if (!t.func_174813_aQ().func_72326_a(aabb) || filter != null && !filter.test(t)) continue;
                listToFill.add((T)((Object)t));
            }
        }
    }

    public boolean func_76601_a(boolean p_76601_1_) {
        if (p_76601_1_ ? this.field_76644_m && this.field_76637_e.func_82737_E() != this.field_76641_n || this.field_76643_l : this.field_76644_m && this.field_76637_e.func_82737_E() >= this.field_76641_n + 600L) {
            return true;
        }
        return this.field_76643_l;
    }

    public boolean func_76621_g() {
        return false;
    }

    public void func_150804_b(boolean skipRecheckGaps) {
        if (this.field_76650_s && this.field_76637_e.field_73011_w.func_191066_m() && !skipRecheckGaps) {
            this.func_150803_c(this.field_76637_e.field_72995_K);
        }
        this.field_150815_m = true;
        while (!this.field_177447_w.isEmpty()) {
            BlockPos blockpos = this.field_177447_w.poll();
            if (this.func_177424_a(blockpos, EnumCreateEntityType.CHECK) != null || !this.func_180495_p(blockpos).hasTileEntity()) continue;
            TileEntity tileentity = this.func_177422_i(blockpos);
            this.field_76637_e.func_175690_a(blockpos, tileentity);
            this.field_76637_e.func_175704_b(blockpos, blockpos);
        }
    }

    public boolean func_150802_k() {
        return this.field_201616_C.func_209003_a(ChunkStatus.POSTPROCESSED);
    }

    public boolean func_186035_j() {
        return this.field_150815_m;
    }

    @Override
    public ChunkPos func_76632_l() {
        return this.field_212816_F;
    }

    public boolean func_76606_c(int startY, int endY) {
        if (startY < 0) {
            startY = 0;
        }
        if (endY >= 256) {
            endY = 255;
        }
        for (int i = startY; i <= endY; i += 16) {
            ChunkSection chunksection = this.field_76652_q[i >> 4];
            if (chunksection == field_186036_a || chunksection.func_76663_a()) continue;
            return false;
        }
        return true;
    }

    public void func_76602_a(ChunkSection[] newStorageArrays) {
        if (this.field_76652_q.length != newStorageArrays.length) {
            field_150817_t.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)newStorageArrays.length, (Object)this.field_76652_q.length);
        } else {
            System.arraycopy(newStorageArrays, 0, this.field_76652_q, 0, this.field_76652_q.length);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_186033_a(PacketBuffer buf, int availableSections, boolean fullChunk) {
        for (TileEntity tileEntity : this.field_150816_i.values()) {
            tileEntity.func_145836_u();
            tileEntity.func_195044_w();
        }
        if (fullChunk) {
            this.field_150816_i.clear();
        } else {
            Iterator<BlockPos> iterator = this.field_150816_i.keySet().iterator();
            while (iterator.hasNext()) {
                BlockPos blockpos = iterator.next();
                int i = blockpos.func_177956_o() >> 4;
                if ((availableSections & 1 << i) == 0) continue;
                iterator.remove();
            }
        }
        boolean flag = this.field_76637_e.field_73011_w.func_191066_m();
        for (int j = 0; j < this.field_76652_q.length; ++j) {
            ChunkSection chunksection = this.field_76652_q[j];
            if ((availableSections & 1 << j) == 0) {
                if (!fullChunk || chunksection == field_186036_a) continue;
                this.field_76652_q[j] = field_186036_a;
                continue;
            }
            if (chunksection == field_186036_a) {
                this.field_76652_q[j] = chunksection = new ChunkSection(j << 4, flag);
            }
            chunksection.func_186049_g().func_186010_a(buf);
            buf.readBytes(chunksection.func_76661_k().func_177481_a());
            if (!flag) continue;
            buf.readBytes(chunksection.func_76671_l().func_177481_a());
        }
        if (fullChunk) {
            for (int k = 0; k < this.field_76651_r.length; ++k) {
                this.field_76651_r[k] = IRegistry.field_212624_m.func_148754_a(buf.readInt());
            }
        }
        for (int l = 0; l < this.field_76652_q.length; ++l) {
            if (this.field_76652_q[l] == field_186036_a || (availableSections & 1 << l) == 0) continue;
            this.field_76652_q[l].func_76672_e();
        }
        this.func_76590_a();
        for (TileEntity tileentity : this.field_150816_i.values()) {
            tileentity.func_145836_u();
        }
    }

    public Biome func_201600_k(BlockPos pos) {
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177952_p() & 0xF;
        return this.field_76651_r[j << 4 | i];
    }

    @Override
    public Biome[] func_201590_e() {
        return this.field_76651_r;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_76613_n() {
        this.field_76649_t = 0;
    }

    public void func_76594_o() {
        if (this.field_76649_t < 4096) {
            BlockPos blockpos = new BlockPos(this.field_76635_g << 4, 0, this.field_76647_h << 4);
            for (int i = 0; i < 8; ++i) {
                if (this.field_76649_t >= 4096) {
                    return;
                }
                int j = this.field_76649_t % 16;
                int k = this.field_76649_t / 16 % 16;
                int l = this.field_76649_t / 256;
                ++this.field_76649_t;
                for (int i1 = 0; i1 < 16; ++i1) {
                    boolean flag;
                    BlockPos blockpos1 = blockpos.func_177982_a(k, (j << 4) + i1, l);
                    boolean bl = flag = i1 == 0 || i1 == 15 || k == 0 || k == 15 || l == 0 || l == 15;
                    if ((this.field_76652_q[j] != field_186036_a || !flag) && (this.field_76652_q[j] == field_186036_a || !this.field_76652_q[j].func_177485_a(k, i1, l).isAir((IBlockReader)this.field_76637_e, blockpos1))) continue;
                    for (EnumFacing enumfacing : EnumFacing.values()) {
                        BlockPos blockpos2 = blockpos1.func_177972_a(enumfacing);
                        if (this.field_76637_e.func_180495_p(blockpos2).getLightValue(this.field_76637_e, blockpos2) <= 0) continue;
                        this.field_76637_e.func_175664_x(blockpos2);
                    }
                    this.field_76637_e.func_175664_x(blockpos1);
                }
            }
        }
    }

    public boolean func_177410_o() {
        return this.field_76636_d;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_177417_c(boolean loaded) {
        this.field_76636_d = loaded;
    }

    public World func_177412_p() {
        return this.field_76637_e;
    }

    public Set<Heightmap.Type> func_201615_v() {
        return this.field_76634_f.keySet();
    }

    public Heightmap func_201608_a(Heightmap.Type type) {
        return this.field_76634_f.get(type);
    }

    public Map<BlockPos, TileEntity> func_177434_r() {
        return this.field_150816_i;
    }

    public ClassInheritanceMultiMap<Entity>[] func_177429_s() {
        return this.field_76645_j;
    }

    @Override
    public NBTTagCompound func_201579_g(BlockPos pos) {
        return this.field_201618_i.get(pos);
    }

    @Override
    public ITickList<Block> func_205218_i_() {
        return this.field_201621_s;
    }

    @Override
    public ITickList<Fluid> func_212247_j() {
        return this.field_205325_u;
    }

    @Override
    public BitSet func_205749_a(GenerationStage.Carving type) {
        throw new RuntimeException("Not yet implemented");
    }

    public void func_177427_f(boolean modified) {
        this.field_76643_l = modified;
    }

    public void func_177409_g(boolean hasEntitiesIn) {
        this.field_76644_m = hasEntitiesIn;
    }

    @Override
    public void func_177432_b(long saveTime) {
        this.field_76641_n = saveTime;
    }

    @Override
    @Nullable
    public StructureStart func_201585_a(String stucture) {
        return this.field_201619_q.get(stucture);
    }

    @Override
    public void func_201584_a(String structureIn, StructureStart structureStartIn) {
        this.field_201619_q.put(structureIn, structureStartIn);
    }

    @Override
    public Map<String, StructureStart> func_201609_c() {
        return this.field_201619_q;
    }

    public void func_201612_a(Map<String, StructureStart> structureStartsIn) {
        this.field_201619_q.clear();
        this.field_201619_q.putAll(structureStartsIn);
    }

    @Override
    @Nullable
    public LongSet func_201578_b(String structureIn) {
        return this.field_201620_r.computeIfAbsent(structureIn, p_201603_0_ -> new LongOpenHashSet());
    }

    @Override
    public void func_201583_a(String strucutre, long reference) {
        this.field_201620_r.computeIfAbsent(strucutre, p_201598_0_ -> new LongOpenHashSet()).add(reference);
    }

    @Override
    public Map<String, LongSet> func_201604_d() {
        return this.field_201620_r;
    }

    public void func_201606_b(Map<String, LongSet> p_201606_1_) {
        this.field_201620_r.clear();
        this.field_201620_r.putAll(p_201606_1_);
    }

    public int func_177442_v() {
        return this.field_82912_p;
    }

    public long func_177416_w() {
        return this.field_111204_q;
    }

    public void func_177415_c(long newInhabitedTime) {
        this.field_111204_q = newInhabitedTime;
    }

    public void func_201595_A() {
        if (!this.field_201616_C.func_209003_a(ChunkStatus.POSTPROCESSED) && this.field_201617_D == 8) {
            ChunkPos chunkpos = this.func_76632_l();
            for (int i = 0; i < this.field_201622_t.length; ++i) {
                if (this.field_201622_t[i] == null) continue;
                for (Short oshort : this.field_201622_t[i]) {
                    BlockPos blockpos = ChunkPrimer.func_201635_a((short)oshort, (int)i, (ChunkPos)chunkpos);
                    IBlockState iblockstate = this.field_76637_e.func_180495_p(blockpos);
                    IBlockState iblockstate1 = Block.func_199770_b(iblockstate, this.field_76637_e, blockpos);
                    this.field_76637_e.func_180501_a(blockpos, iblockstate1, 20);
                }
                this.field_201622_t[i].clear();
            }
            if (this.field_201621_s instanceof ChunkPrimerTickList) {
                ((ChunkPrimerTickList)this.field_201621_s).func_205381_a(this.field_76637_e.func_205220_G_(), p_205323_1_ -> this.field_76637_e.func_180495_p((BlockPos)p_205323_1_).func_177230_c());
            }
            if (this.field_205325_u instanceof ChunkPrimerTickList) {
                ((ChunkPrimerTickList)this.field_205325_u).func_205381_a(this.field_76637_e.func_205219_F_(), p_205324_1_ -> this.field_76637_e.func_204610_c((BlockPos)p_205324_1_).func_206886_c());
            }
            for (BlockPos blockpos1 : new HashSet<BlockPos>(this.field_201618_i.keySet())) {
                this.func_175625_s(blockpos1);
            }
            this.field_201618_i.clear();
            this.func_201574_a(ChunkStatus.POSTPROCESSED);
            this.field_196967_n.func_196990_a(this);
        }
    }

    @Nullable
    private TileEntity func_212815_a(BlockPos p_212815_1_, NBTTagCompound p_212815_2_) {
        TileEntity tileentity;
        if ("DUMMY".equals(p_212815_2_.func_74779_i("id"))) {
            IBlockState state = this.func_180495_p(p_212815_1_);
            if (state.hasTileEntity()) {
                tileentity = state.createTileEntity((IBlockReader)this.field_76637_e);
            } else {
                tileentity = null;
                field_150817_t.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)p_212815_1_, (Object)this.func_180495_p(p_212815_1_));
            }
        } else {
            tileentity = TileEntity.func_203403_c(p_212815_2_);
        }
        if (tileentity != null) {
            tileentity.func_174878_a(p_212815_1_);
            this.func_150813_a(tileentity);
        } else {
            field_150817_t.warn("Tried to load a block entity for block {} but failed at location {}", (Object)this.func_180495_p(p_212815_1_), (Object)p_212815_1_);
        }
        return tileentity;
    }

    public UpgradeData func_196966_y() {
        return this.field_196967_n;
    }

    public ShortList[] func_201614_D() {
        return this.field_201622_t;
    }

    public void func_201610_a(short p_201610_1_, int p_201610_2_) {
        ChunkPrimer.func_205330_a((ShortList[])this.field_201622_t, (int)p_201610_2_).add(p_201610_1_);
    }

    @Override
    public ChunkStatus func_201589_g() {
        return this.field_201616_C;
    }

    @Override
    public void func_201574_a(ChunkStatus status) {
        this.field_201616_C = status;
    }

    public void func_201613_c(String statusIn) {
        this.func_201574_a(ChunkStatus.func_202127_a((String)statusIn));
    }

    public void func_201605_F() {
        ++this.field_201617_D;
        if (this.field_201617_D > 8) {
            throw new RuntimeException("Error while adding chunk to cache. Too many neighbors");
        }
        if (this.func_201596_H()) {
            ((IThreadListener)this.field_76637_e).func_152344_a(this::func_201595_A);
        }
    }

    public void func_201611_G() {
        --this.field_201617_D;
        if (this.field_201617_D < 0) {
            throw new RuntimeException("Error while removing chunk from cache. Not enough neighbors");
        }
    }

    public boolean func_201596_H() {
        return this.field_201617_D == 8;
    }

    @Deprecated
    @Nullable
    public final NBTTagCompound writeCapsToNBT() {
        return this.serializeCaps();
    }

    @Deprecated
    public final void readCapsFromNBT(NBTTagCompound tag) {
        this.deserializeCaps(tag);
    }

    @Override
    public World getWorldForge() {
        return this.func_177412_p();
    }

    public static enum EnumCreateEntityType {
        IMMEDIATE,
        QUEUED,
        CHECK;

    }
}

