/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.stats.StatType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.registries.GameData;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface IRegistry<T>
extends IObjectIntIterable<T> {
    public static final Logger field_212616_e = LogManager.getLogger();
    public static final IRegistry<IRegistry<?>> field_212617_f = new RegistryNamespaced();
    @Deprecated
    public static final IRegistry<Block> field_212618_g = IRegistry.func_212610_a("block", GameData.getWrapperDefaulted(Block.class));
    public static final IRegistry<Fluid> field_212619_h = IRegistry.func_212610_a("fluid", new RegistryNamespacedDefaultedByKey(new ResourceLocation("empty")));
    public static final IRegistry<PaintingType> field_212620_i = IRegistry.func_212610_a("motive", new RegistryNamespacedDefaultedByKey(new ResourceLocation("kebab")));
    @Deprecated
    public static final IRegistry<PotionType> field_212621_j = IRegistry.func_212610_a("potion", GameData.getWrapperDefaulted(PotionType.class));
    @Deprecated
    public static final IRegistry<DimensionType> field_212622_k = IRegistry.func_212610_a("dimension_type", DimensionManager.getRegistry());
    public static final IRegistry<ResourceLocation> field_212623_l = IRegistry.func_212610_a("custom_stat", new RegistryNamespaced());
    @Deprecated
    public static final IRegistry<Biome> field_212624_m = IRegistry.func_212610_a("biome", GameData.getWrapper(Biome.class));
    public static final IRegistry<BiomeProviderType<?, ?>> field_212625_n = IRegistry.func_212610_a("biome_source_type", new RegistryNamespaced());
    @Deprecated
    public static final IRegistry<TileEntityType<?>> field_212626_o = IRegistry.func_212610_a("block_entity_type", GameData.getWrapper(TileEntityType.class));
    public static final IRegistry<ChunkGeneratorType<?, ?>> field_212627_p = IRegistry.func_212610_a("chunk_generator_type", new RegistryNamespaced());
    @Deprecated
    public static final IRegistry<Enchantment> field_212628_q = IRegistry.func_212610_a("enchantment", GameData.getWrapper(Enchantment.class));
    @Deprecated
    public static final IRegistry<EntityType<?>> field_212629_r = IRegistry.func_212610_a("entity_type", GameData.getWrapper(EntityType.class));
    @Deprecated
    public static final IRegistry<Item> field_212630_s = IRegistry.func_212610_a("item", GameData.getWrapper(Item.class));
    @Deprecated
    public static final IRegistry<Potion> field_212631_t = IRegistry.func_212610_a("mob_effect", GameData.getWrapper(Potion.class));
    public static final IRegistry<ParticleType<? extends IParticleData>> field_212632_u = IRegistry.func_212610_a("particle_type", new RegistryNamespaced());
    @Deprecated
    public static final IRegistry<SoundEvent> field_212633_v = IRegistry.func_212610_a("sound_event", GameData.getWrapper(SoundEvent.class));
    public static final IRegistry<StatType<?>> field_212634_w = IRegistry.func_212610_a("stats", new RegistryNamespaced());

    public static <T> IRegistry<T> func_212610_a(String p_212610_0_, IRegistry<T> p_212610_1_) {
        field_212617_f.func_82595_a(new ResourceLocation(p_212610_0_), p_212610_1_);
        return p_212610_1_;
    }

    public static void func_212613_e() {
        field_212617_f.forEach(p_212606_0_ -> {
            if (p_212606_0_.func_195866_d()) {
                field_212616_e.error("Registry '{}' was empty after loading", (Object)field_212617_f.func_177774_c((IRegistry<?>)p_212606_0_));
                if (SharedConstants.field_206244_b) {
                    throw new IllegalStateException("Registry: '" + field_212617_f.func_177774_c((IRegistry<?>)p_212606_0_) + "' is empty, not allowed, fix me!");
                }
            }
            if (p_212606_0_ instanceof RegistryNamespacedDefaultedByKey) {
                ResourceLocation resourcelocation = p_212606_0_.func_212609_b();
                Validate.notNull(p_212606_0_.func_212608_b(resourcelocation), (String)("Missing default of DefaultedMappedRegistry: " + resourcelocation), (Object[])new Object[0]);
            }
        });
    }

    @Nullable
    public ResourceLocation func_177774_c(T var1);

    public T func_82594_a(@Nullable ResourceLocation var1);

    public ResourceLocation func_212609_b();

    public int func_148757_b(@Nullable T var1);

    @Nullable
    public T func_148754_a(int var1);

    public Iterator<T> iterator();

    @Nullable
    public T func_212608_b(@Nullable ResourceLocation var1);

    public void func_177775_a(int var1, ResourceLocation var2, T var3);

    public void func_82595_a(ResourceLocation var1, T var2);

    public Set<ResourceLocation> func_148742_b();

    public boolean func_195866_d();

    @Nullable
    public T func_186801_a(Random var1);

    default public Stream<T> func_201756_e() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean func_212607_c(ResourceLocation var1);
}

