/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.crafting.VanillaRecipeTypes;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityFurnace
extends TileEntityLockable
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickable {
    private static final int[] field_145962_k = new int[]{0};
    private static final int[] field_145959_l = new int[]{2, 1};
    private static final int[] field_145960_m = new int[]{1};
    private NonNullList<ItemStack> field_145957_n = NonNullList.func_191197_a((int)3, (Object)((Object)ItemStack.field_190927_a));
    private int field_145956_a;
    private int field_145963_i;
    private int field_174906_k;
    private int field_174905_l;
    private ITextComponent field_145958_o;
    private final Map<ResourceLocation, Integer> field_203901_m = Maps.newHashMap();
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (EnumFacing[])new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH});

    private static void func_201563_a(Map<Item, Integer> map, Tag<Item> tagIn, int time) {
        for (Item item : tagIn.func_199885_a()) {
            map.put(item, time);
        }
    }

    private static void func_203065_a(Map<Item, Integer> map, IItemProvider itemProvider, int time) {
        map.put(itemProvider.func_199767_j(), time);
    }

    public static Map<Item, Integer> func_201564_p() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        TileEntityFurnace.func_203065_a(map, Items.field_151129_at, 20000);
        TileEntityFurnace.func_203065_a(map, Blocks.field_150402_ci, 16000);
        TileEntityFurnace.func_203065_a(map, Items.field_151072_bj, 2400);
        TileEntityFurnace.func_203065_a(map, Items.field_151044_h, 1600);
        TileEntityFurnace.func_203065_a(map, Items.field_196155_l, 1600);
        TileEntityFurnace.func_201563_a(map, ItemTags.field_200038_h, 300);
        TileEntityFurnace.func_201563_a(map, ItemTags.field_199905_b, 300);
        TileEntityFurnace.func_201563_a(map, ItemTags.field_202898_h, 300);
        TileEntityFurnace.func_201563_a(map, ItemTags.field_202899_i, 150);
        TileEntityFurnace.func_201563_a(map, ItemTags.field_212188_k, 300);
        TileEntityFurnace.func_201563_a(map, ItemTags.field_202900_j, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_180407_aO, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_180404_aQ, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_180408_aP, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_180403_aR, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_180406_aS, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_180405_aT, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_180390_bo, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_180392_bq, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_180391_bp, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_180386_br, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_180385_bs, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_180387_bt, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_196586_al, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_150342_X, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_150421_aI, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_150486_ae, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_150447_bR, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_150462_ai, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_150453_bW, 300);
        TileEntityFurnace.func_201563_a(map, ItemTags.field_202901_n, 300);
        TileEntityFurnace.func_203065_a(map, Items.field_151031_f, 300);
        TileEntityFurnace.func_203065_a(map, Items.field_151112_aM, 300);
        TileEntityFurnace.func_203065_a(map, Blocks.field_150468_ap, 300);
        TileEntityFurnace.func_203065_a(map, Items.field_151155_ap, 200);
        TileEntityFurnace.func_203065_a(map, Items.field_151038_n, 200);
        TileEntityFurnace.func_203065_a(map, Items.field_151041_m, 200);
        TileEntityFurnace.func_203065_a(map, Items.field_151017_I, 200);
        TileEntityFurnace.func_203065_a(map, Items.field_151053_p, 200);
        TileEntityFurnace.func_203065_a(map, Items.field_151039_o, 200);
        TileEntityFurnace.func_201563_a(map, ItemTags.field_200154_g, 200);
        TileEntityFurnace.func_201563_a(map, ItemTags.field_202902_o, 200);
        TileEntityFurnace.func_201563_a(map, ItemTags.field_199904_a, 100);
        TileEntityFurnace.func_201563_a(map, ItemTags.field_200153_d, 100);
        TileEntityFurnace.func_203065_a(map, Items.field_151055_y, 100);
        TileEntityFurnace.func_201563_a(map, ItemTags.field_200037_g, 100);
        TileEntityFurnace.func_203065_a(map, Items.field_151054_z, 100);
        TileEntityFurnace.func_201563_a(map, ItemTags.field_200035_e, 67);
        TileEntityFurnace.func_203065_a(map, Blocks.field_203216_jz, 4001);
        return map;
    }

    public TileEntityFurnace() {
        super(TileEntityType.field_200971_b);
    }

    public int func_70302_i_() {
        return this.field_145957_n.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.field_145957_n) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)((Object)this.field_145957_n.get(index));
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.field_145957_n, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.field_145957_n, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)((Object)this.field_145957_n.get(index));
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a(stack, itemstack);
        this.field_145957_n.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.field_174905_l = this.func_201562_r();
            this.field_174906_k = 0;
            this.func_70296_d();
        }
    }

    public ITextComponent func_200200_C_() {
        return this.field_145958_o != null ? this.field_145958_o : new TextComponentTranslation("container.furnace", new Object[0]);
    }

    public boolean func_145818_k_() {
        return this.field_145958_o != null;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.field_145958_o;
    }

    public void func_200225_a(@Nullable ITextComponent name) {
        this.field_145958_o = name;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.field_145957_n = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)((Object)ItemStack.field_190927_a));
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.field_145957_n);
        this.field_145956_a = compound.func_74762_e("BurnTime");
        this.field_174906_k = compound.func_74762_e("CookTime");
        this.field_174905_l = compound.func_74762_e("CookTimeTotal");
        this.field_145963_i = TileEntityFurnace.func_145952_a((ItemStack)((Object)this.field_145957_n.get(1)));
        int i = compound.func_74765_d("RecipesUsedSize");
        for (int j = 0; j < i; ++j) {
            ResourceLocation resourcelocation = new ResourceLocation(compound.func_74779_i("RecipeLocation" + j));
            int k = compound.func_74762_e("RecipeAmount" + j);
            this.field_203901_m.put(resourcelocation, k);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.field_145958_o = ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("CustomName"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.field_145956_a);
        compound.func_74768_a("CookTime", this.field_174906_k);
        compound.func_74768_a("CookTimeTotal", this.field_174905_l);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.field_145957_n);
        compound.func_74777_a("RecipesUsedSize", (short)this.field_203901_m.size());
        int i = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : this.field_203901_m.entrySet()) {
            compound.func_74778_a("RecipeLocation" + i, entry.getKey().toString());
            compound.func_74768_a("RecipeAmount" + i, entry.getValue());
            ++i;
        }
        if (this.field_145958_o != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.field_145958_o));
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    private boolean func_145950_i() {
        return this.field_145956_a > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean func_174903_a(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.func_145950_i();
        boolean flag1 = false;
        if (this.func_145950_i()) {
            --this.field_145956_a;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)((Object)this.field_145957_n.get(1));
            if (this.func_145950_i() || !itemstack.func_190926_b() && !((ItemStack)((Object)this.field_145957_n.get(0))).func_190926_b()) {
                IRecipe irecipe = this.field_145850_b.func_199532_z().getRecipe((IInventory)this, this.field_145850_b, VanillaRecipeTypes.SMELTING);
                if (!this.func_145950_i() && this.func_201566_b(irecipe)) {
                    this.field_145963_i = this.field_145956_a = TileEntityFurnace.func_145952_a(itemstack);
                    if (this.func_145950_i()) {
                        flag1 = true;
                        if (itemstack.hasContainerItem()) {
                            this.field_145957_n.set(1, (Object)itemstack.getContainerItem());
                        } else if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                Item item1 = item.func_77668_q();
                                this.field_145957_n.set(1, (Object)(item1 == null ? ItemStack.field_190927_a : new ItemStack(item1)));
                            }
                        }
                    }
                }
                if (this.func_145950_i() && this.func_201566_b(irecipe)) {
                    ++this.field_174906_k;
                    if (this.field_174906_k == this.field_174905_l) {
                        this.field_174906_k = 0;
                        this.field_174905_l = this.func_201562_r();
                        this.func_201565_c(irecipe);
                        flag1 = true;
                    }
                } else {
                    this.field_174906_k = 0;
                }
            } else if (!this.func_145950_i() && this.field_174906_k > 0) {
                this.field_174906_k = MathHelper.func_76125_a((int)(this.field_174906_k - 2), (int)0, (int)this.field_174905_l);
            }
            if (flag != this.func_145950_i()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (IBlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)BlockFurnace.field_196325_b, Boolean.valueOf(this.func_145950_i())), 3);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private int func_201562_r() {
        FurnaceRecipe furnacerecipe = (FurnaceRecipe)this.field_145850_b.func_199532_z().getRecipe((IInventory)this, this.field_145850_b, VanillaRecipeTypes.SMELTING);
        return furnacerecipe != null ? furnacerecipe.func_201830_h() : 200;
    }

    private boolean func_201566_b(@Nullable IRecipe recipe) {
        if (!((ItemStack)((Object)this.field_145957_n.get(0))).func_190926_b() && recipe != null) {
            ItemStack itemstack = recipe.func_77571_b();
            if (itemstack.func_190926_b()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)((Object)this.field_145957_n.get(2));
            if (itemstack1.func_190926_b()) {
                return true;
            }
            if (!itemstack1.func_77969_a(itemstack)) {
                return false;
            }
            if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() < itemstack1.func_77976_d()) {
                return true;
            }
            return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
        }
        return false;
    }

    private void func_201565_c(@Nullable IRecipe recipe) {
        if (recipe != null && this.func_201566_b(recipe)) {
            ItemStack itemstack = (ItemStack)((Object)this.field_145957_n.get(0));
            ItemStack itemstack1 = recipe.func_77571_b();
            ItemStack itemstack2 = (ItemStack)((Object)this.field_145957_n.get(2));
            if (itemstack2.func_190926_b()) {
                this.field_145957_n.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_201561_a(this.field_145850_b, null, recipe);
            }
            if (itemstack.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !((ItemStack)((Object)this.field_145957_n.get(1))).func_190926_b() && ((ItemStack)((Object)this.field_145957_n.get(1))).func_77973_b() == Items.field_151133_ar) {
                this.field_145957_n.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    private static int func_145952_a(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        int ret = stack.getBurnTime();
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)(ret == -1 ? TileEntityFurnace.func_201564_p().getOrDefault((Object)item, 0) : ret));
    }

    public static boolean func_145954_b(ItemStack stack) {
        return TileEntityFurnace.func_145952_a(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)((Object)this.field_145957_n.get(1));
        return TileEntityFurnace.func_145954_b(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && itemstack.func_77973_b() != Items.field_151133_ar;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return field_145959_l;
        }
        return side == EnumFacing.UP ? field_145962_k : field_145960_m;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public String func_174875_k() {
        return "minecraft:furnace";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFurnace(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.field_145956_a;
            }
            case 1: {
                return this.field_145963_i;
            }
            case 2: {
                return this.field_174906_k;
            }
            case 3: {
                return this.field_174905_l;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.field_145956_a = value;
                break;
            }
            case 1: {
                this.field_145963_i = value;
                break;
            }
            case 2: {
                this.field_174906_k = value;
                break;
            }
            case 3: {
                this.field_174905_l = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.field_145957_n.clear();
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack itemstack : this.field_145957_n) {
            helper.func_194112_a(itemstack);
        }
    }

    public void func_193056_a(IRecipe recipe) {
        if (this.field_203901_m.containsKey(recipe.func_199560_c())) {
            this.field_203901_m.put(recipe.func_199560_c(), this.field_203901_m.get(recipe.func_199560_c()) + 1);
        } else {
            this.field_203901_m.put(recipe.func_199560_c(), 1);
        }
    }

    @Nullable
    public IRecipe func_193055_i() {
        return null;
    }

    public Map<ResourceLocation, Integer> func_203900_q() {
        return this.field_203901_m;
    }

    public boolean func_201561_a(World worldIn, EntityPlayerMP player, @Nullable IRecipe recipe) {
        if (recipe != null) {
            this.func_193056_a(recipe);
            return true;
        }
        return false;
    }

    public void func_201560_d(EntityPlayer player) {
        if (!this.field_145850_b.func_82736_K().func_82766_b("doLimitedCrafting")) {
            ArrayList list = Lists.newArrayList();
            for (ResourceLocation resourcelocation : this.field_203901_m.keySet()) {
                IRecipe irecipe = player.field_70170_p.func_199532_z().func_199517_a(resourcelocation);
                if (irecipe == null) continue;
                list.add(irecipe);
            }
            player.func_195065_a(list);
        }
        this.field_203901_m.clear();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.UP) {
                return this.handlers[0].cast();
            }
            if (facing == EnumFacing.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }
}

