/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEntityChest
extends TileEntityLockableLoot
implements IChestLid,
ITickable {
    private NonNullList<ItemStack> field_145985_p = NonNullList.func_191197_a((int)27, (Object)((Object)ItemStack.field_190927_a));
    protected float field_145989_m;
    protected float field_145986_n;
    protected int field_145987_o;
    private int field_145983_q;
    private LazyOptional<IItemHandlerModifiable> chestHandler;

    protected TileEntityChest(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    public TileEntityChest() {
        this(TileEntityType.field_200972_c);
    }

    public int func_70302_i_() {
        return 27;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.field_145985_p) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ITextComponent func_200200_C_() {
        ITextComponent itextcomponent = this.func_200201_e();
        return itextcomponent != null ? itextcomponent : new TextComponentTranslation("container.chest", new Object[0]);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.field_145985_p = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)((Object)ItemStack.field_190927_a));
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.field_145985_p);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.field_190577_o = ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("CustomName"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        ITextComponent itextcomponent;
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.field_145985_p);
        }
        if ((itextcomponent = this.func_200201_e()) != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)itextcomponent));
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.field_145983_q;
        if (!this.field_145850_b.field_72995_K && this.field_145987_o != 0 && (this.field_145983_q + i + j + k) % 200 == 0) {
            this.field_145987_o = 0;
            float f = 5.0f;
            for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - 5.0f), (double)((float)j - 5.0f), (double)((float)k - 5.0f), (double)((float)(i + 1) + 5.0f), (double)((float)(j + 1) + 5.0f), (double)((float)(k + 1) + 5.0f)))) {
                IInventory iinventory;
                if (!(entityplayer.field_71070_bA instanceof ContainerChest) || (iinventory = ((ContainerChest)entityplayer.field_71070_bA).func_85151_d()) != this && (!(iinventory instanceof InventoryLargeChest) || !((InventoryLargeChest)iinventory).func_90010_a((IInventory)this))) continue;
                ++this.field_145987_o;
            }
        }
        this.field_145986_n = this.field_145989_m;
        float f1 = 0.1f;
        if (this.field_145987_o > 0 && this.field_145989_m == 0.0f) {
            this.func_195483_a(SoundEvents.field_187657_V);
        }
        if (this.field_145987_o == 0 && this.field_145989_m > 0.0f || this.field_145987_o > 0 && this.field_145989_m < 1.0f) {
            float f2 = this.field_145989_m;
            this.field_145989_m = this.field_145987_o > 0 ? (this.field_145989_m += 0.1f) : (this.field_145989_m -= 0.1f);
            if (this.field_145989_m > 1.0f) {
                this.field_145989_m = 1.0f;
            }
            float f3 = 0.5f;
            if (this.field_145989_m < 0.5f && f2 >= 0.5f) {
                this.func_195483_a(SoundEvents.field_187651_T);
            }
            if (this.field_145989_m < 0.0f) {
                this.field_145989_m = 0.0f;
            }
        }
    }

    private void func_195483_a(SoundEvent soundIn) {
        ChestType chesttype = (ChestType)this.func_195044_w().func_177229_b((IProperty)BlockChest.field_196314_b);
        if (chesttype != ChestType.LEFT) {
            double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
            double d1 = (double)this.field_174879_c.func_177956_o() + 0.5;
            double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
            if (chesttype == ChestType.RIGHT) {
                EnumFacing enumfacing = BlockChest.func_196311_i(this.func_195044_w());
                d0 += (double)enumfacing.func_82601_c() * 0.5;
                d2 += (double)enumfacing.func_82599_e() * 0.5;
            }
            this.field_145850_b.func_184148_a(null, d0, d1, d2, soundIn, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    @Override
    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.field_145987_o = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.field_145987_o < 0) {
                this.field_145987_o = 0;
            }
            ++this.field_145987_o;
            this.func_195482_p();
        }
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v()) {
            --this.field_145987_o;
            this.func_195482_p();
        }
    }

    protected void func_195482_p() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof BlockChest) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.field_145987_o);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    public String func_174875_k() {
        return "minecraft:chest";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.func_184281_d(playerIn);
        return new ContainerChest((IInventory)playerInventory, (IInventory)this, playerIn);
    }

    @Override
    protected NonNullList<ItemStack> func_190576_q() {
        return this.field_145985_p;
    }

    @Override
    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.field_145985_p = itemsIn;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float partialTicks) {
        return this.field_145986_n + (this.field_145989_m - this.field_145986_n) * partialTicks;
    }

    public static int func_195481_a(IBlockReader reader, BlockPos posIn) {
        TileEntity tileentity;
        IBlockState iblockstate = reader.func_180495_p(posIn);
        if (iblockstate.hasTileEntity() && (tileentity = reader.func_175625_s(posIn)) instanceof TileEntityChest) {
            return ((TileEntityChest)tileentity).field_145987_o;
        }
        return 0;
    }

    public static void func_199722_a(TileEntityChest chest, TileEntityChest otherChest) {
        NonNullList<ItemStack> nonnulllist = chest.func_190576_q();
        chest.func_199721_a(otherChest.func_190576_q());
        otherChest.func_199721_a(nonnulllist);
    }

    @Override
    public void func_145836_u() {
        super.func_145836_u();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
            this.chestHandler = null;
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, EnumFacing side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.chestHandler == null) {
                this.chestHandler = LazyOptional.of(this::createHandler);
            }
            return this.chestHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        IBlockState state = this.func_195044_w();
        if (!(state.func_177230_c() instanceof BlockChest)) {
            return new InvWrapper((IInventory)this);
        }
        ChestType type = (ChestType)state.func_177229_b((IProperty)BlockChest.field_196314_b);
        if (type != ChestType.SINGLE) {
            TileEntity ote;
            ChestType otype;
            BlockPos opos = this.func_174877_v().func_177972_a(BlockChest.func_196311_i(state));
            IBlockState ostate = this.func_145831_w().func_180495_p(opos);
            if (state.func_177230_c() == ostate.func_177230_c() && (otype = (ChestType)ostate.func_177229_b((IProperty)BlockChest.field_196314_b)) != ChestType.SINGLE && type != otype && state.func_177229_b((IProperty)BlockChest.field_176459_a) == ostate.func_177229_b((IProperty)BlockChest.field_176459_a) && (ote = this.func_145831_w().func_175625_s(opos)) instanceof TileEntityChest) {
                TileEntityChest top = type == ChestType.RIGHT ? this : (IInventory)ote;
                TileEntityChest bottom = type == ChestType.RIGHT ? (IInventory)ote : this;
                return new CombinedInvWrapper(new IItemHandlerModifiable[]{new InvWrapper((IInventory)top), new InvWrapper((IInventory)bottom)});
            }
        }
        return new InvWrapper((IInventory)this);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
        }
    }
}

