/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.network.play.server.SPacketMultiBlockChange;
import net.minecraft.network.play.server.SPacketUnloadChunk;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerChunkMapEntry {
    private static final Logger field_187281_a = LogManager.getLogger();
    private final PlayerChunkMap field_187282_b;
    private final List<EntityPlayerMP> field_187283_c = Lists.newArrayList();
    private final ChunkPos field_187284_d;
    private short[] field_187285_e = new short[64];
    @Nullable
    private Chunk field_187286_f;
    private int field_187287_g;
    private int field_187288_h;
    private long field_187289_i;
    private boolean field_187290_j;

    public PlayerChunkMapEntry(PlayerChunkMap mapIn, int chunkX, int chunkZ) {
        this.field_187282_b = mapIn;
        this.field_187284_d = new ChunkPos(chunkX, chunkZ);
        ChunkProviderServer chunkproviderserver = mapIn.func_72688_a().func_72863_F();
        chunkproviderserver.func_212469_a(chunkX, chunkZ);
        this.field_187286_f = chunkproviderserver.func_186025_d(chunkX, chunkZ, true, false);
    }

    public ChunkPos func_187264_a() {
        return this.field_187284_d;
    }

    public void func_187276_a(EntityPlayerMP player) {
        if (this.field_187283_c.contains((Object)player)) {
            field_187281_a.debug("Failed to add player. {} already is in chunk {}, {}", (Object)player, (Object)this.field_187284_d.field_77276_a, (Object)this.field_187284_d.field_77275_b);
        } else {
            if (this.field_187283_c.isEmpty()) {
                this.field_187289_i = this.field_187282_b.func_72688_a().func_82737_E();
            }
            this.field_187283_c.add(player);
            if (this.field_187290_j) {
                this.func_187278_c(player);
                MinecraftForge.EVENT_BUS.post((Event)new ChunkWatchEvent.Watch(this.field_187286_f, player));
            }
        }
    }

    public void func_187277_b(EntityPlayerMP player) {
        if (this.field_187283_c.contains((Object)player)) {
            if (this.field_187286_f == null) {
                this.field_187283_c.remove((Object)player);
                if (this.field_187283_c.isEmpty()) {
                    this.field_187282_b.func_187305_b(this);
                }
                return;
            }
            if (this.field_187290_j) {
                player.field_71135_a.func_147359_a((Packet<?>)new SPacketUnloadChunk(this.field_187284_d.field_77276_a, this.field_187284_d.field_77275_b));
            }
            this.field_187283_c.remove((Object)player);
            MinecraftForge.EVENT_BUS.post((Event)new ChunkWatchEvent.UnWatch(this.field_187286_f, player));
            if (this.field_187283_c.isEmpty()) {
                this.field_187282_b.func_187305_b(this);
            }
        }
    }

    public boolean func_187268_a(boolean canGenerate) {
        if (this.field_187286_f != null) {
            return true;
        }
        this.field_187286_f = this.field_187282_b.func_72688_a().func_72863_F().func_186025_d(this.field_187284_d.field_77276_a, this.field_187284_d.field_77275_b, true, canGenerate);
        return this.field_187286_f != null;
    }

    public boolean func_187272_b() {
        if (this.field_187290_j) {
            return true;
        }
        if (this.field_187286_f == null) {
            return false;
        }
        if (!this.field_187286_f.func_150802_k()) {
            return false;
        }
        this.field_187287_g = 0;
        this.field_187288_h = 0;
        this.field_187290_j = true;
        if (!this.field_187283_c.isEmpty()) {
            SPacketChunkData packet = new SPacketChunkData(this.field_187286_f, 65535);
            for (EntityPlayerMP entityplayermp : this.field_187283_c) {
                entityplayermp.field_71135_a.func_147359_a((Packet<?>)packet);
                this.field_187282_b.func_72688_a().func_73039_n().func_85172_a(entityplayermp, this.field_187286_f);
                MinecraftForge.EVENT_BUS.post((Event)new ChunkWatchEvent.Watch(this.field_187286_f, entityplayermp));
            }
        }
        return true;
    }

    public void func_187278_c(EntityPlayerMP player) {
        if (this.field_187290_j) {
            player.field_71135_a.func_147359_a((Packet<?>)new SPacketChunkData(this.field_187286_f, 65535));
            this.field_187282_b.func_72688_a().func_73039_n().func_85172_a(player, this.field_187286_f);
        }
    }

    public void func_187279_c() {
        long i = this.field_187282_b.func_72688_a().func_82737_E();
        if (this.field_187286_f != null) {
            this.field_187286_f.func_177415_c(this.field_187286_f.func_177416_w() + i - this.field_187289_i);
        }
        this.field_187289_i = i;
    }

    public void func_187265_a(int x, int y, int z) {
        if (this.field_187290_j) {
            if (this.field_187287_g == 0) {
                this.field_187282_b.func_187304_a(this);
            }
            this.field_187288_h |= 1 << (y >> 4);
            short short1 = (short)(x << 12 | z << 8 | y);
            for (int i = 0; i < this.field_187287_g; ++i) {
                if (this.field_187285_e[i] != short1) continue;
                return;
            }
            if (this.field_187287_g == this.field_187285_e.length) {
                this.field_187285_e = Arrays.copyOf(this.field_187285_e, this.field_187285_e.length << 1);
            }
            this.field_187285_e[this.field_187287_g++] = short1;
        }
    }

    public void func_187267_a(Packet<?> packetIn) {
        if (this.field_187290_j) {
            for (int i = 0; i < this.field_187283_c.size(); ++i) {
                this.field_187283_c.get((int)i).field_71135_a.func_147359_a(packetIn);
            }
        }
    }

    public void func_187280_d() {
        if (this.field_187290_j && this.field_187286_f != null && this.field_187287_g != 0) {
            if (this.field_187287_g == 1) {
                int i = (this.field_187285_e[0] >> 12 & 0xF) + this.field_187284_d.field_77276_a * 16;
                int j = this.field_187285_e[0] & 0xFF;
                int k = (this.field_187285_e[0] >> 8 & 0xF) + this.field_187284_d.field_77275_b * 16;
                BlockPos blockpos = new BlockPos(i, j, k);
                this.func_187267_a((Packet<?>)new SPacketBlockChange((IBlockReader)this.field_187282_b.func_72688_a(), blockpos));
                if (this.field_187282_b.func_72688_a().func_180495_p(blockpos).hasTileEntity()) {
                    this.func_187273_a(this.field_187282_b.func_72688_a().func_175625_s(blockpos));
                }
            } else if (this.field_187287_g >= (Integer)ForgeConfig.SERVER.clumpingThreshold.get()) {
                this.func_187267_a((Packet<?>)new SPacketChunkData(this.field_187286_f, this.field_187288_h));
            } else {
                this.func_187267_a((Packet<?>)new SPacketMultiBlockChange(this.field_187287_g, this.field_187285_e, this.field_187286_f));
                for (int l = 0; l < this.field_187287_g; ++l) {
                    int i1 = (this.field_187285_e[l] >> 12 & 0xF) + this.field_187284_d.field_77276_a * 16;
                    int j1 = this.field_187285_e[l] & 0xFF;
                    int k1 = (this.field_187285_e[l] >> 8 & 0xF) + this.field_187284_d.field_77275_b * 16;
                    BlockPos blockpos1 = new BlockPos(i1, j1, k1);
                    if (!this.field_187282_b.func_72688_a().func_180495_p(blockpos1).hasTileEntity()) continue;
                    this.func_187273_a(this.field_187282_b.func_72688_a().func_175625_s(blockpos1));
                }
            }
            this.field_187287_g = 0;
            this.field_187288_h = 0;
        }
    }

    private void func_187273_a(@Nullable TileEntity be) {
        SPacketUpdateTileEntity spacketupdatetileentity;
        if (be != null && (spacketupdatetileentity = be.func_189518_D_()) != null) {
            this.func_187267_a((Packet<?>)spacketupdatetileentity);
        }
    }

    public boolean func_187275_d(EntityPlayerMP player) {
        return this.field_187283_c.contains((Object)player);
    }

    public boolean func_187269_a(Predicate<EntityPlayerMP> predicate) {
        return this.field_187283_c.stream().anyMatch(predicate);
    }

    public boolean func_187271_a(double range, Predicate<EntityPlayerMP> predicate) {
        int j = this.field_187283_c.size();
        for (int i = 0; i < j; ++i) {
            EntityPlayerMP entityplayermp = this.field_187283_c.get(i);
            if (!predicate.test(entityplayermp) || !(this.field_187284_d.func_185327_a((Entity)entityplayermp) < range * range)) continue;
            return true;
        }
        return false;
    }

    public boolean func_187274_e() {
        return this.field_187290_j;
    }

    @Nullable
    public Chunk func_187266_f() {
        return this.field_187286_f;
    }

    public double func_187270_g() {
        double d0 = Double.MAX_VALUE;
        for (EntityPlayerMP entityplayermp : this.field_187283_c) {
            double d1 = this.field_187284_d.func_185327_a((Entity)entityplayermp);
            if (!(d1 < d0)) continue;
            d0 = d1;
        }
        return d0;
    }

    public List<EntityPlayerMP> getWatchingPlayers() {
        return this.func_187274_e() ? Collections.unmodifiableList(this.field_187283_c) : Collections.emptyList();
    }
}

