/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.integrated;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.FutureTask;
import java.util.function.BooleanSupplier;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ThreadLanServerPing;
import net.minecraft.command.Commands;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.profiler.Snooper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedPlayerList;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.CryptManager;
import net.minecraft.util.Util;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerDemo;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedDataStorage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class IntegratedServer
extends MinecraftServer {
    private static final Logger field_147148_h = LogManager.getLogger();
    private final Minecraft field_71349_l;
    private final WorldSettings field_71350_m;
    private boolean field_71348_o;
    private int field_195580_l = -1;
    private ThreadLanServerPing field_71345_q;
    private UUID field_211528_n;

    public IntegratedServer(Minecraft clientIn, String folderNameIn, String worldNameIn, WorldSettings worldSettingsIn, YggdrasilAuthenticationService authServiceIn, MinecraftSessionService sessionServiceIn, GameProfileRepository profileRepoIn, PlayerProfileCache profileCacheIn) {
        super(new File(clientIn.field_71412_D, "saves"), clientIn.func_110437_J(), clientIn.func_184126_aj(), new Commands(false), authServiceIn, sessionServiceIn, profileRepoIn, profileCacheIn);
        this.func_71224_l(clientIn.func_110432_I().func_111285_a());
        this.func_71261_m(folderNameIn);
        this.func_71246_n(worldNameIn);
        this.func_71204_b(clientIn.func_71355_q());
        this.func_71194_c(worldSettingsIn.func_77167_c());
        this.func_71191_d(256);
        this.func_184105_a((PlayerList)new IntegratedPlayerList(this));
        this.field_71349_l = clientIn;
        this.field_71350_m = this.func_71242_L() ? WorldServerDemo.field_73071_a : worldSettingsIn;
    }

    @Override
    public void func_71247_a(String saveName, String worldNameIn, long seed, WorldType type, JsonElement generatorOptions) {
        this.func_71237_c(saveName);
        ISaveHandler isavehandler = this.func_71254_M().func_197715_a(saveName, (MinecraftServer)this);
        this.func_175584_a(this.func_71270_I(), isavehandler);
        WorldInfo worldinfo = isavehandler.func_75757_d();
        if (worldinfo == null) {
            worldinfo = new WorldInfo(this.field_71350_m, worldNameIn);
        } else {
            worldinfo.func_76062_a(worldNameIn);
        }
        this.func_195560_a(isavehandler.func_75765_b(), worldinfo);
        WorldSavedDataStorage worldsaveddatastorage = new WorldSavedDataStorage(isavehandler);
        this.func_212369_a(isavehandler, worldsaveddatastorage, worldinfo, this.field_71350_m);
        if (this.func_71218_a(DimensionType.OVERWORLD).func_72912_H().func_176130_y() == null) {
            this.func_147139_a(this.field_71349_l.field_71474_y.field_74318_M);
        }
        this.func_71222_d(worldsaveddatastorage);
    }

    @Override
    public boolean func_71197_b() throws IOException {
        field_147148_h.info("Starting integrated minecraft server version 1.13.2");
        this.func_71229_d(true);
        this.func_71251_e(true);
        this.func_71257_f(true);
        this.func_71188_g(true);
        this.func_71245_h(true);
        field_147148_h.info("Generating keypair");
        this.func_71253_a(CryptManager.func_75891_b());
        if (!ServerLifecycleHooks.handleServerAboutToStart((MinecraftServer)this)) {
            return false;
        }
        this.func_71247_a(this.func_71270_I(), this.func_71221_J(), this.field_71350_m.func_77160_d(), this.field_71350_m.func_77165_h(), this.field_71350_m.func_205391_j());
        this.func_71205_p(this.func_71214_G() + " - " + this.func_71218_a(DimensionType.OVERWORLD).func_72912_H().func_76065_j());
        return ServerLifecycleHooks.handleServerStarting((MinecraftServer)this);
    }

    @Override
    public void func_71217_p(BooleanSupplier p_71217_1_) {
        block5: {
            WorldInfo worldinfo1;
            WorldInfo worldinfo;
            block6: {
                block4: {
                    FutureTask futuretask;
                    boolean flag = this.field_71348_o;
                    boolean bl = this.field_71348_o = Minecraft.func_71410_x().func_147114_u() != null && Minecraft.func_71410_x().func_147113_T();
                    if (!flag && this.field_71348_o) {
                        field_147148_h.info("Saving and pausing game...");
                        this.func_184103_al().func_72389_g();
                        this.func_71267_a(false);
                    }
                    if (!this.field_71348_o) break block4;
                    while ((futuretask = (FutureTask)this.field_175589_i.poll()) != null) {
                        Util.func_181617_a((FutureTask)futuretask, (Logger)field_147148_h);
                    }
                    break block5;
                }
                super.func_71217_p(p_71217_1_);
                if (this.field_71349_l.field_71474_y.field_151451_c != this.func_184103_al().func_72395_o()) {
                    field_147148_h.info("Changing view distance to {}, from {}", (Object)this.field_71349_l.field_71474_y.field_151451_c, (Object)this.func_184103_al().func_72395_o());
                    this.func_184103_al().func_152611_a(this.field_71349_l.field_71474_y.field_151451_c);
                }
                if (this.field_71349_l.field_71441_e == null) break block5;
                worldinfo = this.func_71218_a(DimensionType.OVERWORLD).func_72912_H();
                worldinfo1 = this.field_71349_l.field_71441_e.func_72912_H();
                if (worldinfo.func_176123_z() || worldinfo1.func_176130_y() == worldinfo.func_176130_y()) break block6;
                field_147148_h.info("Changing difficulty to {}, from {}", (Object)worldinfo1.func_176130_y(), (Object)worldinfo.func_176130_y());
                this.func_147139_a(worldinfo1.func_176130_y());
                break block5;
            }
            if (!worldinfo1.func_176123_z() || worldinfo.func_176123_z()) break block5;
            field_147148_h.info("Locking difficulty to {}", (Object)worldinfo1.func_176130_y());
            for (WorldServer worldserver : this.func_212370_w()) {
                if (worldserver == null) continue;
                worldserver.func_72912_H().func_180783_e(true);
            }
        }
    }

    @Override
    public boolean func_71225_e() {
        return false;
    }

    @Override
    public GameType func_71265_f() {
        return this.field_71350_m.func_77162_e();
    }

    @Override
    public EnumDifficulty func_147135_j() {
        if (this.field_71349_l.field_71441_e == null) {
            return this.field_71349_l.field_71474_y.field_74318_M;
        }
        return this.field_71349_l.field_71441_e.func_72912_H().func_176130_y();
    }

    @Override
    public boolean func_71199_h() {
        return this.field_71350_m.func_77158_f();
    }

    @Override
    public boolean func_195569_l() {
        return true;
    }

    public boolean func_195041_r_() {
        return true;
    }

    @Override
    public File func_71238_n() {
        return this.field_71349_l.field_71412_D;
    }

    @Override
    public boolean func_71262_S() {
        return false;
    }

    @Override
    public boolean func_181035_ah() {
        return false;
    }

    @Override
    public void func_71228_a(CrashReport report) {
        this.field_71349_l.func_71404_a(report);
    }

    @Override
    public CrashReport func_71230_b(CrashReport report) {
        report = super.func_71230_b(report);
        report.func_85056_g().func_71507_a("Type", "Integrated Server (map_client.txt)");
        report.func_85056_g().func_189529_a("Is Modded", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
            String s = ClientBrandRetriever.getClientModName();
            if (!s.equals("vanilla")) {
                return "Definitely; Client brand changed to '" + s + "'";
            }
            s = this.getServerModName();
            if (!"vanilla".equals(s)) {
                return "Definitely; Server brand changed to '" + s + "'";
            }
            return Minecraft.class.getSigners() == null ? "Very likely; Jar signature invalidated" : "Probably not. Jar signature remains and both client + server brands are untouched.";
        }));
        return report;
    }

    @Override
    public void func_147139_a(EnumDifficulty difficulty) {
        super.func_147139_a(difficulty);
        if (this.field_71349_l.field_71441_e != null) {
            this.field_71349_l.field_71441_e.func_72912_H().func_176144_a(difficulty);
        }
    }

    @Override
    public void func_70000_a(Snooper playerSnooper) {
        super.func_70000_a(playerSnooper);
        playerSnooper.func_152768_a("snooper_partner", (Object)this.field_71349_l.func_71378_E().func_80006_f());
    }

    @Override
    public boolean func_70002_Q() {
        return Minecraft.func_71410_x().func_70002_Q();
    }

    @Override
    public boolean func_195565_a(GameType gameMode, boolean cheats, int port) {
        try {
            this.func_147137_ag().func_151265_a(null, port);
            field_147148_h.info("Started serving on {}", (Object)port);
            this.field_195580_l = port;
            this.field_71345_q = new ThreadLanServerPing(this.func_71273_Y(), port + "");
            this.field_71345_q.start();
            this.func_184103_al().func_152604_a(gameMode);
            this.func_184103_al().func_72387_b(cheats);
            int i = this.func_211833_a(this.field_71349_l.field_71439_g.func_146103_bH());
            this.field_71349_l.field_71439_g.func_184839_n(i);
            for (EntityPlayerMP entityplayermp : this.func_184103_al().func_181057_v()) {
                this.func_195571_aL().func_197051_a(entityplayermp);
            }
            return true;
        }
        catch (IOException var7) {
            return false;
        }
    }

    @Override
    public void func_71260_j() {
        super.func_71260_j();
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    @Override
    public void func_71263_m() {
        if (this.func_71278_l()) {
            Futures.getUnchecked(this.func_152344_a(() -> {
                for (EntityPlayerMP entityplayermp : Lists.newArrayList(this.func_184103_al().func_181057_v())) {
                    if (entityplayermp.func_110124_au().equals(this.field_211528_n)) continue;
                    this.func_184103_al().func_72367_e(entityplayermp);
                }
            }));
        }
        super.func_71263_m();
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    @Override
    public boolean func_71344_c() {
        return this.field_195580_l > -1;
    }

    @Override
    public int func_71215_F() {
        return this.field_195580_l;
    }

    @Override
    public void func_71235_a(GameType gameMode) {
        super.func_71235_a(gameMode);
        this.func_184103_al().func_152604_a(gameMode);
    }

    @Override
    public boolean func_82356_Z() {
        return true;
    }

    @Override
    public int func_110455_j() {
        return 2;
    }

    public void func_211527_b(UUID uuid) {
        this.field_211528_n = uuid;
    }
}

