/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PotionEffect
implements Comparable<PotionEffect> {
    private static final Logger field_180155_a = LogManager.getLogger();
    private final Potion field_188420_b;
    private int field_76460_b;
    private int field_76461_c;
    private boolean field_82723_d;
    private boolean field_82724_e;
    @OnlyIn(value=Dist.CLIENT)
    private boolean field_100013_f;
    private boolean field_188421_h;
    private boolean field_205349_i;
    private List<ItemStack> curativeItems;

    public PotionEffect(Potion potionIn) {
        this(potionIn, 0, 0);
    }

    public PotionEffect(Potion potionIn, int durationIn) {
        this(potionIn, durationIn, 0);
    }

    public PotionEffect(Potion potionIn, int durationIn, int amplifierIn) {
        this(potionIn, durationIn, amplifierIn, false, true);
    }

    public PotionEffect(Potion potionIn, int durationIn, int amplifierIn, boolean ambientIn, boolean showParticlesIn) {
        this(potionIn, durationIn, amplifierIn, ambientIn, showParticlesIn, showParticlesIn);
    }

    public PotionEffect(Potion p_i48980_1_, int p_i48980_2_, int p_i48980_3_, boolean p_i48980_4_, boolean p_i48980_5_, boolean p_i48980_6_) {
        this.field_188420_b = p_i48980_1_;
        this.field_76460_b = p_i48980_2_;
        this.field_76461_c = p_i48980_3_;
        this.field_82724_e = p_i48980_4_;
        this.field_188421_h = p_i48980_5_;
        this.field_205349_i = p_i48980_6_;
    }

    public PotionEffect(PotionEffect other) {
        this.field_188420_b = other.field_188420_b;
        this.field_76460_b = other.field_76460_b;
        this.field_76461_c = other.field_76461_c;
        this.field_82724_e = other.field_82724_e;
        this.field_188421_h = other.field_188421_h;
        this.field_205349_i = other.field_205349_i;
        this.curativeItems = other.curativeItems == null ? null : new ArrayList<ItemStack>(other.curativeItems);
    }

    public boolean func_199308_a(PotionEffect p_199308_1_) {
        if (this.field_188420_b != p_199308_1_.field_188420_b) {
            field_180155_a.warn("This method should only be called for matching effects!");
        }
        boolean flag = false;
        if (p_199308_1_.field_76461_c > this.field_76461_c) {
            this.field_76461_c = p_199308_1_.field_76461_c;
            this.field_76460_b = p_199308_1_.field_76460_b;
            flag = true;
        } else if (p_199308_1_.field_76461_c == this.field_76461_c && this.field_76460_b < p_199308_1_.field_76460_b) {
            this.field_76460_b = p_199308_1_.field_76460_b;
            flag = true;
        }
        if (!p_199308_1_.field_82724_e && this.field_82724_e || flag) {
            this.field_82724_e = p_199308_1_.field_82724_e;
            flag = true;
        }
        if (p_199308_1_.field_188421_h != this.field_188421_h) {
            this.field_188421_h = p_199308_1_.field_188421_h;
            flag = true;
        }
        if (p_199308_1_.field_205349_i != this.field_205349_i) {
            this.field_205349_i = p_199308_1_.field_205349_i;
            flag = true;
        }
        return flag;
    }

    public Potion func_188419_a() {
        return this.getPotionRaw() == null ? null : (Potion)((Object)this.getPotionRaw().delegate.get());
    }

    private Potion getPotionRaw() {
        return this.field_188420_b;
    }

    public int func_76459_b() {
        return this.field_76460_b;
    }

    public int func_76458_c() {
        return this.field_76461_c;
    }

    public boolean func_82720_e() {
        return this.field_82724_e;
    }

    public boolean func_188418_e() {
        return this.field_188421_h;
    }

    public boolean func_205348_f() {
        return this.field_205349_i;
    }

    public boolean func_76455_a(EntityLivingBase entityIn) {
        if (this.field_76460_b > 0) {
            if (this.field_188420_b.func_76397_a(this.field_76460_b, this.field_76461_c)) {
                this.func_76457_b(entityIn);
            }
            this.func_76454_e();
        }
        return this.field_76460_b > 0;
    }

    private int func_76454_e() {
        return --this.field_76460_b;
    }

    public void func_76457_b(EntityLivingBase entityIn) {
        if (this.field_76460_b > 0) {
            this.field_188420_b.func_76394_a(entityIn, this.field_76461_c);
        }
    }

    public String func_76453_d() {
        return this.field_188420_b.func_76393_a();
    }

    public String toString() {
        String s = this.field_76461_c > 0 ? this.func_76453_d() + " x " + (this.field_76461_c + 1) + ", Duration: " + this.field_76460_b : this.func_76453_d() + ", Duration: " + this.field_76460_b;
        if (this.field_82723_d) {
            s = s + ", Splash: true";
        }
        if (!this.field_188421_h) {
            s = s + ", Particles: false";
        }
        if (!this.field_205349_i) {
            s = s + ", Show Icon: false";
        }
        return s;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof PotionEffect)) {
            return false;
        }
        PotionEffect potioneffect = (PotionEffect)p_equals_1_;
        return this.field_76460_b == potioneffect.field_76460_b && this.field_76461_c == potioneffect.field_76461_c && this.field_82723_d == potioneffect.field_82723_d && this.field_82724_e == potioneffect.field_82724_e && ((Object)((Object)this.field_188420_b)).equals((Object)potioneffect.field_188420_b);
    }

    public int hashCode() {
        int i = ((Object)((Object)this.field_188420_b)).hashCode();
        i = 31 * i + this.field_76460_b;
        i = 31 * i + this.field_76461_c;
        i = 31 * i + (this.field_82723_d ? 1 : 0);
        i = 31 * i + (this.field_82724_e ? 1 : 0);
        return i;
    }

    public NBTTagCompound func_82719_a(NBTTagCompound nbt) {
        nbt.func_74774_a("Id", (byte)Potion.func_188409_a(this.func_188419_a()));
        nbt.func_74774_a("Amplifier", (byte)this.func_76458_c());
        nbt.func_74768_a("Duration", this.func_76459_b());
        nbt.func_74757_a("Ambient", this.func_82720_e());
        nbt.func_74757_a("ShowParticles", this.func_188418_e());
        nbt.func_74757_a("ShowIcon", this.func_205348_f());
        this.writeCurativeItems(nbt);
        return nbt;
    }

    public static PotionEffect func_82722_b(NBTTagCompound nbt) {
        int i = nbt.func_74771_c("Id") & 0xFF;
        Potion potion = Potion.func_188412_a(i);
        if (potion == null) {
            return null;
        }
        byte j = nbt.func_74771_c("Amplifier");
        int k = nbt.func_74762_e("Duration");
        boolean flag = nbt.func_74767_n("Ambient");
        boolean flag1 = true;
        if (nbt.func_150297_b("ShowParticles", 1)) {
            flag1 = nbt.func_74767_n("ShowParticles");
        }
        boolean flag2 = flag1;
        if (nbt.func_150297_b("ShowIcon", 1)) {
            flag2 = nbt.func_74767_n("ShowIcon");
        }
        return PotionEffect.readCurativeItems(new PotionEffect(potion, k, j < 0 ? (byte)0 : j, flag, flag1, flag2), nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_100012_b(boolean maxDuration) {
        this.field_100013_f = maxDuration;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_100011_g() {
        return this.field_100013_f;
    }

    @Override
    public int compareTo(PotionEffect p_compareTo_1_) {
        int i = 32147;
        return !(this.func_76459_b() > 32147 && p_compareTo_1_.func_76459_b() > 32147 || this.func_82720_e() && p_compareTo_1_.func_82720_e()) ? ComparisonChain.start().compare(Boolean.valueOf(this.func_82720_e()), Boolean.valueOf(p_compareTo_1_.func_82720_e())).compare(this.func_76459_b(), p_compareTo_1_.func_76459_b()).compare(this.func_188419_a().getGuiSortColor(this), p_compareTo_1_.func_188419_a().getGuiSortColor(this)).result() : ComparisonChain.start().compare(Boolean.valueOf(this.func_82720_e()), Boolean.valueOf(p_compareTo_1_.func_82720_e())).compare(this.func_188419_a().getGuiSortColor(this), p_compareTo_1_.func_188419_a().getGuiSortColor(this)).result();
    }

    public List<ItemStack> getCurativeItems() {
        if (this.curativeItems == null) {
            this.curativeItems = this.func_188419_a().getCurativeItems();
        }
        return this.curativeItems;
    }

    public boolean isCurativeItem(ItemStack stack) {
        return this.getCurativeItems().stream().anyMatch(e -> e.func_77969_a(stack));
    }

    public void setCurativeItems(List<ItemStack> curativeItems) {
        this.curativeItems = curativeItems;
    }

    public void addCurativeItem(ItemStack stack) {
        if (!this.isCurativeItem(stack)) {
            this.getCurativeItems().add(stack);
        }
    }

    private void writeCurativeItems(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.getCurativeItems()) {
            list.add((INBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        nbt.func_74782_a("CurativeItems", (INBTBase)list);
    }

    private static PotionEffect readCurativeItems(PotionEffect effect, NBTTagCompound nbt) {
        if (nbt.func_150297_b("CurativeItems", 9)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            NBTTagList list = nbt.func_150295_c("CurativeItems", 10);
            for (int i = 0; i < list.size(); ++i) {
                items.add(ItemStack.func_199557_a(list.func_150305_b(i)));
            }
            effect.setCurativeItems(items);
        }
        return effect;
    }
}

