/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.util.concurrent.Futures;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ServerRecipePlacer;
import net.minecraft.item.crafting.ServerRecipePlacerFurnace;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketThreadUtil;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.network.play.client.CPacketChatMessage;
import net.minecraft.network.play.client.CPacketClickWindow;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.network.play.client.CPacketCloseWindow;
import net.minecraft.network.play.client.CPacketConfirmTeleport;
import net.minecraft.network.play.client.CPacketConfirmTransaction;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.client.CPacketEditBook;
import net.minecraft.network.play.client.CPacketEnchantItem;
import net.minecraft.network.play.client.CPacketEntityAction;
import net.minecraft.network.play.client.CPacketHeldItemChange;
import net.minecraft.network.play.client.CPacketInput;
import net.minecraft.network.play.client.CPacketKeepAlive;
import net.minecraft.network.play.client.CPacketNBTQueryEntity;
import net.minecraft.network.play.client.CPacketNBTQueryTileEntity;
import net.minecraft.network.play.client.CPacketPickItem;
import net.minecraft.network.play.client.CPacketPlaceRecipe;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketPlayerAbilities;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.network.play.client.CPacketRecipeInfo;
import net.minecraft.network.play.client.CPacketRenameItem;
import net.minecraft.network.play.client.CPacketResourcePackStatus;
import net.minecraft.network.play.client.CPacketSeenAdvancements;
import net.minecraft.network.play.client.CPacketSelectTrade;
import net.minecraft.network.play.client.CPacketSpectate;
import net.minecraft.network.play.client.CPacketSteerBoat;
import net.minecraft.network.play.client.CPacketTabComplete;
import net.minecraft.network.play.client.CPacketUpdateBeacon;
import net.minecraft.network.play.client.CPacketUpdateCommandBlock;
import net.minecraft.network.play.client.CPacketUpdateCommandMinecart;
import net.minecraft.network.play.client.CPacketUpdateSign;
import net.minecraft.network.play.client.CPacketUpdateStructureBlock;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.network.play.client.CPacketVehicleMove;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketConfirmTransaction;
import net.minecraft.network.play.server.SPacketDisconnect;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.network.play.server.SPacketKeepAlive;
import net.minecraft.network.play.server.SPacketMoveVehicle;
import net.minecraft.network.play.server.SPacketNBTQueryResponse;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.network.play.server.SPacketTabComplete;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ITickable;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetHandlerPlayServer
implements INetHandlerPlayServer,
ITickable {
    private static final Logger field_147370_c = LogManager.getLogger();
    public final NetworkManager field_147371_a;
    private final MinecraftServer field_147367_d;
    public EntityPlayerMP field_147369_b;
    private int field_147368_e;
    private long field_194402_f;
    private boolean field_194403_g;
    private long field_194404_h;
    private int field_147374_l;
    private int field_147375_m;
    private final IntHashMap<Short> field_147372_n = new IntHashMap();
    private double field_184349_l;
    private double field_184350_m;
    private double field_184351_n;
    private double field_184352_o;
    private double field_184353_p;
    private double field_184354_q;
    private Entity field_184355_r;
    private double field_184356_s;
    private double field_184357_t;
    private double field_184358_u;
    private double field_184359_v;
    private double field_184360_w;
    private double field_184361_x;
    private Vec3d field_184362_y;
    private int field_184363_z;
    private int field_184343_A;
    private boolean field_184344_B;
    private int field_147365_f;
    private boolean field_184345_D;
    private int field_184346_E;
    private int field_184347_F;
    private int field_184348_G;

    public NetHandlerPlayServer(MinecraftServer server, NetworkManager networkManagerIn, EntityPlayerMP playerIn) {
        this.field_147367_d = server;
        this.field_147371_a = networkManagerIn;
        networkManagerIn.func_150719_a((INetHandler)this);
        this.field_147369_b = playerIn;
        playerIn.field_71135_a = this;
    }

    public void func_73660_a() {
        this.func_184342_d();
        this.field_147369_b.func_71127_g();
        this.field_147369_b.func_70080_a(this.field_184349_l, this.field_184350_m, this.field_184351_n, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
        ++this.field_147368_e;
        this.field_184348_G = this.field_184347_F;
        if (this.field_184344_B) {
            if (++this.field_147365_f > 80) {
                field_147370_c.warn("{} was kicked for floating too long!", (Object)this.field_147369_b.func_200200_C_().getString());
                this.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.flying", new Object[0]));
                return;
            }
        } else {
            this.field_184344_B = false;
            this.field_147365_f = 0;
        }
        this.field_184355_r = this.field_147369_b.func_184208_bv();
        if (this.field_184355_r != this.field_147369_b && this.field_184355_r.func_184179_bs() == this.field_147369_b) {
            this.field_184356_s = this.field_184355_r.field_70165_t;
            this.field_184357_t = this.field_184355_r.field_70163_u;
            this.field_184358_u = this.field_184355_r.field_70161_v;
            this.field_184359_v = this.field_184355_r.field_70165_t;
            this.field_184360_w = this.field_184355_r.field_70163_u;
            this.field_184361_x = this.field_184355_r.field_70161_v;
            if (this.field_184345_D && this.field_147369_b.func_184208_bv().func_184179_bs() == this.field_147369_b) {
                if (++this.field_184346_E > 80) {
                    field_147370_c.warn("{} was kicked for floating a vehicle too long!", (Object)this.field_147369_b.func_200200_C_().getString());
                    this.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.flying", new Object[0]));
                    return;
                }
            } else {
                this.field_184345_D = false;
                this.field_184346_E = 0;
            }
        } else {
            this.field_184355_r = null;
            this.field_184345_D = false;
            this.field_184346_E = 0;
        }
        this.field_147367_d.field_71304_b.func_76320_a("keepAlive");
        long i = Util.func_211177_b();
        if (i - this.field_194402_f >= 15000L) {
            if (this.field_194403_g) {
                this.func_194028_b((ITextComponent)new TextComponentTranslation("disconnect.timeout", new Object[0]));
            } else {
                this.field_194403_g = true;
                this.field_194402_f = i;
                this.field_194404_h = i;
                this.func_147359_a((Packet<?>)new SPacketKeepAlive(this.field_194404_h));
            }
        }
        this.field_147367_d.field_71304_b.func_76319_b();
        if (this.field_147374_l > 0) {
            --this.field_147374_l;
        }
        if (this.field_147375_m > 0) {
            --this.field_147375_m;
        }
        if (this.field_147369_b.func_154331_x() > 0L && this.field_147367_d.func_143007_ar() > 0 && Util.func_211177_b() - this.field_147369_b.func_154331_x() > (long)(this.field_147367_d.func_143007_ar() * 1000 * 60)) {
            this.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.idling", new Object[0]));
        }
    }

    public void func_184342_d() {
        this.field_184349_l = this.field_147369_b.field_70165_t;
        this.field_184350_m = this.field_147369_b.field_70163_u;
        this.field_184351_n = this.field_147369_b.field_70161_v;
        this.field_184352_o = this.field_147369_b.field_70165_t;
        this.field_184353_p = this.field_147369_b.field_70163_u;
        this.field_184354_q = this.field_147369_b.field_70161_v;
    }

    public NetworkManager func_147362_b() {
        return this.field_147371_a;
    }

    public void func_194028_b(ITextComponent textComponent) {
        this.field_147371_a.func_201058_a((Packet<?>)new SPacketDisconnect(textComponent), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_210161_2_ -> this.field_147371_a.func_150718_a(textComponent)));
        this.field_147371_a.func_150721_g();
        Futures.getUnchecked(this.field_147367_d.func_152344_a(this.field_147371_a::func_179293_l));
    }

    public void func_147358_a(CPacketInput packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_110430_a(packetIn.func_149620_c(), packetIn.func_192620_b(), packetIn.func_149618_e(), packetIn.func_149617_f());
    }

    private static boolean func_183006_b(CPacketPlayer packetIn) {
        if (Doubles.isFinite((double)packetIn.func_186997_a(0.0)) && Doubles.isFinite((double)packetIn.func_186996_b(0.0)) && Doubles.isFinite((double)packetIn.func_187000_c(0.0)) && Floats.isFinite((float)packetIn.func_186998_b(0.0f)) && Floats.isFinite((float)packetIn.func_186999_a(0.0f))) {
            return Math.abs(packetIn.func_186997_a(0.0)) > 3.0E7 || Math.abs(packetIn.func_186996_b(0.0)) > 3.0E7 || Math.abs(packetIn.func_187000_c(0.0)) > 3.0E7;
        }
        return true;
    }

    private static boolean func_184341_b(CPacketVehicleMove packetIn) {
        return !Doubles.isFinite((double)packetIn.func_187004_a()) || !Doubles.isFinite((double)packetIn.func_187002_b()) || !Doubles.isFinite((double)packetIn.func_187003_c()) || !Floats.isFinite((float)packetIn.func_187005_e()) || !Floats.isFinite((float)packetIn.func_187006_d());
    }

    public void func_184338_a(CPacketVehicleMove packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (NetHandlerPlayServer.func_184341_b(packetIn)) {
            this.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.invalid_vehicle_movement", new Object[0]));
        } else {
            Entity entity = this.field_147369_b.func_184208_bv();
            if (entity != this.field_147369_b && entity.func_184179_bs() == this.field_147369_b && entity == this.field_184355_r) {
                WorldServer worldserver = this.field_147369_b.func_71121_q();
                double d0 = entity.field_70165_t;
                double d1 = entity.field_70163_u;
                double d2 = entity.field_70161_v;
                double d3 = packetIn.func_187004_a();
                double d4 = packetIn.func_187002_b();
                double d5 = packetIn.func_187003_c();
                float f = packetIn.func_187006_d();
                float f1 = packetIn.func_187005_e();
                double d6 = d3 - this.field_184356_s;
                double d7 = d4 - this.field_184357_t;
                double d8 = d5 - this.field_184358_u;
                double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                double d9 = entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y;
                if (!(!(d10 - d9 > 100.0) || this.field_147367_d.func_71264_H() && this.field_147367_d.func_71214_G().equals(entity.func_200200_C_().getString()))) {
                    field_147370_c.warn("{} (vehicle of {}) moved too quickly! {},{},{}", (Object)entity.func_200200_C_().getString(), (Object)this.field_147369_b.func_200200_C_().getString(), (Object)d6, (Object)d7, (Object)d8);
                    this.field_147371_a.func_179290_a((Packet<?>)new SPacketMoveVehicle(entity));
                    return;
                }
                boolean flag = worldserver.func_195586_b(entity, entity.func_174813_aQ().func_186664_h(0.0625));
                d6 = d3 - this.field_184359_v;
                d7 = d4 - this.field_184360_w - 1.0E-6;
                d8 = d5 - this.field_184361_x;
                entity.func_70091_d(MoverType.PLAYER, d6, d7, d8);
                double d11 = d7;
                d6 = d3 - entity.field_70165_t;
                d7 = d4 - entity.field_70163_u;
                if (d7 > -0.5 || d7 < 0.5) {
                    d7 = 0.0;
                }
                d8 = d5 - entity.field_70161_v;
                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                boolean flag1 = false;
                if (d10 > 0.0625) {
                    flag1 = true;
                    field_147370_c.warn("{} moved wrongly!", (Object)entity.func_200200_C_().getString());
                }
                entity.func_70080_a(d3, d4, d5, f, f1);
                this.field_147369_b.func_70080_a(d3, d4, d5, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                boolean flag2 = worldserver.func_195586_b(entity, entity.func_174813_aQ().func_186664_h(0.0625));
                if (flag && (flag1 || !flag2)) {
                    entity.func_70080_a(d0, d1, d2, f, f1);
                    this.field_147369_b.func_70080_a(d0, d1, d2, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                    this.field_147371_a.func_179290_a((Packet<?>)new SPacketMoveVehicle(entity));
                    return;
                }
                this.field_147367_d.func_184103_al().func_72358_d(this.field_147369_b);
                this.field_147369_b.func_71000_j(this.field_147369_b.field_70165_t - d0, this.field_147369_b.field_70163_u - d1, this.field_147369_b.field_70161_v - d2);
                this.field_184345_D = d11 >= -0.03125 && !this.field_147367_d.func_71231_X() && !worldserver.func_72829_c(entity.func_174813_aQ().func_186662_g(0.0625).func_72321_a(0.0, -0.55, 0.0));
                this.field_184359_v = entity.field_70165_t;
                this.field_184360_w = entity.field_70163_u;
                this.field_184361_x = entity.field_70161_v;
            }
        }
    }

    public void func_184339_a(CPacketConfirmTeleport packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (packetIn.func_186987_a() == this.field_184363_z) {
            this.field_147369_b.func_70080_a(this.field_184362_y.field_72450_a, this.field_184362_y.field_72448_b, this.field_184362_y.field_72449_c, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
            this.field_184352_o = this.field_184362_y.field_72450_a;
            this.field_184353_p = this.field_184362_y.field_72448_b;
            this.field_184354_q = this.field_184362_y.field_72449_c;
            if (this.field_147369_b.func_184850_K()) {
                this.field_147369_b.func_184846_L();
            }
            this.field_184362_y = null;
        }
    }

    public void func_191984_a(CPacketRecipeInfo packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (packetIn.func_194156_a() == CPacketRecipeInfo.Purpose.SHOWN) {
            IRecipe irecipe = this.field_147367_d.func_199529_aN().func_199517_a(packetIn.func_199619_b());
            if (irecipe != null) {
                this.field_147369_b.func_192037_E().func_194074_f(irecipe);
            }
        } else if (packetIn.func_194156_a() == CPacketRecipeInfo.Purpose.SETTINGS) {
            this.field_147369_b.func_192037_E().func_192813_a(packetIn.func_192624_c());
            this.field_147369_b.func_192037_E().func_192810_b(packetIn.func_192625_d());
            this.field_147369_b.func_192037_E().func_202881_c(packetIn.func_202496_e());
            this.field_147369_b.func_192037_E().func_202882_d(packetIn.func_202497_f());
        }
    }

    public void func_194027_a(CPacketSeenAdvancements packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (packetIn.func_194162_b() == CPacketSeenAdvancements.Action.OPENED_TAB) {
            ResourceLocation resourcelocation = packetIn.func_194165_c();
            Advancement advancement = this.field_147367_d.func_191949_aK().func_192778_a(resourcelocation);
            if (advancement != null) {
                this.field_147369_b.func_192039_O().func_194220_a(advancement);
            }
        }
    }

    public void func_195518_a(CPacketTabComplete packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        StringReader stringreader = new StringReader(packetIn.func_197707_b());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        ParseResults parseresults = this.field_147367_d.func_195571_aL().func_197054_a().parse(stringreader, (Object)this.field_147369_b.func_195051_bN());
        this.field_147367_d.func_195571_aL().func_197054_a().getCompletionSuggestions(parseresults).thenAccept(p_195519_2_ -> this.field_147371_a.func_179290_a((Packet<?>)new SPacketTabComplete(packetIn.func_197709_a(), p_195519_2_)));
    }

    public void func_210153_a(CPacketUpdateCommandBlock packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (!this.field_147367_d.func_82356_Z()) {
            this.field_147369_b.func_145747_a((ITextComponent)new TextComponentTranslation("advMode.notEnabled", new Object[0]));
        } else if (!this.field_147369_b.func_195070_dx()) {
            this.field_147369_b.func_145747_a((ITextComponent)new TextComponentTranslation("advMode.notAllowed", new Object[0]));
        } else {
            CommandBlockBaseLogic commandblockbaselogic = null;
            TileEntityCommandBlock tileentitycommandblock = null;
            BlockPos blockpos = packetIn.func_210361_a();
            TileEntity tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos);
            if (tileentity instanceof TileEntityCommandBlock) {
                tileentitycommandblock = (TileEntityCommandBlock)tileentity;
                commandblockbaselogic = tileentitycommandblock.func_145993_a();
            }
            String s = packetIn.func_210359_b();
            boolean flag = packetIn.func_210363_c();
            if (commandblockbaselogic != null) {
                EnumFacing enumfacing = (EnumFacing)((Object)this.field_147369_b.field_70170_p.func_180495_p(blockpos).func_177229_b((IProperty)BlockCommandBlock.field_185564_a));
                switch (packetIn.func_210360_f()) {
                    case SEQUENCE: {
                        IBlockState iblockstate1 = Blocks.field_185777_dd.func_176223_P();
                        this.field_147369_b.field_70170_p.func_180501_a(blockpos, (IBlockState)((IBlockState)iblockstate1.func_206870_a((IProperty)BlockCommandBlock.field_185564_a, (Comparable)((Object)enumfacing))).func_206870_a((IProperty)BlockCommandBlock.field_185565_b, Boolean.valueOf(packetIn.func_210364_d())), 2);
                        break;
                    }
                    case AUTO: {
                        IBlockState iblockstate = Blocks.field_185776_dc.func_176223_P();
                        this.field_147369_b.field_70170_p.func_180501_a(blockpos, (IBlockState)((IBlockState)iblockstate.func_206870_a((IProperty)BlockCommandBlock.field_185564_a, (Comparable)((Object)enumfacing))).func_206870_a((IProperty)BlockCommandBlock.field_185565_b, Boolean.valueOf(packetIn.func_210364_d())), 2);
                        break;
                    }
                    default: {
                        IBlockState iblockstate2 = Blocks.field_150483_bI.func_176223_P();
                        this.field_147369_b.field_70170_p.func_180501_a(blockpos, (IBlockState)((IBlockState)iblockstate2.func_206870_a((IProperty)BlockCommandBlock.field_185564_a, (Comparable)((Object)enumfacing))).func_206870_a((IProperty)BlockCommandBlock.field_185565_b, Boolean.valueOf(packetIn.func_210364_d())), 2);
                    }
                }
                tileentity.func_145829_t();
                this.field_147369_b.field_70170_p.func_175690_a(blockpos, tileentity);
                commandblockbaselogic.func_145752_a(s);
                commandblockbaselogic.func_175573_a(flag);
                if (!flag) {
                    commandblockbaselogic.func_145750_b((ITextComponent)null);
                }
                tileentitycommandblock.func_184253_b(packetIn.func_210362_e());
                commandblockbaselogic.func_145756_e();
                if (!StringUtils.func_151246_b((String)s)) {
                    this.field_147369_b.func_145747_a((ITextComponent)new TextComponentTranslation("advMode.setCommand.success", s));
                }
            }
        }
    }

    public void func_210158_a(CPacketUpdateCommandMinecart packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (!this.field_147367_d.func_82356_Z()) {
            this.field_147369_b.func_145747_a((ITextComponent)new TextComponentTranslation("advMode.notEnabled", new Object[0]));
        } else if (!this.field_147369_b.func_195070_dx()) {
            this.field_147369_b.func_145747_a((ITextComponent)new TextComponentTranslation("advMode.notAllowed", new Object[0]));
        } else {
            CommandBlockBaseLogic commandblockbaselogic = packetIn.func_210371_a(this.field_147369_b.field_70170_p);
            if (commandblockbaselogic != null) {
                commandblockbaselogic.func_145752_a(packetIn.func_210372_a());
                commandblockbaselogic.func_175573_a(packetIn.func_210373_b());
                if (!packetIn.func_210373_b()) {
                    commandblockbaselogic.func_145750_b((ITextComponent)null);
                }
                commandblockbaselogic.func_145756_e();
                this.field_147369_b.func_145747_a((ITextComponent)new TextComponentTranslation("advMode.setCommand.success", packetIn.func_210372_a()));
            }
        }
    }

    public void func_210152_a(CPacketPickItem packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        this.field_147369_b.field_71071_by.func_184430_d(packetIn.func_210349_a());
        this.field_147369_b.field_71135_a.func_147359_a((Packet<?>)new SPacketSetSlot(-2, this.field_147369_b.field_71071_by.field_70461_c, this.field_147369_b.field_71071_by.func_70301_a(this.field_147369_b.field_71071_by.field_70461_c)));
        this.field_147369_b.field_71135_a.func_147359_a((Packet<?>)new SPacketSetSlot(-2, packetIn.func_210349_a(), this.field_147369_b.field_71071_by.func_70301_a(packetIn.func_210349_a())));
        this.field_147369_b.field_71135_a.func_147359_a((Packet<?>)new SPacketHeldItemChange(this.field_147369_b.field_71071_by.field_70461_c));
    }

    public void func_210155_a(CPacketRenameItem packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71070_bA instanceof ContainerRepair) {
            ContainerRepair containerrepair = (ContainerRepair)this.field_147369_b.field_71070_bA;
            String s = SharedConstants.func_71565_a(packetIn.func_210351_a());
            if (s.length() <= 35) {
                containerrepair.func_82850_a(s);
            }
        }
    }

    public void func_210154_a(CPacketUpdateBeacon packetIn) {
        ContainerBeacon containerbeacon;
        Slot slot;
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71070_bA instanceof ContainerBeacon && (slot = (containerbeacon = (ContainerBeacon)this.field_147369_b.field_71070_bA).func_75139_a(0)).func_75216_d()) {
            slot.func_75209_a(1);
            IInventory iinventory = containerbeacon.func_180611_e();
            iinventory.func_174885_b(1, packetIn.func_210355_a());
            iinventory.func_174885_b(2, packetIn.func_210356_b());
            iinventory.func_70296_d();
        }
    }

    public void func_210157_a(CPacketUpdateStructureBlock packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_195070_dx()) {
            BlockPos blockpos = packetIn.func_210380_a();
            IBlockState iblockstate = this.field_147369_b.field_70170_p.func_180495_p(blockpos);
            TileEntity tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos);
            if (tileentity instanceof TileEntityStructure) {
                TileEntityStructure tileentitystructure = (TileEntityStructure)tileentity;
                tileentitystructure.func_184405_a(packetIn.func_210378_c());
                tileentitystructure.func_184404_a(packetIn.func_210377_d());
                tileentitystructure.func_184414_b(packetIn.func_210383_e());
                tileentitystructure.func_184409_c(packetIn.func_210385_f());
                tileentitystructure.func_184411_a(packetIn.func_210386_g());
                tileentitystructure.func_184408_a(packetIn.func_210379_h());
                tileentitystructure.func_184410_b(packetIn.func_210388_i());
                tileentitystructure.func_184406_a(packetIn.func_210389_j());
                tileentitystructure.func_189703_e(packetIn.func_210390_k());
                tileentitystructure.func_189710_f(packetIn.func_210387_l());
                tileentitystructure.func_189718_a(packetIn.func_210382_m());
                tileentitystructure.func_189725_a(packetIn.func_210381_n());
                if (tileentitystructure.func_208404_d()) {
                    String s = tileentitystructure.func_189715_d();
                    if (packetIn.func_210384_b() == TileEntityStructure.UpdateCommand.SAVE_AREA) {
                        if (tileentitystructure.func_184419_m()) {
                            this.field_147369_b.func_146105_b((ITextComponent)new TextComponentTranslation("structure_block.save_success", s), false);
                        } else {
                            this.field_147369_b.func_146105_b((ITextComponent)new TextComponentTranslation("structure_block.save_failure", s), false);
                        }
                    } else if (packetIn.func_210384_b() == TileEntityStructure.UpdateCommand.LOAD_AREA) {
                        if (!tileentitystructure.func_189709_F()) {
                            this.field_147369_b.func_146105_b((ITextComponent)new TextComponentTranslation("structure_block.load_not_found", s), false);
                        } else if (tileentitystructure.func_184412_n()) {
                            this.field_147369_b.func_146105_b((ITextComponent)new TextComponentTranslation("structure_block.load_success", s), false);
                        } else {
                            this.field_147369_b.func_146105_b((ITextComponent)new TextComponentTranslation("structure_block.load_prepare", s), false);
                        }
                    } else if (packetIn.func_210384_b() == TileEntityStructure.UpdateCommand.SCAN_AREA) {
                        if (tileentitystructure.func_184417_l()) {
                            this.field_147369_b.func_146105_b((ITextComponent)new TextComponentTranslation("structure_block.size_success", s), false);
                        } else {
                            this.field_147369_b.func_146105_b((ITextComponent)new TextComponentTranslation("structure_block.size_failure", new Object[0]), false);
                        }
                    }
                } else {
                    this.field_147369_b.func_146105_b((ITextComponent)new TextComponentTranslation("structure_block.invalid_structure_name", packetIn.func_210377_d()), false);
                }
                tileentitystructure.func_70296_d();
                this.field_147369_b.field_70170_p.func_184138_a(blockpos, iblockstate, iblockstate, 3);
            }
        }
    }

    public void func_210159_a(CPacketSelectTrade packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        int i = packetIn.func_210353_a();
        Container container = this.field_147369_b.field_71070_bA;
        if (container instanceof ContainerMerchant) {
            ((ContainerMerchant)container).func_75175_c(i);
        }
    }

    public void func_210156_a(CPacketEditBook packetIn) {
        ItemStack itemstack1;
        ItemStack itemstack = packetIn.func_210346_a();
        if (!itemstack.func_190926_b() && ItemWritableBook.func_150930_a((NBTTagCompound)itemstack.func_77978_p()) && !(itemstack1 = this.field_147369_b.func_184586_b(packetIn.func_212644_d())).func_190926_b() && itemstack.func_77973_b() == Items.field_151099_bA && itemstack1.func_77973_b() == Items.field_151099_bA) {
            if (packetIn.func_210345_b()) {
                ItemStack itemstack2 = new ItemStack(Items.field_151164_bB);
                itemstack2.func_77983_a("author", new NBTTagString(this.field_147369_b.func_200200_C_().getString()));
                itemstack2.func_77983_a("title", new NBTTagString(itemstack.func_77978_p().func_74779_i("title")));
                NBTTagList nbttaglist = itemstack.func_77978_p().func_150295_c("pages", 8);
                for (int i = 0; i < nbttaglist.size(); ++i) {
                    String s = nbttaglist.func_150307_f(i);
                    TextComponentString itextcomponent = new TextComponentString(s);
                    s = ITextComponent.Serializer.func_150696_a((ITextComponent)itextcomponent);
                    nbttaglist.set(i, (INBTBase)new NBTTagString(s));
                }
                itemstack2.func_77983_a("pages", (INBTBase)nbttaglist);
                EntityEquipmentSlot entityequipmentslot = packetIn.func_212644_d() == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND;
                this.field_147369_b.func_184201_a(entityequipmentslot, itemstack2);
            } else {
                itemstack1.func_77983_a("pages", (INBTBase)itemstack.func_77978_p().func_150295_c("pages", 8));
            }
        }
    }

    public void func_211526_a(CPacketNBTQueryEntity packetIn) {
        Entity entity;
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_211513_k(2) && (entity = this.field_147369_b.func_71121_q().func_73045_a(packetIn.func_211720_c())) != null) {
            NBTTagCompound nbttagcompound = entity.func_189511_e(new NBTTagCompound());
            this.field_147369_b.field_71135_a.func_147359_a((Packet<?>)new SPacketNBTQueryResponse(packetIn.func_211721_b(), nbttagcompound));
        }
    }

    public void func_211525_a(CPacketNBTQueryTileEntity packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_211513_k(2)) {
            TileEntity tileentity = this.field_147369_b.func_71121_q().func_175625_s(packetIn.func_211717_c());
            NBTTagCompound nbttagcompound = tileentity != null ? tileentity.func_189515_b(new NBTTagCompound()) : null;
            this.field_147369_b.field_71135_a.func_147359_a((Packet<?>)new SPacketNBTQueryResponse(packetIn.func_211716_b(), nbttagcompound));
        }
    }

    public void func_147347_a(CPacketPlayer packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (NetHandlerPlayServer.func_183006_b(packetIn)) {
            this.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.invalid_player_movement", new Object[0]));
        } else {
            WorldServer worldserver = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
            if (!this.field_147369_b.field_71136_j) {
                if (this.field_147368_e == 0) {
                    this.func_184342_d();
                }
                if (this.field_184362_y != null) {
                    if (this.field_147368_e - this.field_184343_A > 20) {
                        this.field_184343_A = this.field_147368_e;
                        this.func_147364_a(this.field_184362_y.field_72450_a, this.field_184362_y.field_72448_b, this.field_184362_y.field_72449_c, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                    }
                } else {
                    this.field_184343_A = this.field_147368_e;
                    if (this.field_147369_b.func_184218_aH()) {
                        this.field_147369_b.func_70080_a(this.field_147369_b.field_70165_t, this.field_147369_b.field_70163_u, this.field_147369_b.field_70161_v, packetIn.func_186999_a(this.field_147369_b.field_70177_z), packetIn.func_186998_b(this.field_147369_b.field_70125_A));
                        this.field_147367_d.func_184103_al().func_72358_d(this.field_147369_b);
                    } else {
                        double d0 = this.field_147369_b.field_70165_t;
                        double d1 = this.field_147369_b.field_70163_u;
                        double d2 = this.field_147369_b.field_70161_v;
                        double d3 = this.field_147369_b.field_70163_u;
                        double d4 = packetIn.func_186997_a(this.field_147369_b.field_70165_t);
                        double d5 = packetIn.func_186996_b(this.field_147369_b.field_70163_u);
                        double d6 = packetIn.func_187000_c(this.field_147369_b.field_70161_v);
                        float f = packetIn.func_186999_a(this.field_147369_b.field_70177_z);
                        float f1 = packetIn.func_186998_b(this.field_147369_b.field_70125_A);
                        double d7 = d4 - this.field_184349_l;
                        double d8 = d5 - this.field_184350_m;
                        double d9 = d6 - this.field_184351_n;
                        double d10 = this.field_147369_b.field_70159_w * this.field_147369_b.field_70159_w + this.field_147369_b.field_70181_x * this.field_147369_b.field_70181_x + this.field_147369_b.field_70179_y * this.field_147369_b.field_70179_y;
                        double d11 = d7 * d7 + d8 * d8 + d9 * d9;
                        if (this.field_147369_b.func_70608_bn()) {
                            if (d11 > 1.0) {
                                this.func_147364_a(this.field_147369_b.field_70165_t, this.field_147369_b.field_70163_u, this.field_147369_b.field_70161_v, packetIn.func_186999_a(this.field_147369_b.field_70177_z), packetIn.func_186998_b(this.field_147369_b.field_70125_A));
                            }
                        } else {
                            ++this.field_184347_F;
                            int i = this.field_184347_F - this.field_184348_G;
                            if (i > 5) {
                                field_147370_c.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)i);
                                i = 1;
                            }
                            if (!(this.field_147369_b.func_184850_K() || this.field_147369_b.func_71121_q().func_82736_K().func_82766_b("disableElytraMovementCheck") && this.field_147369_b.func_184613_cA())) {
                                float f2;
                                float f3 = f2 = this.field_147369_b.func_184613_cA() ? 300.0f : 100.0f;
                                if (!(!(d11 - d10 > (double)(f2 * (float)i)) || this.field_147367_d.func_71264_H() && this.field_147367_d.func_71214_G().equals(this.field_147369_b.func_146103_bH().getName()))) {
                                    field_147370_c.warn("{} moved too quickly! {},{},{}", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)d7, (Object)d8, (Object)d9);
                                    this.func_147364_a(this.field_147369_b.field_70165_t, this.field_147369_b.field_70163_u, this.field_147369_b.field_70161_v, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                                    return;
                                }
                            }
                            boolean flag2 = worldserver.func_195586_b(this.field_147369_b, this.field_147369_b.func_174813_aQ().func_186664_h(0.0625));
                            d7 = d4 - this.field_184352_o;
                            d8 = d5 - this.field_184353_p;
                            d9 = d6 - this.field_184354_q;
                            if (this.field_147369_b.field_70122_E && !packetIn.func_149465_i() && d8 > 0.0) {
                                this.field_147369_b.func_70664_aZ();
                            }
                            this.field_147369_b.func_70091_d(MoverType.PLAYER, d7, d8, d9);
                            this.field_147369_b.field_70122_E = packetIn.func_149465_i();
                            double d12 = d8;
                            d7 = d4 - this.field_147369_b.field_70165_t;
                            d8 = d5 - this.field_147369_b.field_70163_u;
                            if (d8 > -0.5 || d8 < 0.5) {
                                d8 = 0.0;
                            }
                            d9 = d6 - this.field_147369_b.field_70161_v;
                            d11 = d7 * d7 + d8 * d8 + d9 * d9;
                            boolean flag = false;
                            if (!this.field_147369_b.func_184850_K() && d11 > 0.0625 && !this.field_147369_b.func_70608_bn() && !this.field_147369_b.field_71134_c.func_73083_d() && this.field_147369_b.field_71134_c.func_73081_b() != GameType.SPECTATOR) {
                                flag = true;
                                field_147370_c.warn("{} moved wrongly!", (Object)this.field_147369_b.func_200200_C_().getString());
                            }
                            this.field_147369_b.func_70080_a(d4, d5, d6, f, f1);
                            this.field_147369_b.func_71000_j(this.field_147369_b.field_70165_t - d0, this.field_147369_b.field_70163_u - d1, this.field_147369_b.field_70161_v - d2);
                            if (!this.field_147369_b.field_70145_X && !this.field_147369_b.func_70608_bn()) {
                                boolean flag1 = worldserver.func_195586_b(this.field_147369_b, this.field_147369_b.func_174813_aQ().func_186664_h(0.0625));
                                if (flag2 && (flag || !flag1)) {
                                    this.func_147364_a(d0, d1, d2, f, f1);
                                    return;
                                }
                            }
                            this.field_184344_B = d12 >= -0.03125;
                            this.field_184344_B &= !this.field_147367_d.func_71231_X() && !this.field_147369_b.field_71075_bZ.field_75101_c;
                            this.field_184344_B &= !this.field_147369_b.func_70644_a(MobEffects.field_188424_y) && !this.field_147369_b.func_184613_cA() && !worldserver.func_72829_c(this.field_147369_b.func_174813_aQ().func_186662_g(0.0625).func_72321_a(0.0, -0.55, 0.0));
                            this.field_147369_b.field_70122_E = packetIn.func_149465_i();
                            this.field_147367_d.func_184103_al().func_72358_d(this.field_147369_b);
                            this.field_147369_b.func_71122_b(this.field_147369_b.field_70163_u - d3, packetIn.func_149465_i());
                            this.field_184352_o = this.field_147369_b.field_70165_t;
                            this.field_184353_p = this.field_147369_b.field_70163_u;
                            this.field_184354_q = this.field_147369_b.field_70161_v;
                        }
                    }
                }
            }
        }
    }

    public void func_147364_a(double x, double y, double z, float yaw, float pitch) {
        this.func_175089_a(x, y, z, yaw, pitch, Collections.emptySet());
    }

    public void func_175089_a(double x, double y, double z, float yaw, float pitch, Set<SPacketPlayerPosLook.EnumFlags> relativeSet) {
        double d0 = relativeSet.contains(SPacketPlayerPosLook.EnumFlags.X) ? this.field_147369_b.field_70165_t : 0.0;
        double d1 = relativeSet.contains(SPacketPlayerPosLook.EnumFlags.Y) ? this.field_147369_b.field_70163_u : 0.0;
        double d2 = relativeSet.contains(SPacketPlayerPosLook.EnumFlags.Z) ? this.field_147369_b.field_70161_v : 0.0;
        float f = relativeSet.contains(SPacketPlayerPosLook.EnumFlags.Y_ROT) ? this.field_147369_b.field_70177_z : 0.0f;
        float f1 = relativeSet.contains(SPacketPlayerPosLook.EnumFlags.X_ROT) ? this.field_147369_b.field_70125_A : 0.0f;
        this.field_184362_y = new Vec3d(x, y, z);
        if (++this.field_184363_z == Integer.MAX_VALUE) {
            this.field_184363_z = 0;
        }
        this.field_184343_A = this.field_147368_e;
        this.field_147369_b.func_70080_a(x, y, z, yaw, pitch);
        this.field_147369_b.field_71135_a.func_147359_a((Packet<?>)new SPacketPlayerPosLook(x - d0, y - d1, z - d2, yaw - f, pitch - f1, relativeSet, this.field_184363_z));
    }

    public void func_147345_a(CPacketPlayerDigging packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        WorldServer worldserver = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
        BlockPos blockpos = packetIn.func_179715_a();
        this.field_147369_b.func_143004_u();
        switch (packetIn.func_180762_c()) {
            case SWAP_HELD_ITEMS: {
                if (!this.field_147369_b.func_175149_v()) {
                    ItemStack itemstack = this.field_147369_b.func_184586_b(EnumHand.OFF_HAND);
                    this.field_147369_b.func_184611_a(EnumHand.OFF_HAND, this.field_147369_b.func_184586_b(EnumHand.MAIN_HAND));
                    this.field_147369_b.func_184611_a(EnumHand.MAIN_HAND, itemstack);
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.field_147369_b.func_175149_v()) {
                    this.field_147369_b.func_71040_bB(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.field_147369_b.func_175149_v()) {
                    this.field_147369_b.func_71040_bB(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.field_147369_b.func_184597_cx();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                double d0 = this.field_147369_b.field_70165_t - ((double)blockpos.func_177958_n() + 0.5);
                double d1 = this.field_147369_b.field_70163_u - ((double)blockpos.func_177956_o() + 0.5) + 1.5;
                double d2 = this.field_147369_b.field_70161_v - ((double)blockpos.func_177952_p() + 0.5);
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                double dist = this.field_147369_b.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() + 1.0;
                dist *= dist;
                if (d3 > dist) {
                    return;
                }
                if (blockpos.func_177956_o() >= this.field_147367_d.func_71207_Z()) {
                    return;
                }
                if (packetIn.func_180762_c() == CPacketPlayerDigging.Action.START_DESTROY_BLOCK) {
                    if (!this.field_147367_d.func_175579_a(worldserver, blockpos, this.field_147369_b) && worldserver.func_175723_af().func_177746_a(blockpos)) {
                        this.field_147369_b.field_71134_c.func_180784_a(blockpos, packetIn.func_179714_b());
                    } else {
                        this.field_147369_b.field_71135_a.func_147359_a((Packet<?>)new SPacketBlockChange((IBlockReader)worldserver, blockpos));
                    }
                } else {
                    if (packetIn.func_180762_c() == CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK) {
                        this.field_147369_b.field_71134_c.func_180785_a(blockpos);
                    } else if (packetIn.func_180762_c() == CPacketPlayerDigging.Action.ABORT_DESTROY_BLOCK) {
                        this.field_147369_b.field_71134_c.func_180238_e();
                    }
                    if (!worldserver.func_180495_p(blockpos).func_196958_f()) {
                        this.field_147369_b.field_71135_a.func_147359_a((Packet<?>)new SPacketBlockChange((IBlockReader)worldserver, blockpos));
                    }
                }
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    public void func_184337_a(CPacketPlayerTryUseItemOnBlock packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        WorldServer worldserver = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
        EnumHand enumhand = packetIn.func_187022_c();
        ItemStack itemstack = this.field_147369_b.func_184586_b(enumhand);
        BlockPos blockpos = packetIn.func_187023_a();
        EnumFacing enumfacing = packetIn.func_187024_b();
        this.field_147369_b.func_143004_u();
        if (blockpos.func_177956_o() < this.field_147367_d.func_71207_Z() - 1 || enumfacing != EnumFacing.UP && blockpos.func_177956_o() < this.field_147367_d.func_71207_Z()) {
            double dist = this.field_147369_b.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() + 3.0;
            dist *= dist;
            if (this.field_184362_y == null && this.field_147369_b.func_70092_e((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5) < dist && !this.field_147367_d.func_175579_a(worldserver, blockpos, this.field_147369_b) && worldserver.func_175723_af().func_177746_a(blockpos)) {
                this.field_147369_b.field_71134_c.func_187251_a(this.field_147369_b, worldserver, itemstack, enumhand, blockpos, enumfacing, packetIn.func_187026_d(), packetIn.func_187025_e(), packetIn.func_187020_f());
            }
        } else {
            ITextComponent itextcomponent = new TextComponentTranslation("build.tooHigh", this.field_147367_d.func_71207_Z()).func_211708_a(TextFormatting.RED);
            this.field_147369_b.field_71135_a.func_147359_a((Packet<?>)new SPacketChat(itextcomponent, ChatType.GAME_INFO));
        }
        this.field_147369_b.field_71135_a.func_147359_a((Packet<?>)new SPacketBlockChange((IBlockReader)worldserver, blockpos));
        this.field_147369_b.field_71135_a.func_147359_a((Packet<?>)new SPacketBlockChange((IBlockReader)worldserver, blockpos.func_177972_a(enumfacing)));
    }

    public void func_147346_a(CPacketPlayerTryUseItem packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        WorldServer worldserver = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
        EnumHand enumhand = packetIn.func_187028_a();
        ItemStack itemstack = this.field_147369_b.func_184586_b(enumhand);
        this.field_147369_b.func_143004_u();
        if (!itemstack.func_190926_b()) {
            this.field_147369_b.field_71134_c.func_187250_a(this.field_147369_b, worldserver, itemstack, enumhand);
        }
    }

    public void func_175088_a(CPacketSpectate packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_175149_v()) {
            WorldServer worldserver;
            Entity entity = null;
            Iterator<WorldServer> iterator = this.field_147367_d.func_212370_w().iterator();
            while (iterator.hasNext() && (entity = packetIn.func_179727_a(worldserver = iterator.next())) == null) {
            }
            if (entity != null) {
                this.field_147369_b.func_200619_a((WorldServer)entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            }
        }
    }

    public void func_175086_a(CPacketResourcePackStatus packetIn) {
    }

    public void func_184340_a(CPacketSteerBoat packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        Entity entity = this.field_147369_b.func_184187_bx();
        if (entity instanceof EntityBoat) {
            ((EntityBoat)entity).func_184445_a(packetIn.func_187012_a(), packetIn.func_187014_b());
        }
    }

    public void func_147231_a(ITextComponent reason) {
        field_147370_c.info("{} lost connection: {}", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)reason.getString());
        this.field_147367_d.func_147132_au();
        this.field_147367_d.func_184103_al().func_148539_a(new TextComponentTranslation("multiplayer.player.left", this.field_147369_b.func_145748_c_()).func_211708_a(TextFormatting.YELLOW));
        this.field_147369_b.func_71123_m();
        this.field_147367_d.func_184103_al().func_72367_e(this.field_147369_b);
        if (this.field_147367_d.func_71264_H() && this.field_147369_b.func_200200_C_().getString().equals(this.field_147367_d.func_71214_G())) {
            field_147370_c.info("Stopping singleplayer server as player logged out");
            this.field_147367_d.func_71263_m();
        }
    }

    public void func_147359_a(Packet<?> packetIn) {
        this.func_211148_a(packetIn, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)null));
    }

    public void func_211148_a(Packet<?> packetIn, @Nullable GenericFutureListener<? extends Future<? super Void>> futureListeners) {
        if (packetIn instanceof SPacketChat) {
            SPacketChat spacketchat = (SPacketChat)packetIn;
            EntityPlayer.EnumChatVisibility entityplayer$enumchatvisibility = this.field_147369_b.func_147096_v();
            if (entityplayer$enumchatvisibility == EntityPlayer.EnumChatVisibility.HIDDEN && spacketchat.func_192590_c() != ChatType.GAME_INFO) {
                return;
            }
            if (entityplayer$enumchatvisibility == EntityPlayer.EnumChatVisibility.SYSTEM && !spacketchat.func_148916_d()) {
                return;
            }
        }
        try {
            this.field_147371_a.func_201058_a(packetIn, futureListeners);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Sending packet");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Packet being sent");
            crashreportcategory.func_189529_a("Packet class", (ICrashReportDetail<String>)((ICrashReportDetail)() -> packetIn.getClass().getCanonicalName()));
            throw new ReportedException(crashreport);
        }
    }

    public void func_147355_a(CPacketHeldItemChange packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (packetIn.func_149614_c() >= 0 && packetIn.func_149614_c() < InventoryPlayer.func_70451_h()) {
            this.field_147369_b.field_71071_by.field_70461_c = packetIn.func_149614_c();
            this.field_147369_b.func_143004_u();
        } else {
            field_147370_c.warn("{} tried to set an invalid carried item", (Object)this.field_147369_b.func_200200_C_().getString());
        }
    }

    public void func_147354_a(CPacketChatMessage packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_147096_v() == EntityPlayer.EnumChatVisibility.HIDDEN) {
            this.func_147359_a((Packet<?>)new SPacketChat(new TextComponentTranslation("chat.cannotSend", new Object[0]).func_211708_a(TextFormatting.RED)));
        } else {
            this.field_147369_b.func_143004_u();
            String s = packetIn.func_149439_c();
            s = org.apache.commons.lang3.StringUtils.normalizeSpace((String)s);
            for (int i = 0; i < s.length(); ++i) {
                if (SharedConstants.func_71566_a(s.charAt(i))) continue;
                this.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.illegal_characters", new Object[0]));
                return;
            }
            if (s.startsWith("/")) {
                this.func_147361_d(s);
            } else {
                TextComponentTranslation itextcomponent = new TextComponentTranslation("chat.type.text", this.field_147369_b.func_145748_c_(), ForgeHooks.newChatWithLinks((String)s));
                if ((itextcomponent = ForgeHooks.onServerChatEvent((NetHandlerPlayServer)this, (String)s, (ITextComponent)itextcomponent)) == null) {
                    return;
                }
                this.field_147367_d.func_184103_al().func_148544_a((ITextComponent)itextcomponent, false);
            }
            this.field_147374_l += 20;
            if (this.field_147374_l > 200 && !this.field_147367_d.func_184103_al().func_152596_g(this.field_147369_b.func_146103_bH())) {
                this.func_194028_b((ITextComponent)new TextComponentTranslation("disconnect.spam", new Object[0]));
            }
        }
    }

    private void func_147361_d(String command) {
        this.field_147367_d.func_195571_aL().func_197059_a(this.field_147369_b.func_195051_bN(), command);
    }

    public void func_175087_a(CPacketAnimation packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        this.field_147369_b.func_184609_a(packetIn.func_187018_a());
    }

    public void func_147357_a(CPacketEntityAction packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        switch (packetIn.func_180764_b()) {
            case START_SNEAKING: {
                this.field_147369_b.func_70095_a(true);
                break;
            }
            case STOP_SNEAKING: {
                this.field_147369_b.func_70095_a(false);
                break;
            }
            case START_SPRINTING: {
                this.field_147369_b.func_70031_b(true);
                break;
            }
            case STOP_SPRINTING: {
                this.field_147369_b.func_70031_b(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.field_147369_b.func_70608_bn()) break;
                this.field_147369_b.func_70999_a(false, true, true);
                this.field_184362_y = new Vec3d(this.field_147369_b.field_70165_t, this.field_147369_b.field_70163_u, this.field_147369_b.field_70161_v);
                break;
            }
            case START_RIDING_JUMP: {
                if (!(this.field_147369_b.func_184187_bx() instanceof IJumpingMount)) break;
                IJumpingMount ijumpingmount1 = (IJumpingMount)this.field_147369_b.func_184187_bx();
                int i = packetIn.func_149512_e();
                if (!ijumpingmount1.func_184776_b() || i <= 0) break;
                ijumpingmount1.func_184775_b(i);
                break;
            }
            case STOP_RIDING_JUMP: {
                if (!(this.field_147369_b.func_184187_bx() instanceof IJumpingMount)) break;
                IJumpingMount ijumpingmount = (IJumpingMount)this.field_147369_b.func_184187_bx();
                ijumpingmount.func_184777_r_();
                break;
            }
            case OPEN_INVENTORY: {
                if (!(this.field_147369_b.func_184187_bx() instanceof AbstractHorse)) break;
                ((AbstractHorse)((Object)this.field_147369_b.func_184187_bx())).func_110199_f(this.field_147369_b);
                break;
            }
            case START_FALL_FLYING: {
                if (!this.field_147369_b.field_70122_E && this.field_147369_b.field_70181_x < 0.0 && !this.field_147369_b.func_184613_cA() && !this.field_147369_b.func_70090_H()) {
                    ItemStack itemstack = this.field_147369_b.func_184582_a(EntityEquipmentSlot.CHEST);
                    if (itemstack.func_77973_b() != Items.field_185160_cR || !ItemElytra.func_185069_d((ItemStack)itemstack)) break;
                    this.field_147369_b.func_184847_M();
                    break;
                }
                this.field_147369_b.func_189103_N();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    public void func_147340_a(CPacketUseEntity packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        WorldServer worldserver = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
        Entity entity = packetIn.func_149564_a((World)worldserver);
        this.field_147369_b.func_143004_u();
        if (entity != null) {
            boolean flag = this.field_147369_b.func_70685_l(entity);
            double d0 = 36.0;
            if (!flag) {
                d0 = 9.0;
            }
            if (this.field_147369_b.func_70068_e(entity) < d0) {
                if (packetIn.func_149565_c() == CPacketUseEntity.Action.INTERACT) {
                    EnumHand enumhand = packetIn.func_186994_b();
                    this.field_147369_b.func_190775_a(entity, enumhand);
                } else if (packetIn.func_149565_c() == CPacketUseEntity.Action.INTERACT_AT) {
                    EnumHand enumhand1 = packetIn.func_186994_b();
                    if (ForgeHooks.onInteractEntityAt((EntityPlayer)this.field_147369_b, (Entity)entity, (Vec3d)packetIn.func_179712_b(), (EnumHand)enumhand1) != null) {
                        return;
                    }
                    entity.func_184199_a(this.field_147369_b, packetIn.func_179712_b(), enumhand1);
                } else if (packetIn.func_149565_c() == CPacketUseEntity.Action.ATTACK) {
                    if (entity instanceof EntityItem || entity instanceof EntityXPOrb || entity instanceof EntityArrow || entity == this.field_147369_b) {
                        this.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.invalid_entity_attacked", new Object[0]));
                        this.field_147367_d.func_71236_h("Player " + this.field_147369_b.func_200200_C_().getString() + " tried to attack an invalid entity");
                        return;
                    }
                    this.field_147369_b.func_71059_n(entity);
                }
            }
        }
    }

    public void func_147342_a(CPacketClientStatus packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        CPacketClientStatus.State cpacketclientstatus$state = packetIn.func_149435_c();
        switch (cpacketclientstatus$state) {
            case PERFORM_RESPAWN: {
                if (this.field_147369_b.field_71136_j) {
                    this.field_147369_b.field_71136_j = false;
                    this.field_147369_b = this.field_147367_d.func_184103_al().func_72368_a(this.field_147369_b, DimensionType.OVERWORLD, true);
                    CriteriaTriggers.field_193134_u.func_193143_a(this.field_147369_b, DimensionType.THE_END, DimensionType.OVERWORLD);
                    break;
                }
                if (this.field_147369_b.func_110143_aJ() > 0.0f) {
                    return;
                }
                this.field_147369_b = this.field_147367_d.func_184103_al().func_72368_a(this.field_147369_b, this.field_147369_b.field_71093_bK, false);
                if (!this.field_147367_d.func_71199_h()) break;
                this.field_147369_b.func_71033_a(GameType.SPECTATOR);
                this.field_147369_b.func_71121_q().func_82736_K().func_82764_b("spectatorsGenerateChunks", "false", this.field_147367_d);
                break;
            }
            case REQUEST_STATS: {
                this.field_147369_b.func_147099_x().func_150876_a(this.field_147369_b);
            }
        }
    }

    public void func_147356_a(CPacketCloseWindow packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_71128_l();
    }

    public void func_147351_a(CPacketClickWindow packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        if (this.field_147369_b.field_71070_bA.field_75152_c == packetIn.func_149548_c() && this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b)) {
            if (this.field_147369_b.func_175149_v()) {
                NonNullList nonnulllist = NonNullList.func_191196_a();
                for (int i = 0; i < this.field_147369_b.field_71070_bA.field_75151_b.size(); ++i) {
                    nonnulllist.add((Object)this.field_147369_b.field_71070_bA.field_75151_b.get(i).func_75211_c());
                }
                this.field_147369_b.func_71110_a(this.field_147369_b.field_71070_bA, (NonNullList<ItemStack>)nonnulllist);
            } else {
                ItemStack itemstack1 = this.field_147369_b.field_71070_bA.func_184996_a(packetIn.func_149544_d(), packetIn.func_149543_e(), packetIn.func_186993_f(), this.field_147369_b);
                if (ItemStack.func_77989_b(packetIn.func_149546_g(), itemstack1)) {
                    this.field_147369_b.field_71135_a.func_147359_a((Packet<?>)new SPacketConfirmTransaction(packetIn.func_149548_c(), packetIn.func_149547_f(), true));
                    this.field_147369_b.field_71137_h = true;
                    this.field_147369_b.field_71070_bA.func_75142_b();
                    this.field_147369_b.func_71113_k();
                    this.field_147369_b.field_71137_h = false;
                } else {
                    this.field_147372_n.func_76038_a(this.field_147369_b.field_71070_bA.field_75152_c, (Object)packetIn.func_149547_f());
                    this.field_147369_b.field_71135_a.func_147359_a((Packet<?>)new SPacketConfirmTransaction(packetIn.func_149548_c(), packetIn.func_149547_f(), false));
                    this.field_147369_b.field_71070_bA.func_75128_a(this.field_147369_b, false);
                    NonNullList nonnulllist1 = NonNullList.func_191196_a();
                    for (int j = 0; j < this.field_147369_b.field_71070_bA.field_75151_b.size(); ++j) {
                        ItemStack itemstack = this.field_147369_b.field_71070_bA.field_75151_b.get(j).func_75211_c();
                        nonnulllist1.add((Object)(itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack));
                    }
                    this.field_147369_b.func_71110_a(this.field_147369_b.field_71070_bA, (NonNullList<ItemStack>)nonnulllist1);
                }
            }
        }
    }

    public void func_194308_a(CPacketPlaceRecipe packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        if (!this.field_147369_b.func_175149_v() && this.field_147369_b.field_71070_bA.field_75152_c == packetIn.func_194318_a() && this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b)) {
            IRecipe irecipe = this.field_147367_d.func_199529_aN().func_199517_a(packetIn.func_199618_b());
            if (this.field_147369_b.field_71070_bA instanceof ContainerFurnace) {
                new ServerRecipePlacerFurnace().func_194327_a(this.field_147369_b, irecipe, packetIn.func_194319_c());
            } else {
                new ServerRecipePlacer().func_194327_a(this.field_147369_b, irecipe, packetIn.func_194319_c());
            }
        }
    }

    public void func_147338_a(CPacketEnchantItem packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        if (this.field_147369_b.field_71070_bA.field_75152_c == packetIn.func_149539_c() && this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) && !this.field_147369_b.func_175149_v()) {
            this.field_147369_b.field_71070_bA.func_75140_a(this.field_147369_b, packetIn.func_149537_d());
            this.field_147369_b.field_71070_bA.func_75142_b();
        }
    }

    public void func_147344_a(CPacketCreativeInventoryAction packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71134_c.func_73083_d()) {
            boolean flag2;
            BlockPos blockpos;
            TileEntity tileentity;
            boolean flag = packetIn.func_149627_c() < 0;
            ItemStack itemstack = packetIn.func_149625_d();
            NBTTagCompound nbttagcompound = itemstack.func_179543_a("BlockEntityTag");
            if (!itemstack.func_190926_b() && nbttagcompound != null && nbttagcompound.func_74764_b("x") && nbttagcompound.func_74764_b("y") && nbttagcompound.func_74764_b("z") && (tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos = new BlockPos(nbttagcompound.func_74762_e("x"), nbttagcompound.func_74762_e("y"), nbttagcompound.func_74762_e("z")))) != null) {
                NBTTagCompound nbttagcompound1 = tileentity.func_189515_b(new NBTTagCompound());
                nbttagcompound1.func_82580_o("x");
                nbttagcompound1.func_82580_o("y");
                nbttagcompound1.func_82580_o("z");
                itemstack.func_77983_a("BlockEntityTag", nbttagcompound1);
            }
            boolean flag1 = packetIn.func_149627_c() >= 1 && packetIn.func_149627_c() <= 45;
            boolean bl = flag2 = itemstack.func_190926_b() || itemstack.func_77952_i() >= 0 && itemstack.func_190916_E() <= 64 && !itemstack.func_190926_b();
            if (flag1 && flag2) {
                if (itemstack.func_190926_b()) {
                    this.field_147369_b.field_71069_bz.func_75141_a(packetIn.func_149627_c(), ItemStack.field_190927_a);
                } else {
                    this.field_147369_b.field_71069_bz.func_75141_a(packetIn.func_149627_c(), itemstack);
                }
                this.field_147369_b.field_71069_bz.func_75128_a(this.field_147369_b, true);
            } else if (flag && flag2 && this.field_147375_m < 200) {
                this.field_147375_m += 20;
                EntityItem entityitem = this.field_147369_b.func_71019_a(itemstack, true);
                if (entityitem != null) {
                    entityitem.func_70288_d();
                }
            }
        }
    }

    public void func_147339_a(CPacketConfirmTransaction packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        Short oshort = (Short)this.field_147372_n.func_76041_a(this.field_147369_b.field_71070_bA.field_75152_c);
        if (oshort != null && packetIn.func_149533_d() == oshort.shortValue() && this.field_147369_b.field_71070_bA.field_75152_c == packetIn.func_149532_c() && !this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) && !this.field_147369_b.func_175149_v()) {
            this.field_147369_b.field_71070_bA.func_75128_a(this.field_147369_b, true);
        }
    }

    public void func_147343_a(CPacketUpdateSign packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        WorldServer worldserver = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
        BlockPos blockpos = packetIn.func_179722_a();
        if (worldserver.func_175667_e(blockpos)) {
            IBlockState iblockstate = worldserver.func_180495_p(blockpos);
            TileEntity tileentity = worldserver.func_175625_s(blockpos);
            if (!(tileentity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            if (!tileentitysign.func_145914_a() || tileentitysign.func_145911_b() != this.field_147369_b) {
                this.field_147367_d.func_71236_h("Player " + this.field_147369_b.func_200200_C_().getString() + " just tried to change non-editable sign");
                return;
            }
            String[] astring = packetIn.func_187017_b();
            for (int i = 0; i < astring.length; ++i) {
                tileentitysign.func_212365_a(i, (ITextComponent)new TextComponentString(TextFormatting.func_110646_a((String)astring[i])));
            }
            tileentitysign.func_70296_d();
            worldserver.func_184138_a(blockpos, iblockstate, iblockstate, 3);
        }
    }

    public void func_147353_a(CPacketKeepAlive packetIn) {
        if (this.field_194403_g && packetIn.func_149460_c() == this.field_194404_h) {
            int i = (int)(Util.func_211177_b() - this.field_194402_f);
            this.field_147369_b.field_71138_i = (this.field_147369_b.field_71138_i * 3 + i) / 4;
            this.field_194403_g = false;
        } else if (!this.field_147369_b.func_200200_C_().getString().equals(this.field_147367_d.func_71214_G())) {
            this.func_194028_b((ITextComponent)new TextComponentTranslation("disconnect.timeout", new Object[0]));
        }
    }

    public void func_147348_a(CPacketPlayerAbilities packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        this.field_147369_b.field_71075_bZ.field_75100_b = packetIn.func_149488_d() && this.field_147369_b.field_71075_bZ.field_75101_c;
    }

    public void func_147352_a(CPacketClientSettings packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_147100_a(packetIn);
    }

    public void func_147349_a(CPacketCustomPayload packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)this, (IThreadListener)this.field_147369_b.func_71121_q());
        NetworkHooks.onCustomPayload((ICustomPacket)packetIn, (NetworkManager)this.field_147371_a);
    }
}

