/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.init.Fluids;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.particles.IParticleData;
import net.minecraft.stats.StatList;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class ItemBucket
extends Item {
    private final Fluid field_77876_a;

    public ItemBucket(Fluid containedFluidIn, Item.Properties builder) {
        super(builder);
        this.field_77876_a = containedFluidIn;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        RayTraceResult raytraceresult;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)playerIn, (World)worldIn, (ItemStack)itemstack, (RayTraceResult)(raytraceresult = this.func_77621_a(worldIn, playerIn, this.field_77876_a == Fluids.field_204541_a)));
        if (ret != null) {
            return ret;
        }
        if (raytraceresult == null) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemstack);
        }
        if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.field_178784_b, itemstack)) {
                if (this.field_77876_a == Fluids.field_204541_a) {
                    Fluid fluid;
                    IBlockState iblockstate1 = worldIn.func_180495_p(blockpos);
                    if (iblockstate1.func_177230_c() instanceof IBucketPickupHandler && (fluid = ((IBucketPickupHandler)iblockstate1.func_177230_c()).func_204508_a((IWorld)worldIn, blockpos, iblockstate1)) != Fluids.field_204541_a) {
                        playerIn.func_71029_a(StatList.field_75929_E.func_199076_b((Object)this));
                        playerIn.func_184185_a(fluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M, 1.0f, 1.0f);
                        ItemStack itemstack1 = this.func_150910_a(itemstack, playerIn, fluid.func_204524_b());
                        if (!worldIn.field_72995_K) {
                            CriteriaTriggers.field_204813_j.func_204817_a((EntityPlayerMP)playerIn, new ItemStack(fluid.func_204524_b()));
                        }
                        return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, itemstack1);
                    }
                    return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
                }
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                BlockPos blockpos1 = this.func_210768_a(iblockstate, blockpos, raytraceresult);
                if (this.func_180616_a(playerIn, worldIn, blockpos1, raytraceresult)) {
                    this.func_203792_a(worldIn, itemstack, blockpos1);
                    if (playerIn instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)playerIn, blockpos1, itemstack);
                    }
                    playerIn.func_71029_a(StatList.field_75929_E.func_199076_b((Object)this));
                    return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, this.func_203790_a(itemstack, playerIn));
                }
                return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
            }
            return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
        }
        return new ActionResult<ItemStack>(EnumActionResult.PASS, itemstack);
    }

    private BlockPos func_210768_a(IBlockState p_210768_1_, BlockPos p_210768_2_, RayTraceResult p_210768_3_) {
        return p_210768_1_.func_177230_c() instanceof ILiquidContainer ? p_210768_2_ : p_210768_3_.func_178782_a().func_177972_a(p_210768_3_.field_178784_b);
    }

    protected ItemStack func_203790_a(ItemStack p_203790_1_, EntityPlayer p_203790_2_) {
        return !p_203790_2_.field_71075_bZ.field_75098_d ? new ItemStack(Items.field_151133_ar) : p_203790_1_;
    }

    public void func_203792_a(World p_203792_1_, ItemStack p_203792_2_, BlockPos p_203792_3_) {
    }

    private ItemStack func_150910_a(ItemStack emptyBuckets, EntityPlayer player, Item fullBucket) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBuckets;
        }
        emptyBuckets.func_190918_g(1);
        if (emptyBuckets.func_190926_b()) {
            return new ItemStack(fullBucket);
        }
        if (!player.field_71071_by.func_70441_a(new ItemStack(fullBucket))) {
            player.func_71019_a(new ItemStack(fullBucket), false);
        }
        return emptyBuckets;
    }

    public boolean func_180616_a(@Nullable EntityPlayer player, World worldIn, BlockPos posIn, @Nullable RayTraceResult p_180616_4_) {
        if (!(this.field_77876_a instanceof FlowingFluid)) {
            return false;
        }
        IBlockState iblockstate = worldIn.func_180495_p(posIn);
        Material material = iblockstate.func_185904_a();
        boolean flag = !material.func_76220_a();
        boolean flag1 = material.func_76222_j();
        if (worldIn.func_175623_d(posIn) || flag || flag1 || iblockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)iblockstate.func_177230_c()).func_204510_a((IBlockReader)worldIn, posIn, iblockstate, this.field_77876_a)) {
            if (worldIn.field_73011_w.func_177500_n() && this.field_77876_a.func_207185_a(FluidTags.field_206959_a)) {
                int i = posIn.func_177958_n();
                int j = posIn.func_177956_o();
                int k = posIn.func_177952_p();
                worldIn.func_184133_a(player, posIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.func_195594_a((IParticleData)Particles.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (iblockstate.func_177230_c() instanceof ILiquidContainer) {
                if (((ILiquidContainer)iblockstate.func_177230_c()).func_204509_a((IWorld)worldIn, posIn, iblockstate, ((FlowingFluid)this.field_77876_a).func_207204_a(false))) {
                    this.func_203791_b(player, worldIn, posIn);
                }
            } else {
                if (!worldIn.field_72995_K && (flag || flag1) && !material.func_76224_d()) {
                    worldIn.func_175655_b(posIn, true);
                }
                this.func_203791_b(player, worldIn, posIn);
                worldIn.func_180501_a(posIn, this.field_77876_a.func_207188_f().func_206883_i(), 11);
            }
            return true;
        }
        return p_180616_4_ == null ? false : this.func_180616_a(player, worldIn, p_180616_4_.func_178782_a().func_177972_a(p_180616_4_.field_178784_b), null);
    }

    protected void func_203791_b(@Nullable EntityPlayer p_203791_1_, IWorld p_203791_2_, BlockPos p_203791_3_) {
        SoundEvent soundevent = this.field_77876_a.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        p_203791_2_.func_184133_a(p_203791_1_, p_203791_3_, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (((Object)((Object)this)).getClass() == ItemBucket.class) {
            return new FluidBucketWrapper(stack);
        }
        return super.initCapabilities(stack, nbt);
    }
}

