/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemAir;
import net.minecraft.item.ItemAppleGold;
import net.minecraft.item.ItemAppleGoldEnchanted;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemArmorDyeable;
import net.minecraft.item.ItemArmorStand;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemBed;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockTall;
import net.minecraft.item.ItemBoat;
import net.minecraft.item.ItemBoneMeal;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemBucketFish;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemCarrotOnAStick;
import net.minecraft.item.ItemChorusFruit;
import net.minecraft.item.ItemClock;
import net.minecraft.item.ItemCocoa;
import net.minecraft.item.ItemCompass;
import net.minecraft.item.ItemDebugStick;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemEmptyMap;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemEndCrystal;
import net.minecraft.item.ItemEnderEye;
import net.minecraft.item.ItemEnderPearl;
import net.minecraft.item.ItemExpBottle;
import net.minecraft.item.ItemFireCharge;
import net.minecraft.item.ItemFireworkRocket;
import net.minecraft.item.ItemFireworkStar;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemGMOnly;
import net.minecraft.item.ItemGlassBottle;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemHangingEntity;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemItemFrame;
import net.minecraft.item.ItemKnowledgeBook;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemLilyPad;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemSaddle;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemSign;
import net.minecraft.item.ItemSimpleFoiled;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemSoup;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemSpawnEgg;
import net.minecraft.item.ItemSpectralArrow;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemString;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ItemTippedArrow;
import net.minecraft.item.ItemTrident;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ItemWallOrFloor;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.GameData;

public class Item
extends ForgeRegistryEntry<Item>
implements IItemProvider,
IForgeItem {
    public static final Map<Block, Item> field_179220_a = GameData.getBlockItemMap();
    private static final IItemPropertyGetter field_185046_b = (p_210306_0_, p_210306_1_, p_210306_2_) -> p_210306_0_.func_77951_h() ? 1.0f : 0.0f;
    private static final IItemPropertyGetter field_185047_c = (p_210307_0_, p_210307_1_, p_210307_2_) -> MathHelper.func_76131_a((float)((float)p_210307_0_.func_77952_i() / (float)p_210307_0_.func_77958_k()), (float)0.0f, (float)1.0f);
    private static final IItemPropertyGetter field_185048_d = (p_210305_0_, p_210305_1_, p_210305_2_) -> p_210305_2_ != null && p_210305_2_.func_184591_cq() != EnumHandSide.RIGHT ? 1.0f : 0.0f;
    private static final IItemPropertyGetter field_185049_e = (p_210308_0_, p_210308_1_, p_210308_2_) -> p_210308_2_ instanceof EntityPlayer ? ((EntityPlayer)p_210308_2_).func_184811_cZ().func_185143_a(p_210308_0_.func_77973_b(), 0.0f) : 0.0f;
    protected static final UUID field_111210_e = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID field_185050_h = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    protected static Random field_77697_d = new Random();
    public final Map<ResourceLocation, IItemPropertyGetter> field_185051_m = Maps.newHashMap();
    protected final ItemGroup field_77701_a;
    private final EnumRarity field_208075_l;
    private final int field_77777_bU;
    private final int field_77699_b;
    private final Item field_77700_c;
    @Nullable
    private String field_77774_bZ;
    @Nullable
    private final Supplier<TileEntityItemStackRenderer> teisr;
    private final Map<ToolType, Integer> toolClasses = Maps.newHashMap();
    protected final boolean canRepair;

    public static int func_150891_b(Item itemIn) {
        return itemIn == null ? 0 : IRegistry.field_212630_s.func_148757_b(itemIn);
    }

    public static Item func_150899_d(int id) {
        return IRegistry.field_212630_s.func_148754_a(id);
    }

    @Deprecated
    public static Item func_150898_a(Block blockIn) {
        Item item = field_179220_a.get((Object)blockIn);
        return item == null ? Items.field_190931_a : item;
    }

    public Item(Properties properties) {
        this.func_185043_a(new ResourceLocation("lefthanded"), field_185048_d);
        this.func_185043_a(new ResourceLocation("cooldown"), field_185049_e);
        this.field_77701_a = properties.field_200923_d;
        this.field_208075_l = properties.field_208104_e;
        this.field_77700_c = properties.field_200922_c;
        this.field_77699_b = properties.field_200921_b;
        this.field_77777_bU = properties.field_200920_a;
        this.canRepair = properties.canRepair;
        this.toolClasses.putAll(properties.toolClasses);
        Object tmp = properties.teisr == null ? null : DistExecutor.callWhenOn((Dist)Dist.CLIENT, (Supplier)properties.teisr);
        Supplier<TileEntityItemStackRenderer> supplier = this.teisr = tmp == null ? null : () -> (TileEntityItemStackRenderer)tmp;
        if (this.field_77699_b > 0) {
            this.func_185043_a(new ResourceLocation("damaged"), field_185046_b);
            this.func_185043_a(new ResourceLocation("damage"), field_185047_c);
        }
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IItemPropertyGetter func_185045_a(ResourceLocation key) {
        return this.field_185051_m.get(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_185040_i() {
        return !this.field_185051_m.isEmpty();
    }

    public boolean func_179215_a(NBTTagCompound nbt) {
        return false;
    }

    public boolean func_195938_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public Item func_199767_j() {
        return this;
    }

    public final void func_185043_a(ResourceLocation key, IItemPropertyGetter getter) {
        this.field_185051_m.put(key, getter);
    }

    public EnumActionResult func_195939_a(ItemUseContext p_195939_1_) {
        return EnumActionResult.PASS;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 1.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        return new ActionResult<ItemStack>(EnumActionResult.PASS, playerIn.func_184586_b(handIn));
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        return stack;
    }

    @Deprecated
    public final int func_77639_j() {
        return this.field_77777_bU;
    }

    @Deprecated
    public final int func_77612_l() {
        return this.field_77699_b;
    }

    public boolean func_77645_m() {
        return this.field_77699_b > 0;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return false;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return false;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_200296_o() {
        return new TextComponentTranslation(this.func_77658_a(), new Object[0]);
    }

    protected String func_195935_o() {
        if (this.field_77774_bZ == null) {
            this.field_77774_bZ = Util.func_200697_a((String)"item", (ResourceLocation)IRegistry.field_212630_s.func_177774_c(this));
        }
        return this.field_77774_bZ;
    }

    public String func_77658_a() {
        return this.func_195935_o();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public boolean func_77651_p() {
        return true;
    }

    @Nullable
    public final Item func_77668_q() {
        return this.field_77700_c;
    }

    @Deprecated
    public boolean func_77634_r() {
        return this.field_77700_c != null;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
    }

    public boolean func_77643_m_() {
        return false;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 0;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TextComponentTranslation(this.func_77667_c(stack), new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77948_v();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (!stack.func_77948_v()) {
            return this.field_208075_l;
        }
        switch (this.field_208075_l) {
            case COMMON: 
            case UNCOMMON: {
                return EnumRarity.RARE;
            }
            case RARE: {
                return EnumRarity.EPIC;
            }
        }
        return this.field_208075_l;
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemStackLimit(stack) == 1 && this.func_77645_m();
    }

    @Nullable
    protected RayTraceResult func_77621_a(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = playerIn.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.func_200259_a(vec3d, vec3d1, useLiquids ? RayTraceFluidMode.SOURCE_ONLY : RayTraceFluidMode.NEVER, false, false);
    }

    public int func_77619_b() {
        return 0;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack(this));
        }
    }

    protected boolean func_194125_a(ItemGroup group) {
        if (this.getCreativeTabs().stream().anyMatch(tab -> tab == group)) {
            return true;
        }
        ItemGroup itemgroup = this.func_77640_w();
        return itemgroup != null && (group == ItemGroup.field_78027_g || group == itemgroup);
    }

    @Nullable
    public final ItemGroup func_77640_w() {
        return this.field_77701_a;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @Deprecated
    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    public boolean isRepairable() {
        return this.canRepair && this.func_77645_m();
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        return this.toolClasses.keySet();
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        return this.toolClasses.getOrDefault(tool, -1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public final TileEntityItemStackRenderer getTileEntityItemStackRenderer() {
        TileEntityItemStackRenderer renderer = this.teisr != null ? this.teisr.get() : null;
        return renderer != null ? renderer : TileEntityItemStackRenderer.field_147719_a;
    }

    public static void func_150900_l() {
        Item.func_179214_a(Blocks.field_150350_a, (Item)new ItemAir(Blocks.field_150350_a, new Properties()));
        Item.func_200879_a(Blocks.field_150348_b, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196650_c, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196652_d, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196654_e, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196655_f, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196656_g, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196657_h, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196658_i, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150346_d, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196660_k, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196661_l, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150347_e, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196662_n, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196664_o, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196666_p, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196668_q, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196670_r, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196672_s, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196674_t, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196675_u, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196676_v, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196678_w, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196679_x, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196680_y, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150357_h, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150354_m, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196611_F, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150351_n, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150352_o, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150366_p, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150365_q, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196617_K, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196618_L, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196619_M, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196620_N, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196621_O, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196623_P, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203204_R, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203205_S, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203206_T, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203207_U, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203208_V, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203209_W, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_209389_ab, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_209390_ac, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_209391_ad, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_209392_ae, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_209393_af, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_209394_ag, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196626_Q, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196629_R, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196631_S, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196634_T, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196637_U, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196639_V, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196642_W, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196645_X, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196647_Y, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196648_Z, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196572_aa, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196574_ab, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150360_v, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196577_ad, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150359_w, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150369_x, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150368_y, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150367_z, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150322_A, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196583_aj, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196585_ak, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196586_al, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196552_aC, ItemGroup.field_78029_e);
        Item.func_200879_a(Blocks.field_150319_E, ItemGroup.field_78029_e);
        Item.func_200879_a(Blocks.field_150320_F, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196553_aF, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150349_c, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196554_aH, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196555_aI, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_203198_aQ, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_204913_jW, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150331_J, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196556_aL, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196557_aM, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196558_aN, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196559_aO, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196560_aP, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196561_aQ, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196562_aR, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196563_aS, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196564_aT, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196565_aU, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196566_aV, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196567_aW, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196568_aX, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196569_aY, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196570_aZ, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196602_ba, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196605_bc, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196606_bd, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196607_be, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196609_bf, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196610_bg, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196612_bh, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196613_bi, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196614_bj, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196615_bk, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196616_bl, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150338_P, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150337_Q, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150340_R, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150339_S, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196622_bq, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196624_br, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196627_bs, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196630_bt, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196632_bu, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196635_bv, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150333_U, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196640_bx, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196643_by, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196646_bz, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196571_bA, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196573_bB, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196575_bC, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196576_bD, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196578_bE, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_185771_cX, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203200_bP, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203201_bQ, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203202_bR, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196581_bI, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196582_bJ, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196580_bH, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196579_bG, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196584_bK, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150335_W, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150342_X, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150341_Y, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150343_Z, ItemGroup.field_78030_b);
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_150478_aa, Blocks.field_196591_bQ, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200879_a(Blocks.field_185764_cQ, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_185765_cR, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_185766_cS, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_185767_cT, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_185768_cU, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_185769_cV, ItemGroup.field_78030_b);
        Item.func_179216_c(Blocks.field_150474_ac);
        Item.func_200879_a(Blocks.field_150476_ad, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150486_ae, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150482_ag, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150484_ah, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150462_ai, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150458_ak, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150460_al, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150468_ap, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150448_aq, ItemGroup.field_78029_e);
        Item.func_200879_a(Blocks.field_196659_cl, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150442_at, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150456_au, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196663_cq, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196665_cr, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196667_cs, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196669_ct, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196671_cu, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196673_cv, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150450_ax, ItemGroup.field_78030_b);
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_150429_aA, Blocks.field_196677_cy, new Properties().func_200916_a(ItemGroup.field_78028_d)));
        Item.func_200879_a(Blocks.field_150430_aB, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150433_aE, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150432_aD, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196604_cC, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150434_aF, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150435_aG, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150421_aI, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_180407_aO, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_180408_aP, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_180404_aQ, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_180403_aR, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_180405_aT, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_180406_aS, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150423_aK, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196625_cS, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150424_aL, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150425_aM, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150426_aN, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196628_cT, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196636_cW, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196638_cX, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196641_cY, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196644_cZ, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196682_da, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196684_db, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196686_dc, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196687_dd, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196688_de, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196690_df, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196692_dg, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196694_dh, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196696_di, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196698_dj, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196700_dk, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196702_dl, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150420_aW, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150419_aX, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196706_do, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150411_aY, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150410_aZ, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150440_ba, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150395_bd, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_180390_bo, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_180391_bp, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_180392_bq, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_180386_br, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_180387_bt, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_180385_bs, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150389_bf, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150390_bg, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150391_bh, ItemGroup.field_78030_b);
        Item.func_200126_a(new ItemLilyPad(Blocks.field_196651_dG, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200879_a(Blocks.field_196653_dH, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150386_bk, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150387_bl, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150381_bn, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150378_br, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150377_bs, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196806_hJ, ItemGroup.field_78030_b);
        Item.func_200126_a(new ItemBlock(Blocks.field_150380_bt, new Properties().func_208103_a(EnumRarity.EPIC)));
        Item.func_200879_a(Blocks.field_150379_bu, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150372_bz, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150412_bA, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150477_bB, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150479_bC, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150475_bE, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150485_bF, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150487_bG, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150481_bH, ItemGroup.field_78030_b);
        Item.func_200126_a((ItemBlock)new ItemGMOnly(Blocks.field_150483_bI, new Properties().func_208103_a(EnumRarity.EPIC)));
        Item.func_200126_a(new ItemBlock(Blocks.field_150461_bJ, new Properties().func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_200879_a(Blocks.field_150463_bK, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196723_eg, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196689_eF, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196691_eG, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196693_eH, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196695_eI, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196697_eJ, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196699_eK, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150467_bQ, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196717_eY, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196718_eZ, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150447_bR, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150445_bS, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150443_bT, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150453_bW, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150451_bX, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196766_fg, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150438_bZ, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196772_fk, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150371_ca, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196770_fj, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150370_cb, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150408_cc, ItemGroup.field_78029_e);
        Item.func_200879_a(Blocks.field_150409_cd, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196777_fo, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196778_fp, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196780_fq, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196782_fr, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196783_fs, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196785_ft, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196787_fu, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196789_fv, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196791_fw, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196793_fx, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196795_fy, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196797_fz, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196719_fA, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196720_fB, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196721_fC, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196722_fD, ItemGroup.field_78030_b);
        Item.func_179216_c(Blocks.field_180401_cv);
        Item.func_200879_a(Blocks.field_180400_cw, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_150407_cf, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196724_fH, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196725_fI, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196727_fJ, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196729_fK, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196731_fL, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196733_fM, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196735_fN, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196737_fO, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196739_fP, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196741_fQ, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196743_fR, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196745_fS, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196747_fT, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196749_fU, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196751_fV, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196753_fW, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_150405_ch, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150402_ci, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150403_cj, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150400_ck, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_150401_cl, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_180399_cE, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_185774_da, ItemGroup.field_78031_c);
        Item.func_200126_a((ItemBlock)new ItemBlockTall(Blocks.field_196800_gd, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBlockTall(Blocks.field_196801_ge, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBlockTall(Blocks.field_196802_gf, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBlockTall(Blocks.field_196803_gg, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBlockTall(Blocks.field_196804_gh, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBlockTall(Blocks.field_196805_gi, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200879_a(Blocks.field_196807_gj, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196808_gk, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196809_gl, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196810_gm, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196811_gn, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196812_go, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196813_gp, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196815_gq, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196816_gr, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196818_gs, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196819_gt, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196820_gu, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196821_gv, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196822_gw, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196823_gx, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196824_gy, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196825_gz, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196758_gA, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196759_gB, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196760_gC, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196761_gD, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196763_gE, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196764_gF, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196765_gG, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196767_gH, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196768_gI, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196769_gJ, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196771_gK, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196773_gL, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196774_gM, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196775_gN, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196776_gO, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_180397_cI, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196779_gQ, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196781_gR, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203210_he, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203211_hf, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203212_hg, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_180398_cJ, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_180395_cM, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196798_hA, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196799_hB, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_180396_cN, ItemGroup.field_78030_b);
        Item.func_200126_a((ItemBlock)new ItemGMOnly(Blocks.field_185776_dc, new Properties().func_208103_a(EnumRarity.EPIC)));
        Item.func_200126_a((ItemBlock)new ItemGMOnly(Blocks.field_185777_dd, new Properties().func_208103_a(EnumRarity.EPIC)));
        Item.func_200879_a(Blocks.field_196814_hQ, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_189878_dg, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196817_hS, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_189880_di, ItemGroup.field_78030_b);
        Item.func_179216_c(Blocks.field_189881_dj);
        Item.func_200879_a(Blocks.field_190976_dk, ItemGroup.field_78028_d);
        Item.func_200126_a(new ItemBlock(Blocks.field_204409_il, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190977_dl, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190978_dm, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190979_dn, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190980_do, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190981_dp, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190982_dq, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190983_dr, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190984_ds, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_196875_ie, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190986_du, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190987_dv, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190988_dw, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190989_dx, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190990_dy, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190991_dz, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a(new ItemBlock(Blocks.field_190975_dA, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200879_a(Blocks.field_192427_dB, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192428_dC, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192429_dD, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192430_dE, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192431_dF, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192432_dG, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192433_dH, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192434_dI, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196876_iu, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192436_dK, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192437_dL, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192438_dM, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192439_dN, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192440_dO, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192441_dP, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_192442_dQ, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_196828_iC, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196830_iD, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196832_iE, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196834_iF, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196836_iG, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196838_iH, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196840_iI, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196842_iJ, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196844_iK, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196846_iL, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196848_iM, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196850_iN, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196852_iO, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196854_iP, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196856_iQ, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196858_iR, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196860_iS, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196862_iT, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196864_iU, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196866_iV, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196868_iW, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196870_iX, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196872_iY, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196874_iZ, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196877_ja, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196878_jb, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196879_jc, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196880_jd, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196881_je, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196882_jf, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196883_jg, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_196884_jh, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203213_jA, ItemGroup.field_78026_f);
        Item.func_200879_a(Blocks.field_204404_jE, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_204405_jF, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_204406_jG, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_204407_jH, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_204408_jI, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203963_jE, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203964_jF, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203965_jG, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203966_jH, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_203967_jI, ItemGroup.field_78030_b);
        Item.func_200879_a(Blocks.field_204278_jJ, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_204279_jK, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_204280_jL, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_204281_jM, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_204282_jN, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_212586_jZ, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_212587_ka, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_212588_kb, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_212589_kc, ItemGroup.field_78031_c);
        Item.func_200879_a(Blocks.field_212585_jY, ItemGroup.field_78031_c);
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_204743_jR, Blocks.field_211891_jY, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_204744_jS, Blocks.field_211892_jZ, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_204745_jT, Blocks.field_211893_ka, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_204746_jU, Blocks.field_211894_kb, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_204747_jV, Blocks.field_211895_kc, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_211901_kp, Blocks.field_211896_kk, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_211902_kq, Blocks.field_211897_kl, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_211903_kr, Blocks.field_211898_km, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_211904_ks, Blocks.field_211899_kn, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_211905_kt, Blocks.field_211900_ko, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200879_a(Blocks.field_205164_gk, ItemGroup.field_78030_b);
        Item.func_200126_a(new ItemBlock(Blocks.field_205165_jY, new Properties().func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_200126_a((ItemBlock)new ItemBlockTall(Blocks.field_150454_av, new Properties().func_200916_a(ItemGroup.field_78028_d)));
        Item.func_200126_a((ItemBlock)new ItemBlockTall(Blocks.field_180413_ao, new Properties().func_200916_a(ItemGroup.field_78028_d)));
        Item.func_200126_a((ItemBlock)new ItemBlockTall(Blocks.field_180414_ap, new Properties().func_200916_a(ItemGroup.field_78028_d)));
        Item.func_200126_a((ItemBlock)new ItemBlockTall(Blocks.field_180412_aq, new Properties().func_200916_a(ItemGroup.field_78028_d)));
        Item.func_200126_a((ItemBlock)new ItemBlockTall(Blocks.field_180411_ar, new Properties().func_200916_a(ItemGroup.field_78028_d)));
        Item.func_200126_a((ItemBlock)new ItemBlockTall(Blocks.field_180410_as, new Properties().func_200916_a(ItemGroup.field_78028_d)));
        Item.func_200126_a((ItemBlock)new ItemBlockTall(Blocks.field_180409_at, new Properties().func_200916_a(ItemGroup.field_78028_d)));
        Item.func_200879_a(Blocks.field_196633_cV, ItemGroup.field_78028_d);
        Item.func_200879_a(Blocks.field_196762_fd, ItemGroup.field_78028_d);
        Item.func_200126_a((ItemBlock)new ItemGMOnly(Blocks.field_185779_df, new Properties().func_208103_a(EnumRarity.EPIC)));
        Item.func_195936_a("turtle_helmet", new ItemArmor((IArmorMaterial)ArmorMaterial.TURTLE, EntityEquipmentSlot.HEAD, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("scute", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("iron_shovel", (Item)((Object)new ItemSpade((IItemTier)ItemTier.IRON, 1.5f, -3.0f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("iron_pickaxe", (Item)((Object)new ItemPickaxe((IItemTier)ItemTier.IRON, 1, -2.8f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("iron_axe", (Item)((Object)new ItemAxe((IItemTier)ItemTier.IRON, 6.0f, -3.1f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("flint_and_steel", (Item)new ItemFlintAndSteel(new Properties().func_200918_c(64).func_200916_a(ItemGroup.field_78040_i)));
        Item.func_195936_a("apple", (Item)new ItemFood(4, 0.3f, false, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("bow", new ItemBow(new Properties().func_200918_c(384).func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("arrow", new ItemArrow(new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("coal", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("charcoal", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("diamond", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("iron_ingot", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("gold_ingot", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("iron_sword", (Item)new ItemSword((IItemTier)ItemTier.IRON, 3, -2.4f, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("wooden_sword", (Item)new ItemSword((IItemTier)ItemTier.WOOD, 3, -2.4f, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("wooden_shovel", (Item)((Object)new ItemSpade((IItemTier)ItemTier.WOOD, 1.5f, -3.0f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("wooden_pickaxe", (Item)((Object)new ItemPickaxe((IItemTier)ItemTier.WOOD, 1, -2.8f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("wooden_axe", (Item)((Object)new ItemAxe((IItemTier)ItemTier.WOOD, 6.0f, -3.2f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("stone_sword", (Item)new ItemSword((IItemTier)ItemTier.STONE, 3, -2.4f, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("stone_shovel", (Item)((Object)new ItemSpade((IItemTier)ItemTier.STONE, 1.5f, -3.0f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("stone_pickaxe", (Item)((Object)new ItemPickaxe((IItemTier)ItemTier.STONE, 1, -2.8f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("stone_axe", (Item)((Object)new ItemAxe((IItemTier)ItemTier.STONE, 7.0f, -3.2f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("diamond_sword", (Item)new ItemSword((IItemTier)ItemTier.DIAMOND, 3, -2.4f, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("diamond_shovel", (Item)((Object)new ItemSpade((IItemTier)ItemTier.DIAMOND, 1.5f, -3.0f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("diamond_pickaxe", (Item)((Object)new ItemPickaxe((IItemTier)ItemTier.DIAMOND, 1, -2.8f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("diamond_axe", (Item)((Object)new ItemAxe((IItemTier)ItemTier.DIAMOND, 5.0f, -3.0f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("stick", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("bowl", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("mushroom_stew", (Item)new ItemSoup(6, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("golden_sword", (Item)new ItemSword((IItemTier)ItemTier.GOLD, 3, -2.4f, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("golden_shovel", (Item)((Object)new ItemSpade((IItemTier)ItemTier.GOLD, 1.5f, -3.0f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("golden_pickaxe", (Item)((Object)new ItemPickaxe((IItemTier)ItemTier.GOLD, 1, -2.8f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("golden_axe", (Item)((Object)new ItemAxe((IItemTier)ItemTier.GOLD, 6.0f, -3.0f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("string", (Item)new ItemString(new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("feather", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("gunpowder", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("wooden_hoe", (Item)((Object)new ItemHoe((IItemTier)ItemTier.WOOD, -3.0f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("stone_hoe", (Item)((Object)new ItemHoe((IItemTier)ItemTier.STONE, -2.0f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("iron_hoe", (Item)((Object)new ItemHoe((IItemTier)ItemTier.IRON, -1.0f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("diamond_hoe", (Item)((Object)new ItemHoe((IItemTier)ItemTier.DIAMOND, 0.0f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("golden_hoe", (Item)((Object)new ItemHoe((IItemTier)ItemTier.GOLD, -3.0f, new Properties().func_200916_a(ItemGroup.field_78040_i))));
        Item.func_195936_a("wheat_seeds", new ItemSeeds(Blocks.field_150464_aj, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("wheat", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("bread", (Item)new ItemFood(5, 0.6f, false, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("leather_helmet", (Item)new ItemArmorDyeable((IArmorMaterial)ArmorMaterial.LEATHER, EntityEquipmentSlot.HEAD, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("leather_chestplate", (Item)new ItemArmorDyeable((IArmorMaterial)ArmorMaterial.LEATHER, EntityEquipmentSlot.CHEST, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("leather_leggings", (Item)new ItemArmorDyeable((IArmorMaterial)ArmorMaterial.LEATHER, EntityEquipmentSlot.LEGS, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("leather_boots", (Item)new ItemArmorDyeable((IArmorMaterial)ArmorMaterial.LEATHER, EntityEquipmentSlot.FEET, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("chainmail_helmet", new ItemArmor((IArmorMaterial)ArmorMaterial.CHAIN, EntityEquipmentSlot.HEAD, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("chainmail_chestplate", new ItemArmor((IArmorMaterial)ArmorMaterial.CHAIN, EntityEquipmentSlot.CHEST, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("chainmail_leggings", new ItemArmor((IArmorMaterial)ArmorMaterial.CHAIN, EntityEquipmentSlot.LEGS, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("chainmail_boots", new ItemArmor((IArmorMaterial)ArmorMaterial.CHAIN, EntityEquipmentSlot.FEET, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("iron_helmet", new ItemArmor((IArmorMaterial)ArmorMaterial.IRON, EntityEquipmentSlot.HEAD, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("iron_chestplate", new ItemArmor((IArmorMaterial)ArmorMaterial.IRON, EntityEquipmentSlot.CHEST, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("iron_leggings", new ItemArmor((IArmorMaterial)ArmorMaterial.IRON, EntityEquipmentSlot.LEGS, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("iron_boots", new ItemArmor((IArmorMaterial)ArmorMaterial.IRON, EntityEquipmentSlot.FEET, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("diamond_helmet", new ItemArmor((IArmorMaterial)ArmorMaterial.DIAMOND, EntityEquipmentSlot.HEAD, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("diamond_chestplate", new ItemArmor((IArmorMaterial)ArmorMaterial.DIAMOND, EntityEquipmentSlot.CHEST, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("diamond_leggings", new ItemArmor((IArmorMaterial)ArmorMaterial.DIAMOND, EntityEquipmentSlot.LEGS, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("diamond_boots", new ItemArmor((IArmorMaterial)ArmorMaterial.DIAMOND, EntityEquipmentSlot.FEET, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("golden_helmet", new ItemArmor((IArmorMaterial)ArmorMaterial.GOLD, EntityEquipmentSlot.HEAD, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("golden_chestplate", new ItemArmor((IArmorMaterial)ArmorMaterial.GOLD, EntityEquipmentSlot.CHEST, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("golden_leggings", new ItemArmor((IArmorMaterial)ArmorMaterial.GOLD, EntityEquipmentSlot.LEGS, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("golden_boots", new ItemArmor((IArmorMaterial)ArmorMaterial.GOLD, EntityEquipmentSlot.FEET, new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("flint", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("porkchop", (Item)new ItemFood(3, 0.3f, true, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("cooked_porkchop", (Item)new ItemFood(8, 0.8f, true, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("painting", (Item)new ItemHangingEntity(EntityPainting.class, new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("golden_apple", (Item)new ItemAppleGold(4, 1.2f, false, new Properties().func_200916_a(ItemGroup.field_78039_h).func_208103_a(EnumRarity.RARE)).func_77848_i());
        Item.func_195936_a("enchanted_golden_apple", (Item)new ItemAppleGoldEnchanted(4, 1.2f, false, new Properties().func_200916_a(ItemGroup.field_78039_h).func_208103_a(EnumRarity.EPIC)).func_77848_i());
        Item.func_195936_a("sign", (Item)new ItemSign(new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        ItemBucket item = new ItemBucket(Fluids.field_204541_a, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78026_f));
        Item.func_195936_a("bucket", item);
        Item.func_195936_a("water_bucket", new ItemBucket((Fluid)Fluids.field_204546_a, new Properties().func_200919_a(item).func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("lava_bucket", new ItemBucket((Fluid)Fluids.field_204547_b, new Properties().func_200919_a(item).func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("minecart", new ItemMinecart(EntityMinecart.Type.RIDEABLE, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e)));
        Item.func_195936_a("saddle", (Item)new ItemSaddle(new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e)));
        Item.func_195936_a("redstone", new ItemBlock(Blocks.field_150488_af, new Properties().func_200916_a(ItemGroup.field_78028_d)));
        Item.func_195936_a("snowball", (Item)new ItemSnowball(new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("oak_boat", (Item)new ItemBoat(EntityBoat.Type.OAK, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e)));
        Item.func_195936_a("leather", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("milk_bucket", new ItemBucketMilk(new Properties().func_200919_a(item).func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("pufferfish_bucket", (Item)new ItemBucketFish(EntityType.field_203779_Z, (Fluid)Fluids.field_204546_a, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("salmon_bucket", (Item)new ItemBucketFish(EntityType.field_203778_ae, (Fluid)Fluids.field_204546_a, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("cod_bucket", (Item)new ItemBucketFish(EntityType.field_203780_j, (Fluid)Fluids.field_204546_a, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("tropical_fish_bucket", (Item)new ItemBucketFish(EntityType.field_204262_at, (Fluid)Fluids.field_204546_a, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("brick", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("clay_ball", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_200879_a(Blocks.field_196608_cF, ItemGroup.field_78026_f);
        Item.func_200879_a(Blocks.field_203214_jx, ItemGroup.field_78026_f);
        Item.func_200879_a(Blocks.field_203216_jz, ItemGroup.field_78030_b);
        Item.func_195936_a("paper", new Item(new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("book", (Item)new ItemBook(new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("slime_ball", new Item(new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("chest_minecart", new ItemMinecart(EntityMinecart.Type.CHEST, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e)));
        Item.func_195936_a("furnace_minecart", new ItemMinecart(EntityMinecart.Type.FURNACE, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e)));
        Item.func_195936_a("egg", (Item)new ItemEgg(new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("compass", (Item)new ItemCompass(new Properties().func_200916_a(ItemGroup.field_78040_i)));
        Item.func_195936_a("fishing_rod", (Item)new ItemFishingRod(new Properties().func_200918_c(64).func_200916_a(ItemGroup.field_78040_i)));
        Item.func_195936_a("clock", (Item)new ItemClock(new Properties().func_200916_a(ItemGroup.field_78040_i)));
        Item.func_195936_a("glowstone_dust", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("cod", (Item)new ItemFishFood(ItemFishFood.FishType.COD, false, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("salmon", (Item)new ItemFishFood(ItemFishFood.FishType.SALMON, false, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("tropical_fish", (Item)new ItemFishFood(ItemFishFood.FishType.TROPICAL_FISH, false, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("pufferfish", (Item)new ItemFishFood(ItemFishFood.FishType.PUFFERFISH, false, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("cooked_cod", (Item)new ItemFishFood(ItemFishFood.FishType.COD, true, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("cooked_salmon", (Item)new ItemFishFood(ItemFishFood.FishType.SALMON, true, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("ink_sac", (Item)new ItemDye(EnumDyeColor.BLACK, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("rose_red", (Item)new ItemDye(EnumDyeColor.RED, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("cactus_green", (Item)new ItemDye(EnumDyeColor.GREEN, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("cocoa_beans", (Item)new ItemCocoa(EnumDyeColor.BROWN, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("lapis_lazuli", (Item)new ItemDye(EnumDyeColor.BLUE, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("purple_dye", (Item)new ItemDye(EnumDyeColor.PURPLE, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("cyan_dye", (Item)new ItemDye(EnumDyeColor.CYAN, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("light_gray_dye", (Item)new ItemDye(EnumDyeColor.LIGHT_GRAY, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("gray_dye", (Item)new ItemDye(EnumDyeColor.GRAY, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("pink_dye", (Item)new ItemDye(EnumDyeColor.PINK, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("lime_dye", (Item)new ItemDye(EnumDyeColor.LIME, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("dandelion_yellow", (Item)new ItemDye(EnumDyeColor.YELLOW, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("light_blue_dye", (Item)new ItemDye(EnumDyeColor.LIGHT_BLUE, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("magenta_dye", (Item)new ItemDye(EnumDyeColor.MAGENTA, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("orange_dye", (Item)new ItemDye(EnumDyeColor.ORANGE, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("bone_meal", (Item)((Object)new ItemBoneMeal(EnumDyeColor.WHITE, new Properties().func_200916_a(ItemGroup.field_78035_l))));
        Item.func_195936_a("bone", new Item(new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("sugar", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_200126_a(new ItemBlock(Blocks.field_150414_aQ, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78039_h)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196587_am, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196588_an, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196589_ao, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196590_ap, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196592_aq, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196593_ar, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196594_as, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196595_at, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196596_au, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196597_av, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196598_aw, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196599_ax, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196600_ay, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196601_az, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196550_aA, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200126_a((ItemBlock)new ItemBed(Blocks.field_196551_aB, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("cookie", (Item)new ItemFood(2, 0.1f, false, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("filled_map", (Item)((Object)new ItemMap(new Properties())));
        Item.func_195936_a("shears", new ItemShears(new Properties().func_200918_c(238).func_200916_a(ItemGroup.field_78040_i)));
        Item.func_195936_a("melon_slice", (Item)new ItemFood(2, 0.3f, false, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("dried_kelp", (Item)new ItemFood(1, 0.3f, false, new Properties().func_200916_a(ItemGroup.field_78039_h)).func_203174_f());
        Item.func_195936_a("pumpkin_seeds", new ItemSeeds(Blocks.field_150393_bb, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("melon_seeds", new ItemSeeds(Blocks.field_150394_bc, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("beef", (Item)new ItemFood(3, 0.3f, true, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("cooked_beef", (Item)new ItemFood(8, 0.8f, true, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("chicken", (Item)new ItemFood(2, 0.3f, true, new Properties().func_200916_a(ItemGroup.field_78039_h)).func_185070_a(new PotionEffect(MobEffects.field_76438_s, 600, 0), 0.3f));
        Item.func_195936_a("cooked_chicken", (Item)new ItemFood(6, 0.6f, true, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("rotten_flesh", (Item)new ItemFood(4, 0.1f, true, new Properties().func_200916_a(ItemGroup.field_78039_h)).func_185070_a(new PotionEffect(MobEffects.field_76438_s, 600, 0), 0.8f));
        Item.func_195936_a("ender_pearl", (Item)new ItemEnderPearl(new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("blaze_rod", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("ghast_tear", new Item(new Properties().func_200916_a(ItemGroup.field_78038_k)));
        Item.func_195936_a("gold_nugget", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("nether_wart", new ItemSeeds(Blocks.field_150388_bm, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("potion", (Item)new ItemPotion(new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78038_k)));
        ItemGlassBottle item1 = new ItemGlassBottle(new Properties().func_200916_a(ItemGroup.field_78038_k));
        Item.func_195936_a("glass_bottle", (Item)item1);
        Item.func_195936_a("spider_eye", (Item)new ItemFood(2, 0.8f, false, new Properties().func_200916_a(ItemGroup.field_78039_h)).func_185070_a(new PotionEffect(MobEffects.field_76436_u, 100, 0), 1.0f));
        Item.func_195936_a("fermented_spider_eye", new Item(new Properties().func_200916_a(ItemGroup.field_78038_k)));
        Item.func_195936_a("blaze_powder", new Item(new Properties().func_200916_a(ItemGroup.field_78038_k)));
        Item.func_195936_a("magma_cream", new Item(new Properties().func_200916_a(ItemGroup.field_78038_k)));
        Item.func_200879_a(Blocks.field_150382_bo, ItemGroup.field_78038_k);
        Item.func_200879_a(Blocks.field_150383_bp, ItemGroup.field_78038_k);
        Item.func_195936_a("ender_eye", (Item)new ItemEnderEye(new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("glistering_melon_slice", new Item(new Properties().func_200916_a(ItemGroup.field_78038_k)));
        Item.func_195936_a("bat_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200791_e, 4996656, 986895, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("blaze_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200792_f, 16167425, 16775294, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("cave_spider_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200794_h, 803406, 11013646, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("chicken_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200795_i, 0xA1A1A1, 0xFF0000, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("cod_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_203780_j, 12691306, 15058059, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("cow_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200796_j, 4470310, 0xA1A1A1, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("creeper_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200797_k, 894731, 0, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("dolphin_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_205137_n, 2243405, 0xF9F9F9, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("donkey_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200798_l, 5457209, 8811878, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("drowned_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_204724_o, 9433559, 7969893, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("elder_guardian_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200800_n, 13552826, 7632531, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("enderman_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200803_q, 0x161616, 0, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("endermite_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200804_r, 0x161616, 0x6E6E6E, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("evoker_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200806_t, 0x959B9B, 1973274, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("ghast_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200811_y, 0xF9F9F9, 0xBCBCBC, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("guardian_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200761_A, 5931634, 15826224, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("horse_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200762_B, 12623485, 0xEEE500, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("husk_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200763_C, 7958625, 15125652, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("llama_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200769_I, 12623485, 10051392, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("magma_cube_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200771_K, 0x340000, 0xFCFC00, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("mooshroom_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200780_T, 10489616, 0xB7B7B7, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("mule_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200779_S, 1769984, 5321501, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("ocelot_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200781_U, 15720061, 5653556, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("parrot_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200783_W, 894731, 0xFF0000, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("phantom_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_203097_aH, 4411786, 0x88FF00, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("pig_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200784_X, 15771042, 14377823, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("polar_bear_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200786_Z, 0xF2F2F2, 0x959590, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("pufferfish_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_203779_Z, 16167425, 3654642, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("rabbit_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200736_ab, 10051392, 7555121, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("salmon_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_203778_ae, 10489616, 951412, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("sheep_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200737_ac, 0xE7E7E7, 0xFFB5B5, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("shulker_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200738_ad, 9725844, 5060690, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("silverfish_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200740_af, 0x6E6E6E, 0x303030, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("skeleton_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200741_ag, 0xC1C1C1, 0x494949, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("skeleton_horse_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200742_ah, 6842447, 15066584, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("slime_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200743_ai, 5349438, 8306542, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("spider_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200748_an, 3419431, 11013646, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("squid_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200749_ao, 2243405, 7375001, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("stray_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200750_ap, 0x617677, 0xDDEAEA, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("tropical_fish_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_204262_at, 15690005, 0xFFF9EF, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("turtle_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_203099_aq, 0xE7E7E7, 44975, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("vex_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200755_au, 8032420, 15265265, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("villager_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200756_av, 5651507, 12422002, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("vindicator_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200758_ax, 0x959B9B, 2580065, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("witch_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200759_ay, 0x340000, 5349438, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("wither_skeleton_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200722_aA, 0x141414, 0x474D4D, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("wolf_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200724_aC, 0xD7D3D3, 13545366, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("zombie_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200725_aD, 44975, 7969893, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("zombie_horse_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200726_aE, 3232308, 9945732, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("zombie_pigman_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200785_Y, 15373203, 5009705, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("zombie_villager_spawn_egg", (Item)new ItemSpawnEgg(EntityType.field_200727_aF, 5651507, 7969893, new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("experience_bottle", (Item)new ItemExpBottle(new Properties().func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.UNCOMMON)));
        Item.func_195936_a("fire_charge", (Item)new ItemFireCharge(new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("writable_book", (Item)new ItemWritableBook(new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("written_book", (Item)new ItemWrittenBook(new Properties().func_200917_a(16)));
        Item.func_195936_a("emerald", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("item_frame", (Item)new ItemItemFrame(new Properties().func_200916_a(ItemGroup.field_78031_c)));
        Item.func_200879_a(Blocks.field_150457_bL, ItemGroup.field_78031_c);
        Item.func_195936_a("carrot", (Item)((Object)new ItemSeedFood(3, 0.6f, Blocks.field_150459_bM, new Properties().func_200916_a(ItemGroup.field_78039_h))));
        Item.func_195936_a("potato", (Item)((Object)new ItemSeedFood(1, 0.3f, Blocks.field_150469_bN, new Properties().func_200916_a(ItemGroup.field_78039_h))));
        Item.func_195936_a("baked_potato", (Item)new ItemFood(5, 0.6f, false, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("poisonous_potato", (Item)new ItemFood(2, 0.3f, false, new Properties().func_200916_a(ItemGroup.field_78039_h)).func_185070_a(new PotionEffect(MobEffects.field_76436_u, 100, 0), 0.6f));
        Item.func_195936_a("map", (Item)new ItemEmptyMap(new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("golden_carrot", (Item)new ItemFood(6, 1.2f, false, new Properties().func_200916_a(ItemGroup.field_78038_k)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_196703_eM, Blocks.field_196701_eL, new Properties().func_200916_a(ItemGroup.field_78031_c).func_208103_a(EnumRarity.UNCOMMON)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_196705_eO, Blocks.field_196704_eN, new Properties().func_200916_a(ItemGroup.field_78031_c).func_208103_a(EnumRarity.UNCOMMON)));
        Item.func_200126_a((ItemBlock)new ItemSkull(Blocks.field_196710_eS, Blocks.field_196709_eR, new Properties().func_200916_a(ItemGroup.field_78031_c).func_208103_a(EnumRarity.UNCOMMON)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_196708_eQ, Blocks.field_196707_eP, new Properties().func_200916_a(ItemGroup.field_78031_c).func_208103_a(EnumRarity.UNCOMMON)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_196714_eU, Blocks.field_196712_eT, new Properties().func_200916_a(ItemGroup.field_78031_c).func_208103_a(EnumRarity.UNCOMMON)));
        Item.func_200126_a((ItemBlock)new ItemWallOrFloor(Blocks.field_196716_eW, Blocks.field_196715_eV, new Properties().func_200916_a(ItemGroup.field_78031_c).func_208103_a(EnumRarity.UNCOMMON)));
        Item.func_195936_a("carrot_on_a_stick", (Item)new ItemCarrotOnAStick(new Properties().func_200918_c(25).func_200916_a(ItemGroup.field_78029_e)));
        Item.func_195936_a("nether_star", (Item)new ItemSimpleFoiled(new Properties().func_200916_a(ItemGroup.field_78035_l).func_208103_a(EnumRarity.UNCOMMON)));
        Item.func_195936_a("pumpkin_pie", (Item)new ItemFood(8, 0.3f, false, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("firework_rocket", (Item)new ItemFireworkRocket(new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("firework_star", (Item)new ItemFireworkStar(new Properties().func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("enchanted_book", (Item)new ItemEnchantedBook(new Properties().func_200917_a(1).func_208103_a(EnumRarity.UNCOMMON)));
        Item.func_195936_a("nether_brick", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("quartz", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("tnt_minecart", new ItemMinecart(EntityMinecart.Type.TNT, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e)));
        Item.func_195936_a("hopper_minecart", new ItemMinecart(EntityMinecart.Type.HOPPER, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e)));
        Item.func_195936_a("prismarine_shard", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("prismarine_crystals", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("rabbit", (Item)new ItemFood(3, 0.3f, true, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("cooked_rabbit", (Item)new ItemFood(5, 0.6f, true, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("rabbit_stew", (Item)new ItemSoup(10, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("rabbit_foot", new Item(new Properties().func_200916_a(ItemGroup.field_78038_k)));
        Item.func_195936_a("rabbit_hide", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("armor_stand", (Item)new ItemArmorStand(new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("iron_horse_armor", new Item(new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("golden_horse_armor", new Item(new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("diamond_horse_armor", new Item(new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        Item.func_195936_a("lead", (Item)new ItemLead(new Properties().func_200916_a(ItemGroup.field_78040_i)));
        Item.func_195936_a("name_tag", (Item)new ItemNameTag(new Properties().func_200916_a(ItemGroup.field_78040_i)));
        Item.func_195936_a("command_block_minecart", new ItemMinecart(EntityMinecart.Type.COMMAND_BLOCK, new Properties().func_200917_a(1)));
        Item.func_195936_a("mutton", (Item)new ItemFood(2, 0.3f, true, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("cooked_mutton", (Item)new ItemFood(6, 0.8f, true, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("white_banner", (Item)new ItemBanner(Blocks.field_196784_gT, Blocks.field_196843_hj, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("orange_banner", (Item)new ItemBanner(Blocks.field_196786_gU, Blocks.field_196845_hk, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("magenta_banner", (Item)new ItemBanner(Blocks.field_196788_gV, Blocks.field_196847_hl, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("light_blue_banner", (Item)new ItemBanner(Blocks.field_196790_gW, Blocks.field_196849_hm, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("yellow_banner", (Item)new ItemBanner(Blocks.field_196792_gX, Blocks.field_196851_hn, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("lime_banner", (Item)new ItemBanner(Blocks.field_196794_gY, Blocks.field_196853_ho, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("pink_banner", (Item)new ItemBanner(Blocks.field_196796_gZ, Blocks.field_196855_hp, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("gray_banner", (Item)new ItemBanner(Blocks.field_196826_ha, Blocks.field_196857_hq, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("light_gray_banner", (Item)new ItemBanner(Blocks.field_196827_hb, Blocks.field_196859_hr, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("cyan_banner", (Item)new ItemBanner(Blocks.field_196829_hc, Blocks.field_196861_hs, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("purple_banner", (Item)new ItemBanner(Blocks.field_196831_hd, Blocks.field_196863_ht, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("blue_banner", (Item)new ItemBanner(Blocks.field_196833_he, Blocks.field_196865_hu, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("brown_banner", (Item)new ItemBanner(Blocks.field_196835_hf, Blocks.field_196867_hv, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("green_banner", (Item)new ItemBanner(Blocks.field_196837_hg, Blocks.field_196869_hw, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("red_banner", (Item)new ItemBanner(Blocks.field_196839_hh, Blocks.field_196871_hx, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("black_banner", (Item)new ItemBanner(Blocks.field_196841_hi, Blocks.field_196873_hy, new Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        Item.func_195936_a("end_crystal", (Item)new ItemEndCrystal(new Properties().func_200916_a(ItemGroup.field_78031_c).func_208103_a(EnumRarity.RARE)));
        Item.func_195936_a("chorus_fruit", (Item)new ItemChorusFruit(4, 0.3f, new Properties().func_200916_a(ItemGroup.field_78035_l)).func_77848_i());
        Item.func_195936_a("popped_chorus_fruit", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("beetroot", (Item)new ItemFood(1, 0.6f, false, new Properties().func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("beetroot_seeds", new ItemSeeds(Blocks.field_185773_cZ, new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("beetroot_soup", (Item)new ItemSoup(6, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78039_h)));
        Item.func_195936_a("dragon_breath", new Item(new Properties().func_200919_a((Item)item1).func_200916_a(ItemGroup.field_78038_k).func_208103_a(EnumRarity.UNCOMMON)));
        Item.func_195936_a("splash_potion", (Item)new ItemSplashPotion(new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78038_k)));
        Item.func_195936_a("spectral_arrow", (Item)new ItemSpectralArrow(new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("tipped_arrow", (Item)new ItemTippedArrow(new Properties().func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("lingering_potion", (Item)new ItemLingeringPotion(new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78038_k)));
        Item.func_195936_a("shield", (Item)new ItemShield(new Properties().func_200918_c(336).func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("elytra", (Item)new ItemElytra(new Properties().func_200918_c(432).func_200916_a(ItemGroup.field_78029_e).func_208103_a(EnumRarity.UNCOMMON)));
        Item.func_195936_a("spruce_boat", (Item)new ItemBoat(EntityBoat.Type.SPRUCE, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e)));
        Item.func_195936_a("birch_boat", (Item)new ItemBoat(EntityBoat.Type.BIRCH, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e)));
        Item.func_195936_a("jungle_boat", (Item)new ItemBoat(EntityBoat.Type.JUNGLE, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e)));
        Item.func_195936_a("acacia_boat", (Item)new ItemBoat(EntityBoat.Type.ACACIA, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e)));
        Item.func_195936_a("dark_oak_boat", (Item)new ItemBoat(EntityBoat.Type.DARK_OAK, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e)));
        Item.func_195936_a("totem_of_undying", new Item(new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78037_j).func_208103_a(EnumRarity.UNCOMMON)));
        Item.func_195936_a("shulker_shell", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("iron_nugget", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("knowledge_book", (Item)new ItemKnowledgeBook(new Properties().func_200917_a(1)));
        Item.func_195936_a("debug_stick", (Item)new ItemDebugStick(new Properties().func_200917_a(1)));
        Item.func_195936_a("music_disc_13", (Item)new ItemRecord(1, SoundEvents.field_187828_ep, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_195936_a("music_disc_cat", (Item)new ItemRecord(2, SoundEvents.field_187832_er, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_195936_a("music_disc_blocks", (Item)new ItemRecord(3, SoundEvents.field_187830_eq, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_195936_a("music_disc_chirp", (Item)new ItemRecord(4, SoundEvents.field_187834_es, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_195936_a("music_disc_far", (Item)new ItemRecord(5, SoundEvents.field_187836_et, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_195936_a("music_disc_mall", (Item)new ItemRecord(6, SoundEvents.field_187838_eu, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_195936_a("music_disc_mellohi", (Item)new ItemRecord(7, SoundEvents.field_187840_ev, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_195936_a("music_disc_stal", (Item)new ItemRecord(8, SoundEvents.field_187842_ew, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_195936_a("music_disc_strad", (Item)new ItemRecord(9, SoundEvents.field_187844_ex, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_195936_a("music_disc_ward", (Item)new ItemRecord(10, SoundEvents.field_187848_ez, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_195936_a("music_disc_11", (Item)new ItemRecord(11, SoundEvents.field_187826_eo, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_195936_a("music_disc_wait", (Item)new ItemRecord(12, SoundEvents.field_187846_ey, new Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_208103_a(EnumRarity.RARE)));
        Item.func_195936_a("trident", (Item)new ItemTrident(new Properties().func_200918_c(250).func_200916_a(ItemGroup.field_78037_j)));
        Item.func_195936_a("phantom_membrane", new Item(new Properties().func_200916_a(ItemGroup.field_78038_k)));
        Item.func_195936_a("nautilus_shell", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l)));
        Item.func_195936_a("heart_of_the_sea", new Item(new Properties().func_200916_a(ItemGroup.field_78035_l).func_208103_a(EnumRarity.UNCOMMON)));
    }

    private static void func_179216_c(Block blockIn) {
        Item.func_200126_a(new ItemBlock(blockIn, new Properties()));
    }

    private static void func_200879_a(Block blockIn, ItemGroup group) {
        Item.func_200126_a(new ItemBlock(blockIn, new Properties().func_200916_a(group)));
    }

    private static void func_200126_a(ItemBlock itemBlockIn) {
        Item.func_179214_a(itemBlockIn.func_179223_d(), itemBlockIn);
    }

    protected static void func_179214_a(Block blockIn, Item itemIn) {
        Item.func_195940_a(IRegistry.field_212618_g.func_177774_c(blockIn), itemIn);
    }

    private static void func_195936_a(String id, Item itemIn) {
        Item.func_195940_a(new ResourceLocation(id), itemIn);
    }

    private static void func_195940_a(ResourceLocation resourceLocationIn, Item itemIn) {
        if (itemIn instanceof ItemBlock) {
            ((ItemBlock)itemIn).func_195946_a(field_179220_a, itemIn);
        }
        IRegistry.field_212630_s.func_82595_a(resourceLocationIn, itemIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_190903_i() {
        return new ItemStack(this);
    }

    public boolean func_206844_a(Tag<Item> tagIn) {
        return tagIn.func_199685_a_(this);
    }

    public static class Properties {
        private int field_200920_a = 64;
        private int field_200921_b;
        private Item field_200922_c;
        private ItemGroup field_200923_d;
        private EnumRarity field_208104_e = EnumRarity.COMMON;
        private boolean canRepair = true;
        private Map<ToolType, Integer> toolClasses = Maps.newHashMap();
        private Supplier<Callable<TileEntityItemStackRenderer>> teisr;

        public Properties func_200917_a(int maxStackSizeIn) {
            if (this.field_200921_b > 0) {
                throw new RuntimeException("Unable to have damage AND stack.");
            }
            this.field_200920_a = maxStackSizeIn;
            return this;
        }

        public Properties func_200915_b(int maxDamageIn) {
            return this.field_200921_b == 0 ? this.func_200918_c(maxDamageIn) : this;
        }

        private Properties func_200918_c(int maxDamageIn) {
            this.field_200921_b = maxDamageIn;
            this.field_200920_a = 1;
            return this;
        }

        public Properties func_200919_a(Item containerItemIn) {
            this.field_200922_c = containerItemIn;
            return this;
        }

        public Properties func_200916_a(ItemGroup groupIn) {
            this.field_200923_d = groupIn;
            return this;
        }

        public Properties func_208103_a(EnumRarity rarityIn) {
            this.field_208104_e = rarityIn;
            return this;
        }

        public Properties setNoRepair() {
            this.canRepair = false;
            return this;
        }

        public Properties addToolType(ToolType type, int level) {
            this.toolClasses.put(type, level);
            return this;
        }

        public Properties setTEISR(Supplier<Callable<TileEntityItemStackRenderer>> teisr) {
            this.teisr = teisr;
            return this;
        }
    }
}

