/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.init.MobEffects;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityShulkerBullet
extends Entity {
    private EntityLivingBase field_184570_a;
    private Entity field_184571_b;
    @Nullable
    private EnumFacing field_184573_c;
    private int field_184575_d;
    private double field_184577_e;
    private double field_184578_f;
    private double field_184579_g;
    @Nullable
    private UUID field_184580_h;
    private BlockPos field_184572_as;
    @Nullable
    private UUID field_184574_at;
    private BlockPos field_184576_au;

    public EntityShulkerBullet(World worldIn) {
        super(EntityType.field_200739_ae, worldIn);
        this.func_70105_a(0.3125f, 0.3125f);
        this.field_70145_X = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityShulkerBullet(World worldIn, double x, double y, double z, double motionXIn, double motionYIn, double motionZIn) {
        this(worldIn);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.field_70159_w = motionXIn;
        this.field_70181_x = motionYIn;
        this.field_70179_y = motionZIn;
    }

    public EntityShulkerBullet(World worldIn, EntityLivingBase ownerIn, Entity targetIn, EnumFacing.Axis p_i46772_4_) {
        this(worldIn);
        this.field_184570_a = ownerIn;
        BlockPos blockpos = new BlockPos((Entity)ownerIn);
        double d0 = (double)blockpos.func_177958_n() + 0.5;
        double d1 = (double)blockpos.func_177956_o() + 0.5;
        double d2 = (double)blockpos.func_177952_p() + 0.5;
        this.func_70012_b(d0, d1, d2, this.field_70177_z, this.field_70125_A);
        this.field_184571_b = targetIn;
        this.field_184573_c = EnumFacing.UP;
        this.func_184569_a(p_i46772_4_);
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        if (this.field_184570_a != null) {
            BlockPos blockpos = new BlockPos((Entity)this.field_184570_a);
            NBTTagCompound nbttagcompound = NBTUtil.func_186862_a((UUID)this.field_184570_a.func_110124_au());
            nbttagcompound.func_74768_a("X", blockpos.func_177958_n());
            nbttagcompound.func_74768_a("Y", blockpos.func_177956_o());
            nbttagcompound.func_74768_a("Z", blockpos.func_177952_p());
            compound.func_74782_a("Owner", nbttagcompound);
        }
        if (this.field_184571_b != null) {
            BlockPos blockpos1 = new BlockPos(this.field_184571_b);
            NBTTagCompound nbttagcompound1 = NBTUtil.func_186862_a((UUID)this.field_184571_b.func_110124_au());
            nbttagcompound1.func_74768_a("X", blockpos1.func_177958_n());
            nbttagcompound1.func_74768_a("Y", blockpos1.func_177956_o());
            nbttagcompound1.func_74768_a("Z", blockpos1.func_177952_p());
            compound.func_74782_a("Target", nbttagcompound1);
        }
        if (this.field_184573_c != null) {
            compound.func_74768_a("Dir", this.field_184573_c.func_176745_a());
        }
        compound.func_74768_a("Steps", this.field_184575_d);
        compound.func_74780_a("TXD", this.field_184577_e);
        compound.func_74780_a("TYD", this.field_184578_f);
        compound.func_74780_a("TZD", this.field_184579_g);
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        this.field_184575_d = compound.func_74762_e("Steps");
        this.field_184577_e = compound.func_74769_h("TXD");
        this.field_184578_f = compound.func_74769_h("TYD");
        this.field_184579_g = compound.func_74769_h("TZD");
        if (compound.func_150297_b("Dir", 99)) {
            this.field_184573_c = EnumFacing.func_82600_a(compound.func_74762_e("Dir"));
        }
        if (compound.func_150297_b("Owner", 10)) {
            NBTTagCompound nbttagcompound = compound.func_74775_l("Owner");
            this.field_184580_h = NBTUtil.func_186860_b((NBTTagCompound)nbttagcompound);
            this.field_184572_as = new BlockPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Y"), nbttagcompound.func_74762_e("Z"));
        }
        if (compound.func_150297_b("Target", 10)) {
            NBTTagCompound nbttagcompound1 = compound.func_74775_l("Target");
            this.field_184574_at = NBTUtil.func_186860_b((NBTTagCompound)nbttagcompound1);
            this.field_184576_au = new BlockPos(nbttagcompound1.func_74762_e("X"), nbttagcompound1.func_74762_e("Y"), nbttagcompound1.func_74762_e("Z"));
        }
    }

    @Override
    protected void func_70088_a() {
    }

    private void func_184568_a(@Nullable EnumFacing directionIn) {
        this.field_184573_c = directionIn;
    }

    private void func_184569_a(@Nullable EnumFacing.Axis p_184569_1_) {
        BlockPos blockpos;
        double d0 = 0.5;
        if (this.field_184571_b == null) {
            blockpos = new BlockPos((Entity)this).func_177977_b();
        } else {
            d0 = (double)this.field_184571_b.field_70131_O * 0.5;
            blockpos = new BlockPos(this.field_184571_b.field_70165_t, this.field_184571_b.field_70163_u + d0, this.field_184571_b.field_70161_v);
        }
        double d1 = (double)blockpos.func_177958_n() + 0.5;
        double d2 = (double)blockpos.func_177956_o() + d0;
        double d3 = (double)blockpos.func_177952_p() + 0.5;
        EnumFacing enumfacing = null;
        if (blockpos.func_177957_d(this.field_70165_t, this.field_70163_u, this.field_70161_v) >= 4.0) {
            BlockPos blockpos1 = new BlockPos((Entity)this);
            ArrayList list = Lists.newArrayList();
            if (p_184569_1_ != EnumFacing.Axis.X) {
                if (blockpos1.func_177958_n() < blockpos.func_177958_n() && this.field_70170_p.func_175623_d(blockpos1.func_177974_f())) {
                    list.add(EnumFacing.EAST);
                } else if (blockpos1.func_177958_n() > blockpos.func_177958_n() && this.field_70170_p.func_175623_d(blockpos1.func_177976_e())) {
                    list.add(EnumFacing.WEST);
                }
            }
            if (p_184569_1_ != EnumFacing.Axis.Y) {
                if (blockpos1.func_177956_o() < blockpos.func_177956_o() && this.field_70170_p.func_175623_d(blockpos1.func_177984_a())) {
                    list.add(EnumFacing.UP);
                } else if (blockpos1.func_177956_o() > blockpos.func_177956_o() && this.field_70170_p.func_175623_d(blockpos1.func_177977_b())) {
                    list.add(EnumFacing.DOWN);
                }
            }
            if (p_184569_1_ != EnumFacing.Axis.Z) {
                if (blockpos1.func_177952_p() < blockpos.func_177952_p() && this.field_70170_p.func_175623_d(blockpos1.func_177968_d())) {
                    list.add(EnumFacing.SOUTH);
                } else if (blockpos1.func_177952_p() > blockpos.func_177952_p() && this.field_70170_p.func_175623_d(blockpos1.func_177978_c())) {
                    list.add(EnumFacing.NORTH);
                }
            }
            enumfacing = EnumFacing.func_176741_a(this.field_70146_Z);
            if (list.isEmpty()) {
                for (int i = 5; !this.field_70170_p.func_175623_d(blockpos1.func_177972_a(enumfacing)) && i > 0; --i) {
                    enumfacing = EnumFacing.func_176741_a(this.field_70146_Z);
                }
            } else {
                enumfacing = (EnumFacing)((Object)list.get(this.field_70146_Z.nextInt(list.size())));
            }
            d1 = this.field_70165_t + (double)enumfacing.func_82601_c();
            d2 = this.field_70163_u + (double)enumfacing.func_96559_d();
            d3 = this.field_70161_v + (double)enumfacing.func_82599_e();
        }
        this.func_184568_a(enumfacing);
        double d6 = d1 - this.field_70165_t;
        double d7 = d2 - this.field_70163_u;
        double d4 = d3 - this.field_70161_v;
        double d5 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7 + d4 * d4));
        if (d5 == 0.0) {
            this.field_184577_e = 0.0;
            this.field_184578_f = 0.0;
            this.field_184579_g = 0.0;
        } else {
            this.field_184577_e = d6 / d5 * 0.15;
            this.field_184578_f = d7 / d5 * 0.15;
            this.field_184579_g = d4 / d5 * 0.15;
        }
        this.field_70160_al = true;
        this.field_184575_d = 10 + this.field_70146_Z.nextInt(5) * 10;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        } else {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K) {
                RayTraceResult raytraceresult;
                if (this.field_184571_b == null && this.field_184574_at != null) {
                    for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_184576_au.func_177982_a(-2, -2, -2), this.field_184576_au.func_177982_a(2, 2, 2)))) {
                        if (!entitylivingbase.func_110124_au().equals(this.field_184574_at)) continue;
                        this.field_184571_b = entitylivingbase;
                        break;
                    }
                    this.field_184574_at = null;
                }
                if (this.field_184570_a == null && this.field_184580_h != null) {
                    for (EntityLivingBase entitylivingbase1 : this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_184572_as.func_177982_a(-2, -2, -2), this.field_184572_as.func_177982_a(2, 2, 2)))) {
                        if (!entitylivingbase1.func_110124_au().equals(this.field_184580_h)) continue;
                        this.field_184570_a = entitylivingbase1;
                        break;
                    }
                    this.field_184580_h = null;
                }
                if (this.field_184571_b == null || !this.field_184571_b.func_70089_S() || this.field_184571_b instanceof EntityPlayer && ((EntityPlayer)this.field_184571_b).func_175149_v()) {
                    if (!this.func_189652_ae()) {
                        this.field_70181_x -= 0.04;
                    }
                } else {
                    this.field_184577_e = MathHelper.func_151237_a((double)(this.field_184577_e * 1.025), (double)-1.0, (double)1.0);
                    this.field_184578_f = MathHelper.func_151237_a((double)(this.field_184578_f * 1.025), (double)-1.0, (double)1.0);
                    this.field_184579_g = MathHelper.func_151237_a((double)(this.field_184579_g * 1.025), (double)-1.0, (double)1.0);
                    this.field_70159_w += (this.field_184577_e - this.field_70159_w) * 0.2;
                    this.field_70181_x += (this.field_184578_f - this.field_70181_x) * 0.2;
                    this.field_70179_y += (this.field_184579_g - this.field_70179_y) * 0.2;
                }
                if ((raytraceresult = ProjectileHelper.func_188802_a((Entity)this, (boolean)true, (boolean)false, (Entity)this.field_184570_a)) != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                    this.func_184567_a(raytraceresult);
                }
            }
            this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            ProjectileHelper.func_188803_a((Entity)this, (float)0.5f);
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_195594_a((IParticleData)Particles.field_197624_q, this.field_70165_t - this.field_70159_w, this.field_70163_u - this.field_70181_x + 0.15, this.field_70161_v - this.field_70179_y, 0.0, 0.0, 0.0);
            } else if (this.field_184571_b != null && !this.field_184571_b.field_70128_L) {
                if (this.field_184575_d > 0) {
                    --this.field_184575_d;
                    if (this.field_184575_d == 0) {
                        this.func_184569_a(this.field_184573_c == null ? null : this.field_184573_c.func_176740_k());
                    }
                }
                if (this.field_184573_c != null) {
                    BlockPos blockpos = new BlockPos((Entity)this);
                    EnumFacing.Axis enumfacing$axis = this.field_184573_c.func_176740_k();
                    if (this.field_70170_p.func_195595_w(blockpos.func_177972_a(this.field_184573_c))) {
                        this.func_184569_a(enumfacing$axis);
                    } else {
                        BlockPos blockpos1 = new BlockPos(this.field_184571_b);
                        if (enumfacing$axis == EnumFacing.Axis.X && blockpos.func_177958_n() == blockpos1.func_177958_n() || enumfacing$axis == EnumFacing.Axis.Z && blockpos.func_177952_p() == blockpos1.func_177952_p() || enumfacing$axis == EnumFacing.Axis.Y && blockpos.func_177956_o() == blockpos1.func_177956_o()) {
                            this.func_184569_a(enumfacing$axis);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean func_70027_ad() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 16384.0;
    }

    @Override
    public float func_70013_c() {
        return 1.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    protected void func_184567_a(RayTraceResult result) {
        if (result.field_72308_g == null) {
            ((WorldServer)this.field_70170_p).func_195598_a(Particles.field_197627_t, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2, 0.2, 0.2, 0.2, 0.0);
            this.func_184185_a(SoundEvents.field_187775_eP, 1.0f, 1.0f);
        } else {
            boolean flag = result.field_72308_g.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.field_184570_a).func_76349_b(), 4.0f);
            if (flag) {
                this.func_174815_a(this.field_184570_a, result.field_72308_g);
                if (result.field_72308_g instanceof EntityLivingBase) {
                    ((EntityLivingBase)result.field_72308_g).func_195064_c(new PotionEffect(MobEffects.field_188424_y, 200));
                }
            }
        }
        this.func_70106_y();
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a(SoundEvents.field_187777_eQ, 1.0f, 1.0f);
            ((WorldServer)this.field_70170_p).func_195598_a(Particles.field_197614_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 15, 0.2, 0.2, 0.2, 0.0);
            this.func_70106_y();
        }
        return true;
    }
}

