/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBubbleColumn;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtil;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatList;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;

public abstract class EntityPlayer
extends EntityLivingBase {
    public static final String PERSISTED_NBT_TAG = "PlayerPersisted";
    protected HashMap<ResourceLocation, BlockPos> spawnPosMap = new HashMap();
    protected HashMap<ResourceLocation, Boolean> spawnForcedMap = new HashMap();
    public static final IAttribute REACH_DISTANCE = new RangedAttribute(null, "generic.reachDistance", 5.0, 0.0, 1024.0).func_111112_a(true);
    private static final DataParameter<Float> field_184829_a = EntityDataManager.func_187226_a(EntityPlayer.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184830_b = EntityDataManager.func_187226_a(EntityPlayer.class, DataSerializers.field_187192_b);
    protected static final DataParameter<Byte> field_184827_bp = EntityDataManager.func_187226_a(EntityPlayer.class, DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> field_184828_bq = EntityDataManager.func_187226_a(EntityPlayer.class, DataSerializers.field_187191_a);
    protected static final DataParameter<NBTTagCompound> field_192032_bt = EntityDataManager.func_187226_a(EntityPlayer.class, DataSerializers.field_192734_n);
    protected static final DataParameter<NBTTagCompound> field_192033_bu = EntityDataManager.func_187226_a(EntityPlayer.class, DataSerializers.field_192734_n);
    public InventoryPlayer field_71071_by = new InventoryPlayer(this);
    protected InventoryEnderChest field_71078_a = new InventoryEnderChest();
    public Container field_71069_bz;
    public Container field_71070_bA;
    protected FoodStats field_71100_bB = new FoodStats();
    protected int field_71101_bC;
    public float field_71107_bF;
    public float field_71109_bG;
    public int field_71090_bL;
    public double field_71091_bM;
    public double field_71096_bN;
    public double field_71097_bO;
    public double field_71094_bP;
    public double field_71095_bQ;
    public double field_71085_bR;
    protected boolean field_71083_bS;
    public BlockPos field_71081_bT;
    private int field_71076_b;
    public float field_71079_bU;
    @OnlyIn(value=Dist.CLIENT)
    public float field_71082_cx;
    public float field_71089_bV;
    private boolean field_203042_d;
    protected boolean field_204230_bP;
    protected BlockPos field_71077_c;
    protected boolean field_82248_d;
    public PlayerCapabilities field_71075_bZ = new PlayerCapabilities();
    public int field_71068_ca;
    public int field_71067_cb;
    public float field_71106_cc;
    protected int field_175152_f;
    protected float field_71102_ce = 0.02f;
    private int field_82249_h;
    private final GameProfile field_146106_i;
    @OnlyIn(value=Dist.CLIENT)
    private boolean field_175153_bG;
    private ItemStack field_184831_bT = ItemStack.field_190927_a;
    private final CooldownTracker field_184832_bU = this.func_184815_l();
    @Nullable
    public EntityFishHook field_71104_cf;
    private float eyeHeight = this.getDefaultEyeHeight();
    private DimensionType spawnDimension = DimensionType.OVERWORLD;
    private final Collection<ITextComponent> prefixes = new LinkedList<ITextComponent>();
    private final Collection<ITextComponent> suffixes = new LinkedList<ITextComponent>();
    private final LazyOptional<IItemHandler> playerMainHandler = LazyOptional.of(() -> new PlayerMainInvWrapper(this.field_71071_by));
    private final LazyOptional<IItemHandler> playerEquipmentHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{new PlayerArmorInvWrapper(this.field_71071_by), new PlayerOffhandInvWrapper(this.field_71071_by)}));
    private final LazyOptional<IItemHandler> playerJoinedHandler = LazyOptional.of(() -> new PlayerInvWrapper(this.field_71071_by));

    public EntityPlayer(World worldIn, GameProfile gameProfileIn) {
        super(EntityType.field_200729_aH, worldIn);
        this.func_184221_a(EntityPlayer.func_146094_a(gameProfileIn));
        this.field_146106_i = gameProfileIn;
        this.field_71070_bA = this.field_71069_bz = new ContainerPlayer(this.field_71071_by, !worldIn.field_72995_K, this);
        BlockPos blockpos = worldIn.func_175694_M();
        this.func_70012_b((double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o() + 1, (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
        this.field_70741_aB = 180.0f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.1f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188792_h);
        this.func_110140_aT().func_111150_b(REACH_DISTANCE);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184829_a, Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(field_184830_b, 0);
        this.field_70180_af.func_187214_a(field_184827_bp, (byte)0);
        this.field_70180_af.func_187214_a(field_184828_bq, (byte)1);
        this.field_70180_af.func_187214_a(field_192032_bt, new NBTTagCompound());
        this.field_70180_af.func_187214_a(field_192033_bu, new NBTTagCompound());
    }

    @Override
    public void func_70071_h_() {
        BasicEventHooks.onPlayerPreTick((EntityPlayer)this);
        this.field_70145_X = this.func_175149_v();
        if (this.func_175149_v()) {
            this.field_70122_E = false;
        }
        if (this.field_71090_bL > 0) {
            --this.field_71090_bL;
        }
        if (this.func_70608_bn()) {
            ++this.field_71076_b;
            if (this.field_71076_b > 100) {
                this.field_71076_b = 100;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (!this.func_175143_p()) {
                    this.func_70999_a(true, true, false);
                } else if (!ForgeEventFactory.fireSleepingTimeCheck((EntityPlayer)this, (BlockPos)this.field_71081_bT)) {
                    this.func_70999_a(false, true, true);
                }
            }
        } else if (this.field_71076_b > 0) {
            ++this.field_71076_b;
            if (this.field_71076_b >= 110) {
                this.field_71076_b = 0;
            }
        }
        this.func_203040_o();
        this.func_204229_de();
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_71070_bA != null && !this.field_71070_bA.func_75145_c(this)) {
            this.func_71053_j();
            this.field_71070_bA = this.field_71069_bz;
        }
        if (this.func_70027_ad() && this.field_71075_bZ.field_75102_a) {
            this.func_70066_B();
        }
        this.func_184820_o();
        if (!this.field_70170_p.field_72995_K) {
            this.field_71100_bB.func_75118_a(this);
            this.func_195066_a(StatList.field_188097_g);
            if (this.func_70089_S()) {
                this.func_195066_a(StatList.field_188098_h);
            }
            if (this.func_70093_af()) {
                this.func_195066_a(StatList.field_188099_i);
            }
            if (!this.func_70608_bn()) {
                this.func_195066_a(StatList.field_203284_n);
            }
        }
        int i = 29999999;
        double d0 = MathHelper.func_151237_a((double)this.field_70165_t, (double)-2.9999999E7, (double)2.9999999E7);
        double d1 = MathHelper.func_151237_a((double)this.field_70161_v, (double)-2.9999999E7, (double)2.9999999E7);
        if (d0 != this.field_70165_t || d1 != this.field_70161_v) {
            this.func_70107_b(d0, this.field_70163_u, d1);
        }
        ++this.field_184617_aD;
        ItemStack itemstack = this.func_184614_ca();
        if (!ItemStack.func_77989_b(this.field_184831_bT, itemstack)) {
            if (!ItemStack.func_185132_d(this.field_184831_bT, itemstack)) {
                this.func_184821_cY();
            }
            this.field_184831_bT = itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack.func_77946_l();
        }
        this.func_203041_m();
        this.field_184832_bU.func_185144_a();
        this.func_184808_cD();
        BasicEventHooks.onPlayerPostTick((EntityPlayer)this);
    }

    protected boolean func_204229_de() {
        this.field_204230_bP = this.func_208600_a(FluidTags.field_206959_a);
        return this.field_204230_bP;
    }

    private void func_203041_m() {
        ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
        if (itemstack.func_77973_b() == Items.field_203179_ao && !this.func_208600_a(FluidTags.field_206959_a)) {
            this.func_195064_c(new PotionEffect(MobEffects.field_76427_o, 200, 0, false, false, true));
        }
    }

    protected CooldownTracker func_184815_l() {
        return new CooldownTracker();
    }

    private void func_203040_o() {
        IBlockState iblockstate = this.field_70170_p.func_203067_a(this.func_174813_aQ().func_72314_b(0.0, (double)-0.4f, 0.0).func_186664_h(0.001), Blocks.field_203203_C);
        if (iblockstate != null) {
            if (!(this.field_203042_d || this.field_70148_d || iblockstate.func_177230_c() != Blocks.field_203203_C || this.func_175149_v())) {
                boolean flag = (Boolean)iblockstate.func_177229_b((IProperty)BlockBubbleColumn.field_203160_a);
                if (flag) {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_203283_jd, this.func_184176_by(), 1.0f, 1.0f, false);
                } else {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_203252_T, this.func_184176_by(), 1.0f, 1.0f, false);
                }
            }
            this.field_203042_d = true;
        } else {
            this.field_203042_d = false;
        }
    }

    private void func_184820_o() {
        this.field_71091_bM = this.field_71094_bP;
        this.field_71096_bN = this.field_71095_bQ;
        this.field_71097_bO = this.field_71085_bR;
        double d0 = this.field_70165_t - this.field_71094_bP;
        double d1 = this.field_70163_u - this.field_71095_bQ;
        double d2 = this.field_70161_v - this.field_71085_bR;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.field_71091_bM = this.field_71094_bP = this.field_70165_t;
        }
        if (d2 > 10.0) {
            this.field_71097_bO = this.field_71085_bR = this.field_70161_v;
        }
        if (d1 > 10.0) {
            this.field_71096_bN = this.field_71095_bQ = this.field_70163_u;
        }
        if (d0 < -10.0) {
            this.field_71091_bM = this.field_71094_bP = this.field_70165_t;
        }
        if (d2 < -10.0) {
            this.field_71097_bO = this.field_71085_bR = this.field_70161_v;
        }
        if (d1 < -10.0) {
            this.field_71096_bN = this.field_71095_bQ = this.field_70163_u;
        }
        this.field_71094_bP += d0 * 0.25;
        this.field_71085_bR += d2 * 0.25;
        this.field_71095_bQ += d1 * 0.25;
    }

    protected void func_184808_cD() {
        float f1;
        float f;
        if (this.func_184613_cA()) {
            f = 0.6f;
            f1 = 0.6f;
        } else if (this.func_70608_bn()) {
            f = 0.2f;
            f1 = 0.2f;
        } else if (!this.func_203007_ba() && !this.func_204805_cN()) {
            if (this.func_70093_af()) {
                f = 0.6f;
                f1 = 1.65f;
            } else {
                f = 0.6f;
                f1 = 1.8f;
            }
        } else {
            f = 0.6f;
            f1 = 0.6f;
        }
        if (f != this.field_70130_N || f1 != this.field_70131_O) {
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            axisalignedbb = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)f, axisalignedbb.field_72338_b + (double)f1, axisalignedbb.field_72339_c + (double)f);
            if (this.field_70170_p.func_195586_b(null, axisalignedbb)) {
                this.func_70105_a(f, f1);
            }
        }
    }

    @Override
    public int func_82145_z() {
        return this.field_71075_bZ.field_75102_a ? 1 : 80;
    }

    @Override
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187808_ef;
    }

    @Override
    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187806_ee;
    }

    @Override
    protected SoundEvent func_204208_ah() {
        return SoundEvents.field_204328_gh;
    }

    @Override
    public int func_82147_ab() {
        return 10;
    }

    @Override
    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        this.field_70170_p.func_184148_a(this, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundIn, this.func_184176_by(), volume, pitch);
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.PLAYERS;
    }

    @Override
    protected int func_190531_bD() {
        return 20;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 9) {
            this.func_71036_o();
        } else if (id == 23) {
            this.field_175153_bG = false;
        } else if (id == 22) {
            this.field_175153_bG = true;
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    protected boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f || this.func_70608_bn();
    }

    public void func_71053_j() {
        this.field_71070_bA = this.field_71069_bz;
    }

    @Override
    public void func_70098_U() {
        if (!this.field_70170_p.field_72995_K && this.func_70093_af() && this.func_184218_aH()) {
            this.func_184210_p();
            this.func_70095_a(false);
        } else {
            double d0 = this.field_70165_t;
            double d1 = this.field_70163_u;
            double d2 = this.field_70161_v;
            float f = this.field_70177_z;
            float f1 = this.field_70125_A;
            super.func_70098_U();
            this.field_71107_bF = this.field_71109_bG;
            this.field_71109_bG = 0.0f;
            this.func_71015_k(this.field_70165_t - d0, this.field_70163_u - d1, this.field_70161_v - d2);
            if (this.func_184187_bx() instanceof EntityLivingBase && ((EntityLivingBase)this.func_184187_bx()).shouldRiderFaceForward(this)) {
                this.field_70125_A = f1;
                this.field_70177_z = f;
                this.field_70761_aq = ((EntityLivingBase)this.func_184187_bx()).field_70761_aq;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70065_x() {
        this.func_70105_a(0.6f, 1.8f);
        super.func_70065_x();
        this.func_70606_j(this.func_110138_aP());
        this.field_70725_aQ = 0;
    }

    @Override
    protected void func_70626_be() {
        super.func_70626_be();
        this.func_82168_bl();
        this.field_70759_as = this.field_70177_z;
    }

    @Override
    public void func_70636_d() {
        if (this.field_71101_bC > 0) {
            --this.field_71101_bC;
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.field_70170_p.func_82736_K().func_82766_b("naturalRegeneration")) {
            if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
            if (this.field_71100_bB.func_75121_c() && this.field_70173_aa % 10 == 0) {
                this.field_71100_bB.func_75114_a(this.field_71100_bB.func_75116_a() + 1);
            }
        }
        this.field_71071_by.func_70429_k();
        this.field_71107_bF = this.field_71109_bG;
        super.func_70636_d();
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (!this.field_70170_p.field_72995_K) {
            iattributeinstance.func_111128_a((double)this.field_71075_bZ.func_75094_b());
        }
        this.field_70747_aH = this.field_71102_ce;
        if (this.func_70051_ag()) {
            this.field_70747_aH = (float)((double)this.field_70747_aH + (double)this.field_71102_ce * 0.3);
        }
        this.func_70659_e((float)iattributeinstance.func_111126_e());
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        float f1 = (float)(Math.atan(-this.field_70181_x * (double)0.2f) * 15.0);
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.field_70122_E || this.func_110143_aJ() <= 0.0f || this.func_203007_ba()) {
            f = 0.0f;
        }
        if (this.field_70122_E || this.func_110143_aJ() <= 0.0f) {
            f1 = 0.0f;
        }
        this.field_71109_bG += (f - this.field_71109_bG) * 0.4f;
        this.field_70726_aT += (f1 - this.field_70726_aT) * 0.8f;
        if (this.func_110143_aJ() > 0.0f && !this.func_175149_v()) {
            AxisAlignedBB axisalignedbb = this.func_184218_aH() && !this.func_184187_bx().field_70128_L ? this.func_174813_aQ().func_111270_a(this.func_184187_bx().func_174813_aQ()).func_72314_b(1.0, 0.0, 1.0) : this.func_174813_aQ().func_72314_b(1.0, 0.5, 1.0);
            List list = this.field_70170_p.func_72839_b(this, axisalignedbb);
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)((Object)list.get(i));
                if (entity.field_70128_L) continue;
                this.func_71044_o(entity);
            }
        }
        this.func_192028_j(this.func_192023_dk());
        this.func_192028_j(this.func_192025_dl());
        if (!this.field_70170_p.field_72995_K && (this.field_70143_R > 0.5f || this.func_70090_H() || this.func_184218_aH()) || this.field_71075_bZ.field_75100_b) {
            this.func_192030_dh();
        }
    }

    private void func_192028_j(@Nullable NBTTagCompound p_192028_1_) {
        String s;
        if ((p_192028_1_ != null && !p_192028_1_.func_74764_b("Silent") || !p_192028_1_.func_74767_n("Silent")) && EntityType.func_200713_a(s = p_192028_1_.func_74779_i("id")) == EntityType.field_200783_W) {
            EntityParrot.func_192005_a(this.field_70170_p, this);
        }
    }

    private void func_71044_o(Entity entityIn) {
        entityIn.func_70100_b_(this);
    }

    public int func_71037_bA() {
        return this.field_70180_af.func_187225_a(field_184830_b);
    }

    public void func_85040_s(int scoreIn) {
        this.field_70180_af.func_187227_b(field_184830_b, scoreIn);
    }

    public void func_85039_t(int scoreIn) {
        int i = this.func_71037_bA();
        this.field_70180_af.func_187227_b(field_184830_b, i + scoreIn);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((EntityLivingBase)this, (DamageSource)cause)) {
            return;
        }
        super.func_70645_a(cause);
        this.func_70105_a(0.2f, 0.2f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70181_x = 0.1f;
        this.captureDrops(new ArrayList<EntityItem>());
        if ("Notch".equals(this.func_200200_C_().getString())) {
            this.func_146097_a(new ItemStack(Items.field_151034_e), true, false);
        }
        if (!this.field_70170_p.func_82736_K().func_82766_b("keepInventory") && !this.func_175149_v()) {
            this.func_190776_cN();
            this.field_71071_by.func_70436_m();
        }
        if (!this.field_70170_p.field_72995_K) {
            ForgeEventFactory.onPlayerDrops((EntityPlayer)this, (DamageSource)cause, this.captureDrops(null), (this.field_70718_bc > 0 ? 1 : 0) != 0);
        }
        if (cause != null) {
            this.field_70159_w = -MathHelper.func_76134_b((float)((this.field_70739_aP + this.field_70177_z) * ((float)Math.PI / 180))) * 0.1f;
            this.field_70179_y = -MathHelper.func_76126_a((float)((this.field_70739_aP + this.field_70177_z) * ((float)Math.PI / 180))) * 0.1f;
        } else {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
        this.func_195066_a(StatList.field_188069_A);
        this.func_175145_a(StatList.field_199092_j.func_199076_b((Object)StatList.field_188098_h));
        this.func_175145_a(StatList.field_199092_j.func_199076_b((Object)StatList.field_203284_n));
        this.func_70066_B();
        this.func_70052_a(0, false);
    }

    protected void func_190776_cN() {
        for (int i = 0; i < this.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = this.field_71071_by.func_70301_a(i);
            if (itemstack.func_190926_b() || !EnchantmentHelper.func_190939_c(itemstack)) continue;
            this.field_71071_by.func_70304_b(i);
        }
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (damageSourceIn == DamageSource.field_76370_b) {
            return SoundEvents.field_193806_fH;
        }
        return damageSourceIn == DamageSource.field_76369_e ? SoundEvents.field_193805_fG : SoundEvents.field_187800_eb;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187798_ea;
    }

    @Nullable
    public EntityItem func_71040_bB(boolean dropAll) {
        ItemStack stack = this.field_71071_by.func_70448_g();
        if (stack.func_190926_b() || !stack.onDroppedByPlayer(this)) {
            return null;
        }
        return ForgeHooks.onPlayerTossEvent((EntityPlayer)this, (ItemStack)this.field_71071_by.func_70298_a(this.field_71071_by.field_70461_c, dropAll && !this.field_71071_by.func_70448_g().func_190926_b() ? this.field_71071_by.func_70448_g().func_190916_E() : 1), (boolean)true);
    }

    @Nullable
    public EntityItem func_71019_a(ItemStack itemStackIn, boolean unused) {
        return ForgeHooks.onPlayerTossEvent((EntityPlayer)this, (ItemStack)itemStackIn, (boolean)false);
    }

    @Nullable
    public EntityItem func_146097_a(ItemStack droppedItem, boolean dropAround, boolean traceItem) {
        if (droppedItem.func_190926_b()) {
            return null;
        }
        double d0 = this.field_70163_u - (double)0.3f + (double)this.func_70047_e();
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, d0, this.field_70161_v, droppedItem);
        entityitem.func_174867_a(40);
        if (traceItem) {
            entityitem.func_200216_c(this.func_110124_au());
        }
        if (dropAround) {
            float f = this.field_70146_Z.nextFloat() * 0.5f;
            float f1 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)f1) * f;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)f1) * f;
            entityitem.field_70181_x = 0.2f;
        } else {
            float f2 = 0.3f;
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180))) * f2;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180))) * f2;
            entityitem.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A * ((float)Math.PI / 180))) * f2 + 0.1f;
            float f3 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            f2 = 0.02f * this.field_70146_Z.nextFloat();
            entityitem.field_70159_w += Math.cos(f3) * (double)f2;
            entityitem.field_70181_x += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
            entityitem.field_70179_y += Math.sin(f3) * (double)f2;
        }
        ItemStack itemstack = this.func_184816_a(entityitem);
        if (traceItem) {
            if (!itemstack.func_190926_b()) {
                this.func_71064_a(StatList.field_188068_aj.func_199076_b((Object)itemstack.func_77973_b()), droppedItem.func_190916_E());
            }
            this.func_195066_a(StatList.field_75952_v);
        }
        return entityitem;
    }

    public ItemStack func_184816_a(EntityItem p_184816_1_) {
        if (this.captureDrops() != null) {
            this.captureDrops().add(p_184816_1_);
        } else {
            this.field_70170_p.func_72838_d(p_184816_1_);
        }
        return p_184816_1_.func_92059_d();
    }

    @Deprecated
    public float func_184813_a(IBlockState state) {
        return this.getDigSpeed(state, null);
    }

    public float getDigSpeed(IBlockState state, @Nullable BlockPos pos) {
        float f = this.field_71071_by.func_184438_a(state);
        if (f > 1.0f) {
            int i = EnchantmentHelper.func_185293_e(this);
            ItemStack itemstack = this.func_184614_ca();
            if (i > 0 && !itemstack.func_190926_b()) {
                f += (float)(i * i + 1);
            }
        }
        if (PotionUtil.func_205135_a((EntityLivingBase)this)) {
            f *= 1.0f + (float)(PotionUtil.func_205134_b((EntityLivingBase)this) + 1) * 0.2f;
        }
        if (this.func_70644_a(MobEffects.field_76419_f)) {
            float f1;
            switch (this.func_70660_b(MobEffects.field_76419_f).func_76458_c()) {
                case 0: {
                    f1 = 0.3f;
                    break;
                }
                case 1: {
                    f1 = 0.09f;
                    break;
                }
                case 2: {
                    f1 = 0.0027f;
                    break;
                }
                default: {
                    f1 = 8.1E-4f;
                }
            }
            f *= f1;
        }
        if (this.func_208600_a(FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i(this)) {
            f /= 5.0f;
        }
        if (!this.field_70122_E) {
            f /= 5.0f;
        }
        f = ForgeEventFactory.getBreakSpeed((EntityPlayer)this, (IBlockState)state, (float)f, (BlockPos)pos);
        return f;
    }

    public boolean func_184823_b(IBlockState state) {
        return ForgeEventFactory.doPlayerHarvestCheck((EntityPlayer)this, (IBlockState)state, (state.func_185904_a().func_76229_l() || this.field_71071_by.func_184432_b(state) ? 1 : 0) != 0);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_184221_a(EntityPlayer.func_146094_a(this.field_146106_i));
        NBTTagList nbttaglist = compound.func_150295_c("Inventory", 10);
        this.field_71071_by.func_70443_b(nbttaglist);
        this.field_71071_by.field_70461_c = compound.func_74762_e("SelectedItemSlot");
        this.field_71083_bS = compound.func_74767_n("Sleeping");
        this.field_71076_b = compound.func_74765_d("SleepTimer");
        this.field_71106_cc = compound.func_74760_g("XpP");
        this.field_71068_ca = compound.func_74762_e("XpLevel");
        this.field_71067_cb = compound.func_74762_e("XpTotal");
        this.field_175152_f = compound.func_74762_e("XpSeed");
        if (this.field_175152_f == 0) {
            this.field_175152_f = this.field_70146_Z.nextInt();
        }
        this.func_85040_s(compound.func_74762_e("Score"));
        if (this.field_71083_bS) {
            this.field_71081_bT = new BlockPos((Entity)this);
            this.func_70999_a(true, true, false);
        }
        if (compound.func_150297_b("SpawnX", 99) && compound.func_150297_b("SpawnY", 99) && compound.func_150297_b("SpawnZ", 99)) {
            this.field_71077_c = new BlockPos(compound.func_74762_e("SpawnX"), compound.func_74762_e("SpawnY"), compound.func_74762_e("SpawnZ"));
            this.field_82248_d = compound.func_74767_n("SpawnForced");
        }
        compound.func_150295_c("Spawns", 10).forEach(e -> {
            NBTTagCompound data = (NBTTagCompound)e;
            ResourceLocation dim = new ResourceLocation(data.func_74779_i("Dim"));
            this.spawnPosMap.put(dim, new BlockPos(data.func_74762_e("SpawnX"), data.func_74762_e("SpawnY"), data.func_74762_e("SpawnZ")));
            this.spawnForcedMap.put(dim, data.func_74767_n("SpawnForced"));
        });
        DimensionType spawnDim = null;
        if (compound.func_150297_b("SpawnDimension", 8)) {
            spawnDim = DimensionType.func_193417_a(new ResourceLocation(compound.func_74779_i("SpawnDimension")));
        }
        this.spawnDimension = spawnDim != null ? spawnDim : DimensionType.OVERWORLD;
        this.field_71100_bB.func_75112_a(compound);
        this.field_71075_bZ.func_75095_b(compound);
        if (compound.func_150297_b("EnderItems", 9)) {
            this.field_71078_a.func_70486_a(compound.func_150295_c("EnderItems", 10));
        }
        if (compound.func_150297_b("ShoulderEntityLeft", 10)) {
            this.func_192029_h(compound.func_74775_l("ShoulderEntityLeft"));
        }
        if (compound.func_150297_b("ShoulderEntityRight", 10)) {
            this.func_192031_i(compound.func_74775_l("ShoulderEntityRight"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("DataVersion", 1631);
        compound.func_74782_a("Inventory", (INBTBase)this.field_71071_by.func_70442_a(new NBTTagList()));
        compound.func_74768_a("SelectedItemSlot", this.field_71071_by.field_70461_c);
        compound.func_74757_a("Sleeping", this.field_71083_bS);
        compound.func_74777_a("SleepTimer", (short)this.field_71076_b);
        compound.func_74776_a("XpP", this.field_71106_cc);
        compound.func_74768_a("XpLevel", this.field_71068_ca);
        compound.func_74768_a("XpTotal", this.field_71067_cb);
        compound.func_74768_a("XpSeed", this.field_175152_f);
        compound.func_74768_a("Score", this.func_71037_bA());
        if (this.field_71077_c != null) {
            compound.func_74768_a("SpawnX", this.field_71077_c.func_177958_n());
            compound.func_74768_a("SpawnY", this.field_71077_c.func_177956_o());
            compound.func_74768_a("SpawnZ", this.field_71077_c.func_177952_p());
            compound.func_74757_a("SpawnForced", this.field_82248_d);
        }
        this.field_71100_bB.func_75117_b(compound);
        this.field_71075_bZ.func_75091_a(compound);
        compound.func_74782_a("EnderItems", (INBTBase)this.field_71078_a.func_70487_g());
        if (!this.func_192023_dk().isEmpty()) {
            compound.func_74782_a("ShoulderEntityLeft", this.func_192023_dk());
        }
        if (!this.func_192025_dl().isEmpty()) {
            compound.func_74782_a("ShoulderEntityRight", this.func_192025_dl());
        }
        NBTTagList spawnlist = new NBTTagList();
        this.spawnPosMap.forEach((dim, pos) -> {
            if (pos != null) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("Dim", dim.toString());
                data.func_74768_a("SpawnX", pos.func_177958_n());
                data.func_74768_a("SpawnY", pos.func_177956_o());
                data.func_74768_a("SpawnZ", pos.func_177952_p());
                data.func_74757_a("SpawnForced", this.spawnForcedMap.getOrDefault(dim, false));
                spawnlist.add((INBTBase)data);
            }
        });
        compound.func_74782_a("Spawns", (INBTBase)spawnlist);
        if (this.spawnDimension != DimensionType.OVERWORLD) {
            compound.func_74778_a("SpawnDimension", this.spawnDimension.getRegistryName().toString());
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!ForgeHooks.onPlayerAttack((EntityLivingBase)this, (DamageSource)source, (float)amount)) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_71075_bZ.field_75102_a && !source.func_76357_e()) {
            return false;
        }
        this.field_70708_bq = 0;
        if (this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (this.func_70608_bn() && !this.field_70170_p.field_72995_K) {
            this.func_70999_a(true, true, false);
        }
        this.func_192030_dh();
        if (source.func_76350_n()) {
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                amount = 0.0f;
            }
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.EASY) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        return amount == 0.0f ? false : super.func_70097_a(source, amount);
    }

    @Override
    protected void func_190629_c(EntityLivingBase p_190629_1_) {
        super.func_190629_c(p_190629_1_);
        if (p_190629_1_.func_184614_ca().canDisableShield(this.field_184627_bm, this, p_190629_1_)) {
            this.func_190777_m(true);
        }
    }

    public boolean func_96122_a(EntityPlayer other) {
        Team team = this.func_96124_cp();
        Team team1 = other.func_96124_cp();
        if (team == null) {
            return true;
        }
        return !team.func_142054_a(team1) ? true : team.func_96665_g();
    }

    @Override
    protected void func_70675_k(float damage) {
        this.field_71071_by.func_70449_g(damage);
    }

    @Override
    protected void func_184590_k(float damage) {
        if (damage >= 3.0f && this.field_184627_bm.isShield(this)) {
            ItemStack copy = this.field_184627_bm.func_77946_l();
            int i = 1 + MathHelper.func_76141_d((float)damage);
            this.field_184627_bm.func_77972_a(i, this);
            if (this.field_184627_bm.func_190926_b()) {
                EnumHand enumhand = this.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)this, (ItemStack)copy, (EnumHand)enumhand);
                if (enumhand == EnumHand.MAIN_HAND) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                this.field_184627_bm = ItemStack.field_190927_a;
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    public float func_82243_bO() {
        int i = 0;
        for (ItemStack itemstack : this.field_71071_by.field_70460_b) {
            if (itemstack.func_190926_b()) continue;
            ++i;
        }
        return (float)i / (float)this.field_71071_by.field_70460_b.size();
    }

    @Override
    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (!this.func_180431_b(damageSrc)) {
            if ((damageAmount = ForgeHooks.onLivingHurt((EntityLivingBase)this, (DamageSource)damageSrc, (float)damageAmount)) <= 0.0f) {
                return;
            }
            damageAmount = this.func_70655_b(damageSrc, damageAmount);
            float f = damageAmount = this.func_70672_c(damageSrc, damageAmount);
            damageAmount = Math.max(damageAmount - this.func_110139_bj(), 0.0f);
            this.func_110149_m(this.func_110139_bj() - (f - damageAmount));
            damageAmount = ForgeHooks.onLivingDamage((EntityLivingBase)this, (DamageSource)damageSrc, (float)damageAmount);
            float f1 = f - damageAmount;
            if (f1 > 0.0f && f1 < 3.4028235E37f) {
                this.func_195067_a(StatList.field_212738_J, Math.round(f1 * 10.0f));
            }
            if (damageAmount != 0.0f) {
                this.func_71020_j(damageSrc.func_76345_d());
                float f2 = this.func_110143_aJ();
                this.func_70606_j(this.func_110143_aJ() - damageAmount);
                this.func_110142_aN().func_94547_a(damageSrc, f2, damageAmount);
                if (damageAmount < 3.4028235E37f) {
                    this.func_195067_a(StatList.field_188112_z, Math.round(damageAmount * 10.0f));
                }
            }
        }
    }

    public void func_175141_a(TileEntitySign signTile) {
    }

    public void func_184809_a(CommandBlockBaseLogic commandBlock) {
    }

    public void func_184824_a(TileEntityCommandBlock commandBlock) {
    }

    public void func_189807_a(TileEntityStructure structure) {
    }

    public void func_180472_a(IMerchant villager) {
    }

    public void func_71007_a(IInventory chestInventory) {
    }

    public void func_184826_a(AbstractHorse horse, IInventory inventoryIn) {
    }

    public void func_180468_a(IInteractionObject guiOwner) {
    }

    public void func_184814_a(ItemStack stack, EnumHand hand) {
    }

    public EnumActionResult func_190775_a(Entity entityToInteractOn, EnumHand hand) {
        ItemStack itemstack1;
        if (this.func_175149_v()) {
            if (entityToInteractOn instanceof IInventory) {
                this.func_71007_a((IInventory)entityToInteractOn);
            }
            return EnumActionResult.PASS;
        }
        EnumActionResult cancelResult = ForgeHooks.onInteractEntity((EntityPlayer)this, (Entity)entityToInteractOn, (EnumHand)hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        ItemStack itemstack = this.func_184586_b(hand);
        ItemStack itemStack = itemstack1 = itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack.func_77946_l();
        if (entityToInteractOn.func_184230_a(this, hand)) {
            if (this.field_71075_bZ.field_75098_d && itemstack == this.func_184586_b(hand) && itemstack.func_190916_E() < itemstack1.func_190916_E()) {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
            if (!this.field_71075_bZ.field_75098_d && itemstack.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)this, (ItemStack)itemstack1, (EnumHand)hand);
            }
            return EnumActionResult.SUCCESS;
        }
        if (!itemstack.func_190926_b() && entityToInteractOn instanceof EntityLivingBase) {
            if (this.field_71075_bZ.field_75098_d) {
                itemstack = itemstack1;
            }
            if (itemstack.func_111282_a(this, (EntityLivingBase)entityToInteractOn, hand)) {
                if (itemstack.func_190926_b() && !this.field_71075_bZ.field_75098_d) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)this, (ItemStack)itemstack1, (EnumHand)hand);
                    this.func_184611_a(hand, ItemStack.field_190927_a);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public double func_70033_W() {
        return -0.35;
    }

    @Override
    public void func_184210_p() {
        super.func_184210_p();
        this.field_184245_j = 0;
    }

    public void func_71059_n(Entity targetEntity) {
        if (!ForgeHooks.onPlayerAttackTarget((EntityPlayer)this, (Entity)targetEntity)) {
            return;
        }
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j(this)) {
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            float f1 = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a(this.func_184614_ca(), ((EntityLivingBase)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a(this.func_184614_ca(), CreatureAttribute.UNDEFINED);
            float f2 = this.func_184825_o(0.5f);
            f1 *= f2;
            this.func_184821_cY();
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                ItemStack itemstack;
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                int i = 0;
                i += EnchantmentHelper.func_77501_a(this);
                if (this.func_70051_ag() && flag) {
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187721_dT, this.func_184176_by(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                boolean flag2 = flag && this.field_70143_R > 0.0f && !this.field_70122_E && !this.func_70617_f_() && !this.func_70090_H() && !this.func_70644_a(MobEffects.field_76440_q) && !this.func_184218_aH() && targetEntity instanceof EntityLivingBase;
                flag2 = flag2 && !this.func_70051_ag();
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((EntityPlayer)this, (Entity)targetEntity, (boolean)flag2, (float)(flag2 ? 1.5f : 1.0f));
                boolean bl = flag2 = hitResult != null;
                if (flag2) {
                    f *= hitResult.getDamageModifier();
                }
                f += f1;
                boolean flag3 = false;
                double d0 = this.field_70140_Q - this.field_70141_P;
                if (flag && !flag2 && !flag1 && this.field_70122_E && d0 < (double)this.func_70689_ay() && (itemstack = this.func_184586_b(EnumHand.MAIN_HAND)).func_77973_b() instanceof ItemSword) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.func_90036_a(this);
                if (targetEntity instanceof EntityLivingBase) {
                    f4 = ((EntityLivingBase)targetEntity).func_110143_aJ();
                    if (j > 0 && !targetEntity.func_70027_ad()) {
                        flag4 = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                double d1 = targetEntity.field_70159_w;
                double d2 = targetEntity.field_70181_x;
                double d3 = targetEntity.field_70179_y;
                boolean flag5 = targetEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this), f);
                if (flag5) {
                    IEntityMultiPart ientitymultipart;
                    if (i > 0) {
                        if (targetEntity instanceof EntityLivingBase) {
                            ((EntityLivingBase)targetEntity).func_70653_a(this, (float)i * 0.5f, MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))));
                        } else {
                            targetEntity.func_70024_g(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f, 0.1, MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f);
                        }
                        this.field_70159_w *= 0.6;
                        this.field_70179_y *= 0.6;
                        this.func_70031_b(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + EnchantmentHelper.func_191527_a(this) * f;
                        for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, targetEntity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                            if (entitylivingbase == this || entitylivingbase == targetEntity || this.func_184191_r(entitylivingbase) || entitylivingbase instanceof EntityArmorStand && ((EntityArmorStand)entitylivingbase).func_181026_s() || !(this.func_70068_e(entitylivingbase) < 9.0)) continue;
                            entitylivingbase.func_70653_a(this, 0.4f, MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))));
                            entitylivingbase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this), f3);
                        }
                        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187730_dW, this.func_184176_by(), 1.0f, 1.0f);
                        this.func_184810_cG();
                    }
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                        ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet<?>)new SPacketEntityVelocity(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.field_70159_w = d1;
                        targetEntity.field_70181_x = d2;
                        targetEntity.field_70179_y = d3;
                    }
                    if (flag2) {
                        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187718_dS, this.func_184176_by(), 1.0f, 1.0f);
                        this.func_71009_b(targetEntity);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187727_dV, this.func_184176_by(), 1.0f, 1.0f);
                        } else {
                            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187733_dX, this.func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.func_71047_c(targetEntity);
                    }
                    this.func_130011_c(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)targetEntity, this);
                    }
                    EnchantmentHelper.func_151385_b(this, targetEntity);
                    ItemStack itemstack1 = this.func_184614_ca();
                    Entity entity = targetEntity;
                    if (targetEntity instanceof MultiPartEntityPart && (ientitymultipart = ((MultiPartEntityPart)targetEntity).field_70259_a) instanceof EntityLivingBase) {
                        entity = (EntityLivingBase)ientitymultipart;
                    }
                    if (!itemstack1.func_190926_b() && entity instanceof EntityLivingBase) {
                        ItemStack copy = itemstack1.func_77946_l();
                        itemstack1.func_77961_a((EntityLivingBase)entity, this);
                        if (itemstack1.func_190926_b()) {
                            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)this, (ItemStack)copy, (EnumHand)EnumHand.MAIN_HAND);
                            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (targetEntity instanceof EntityLivingBase) {
                        float f5 = f4 - ((EntityLivingBase)targetEntity).func_110143_aJ();
                        this.func_195067_a(StatList.field_188111_y, Math.round(f5 * 10.0f));
                        if (j > 0) {
                            targetEntity.func_70015_d(j * 4);
                        }
                        if (this.field_70170_p instanceof WorldServer && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((WorldServer)this.field_70170_p).func_195598_a(Particles.field_197615_h, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)(targetEntity.field_70131_O * 0.5f), targetEntity.field_70161_v, k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.func_71020_j(0.1f);
                } else {
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187724_dU, this.func_184176_by(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
    }

    @Override
    protected void func_204804_d(EntityLivingBase p_204804_1_) {
        this.func_71059_n(p_204804_1_);
    }

    public void func_190777_m(boolean p_190777_1_) {
        float f = 0.25f + (float)EnchantmentHelper.func_185293_e(this) * 0.05f;
        if (p_190777_1_) {
            f += 0.75f;
        }
        if (this.field_70146_Z.nextFloat() < f) {
            this.func_184811_cZ().func_185145_a(this.func_184607_cu().func_77973_b(), 100);
            this.func_184602_cy();
            this.field_70170_p.func_72960_a(this, (byte)30);
        }
    }

    public void func_71009_b(Entity entityHit) {
    }

    public void func_71047_c(Entity entityHit) {
    }

    public void func_184810_cG() {
        double d0 = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
        double d1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
        if (this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_195598_a(Particles.field_197603_N, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_71004_bE() {
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        this.field_71069_bz.func_75134_a(this);
        if (this.field_71070_bA != null) {
            this.field_71070_bA.func_75134_a(this);
        }
    }

    @Override
    public boolean func_70094_T() {
        return !this.field_71083_bS && super.func_70094_T();
    }

    public boolean func_175144_cb() {
        return false;
    }

    public GameProfile func_146103_bH() {
        return this.field_146106_i;
    }

    public SleepResult func_180469_a(BlockPos bedLocation) {
        EnumFacing enumfacing;
        SleepResult ret = ForgeEventFactory.onPlayerSleepInBed((EntityPlayer)this, (BlockPos)bedLocation);
        if (ret != null) {
            return ret;
        }
        IBlockState state = this.field_70170_p.func_175667_e(bedLocation) ? this.field_70170_p.func_180495_p(bedLocation) : null;
        boolean isBed = state != null && state.isBed((IBlockReader)this.field_70170_p, bedLocation, this);
        EnumFacing enumFacing = enumfacing = isBed && state.func_177230_c() instanceof BlockHorizontal ? (EnumFacing)((Object)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)) : null;
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70608_bn() || !this.func_70089_S()) {
                return SleepResult.OTHER_PROBLEM;
            }
            if (!this.field_70170_p.field_73011_w.func_76569_d()) {
                return SleepResult.NOT_POSSIBLE_HERE;
            }
            if (!ForgeEventFactory.fireSleepingTimeCheck((EntityPlayer)this, (BlockPos)bedLocation)) {
                return SleepResult.NOT_POSSIBLE_NOW;
            }
            if (!this.func_190774_a(bedLocation, enumfacing)) {
                return SleepResult.TOO_FAR_AWAY;
            }
            if (!this.func_184812_l_()) {
                double d0 = 8.0;
                double d1 = 5.0;
                List<EntityMob> list = this.field_70170_p.func_175647_a(EntityMob.class, new AxisAlignedBB((double)bedLocation.func_177958_n() - 8.0, (double)bedLocation.func_177956_o() - 5.0, (double)bedLocation.func_177952_p() - 8.0, (double)bedLocation.func_177958_n() + 8.0, (double)bedLocation.func_177956_o() + 5.0, (double)bedLocation.func_177952_p() + 8.0), new SleepEnemyPredicate(this));
                if (!list.isEmpty()) {
                    return SleepResult.NOT_SAFE;
                }
            }
        }
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
        this.func_192030_dh();
        this.func_175145_a(StatList.field_199092_j.func_199076_b((Object)StatList.field_203284_n));
        this.func_70105_a(0.2f, 0.2f);
        if (enumfacing != null) {
            float f1 = 0.5f + (float)enumfacing.func_82601_c() * 0.4f;
            float f = 0.5f + (float)enumfacing.func_82599_e() * 0.4f;
            this.func_175139_a(enumfacing);
            this.func_70107_b((float)bedLocation.func_177958_n() + f1, (float)bedLocation.func_177956_o() + 0.6875f, (float)bedLocation.func_177952_p() + f);
        } else {
            this.func_70107_b((float)bedLocation.func_177958_n() + 0.5f, (float)bedLocation.func_177956_o() + 0.6875f, (float)bedLocation.func_177952_p() + 0.5f);
        }
        this.field_71083_bS = true;
        this.field_71076_b = 0;
        this.field_71081_bT = bedLocation;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72854_c();
        }
        return SleepResult.OK;
    }

    private boolean func_190774_a(BlockPos p_190774_1_, EnumFacing p_190774_2_) {
        if (Math.abs(this.field_70165_t - (double)p_190774_1_.func_177958_n()) <= 3.0 && Math.abs(this.field_70163_u - (double)p_190774_1_.func_177956_o()) <= 2.0 && Math.abs(this.field_70161_v - (double)p_190774_1_.func_177952_p()) <= 3.0) {
            return true;
        }
        if (p_190774_2_ == null) {
            return false;
        }
        BlockPos blockpos = p_190774_1_.func_177972_a(p_190774_2_.func_176734_d());
        return Math.abs(this.field_70165_t - (double)blockpos.func_177958_n()) <= 3.0 && Math.abs(this.field_70163_u - (double)blockpos.func_177956_o()) <= 2.0 && Math.abs(this.field_70161_v - (double)blockpos.func_177952_p()) <= 3.0;
    }

    private void func_175139_a(EnumFacing bedDirection) {
        this.field_71079_bU = -1.8f * (float)bedDirection.func_82601_c();
        this.field_71089_bV = -1.8f * (float)bedDirection.func_82599_e();
    }

    public void func_70999_a(boolean immediately, boolean updateWorldFlag, boolean setSpawn) {
        IBlockState iblockstate;
        ForgeEventFactory.onPlayerWakeup((EntityPlayer)this, (boolean)immediately, (boolean)updateWorldFlag, (boolean)setSpawn);
        this.func_70105_a(0.6f, 1.8f);
        IBlockState iBlockState = iblockstate = this.field_71081_bT == null ? null : this.field_70170_p.func_180495_p(this.field_71081_bT);
        if (this.field_71081_bT != null && iblockstate.isBed((IBlockReader)this.field_70170_p, this.field_71081_bT, this)) {
            iblockstate.setBedOccupied(this.field_70170_p, this.field_71081_bT, this, false);
            BlockPos blockpos = iblockstate.getBedSpawnPosition((IBlockReader)this.field_70170_p, this.field_71081_bT, this);
            if (blockpos == null) {
                blockpos = this.field_71081_bT.func_177984_a();
            }
            this.func_70107_b((float)blockpos.func_177958_n() + 0.5f, (float)blockpos.func_177956_o() + 0.1f, (float)blockpos.func_177952_p() + 0.5f);
        } else {
            setSpawn = false;
        }
        this.field_71083_bS = false;
        if (!this.field_70170_p.field_72995_K && updateWorldFlag) {
            this.field_70170_p.func_72854_c();
        }
        int n = this.field_71076_b = immediately ? 0 : 100;
        if (setSpawn) {
            this.func_180473_a(this.field_71081_bT, false);
        }
    }

    private boolean func_175143_p() {
        return ForgeEventFactory.fireSleepingLocationCheck((EntityPlayer)this, (BlockPos)this.field_71081_bT);
    }

    @Nullable
    public static BlockPos func_180467_a(IBlockReader worldIn, BlockPos bedLocation, boolean forceSpawn) {
        IBlockState state = worldIn.func_180495_p(bedLocation);
        if (!state.isBed(worldIn, bedLocation, null)) {
            if (!forceSpawn) {
                return null;
            }
            boolean flag = state.func_177230_c().func_181623_g();
            boolean flag1 = worldIn.func_180495_p(bedLocation.func_177984_a()).func_177230_c().func_181623_g();
            return flag && flag1 ? bedLocation : null;
        }
        return state.getBedSpawnPosition(worldIn, bedLocation, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_71051_bG() {
        if (this.field_71081_bT != null) {
            IBlockState state = this.field_70170_p.func_180495_p(this.field_71081_bT);
            EnumFacing enumfacing = !state.isBed((IBlockReader)this.field_70170_p, this.field_71081_bT, this) ? EnumFacing.UP : state.getBedDirection(this.field_70170_p, this.field_71081_bT);
            switch (enumfacing) {
                case SOUTH: {
                    return 90.0f;
                }
                case WEST: {
                    return 0.0f;
                }
                case NORTH: {
                    return 270.0f;
                }
                case EAST: {
                    return 180.0f;
                }
            }
        }
        return 0.0f;
    }

    @Override
    public boolean func_70608_bn() {
        return this.field_71083_bS;
    }

    public boolean func_71026_bH() {
        return this.field_71083_bS && this.field_71076_b >= 100;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_71060_bI() {
        return this.field_71076_b;
    }

    public void func_146105_b(ITextComponent chatComponent, boolean actionBar) {
    }

    @Deprecated
    public BlockPos func_180470_cg() {
        return this.getBedLocation(this.field_71093_bK);
    }

    public BlockPos getBedLocation(DimensionType dim) {
        return dim == DimensionType.OVERWORLD ? this.field_71081_bT : this.spawnPosMap.get(dim.getRegistryName());
    }

    @Deprecated
    public boolean func_82245_bX() {
        return this.isSpawnForced(this.field_71093_bK);
    }

    public boolean isSpawnForced(DimensionType dim) {
        return dim == DimensionType.OVERWORLD ? this.field_82248_d : this.spawnForcedMap.getOrDefault(dim.getRegistryName(), false);
    }

    @Deprecated
    public void func_180473_a(BlockPos pos, boolean forced) {
        this.setSpawnPoint(pos, forced, this.field_71093_bK);
    }

    public void setSpawnPoint(@Nullable BlockPos pos, boolean forced, DimensionType dim) {
        if (ForgeEventFactory.onPlayerSpawnSet((EntityPlayer)this, (BlockPos)pos, (boolean)forced)) {
            return;
        }
        if (dim != DimensionType.OVERWORLD) {
            if (pos == null) {
                this.spawnPosMap.remove(dim.getRegistryName());
                this.spawnForcedMap.remove(dim.getRegistryName());
            } else {
                this.spawnPosMap.put(dim.getRegistryName(), pos);
                this.spawnForcedMap.put(dim.getRegistryName(), forced);
            }
            return;
        }
        if (pos != null) {
            this.field_71077_c = pos;
            this.field_82248_d = forced;
        } else {
            this.field_71077_c = null;
            this.field_82248_d = false;
        }
    }

    public void func_195066_a(ResourceLocation stat) {
        this.func_71029_a(StatList.field_199092_j.func_199076_b((Object)stat));
    }

    public void func_195067_a(ResourceLocation p_195067_1_, int p_195067_2_) {
        this.func_71064_a(StatList.field_199092_j.func_199076_b((Object)p_195067_1_), p_195067_2_);
    }

    public void func_71029_a(Stat<?> stat) {
        this.func_71064_a(stat, 1);
    }

    public void func_71064_a(Stat<?> stat, int amount) {
    }

    public void func_175145_a(Stat<?> stat) {
    }

    public int func_195065_a(Collection<IRecipe> p_195065_1_) {
        return 0;
    }

    public void func_193102_a(ResourceLocation[] p_193102_1_) {
    }

    public int func_195069_b(Collection<IRecipe> p_195069_1_) {
        return 0;
    }

    @Override
    public void func_70664_aZ() {
        super.func_70664_aZ();
        this.func_195066_a(StatList.field_75953_u);
        if (this.func_70051_ag()) {
            this.func_71020_j(0.2f);
        } else {
            this.func_71020_j(0.05f);
        }
    }

    @Override
    public void func_191986_a(float strafe, float vertical, float forward) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        if (this.func_203007_ba() && !this.func_184218_aH()) {
            double d4;
            double d3 = this.func_70040_Z().field_72448_b;
            double d = d4 = d3 < -0.2 ? 0.085 : 0.06;
            if (d3 <= 0.0 || this.field_70703_bu || !this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + 1.0 - 0.1, this.field_70161_v)).func_204520_s().func_206888_e()) {
                this.field_70181_x += (d3 - this.field_70181_x) * d4;
            }
        }
        if (this.field_71075_bZ.field_75100_b && !this.func_184218_aH()) {
            double d5 = this.field_70181_x;
            float f = this.field_70747_aH;
            this.field_70747_aH = this.field_71075_bZ.func_75093_a() * (float)(this.func_70051_ag() ? 2 : 1);
            super.func_191986_a(strafe, vertical, forward);
            this.field_70181_x = d5 * 0.6;
            this.field_70747_aH = f;
            this.field_70143_R = 0.0f;
            this.func_70052_a(7, false);
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
        this.func_71000_j(this.field_70165_t - d0, this.field_70163_u - d1, this.field_70161_v - d2);
    }

    @Override
    public void func_205343_av() {
        if (this.field_71075_bZ.field_75100_b) {
            this.func_204711_a(false);
        } else {
            super.func_205343_av();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected boolean func_207402_f(BlockPos p_207402_1_) {
        return this.func_207401_g(p_207402_1_) && !this.field_70170_p.func_180495_p(p_207402_1_.func_177984_a()).func_185915_l();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected boolean func_207401_g(BlockPos pos) {
        return !this.field_70170_p.func_180495_p(pos).func_185915_l();
    }

    @Override
    public float func_70689_ay() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
    }

    public void func_71000_j(double p_71000_1_, double p_71000_3_, double p_71000_5_) {
        if (!this.func_184218_aH()) {
            if (this.func_203007_ba()) {
                int i = Math.round(MathHelper.func_76133_a((double)(p_71000_1_ * p_71000_1_ + p_71000_3_ * p_71000_3_ + p_71000_5_ * p_71000_5_)) * 100.0f);
                if (i > 0) {
                    this.func_195067_a(StatList.field_75946_m, i);
                    this.func_71020_j(0.01f * (float)i * 0.01f);
                }
            } else if (this.func_208600_a(FluidTags.field_206959_a)) {
                int j = Math.round(MathHelper.func_76133_a((double)(p_71000_1_ * p_71000_1_ + p_71000_3_ * p_71000_3_ + p_71000_5_ * p_71000_5_)) * 100.0f);
                if (j > 0) {
                    this.func_195067_a(StatList.field_211756_w, j);
                    this.func_71020_j(0.01f * (float)j * 0.01f);
                }
            } else if (this.func_70090_H()) {
                int k = Math.round(MathHelper.func_76133_a((double)(p_71000_1_ * p_71000_1_ + p_71000_5_ * p_71000_5_)) * 100.0f);
                if (k > 0) {
                    this.func_195067_a(StatList.field_211755_s, k);
                    this.func_71020_j(0.01f * (float)k * 0.01f);
                }
            } else if (this.func_70617_f_()) {
                if (p_71000_3_ > 0.0) {
                    this.func_195067_a(StatList.field_188103_o, (int)Math.round(p_71000_3_ * 100.0));
                }
            } else if (this.field_70122_E) {
                int l = Math.round(MathHelper.func_76133_a((double)(p_71000_1_ * p_71000_1_ + p_71000_5_ * p_71000_5_)) * 100.0f);
                if (l > 0) {
                    if (this.func_70051_ag()) {
                        this.func_195067_a(StatList.field_188102_l, l);
                        this.func_71020_j(0.1f * (float)l * 0.01f);
                    } else if (this.func_70093_af()) {
                        this.func_195067_a(StatList.field_188101_k, l);
                        this.func_71020_j(0.0f * (float)l * 0.01f);
                    } else {
                        this.func_195067_a(StatList.field_188100_j, l);
                        this.func_71020_j(0.0f * (float)l * 0.01f);
                    }
                }
            } else if (this.func_184613_cA()) {
                int i1 = Math.round(MathHelper.func_76133_a((double)(p_71000_1_ * p_71000_1_ + p_71000_3_ * p_71000_3_ + p_71000_5_ * p_71000_5_)) * 100.0f);
                this.func_195067_a(StatList.field_188110_v, i1);
            } else {
                int j1 = Math.round(MathHelper.func_76133_a((double)(p_71000_1_ * p_71000_1_ + p_71000_5_ * p_71000_5_)) * 100.0f);
                if (j1 > 25) {
                    this.func_195067_a(StatList.field_188104_p, j1);
                }
            }
        }
    }

    private void func_71015_k(double p_71015_1_, double p_71015_3_, double p_71015_5_) {
        int i;
        if (this.func_184218_aH() && (i = Math.round(MathHelper.func_76133_a((double)(p_71015_1_ * p_71015_1_ + p_71015_3_ * p_71015_3_ + p_71015_5_ * p_71015_5_)) * 100.0f)) > 0) {
            if (this.func_184187_bx() instanceof EntityMinecart) {
                this.func_195067_a(StatList.field_188106_r, i);
            } else if (this.func_184187_bx() instanceof EntityBoat) {
                this.func_195067_a(StatList.field_188107_s, i);
            } else if (this.func_184187_bx() instanceof EntityPig) {
                this.func_195067_a(StatList.field_188108_t, i);
            } else if (this.func_184187_bx() instanceof AbstractHorse) {
                this.func_195067_a(StatList.field_188109_u, i);
            }
        }
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.field_71075_bZ.field_75101_c) {
            if (distance >= 2.0f) {
                this.func_195067_a(StatList.field_75943_n, (int)Math.round((double)distance * 100.0));
            }
            super.func_180430_e(distance, damageMultiplier);
        } else {
            ForgeEventFactory.onPlayerFall((EntityPlayer)this, (float)distance, (float)damageMultiplier);
        }
    }

    @Override
    protected void func_71061_d_() {
        if (!this.func_175149_v()) {
            super.func_71061_d_();
        }
    }

    @Override
    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187736_dY : SoundEvents.field_187804_ed;
    }

    @Override
    public void func_70074_a(EntityLivingBase entityLivingIn) {
        this.func_71029_a(StatList.field_199090_h.func_199076_b(entityLivingIn.func_200600_R()));
    }

    @Override
    public void func_70110_aj() {
        if (!this.field_71075_bZ.field_75100_b) {
            super.func_70110_aj();
        }
    }

    public void func_195068_e(int p_195068_1_) {
        this.func_85039_t(p_195068_1_);
        this.field_71106_cc += (float)p_195068_1_ / (float)this.func_71050_bK();
        this.field_71067_cb = MathHelper.func_76125_a((int)(this.field_71067_cb + p_195068_1_), (int)0, (int)Integer.MAX_VALUE);
        while (this.field_71106_cc < 0.0f) {
            float f = this.field_71106_cc * (float)this.func_71050_bK();
            if (this.field_71068_ca > 0) {
                this.func_82242_a(-1);
                this.field_71106_cc = 1.0f + f / (float)this.func_71050_bK();
                continue;
            }
            this.func_82242_a(-1);
            this.field_71106_cc = 0.0f;
        }
        while (this.field_71106_cc >= 1.0f) {
            this.field_71106_cc = (this.field_71106_cc - 1.0f) * (float)this.func_71050_bK();
            this.func_82242_a(1);
            this.field_71106_cc /= (float)this.func_71050_bK();
        }
    }

    public int func_175138_ci() {
        return this.field_175152_f;
    }

    public void func_192024_a(ItemStack enchantedItem, int cost) {
        this.field_71068_ca -= cost;
        if (this.field_71068_ca < 0) {
            this.field_71068_ca = 0;
            this.field_71106_cc = 0.0f;
            this.field_71067_cb = 0;
        }
        this.field_175152_f = this.field_70146_Z.nextInt();
    }

    public void func_82242_a(int levels) {
        this.field_71068_ca += levels;
        if (this.field_71068_ca < 0) {
            this.field_71068_ca = 0;
            this.field_71106_cc = 0.0f;
            this.field_71067_cb = 0;
        }
        if (levels > 0 && this.field_71068_ca % 5 == 0 && (float)this.field_82249_h < (float)this.field_70173_aa - 100.0f) {
            float f = this.field_71068_ca > 30 ? 1.0f : (float)this.field_71068_ca / 30.0f;
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187802_ec, this.func_184176_by(), f * 0.75f, 1.0f);
            this.field_82249_h = this.field_70173_aa;
        }
    }

    public int func_71050_bK() {
        if (this.field_71068_ca >= 30) {
            return 112 + (this.field_71068_ca - 30) * 9;
        }
        return this.field_71068_ca >= 15 ? 37 + (this.field_71068_ca - 15) * 5 : 7 + this.field_71068_ca * 2;
    }

    public void func_71020_j(float exhaustion) {
        if (!this.field_71075_bZ.field_75102_a && !this.field_70170_p.field_72995_K) {
            this.field_71100_bB.func_75113_a(exhaustion);
        }
    }

    public FoodStats func_71024_bL() {
        return this.field_71100_bB;
    }

    public boolean func_71043_e(boolean ignoreHunger) {
        return !this.field_71075_bZ.field_75102_a && (ignoreHunger || this.field_71100_bB.func_75121_c());
    }

    public boolean func_70996_bM() {
        return this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < this.func_110138_aP();
    }

    public boolean func_175142_cm() {
        return this.field_71075_bZ.field_75099_e;
    }

    public boolean func_175151_a(BlockPos pos, EnumFacing facing, ItemStack stack) {
        if (this.field_71075_bZ.field_75099_e) {
            return true;
        }
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        BlockWorldState blockworldstate = new BlockWorldState((IWorldReaderBase)this.field_70170_p, blockpos, false);
        return stack.func_206847_b(this.field_70170_p.func_205772_D(), blockworldstate);
    }

    @Override
    protected int func_70693_a(EntityPlayer player) {
        if (!this.field_70170_p.func_82736_K().func_82766_b("keepInventory") && !this.func_175149_v()) {
            int i = this.field_71068_ca * 7;
            return i > 100 ? 100 : i;
        }
        return 0;
    }

    @Override
    protected boolean func_70684_aJ() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_94059_bO() {
        return true;
    }

    @Override
    protected boolean func_70041_e_() {
        return !this.field_71075_bZ.field_75100_b;
    }

    public void func_71016_p() {
    }

    public void func_71033_a(GameType gameType) {
    }

    @Override
    public ITextComponent func_200200_C_() {
        return new TextComponentString(this.field_146106_i.getName());
    }

    public InventoryEnderChest func_71005_bN() {
        return this.field_71078_a;
    }

    @Override
    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            return this.field_71071_by.func_70448_g();
        }
        if (slotIn == EntityEquipmentSlot.OFFHAND) {
            return (ItemStack)((Object)this.field_71071_by.field_184439_c.get(0));
        }
        return slotIn.func_188453_a() == EntityEquipmentSlot.Type.ARMOR ? (ItemStack)((Object)this.field_71071_by.field_70460_b.get(slotIn.func_188454_b())) : ItemStack.field_190927_a;
    }

    @Override
    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            this.func_184606_a_(stack);
            this.field_71071_by.field_70462_a.set(this.field_71071_by.field_70461_c, (Object)stack);
        } else if (slotIn == EntityEquipmentSlot.OFFHAND) {
            this.func_184606_a_(stack);
            this.field_71071_by.field_184439_c.set(0, (Object)stack);
        } else if (slotIn.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
            this.func_184606_a_(stack);
            this.field_71071_by.field_70460_b.set(slotIn.func_188454_b(), (Object)stack);
        }
    }

    public boolean func_191521_c(ItemStack p_191521_1_) {
        this.func_184606_a_(p_191521_1_);
        return this.field_71071_by.func_70441_a(p_191521_1_);
    }

    @Override
    public Iterable<ItemStack> func_184214_aD() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.func_184614_ca(), this.func_184592_cb()});
    }

    @Override
    public Iterable<ItemStack> func_184193_aE() {
        return this.field_71071_by.field_70460_b;
    }

    public boolean func_192027_g(NBTTagCompound p_192027_1_) {
        if (!this.func_184218_aH() && this.field_70122_E && !this.func_70090_H()) {
            if (this.func_192023_dk().isEmpty()) {
                this.func_192029_h(p_192027_1_);
                return true;
            }
            if (this.func_192025_dl().isEmpty()) {
                this.func_192031_i(p_192027_1_);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void func_192030_dh() {
        this.func_192026_k(this.func_192023_dk());
        this.func_192029_h(new NBTTagCompound());
        this.func_192026_k(this.func_192025_dl());
        this.func_192031_i(new NBTTagCompound());
    }

    private void func_192026_k(@Nullable NBTTagCompound p_192026_1_) {
        if (!this.field_70170_p.field_72995_K && !p_192026_1_.isEmpty()) {
            Entity entity = EntityType.func_200716_a(p_192026_1_, this.field_70170_p);
            if (entity instanceof EntityTameable) {
                ((EntityTameable)entity).func_184754_b(this.field_96093_i);
            }
            entity.func_70107_b(this.field_70165_t, this.field_70163_u + (double)0.7f, this.field_70161_v);
            this.field_70170_p.func_72838_d(entity);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_98034_c(EntityPlayer player) {
        if (!this.func_82150_aj()) {
            return false;
        }
        if (player.func_175149_v()) {
            return false;
        }
        Team team = this.func_96124_cp();
        return team == null || player == null || player.func_96124_cp() != team || !team.func_98297_h();
    }

    public abstract boolean func_175149_v();

    @Override
    public boolean func_203007_ba() {
        return !this.field_71075_bZ.field_75100_b && !this.func_175149_v() && super.func_203007_ba();
    }

    public abstract boolean func_184812_l_();

    @Override
    public boolean func_96092_aw() {
        return !this.field_71075_bZ.field_75100_b;
    }

    public Scoreboard func_96123_co() {
        return this.field_70170_p.func_96441_U();
    }

    @Override
    public ITextComponent func_145748_c_() {
        TextComponentString itextcomponent = new TextComponentString("");
        this.prefixes.forEach(arg_0 -> EntityPlayer.lambda$getDisplayName$2((ITextComponent)itextcomponent, arg_0));
        itextcomponent.func_150257_a(ScorePlayerTeam.func_200541_a((Team)this.func_96124_cp(), (ITextComponent)this.func_200200_C_()));
        this.suffixes.forEach(arg_0 -> EntityPlayer.lambda$getDisplayName$3((ITextComponent)itextcomponent, arg_0));
        return this.func_208016_c((ITextComponent)itextcomponent);
    }

    public ITextComponent func_208017_dF() {
        return new TextComponentString("").func_150257_a(this.func_200200_C_()).func_150258_a(" (").func_150258_a(this.field_146106_i.getId().toString()).func_150258_a(")");
    }

    private ITextComponent func_208016_c(ITextComponent p_208016_1_) {
        String s = this.func_146103_bH().getName();
        return p_208016_1_.func_211710_a(p_211521_2_ -> p_211521_2_.func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tell " + s + " ")).func_150209_a(this.func_174823_aP()).func_179989_a(s));
    }

    @Override
    public String func_195047_I_() {
        return this.func_146103_bH().getName();
    }

    @Override
    public float func_70047_e() {
        float f = this.eyeHeight;
        if (this.func_70608_bn()) {
            f = 0.2f;
        } else if (!this.func_203007_ba() && !this.func_184613_cA() && this.field_70131_O != 0.6f) {
            if (this.func_70093_af() || this.field_70131_O == 1.65f) {
                f -= 0.08f;
            }
        } else {
            f = 0.4f;
        }
        return f;
    }

    @Override
    public void func_110149_m(float amount) {
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        this.func_184212_Q().func_187227_b(field_184829_a, Float.valueOf(amount));
    }

    @Override
    public float func_110139_bj() {
        return this.func_184212_Q().func_187225_a(field_184829_a).floatValue();
    }

    public static UUID func_146094_a(GameProfile profile) {
        UUID uuid = profile.getId();
        if (uuid == null) {
            uuid = EntityPlayer.func_175147_b(profile.getName());
        }
        return uuid;
    }

    public static UUID func_175147_b(String username) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
    }

    public boolean func_175146_a(LockCode code) {
        if (code.func_180160_a()) {
            return true;
        }
        ItemStack itemstack = this.func_184614_ca();
        return !itemstack.func_190926_b() && itemstack.func_82837_s() ? itemstack.func_200301_q().getString().equals(code.func_180159_b()) : false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_175148_a(EnumPlayerModelParts part) {
        return (this.func_184212_Q().func_187225_a(field_184827_bp) & part.func_179327_a()) == part.func_179327_a();
    }

    @Override
    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (inventorySlot >= 0 && inventorySlot < this.field_71071_by.field_70462_a.size()) {
            this.field_71071_by.func_70299_a(inventorySlot, itemStackIn);
            return true;
        }
        Object entityequipmentslot = inventorySlot == 100 + EntityEquipmentSlot.HEAD.func_188454_b() ? EntityEquipmentSlot.HEAD : (inventorySlot == 100 + EntityEquipmentSlot.CHEST.func_188454_b() ? EntityEquipmentSlot.CHEST : (inventorySlot == 100 + EntityEquipmentSlot.LEGS.func_188454_b() ? EntityEquipmentSlot.LEGS : (inventorySlot == 100 + EntityEquipmentSlot.FEET.func_188454_b() ? EntityEquipmentSlot.FEET : null)));
        if (inventorySlot == 98) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemStackIn);
            return true;
        }
        if (inventorySlot == 99) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, itemStackIn);
            return true;
        }
        if (entityequipmentslot == null) {
            int i = inventorySlot - 200;
            if (i >= 0 && i < this.field_71078_a.func_70302_i_()) {
                this.field_71078_a.func_70299_a(i, itemStackIn);
                return true;
            }
            return false;
        }
        if (!itemStackIn.func_190926_b() && (!(itemStackIn.func_77973_b() instanceof ItemArmor) && !(itemStackIn.func_77973_b() instanceof ItemElytra) ? entityequipmentslot != EntityEquipmentSlot.HEAD : EntityLiving.func_184640_d(itemStackIn) != entityequipmentslot)) {
            return false;
        }
        this.field_71071_by.func_70299_a(entityequipmentslot.func_188454_b() + this.field_71071_by.field_70462_a.size(), itemStackIn);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_175140_cp() {
        return this.field_175153_bG;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_175150_k(boolean reducedDebug) {
        this.field_175153_bG = reducedDebug;
    }

    @Override
    public EnumHandSide func_184591_cq() {
        return this.field_70180_af.func_187225_a(field_184828_bq) == 0 ? EnumHandSide.LEFT : EnumHandSide.RIGHT;
    }

    public void func_184819_a(EnumHandSide hand) {
        this.field_70180_af.func_187227_b(field_184828_bq, (byte)(hand != EnumHandSide.LEFT ? 1 : 0));
    }

    public NBTTagCompound func_192023_dk() {
        return this.field_70180_af.func_187225_a(field_192032_bt);
    }

    protected void func_192029_h(NBTTagCompound tag) {
        this.field_70180_af.func_187227_b(field_192032_bt, tag);
    }

    public NBTTagCompound func_192025_dl() {
        return this.field_70180_af.func_187225_a(field_192033_bu);
    }

    protected void func_192031_i(NBTTagCompound tag) {
        this.field_70180_af.func_187227_b(field_192033_bu, tag);
    }

    public float func_184818_cX() {
        return (float)(1.0 / this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e() * 20.0);
    }

    public float func_184825_o(float adjustTicks) {
        return MathHelper.func_76131_a((float)(((float)this.field_184617_aD + adjustTicks) / this.func_184818_cX()), (float)0.0f, (float)1.0f);
    }

    public void func_184821_cY() {
        this.field_184617_aD = 0;
    }

    public CooldownTracker func_184811_cZ() {
        return this.field_184832_bU;
    }

    @Override
    public void func_70108_f(Entity entityIn) {
        if (!this.func_70608_bn()) {
            super.func_70108_f(entityIn);
        }
    }

    public float func_184817_da() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_188792_h).func_111126_e();
    }

    public boolean func_195070_dx() {
        return this.field_71075_bZ.field_75098_d && this.func_184840_I() >= 2;
    }

    public float getDefaultEyeHeight() {
        return 1.62f;
    }

    public DimensionType getSpawnDimension() {
        return this.spawnDimension;
    }

    public void setSpawnDimenion(DimensionType dim) {
        this.spawnDimension = dim;
    }

    public Collection<ITextComponent> getPrefixes() {
        return this.prefixes;
    }

    public Collection<ITextComponent> getSuffixes() {
        return this.suffixes;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return this.playerJoinedHandler.cast();
            }
            if (facing.func_176740_k().func_200128_b()) {
                return this.playerMainHandler.cast();
            }
            if (facing.func_176740_k().func_176722_c()) {
                return this.playerEquipmentHandler.cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    private static /* synthetic */ void lambda$getDisplayName$3(ITextComponent itextcomponent, ITextComponent e) {
        itextcomponent.func_150257_a(e);
    }

    private static /* synthetic */ void lambda$getDisplayName$2(ITextComponent itextcomponent, ITextComponent e) {
        itextcomponent.func_150257_a(e);
    }

    public static enum SleepResult {
        OK,
        NOT_POSSIBLE_HERE,
        NOT_POSSIBLE_NOW,
        TOO_FAR_AWAY,
        OTHER_PROBLEM,
        NOT_SAFE;

    }

    static class SleepEnemyPredicate
    implements Predicate<EntityMob> {
        private final EntityPlayer field_192387_a;

        private SleepEnemyPredicate(EntityPlayer playerIn) {
            this.field_192387_a = playerIn;
        }

        @Override
        public boolean test(@Nullable EntityMob p_test_1_) {
            return p_test_1_.func_191990_c(this.field_192387_a);
        }
    }

    public static enum EnumChatVisibility {
        FULL(0, "options.chat.visibility.full"),
        SYSTEM(1, "options.chat.visibility.system"),
        HIDDEN(2, "options.chat.visibility.hidden");

        private static final EnumChatVisibility[] field_151432_d;
        private final int field_151433_e;
        private final String field_151430_f;

        private EnumChatVisibility(int id, String resourceKey) {
            this.field_151433_e = id;
            this.field_151430_f = resourceKey;
        }

        public int func_151428_a() {
            return this.field_151433_e;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static EnumChatVisibility func_151426_a(int id) {
            return field_151432_d[id % field_151432_d.length];
        }

        @OnlyIn(value=Dist.CLIENT)
        public String func_151429_b() {
            return this.field_151430_f;
        }

        static {
            field_151432_d = (EnumChatVisibility[])Arrays.stream(EnumChatVisibility.values()).sorted(Comparator.comparingInt(EnumChatVisibility::func_151428_a)).toArray(EnumChatVisibility[]::new);
        }
    }
}

