/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySpellcasterIllager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityIllusionIllager
extends EntitySpellcasterIllager
implements IRangedAttackMob {
    private int field_193099_c;
    private final Vec3d[][] field_193100_bx;

    public EntityIllusionIllager(World worldIn) {
        super(EntityType.field_200764_D, worldIn);
        this.func_70105_a(0.6f, 1.95f);
        this.field_70728_aV = 5;
        this.field_193100_bx = new Vec3d[2][4];
        for (int i = 0; i < 4; ++i) {
            this.field_193100_bx[0][i] = new Vec3d(0.0, 0.0, 0.0);
            this.field_193100_bx[1][i] = new Vec3d(0.0, 0.0, 0.0);
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)((Object)this)));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntitySpellcasterIllager.AICastingApell((EntitySpellcasterIllager)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIMirriorSpell());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIBlindnessSpell());
        this.field_70714_bg.func_75776_a(6, new EntityAIAttackRangedBow<EntityIllusionIllager>(this, 0.5, 20, 15.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)((Object)this), EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)((Object)this), EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityIllusionIllager.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, false).func_190882_b(300));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(32.0);
    }

    public IEntityLivingData func_204210_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData, @Nullable NBTTagCompound itemNbt) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151031_f));
        return super.func_204210_a(difficulty, entityLivingData, itemNbt);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186419_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.func_82150_aj()) {
            --this.field_193099_c;
            if (this.field_193099_c < 0) {
                this.field_193099_c = 0;
            }
            if (this.field_70737_aN != 1 && this.field_70173_aa % 1200 != 0) {
                if (this.field_70737_aN == this.field_70738_aO - 1) {
                    this.field_193099_c = 3;
                    for (int k = 0; k < 4; ++k) {
                        this.field_193100_bx[0][k] = this.field_193100_bx[1][k];
                        this.field_193100_bx[1][k] = new Vec3d(0.0, 0.0, 0.0);
                    }
                }
            } else {
                this.field_193099_c = 3;
                float f = -6.0f;
                int i = 13;
                for (int j = 0; j < 4; ++j) {
                    this.field_193100_bx[0][j] = this.field_193100_bx[1][j];
                    this.field_193100_bx[1][j] = new Vec3d((double)(-6.0f + (float)this.field_70146_Z.nextInt(13)) * 0.5, Math.max(0, this.field_70146_Z.nextInt(6) - 4), (double)(-6.0f + (float)this.field_70146_Z.nextInt(13)) * 0.5);
                }
                for (int l = 0; l < 16; ++l) {
                    this.field_70170_p.func_195594_a((IParticleData)Particles.field_197613_f, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                }
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_193788_dg, this.func_184176_by(), 1.0f, 1.0f, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d[] func_193098_a(float p_193098_1_) {
        if (this.field_193099_c <= 0) {
            return this.field_193100_bx[1];
        }
        double d0 = ((float)this.field_193099_c - p_193098_1_) / 3.0f;
        d0 = Math.pow(d0, 0.25);
        Vec3d[] avec3d = new Vec3d[4];
        for (int i = 0; i < 4; ++i) {
            avec3d[i] = this.field_193100_bx[1][i].func_186678_a(1.0 - d0).func_178787_e(this.field_193100_bx[0][i].func_186678_a(d0));
        }
        return avec3d;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_70668_bt() == CreatureAttribute.ILLAGER) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_193783_dc;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_193786_de;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_193787_df;
    }

    protected SoundEvent func_193086_dk() {
        return SoundEvents.field_193784_dd;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityArrow entityarrow = this.func_193097_t(distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof ItemBow) {
            entityarrow = ((ItemBow)this.func_184614_ca().func_77973_b()).customizeArrow(entityarrow);
        }
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d(entityarrow);
    }

    protected EntityArrow func_193097_t(float p_193097_1_) {
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)((Object)this));
        entitytippedarrow.func_190547_a((EntityLivingBase)((Object)this), p_193097_1_);
        return entitytippedarrow;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_193096_dj() {
        return this.func_193078_a(1);
    }

    public void func_184724_a(boolean swingingArms) {
        this.func_193079_a(1, swingingArms);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllager.IllagerArmPose func_193077_p() {
        if (this.func_193082_dl()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return this.func_193096_dj() ? AbstractIllager.IllagerArmPose.BOW_AND_ARROW : AbstractIllager.IllagerArmPose.CROSSED;
    }

    class AIMirriorSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private AIMirriorSpell() {
            super((EntitySpellcasterIllager)EntityIllusionIllager.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            return !EntityIllusionIllager.this.func_70644_a(MobEffects.field_76441_p);
        }

        protected int func_190869_f() {
            return 20;
        }

        protected int func_190872_i() {
            return 340;
        }

        protected void func_190868_j() {
            EntityIllusionIllager.this.func_195064_c(new PotionEffect(MobEffects.field_76441_p, 1200));
        }

        @Nullable
        protected SoundEvent func_190871_k() {
            return SoundEvents.field_193790_di;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.DISAPPEAR;
        }
    }

    class AIBlindnessSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private int field_193325_b;

        private AIBlindnessSpell() {
            super((EntitySpellcasterIllager)EntityIllusionIllager.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntityIllusionIllager.this.func_70638_az() == null) {
                return false;
            }
            if (EntityIllusionIllager.this.func_70638_az().func_145782_y() == this.field_193325_b) {
                return false;
            }
            return EntityIllusionIllager.this.field_70170_p.func_175649_E(new BlockPos((Entity)((Object)EntityIllusionIllager.this))).func_193845_a((float)EnumDifficulty.NORMAL.ordinal());
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.field_193325_b = EntityIllusionIllager.this.func_70638_az().func_145782_y();
        }

        protected int func_190869_f() {
            return 20;
        }

        protected int func_190872_i() {
            return 180;
        }

        protected void func_190868_j() {
            EntityIllusionIllager.this.func_70638_az().func_195064_c(new PotionEffect(MobEffects.field_76440_q, 400));
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_193789_dh;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.BLINDNESS;
        }
    }
}

