/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySpellcasterIllager;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityEvoker
extends EntitySpellcasterIllager {
    private EntitySheep field_190763_bw;

    public EntityEvoker(World worldIn) {
        super(EntityType.field_200806_t, worldIn);
        this.func_70105_a(0.6f, 1.95f);
        this.field_70728_aV = 10;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)((Object)this)));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AICastingSpell());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AISummonSpell());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIAttackSpell());
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIWololoSpell());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)((Object)this), EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)((Object)this), EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityEvoker.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableList.field_191185_au;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (entityIn == this) {
            return true;
        }
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof EntityVex) {
            return this.func_184191_r(((EntityVex)entityIn).func_190645_o());
        }
        if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_70668_bt() == CreatureAttribute.ILLAGER) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191243_bm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191245_bo;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191246_bp;
    }

    private void func_190748_a(@Nullable EntitySheep wololoTargetIn) {
        this.field_190763_bw = wololoTargetIn;
    }

    @Nullable
    private EntitySheep func_190751_dj() {
        return this.field_190763_bw;
    }

    protected SoundEvent func_193086_dk() {
        return SoundEvents.field_191244_bn;
    }

    public class AIWololoSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private final Predicate<EntitySheep> field_190879_a;

        public AIWololoSpell() {
            super((EntitySpellcasterIllager)EntityEvoker.this);
            this.field_190879_a = p_200827_0_ -> p_200827_0_.func_175509_cj() == EnumDyeColor.BLUE;
        }

        public boolean func_75250_a() {
            if (EntityEvoker.this.func_70638_az() != null) {
                return false;
            }
            if (EntityEvoker.this.func_193082_dl()) {
                return false;
            }
            if (EntityEvoker.this.field_70173_aa < this.field_193322_d) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)EntityEvoker.this.field_70170_p, (Entity)((Object)EntityEvoker.this))) {
                return false;
            }
            List<EntitySheep> list = EntityEvoker.this.field_70170_p.func_175647_a(EntitySheep.class, EntityEvoker.this.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0), this.field_190879_a);
            if (list.isEmpty()) {
                return false;
            }
            EntityEvoker.this.func_190748_a(list.get(EntityEvoker.this.field_70146_Z.nextInt(list.size())));
            return true;
        }

        public boolean func_75253_b() {
            return EntityEvoker.this.func_190751_dj() != null && this.field_193321_c > 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityEvoker.this.func_190748_a(null);
        }

        protected void func_190868_j() {
            EntitySheep entitysheep = EntityEvoker.this.func_190751_dj();
            if (entitysheep != null && entitysheep.func_70089_S()) {
                entitysheep.func_175512_b(EnumDyeColor.RED);
            }
        }

        protected int func_190867_m() {
            return 40;
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 140;
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191249_bs;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.WOLOLO;
        }
    }

    class AISummonSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private AISummonSpell() {
            super((EntitySpellcasterIllager)EntityEvoker.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            int i = EntityEvoker.this.field_70170_p.func_72872_a(EntityVex.class, EntityEvoker.this.func_174813_aQ().func_186662_g(16.0)).size();
            return EntityEvoker.this.field_70146_Z.nextInt(8) + 1 > i;
        }

        protected int func_190869_f() {
            return 100;
        }

        protected int func_190872_i() {
            return 340;
        }

        protected void func_190868_j() {
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos = new BlockPos((Entity)((Object)EntityEvoker.this)).func_177982_a(-2 + EntityEvoker.this.field_70146_Z.nextInt(5), 1, -2 + EntityEvoker.this.field_70146_Z.nextInt(5));
                EntityVex entityvex = new EntityVex(EntityEvoker.this.field_70170_p);
                entityvex.func_174828_a(blockpos, 0.0f, 0.0f);
                entityvex.func_204210_a(EntityEvoker.this.field_70170_p.func_175649_E(blockpos), (IEntityLivingData)null, (NBTTagCompound)null);
                entityvex.func_190658_a((EntityLiving)((Object)EntityEvoker.this));
                entityvex.func_190651_g(blockpos);
                entityvex.func_190653_a(20 * (30 + EntityEvoker.this.field_70146_Z.nextInt(90)));
                EntityEvoker.this.field_70170_p.func_72838_d((Entity)entityvex);
            }
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191248_br;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.SUMMON_VEX;
        }
    }

    class AICastingSpell
    extends EntitySpellcasterIllager.AICastingApell {
        private AICastingSpell() {
            super((EntitySpellcasterIllager)EntityEvoker.this);
        }

        public void func_75246_d() {
            if (EntityEvoker.this.func_70638_az() != null) {
                EntityEvoker.this.func_70671_ap().func_75651_a((Entity)EntityEvoker.this.func_70638_az(), (float)EntityEvoker.this.func_184649_cE(), (float)EntityEvoker.this.func_70646_bf());
            } else if (EntityEvoker.this.func_190751_dj() != null) {
                EntityEvoker.this.func_70671_ap().func_75651_a((Entity)((Object)EntityEvoker.this.func_190751_dj()), (float)EntityEvoker.this.func_184649_cE(), (float)EntityEvoker.this.func_70646_bf());
            }
        }
    }

    class AIAttackSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private AIAttackSpell() {
            super((EntitySpellcasterIllager)EntityEvoker.this);
        }

        protected int func_190869_f() {
            return 40;
        }

        protected int func_190872_i() {
            return 100;
        }

        protected void func_190868_j() {
            EntityLivingBase entitylivingbase = EntityEvoker.this.func_70638_az();
            double d0 = Math.min(entitylivingbase.field_70163_u, EntityEvoker.this.field_70163_u);
            double d1 = Math.max(entitylivingbase.field_70163_u, EntityEvoker.this.field_70163_u) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.field_70161_v - EntityEvoker.this.field_70161_v), (double)(entitylivingbase.field_70165_t - EntityEvoker.this.field_70165_t));
            if (EntityEvoker.this.func_70068_e(entitylivingbase) < 9.0) {
                for (int i = 0; i < 5; ++i) {
                    float f1 = f + (float)i * (float)Math.PI * 0.4f;
                    this.func_190876_a(EntityEvoker.this.field_70165_t + (double)MathHelper.func_76134_b((float)f1) * 1.5, EntityEvoker.this.field_70161_v + (double)MathHelper.func_76126_a((float)f1) * 1.5, d0, d1, f1, 0);
                }
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.func_190876_a(EntityEvoker.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 2.5, EntityEvoker.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 2.5, d0, d1, f2, 3);
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = 1 * l;
                    this.func_190876_a(EntityEvoker.this.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, EntityEvoker.this.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
                }
            }
        }

        private void func_190876_a(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                IBlockState iblockstate;
                VoxelShape voxelshape;
                if (EntityEvoker.this.field_70170_p.func_195595_w(blockpos) || !EntityEvoker.this.field_70170_p.func_195595_w(blockpos.func_177977_b())) continue;
                if (!EntityEvoker.this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (iblockstate = EntityEvoker.this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)EntityEvoker.this.field_70170_p, blockpos)).func_197766_b()) {
                    d0 = voxelshape.func_197758_c(EnumFacing.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                EntityEvokerFangs entityevokerfangs = new EntityEvokerFangs(EntityEvoker.this.field_70170_p, p_190876_1_, (double)blockpos.func_177956_o() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (EntityLivingBase)((Object)EntityEvoker.this));
                EntityEvoker.this.field_70170_p.func_72838_d((Entity)entityevokerfangs);
            }
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191247_bq;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.FANGS;
        }
    }
}

