/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SharedMonsterAttributes {
    private static final Logger field_151476_f = LogManager.getLogger();
    public static final IAttribute field_111267_a = new RangedAttribute((IAttribute)null, "generic.maxHealth", 20.0, (double)1.4E-45f, 1024.0).func_111117_a("Max Health").func_111112_a(true);
    public static final IAttribute field_111265_b = new RangedAttribute((IAttribute)null, "generic.followRange", 32.0, 0.0, 2048.0).func_111117_a("Follow Range");
    public static final IAttribute field_111266_c = new RangedAttribute((IAttribute)null, "generic.knockbackResistance", 0.0, 0.0, 1.0).func_111117_a("Knockback Resistance");
    public static final IAttribute field_111263_d = new RangedAttribute((IAttribute)null, "generic.movementSpeed", (double)0.7f, 0.0, 1024.0).func_111117_a("Movement Speed").func_111112_a(true);
    public static final IAttribute field_193334_e = new RangedAttribute((IAttribute)null, "generic.flyingSpeed", (double)0.4f, 0.0, 1024.0).func_111117_a("Flying Speed").func_111112_a(true);
    public static final IAttribute field_111264_e = new RangedAttribute((IAttribute)null, "generic.attackDamage", 2.0, 0.0, 2048.0);
    public static final IAttribute field_188790_f = new RangedAttribute((IAttribute)null, "generic.attackSpeed", 4.0, 0.0, 1024.0).func_111112_a(true);
    public static final IAttribute field_188791_g = new RangedAttribute((IAttribute)null, "generic.armor", 0.0, 0.0, 30.0).func_111112_a(true);
    public static final IAttribute field_189429_h = new RangedAttribute((IAttribute)null, "generic.armorToughness", 0.0, 0.0, 20.0).func_111112_a(true);
    public static final IAttribute field_188792_h = new RangedAttribute((IAttribute)null, "generic.luck", 0.0, -1024.0, 1024.0).func_111112_a(true);

    public static NBTTagList func_111257_a(AbstractAttributeMap map) {
        NBTTagList nbttaglist = new NBTTagList();
        for (IAttributeInstance iattributeinstance : map.func_111146_a()) {
            nbttaglist.add((INBTBase)SharedMonsterAttributes.func_111261_a(iattributeinstance));
        }
        return nbttaglist;
    }

    private static NBTTagCompound func_111261_a(IAttributeInstance instance) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        IAttribute iattribute = instance.func_111123_a();
        nbttagcompound.func_74778_a("Name", iattribute.func_111108_a());
        nbttagcompound.func_74780_a("Base", instance.func_111125_b());
        Collection collection = instance.func_111122_c();
        if (collection != null && !collection.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (AttributeModifier attributemodifier : collection) {
                if (!attributemodifier.func_111165_e()) continue;
                nbttaglist.add((INBTBase)SharedMonsterAttributes.func_111262_a(attributemodifier));
            }
            nbttagcompound.func_74782_a("Modifiers", (INBTBase)nbttaglist);
        }
        return nbttagcompound;
    }

    public static NBTTagCompound func_111262_a(AttributeModifier modifier) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74778_a("Name", modifier.func_111166_b());
        nbttagcompound.func_74780_a("Amount", modifier.func_111164_d());
        nbttagcompound.func_74768_a("Operation", modifier.func_111169_c());
        nbttagcompound.func_186854_a("UUID", modifier.func_111167_a());
        return nbttagcompound;
    }

    public static void func_151475_a(AbstractAttributeMap map, NBTTagList list) {
        for (int i = 0; i < list.size(); ++i) {
            NBTTagCompound nbttagcompound = list.func_150305_b(i);
            IAttributeInstance iattributeinstance = map.func_111152_a(nbttagcompound.func_74779_i("Name"));
            if (iattributeinstance == null) {
                field_151476_f.warn("Ignoring unknown attribute '{}'", (Object)nbttagcompound.func_74779_i("Name"));
                continue;
            }
            SharedMonsterAttributes.func_111258_a(iattributeinstance, nbttagcompound);
        }
    }

    private static void func_111258_a(IAttributeInstance instance, NBTTagCompound compound) {
        instance.func_111128_a(compound.func_74769_h("Base"));
        if (compound.func_150297_b("Modifiers", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("Modifiers", 10);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                AttributeModifier attributemodifier = SharedMonsterAttributes.func_111259_a(nbttaglist.func_150305_b(i));
                if (attributemodifier == null) continue;
                AttributeModifier attributemodifier1 = instance.func_111127_a(attributemodifier.func_111167_a());
                if (attributemodifier1 != null) {
                    instance.func_111124_b(attributemodifier1);
                }
                instance.func_111121_a(attributemodifier);
            }
        }
    }

    @Nullable
    public static AttributeModifier func_111259_a(NBTTagCompound compound) {
        UUID uuid = compound.func_186857_a("UUID");
        try {
            return new AttributeModifier(uuid, compound.func_74779_i("Name"), compound.func_74769_h("Amount"), compound.func_74762_e("Operation"));
        }
        catch (Exception exception) {
            field_151476_f.warn("Unable to create attribute: {}", (Object)exception.getMessage());
            return null;
        }
    }
}

