/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.enchantment.EnchantmentFrostWalker;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.fluid.Fluid;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.network.play.server.SPacketCollectItem;
import net.minecraft.network.play.server.SPacketEntityEquipment;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtil;
import net.minecraft.potion.PotionUtils;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.state.IProperty;
import net.minecraft.stats.StatList;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.CombatRules;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.PotionColorCalculationEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.EntityEquipmentInvWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EntityLivingBase
extends Entity {
    private static final Logger field_190632_a = LogManager.getLogger();
    private static final UUID field_110156_b = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
    private static final AttributeModifier field_110157_c = new AttributeModifier(field_110156_b, "Sprinting speed boost", (double)0.3f, 2).func_111168_a(false);
    public static final IAttribute SWIM_SPEED = new RangedAttribute(null, "forge.swimSpeed", 1.0, 0.0, 1024.0).func_111112_a(true);
    public static final IAttribute NAMETAG_DISTANCE = new RangedAttribute(null, "forge.nameTagDistance", 64.0, 0.0, 3.4028234663852886E38).func_111112_a(true);
    protected static final DataParameter<Byte> field_184621_as = EntityDataManager.func_187226_a(EntityLivingBase.class, DataSerializers.field_187191_a);
    private static final DataParameter<Float> field_184632_c = EntityDataManager.func_187226_a(EntityLivingBase.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184633_f = EntityDataManager.func_187226_a(EntityLivingBase.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_184634_g = EntityDataManager.func_187226_a(EntityLivingBase.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_184635_h = EntityDataManager.func_187226_a(EntityLivingBase.class, DataSerializers.field_187192_b);
    private AbstractAttributeMap field_110155_d;
    private final CombatTracker field_94063_bt = new CombatTracker(this);
    private final Map<Potion, PotionEffect> field_70713_bf = Maps.newHashMap();
    private final NonNullList<ItemStack> field_184630_bs = NonNullList.func_191197_a((int)2, (Object)((Object)ItemStack.field_190927_a));
    private final NonNullList<ItemStack> field_184631_bt = NonNullList.func_191197_a((int)4, (Object)((Object)ItemStack.field_190927_a));
    public boolean field_82175_bq;
    public EnumHand field_184622_au;
    public int field_110158_av;
    public int field_70720_be;
    public int field_70737_aN;
    public int field_70738_aO;
    public float field_70739_aP;
    public int field_70725_aQ;
    public float field_70732_aI;
    public float field_70733_aJ;
    protected int field_184617_aD;
    public float field_184618_aE;
    public float field_70721_aZ;
    public float field_184619_aG;
    public int field_70771_an = 20;
    public float field_70727_aS;
    public float field_70726_aT;
    public float field_70769_ao;
    public float field_70770_ap;
    public float field_70761_aq;
    public float field_70760_ar;
    public float field_70759_as;
    public float field_70758_at;
    public float field_70747_aH = 0.02f;
    protected EntityPlayer field_70717_bb;
    protected int field_70718_bc;
    protected boolean field_70729_aU;
    protected int field_70708_bq;
    protected float field_70768_au;
    protected float field_110154_aX;
    protected float field_70764_aw;
    protected float field_70763_ax;
    protected float field_70741_aB;
    protected int field_70744_aE;
    protected float field_110153_bc;
    protected boolean field_70703_bu;
    public float field_70702_br;
    public float field_70701_bs;
    public float field_191988_bg;
    public float field_70704_bt;
    protected int field_70716_bi;
    protected double field_184623_bh;
    protected double field_184624_bi;
    protected double field_184625_bj;
    protected double field_184626_bk;
    protected double field_70709_bj;
    protected double field_208001_bq;
    protected int field_208002_br;
    private boolean field_70752_e = true;
    private EntityLivingBase field_70755_b;
    private int field_70756_c;
    private EntityLivingBase field_110150_bn;
    private int field_142016_bo;
    private float field_70746_aG;
    private int field_70773_bE;
    private float field_110151_bq;
    protected ItemStack field_184627_bm = ItemStack.field_190927_a;
    protected int field_184628_bn;
    protected int field_184629_bo;
    private BlockPos field_184620_bC;
    private DamageSource field_189750_bF;
    private long field_189751_bG;
    protected int field_204807_bs;
    private float field_205017_bL;
    private float field_205018_bM;
    private final LazyOptional<?>[] handlers = EntityEquipmentInvWrapper.create((EntityLivingBase)this);

    protected EntityLivingBase(EntityType<?> type, World p_i48577_2_) {
        super(type, p_i48577_2_);
        this.func_110147_ax();
        this.func_70606_j(this.func_110138_aP());
        this.field_70156_m = true;
        this.field_70770_ap = (float)((Math.random() + 1.0) * (double)0.01f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70769_ao = (float)Math.random() * 12398.0f;
        this.field_70759_as = this.field_70177_z = (float)(Math.random() * 6.2831854820251465);
        this.field_70138_W = 0.6f;
    }

    @Override
    public void func_174812_G() {
        this.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184621_as, (byte)0);
        this.field_70180_af.func_187214_a(field_184633_f, 0);
        this.field_70180_af.func_187214_a(field_184634_g, false);
        this.field_70180_af.func_187214_a(field_184635_h, 0);
        this.field_70180_af.func_187214_a(field_184632_c, Float.valueOf(1.0f));
    }

    protected void func_110147_ax() {
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111267_a);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111266_c);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111263_d);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188791_g);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_189429_h);
        this.func_110140_aT().func_111150_b(SWIM_SPEED);
        this.func_110140_aT().func_111150_b(NAMETAG_DISTANCE);
    }

    @Override
    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.func_70090_H()) {
            this.func_70072_I();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70143_R > 3.0f && onGroundIn) {
            double d0;
            int i;
            float f = MathHelper.func_76123_f((float)(this.field_70143_R - 3.0f));
            if (!state.isAir((IBlockReader)this.field_70170_p, pos) && !state.addLandingEffects((WorldServer)this.field_70170_p, pos, state, this, i = (int)(150.0 * (d0 = Math.min((double)(0.2f + f / 15.0f), 2.5))))) {
                ((WorldServer)this.field_70170_p).func_195598_a(new BlockParticleData(Particles.field_197611_d, state), this.field_70165_t, this.field_70163_u, this.field_70161_v, i, 0.0, 0.0, 0.0, 0.15f);
            }
        }
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    public boolean func_70648_aU() {
        return this.func_70668_bt() == CreatureAttribute.UNDEAD;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_205015_b(float partialTicks) {
        return this.func_205016_b(this.field_205018_bM, this.field_205017_bL, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected float func_205016_b(float p_205016_1_, float p_205016_2_, float partialTicks) {
        return p_205016_1_ + (p_205016_2_ - p_205016_1_) * partialTicks;
    }

    @Override
    public void func_70030_z() {
        boolean flag1;
        this.field_70732_aI = this.field_70733_aJ;
        super.func_70030_z();
        this.field_70170_p.field_72984_F.func_76320_a("livingEntityBaseTick");
        boolean flag = this instanceof EntityPlayer;
        if (this.func_70089_S()) {
            double d1;
            double d0;
            if (this.func_70094_T()) {
                this.func_70097_a(DamageSource.field_76368_d, 1.0f);
            } else if (flag && !this.field_70170_p.func_175723_af().func_177743_a(this.func_174813_aQ()) && (d0 = this.field_70170_p.func_175723_af().func_177745_a(this) + this.field_70170_p.func_175723_af().func_177742_m()) < 0.0 && (d1 = this.field_70170_p.func_175723_af().func_177727_n()) > 0.0) {
                this.func_70097_a(DamageSource.field_76368_d, Math.max(1, MathHelper.func_76128_c((double)(-d0 * d1))));
            }
        }
        if (this.func_70045_F() || this.field_70170_p.field_72995_K) {
            this.func_70066_B();
        }
        boolean bl = flag1 = flag && ((EntityPlayer)this).field_71075_bZ.field_75102_a;
        if (this.func_70089_S()) {
            BlockPos blockpos;
            if (this.func_208600_a(FluidTags.field_206959_a) && this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v)).func_177230_c() != Blocks.field_203203_C) {
                if (!(this.func_70648_aU() || PotionUtil.func_205133_c((EntityLivingBase)this) || flag1)) {
                    this.func_70050_g(this.func_70682_h(this.func_70086_ai()));
                    if (this.func_70086_ai() == -20) {
                        this.func_70050_g(0);
                        for (int i = 0; i < 8; ++i) {
                            float f2 = this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat();
                            float f = this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat();
                            float f1 = this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat();
                            this.field_70170_p.func_195594_a((IParticleData)Particles.field_197612_e, this.field_70165_t + (double)f2, this.field_70163_u + (double)f, this.field_70161_v + (double)f1, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                        }
                        this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                    }
                }
                if (!this.field_70170_p.field_72995_K && this.func_184218_aH() && this.func_184187_bx() != null && !this.func_184187_bx().canBeRiddenInWater(this)) {
                    this.func_184210_p();
                }
            } else if (this.func_70086_ai() < this.func_205010_bg()) {
                this.func_70050_g(this.func_207300_l(this.func_70086_ai()));
            }
            if (!this.field_70170_p.field_72995_K && !Objects.equal((Object)this.field_184620_bC, (Object)(blockpos = new BlockPos((Entity)this)))) {
                this.field_184620_bC = blockpos;
                this.func_184594_b(blockpos);
            }
        }
        if (this.func_70089_S() && this.func_203008_ap()) {
            this.func_70066_B();
        }
        this.field_70727_aS = this.field_70726_aT;
        if (this.field_70737_aN > 0) {
            --this.field_70737_aN;
        }
        if (this.field_70172_ad > 0 && !(this instanceof EntityPlayerMP)) {
            --this.field_70172_ad;
        }
        if (this.func_110143_aJ() <= 0.0f) {
            this.func_70609_aI();
        }
        if (this.field_70718_bc > 0) {
            --this.field_70718_bc;
        } else {
            this.field_70717_bb = null;
        }
        if (this.field_110150_bn != null && !this.field_110150_bn.func_70089_S()) {
            this.field_110150_bn = null;
        }
        if (this.field_70755_b != null) {
            if (!this.field_70755_b.func_70089_S()) {
                this.func_70604_c(null);
            } else if (this.field_70173_aa - this.field_70756_c > 100) {
                this.func_70604_c(null);
            }
        }
        this.func_70679_bo();
        this.field_70763_ax = this.field_70764_aw;
        this.field_70760_ar = this.field_70761_aq;
        this.field_70758_at = this.field_70759_as;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    protected void func_184594_b(BlockPos pos) {
        int i = EnchantmentHelper.func_185284_a(Enchantments.field_185301_j, this);
        if (i > 0) {
            EnchantmentFrostWalker.func_185266_a(this, this.field_70170_p, pos, i);
        }
    }

    public boolean func_70631_g_() {
        return false;
    }

    @Override
    public boolean func_205710_ba() {
        return false;
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a(i);
                    this.field_70170_p.func_72838_d(new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)Particles.field_197598_I, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1);
            }
        }
    }

    protected boolean func_146066_aG() {
        return !this.func_70631_g_();
    }

    protected int func_70682_h(int air) {
        int i = EnchantmentHelper.func_185292_c(this);
        return i > 0 && this.field_70146_Z.nextInt(i + 1) > 0 ? air : air - 1;
    }

    protected int func_207300_l(int currentAir) {
        return Math.min(currentAir + 4, this.func_205010_bg());
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    protected boolean func_70684_aJ() {
        return false;
    }

    public Random func_70681_au() {
        return this.field_70146_Z;
    }

    @Nullable
    public EntityLivingBase func_70643_av() {
        return this.field_70755_b;
    }

    public int func_142015_aE() {
        return this.field_70756_c;
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        this.field_70755_b = livingBase;
        this.field_70756_c = this.field_70173_aa;
    }

    public EntityLivingBase func_110144_aD() {
        return this.field_110150_bn;
    }

    public int func_142013_aG() {
        return this.field_142016_bo;
    }

    public void func_130011_c(Entity entityIn) {
        this.field_110150_bn = entityIn instanceof EntityLivingBase ? (EntityLivingBase)entityIn : null;
        this.field_142016_bo = this.field_70173_aa;
    }

    public int func_70654_ax() {
        return this.field_70708_bq;
    }

    protected void func_184606_a_(ItemStack stack) {
        if (!stack.func_190926_b()) {
            SoundEvent soundevent = SoundEvents.field_187719_p;
            Item item = stack.func_77973_b();
            if (item instanceof ItemArmor) {
                soundevent = ((ItemArmor)item).func_200880_d().func_200899_b();
            } else if (item == Items.field_185160_cR) {
                soundevent = SoundEvents.field_191258_p;
            }
            this.func_184185_a(soundevent, 1.0f, 1.0f);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("Health", this.func_110143_aJ());
        compound.func_74777_a("HurtTime", (short)this.field_70737_aN);
        compound.func_74768_a("HurtByTimestamp", this.field_70756_c);
        compound.func_74777_a("DeathTime", (short)this.field_70725_aQ);
        compound.func_74776_a("AbsorptionAmount", this.func_110139_bj());
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            ItemStack itemstack = this.func_184582_a(entityequipmentslot);
            if (itemstack.func_190926_b()) continue;
            this.func_110140_aT().func_111148_a(itemstack.func_111283_C(entityequipmentslot));
        }
        compound.func_74782_a("Attributes", (INBTBase)SharedMonsterAttributes.func_111257_a(this.func_110140_aT()));
        for (EntityEquipmentSlot entityequipmentslot1 : EntityEquipmentSlot.values()) {
            ItemStack itemstack1 = this.func_184582_a(entityequipmentslot1);
            if (itemstack1.func_190926_b()) continue;
            this.func_110140_aT().func_111147_b(itemstack1.func_111283_C(entityequipmentslot1));
        }
        if (!this.field_70713_bf.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (PotionEffect potioneffect : this.field_70713_bf.values()) {
                nbttaglist.add((INBTBase)potioneffect.func_82719_a(new NBTTagCompound()));
            }
            compound.func_74782_a("ActiveEffects", (INBTBase)nbttaglist);
        }
        compound.func_74757_a("FallFlying", this.func_184613_cA());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.func_110149_m(compound.func_74760_g("AbsorptionAmount"));
        if (compound.func_150297_b("Attributes", 9) && this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            SharedMonsterAttributes.func_151475_a(this.func_110140_aT(), compound.func_150295_c("Attributes", 10));
        }
        if (compound.func_150297_b("ActiveEffects", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("ActiveEffects", 10);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                PotionEffect potioneffect = PotionEffect.func_82722_b(nbttagcompound);
                if (potioneffect == null) continue;
                this.field_70713_bf.put(potioneffect.func_188419_a(), potioneffect);
            }
        }
        if (compound.func_150297_b("Health", 99)) {
            this.func_70606_j(compound.func_74760_g("Health"));
        }
        this.field_70737_aN = compound.func_74765_d("HurtTime");
        this.field_70725_aQ = compound.func_74765_d("DeathTime");
        this.field_70756_c = compound.func_74762_e("HurtByTimestamp");
        if (compound.func_150297_b("Team", 8)) {
            boolean flag;
            String s = compound.func_74779_i("Team");
            ScorePlayerTeam scoreplayerteam = this.field_70170_p.func_96441_U().func_96508_e(s);
            boolean bl = flag = scoreplayerteam != null && this.field_70170_p.func_96441_U().func_197901_a(this.func_189512_bd(), scoreplayerteam);
            if (!flag) {
                field_190632_a.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)s);
            }
        }
        if (compound.func_74767_n("FallFlying")) {
            this.func_70052_a(7, true);
        }
    }

    protected void func_70679_bo() {
        Iterator<Potion> iterator = this.field_70713_bf.keySet().iterator();
        try {
            while (iterator.hasNext()) {
                Potion potion = iterator.next();
                PotionEffect potioneffect = this.field_70713_bf.get((Object)potion);
                if (!potioneffect.func_76455_a(this)) {
                    if (this.field_70170_p.field_72995_K || MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionExpiryEvent(this, potioneffect))) continue;
                    iterator.remove();
                    this.func_70688_c(potioneffect);
                    continue;
                }
                if (potioneffect.func_76459_b() % 600 != 0) continue;
                this.func_70695_b(potioneffect, false);
            }
        }
        catch (ConcurrentModificationException potion) {
            // empty catch block
        }
        if (this.field_70752_e) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_175135_B();
            }
            this.field_70752_e = false;
        }
        int i = this.field_70180_af.func_187225_a(field_184633_f);
        boolean flag1 = this.field_70180_af.func_187225_a(field_184634_g);
        if (i > 0) {
            boolean flag = this.func_82150_aj() ? this.field_70146_Z.nextInt(15) == 0 : this.field_70146_Z.nextBoolean();
            if (flag1) {
                flag &= this.field_70146_Z.nextInt(5) == 0;
            }
            if (flag && i > 0) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                this.field_70170_p.func_195594_a((IParticleData)(flag1 ? Particles.field_197608_a : Particles.field_197625_r), this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d0, d1, d2);
            }
        }
    }

    protected void func_175135_B() {
        if (this.field_70713_bf.isEmpty()) {
            this.func_175133_bi();
            this.func_82142_c(false);
        } else {
            Collection<PotionEffect> collection = this.field_70713_bf.values();
            PotionColorCalculationEvent event = new PotionColorCalculationEvent(this, PotionUtils.func_185181_a(collection), EntityLivingBase.func_184593_a(collection), collection);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.field_70180_af.func_187227_b(field_184634_g, event.areParticlesHidden());
            this.field_70180_af.func_187227_b(field_184633_f, event.getColor());
            this.func_82142_c(this.func_70644_a(MobEffects.field_76441_p));
        }
    }

    public static boolean func_184593_a(Collection<PotionEffect> potionEffects) {
        for (PotionEffect potioneffect : potionEffects) {
            if (potioneffect.func_82720_e()) continue;
            return false;
        }
        return true;
    }

    protected void func_175133_bi() {
        this.field_70180_af.func_187227_b(field_184634_g, false);
        this.field_70180_af.func_187227_b(field_184633_f, 0);
    }

    public boolean func_195061_cb() {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        Iterator<PotionEffect> iterator = this.field_70713_bf.values().iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            PotionEffect effect = iterator.next();
            if (!MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionRemoveEvent(this, effect))) {
                this.func_70688_c(effect);
                iterator.remove();
            }
            flag = true;
        }
        return flag;
    }

    public boolean curePotionEffects(ItemStack curativeItem) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean ret = false;
        Iterator<PotionEffect> itr = this.field_70713_bf.values().iterator();
        while (itr.hasNext()) {
            PotionEffect effect = itr.next();
            if (!effect.isCurativeItem(curativeItem) || MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionRemoveEvent(this, effect))) continue;
            this.func_70688_c(effect);
            itr.remove();
            ret = true;
            this.field_70752_e = true;
        }
        return ret;
    }

    public Collection<PotionEffect> func_70651_bq() {
        return this.field_70713_bf.values();
    }

    public Map<Potion, PotionEffect> func_193076_bZ() {
        return this.field_70713_bf;
    }

    public boolean func_70644_a(Potion potionIn) {
        return this.field_70713_bf.containsKey((Object)potionIn);
    }

    @Nullable
    public PotionEffect func_70660_b(Potion potionIn) {
        return this.field_70713_bf.get((Object)potionIn);
    }

    public boolean func_195064_c(PotionEffect p_195064_1_) {
        if (!this.func_70687_e(p_195064_1_)) {
            return false;
        }
        PotionEffect potioneffect = this.field_70713_bf.get((Object)p_195064_1_.func_188419_a());
        MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionAddedEvent(this, potioneffect, p_195064_1_));
        if (potioneffect == null) {
            this.field_70713_bf.put(p_195064_1_.func_188419_a(), p_195064_1_);
            this.func_70670_a(p_195064_1_);
            return true;
        }
        if (potioneffect.func_199308_a(p_195064_1_)) {
            this.func_70695_b(potioneffect, true);
            return true;
        }
        return false;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        Potion potion;
        PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent(this, potioneffectIn);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() != Event.Result.DEFAULT) {
            return event.getResult() == Event.Result.ALLOW;
        }
        return this.func_70668_bt() != CreatureAttribute.UNDEAD || (potion = potioneffectIn.func_188419_a()) != MobEffects.field_76428_l && potion != MobEffects.field_76436_u;
    }

    public boolean func_70662_br() {
        return this.func_70668_bt() == CreatureAttribute.UNDEAD;
    }

    @Nullable
    public PotionEffect func_184596_c(@Nullable Potion potioneffectin) {
        return this.field_70713_bf.remove((Object)potioneffectin);
    }

    public boolean func_195063_d(Potion p_195063_1_) {
        if (MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionRemoveEvent(this, p_195063_1_))) {
            return false;
        }
        PotionEffect potioneffect = this.func_184596_c(p_195063_1_);
        if (potioneffect != null) {
            this.func_70688_c(potioneffect);
            return true;
        }
        return false;
    }

    protected void func_70670_a(PotionEffect id) {
        this.field_70752_e = true;
        if (!this.field_70170_p.field_72995_K) {
            id.func_188419_a().func_111185_a(this, this.func_110140_aT(), id.func_76458_c());
        }
    }

    protected void func_70695_b(PotionEffect id, boolean p_70695_2_) {
        this.field_70752_e = true;
        if (p_70695_2_ && !this.field_70170_p.field_72995_K) {
            Potion potion = id.func_188419_a();
            potion.func_111187_a(this, this.func_110140_aT(), id.func_76458_c());
            potion.func_111185_a(this, this.func_110140_aT(), id.func_76458_c());
        }
    }

    protected void func_70688_c(PotionEffect effect) {
        this.field_70752_e = true;
        if (!this.field_70170_p.field_72995_K) {
            effect.func_188419_a().func_111187_a(this, this.func_110140_aT(), effect.func_76458_c());
        }
    }

    public void func_70691_i(float healAmount) {
        if ((healAmount = ForgeEventFactory.onLivingHeal((EntityLivingBase)this, (float)healAmount)) <= 0.0f) {
            return;
        }
        float f = this.func_110143_aJ();
        if (f > 0.0f) {
            this.func_70606_j(f + healAmount);
        }
    }

    public float func_110143_aJ() {
        return this.field_70180_af.func_187225_a(field_184632_c).floatValue();
    }

    public void func_70606_j(float health) {
        this.field_70180_af.func_187227_b(field_184632_c, Float.valueOf(MathHelper.func_76131_a((float)health, (float)0.0f, (float)this.func_110138_aP())));
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag2;
        if (!ForgeHooks.onLivingAttack((EntityLivingBase)this, (DamageSource)source, (float)amount)) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (source.func_76347_k() && this.func_70644_a(MobEffects.field_76426_n)) {
            return false;
        }
        this.field_70708_bq = 0;
        float f = amount;
        if (!(source != DamageSource.field_82728_o && source != DamageSource.field_82729_p || this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b())) {
            this.func_184582_a(EntityEquipmentSlot.HEAD).func_77972_a((int)(amount * 4.0f + this.field_70146_Z.nextFloat() * amount * 2.0f), this);
            amount *= 0.75f;
        }
        boolean flag = false;
        float f1 = 0.0f;
        if (amount > 0.0f && this.func_184583_d(source)) {
            Entity entity;
            this.func_184590_k(amount);
            f1 = amount;
            amount = 0.0f;
            if (!source.func_76352_a() && (entity = source.func_76364_f()) instanceof EntityLivingBase) {
                this.func_190629_c((EntityLivingBase)entity);
            }
            flag = true;
        }
        this.field_70721_aZ = 1.5f;
        boolean flag1 = true;
        if ((float)this.field_70172_ad > (float)this.field_70771_an / 2.0f) {
            if (amount <= this.field_110153_bc) {
                return false;
            }
            this.func_70665_d(source, amount - this.field_110153_bc);
            this.field_110153_bc = amount;
            flag1 = false;
        } else {
            this.field_110153_bc = amount;
            this.field_70172_ad = this.field_70771_an;
            this.func_70665_d(source, amount);
            this.field_70737_aN = this.field_70738_aO = 10;
        }
        this.field_70739_aP = 0.0f;
        Entity entity1 = source.func_76346_g();
        if (entity1 != null) {
            EntityTameable entitywolf;
            if (entity1 instanceof EntityLivingBase) {
                this.func_70604_c((EntityLivingBase)entity1);
            }
            if (entity1 instanceof EntityPlayer) {
                this.field_70718_bc = 100;
                this.field_70717_bb = (EntityPlayer)entity1;
            } else if (entity1 instanceof EntityTameable && (entitywolf = (EntityTameable)entity1).func_70909_n()) {
                this.field_70718_bc = 100;
                this.field_70717_bb = null;
            }
        }
        if (flag1) {
            if (flag) {
                this.field_70170_p.func_72960_a(this, (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
                this.field_70170_p.func_72960_a(this, (byte)33);
            } else {
                byte b0 = source == DamageSource.field_76369_e ? (byte)36 : (source.func_76347_k() ? (byte)37 : 2);
                this.field_70170_p.func_72960_a(this, b0);
            }
            if (source != DamageSource.field_76369_e && (!flag || amount > 0.0f)) {
                this.func_70018_K();
            }
            if (entity1 != null) {
                double d1 = entity1.field_70165_t - this.field_70165_t;
                double d0 = entity1.field_70161_v - this.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.2957763671875 - (double)this.field_70177_z);
                this.func_70653_a(entity1, 0.4f, d1, d0);
            } else {
                this.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            if (!this.func_190628_d(source)) {
                SoundEvent soundevent = this.func_184615_bR();
                if (flag1 && soundevent != null) {
                    this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
                }
                this.func_70645_a(source);
            }
        } else if (flag1) {
            this.func_184581_c(source);
        }
        boolean bl = flag2 = !flag || amount > 0.0f;
        if (flag2) {
            this.field_189750_bF = source;
            this.field_189751_bG = this.field_70170_p.func_82737_E();
        }
        if (this instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192128_h.func_192200_a((EntityPlayerMP)this, source, f, amount, flag);
            if (f1 > 0.0f && f1 < 3.4028235E37f) {
                ((EntityPlayerMP)this).func_195067_a(StatList.field_212737_I, Math.round(f1 * 10.0f));
            }
        }
        if (entity1 instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192127_g.func_192220_a((EntityPlayerMP)entity1, (Entity)this, source, f, amount, flag);
        }
        return flag2;
    }

    protected void func_190629_c(EntityLivingBase p_190629_1_) {
        p_190629_1_.func_70653_a(this, 0.5f, this.field_70165_t - p_190629_1_.field_70165_t, this.field_70161_v - p_190629_1_.field_70161_v);
    }

    private boolean func_190628_d(DamageSource p_190628_1_) {
        if (p_190628_1_.func_76357_e()) {
            return false;
        }
        ItemStack itemstack = null;
        for (EnumHand enumhand : EnumHand.values()) {
            ItemStack itemstack1 = this.func_184586_b(enumhand);
            if (itemstack1.func_77973_b() != Items.field_190929_cY) continue;
            itemstack = itemstack1.func_77946_l();
            itemstack1.func_190918_g(1);
            break;
        }
        if (itemstack != null) {
            if (this instanceof EntityPlayerMP) {
                EntityPlayerMP entityplayermp = (EntityPlayerMP)this;
                entityplayermp.func_71029_a(StatList.field_75929_E.func_199076_b((Object)Items.field_190929_cY));
                CriteriaTriggers.field_193130_A.func_193187_a(entityplayermp, itemstack);
            }
            this.func_70606_j(1.0f);
            this.func_195061_cb();
            this.func_195064_c(new PotionEffect(MobEffects.field_76428_l, 900, 1));
            this.func_195064_c(new PotionEffect(MobEffects.field_76444_x, 100, 1));
            this.field_70170_p.func_72960_a(this, (byte)35);
        }
        return itemstack != null;
    }

    @Nullable
    public DamageSource func_189748_bU() {
        if (this.field_70170_p.func_82737_E() - this.field_189751_bG > 40L) {
            this.field_189750_bF = null;
        }
        return this.field_189750_bF;
    }

    protected void func_184581_c(DamageSource source) {
        SoundEvent soundevent = this.func_184601_bQ(source);
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    private boolean func_184583_d(DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && this.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = this.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public void func_70669_a(ItemStack stack) {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187635_cQ, this.func_184176_by(), 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
        this.func_195062_a(stack, 5);
    }

    public void func_70645_a(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((EntityLivingBase)this, (DamageSource)cause)) {
            return;
        }
        if (!this.field_70729_aU) {
            Entity entity = cause.func_76346_g();
            EntityLivingBase entitylivingbase = this.func_94060_bK();
            if (this.field_70744_aE >= 0 && entitylivingbase != null) {
                entitylivingbase.func_191956_a(this, this.field_70744_aE, cause);
            }
            if (entity != null) {
                entity.func_70074_a(this);
            }
            this.field_70729_aU = true;
            this.func_110142_aN().func_94549_h();
            if (!this.field_70170_p.field_72995_K) {
                Collection<EntityItem> drops;
                int i = ForgeHooks.getLootingLevel((Entity)this, (Entity)entity, (DamageSource)cause);
                this.captureDrops(new ArrayList<EntityItem>());
                if (this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                    boolean flag = this.field_70718_bc > 0;
                    this.func_184610_a(flag, i, cause);
                }
                if (!ForgeHooks.onLivingDrops((EntityLivingBase)this, (DamageSource)cause, drops = this.captureDrops(null), (int)i, (this.field_70718_bc > 0 ? 1 : 0) != 0)) {
                    drops.forEach(e -> this.field_70170_p.func_72838_d((Entity)((Object)e)));
                }
            }
            this.field_70170_p.func_72960_a(this, (byte)3);
        }
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        this.func_70628_a(wasRecentlyHit, lootingModifier);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((EntityLivingBase)this, (Entity)entityIn, (float)strength, (double)xRatio, (double)zRatio);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        xRatio = event.getRatioX();
        zRatio = event.getRatioZ();
        if (!(this.field_70146_Z.nextDouble() < this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e())) {
            this.field_70160_al = true;
            float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
            this.field_70159_w /= 2.0;
            this.field_70179_y /= 2.0;
            this.field_70159_w -= xRatio / (double)f * (double)strength;
            this.field_70179_y -= zRatio / (double)f * (double)strength;
            if (this.field_70122_E) {
                this.field_70181_x /= 2.0;
                this.field_70181_x += (double)strength;
                if (this.field_70181_x > (double)0.4f) {
                    this.field_70181_x = 0.4f;
                }
            }
        }
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187543_bD;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187661_by;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187655_bw : SoundEvents.field_187545_bE;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
    }

    public boolean func_70617_f_() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        if (this instanceof EntityPlayer && ((EntityPlayer)this).func_175149_v()) {
            return false;
        }
        BlockPos blockpos = new BlockPos(i, j, k);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        return ForgeHooks.isLivingOnLadder((IBlockState)iblockstate, (World)this.field_70170_p, (BlockPos)blockpos, (EntityLivingBase)this);
    }

    private boolean func_184604_a(BlockPos pos, IBlockState state) {
        IBlockState iblockstate;
        return (Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b) != false && (iblockstate = this.field_70170_p.func_180495_p(pos.func_177977_b())).func_177230_c() == Blocks.field_150468_ap && iblockstate.func_177229_b((IProperty)BlockLadder.field_176382_a) == state.func_177229_b((IProperty)BlockTrapDoor.field_185512_D);
    }

    @Override
    public boolean func_70089_S() {
        return !this.field_70128_L && this.func_110143_aJ() > 0.0f;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        float[] ret = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        super.func_180430_e(distance, damageMultiplier);
        PotionEffect potioneffect = this.func_70660_b(MobEffects.field_76430_j);
        float f = potioneffect == null ? 0.0f : (float)(potioneffect.func_76458_c() + 1);
        int i = MathHelper.func_76123_f((float)((distance - 3.0f - f) * damageMultiplier));
        if (i > 0) {
            this.func_184185_a(this.func_184588_d(i), 1.0f, 1.0f);
            this.func_70097_a(DamageSource.field_76379_h, i);
            int j = MathHelper.func_76128_c((double)this.field_70165_t);
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int l = MathHelper.func_76128_c((double)this.field_70161_v);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(j, k, l));
            if (!iblockstate.func_196958_f()) {
                SoundType soundtype = iblockstate.getSoundType(this.field_70170_p, new BlockPos(j, k, l), this);
                this.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.field_70737_aN = this.field_70738_aO = 10;
        this.field_70739_aP = 0.0f;
    }

    public int func_70658_aO() {
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_188791_g);
        return MathHelper.func_76128_c((double)iattributeinstance.func_111126_e());
    }

    protected void func_70675_k(float damage) {
    }

    protected void func_184590_k(float damage) {
    }

    protected float func_70655_b(DamageSource source, float damage) {
        if (!source.func_76363_c()) {
            this.func_70675_k(damage);
            damage = CombatRules.func_189427_a((float)damage, (float)this.func_70658_aO(), (float)((float)this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
        }
        return damage;
    }

    protected float func_70672_c(DamageSource source, float damage) {
        int i;
        int j;
        float f;
        float f1;
        float f2;
        if (source.func_151517_h()) {
            return damage;
        }
        if (this.func_70644_a(MobEffects.field_76429_m) && source != DamageSource.field_76380_i && (f2 = (f1 = damage) - (damage = Math.max((f = damage * (float)(j = 25 - (i = (this.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
            if (this instanceof EntityPlayerMP) {
                ((EntityPlayerMP)this).func_195067_a(StatList.field_212739_K, Math.round(f2 * 10.0f));
            } else if (source.func_76346_g() instanceof EntityPlayerMP) {
                ((EntityPlayerMP)source.func_76346_g()).func_195067_a(StatList.field_212736_G, Math.round(f2 * 10.0f));
            }
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        int k = EnchantmentHelper.func_77508_a(this.func_184193_aE(), source);
        if (k > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)k);
        }
        return damage;
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (!this.func_180431_b(damageSrc)) {
            if ((damageAmount = ForgeHooks.onLivingHurt((EntityLivingBase)this, (DamageSource)damageSrc, (float)damageAmount)) <= 0.0f) {
                return;
            }
            damageAmount = this.func_70655_b(damageSrc, damageAmount);
            float f = damageAmount = this.func_70672_c(damageSrc, damageAmount);
            damageAmount = Math.max(damageAmount - this.func_110139_bj(), 0.0f);
            this.func_110149_m(this.func_110139_bj() - (f - damageAmount));
            float f1 = f - damageAmount;
            if (f1 > 0.0f && f1 < 3.4028235E37f && damageSrc.func_76346_g() instanceof EntityPlayerMP) {
                ((EntityPlayerMP)damageSrc.func_76346_g()).func_195067_a(StatList.field_212735_F, Math.round(f1 * 10.0f));
            }
            if ((damageAmount = ForgeHooks.onLivingDamage((EntityLivingBase)this, (DamageSource)damageSrc, (float)damageAmount)) != 0.0f) {
                float f2 = this.func_110143_aJ();
                this.func_110142_aN().func_94547_a(damageSrc, f2, damageAmount);
                this.func_70606_j(f2 - damageAmount);
                this.func_110149_m(this.func_110139_bj() - damageAmount);
            }
        }
    }

    public CombatTracker func_110142_aN() {
        return this.field_94063_bt;
    }

    @Nullable
    public EntityLivingBase func_94060_bK() {
        if (this.field_94063_bt.func_94550_c() != null) {
            return this.field_94063_bt.func_94550_c();
        }
        if (this.field_70717_bb != null) {
            return this.field_70717_bb;
        }
        return this.field_70755_b != null ? this.field_70755_b : null;
    }

    public final float func_110138_aP() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
    }

    public final int func_85035_bI() {
        return this.field_70180_af.func_187225_a(field_184635_h);
    }

    public final void func_85034_r(int count) {
        this.field_70180_af.func_187227_b(field_184635_h, count);
    }

    private int func_82166_i() {
        if (PotionUtil.func_205135_a((EntityLivingBase)this)) {
            return 6 - (1 + PotionUtil.func_205134_b((EntityLivingBase)this));
        }
        return this.func_70644_a(MobEffects.field_76419_f) ? 6 + (1 + this.func_70660_b(MobEffects.field_76419_f).func_76458_c()) * 2 : 6;
    }

    public void func_184609_a(EnumHand hand) {
        ItemStack stack = this.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.onEntitySwing(this)) {
            return;
        }
        if (!this.field_82175_bq || this.field_110158_av >= this.func_82166_i() / 2 || this.field_110158_av < 0) {
            this.field_110158_av = -1;
            this.field_82175_bq = true;
            this.field_184622_au = hand;
            if (this.field_70170_p instanceof WorldServer) {
                ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a(this, (Packet<?>)new SPacketAnimation((Entity)this, hand == EnumHand.MAIN_HAND ? 0 : 3));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        boolean flag2;
        boolean flag = id == 33;
        boolean flag1 = id == 36;
        boolean bl = flag2 = id == 37;
        if (!(id == 2 || flag || flag1 || flag2)) {
            if (id == 3) {
                SoundEvent soundevent1 = this.func_184615_bR();
                if (soundevent1 != null) {
                    this.func_184185_a(soundevent1, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
                this.func_70606_j(0.0f);
                this.func_70645_a(DamageSource.field_76377_j);
            } else if (id == 30) {
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            } else if (id == 29) {
                this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            } else {
                super.func_70103_a(id);
            }
        } else {
            DamageSource damagesource;
            SoundEvent soundevent;
            this.field_70721_aZ = 1.5f;
            this.field_70172_ad = this.field_70771_an;
            this.field_70737_aN = this.field_70738_aO = 10;
            this.field_70739_aP = 0.0f;
            if (flag) {
                this.func_184185_a(SoundEvents.field_187903_gc, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            if ((soundevent = this.func_184601_bQ(damagesource = flag2 ? DamageSource.field_76370_b : (flag1 ? DamageSource.field_76369_e : DamageSource.field_76377_j))) != null) {
                this.func_184185_a(soundevent, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.func_70097_a(DamageSource.field_76377_j, 0.0f);
        }
    }

    @Override
    protected void func_70076_C() {
        this.func_70097_a(DamageSource.field_76380_i, 4.0f);
    }

    protected void func_82168_bl() {
        int i = this.func_82166_i();
        if (this.field_82175_bq) {
            ++this.field_110158_av;
            if (this.field_110158_av >= i) {
                this.field_110158_av = 0;
                this.field_82175_bq = false;
            }
        } else {
            this.field_110158_av = 0;
        }
        this.field_70733_aJ = (float)this.field_110158_av / (float)i;
    }

    public IAttributeInstance func_110148_a(IAttribute attribute) {
        return this.func_110140_aT().func_111151_a(attribute);
    }

    public AbstractAttributeMap func_110140_aT() {
        if (this.field_110155_d == null) {
            this.field_110155_d = new AttributeMap();
        }
        return this.field_110155_d;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.UNDEFINED;
    }

    public ItemStack func_184614_ca() {
        return this.func_184582_a(EntityEquipmentSlot.MAINHAND);
    }

    public ItemStack func_184592_cb() {
        return this.func_184582_a(EntityEquipmentSlot.OFFHAND);
    }

    public ItemStack func_184586_b(EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            return this.func_184582_a(EntityEquipmentSlot.MAINHAND);
        }
        if (hand == EnumHand.OFF_HAND) {
            return this.func_184582_a(EntityEquipmentSlot.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + hand);
    }

    public void func_184611_a(EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.MAIN_HAND) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
        } else {
            if (hand != EnumHand.OFF_HAND) {
                throw new IllegalArgumentException("Invalid hand " + hand);
            }
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, stack);
        }
    }

    public boolean func_190630_a(EntityEquipmentSlot p_190630_1_) {
        return !this.func_184582_a(p_190630_1_).func_190926_b();
    }

    @Override
    public abstract Iterable<ItemStack> func_184193_aE();

    public abstract ItemStack func_184582_a(EntityEquipmentSlot var1);

    @Override
    public abstract void func_184201_a(EntityEquipmentSlot var1, ItemStack var2);

    @Override
    public void func_70031_b(boolean sprinting) {
        super.func_70031_b(sprinting);
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (iattributeinstance.func_111127_a(field_110156_b) != null) {
            iattributeinstance.func_111124_b(field_110157_c);
        }
        if (sprinting) {
            iattributeinstance.func_111121_a(field_110157_c);
        }
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.5f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f;
    }

    public void func_110145_l(Entity entityIn) {
        if (!(entityIn instanceof EntityBoat) && !(entityIn instanceof AbstractHorse)) {
            double d1 = entityIn.field_70165_t;
            double d13 = entityIn.func_174813_aQ().field_72338_b + (double)entityIn.field_70131_O;
            double d14 = entityIn.field_70161_v;
            EnumFacing enumfacing1 = entityIn.func_184172_bi();
            if (enumfacing1 != null) {
                EnumFacing enumfacing = enumfacing1.func_176746_e();
                int[][] aint1 = new int[][]{{0, 1}, {0, -1}, {-1, 1}, {-1, -1}, {1, 1}, {1, -1}, {-1, 0}, {1, 0}, {0, 1}};
                double d5 = Math.floor(this.field_70165_t) + 0.5;
                double d6 = Math.floor(this.field_70161_v) + 0.5;
                double d7 = this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a;
                double d8 = this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c;
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(d5 - d7 / 2.0, entityIn.func_174813_aQ().field_72338_b, d6 - d8 / 2.0, d5 + d7 / 2.0, Math.floor(entityIn.func_174813_aQ().field_72338_b) + (double)this.field_70131_O, d6 + d8 / 2.0);
                for (int[] aint : aint1) {
                    double d9 = enumfacing1.func_82601_c() * aint[0] + enumfacing.func_82601_c() * aint[1];
                    double d10 = enumfacing1.func_82599_e() * aint[0] + enumfacing.func_82599_e() * aint[1];
                    double d11 = d5 + d9;
                    double d12 = d6 + d10;
                    AxisAlignedBB axisalignedbb1 = axisalignedbb.func_72317_d(d9, 0.0, d10);
                    if (this.field_70170_p.func_195586_b(this, axisalignedbb1)) {
                        if (this.field_70170_p.func_195595_w(new BlockPos(d11, this.field_70163_u, d12))) {
                            this.func_70634_a(d11, this.field_70163_u + 1.0, d12);
                            return;
                        }
                        BlockPos blockpos = new BlockPos(d11, this.field_70163_u - 1.0, d12);
                        if (!this.field_70170_p.func_195595_w(blockpos) && !this.field_70170_p.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a)) continue;
                        d1 = d11;
                        d13 = this.field_70163_u + 1.0;
                        d14 = d12;
                        continue;
                    }
                    if (!this.field_70170_p.func_195586_b(this, axisalignedbb1.func_72317_d(0.0, 1.0, 0.0)) || !this.field_70170_p.func_195595_w(new BlockPos(d11, this.field_70163_u + 1.0, d12))) continue;
                    d1 = d11;
                    d13 = this.field_70163_u + 2.0;
                    d14 = d12;
                }
            }
            this.func_70634_a(d1, d13, d14);
        } else {
            double d0 = (double)(this.field_70130_N / 2.0f + entityIn.field_70130_N / 2.0f) + 0.4;
            float f = entityIn instanceof EntityBoat ? 0.0f : 1.5707964f * (float)(this.func_184591_cq() == EnumHandSide.RIGHT ? -1 : 1);
            float f1 = -MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI + f));
            float f2 = -MathHelper.func_76134_b((float)(-this.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI + f));
            double d2 = Math.abs(f1) > Math.abs(f2) ? d0 / (double)Math.abs(f1) : d0 / (double)Math.abs(f2);
            double d3 = this.field_70165_t + (double)f1 * d2;
            double d4 = this.field_70161_v + (double)f2 * d2;
            this.func_70107_b(d3, entityIn.field_70163_u + (double)entityIn.field_70131_O + 0.001, d4);
            if (!this.field_70170_p.func_195586_b(this, this.func_174813_aQ().func_111270_a(entityIn.func_174813_aQ()))) {
                this.func_70107_b(d3, entityIn.field_70163_u + (double)entityIn.field_70131_O + 1.001, d4);
                if (!this.field_70170_p.func_195586_b(this, this.func_174813_aQ().func_111270_a(entityIn.func_174813_aQ()))) {
                    this.func_70107_b(entityIn.field_70165_t, entityIn.field_70163_u + (double)this.field_70131_O + 0.001, entityIn.field_70161_v);
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_94059_bO() {
        return this.func_174833_aM();
    }

    protected float func_175134_bD() {
        return 0.42f;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = this.func_175134_bD();
        if (this.func_70644_a(MobEffects.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        if (this.func_70051_ag()) {
            float f = this.field_70177_z * ((float)Math.PI / 180);
            this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void func_203010_cG() {
        this.field_70181_x -= (double)0.04f * this.func_110148_a(SWIM_SPEED).func_111126_e();
    }

    protected void func_180466_bG(Tag<Fluid> p_180466_1_) {
        this.field_70181_x += (double)0.04f * this.func_110148_a(SWIM_SPEED).func_111126_e();
    }

    protected float func_189749_co() {
        return 0.8f;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        double d7;
        if (this.func_70613_aW() || this.func_184186_bw()) {
            double d0 = 0.08;
            if (this.field_70181_x <= 0.0 && this.func_70644_a(MobEffects.field_204839_B)) {
                d0 = 0.01;
                this.field_70143_R = 0.0f;
            }
            if (!this.func_70090_H() || this instanceof EntityPlayer && ((EntityPlayer)this).field_71075_bZ.field_75100_b) {
                if (!this.func_180799_ab() || this instanceof EntityPlayer && ((EntityPlayer)this).field_71075_bZ.field_75100_b) {
                    if (this.func_184613_cA()) {
                        double d12;
                        double d4;
                        float f6;
                        if (this.field_70181_x > -0.5) {
                            this.field_70143_R = 1.0f;
                        }
                        Vec3d vec3d = this.func_70040_Z();
                        float f = this.field_70125_A * ((float)Math.PI / 180);
                        double d8 = Math.sqrt(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c);
                        double d10 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                        double d2 = vec3d.func_72433_c();
                        float f5 = MathHelper.func_76134_b((float)f);
                        f5 = (float)((double)f5 * (double)f5 * Math.min(1.0, d2 / 0.4));
                        this.field_70181_x += d0 * (-1.0 + (double)f5 * 0.75);
                        if (this.field_70181_x < 0.0 && d8 > 0.0) {
                            double d3 = this.field_70181_x * -0.1 * (double)f5;
                            this.field_70181_x += d3;
                            this.field_70159_w += vec3d.field_72450_a * d3 / d8;
                            this.field_70179_y += vec3d.field_72449_c * d3 / d8;
                        }
                        if (f < 0.0f && d8 > 0.0) {
                            double d11 = d10 * (double)(-MathHelper.func_76126_a((float)f)) * 0.04;
                            this.field_70181_x += d11 * 3.2;
                            this.field_70159_w -= vec3d.field_72450_a * d11 / d8;
                            this.field_70179_y -= vec3d.field_72449_c * d11 / d8;
                        }
                        if (d8 > 0.0) {
                            this.field_70159_w += (vec3d.field_72450_a / d8 * d10 - this.field_70159_w) * 0.1;
                            this.field_70179_y += (vec3d.field_72449_c / d8 * d10 - this.field_70179_y) * 0.1;
                        }
                        this.field_70159_w *= (double)0.99f;
                        this.field_70181_x *= (double)0.98f;
                        this.field_70179_y *= (double)0.99f;
                        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                        if (this.field_70123_F && !this.field_70170_p.field_72995_K && (f6 = (float)((d4 = d10 - (d12 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) * 10.0 - 3.0)) > 0.0f) {
                            this.func_184185_a(this.func_184588_d((int)f6), 1.0f, 1.0f);
                            this.func_70097_a(DamageSource.field_188406_j, f6);
                        }
                        if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
                            this.func_70052_a(7, false);
                        }
                    } else {
                        float f7 = 0.91f;
                        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)this.field_70165_t, (double)(this.func_174813_aQ().field_72338_b - 1.0), (double)this.field_70161_v);){
                            if (this.field_70122_E) {
                                f7 = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).getSlipperiness(this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos, this) * 0.91f;
                            }
                            float f8 = 0.16277137f / (f7 * f7 * f7);
                            float f9 = this.field_70122_E ? this.func_70689_ay() * f8 : this.field_70747_aH;
                            this.func_191958_b(strafe, vertical, forward, f9);
                            f7 = 0.91f;
                            if (this.field_70122_E) {
                                f7 = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_189532_c(this.field_70165_t, this.func_174813_aQ().field_72338_b - 1.0, this.field_70161_v)).getSlipperiness(this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos, this) * 0.91f;
                            }
                            if (this.func_70617_f_()) {
                                boolean flag;
                                float f4 = 0.15f;
                                this.field_70159_w = MathHelper.func_151237_a((double)this.field_70159_w, (double)-0.15f, (double)0.15f);
                                this.field_70179_y = MathHelper.func_151237_a((double)this.field_70179_y, (double)-0.15f, (double)0.15f);
                                this.field_70143_R = 0.0f;
                                if (this.field_70181_x < -0.15) {
                                    this.field_70181_x = -0.15;
                                }
                                boolean bl = flag = this.func_70093_af() && this instanceof EntityPlayer;
                                if (flag && this.field_70181_x < 0.0) {
                                    this.field_70181_x = 0.0;
                                }
                            }
                            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                            if (this.field_70123_F && this.func_70617_f_()) {
                                this.field_70181_x = 0.2;
                            }
                            if (this.func_70644_a(MobEffects.field_188424_y)) {
                                this.field_70181_x += (0.05 * (double)(this.func_70660_b(MobEffects.field_188424_y).func_76458_c() + 1) - this.field_70181_x) * 0.2;
                                this.field_70143_R = 0.0f;
                            } else {
                                blockpos$pooledmutableblockpos.func_189532_c(this.field_70165_t, 0.0, this.field_70161_v);
                                if (!this.field_70170_p.field_72995_K || this.field_70170_p.func_175667_e((BlockPos)blockpos$pooledmutableblockpos) && this.field_70170_p.func_175726_f((BlockPos)blockpos$pooledmutableblockpos).func_177410_o()) {
                                    if (!this.func_189652_ae()) {
                                        this.field_70181_x -= d0;
                                    }
                                } else {
                                    this.field_70181_x = this.field_70163_u > 0.0 ? -0.1 : 0.0;
                                }
                            }
                            this.field_70181_x *= (double)0.98f;
                            this.field_70159_w *= (double)f7;
                            this.field_70179_y *= (double)f7;
                        }
                    }
                } else {
                    double d6 = this.field_70163_u;
                    this.func_191958_b(strafe, vertical, forward, 0.02f);
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                    if (!this.func_189652_ae()) {
                        this.field_70181_x -= d0 / 4.0;
                    }
                    if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d6, this.field_70179_y)) {
                        this.field_70181_x = 0.3f;
                    }
                }
            } else {
                double d1 = this.field_70163_u;
                float f1 = this.func_70051_ag() ? 0.9f : this.func_189749_co();
                float f2 = 0.02f;
                float f3 = EnchantmentHelper.func_185294_d(this);
                if (f3 > 3.0f) {
                    f3 = 3.0f;
                }
                if (!this.field_70122_E) {
                    f3 *= 0.5f;
                }
                if (f3 > 0.0f) {
                    f1 += (0.54600006f - f1) * f3 / 3.0f;
                    f2 += (this.func_70689_ay() - f2) * f3 / 3.0f;
                }
                if (this.func_70644_a(MobEffects.field_206827_D)) {
                    f1 = 0.96f;
                }
                this.func_191958_b(strafe, vertical, forward, f2);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f1;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)f1;
                if (!this.func_189652_ae() && !this.func_70051_ag()) {
                    this.field_70181_x = this.field_70181_x <= 0.0 && Math.abs(this.field_70181_x - 0.005) >= 0.003 && Math.abs(this.field_70181_x - d0 / 16.0) < 0.003 ? -0.003 : (this.field_70181_x -= d0 / 16.0);
                }
                if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d1, this.field_70179_y)) {
                    this.field_70181_x = 0.3f;
                }
            }
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d5 = this.field_70165_t - this.field_70169_q;
        double d9 = this instanceof IFlyingAnimal ? this.field_70163_u - this.field_70167_r : 0.0;
        float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d9 * d9 + (d7 = this.field_70161_v - this.field_70166_s) * d7)) * 4.0f;
        if (f10 > 1.0f) {
            f10 = 1.0f;
        }
        this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public float func_70689_ay() {
        return this.field_70746_aG;
    }

    public void func_70659_e(float speedIn) {
        this.field_70746_aG = speedIn;
    }

    public boolean func_70652_k(Entity entityIn) {
        this.func_130011_c(entityIn);
        return false;
    }

    public boolean func_70608_bn() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        if (ForgeHooks.onLivingUpdate((EntityLivingBase)this)) {
            return;
        }
        super.func_70071_h_();
        this.func_184608_ct();
        this.func_205014_p();
        if (!this.field_70170_p.field_72995_K) {
            int i = this.func_85035_bI();
            if (i > 0) {
                if (this.field_70720_be <= 0) {
                    this.field_70720_be = 20 * (30 - i);
                }
                --this.field_70720_be;
                if (this.field_70720_be <= 0) {
                    this.func_85034_r(i - 1);
                }
            }
            block8: for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                ItemStack itemstack;
                switch (entityequipmentslot.func_188453_a()) {
                    case HAND: {
                        itemstack = (ItemStack)((Object)this.field_184630_bs.get(entityequipmentslot.func_188454_b()));
                        break;
                    }
                    case ARMOR: {
                        itemstack = (ItemStack)((Object)this.field_184631_bt.get(entityequipmentslot.func_188454_b()));
                        break;
                    }
                    default: {
                        continue block8;
                    }
                }
                ItemStack itemstack1 = this.func_184582_a(entityequipmentslot);
                if (ItemStack.func_77989_b(itemstack1, itemstack)) continue;
                if (!itemstack1.equals(itemstack, true)) {
                    ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a(this, (Packet<?>)new SPacketEntityEquipment(this.func_145782_y(), entityequipmentslot, itemstack1));
                }
                MinecraftForge.EVENT_BUS.post((Event)new LivingEquipmentChangeEvent(this, entityequipmentslot, itemstack, itemstack1));
                if (!itemstack.func_190926_b()) {
                    this.func_110140_aT().func_111148_a(itemstack.func_111283_C(entityequipmentslot));
                }
                if (!itemstack1.func_190926_b()) {
                    this.func_110140_aT().func_111147_b(itemstack1.func_111283_C(entityequipmentslot));
                }
                switch (entityequipmentslot.func_188453_a()) {
                    case HAND: {
                        this.field_184630_bs.set(entityequipmentslot.func_188454_b(), (Object)(itemstack1.func_190926_b() ? ItemStack.field_190927_a : itemstack1.func_77946_l()));
                        continue block8;
                    }
                    case ARMOR: {
                        this.field_184631_bt.set(entityequipmentslot.func_188454_b(), (Object)(itemstack1.func_190926_b() ? ItemStack.field_190927_a : itemstack1.func_77946_l()));
                    }
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                this.func_110142_aN().func_94549_h();
            }
            if (!this.field_184238_ar) {
                boolean flag = this.func_70644_a(MobEffects.field_188423_x);
                if (this.func_70083_f(6) != flag) {
                    this.func_70052_a(6, flag);
                }
            }
        }
        this.func_70636_d();
        double d0 = this.field_70165_t - this.field_70169_q;
        double d1 = this.field_70161_v - this.field_70166_s;
        float f3 = (float)(d0 * d0 + d1 * d1);
        float f4 = this.field_70761_aq;
        float f5 = 0.0f;
        this.field_70768_au = this.field_110154_aX;
        float f = 0.0f;
        if (f3 > 0.0025000002f) {
            f = 1.0f;
            f5 = (float)Math.sqrt(f3) * 3.0f;
            float f1 = (float)MathHelper.func_181159_b((double)d1, (double)d0) * 57.295776f - 90.0f;
            float f2 = MathHelper.func_76135_e((float)(MathHelper.func_76142_g((float)this.field_70177_z) - f1));
            f4 = 95.0f < f2 && f2 < 265.0f ? f1 - 180.0f : f1;
        }
        if (this.field_70733_aJ > 0.0f) {
            f4 = this.field_70177_z;
        }
        if (!this.field_70122_E) {
            f = 0.0f;
        }
        this.field_110154_aX += (f - this.field_110154_aX) * 0.3f;
        this.field_70170_p.field_72984_F.func_76320_a("headTurn");
        f5 = this.func_110146_f(f4, f5);
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("rangeChecks");
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        while (this.field_70761_aq - this.field_70760_ar < -180.0f) {
            this.field_70760_ar -= 360.0f;
        }
        while (this.field_70761_aq - this.field_70760_ar >= 180.0f) {
            this.field_70760_ar += 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70759_as - this.field_70758_at < -180.0f) {
            this.field_70758_at -= 360.0f;
        }
        while (this.field_70759_as - this.field_70758_at >= 180.0f) {
            this.field_70758_at += 360.0f;
        }
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70764_aw += f5;
        this.field_184629_bo = this.func_184613_cA() ? ++this.field_184629_bo : 0;
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        boolean flag;
        float f = MathHelper.func_76142_g((float)(p_110146_1_ - this.field_70761_aq));
        this.field_70761_aq += f * 0.3f;
        float f1 = MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70761_aq));
        boolean bl = flag = f1 < -90.0f || f1 >= 90.0f;
        if (f1 < -75.0f) {
            f1 = -75.0f;
        }
        if (f1 >= 75.0f) {
            f1 = 75.0f;
        }
        this.field_70761_aq = this.field_70177_z - f1;
        if (f1 * f1 > 2500.0f) {
            this.field_70761_aq += f1 * 0.2f;
        }
        if (flag) {
            p_110146_2_ *= -1.0f;
        }
        return p_110146_2_;
    }

    public void func_70636_d() {
        if (this.field_70773_bE > 0) {
            --this.field_70773_bE;
        }
        if (this.field_70716_bi > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.field_184623_bh - this.field_70165_t) / (double)this.field_70716_bi;
            double d1 = this.field_70163_u + (this.field_184624_bi - this.field_70163_u) / (double)this.field_70716_bi;
            double d2 = this.field_70161_v + (this.field_184625_bj - this.field_70161_v) / (double)this.field_70716_bi;
            double d3 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.field_70716_bi);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
            --this.field_70716_bi;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else if (!this.func_70613_aW()) {
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
        }
        if (this.field_208002_br > 0) {
            this.field_70759_as = (float)((double)this.field_70759_as + MathHelper.func_76138_g((double)(this.field_208001_bq - (double)this.field_70759_as)) / (double)this.field_208002_br);
            --this.field_208002_br;
        }
        if (Math.abs(this.field_70159_w) < 0.003) {
            this.field_70159_w = 0.0;
        }
        if (Math.abs(this.field_70181_x) < 0.003) {
            this.field_70181_x = 0.0;
        }
        if (Math.abs(this.field_70179_y) < 0.003) {
            this.field_70179_y = 0.0;
        }
        this.field_70170_p.field_72984_F.func_76320_a("ai");
        if (this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
            this.field_70704_bt = 0.0f;
        } else if (this.func_70613_aW()) {
            this.field_70170_p.field_72984_F.func_76320_a("newAi");
            this.func_70626_be();
            this.field_70170_p.field_72984_F.func_76319_b();
        }
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("jump");
        if (this.field_70703_bu) {
            if (!(this.field_211517_W > 0.0) || this.field_70122_E && !(this.field_211517_W > 0.4)) {
                if (this.func_180799_ab()) {
                    this.func_180466_bG(FluidTags.field_206960_b);
                } else if ((this.field_70122_E || this.field_211517_W > 0.0 && this.field_211517_W <= 0.4) && this.field_70773_bE == 0) {
                    this.func_70664_aZ();
                    this.field_70773_bE = 10;
                }
            } else {
                this.func_180466_bG(FluidTags.field_206959_a);
            }
        } else {
            this.field_70773_bE = 0;
        }
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("travel");
        this.field_70702_br *= 0.98f;
        this.field_191988_bg *= 0.98f;
        this.field_70704_bt *= 0.9f;
        this.func_184616_r();
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.func_191986_a(this.field_70702_br, this.field_70701_bs, this.field_191988_bg);
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("push");
        if (this.field_204807_bs > 0) {
            --this.field_204807_bs;
            this.func_204801_a(axisalignedbb, this.func_174813_aQ());
        }
        this.func_85033_bc();
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    private void func_184616_r() {
        boolean flag = this.func_70083_f(7);
        if (flag && !this.field_70122_E && !this.func_184218_aH()) {
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.CHEST);
            if (itemstack.func_77973_b() == Items.field_185160_cR && ItemElytra.func_185069_d((ItemStack)itemstack)) {
                flag = true;
                if (!this.field_70170_p.field_72995_K && (this.field_184629_bo + 1) % 20 == 0) {
                    itemstack.func_77972_a(1, this);
                }
            } else {
                flag = false;
            }
        } else {
            flag = false;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(7, flag);
        }
    }

    protected void func_70626_be() {
    }

    protected void func_85033_bc() {
        List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ(), EntitySelectors.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_180263_c("maxEntityCramming");
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (list.get(k).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = list.get(l);
                this.func_82167_n(entity);
            }
        }
    }

    protected void func_204801_a(AxisAlignedBB p_204801_1_, AxisAlignedBB p_204801_2_) {
        AxisAlignedBB axisalignedbb = p_204801_1_.func_111270_a(p_204801_2_);
        List list = this.field_70170_p.func_72839_b(this, axisalignedbb);
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)((Object)list.get(i));
                if (!(entity instanceof EntityLivingBase)) continue;
                this.func_204804_d((EntityLivingBase)entity);
                this.field_204807_bs = 0;
                this.field_70159_w *= -0.2;
                this.field_70181_x *= -0.2;
                this.field_70179_y *= -0.2;
                break;
            }
        } else if (this.field_70123_F) {
            this.field_204807_bs = 0;
        }
        if (!this.field_70170_p.field_72995_K && this.field_204807_bs <= 0) {
            this.func_204802_c(4, false);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        entityIn.func_70108_f(this);
    }

    protected void func_204804_d(EntityLivingBase p_204804_1_) {
    }

    public void func_204803_n(int p_204803_1_) {
        this.field_204807_bs = p_204803_1_;
        if (!this.field_70170_p.field_72995_K) {
            this.func_204802_c(4, true);
        }
    }

    public boolean func_204805_cN() {
        return (this.field_70180_af.func_187225_a(field_184621_as) & 4) != 0;
    }

    @Override
    public void func_184210_p() {
        Entity entity = this.func_184187_bx();
        super.func_184210_p();
        if (entity != null && entity != this.func_184187_bx() && !this.field_70170_p.field_72995_K) {
            this.func_110145_l(entity);
        }
    }

    @Override
    public void func_70098_U() {
        super.func_70098_U();
        this.field_70768_au = this.field_110154_aX;
        this.field_110154_aX = 0.0f;
        this.field_70143_R = 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.field_184623_bh = x;
        this.field_184624_bi = y;
        this.field_184625_bj = z;
        this.field_184626_bk = yaw;
        this.field_70709_bj = pitch;
        this.field_70716_bi = posRotationIncrements;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_208000_a(float yaw, int pitch) {
        this.field_208001_bq = yaw;
        this.field_208002_br = pitch;
    }

    public void func_70637_d(boolean jumping) {
        this.field_70703_bu = jumping;
    }

    public void func_71001_a(Entity entityIn, int quantity) {
        if (!entityIn.field_70128_L && !this.field_70170_p.field_72995_K) {
            EntityTracker entitytracker = ((WorldServer)this.field_70170_p).func_73039_n();
            if (entityIn instanceof EntityItem || entityIn instanceof EntityArrow || entityIn instanceof EntityXPOrb) {
                entitytracker.func_151247_a(entityIn, (Packet<?>)new SPacketCollectItem(entityIn.func_145782_y(), this.func_145782_y(), quantity));
            }
        }
    }

    public boolean func_70685_l(Entity entityIn) {
        return this.field_70170_p.func_200259_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u + (double)entityIn.func_70047_e(), entityIn.field_70161_v), RayTraceFluidMode.NEVER, true, false) == null;
    }

    @Override
    public float func_195046_g(float partialTicks) {
        return partialTicks == 1.0f ? this.field_70759_as : this.field_70758_at + (this.field_70759_as - this.field_70758_at) * partialTicks;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70678_g(float partialTickTime) {
        float f = this.field_70733_aJ - this.field_70732_aI;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return this.field_70732_aI + f * partialTickTime;
    }

    public boolean func_70613_aW() {
        return !this.field_70170_p.field_72995_K;
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @Override
    public boolean func_70104_M() {
        return this.func_70089_S() && !this.func_70617_f_();
    }

    @Override
    protected void func_70018_K() {
        this.field_70133_I = this.field_70146_Z.nextDouble() >= this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
    }

    @Override
    public float func_70079_am() {
        return this.field_70759_as;
    }

    @Override
    public void func_70034_d(float rotation) {
        this.field_70759_as = rotation;
    }

    @Override
    public void func_181013_g(float offset) {
        this.field_70761_aq = offset;
    }

    public float func_110139_bj() {
        return this.field_110151_bq;
    }

    public void func_110149_m(float amount) {
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        this.field_110151_bq = amount;
    }

    public void func_152111_bt() {
    }

    public void func_152112_bu() {
    }

    protected void func_175136_bO() {
        this.field_70752_e = true;
    }

    public abstract EnumHandSide func_184591_cq();

    public boolean func_184587_cr() {
        return (this.field_70180_af.func_187225_a(field_184621_as) & 1) > 0;
    }

    public EnumHand func_184600_cs() {
        return (this.field_70180_af.func_187225_a(field_184621_as) & 2) > 0 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
    }

    protected void func_184608_ct() {
        if (this.func_184587_cr()) {
            ItemStack itemstack = this.func_184586_b(this.func_184600_cs());
            if (ForgeHooks.canContinueUsing((ItemStack)this.field_184627_bm, (ItemStack)itemstack)) {
                this.field_184627_bm = itemstack;
            }
            if (itemstack == this.field_184627_bm) {
                if (!this.field_184627_bm.func_190926_b()) {
                    this.field_184628_bn = ForgeEventFactory.onItemUseTick((EntityLivingBase)this, (ItemStack)this.field_184627_bm, (int)this.field_184628_bn);
                    if (this.field_184628_bn > 0) {
                        this.field_184627_bm.onUsingTick(this, this.field_184628_bn);
                    }
                }
                if (this.func_184605_cv() <= 25 && this.func_184605_cv() % 4 == 0) {
                    this.func_184584_a(this.field_184627_bm, 5);
                }
                if (--this.field_184628_bn <= 0 && !this.field_70170_p.field_72995_K) {
                    this.func_71036_o();
                }
            } else {
                this.func_184602_cy();
            }
        }
    }

    private void func_205014_p() {
        this.field_205018_bM = this.field_205017_bL;
        this.field_205017_bL = this.func_203007_ba() ? Math.min(1.0f, this.field_205017_bL + 0.09f) : Math.max(0.0f, this.field_205017_bL - 0.09f);
    }

    protected void func_204802_c(int key, boolean value) {
        int i = this.field_70180_af.func_187225_a(field_184621_as).byteValue();
        i = value ? (i |= key) : (i &= ~key);
        this.field_70180_af.func_187227_b(field_184621_as, (byte)i);
    }

    public void func_184598_c(EnumHand hand) {
        ItemStack itemstack = this.func_184586_b(hand);
        if (!itemstack.func_190926_b() && !this.func_184587_cr()) {
            int duration = ForgeEventFactory.onItemUseStart((EntityLivingBase)this, (ItemStack)itemstack, (int)itemstack.func_77988_m());
            if (duration <= 0) {
                return;
            }
            this.field_184627_bm = itemstack;
            this.field_184628_bn = duration;
            if (!this.field_70170_p.field_72995_K) {
                this.func_204802_c(1, true);
                this.func_204802_c(2, hand == EnumHand.OFF_HAND);
            }
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (field_184621_as.equals(key) && this.field_70170_p.field_72995_K) {
            if (this.func_184587_cr() && this.field_184627_bm.func_190926_b()) {
                this.field_184627_bm = this.func_184586_b(this.func_184600_cs());
                if (!this.field_184627_bm.func_190926_b()) {
                    this.field_184628_bn = this.field_184627_bm.func_77988_m();
                }
            } else if (!this.func_184587_cr() && !this.field_184627_bm.func_190926_b()) {
                this.field_184627_bm = ItemStack.field_190927_a;
                this.field_184628_bn = 0;
            }
        }
    }

    @Override
    public void func_200602_a(EntityAnchorArgument.Type p_200602_1_, Vec3d p_200602_2_) {
        super.func_200602_a(p_200602_1_, p_200602_2_);
        this.field_70758_at = this.field_70759_as;
        this.field_70760_ar = this.field_70761_aq = this.field_70759_as;
    }

    protected void func_184584_a(ItemStack stack, int eatingParticleCount) {
        if (!stack.func_190926_b() && this.func_184587_cr()) {
            if (stack.func_77975_n() == EnumAction.DRINK) {
                this.func_184185_a(SoundEvents.field_187664_bz, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (stack.func_77975_n() == EnumAction.EAT) {
                this.func_195062_a(stack, eatingParticleCount);
                this.func_184185_a(SoundEvents.field_187537_bA, 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    private void func_195062_a(ItemStack p_195062_1_, int p_195062_2_) {
        for (int i = 0; i < p_195062_2_; ++i) {
            Vec3d vec3d = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
            vec3d = vec3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
            double d0 = (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3;
            Vec3d vec3d1 = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
            vec3d1 = vec3d1.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
            vec3d1 = vec3d1.func_72441_c(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
            if (this.field_70170_p instanceof WorldServer) {
                ((WorldServer)this.field_70170_p).func_195598_a(new ItemParticleData(Particles.field_197591_B, p_195062_1_), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, 1, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, 0.0);
                continue;
            }
            this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(Particles.field_197591_B, p_195062_1_), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
        }
    }

    protected void func_71036_o() {
        if (!this.field_184627_bm.func_190926_b() && this.func_184587_cr()) {
            this.func_184584_a(this.field_184627_bm, 16);
            ItemStack copy = this.field_184627_bm.func_77946_l();
            ItemStack stack = ForgeEventFactory.onItemUseFinish((EntityLivingBase)this, (ItemStack)copy, (int)this.func_184605_cv(), (ItemStack)this.field_184627_bm.func_77950_b(this.field_70170_p, this));
            this.func_184611_a(this.func_184600_cs(), stack);
            this.func_184602_cy();
        }
    }

    public ItemStack func_184607_cu() {
        return this.field_184627_bm;
    }

    public int func_184605_cv() {
        return this.field_184628_bn;
    }

    public int func_184612_cw() {
        return this.func_184587_cr() ? this.field_184627_bm.func_77988_m() - this.func_184605_cv() : 0;
    }

    public void func_184597_cx() {
        if (!this.field_184627_bm.func_190926_b() && !ForgeEventFactory.onUseItemStop((EntityLivingBase)this, (ItemStack)this.field_184627_bm, (int)this.func_184605_cv())) {
            this.field_184627_bm.func_77974_b(this.field_70170_p, this, this.func_184605_cv());
        }
        this.func_184602_cy();
    }

    public void func_184602_cy() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_204802_c(1, false);
        }
        this.field_184627_bm = ItemStack.field_190927_a;
        this.field_184628_bn = 0;
    }

    public boolean func_184585_cz() {
        if (this.func_184587_cr() && !this.field_184627_bm.func_190926_b()) {
            Item item = this.field_184627_bm.func_77973_b();
            if (item.func_77661_b(this.field_184627_bm) != EnumAction.BLOCK) {
                return false;
            }
            return item.func_77626_a(this.field_184627_bm) - this.field_184628_bn >= 5;
        }
        return false;
    }

    public boolean func_184613_cA() {
        return this.func_70083_f(7);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_184599_cB() {
        return this.field_184629_bo;
    }

    public boolean func_184595_k(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World iworld = this.field_70170_p;
        Random random = this.func_70681_au();
        if (iworld.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = iworld.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (iworld.func_195586_b(this, this.func_174813_aQ()) && !iworld.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        int i = 128;
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.field_70131_O;
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            iworld.func_195594_a((IParticleData)Particles.field_197599_J, d3, d4, d5, f, f1, f2);
        }
        if (this instanceof EntityCreature) {
            ((EntityCreature)this).func_70661_as().func_75499_g();
        }
        return true;
    }

    public boolean func_184603_cC() {
        return true;
    }

    public boolean func_190631_cK() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_191987_a(BlockPos pos, boolean isPartying) {
    }

    public boolean shouldRiderFaceForward(EntityPlayer player) {
        return this instanceof EntityPig;
    }

    @Override
    public void func_191958_b(float strafe, float up, float forward, float friction) {
        float f = strafe * strafe + up * up + forward * forward;
        if (f >= 1.0E-4f) {
            if ((f = MathHelper.func_76129_c((float)f)) < 1.0f) {
                f = 1.0f;
            }
            f = friction / f;
            strafe *= f;
            up *= f;
            forward *= f;
            if (this.func_70090_H() || this.func_180799_ab()) {
                float speed = (float)this.func_110148_a(SWIM_SPEED).func_111126_e();
                strafe *= speed;
                up *= speed;
                forward *= speed;
            }
            float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            this.field_70159_w += (double)(strafe * f2 - forward * f1);
            this.field_70181_x += (double)up;
            this.field_70179_y += (double)(forward * f2 + strafe * f1);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return this.handlers[2].cast();
            }
            if (facing.func_176740_k().func_200128_b()) {
                return this.handlers[0].cast();
            }
            if (facing.func_176740_k().func_176722_c()) {
                return this.handlers[1].cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!keepData) {
            for (int x = 0; x < this.handlers.length; ++x) {
                this.handlers[x].invalidate();
            }
        }
    }
}

