/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockAbstractSkull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.EntitySenses;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityAttach;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public abstract class EntityLiving
extends EntityLivingBase {
    private static final DataParameter<Byte> field_184654_a = EntityDataManager.func_187226_a(EntityLiving.class, DataSerializers.field_187191_a);
    public int field_70757_a;
    protected int field_70728_aV;
    protected EntityLookHelper field_70749_g;
    protected EntityMoveHelper field_70765_h;
    protected EntityJumpHelper field_70767_i;
    private final EntityBodyHelper field_70762_j;
    protected PathNavigate field_70699_by;
    public final EntityAITasks field_70714_bg;
    public final EntityAITasks field_70715_bh;
    private EntityLivingBase field_70696_bz;
    private final EntitySenses field_70723_bA;
    private final NonNullList<ItemStack> field_184656_bv = NonNullList.func_191197_a((int)2, (Object)((Object)ItemStack.field_190927_a));
    protected float[] field_82174_bp = new float[2];
    private final NonNullList<ItemStack> field_184657_bw = NonNullList.func_191197_a((int)4, (Object)((Object)ItemStack.field_190927_a));
    protected float[] field_184655_bs = new float[4];
    private boolean field_82172_bs;
    private boolean field_82179_bU;
    private final Map<PathNodeType, Float> field_184658_bz = Maps.newEnumMap(PathNodeType.class);
    private ResourceLocation field_184659_bA;
    private long field_184653_bB;
    private boolean field_110169_bv;
    private Entity field_110168_bw;
    private NBTTagCompound field_110170_bx;

    protected EntityLiving(EntityType<?> type, World worldIn) {
        super(type, worldIn);
        this.field_70714_bg = new EntityAITasks(worldIn != null && worldIn.field_72984_F != null ? worldIn.field_72984_F : null);
        this.field_70715_bh = new EntityAITasks(worldIn != null && worldIn.field_72984_F != null ? worldIn.field_72984_F : null);
        this.field_70749_g = new EntityLookHelper(this);
        this.field_70765_h = new EntityMoveHelper(this);
        this.field_70767_i = new EntityJumpHelper(this);
        this.field_70762_j = this.func_184650_s();
        this.field_70699_by = this.func_175447_b(worldIn);
        this.field_70723_bA = new EntitySenses(this);
        Arrays.fill(this.field_184655_bs, 0.085f);
        Arrays.fill(this.field_82174_bp, 0.085f);
        if (worldIn != null && !worldIn.field_72995_K) {
            this.func_184651_r();
        }
    }

    protected void func_184651_r() {
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateGround(this, worldIn);
    }

    public float func_184643_a(PathNodeType nodeType) {
        Float f = this.field_184658_bz.get(nodeType);
        return f == null ? nodeType.func_186289_a() : f.floatValue();
    }

    public void func_184644_a(PathNodeType nodeType, float priority) {
        this.field_184658_bz.put(nodeType, Float.valueOf(priority));
    }

    protected EntityBodyHelper func_184650_s() {
        return new EntityBodyHelper((EntityLivingBase)this);
    }

    public EntityLookHelper func_70671_ap() {
        return this.field_70749_g;
    }

    public EntityMoveHelper func_70605_aq() {
        return this.field_70765_h;
    }

    public EntityJumpHelper func_70683_ar() {
        return this.field_70767_i;
    }

    public PathNavigate func_70661_as() {
        return this.field_70699_by;
    }

    public EntitySenses func_70635_at() {
        return this.field_70723_bA;
    }

    @Nullable
    public EntityLivingBase func_70638_az() {
        return this.field_70696_bz;
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        this.field_70696_bz = entitylivingbaseIn;
        ForgeHooks.onLivingSetAttackTarget((EntityLivingBase)this, (EntityLivingBase)entitylivingbaseIn);
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return cls != EntityGhast.class;
    }

    public void func_70615_aA() {
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184654_a, (byte)0);
    }

    public int func_70627_aG() {
        return 80;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        this.field_70170_p.field_72984_F.func_76320_a("mobBaseTick");
        if (this.func_70089_S() && this.field_70146_Z.nextInt(1000) < this.field_70757_a++) {
            this.func_175456_n();
            this.func_70642_aH();
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    @Override
    protected void func_184581_c(DamageSource source) {
        this.func_175456_n();
        super.func_184581_c(source);
    }

    private void func_175456_n() {
        this.field_70757_a = -this.func_70627_aG();
    }

    @Override
    protected int func_70693_a(EntityPlayer player) {
        if (this.field_70728_aV > 0) {
            int i = this.field_70728_aV;
            for (int j = 0; j < this.field_184657_bw.size(); ++j) {
                if (((ItemStack)((Object)this.field_184657_bw.get(j))).func_190926_b() || !(this.field_184655_bs[j] <= 1.0f)) continue;
                i += 1 + this.field_70146_Z.nextInt(3);
            }
            for (int k = 0; k < this.field_184656_bv.size(); ++k) {
                if (((ItemStack)((Object)this.field_184656_bv.get(k))).func_190926_b() || !(this.field_82174_bp[k] <= 1.0f)) continue;
                i += 1 + this.field_70146_Z.nextInt(3);
            }
            return i;
        }
        return this.field_70728_aV;
    }

    public void func_70656_aK() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d3 = 10.0;
                this.field_70170_p.func_195594_a((IParticleData)Particles.field_197598_I, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * 10.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * 10.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * 10.0, d0, d1, d2);
            }
        } else {
            this.field_70170_p.func_72960_a(this, (byte)20);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 20) {
            this.func_70656_aK();
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.func_110159_bB();
            if (this.field_70173_aa % 5 == 0) {
                boolean flag = !(this.func_184179_bs() instanceof EntityLiving);
                boolean flag1 = !(this.func_184187_bx() instanceof EntityBoat);
                this.field_70714_bg.func_188527_a(1, flag);
                this.field_70714_bg.func_188527_a(4, flag && flag1);
                this.field_70714_bg.func_188527_a(2, flag);
            }
        }
    }

    @Override
    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        this.field_70762_j.func_75664_a();
        return p_110146_2_;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Nullable
    protected Item func_146068_u() {
        return null;
    }

    @Override
    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        Item item = this.func_146068_u();
        if (item != null) {
            int i = this.field_70146_Z.nextInt(3);
            if (lootingModifier > 0) {
                i += this.field_70146_Z.nextInt(lootingModifier + 1);
            }
            for (int j = 0; j < i; ++j) {
                this.func_199703_a(item);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("CanPickUpLoot", this.func_98052_bS());
        compound.func_74757_a("PersistenceRequired", this.field_82179_bU);
        NBTTagList nbttaglist = new NBTTagList();
        for (Object itemstack : this.field_184657_bw) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            if (!((ItemStack)((Object)itemstack)).func_190926_b()) {
                ((ItemStack)((Object)itemstack)).func_77955_b(nbttagcompound);
            }
            nbttaglist.add((INBTBase)nbttagcompound);
        }
        compound.func_74782_a("ArmorItems", (INBTBase)nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (Object itemstack1 : this.field_184656_bv) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (!((ItemStack)((Object)itemstack1)).func_190926_b()) {
                ((ItemStack)((Object)itemstack1)).func_77955_b(nbttagcompound1);
            }
            nbttaglist1.add((INBTBase)nbttagcompound1);
        }
        compound.func_74782_a("HandItems", (INBTBase)nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (Object f : (Object)this.field_184655_bs) {
            nbttaglist2.add((INBTBase)new NBTTagFloat((float)f));
        }
        compound.func_74782_a("ArmorDropChances", (INBTBase)nbttaglist2);
        NBTTagList nbttaglist3 = new NBTTagList();
        for (float f1 : this.field_82174_bp) {
            nbttaglist3.add((INBTBase)new NBTTagFloat(f1));
        }
        compound.func_74782_a("HandDropChances", (INBTBase)nbttaglist3);
        compound.func_74757_a("Leashed", this.field_110169_bv);
        if (this.field_110168_bw != null) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            if (this.field_110168_bw instanceof EntityLivingBase) {
                UUID uuid = this.field_110168_bw.func_110124_au();
                nbttagcompound2.func_186854_a("UUID", uuid);
            } else if (this.field_110168_bw instanceof EntityHanging) {
                BlockPos blockpos = ((EntityHanging)this.field_110168_bw).func_174857_n();
                nbttagcompound2.func_74768_a("X", blockpos.func_177958_n());
                nbttagcompound2.func_74768_a("Y", blockpos.func_177956_o());
                nbttagcompound2.func_74768_a("Z", blockpos.func_177952_p());
            }
            compound.func_74782_a("Leash", nbttagcompound2);
        }
        compound.func_74757_a("LeftHanded", this.func_184638_cS());
        if (this.field_184659_bA != null) {
            compound.func_74778_a("DeathLootTable", this.field_184659_bA.toString());
            if (this.field_184653_bB != 0L) {
                compound.func_74772_a("DeathLootTableSeed", this.field_184653_bB);
            }
        }
        if (this.func_175446_cd()) {
            compound.func_74757_a("NoAI", this.func_175446_cd());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("CanPickUpLoot", 1)) {
            this.func_98053_h(compound.func_74767_n("CanPickUpLoot"));
        }
        this.field_82179_bU = compound.func_74767_n("PersistenceRequired");
        if (compound.func_150297_b("ArmorItems", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("ArmorItems", 10);
            for (int i = 0; i < this.field_184657_bw.size(); ++i) {
                this.field_184657_bw.set(i, (Object)ItemStack.func_199557_a(nbttaglist.func_150305_b(i)));
            }
        }
        if (compound.func_150297_b("HandItems", 9)) {
            NBTTagList nbttaglist1 = compound.func_150295_c("HandItems", 10);
            for (int j = 0; j < this.field_184656_bv.size(); ++j) {
                this.field_184656_bv.set(j, (Object)ItemStack.func_199557_a(nbttaglist1.func_150305_b(j)));
            }
        }
        if (compound.func_150297_b("ArmorDropChances", 9)) {
            NBTTagList nbttaglist2 = compound.func_150295_c("ArmorDropChances", 5);
            for (int k = 0; k < nbttaglist2.size(); ++k) {
                this.field_184655_bs[k] = nbttaglist2.func_150308_e(k);
            }
        }
        if (compound.func_150297_b("HandDropChances", 9)) {
            NBTTagList nbttaglist3 = compound.func_150295_c("HandDropChances", 5);
            for (int l = 0; l < nbttaglist3.size(); ++l) {
                this.field_82174_bp[l] = nbttaglist3.func_150308_e(l);
            }
        }
        this.field_110169_bv = compound.func_74767_n("Leashed");
        if (this.field_110169_bv && compound.func_150297_b("Leash", 10)) {
            this.field_110170_bx = compound.func_74775_l("Leash");
        }
        this.func_184641_n(compound.func_74767_n("LeftHanded"));
        if (compound.func_150297_b("DeathLootTable", 8)) {
            this.field_184659_bA = new ResourceLocation(compound.func_74779_i("DeathLootTable"));
            this.field_184653_bB = compound.func_74763_f("DeathLootTableSeed");
        }
        this.func_94061_f(compound.func_74767_n("NoAI"));
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    @Override
    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        ResourceLocation resourcelocation = this.field_184659_bA;
        if (resourcelocation == null) {
            resourcelocation = this.func_184647_J();
        }
        if (resourcelocation != null) {
            LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
            this.field_184659_bA = null;
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a(this).func_186473_a(source).func_204313_a(new BlockPos((Entity)this));
            if (wasRecentlyHit && this.field_70717_bb != null) {
                lootcontext$builder = lootcontext$builder.func_186470_a(this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da());
            }
            for (ItemStack itemstack : loottable.func_186462_a(this.field_184653_bB == 0L ? this.field_70146_Z : new Random(this.field_184653_bB), lootcontext$builder.func_186471_a())) {
                this.func_199701_a_(itemstack);
            }
            this.func_82160_b(wasRecentlyHit, lootingModifier);
        } else {
            super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        }
    }

    public void func_191989_p(float amount) {
        this.field_191988_bg = amount;
    }

    public void func_70657_f(float amount) {
        this.field_70701_bs = amount;
    }

    public void func_184646_p(float amount) {
        this.field_70702_br = amount;
    }

    @Override
    public void func_70659_e(float speedIn) {
        super.func_70659_e(speedIn);
        this.func_191989_p(speedIn);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.field_70170_p.field_72984_F.func_76320_a("looting");
        if (!this.field_70170_p.field_72995_K && this.func_98052_bS() && !this.field_70729_aU && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            for (EntityItem entityitem : this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0))) {
                if (entityitem.field_70128_L || entityitem.func_92059_d().func_190926_b() || entityitem.func_174874_s()) continue;
                this.func_175445_a(entityitem);
            }
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    protected void func_175445_a(EntityItem itemEntity) {
        EntityEquipmentSlot entityequipmentslot;
        ItemStack itemstack1;
        ItemStack itemstack = itemEntity.func_92059_d();
        boolean flag = this.func_208003_a(itemstack, itemstack1 = this.func_184582_a(entityequipmentslot = EntityLiving.func_184640_d(itemstack)), entityequipmentslot);
        if (flag && this.func_175448_a(itemstack)) {
            double d0 = this.func_205712_c(entityequipmentslot);
            if (!itemstack1.func_190926_b() && (double)(this.field_70146_Z.nextFloat() - 0.1f) < d0) {
                this.func_199701_a_(itemstack1);
            }
            this.func_184201_a(entityequipmentslot, itemstack);
            switch (entityequipmentslot.func_188453_a()) {
                case HAND: {
                    this.field_82174_bp[entityequipmentslot.func_188454_b()] = 2.0f;
                    break;
                }
                case ARMOR: {
                    this.field_184655_bs[entityequipmentslot.func_188454_b()] = 2.0f;
                }
            }
            this.field_82179_bU = true;
            this.func_71001_a(itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
        }
    }

    protected boolean func_208003_a(ItemStack candidate, ItemStack existing, EntityEquipmentSlot p_208003_3_) {
        boolean flag = true;
        if (!existing.func_190926_b()) {
            if (p_208003_3_.func_188453_a() == EntityEquipmentSlot.Type.HAND) {
                if (candidate.func_77973_b() instanceof ItemSword && !(existing.func_77973_b() instanceof ItemSword)) {
                    flag = true;
                } else if (candidate.func_77973_b() instanceof ItemSword && existing.func_77973_b() instanceof ItemSword) {
                    ItemSword itemsword = (ItemSword)candidate.func_77973_b();
                    ItemSword itemsword1 = (ItemSword)existing.func_77973_b();
                    flag = itemsword.func_200894_d() == itemsword1.func_200894_d() ? candidate.func_77952_i() < existing.func_77952_i() || candidate.func_77942_o() && !existing.func_77942_o() : itemsword.func_200894_d() > itemsword1.func_200894_d();
                } else {
                    flag = candidate.func_77973_b() instanceof ItemBow && existing.func_77973_b() instanceof ItemBow ? candidate.func_77942_o() && !existing.func_77942_o() : false;
                }
            } else if (candidate.func_77973_b() instanceof ItemArmor && !(existing.func_77973_b() instanceof ItemArmor)) {
                flag = true;
            } else if (candidate.func_77973_b() instanceof ItemArmor && existing.func_77973_b() instanceof ItemArmor && !EnchantmentHelper.func_190938_b(existing)) {
                ItemArmor itemarmor = (ItemArmor)candidate.func_77973_b();
                ItemArmor itemarmor1 = (ItemArmor)existing.func_77973_b();
                flag = itemarmor.func_200881_e() == itemarmor1.func_200881_e() ? candidate.func_77952_i() < existing.func_77952_i() || candidate.func_77942_o() && !existing.func_77942_o() : itemarmor.func_200881_e() > itemarmor1.func_200881_e();
            } else {
                flag = false;
            }
        }
        return flag;
    }

    protected boolean func_175448_a(ItemStack stack) {
        return true;
    }

    public boolean func_70692_ba() {
        return true;
    }

    protected void func_70623_bb() {
        Event.Result result = null;
        if (this.field_82179_bU) {
            this.field_70708_bq = 0;
        } else if ((this.field_70708_bq & 0x1F) == 31 && (result = ForgeEventFactory.canEntityDespawn((EntityLiving)this)) != Event.Result.DEFAULT) {
            if (result == Event.Result.DENY) {
                this.field_70708_bq = 0;
            } else {
                this.func_70106_y();
            }
        } else {
            EntityPlayer entity = this.field_70170_p.func_72890_a(this, -1.0);
            if (entity != null) {
                double d0 = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70163_u - this.field_70163_u;
                double d2 = entity.field_70161_v - this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.func_70692_ba() && d3 > 16384.0) {
                    this.func_70106_y();
                }
                if (this.field_70708_bq > 600 && this.field_70146_Z.nextInt(800) == 0 && d3 > 1024.0 && this.func_70692_ba()) {
                    this.func_70106_y();
                } else if (d3 < 1024.0) {
                    this.field_70708_bq = 0;
                }
            }
        }
    }

    @Override
    protected final void func_70626_be() {
        ++this.field_70708_bq;
        this.field_70170_p.field_72984_F.func_76320_a("checkDespawn");
        this.func_70623_bb();
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("sensing");
        this.field_70723_bA.func_75523_a();
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("targetSelector");
        this.field_70715_bh.func_75774_a();
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("goalSelector");
        this.field_70714_bg.func_75774_a();
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("navigation");
        this.field_70699_by.func_75501_e();
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("mob tick");
        this.func_70619_bc();
        this.field_70170_p.field_72984_F.func_76319_b();
        if (this.func_184218_aH() && this.func_184187_bx() instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)this.func_184187_bx();
            entityliving.func_70661_as().func_75484_a(this.func_70661_as().func_75505_d(), 1.5);
            entityliving.func_70605_aq().func_188487_a(this.func_70605_aq());
        }
        this.field_70170_p.field_72984_F.func_76320_a("controls");
        this.field_70170_p.field_72984_F.func_76320_a("move");
        this.field_70765_h.func_75641_c();
        this.field_70170_p.field_72984_F.func_76318_c("look");
        this.field_70749_g.func_75649_a();
        this.field_70170_p.field_72984_F.func_76318_c("jump");
        this.field_70767_i.func_75661_b();
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    protected void func_70619_bc() {
    }

    public int func_70646_bf() {
        return 40;
    }

    public int func_184649_cE() {
        return 10;
    }

    public void func_70625_a(Entity entityIn, float maxYawIncrease, float maxPitchIncrease) {
        double d1;
        double d0 = entityIn.field_70165_t - this.field_70165_t;
        double d2 = entityIn.field_70161_v - this.field_70161_v;
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)entityIn;
            d1 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        } else {
            d1 = (entityIn.func_174813_aQ().field_72338_b + entityIn.func_174813_aQ().field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
        this.field_70125_A = this.func_70663_b(this.field_70125_A, f1, maxPitchIncrease);
        this.field_70177_z = this.func_70663_b(this.field_70177_z, f, maxYawIncrease);
    }

    private float func_70663_b(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    public boolean func_205020_a(IWorld worldIn, boolean p_205020_2_) {
        IBlockState iblockstate = worldIn.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return iblockstate.func_189884_a(this);
    }

    public final boolean func_70058_J() {
        return this.func_205019_a(this.field_70170_p);
    }

    public boolean func_205019_a(IWorldReaderBase worldIn) {
        return !worldIn.func_72953_d(this.func_174813_aQ()) && worldIn.func_195586_b((Entity)this, this.func_174813_aQ()) && worldIn.func_195587_c((Entity)this, this.func_174813_aQ());
    }

    public float func_70603_bj() {
        return 1.0f;
    }

    public int func_70641_bl() {
        return 4;
    }

    public boolean func_204209_c(int p_204209_1_) {
        return false;
    }

    @Override
    public int func_82143_as() {
        if (this.func_70638_az() == null) {
            return 3;
        }
        int i = (int)(this.func_110143_aJ() - this.func_110138_aP() * 0.33f);
        if ((i -= (3 - this.field_70170_p.func_175659_aa().func_151525_a()) * 4) < 0) {
            i = 0;
        }
        return i + 3;
    }

    @Override
    public Iterable<ItemStack> func_184214_aD() {
        return this.field_184656_bv;
    }

    @Override
    public Iterable<ItemStack> func_184193_aE() {
        return this.field_184657_bw;
    }

    @Override
    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                return (ItemStack)((Object)this.field_184656_bv.get(slotIn.func_188454_b()));
            }
            case ARMOR: {
                return (ItemStack)((Object)this.field_184657_bw.get(slotIn.func_188454_b()));
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                this.field_184656_bv.set(slotIn.func_188454_b(), (Object)stack);
                break;
            }
            case ARMOR: {
                this.field_184657_bw.set(slotIn.func_188454_b(), (Object)stack);
            }
        }
    }

    @Override
    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            boolean flag;
            ItemStack itemstack = this.func_184582_a(entityequipmentslot);
            float f = this.func_205712_c(entityequipmentslot);
            boolean bl = flag = f > 1.0f;
            if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c(itemstack) || !wasRecentlyHit && !flag || !(this.field_70146_Z.nextFloat() - (float)lootingModifier * 0.01f < f)) continue;
            if (!flag && itemstack.func_77984_f()) {
                itemstack.func_196085_b(itemstack.func_77958_k() - this.field_70146_Z.nextInt(1 + this.field_70146_Z.nextInt(Math.max(itemstack.func_77958_k() - 3, 1))));
            }
            this.func_199701_a_(itemstack);
        }
    }

    protected float func_205712_c(EntityEquipmentSlot p_205712_1_) {
        float f;
        switch (p_205712_1_.func_188453_a()) {
            case HAND: {
                f = this.field_82174_bp[p_205712_1_.func_188454_b()];
                break;
            }
            case ARMOR: {
                f = this.field_184655_bs[p_205712_1_.func_188454_b()];
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return f;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        if (this.field_70146_Z.nextFloat() < 0.15f * difficulty.func_180170_c()) {
            float f;
            int i = this.field_70146_Z.nextInt(2);
            float f2 = f = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.1f : 0.25f;
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                Item item;
                if (entityequipmentslot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (!flag && this.field_70146_Z.nextFloat() < f) break;
                flag = false;
                if (!itemstack.func_190926_b() || (item = EntityLiving.func_184636_a(entityequipmentslot, i)) == null) continue;
                this.func_184201_a(entityequipmentslot, new ItemStack(item));
            }
        }
    }

    public static EntityEquipmentSlot func_184640_d(ItemStack stack) {
        EntityEquipmentSlot slot = stack.getEquipmentSlot();
        if (slot != null) {
            return slot;
        }
        Item item = stack.func_77973_b();
        if (!(item == Blocks.field_196625_cS.func_199767_j() || item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof BlockAbstractSkull)) {
            if (item instanceof ItemArmor) {
                return ((ItemArmor)item).func_185083_B_();
            }
            if (item == Items.field_185160_cR) {
                return EntityEquipmentSlot.CHEST;
            }
            return stack.isShield(null) ? EntityEquipmentSlot.OFFHAND : EntityEquipmentSlot.MAINHAND;
        }
        return EntityEquipmentSlot.HEAD;
    }

    @Nullable
    public static Item func_184636_a(EntityEquipmentSlot slotIn, int chance) {
        switch (slotIn) {
            case HEAD: {
                if (chance == 0) {
                    return Items.field_151024_Q;
                }
                if (chance == 1) {
                    return Items.field_151169_ag;
                }
                if (chance == 2) {
                    return Items.field_151020_U;
                }
                if (chance == 3) {
                    return Items.field_151028_Y;
                }
                if (chance == 4) {
                    return Items.field_151161_ac;
                }
            }
            case CHEST: {
                if (chance == 0) {
                    return Items.field_151027_R;
                }
                if (chance == 1) {
                    return Items.field_151171_ah;
                }
                if (chance == 2) {
                    return Items.field_151023_V;
                }
                if (chance == 3) {
                    return Items.field_151030_Z;
                }
                if (chance == 4) {
                    return Items.field_151163_ad;
                }
            }
            case LEGS: {
                if (chance == 0) {
                    return Items.field_151026_S;
                }
                if (chance == 1) {
                    return Items.field_151149_ai;
                }
                if (chance == 2) {
                    return Items.field_151022_W;
                }
                if (chance == 3) {
                    return Items.field_151165_aa;
                }
                if (chance == 4) {
                    return Items.field_151173_ae;
                }
            }
            case FEET: {
                if (chance == 0) {
                    return Items.field_151021_T;
                }
                if (chance == 1) {
                    return Items.field_151151_aj;
                }
                if (chance == 2) {
                    return Items.field_151029_X;
                }
                if (chance == 3) {
                    return Items.field_151167_ab;
                }
                if (chance != 4) break;
                return Items.field_151175_af;
            }
        }
        return null;
    }

    protected void func_180483_b(DifficultyInstance difficulty) {
        float f = difficulty.func_180170_c();
        if (!this.func_184614_ca().func_190926_b() && this.field_70146_Z.nextFloat() < 0.25f * f) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, EnchantmentHelper.func_77504_a(this.field_70146_Z, this.func_184614_ca(), (int)(5.0f + f * (float)this.field_70146_Z.nextInt(18)), false));
        }
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            ItemStack itemstack;
            if (entityequipmentslot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || (itemstack = this.func_184582_a(entityequipmentslot)).func_190926_b() || !(this.field_70146_Z.nextFloat() < 0.5f * f)) continue;
            this.func_184201_a(entityequipmentslot, EnchantmentHelper.func_77504_a(this.field_70146_Z, itemstack, (int)(5.0f + f * (float)this.field_70146_Z.nextInt(18)), false));
        }
    }

    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData, @Nullable NBTTagCompound itemNbt) {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        if (this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184641_n(true);
        } else {
            this.func_184641_n(false);
        }
        return entityLivingData;
    }

    public boolean func_82171_bF() {
        return false;
    }

    public void func_110163_bv() {
        this.field_82179_bU = true;
    }

    public void func_184642_a(EntityEquipmentSlot slotIn, float chance) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                this.field_82174_bp[slotIn.func_188454_b()] = chance;
                break;
            }
            case ARMOR: {
                this.field_184655_bs[slotIn.func_188454_b()] = chance;
            }
        }
    }

    public boolean func_98052_bS() {
        return this.field_82172_bs;
    }

    public void func_98053_h(boolean canPickup) {
        this.field_82172_bs = canPickup;
    }

    public boolean func_104002_bU() {
        return this.field_82179_bU;
    }

    @Override
    public final boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.func_110167_bD() && this.func_110166_bE() == player) {
            this.func_110160_i(true, !player.field_71075_bZ.field_75098_d);
            return true;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151058_ca && this.func_184652_a(player)) {
            this.func_110162_b(player, true);
            itemstack.func_190918_g(1);
            return true;
        }
        return this.func_184645_a(player, hand) ? true : super.func_184230_a(player, hand);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    protected void func_110159_bB() {
        if (this.field_110170_bx != null) {
            this.func_110165_bF();
        }
        if (this.field_110169_bv) {
            if (!this.func_70089_S()) {
                this.func_110160_i(true, true);
            }
            if (this.field_110168_bw == null || this.field_110168_bw.field_70128_L) {
                this.func_110160_i(true, true);
            }
        }
    }

    public void func_110160_i(boolean sendPacket, boolean dropLead) {
        if (this.field_110169_bv) {
            this.field_110169_bv = false;
            this.field_110168_bw = null;
            if (!this.field_70170_p.field_72995_K && dropLead) {
                this.func_199703_a(Items.field_151058_ca);
            }
            if (!this.field_70170_p.field_72995_K && sendPacket && this.field_70170_p instanceof WorldServer) {
                ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a(this, (Packet<?>)new SPacketEntityAttach((Entity)this, (Entity)null));
            }
        }
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_110167_bD() && !(this instanceof IMob);
    }

    public boolean func_110167_bD() {
        return this.field_110169_bv;
    }

    public Entity func_110166_bE() {
        return this.field_110168_bw;
    }

    public void func_110162_b(Entity entityIn, boolean sendAttachNotification) {
        this.field_110169_bv = true;
        this.field_110168_bw = entityIn;
        if (!this.field_70170_p.field_72995_K && sendAttachNotification && this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a(this, (Packet<?>)new SPacketEntityAttach((Entity)this, this.field_110168_bw));
        }
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
    }

    @Override
    public boolean func_184205_a(Entity entityIn, boolean force) {
        boolean flag = super.func_184205_a(entityIn, force);
        if (flag && this.func_110167_bD()) {
            this.func_110160_i(true, true);
        }
        return flag;
    }

    private void func_110165_bF() {
        if (this.field_110169_bv && this.field_110170_bx != null) {
            if (this.field_110170_bx.func_186855_b("UUID")) {
                UUID uuid = this.field_110170_bx.func_186857_a("UUID");
                for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(10.0))) {
                    if (!entitylivingbase.func_110124_au().equals(uuid)) continue;
                    this.func_110162_b(entitylivingbase, true);
                    break;
                }
            } else if (this.field_110170_bx.func_150297_b("X", 99) && this.field_110170_bx.func_150297_b("Y", 99) && this.field_110170_bx.func_150297_b("Z", 99)) {
                BlockPos blockpos = new BlockPos(this.field_110170_bx.func_74762_e("X"), this.field_110170_bx.func_74762_e("Y"), this.field_110170_bx.func_74762_e("Z"));
                EntityLeashKnot entityleashknot = EntityLeashKnot.func_174863_b(this.field_70170_p, blockpos);
                if (entityleashknot == null) {
                    entityleashknot = EntityLeashKnot.func_174862_a(this.field_70170_p, blockpos);
                }
                this.func_110162_b(entityleashknot, true);
            } else {
                this.func_110160_i(false, true);
            }
        }
        this.field_110170_bx = null;
    }

    @Override
    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        EntityEquipmentSlot entityequipmentslot;
        if (inventorySlot == 98) {
            entityequipmentslot = EntityEquipmentSlot.MAINHAND;
        } else if (inventorySlot == 99) {
            entityequipmentslot = EntityEquipmentSlot.OFFHAND;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.HEAD.func_188454_b()) {
            entityequipmentslot = EntityEquipmentSlot.HEAD;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.CHEST.func_188454_b()) {
            entityequipmentslot = EntityEquipmentSlot.CHEST;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.LEGS.func_188454_b()) {
            entityequipmentslot = EntityEquipmentSlot.LEGS;
        } else {
            if (inventorySlot != 100 + EntityEquipmentSlot.FEET.func_188454_b()) {
                return false;
            }
            entityequipmentslot = EntityEquipmentSlot.FEET;
        }
        if (!itemStackIn.func_190926_b() && !EntityLiving.func_184648_b(entityequipmentslot, itemStackIn) && entityequipmentslot != EntityEquipmentSlot.HEAD) {
            return false;
        }
        this.func_184201_a(entityequipmentslot, itemStackIn);
        return true;
    }

    @Override
    public boolean func_184186_bw() {
        return this.func_82171_bF() && super.func_184186_bw();
    }

    public static boolean func_184648_b(EntityEquipmentSlot slotIn, ItemStack stack) {
        EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d(stack);
        return entityequipmentslot == slotIn || entityequipmentslot == EntityEquipmentSlot.MAINHAND && slotIn == EntityEquipmentSlot.OFFHAND || entityequipmentslot == EntityEquipmentSlot.OFFHAND && slotIn == EntityEquipmentSlot.MAINHAND;
    }

    @Override
    public boolean func_70613_aW() {
        return super.func_70613_aW() && !this.func_175446_cd();
    }

    public void func_94061_f(boolean disable) {
        byte b0 = this.field_70180_af.func_187225_a(field_184654_a);
        this.field_70180_af.func_187227_b(field_184654_a, disable ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void func_184641_n(boolean leftHanded) {
        byte b0 = this.field_70180_af.func_187225_a(field_184654_a);
        this.field_70180_af.func_187227_b(field_184654_a, leftHanded ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public boolean func_175446_cd() {
        return (this.field_70180_af.func_187225_a(field_184654_a) & 1) != 0;
    }

    public boolean func_184638_cS() {
        return (this.field_70180_af.func_187225_a(field_184654_a) & 2) != 0;
    }

    @Override
    public EnumHandSide func_184591_cq() {
        return this.func_184638_cS() ? EnumHandSide.LEFT : EnumHandSide.RIGHT;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a(this.func_184614_ca(), ((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a(this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a(this, (float)i * 0.5f, MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a(this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.canDisableShield(itemstack1, entityplayer, this) && itemstack1.isShield(entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e(this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a(entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a(this, entityIn);
        }
        return flag;
    }

    protected boolean func_204609_dp() {
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            BlockPos blockpos;
            float f = this.func_70013_c();
            BlockPos blockPos = blockpos = this.func_184187_bx() instanceof EntityBoat ? new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v).func_177984_a() : new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
            if (f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(blockpos)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void func_180466_bG(Tag<Fluid> p_180466_1_) {
        if (this.func_70661_as().func_212238_t()) {
            super.func_180466_bG(p_180466_1_);
        } else {
            this.field_70181_x += (double)0.3f;
        }
    }
}

