/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeEntity;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Entity
extends CapabilityProvider<Entity>
implements INameable,
ICommandSource,
IForgeEntity {
    protected static final Logger field_184243_a = LogManager.getLogger();
    private static final List<ItemStack> field_190535_b = Collections.emptyList();
    private static final AxisAlignedBB field_174836_a = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static double field_70155_l = 1.0;
    private static int field_70152_a;
    @Deprecated
    private final EntityType<?> field_200606_g;
    private int field_145783_c = field_70152_a++;
    public boolean field_70156_m;
    private final List<Entity> field_184244_h = Lists.newArrayList();
    protected int field_184245_j;
    private Entity field_184239_as;
    public boolean field_98038_p;
    public World field_70170_p;
    public double field_70169_q;
    public double field_70167_r;
    public double field_70166_s;
    public double field_70165_t;
    public double field_70163_u;
    public double field_70161_v;
    public double field_70159_w;
    public double field_70181_x;
    public double field_70179_y;
    public float field_70177_z;
    public float field_70125_A;
    public float field_70126_B;
    public float field_70127_C;
    private AxisAlignedBB field_70121_D = field_174836_a;
    public boolean field_70122_E;
    public boolean field_70123_F;
    public boolean field_70124_G;
    public boolean field_70132_H;
    public boolean field_70133_I;
    protected boolean field_70134_J;
    private boolean field_174835_g;
    @Deprecated
    public boolean field_70128_L;
    public float field_70130_N = 0.6f;
    public float field_70131_O = 1.8f;
    public float field_70141_P;
    public float field_70140_Q;
    public float field_82151_R;
    public float field_70143_R;
    private float field_70150_b = 1.0f;
    private float field_191959_ay = 1.0f;
    public double field_70142_S;
    public double field_70137_T;
    public double field_70136_U;
    public float field_70138_W;
    public boolean field_70145_X;
    public float field_70144_Y;
    protected Random field_70146_Z = new Random();
    public int field_70173_aa;
    private int field_190534_ay = -this.func_190531_bD();
    protected boolean field_70171_ac;
    protected double field_211517_W;
    protected boolean field_205013_W;
    public int field_70172_ad;
    protected boolean field_70148_d = true;
    protected boolean field_70178_ae;
    protected EntityDataManager field_70180_af;
    protected static final DataParameter<Byte> field_184240_ax;
    private static final DataParameter<Integer> field_184241_ay;
    private static final DataParameter<Optional<ITextComponent>> field_184242_az;
    private static final DataParameter<Boolean> field_184233_aA;
    private static final DataParameter<Boolean> field_184234_aB;
    private static final DataParameter<Boolean> field_189655_aD;
    public boolean field_70175_ag;
    public int field_70176_ah;
    public int field_70162_ai;
    public int field_70164_aj;
    @OnlyIn(value=Dist.CLIENT)
    public long field_70118_ct;
    @OnlyIn(value=Dist.CLIENT)
    public long field_70117_cu;
    @OnlyIn(value=Dist.CLIENT)
    public long field_70116_cv;
    public boolean field_70158_ak;
    public boolean field_70160_al;
    public int field_71088_bW;
    protected boolean field_71087_bX;
    protected int field_82153_h;
    public DimensionType field_71093_bK;
    protected BlockPos field_181016_an;
    protected Vec3d field_181017_ao;
    protected EnumFacing field_181018_ap;
    private boolean field_83001_bt;
    protected UUID field_96093_i = MathHelper.func_180182_a((Random)this.field_70146_Z);
    protected String field_189513_ar = this.field_96093_i.toString();
    protected boolean field_184238_ar;
    private final Set<String> field_184236_aF = Sets.newHashSet();
    private boolean field_184237_aG;
    private final double[] field_191505_aI = new double[]{0.0, 0.0, 0.0};
    private long field_191506_aJ;
    private boolean canUpdate = true;
    private Collection<EntityItem> captureDrops = null;
    private NBTTagCompound entityData;
    private boolean isAddedToWorld;

    public Entity(EntityType<?> entityTypeIn, World worldIn) {
        super(Entity.class);
        this.field_200606_g = entityTypeIn;
        this.field_70170_p = worldIn;
        this.func_70107_b(0.0, 0.0, 0.0);
        if (worldIn != null) {
            this.field_71093_bK = worldIn.field_73011_w.func_186058_p();
        }
        this.field_70180_af = new EntityDataManager(this);
        this.field_70180_af.func_187214_a(field_184240_ax, (byte)0);
        this.field_70180_af.func_187214_a(field_184241_ay, this.func_205010_bg());
        this.field_70180_af.func_187214_a(field_184233_aA, false);
        this.field_70180_af.func_187214_a(field_184242_az, Optional.empty());
        this.field_70180_af.func_187214_a(field_184234_aB, false);
        this.field_70180_af.func_187214_a(field_189655_aD, false);
        this.func_70088_a();
        MinecraftForge.EVENT_BUS.post((Event)new EntityEvent.EntityConstructing(this));
        this.gatherCapabilities();
    }

    public EntityType<?> func_200600_R() {
        return this.field_200606_g;
    }

    public int func_145782_y() {
        return this.field_145783_c;
    }

    public void func_145769_d(int id) {
        this.field_145783_c = id;
    }

    public Set<String> func_184216_O() {
        return this.field_184236_aF;
    }

    public boolean func_184211_a(String tag) {
        return this.field_184236_aF.size() >= 1024 ? false : this.field_184236_aF.add(tag);
    }

    public boolean func_184197_b(String tag) {
        return this.field_184236_aF.remove(tag);
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    protected abstract void func_70088_a();

    public EntityDataManager func_184212_Q() {
        return this.field_70180_af;
    }

    public boolean equals(Object p_equals_1_) {
        if (p_equals_1_ instanceof Entity) {
            return ((Entity)((Object)p_equals_1_)).field_145783_c == this.field_145783_c;
        }
        return false;
    }

    public int hashCode() {
        return this.field_145783_c;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void func_70065_x() {
        if (this.field_70170_p != null) {
            while (this.field_70163_u > 0.0 && this.field_70163_u < 256.0) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_195586_b(this, this.func_174813_aQ())) break;
                this.field_70163_u += 1.0;
            }
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70125_A = 0.0f;
        }
    }

    public void func_70106_y() {
        this.remove(false);
    }

    public void remove(boolean keepData) {
        this.field_70128_L = true;
        if (!keepData) {
            this.invalidateCaps();
        }
    }

    public void func_184174_b(boolean dropWhenDead) {
    }

    protected void func_70105_a(float width, float height) {
        if (width != this.field_70130_N || height != this.field_70131_O) {
            float f = this.field_70130_N;
            this.field_70130_N = width;
            this.field_70131_O = height;
            if (this.field_70130_N < f) {
                double d0 = (double)width / 2.0;
                this.func_174826_a(new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + d0));
                return;
            }
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)this.field_70130_N, axisalignedbb.field_72338_b + (double)this.field_70131_O, axisalignedbb.field_72339_c + (double)this.field_70130_N));
            if (this.field_70130_N > f && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
                this.func_70091_d(MoverType.SELF, f - this.field_70130_N, 0.0, f - this.field_70130_N);
            }
        }
    }

    protected void func_70101_b(float yaw, float pitch) {
        this.field_70177_z = yaw % 360.0f;
        this.field_70125_A = pitch % 360.0f;
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a(this, false);
        }
        float f = this.field_70130_N / 2.0f;
        float f1 = this.field_70131_O;
        this.func_174826_a(new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_195049_a(double yaw, double pitch) {
        double d0 = pitch * 0.15;
        double d1 = yaw * 0.15;
        this.field_70125_A = (float)((double)this.field_70125_A + d0);
        this.field_70177_z = (float)((double)this.field_70177_z + d1);
        this.field_70125_A = MathHelper.func_76131_a((float)this.field_70125_A, (float)-90.0f, (float)90.0f);
        this.field_70127_C = (float)((double)this.field_70127_C + d0);
        this.field_70126_B = (float)((double)this.field_70126_B + d1);
        this.field_70127_C = MathHelper.func_76131_a((float)this.field_70127_C, (float)-90.0f, (float)90.0f);
        if (this.field_184239_as != null) {
            this.field_184239_as.func_184190_l(this);
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
    }

    public void func_70030_z() {
        this.field_70170_p.field_72984_F.func_76320_a("entityBaseTick");
        if (this.func_184218_aH() && this.func_184187_bx().field_70128_L) {
            this.func_184210_p();
        }
        if (this.field_184245_j > 0) {
            --this.field_184245_j;
        }
        this.field_70141_P = this.field_70140_Q;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof WorldServer) {
            this.field_70170_p.field_72984_F.func_76320_a("portal");
            if (this.field_71087_bX) {
                MinecraftServer minecraftserver = this.field_70170_p.func_73046_m();
                if (minecraftserver.func_71255_r()) {
                    int i;
                    if (!this.func_184218_aH() && this.field_82153_h++ >= (i = this.func_82145_z())) {
                        this.field_82153_h = i;
                        this.field_71088_bW = this.func_82147_ab();
                        DimensionType dimensiontype = this.field_70170_p.field_73011_w.func_186058_p() == DimensionType.NETHER ? DimensionType.OVERWORLD : DimensionType.NETHER;
                        this.func_212321_a(dimensiontype);
                    }
                    this.field_71087_bX = false;
                }
            } else {
                if (this.field_82153_h > 0) {
                    this.field_82153_h -= 4;
                }
                if (this.field_82153_h < 0) {
                    this.field_82153_h = 0;
                }
            }
            this.func_184173_H();
            this.field_70170_p.field_72984_F.func_76319_b();
        }
        this.func_174830_Y();
        this.func_205011_p();
        if (this.field_70170_p.field_72995_K) {
            this.func_70066_B();
        } else if (this.field_190534_ay > 0) {
            if (this.field_70178_ae) {
                this.field_190534_ay -= 4;
                if (this.field_190534_ay < 0) {
                    this.func_70066_B();
                }
            } else {
                if (this.field_190534_ay % 20 == 0) {
                    this.func_70097_a(DamageSource.field_76370_b, 1.0f);
                }
                --this.field_190534_ay;
            }
        }
        if (this.func_180799_ab()) {
            this.func_70044_A();
            this.field_70143_R *= 0.5f;
        }
        if (this.field_70163_u < -64.0) {
            this.func_70076_C();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(0, this.field_190534_ay > 0);
        }
        this.field_70148_d = false;
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    protected void func_184173_H() {
        if (this.field_71088_bW > 0) {
            --this.field_71088_bW;
        }
    }

    public int func_82145_z() {
        return 1;
    }

    protected void func_70044_A() {
        if (!this.field_70178_ae) {
            this.func_70015_d(15);
            this.func_70097_a(DamageSource.field_76371_c, 4.0f);
        }
    }

    public void func_70015_d(int seconds) {
        int i = seconds * 20;
        if (this instanceof EntityLivingBase) {
            i = EnchantmentProtection.func_92093_a((EntityLivingBase)((EntityLivingBase)this), (int)i);
        }
        if (this.field_190534_ay < i) {
            this.field_190534_ay = i;
        }
    }

    public void func_70066_B() {
        this.field_190534_ay = 0;
    }

    protected void func_70076_C() {
        this.func_70106_y();
    }

    public boolean func_70038_c(double x, double y, double z) {
        return this.func_174809_b(this.func_174813_aQ().func_72317_d(x, y, z));
    }

    private boolean func_174809_b(AxisAlignedBB bb) {
        return this.field_70170_p.func_195586_b(this, bb) && !this.field_70170_p.func_72953_d(bb);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.field_70145_X) {
            this.func_174826_a(this.func_174813_aQ().func_72317_d(x, y, z));
            this.func_174829_m();
        } else {
            BlockPos blockpos1;
            IBlockState iblockstate1;
            Block block1;
            boolean flag;
            if (type == MoverType.PISTON) {
                long i = this.field_70170_p.func_82737_E();
                if (i != this.field_191506_aJ) {
                    Arrays.fill(this.field_191505_aI, 0.0);
                    this.field_191506_aJ = i;
                }
                if (x != 0.0) {
                    int j = EnumFacing.Axis.X.ordinal();
                    double d0 = MathHelper.func_151237_a((double)(x + this.field_191505_aI[j]), (double)-0.51, (double)0.51);
                    x = d0 - this.field_191505_aI[j];
                    this.field_191505_aI[j] = d0;
                    if (Math.abs(x) <= (double)1.0E-5f) {
                        return;
                    }
                } else if (y != 0.0) {
                    int l = EnumFacing.Axis.Y.ordinal();
                    double d19 = MathHelper.func_151237_a((double)(y + this.field_191505_aI[l]), (double)-0.51, (double)0.51);
                    y = d19 - this.field_191505_aI[l];
                    this.field_191505_aI[l] = d19;
                    if (Math.abs(y) <= (double)1.0E-5f) {
                        return;
                    }
                } else {
                    if (z == 0.0) {
                        return;
                    }
                    int i1 = EnumFacing.Axis.Z.ordinal();
                    double d20 = MathHelper.func_151237_a((double)(z + this.field_191505_aI[i1]), (double)-0.51, (double)0.51);
                    z = d20 - this.field_191505_aI[i1];
                    this.field_191505_aI[i1] = d20;
                    if (Math.abs(z) <= (double)1.0E-5f) {
                        return;
                    }
                }
            }
            this.field_70170_p.field_72984_F.func_76320_a("move");
            double d17 = this.field_70165_t;
            double d18 = this.field_70163_u;
            double d1 = this.field_70161_v;
            if (this.field_70134_J) {
                this.field_70134_J = false;
                x *= 0.25;
                y *= (double)0.05f;
                z *= 0.25;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            double d2 = x;
            double d3 = y;
            double d4 = z;
            if ((type == MoverType.SELF || type == MoverType.PLAYER) && this.field_70122_E && this.func_70093_af() && this instanceof EntityPlayer) {
                double d5 = 0.05;
                while (x != 0.0 && this.field_70170_p.func_195586_b(this, this.func_174813_aQ().func_72317_d(x, (double)(-this.field_70138_W), 0.0))) {
                    x = x < 0.05 && x >= -0.05 ? 0.0 : (x > 0.0 ? (x -= 0.05) : (x += 0.05));
                    d2 = x;
                }
                while (z != 0.0 && this.field_70170_p.func_195586_b(this, this.func_174813_aQ().func_72317_d(0.0, (double)(-this.field_70138_W), z))) {
                    z = z < 0.05 && z >= -0.05 ? 0.0 : (z > 0.0 ? (z -= 0.05) : (z += 0.05));
                    d4 = z;
                }
                while (x != 0.0 && z != 0.0 && this.field_70170_p.func_195586_b(this, this.func_174813_aQ().func_72317_d(x, (double)(-this.field_70138_W), z))) {
                    x = x < 0.05 && x >= -0.05 ? 0.0 : (x > 0.0 ? (x -= 0.05) : (x += 0.05));
                    d2 = x;
                    z = z < 0.05 && z >= -0.05 ? 0.0 : (z > 0.0 ? (z -= 0.05) : (z += 0.05));
                    d4 = z;
                }
            }
            AxisAlignedBB axisalignedbb4 = this.func_174813_aQ();
            if (x != 0.0 || y != 0.0 || z != 0.0) {
                ReuseableStream reuseablestream = new ReuseableStream(this.field_70170_p.func_199406_a(this, this.func_174813_aQ(), x, y, z));
                if (y != 0.0) {
                    y = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.Y, (AxisAlignedBB)this.func_174813_aQ(), (Stream)reuseablestream.func_212761_a(), (double)y);
                    this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, y, 0.0));
                }
                if (x != 0.0 && (x = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.X, (AxisAlignedBB)this.func_174813_aQ(), (Stream)reuseablestream.func_212761_a(), (double)x)) != 0.0) {
                    this.func_174826_a(this.func_174813_aQ().func_72317_d(x, 0.0, 0.0));
                }
                if (z != 0.0 && (z = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.Z, (AxisAlignedBB)this.func_174813_aQ(), (Stream)reuseablestream.func_212761_a(), (double)z)) != 0.0) {
                    this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, z));
                }
            }
            boolean bl = flag = this.field_70122_E || d3 != y && d3 < 0.0;
            if (this.field_70138_W > 0.0f && flag && (d2 != x || d4 != z)) {
                double d6 = x;
                double d7 = y;
                double d8 = z;
                AxisAlignedBB axisalignedbb = this.func_174813_aQ();
                this.func_174826_a(axisalignedbb4);
                x = d2;
                y = this.field_70138_W;
                z = d4;
                if (d2 != 0.0 || y != 0.0 || d4 != 0.0) {
                    double d16;
                    double d15;
                    double d14;
                    double d13;
                    AxisAlignedBB axisalignedbb3;
                    double d12;
                    double d11;
                    double d10;
                    ReuseableStream reuseablestream1 = new ReuseableStream(this.field_70170_p.func_199406_a(this, this.func_174813_aQ(), d2, y, d4));
                    AxisAlignedBB axisalignedbb1 = this.func_174813_aQ();
                    AxisAlignedBB axisalignedbb2 = axisalignedbb1.func_72321_a(d2, 0.0, d4);
                    double d9 = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.Y, (AxisAlignedBB)axisalignedbb2, (Stream)reuseablestream1.func_212761_a(), (double)y);
                    if (d9 != 0.0) {
                        axisalignedbb1 = axisalignedbb1.func_72317_d(0.0, d9, 0.0);
                    }
                    if ((d10 = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.X, (AxisAlignedBB)axisalignedbb1, (Stream)reuseablestream1.func_212761_a(), (double)d2)) != 0.0) {
                        axisalignedbb1 = axisalignedbb1.func_72317_d(d10, 0.0, 0.0);
                    }
                    if ((d11 = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.Z, (AxisAlignedBB)axisalignedbb1, (Stream)reuseablestream1.func_212761_a(), (double)d4)) != 0.0) {
                        axisalignedbb1 = axisalignedbb1.func_72317_d(0.0, 0.0, d11);
                    }
                    if ((d12 = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.Y, (AxisAlignedBB)(axisalignedbb3 = this.func_174813_aQ()), (Stream)reuseablestream1.func_212761_a(), (double)y)) != 0.0) {
                        axisalignedbb3 = axisalignedbb3.func_72317_d(0.0, d12, 0.0);
                    }
                    if ((d13 = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.X, (AxisAlignedBB)axisalignedbb3, (Stream)reuseablestream1.func_212761_a(), (double)d2)) != 0.0) {
                        axisalignedbb3 = axisalignedbb3.func_72317_d(d13, 0.0, 0.0);
                    }
                    if ((d14 = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.Z, (AxisAlignedBB)axisalignedbb3, (Stream)reuseablestream1.func_212761_a(), (double)d4)) != 0.0) {
                        axisalignedbb3 = axisalignedbb3.func_72317_d(0.0, 0.0, d14);
                    }
                    if ((d15 = d10 * d10 + d11 * d11) > (d16 = d13 * d13 + d14 * d14)) {
                        x = d10;
                        z = d11;
                        y = -d9;
                        this.func_174826_a(axisalignedbb1);
                    } else {
                        x = d13;
                        z = d14;
                        y = -d12;
                        this.func_174826_a(axisalignedbb3);
                    }
                    y = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.Y, (AxisAlignedBB)this.func_174813_aQ(), (Stream)reuseablestream1.func_212761_a(), (double)y);
                    if (y != 0.0) {
                        this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, y, 0.0));
                    }
                }
                if (d6 * d6 + d8 * d8 >= x * x + z * z) {
                    x = d6;
                    y = d7;
                    z = d8;
                    this.func_174826_a(axisalignedbb);
                }
            }
            this.field_70170_p.field_72984_F.func_76319_b();
            this.field_70170_p.field_72984_F.func_76320_a("rest");
            this.func_174829_m();
            this.field_70123_F = d2 != x || d4 != z;
            this.field_70124_G = d3 != y;
            this.field_70122_E = this.field_70124_G && d3 < 0.0;
            this.field_70132_H = this.field_70123_F || this.field_70124_G;
            int j1 = MathHelper.func_76128_c((double)this.field_70165_t);
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int k1 = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos blockpos = new BlockPos(j1, k, k1);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.isAir((IBlockReader)this.field_70170_p, blockpos) && ((block1 = (iblockstate1 = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_177230_c()) instanceof BlockFence || block1 instanceof BlockWall || block1 instanceof BlockFenceGate)) {
                iblockstate = iblockstate1;
                blockpos = blockpos1;
            }
            this.func_184231_a(y, this.field_70122_E, iblockstate, blockpos);
            if (d2 != x) {
                this.field_70159_w = 0.0;
            }
            if (d4 != z) {
                this.field_70179_y = 0.0;
            }
            Block block = iblockstate.func_177230_c();
            if (d3 != y) {
                block.func_176216_a((IBlockReader)this.field_70170_p, this);
            }
            if (!(!this.func_70041_e_() || this.field_70122_E && this.func_70093_af() && this instanceof EntityPlayer || this.func_184218_aH())) {
                double d21 = this.field_70165_t - d17;
                double d22 = this.field_70163_u - d18;
                double d23 = this.field_70161_v - d1;
                if (block != Blocks.field_150468_ap) {
                    d22 = 0.0;
                }
                if (block != null && this.field_70122_E) {
                    block.func_176199_a(this.field_70170_p, blockpos, this);
                }
                this.field_70140_Q = (float)((double)this.field_70140_Q + (double)MathHelper.func_76133_a((double)(d21 * d21 + d23 * d23)) * 0.6);
                this.field_82151_R = (float)((double)this.field_82151_R + (double)MathHelper.func_76133_a((double)(d21 * d21 + d22 * d22 + d23 * d23)) * 0.6);
                if (this.field_82151_R > this.field_70150_b && !iblockstate.isAir((IBlockReader)this.field_70170_p, blockpos)) {
                    this.field_70150_b = this.func_203009_ad();
                    if (this.func_70090_H()) {
                        Entity entity = this.func_184207_aI() && this.func_184179_bs() != null ? this.func_184179_bs() : this;
                        float f = entity == this ? 0.35f : 0.4f;
                        float f1 = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w * (double)0.2f + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y * (double)0.2f)) * f;
                        if (f1 > 1.0f) {
                            f1 = 1.0f;
                        }
                        this.func_203006_d(f1);
                    } else {
                        this.func_180429_a(blockpos, iblockstate);
                    }
                } else if (this.field_82151_R > this.field_191959_ay && this.func_191957_ae() && iblockstate.isAir((IBlockReader)this.field_70170_p, blockpos)) {
                    this.field_191959_ay = this.func_191954_d(this.field_82151_R);
                }
            }
            try {
                this.func_145775_I();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
                this.func_85029_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
            boolean flag1 = this.func_203008_ap();
            if (this.field_70170_p.func_147470_e(this.func_174813_aQ().func_186664_h(0.001))) {
                if (!flag1) {
                    ++this.field_190534_ay;
                    if (this.field_190534_ay == 0) {
                        this.func_70015_d(8);
                    }
                }
                this.func_70081_e(1);
            } else if (this.field_190534_ay <= 0) {
                this.field_190534_ay = -this.func_190531_bD();
            }
            if (flag1 && this.func_70027_ad()) {
                this.func_184185_a(SoundEvents.field_187541_bC, 0.7f, 1.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                this.field_190534_ay = -this.func_190531_bD();
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    protected float func_203009_ad() {
        return (int)this.field_82151_R + 1;
    }

    public void func_174829_m() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.field_70165_t = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
        this.field_70163_u = axisalignedbb.field_72338_b;
        this.field_70161_v = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a(this, false);
        }
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187549_bG;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187547_bF;
    }

    protected SoundEvent func_204208_ah() {
        return SoundEvents.field_187547_bF;
    }

    protected void func_145775_I() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72340_a + 0.001), (double)(axisalignedbb.field_72338_b + 0.001), (double)(axisalignedbb.field_72339_c + 0.001));
             BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos1 = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72336_d - 0.001), (double)(axisalignedbb.field_72337_e - 0.001), (double)(axisalignedbb.field_72334_f - 0.001));
             BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos2 = BlockPos.PooledMutableBlockPos.func_185346_s();){
            if (this.field_70170_p.func_175707_a((BlockPos)blockpos$pooledmutableblockpos, (BlockPos)blockpos$pooledmutableblockpos1)) {
                for (int i = blockpos$pooledmutableblockpos.func_177958_n(); i <= blockpos$pooledmutableblockpos1.func_177958_n(); ++i) {
                    for (int j = blockpos$pooledmutableblockpos.func_177956_o(); j <= blockpos$pooledmutableblockpos1.func_177956_o(); ++j) {
                        for (int k = blockpos$pooledmutableblockpos.func_177952_p(); k <= blockpos$pooledmutableblockpos1.func_177952_p(); ++k) {
                            blockpos$pooledmutableblockpos2.func_181079_c(i, j, k);
                            IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos2);
                            try {
                                iblockstate.func_196950_a(this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos2, this);
                                this.func_191955_a(iblockstate);
                                continue;
                            }
                            catch (Throwable throwable) {
                                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Colliding entity with block");
                                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being collided with");
                                CrashReportCategory.func_175750_a(crashreportcategory, (BlockPos)blockpos$pooledmutableblockpos2, iblockstate);
                                throw new ReportedException(crashreport);
                            }
                        }
                    }
                }
            }
        }
    }

    protected void func_191955_a(IBlockState p_191955_1_) {
    }

    protected void func_180429_a(BlockPos pos, IBlockState blockIn) {
        if (!blockIn.func_185904_a().func_76224_d()) {
            SoundType soundtype = this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150433_aE ? Blocks.field_150433_aE.func_185467_w() : blockIn.getSoundType(this.field_70170_p, pos, this);
            this.func_184185_a(soundtype.func_185844_d(), soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
        }
    }

    protected void func_203006_d(float volume) {
        this.func_184185_a(this.func_184184_Z(), volume, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
    }

    protected float func_191954_d(float volume) {
        return 0.0f;
    }

    protected boolean func_191957_ae() {
        return false;
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundIn, this.func_184176_by(), volume, pitch);
        }
    }

    public boolean func_174814_R() {
        return this.field_70180_af.func_187225_a(field_184234_aB);
    }

    public void func_174810_b(boolean isSilent) {
        this.field_70180_af.func_187227_b(field_184234_aB, isSilent);
    }

    public boolean func_189652_ae() {
        return this.field_70180_af.func_187225_a(field_189655_aD);
    }

    public void func_189654_d(boolean noGravity) {
        this.field_70180_af.func_187227_b(field_189655_aD, noGravity);
    }

    protected boolean func_70041_e_() {
        return true;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (onGroundIn) {
            if (this.field_70143_R > 0.0f) {
                state.func_177230_c().func_180658_a(this.field_70170_p, pos, this, this.field_70143_R);
            }
            this.field_70143_R = 0.0f;
        } else if (y < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - y);
        }
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    protected void func_70081_e(int amount) {
        if (!this.field_70178_ae) {
            this.func_70097_a(DamageSource.field_76372_a, amount);
        }
    }

    public final boolean func_70045_F() {
        return this.field_70178_ae;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184188_bt()) {
                entity.func_180430_e(distance, damageMultiplier);
            }
        }
    }

    public boolean func_70090_H() {
        return this.field_70171_ac;
    }

    private boolean func_209511_p() {
        boolean flag;
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_209907_b((Entity)this);){
            flag = this.field_70170_p.func_175727_C((BlockPos)blockpos$pooledmutableblockpos) || this.field_70170_p.func_175727_C((BlockPos)blockpos$pooledmutableblockpos.func_189532_c(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v));
        }
        return flag;
    }

    private boolean func_209512_q() {
        return this.field_70170_p.func_180495_p(new BlockPos(this)).func_177230_c() == Blocks.field_203203_C;
    }

    public boolean func_70026_G() {
        return this.func_70090_H() || this.func_209511_p();
    }

    public boolean func_203008_ap() {
        return this.func_70090_H() || this.func_209511_p() || this.func_209512_q();
    }

    public boolean func_203005_aq() {
        return this.func_70090_H() || this.func_209512_q();
    }

    public boolean func_204231_K() {
        return this.field_205013_W && this.func_70090_H();
    }

    private void func_205011_p() {
        this.func_70072_I();
        this.func_205012_q();
        this.func_205343_av();
    }

    public void func_205343_av() {
        if (this.func_203007_ba()) {
            this.func_204711_a(this.func_70051_ag() && this.func_70090_H() && !this.func_184218_aH());
        } else {
            this.func_204711_a(this.func_70051_ag() && this.func_204231_K() && !this.func_184218_aH());
        }
    }

    public boolean func_70072_I() {
        if (this.func_184187_bx() instanceof EntityBoat) {
            this.field_70171_ac = false;
        } else if (this.func_210500_b(FluidTags.field_206959_a)) {
            if (!this.field_70171_ac && !this.field_70148_d) {
                this.func_71061_d_();
            }
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
        return this.field_70171_ac;
    }

    private void func_205012_q() {
        this.field_205013_W = this.func_208600_a(FluidTags.field_206959_a);
    }

    protected void func_71061_d_() {
        Entity entity = this.func_184207_aI() && this.func_184179_bs() != null ? this.func_184179_bs() : this;
        float f = entity == this ? 0.2f : 0.9f;
        float f1 = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w * (double)0.2f + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y * (double)0.2f)) * f;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        if ((double)f1 < 0.25) {
            this.func_184185_a(this.func_184181_aa(), f1, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
        } else {
            this.func_184185_a(this.func_204208_ah(), f1, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
        }
        float f2 = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int i = 0;
        while ((float)i < 1.0f + this.field_70130_N * 20.0f) {
            float f3 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
            float f4 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
            this.field_70170_p.func_195594_a((IParticleData)Particles.field_197612_e, this.field_70165_t + (double)f3, f2 + 1.0f, this.field_70161_v + (double)f4, this.field_70159_w, this.field_70181_x - (double)(this.field_70146_Z.nextFloat() * 0.2f), this.field_70179_y);
            ++i;
        }
        int j = 0;
        while ((float)j < 1.0f + this.field_70130_N * 20.0f) {
            float f5 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
            float f6 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
            this.field_70170_p.func_195594_a((IParticleData)Particles.field_197606_Q, this.field_70165_t + (double)f5, f2 + 1.0f, this.field_70161_v + (double)f6, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            ++j;
        }
    }

    public void func_174830_Y() {
        if (this.func_70051_ag() && !this.func_70090_H()) {
            this.func_174808_Z();
        }
    }

    protected void func_174808_Z() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v));
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        if (!iblockstate.addRunningEffects(this.field_70170_p, blockpos, this) && iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(Particles.field_197611_d, iblockstate), this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, -this.field_70159_w * 4.0, 1.5, -this.field_70179_y * 4.0);
        }
    }

    public boolean func_208600_a(Tag<Fluid> tagIn) {
        if (this.func_184187_bx() instanceof EntityBoat) {
            return false;
        }
        double d0 = this.field_70163_u + (double)this.func_70047_e();
        BlockPos blockpos = new BlockPos(this.field_70165_t, d0, this.field_70161_v);
        IFluidState ifluidstate = this.field_70170_p.func_204610_c(blockpos);
        return ifluidstate.isEntityInside(this.field_70170_p, blockpos, this, d0, tagIn, true);
    }

    public boolean func_180799_ab() {
        return this.field_70170_p.func_72875_a(this.func_174813_aQ().func_211539_f((double)0.1f, (double)0.4f, (double)0.1f), Material.field_151587_i);
    }

    public void func_191958_b(float strafe, float up, float forward, float friction) {
        float f = strafe * strafe + up * up + forward * forward;
        if (!(f < 1.0E-4f)) {
            if ((f = MathHelper.func_76129_c((float)f)) < 1.0f) {
                f = 1.0f;
            }
            f = friction / f;
            float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            this.field_70159_w += (double)((strafe *= f) * f2 - (forward *= f) * f1);
            this.field_70181_x += (double)(up *= f);
            this.field_70179_y += (double)(forward * f2 + strafe * f1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
        return this.field_70170_p.func_175667_e(blockpos) ? this.field_70170_p.func_175626_b(blockpos, 0) : 0;
    }

    public float func_70013_c() {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_70165_t), 0, MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70170_p.func_175667_e((BlockPos)blockpos$mutableblockpos)) {
            blockpos$mutableblockpos.func_185336_p(MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e())));
            return this.field_70170_p.func_205052_D((BlockPos)blockpos$mutableblockpos);
        }
        return 0.0f;
    }

    public void func_70029_a(World worldIn) {
        this.field_70170_p = worldIn;
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        this.field_70165_t = MathHelper.func_151237_a((double)x, (double)-3.0E7, (double)3.0E7);
        this.field_70163_u = y;
        this.field_70161_v = MathHelper.func_151237_a((double)z, (double)-3.0E7, (double)3.0E7);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        pitch = MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f);
        this.field_70177_z = yaw;
        this.field_70125_A = pitch;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        double d0 = this.field_70126_B - yaw;
        if (d0 < -180.0) {
            this.field_70126_B += 360.0f;
        }
        if (d0 >= 180.0) {
            this.field_70126_B -= 360.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72964_e((int)Math.floor(this.field_70165_t) >> 4, (int)Math.floor(this.field_70161_v) >> 4);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_70101_b(yaw, pitch);
    }

    public void func_174828_a(BlockPos pos, float rotationYawIn, float rotationPitchIn) {
        this.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, rotationYawIn, rotationPitchIn);
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.field_70177_z = yaw;
        this.field_70125_A = pitch;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public float func_70032_d(Entity entityIn) {
        float f = (float)(this.field_70165_t - entityIn.field_70165_t);
        float f1 = (float)(this.field_70163_u - entityIn.field_70163_u);
        float f2 = (float)(this.field_70161_v - entityIn.field_70161_v);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public double func_70092_e(double x, double y, double z) {
        double d0 = this.field_70165_t - x;
        double d1 = this.field_70163_u - y;
        double d2 = this.field_70161_v - z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double func_174818_b(BlockPos pos) {
        return pos.func_177954_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public double func_174831_c(BlockPos pos) {
        return pos.func_177957_d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public double func_70011_f(double x, double y, double z) {
        double d0 = this.field_70165_t - x;
        double d1 = this.field_70163_u - y;
        double d2 = this.field_70161_v - z;
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
    }

    public double func_70068_e(Entity entityIn) {
        double d0 = this.field_70165_t - entityIn.field_70165_t;
        double d1 = this.field_70163_u - entityIn.field_70163_u;
        double d2 = this.field_70161_v - entityIn.field_70161_v;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double func_195048_a(Vec3d p_195048_1_) {
        double d0 = this.field_70165_t - p_195048_1_.field_72450_a;
        double d1 = this.field_70163_u - p_195048_1_.field_72448_b;
        double d2 = this.field_70161_v - p_195048_1_.field_72449_c;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void func_70100_b_(EntityPlayer entityIn) {
    }

    public void func_70108_f(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!this.func_184223_x(entityIn) && !entityIn.field_70145_X && !this.field_70145_X && (d2 = MathHelper.func_76132_a((double)(d0 = entityIn.field_70165_t - this.field_70165_t), (double)(d1 = entityIn.field_70161_v - this.field_70161_v))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.field_70144_Y);
            d1 *= (double)(1.0f - this.field_70144_Y);
            if (!this.func_184207_aI()) {
                this.func_70024_g(-d0, 0.0, -d1);
            }
            if (!entityIn.func_184207_aI()) {
                entityIn.func_70024_g(d0, 0.0, d1);
            }
        }
    }

    public void func_70024_g(double x, double y, double z) {
        this.field_70159_w += x;
        this.field_70181_x += y;
        this.field_70179_y += z;
        this.field_70160_al = true;
    }

    protected void func_70018_K() {
        this.field_70133_I = true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        return false;
    }

    public final Vec3d func_70676_i(float partialTicks) {
        return this.func_174806_f(this.func_195050_f(partialTicks), this.func_195046_g(partialTicks));
    }

    public float func_195050_f(float partialTicks) {
        return partialTicks == 1.0f ? this.field_70125_A : this.field_70127_C + (this.field_70125_A - this.field_70127_C) * partialTicks;
    }

    public float func_195046_g(float partialTicks) {
        return partialTicks == 1.0f ? this.field_70177_z : this.field_70126_B + (this.field_70177_z - this.field_70126_B) * partialTicks;
    }

    protected final Vec3d func_174806_f(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        float f5 = MathHelper.func_76126_a((float)f);
        return new Vec3d(f3 * f4, -f5, f2 * f4);
    }

    public Vec3d func_174824_e(float partialTicks) {
        if (partialTicks == 1.0f) {
            return new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
        }
        double d0 = this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTicks;
        double d1 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTicks + (double)this.func_70047_e();
        double d2 = this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTicks;
        return new Vec3d(d0, d1, d2);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public RayTraceResult func_174822_a(double blockReachDistance, float partialTicks, RayTraceFluidMode p_174822_4_) {
        Vec3d vec3d = this.func_174824_e(partialTicks);
        Vec3d vec3d1 = this.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return this.field_70170_p.func_200259_a(vec3d, vec3d2, p_174822_4_, false, true);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_191956_a(Entity p_191956_1_, int p_191956_2_, DamageSource p_191956_3_) {
        if (p_191956_1_ instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192123_c.func_192211_a((EntityPlayerMP)p_191956_1_, this, p_191956_3_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        double d0 = this.field_70165_t - x;
        double d1 = this.field_70163_u - y;
        double d2 = this.field_70161_v - z;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        return this.func_70112_a(d3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * field_70155_l) * d0;
    }

    public boolean func_184198_c(NBTTagCompound compound) {
        String s = this.func_70022_Q();
        if (!this.field_70128_L && s != null) {
            compound.func_74778_a("id", s);
            this.func_189511_e(compound);
            return true;
        }
        return false;
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return this.func_184218_aH() ? false : this.func_184198_c(compound);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        try {
            NBTTagCompound caps;
            compound.func_74782_a("Pos", (INBTBase)this.func_70087_a(this.field_70165_t, this.field_70163_u, this.field_70161_v));
            compound.func_74782_a("Motion", (INBTBase)this.func_70087_a(this.field_70159_w, this.field_70181_x, this.field_70179_y));
            compound.func_74782_a("Rotation", (INBTBase)this.func_70049_a(this.field_70177_z, this.field_70125_A));
            compound.func_74776_a("FallDistance", this.field_70143_R);
            compound.func_74777_a("Fire", (short)this.field_190534_ay);
            compound.func_74777_a("Air", (short)this.func_70086_ai());
            compound.func_74757_a("OnGround", this.field_70122_E);
            compound.func_74768_a("Dimension", this.field_71093_bK.func_186068_a());
            compound.func_74757_a("Invulnerable", this.field_83001_bt);
            compound.func_74768_a("PortalCooldown", this.field_71088_bW);
            compound.func_186854_a("UUID", this.func_110124_au());
            ITextComponent itextcomponent = this.func_200201_e();
            if (itextcomponent != null) {
                compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)itextcomponent));
            }
            if (this.func_174833_aM()) {
                compound.func_74757_a("CustomNameVisible", this.func_174833_aM());
            }
            if (this.func_174814_R()) {
                compound.func_74757_a("Silent", this.func_174814_R());
            }
            if (this.func_189652_ae()) {
                compound.func_74757_a("NoGravity", this.func_189652_ae());
            }
            if (this.field_184238_ar) {
                compound.func_74757_a("Glowing", this.field_184238_ar);
            }
            compound.func_74757_a("CanUpdate", this.canUpdate);
            if (!this.field_184236_aF.isEmpty()) {
                NBTTagList nbttaglist = new NBTTagList();
                for (String s : this.field_184236_aF) {
                    nbttaglist.add((INBTBase)new NBTTagString(s));
                }
                compound.func_74782_a("Tags", (INBTBase)nbttaglist);
            }
            if ((caps = this.serializeCaps()) != null) {
                compound.func_74782_a("ForgeCaps", caps);
            }
            if (this.entityData != null) {
                compound.func_74782_a("ForgeData", this.entityData);
            }
            this.func_70014_b(compound);
            if (this.func_184207_aI()) {
                NBTTagList nbttaglist1 = new NBTTagList();
                for (Entity entity : this.func_184188_bt()) {
                    NBTTagCompound nbttagcompound;
                    if (!entity.func_184198_c(nbttagcompound = new NBTTagCompound())) continue;
                    nbttaglist1.add((INBTBase)nbttagcompound);
                }
                if (!nbttaglist1.isEmpty()) {
                    compound.func_74782_a("Passengers", (INBTBase)nbttaglist1);
                }
            }
            return compound;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Saving entity NBT");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being saved");
            this.func_85029_a(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    public void func_70020_e(NBTTagCompound compound) {
        try {
            NBTTagList nbttaglist = compound.func_150295_c("Pos", 6);
            NBTTagList nbttaglist2 = compound.func_150295_c("Motion", 6);
            NBTTagList nbttaglist3 = compound.func_150295_c("Rotation", 5);
            this.field_70159_w = nbttaglist2.func_150309_d(0);
            this.field_70181_x = nbttaglist2.func_150309_d(1);
            this.field_70179_y = nbttaglist2.func_150309_d(2);
            if (Math.abs(this.field_70159_w) > 10.0) {
                this.field_70159_w = 0.0;
            }
            if (Math.abs(this.field_70181_x) > 10.0) {
                this.field_70181_x = 0.0;
            }
            if (Math.abs(this.field_70179_y) > 10.0) {
                this.field_70179_y = 0.0;
            }
            this.field_70165_t = nbttaglist.func_150309_d(0);
            this.field_70163_u = nbttaglist.func_150309_d(1);
            this.field_70161_v = nbttaglist.func_150309_d(2);
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70177_z = nbttaglist3.func_150308_e(0);
            this.field_70125_A = nbttaglist3.func_150308_e(1);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
            this.func_70034_d(this.field_70177_z);
            this.func_181013_g(this.field_70177_z);
            this.field_70143_R = compound.func_74760_g("FallDistance");
            this.field_190534_ay = compound.func_74765_d("Fire");
            this.func_70050_g(compound.func_74765_d("Air"));
            this.field_70122_E = compound.func_74767_n("OnGround");
            if (compound.func_74764_b("Dimension")) {
                this.field_71093_bK = DimensionType.func_186069_a(compound.func_74762_e("Dimension"));
            }
            this.field_83001_bt = compound.func_74767_n("Invulnerable");
            this.field_71088_bW = compound.func_74762_e("PortalCooldown");
            if (compound.func_186855_b("UUID")) {
                this.field_96093_i = compound.func_186857_a("UUID");
                this.field_189513_ar = this.field_96093_i.toString();
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (compound.func_150297_b("CustomName", 8)) {
                this.func_200203_b(ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("CustomName")));
            }
            this.func_174805_g(compound.func_74767_n("CustomNameVisible"));
            this.func_174810_b(compound.func_74767_n("Silent"));
            this.func_189654_d(compound.func_74767_n("NoGravity"));
            this.func_184195_f(compound.func_74767_n("Glowing"));
            if (compound.func_150297_b("ForgeData", 10)) {
                this.entityData = compound.func_74775_l("ForgeData");
            }
            if (compound.func_150297_b("CanUpdate", 99)) {
                this.canUpdate(compound.func_74767_n("CanUpdate"));
            }
            if (compound.func_150297_b("ForgeCaps", 10)) {
                this.deserializeCaps(compound.func_74775_l("ForgeCaps"));
            }
            if (compound.func_150297_b("Tags", 9)) {
                this.field_184236_aF.clear();
                NBTTagList nbttaglist1 = compound.func_150295_c("Tags", 8);
                int i = Math.min(nbttaglist1.size(), 1024);
                for (int j = 0; j < i; ++j) {
                    this.field_184236_aF.add(nbttaglist1.func_150307_f(j));
                }
            }
            this.func_70037_a(compound);
            if (this.func_142008_O()) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Loading entity NBT");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being loaded");
            this.func_85029_a(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean func_142008_O() {
        return true;
    }

    @Nullable
    public final String func_70022_Q() {
        EntityType<?> entitytype = this.func_200600_R();
        ResourceLocation resourcelocation = EntityType.func_200718_a(entitytype);
        return entitytype.func_200715_a() && resourcelocation != null ? resourcelocation.toString() : null;
    }

    protected abstract void func_70037_a(NBTTagCompound var1);

    protected abstract void func_70014_b(NBTTagCompound var1);

    protected NBTTagList func_70087_a(double ... numbers) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d0 : numbers) {
            nbttaglist.add((INBTBase)new NBTTagDouble(d0));
        }
        return nbttaglist;
    }

    protected NBTTagList func_70049_a(float ... numbers) {
        NBTTagList nbttaglist = new NBTTagList();
        for (float f : numbers) {
            nbttaglist.add((INBTBase)new NBTTagFloat(f));
        }
        return nbttaglist;
    }

    @Nullable
    public EntityItem func_199703_a(IItemProvider p_199703_1_) {
        return this.func_199702_a(p_199703_1_, 0);
    }

    @Nullable
    public EntityItem func_199702_a(IItemProvider p_199702_1_, int offset) {
        return this.func_70099_a(new ItemStack(p_199702_1_), offset);
    }

    @Nullable
    public EntityItem func_199701_a_(ItemStack p_199701_1_) {
        return this.func_70099_a(p_199701_1_, 0.0f);
    }

    @Nullable
    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_190926_b()) {
            return null;
        }
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
        entityitem.func_174869_p();
        if (this.captureDrops() != null) {
            this.captureDrops().add(entityitem);
        } else {
            this.field_70170_p.func_72838_d(entityitem);
        }
        return entityitem;
    }

    public boolean func_70089_S() {
        return !this.field_70128_L;
    }

    public boolean func_70094_T() {
        if (this.field_70145_X) {
            return false;
        }
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (int i = 0; i < 8; ++i) {
                boolean flag;
                int j = MathHelper.func_76128_c((double)(this.field_70163_u + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)this.func_70047_e()));
                int k = MathHelper.func_76128_c((double)(this.field_70165_t + (double)(((float)((i >> 1) % 2) - 0.5f) * this.field_70130_N * 0.8f)));
                int l = MathHelper.func_76128_c((double)(this.field_70161_v + (double)(((float)((i >> 2) % 2) - 0.5f) * this.field_70130_N * 0.8f)));
                if (blockpos$pooledmutableblockpos.func_177958_n() == k && blockpos$pooledmutableblockpos.func_177956_o() == j && blockpos$pooledmutableblockpos.func_177952_p() == l) continue;
                blockpos$pooledmutableblockpos.func_181079_c(k, j, l);
                if (!this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_191058_s()) continue;
                boolean bl = flag = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && entity.field_70128_L) {
            this.func_184210_p();
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            if (this.canUpdate()) {
                this.func_70071_h_();
            }
            if (this.func_184218_aH()) {
                entity.func_184232_k(this);
            }
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
    }

    public double func_70033_W() {
        return 0.0;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.75;
    }

    public boolean func_184220_m(Entity entityIn) {
        return this.func_184205_a(entityIn, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_203003_aK() {
        return this instanceof EntityLivingBase;
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        Entity entity = entityIn;
        while (entity.field_184239_as != null) {
            if (entity.field_184239_as == this) {
                return false;
            }
            entity = entity.field_184239_as;
        }
        if (!ForgeEventFactory.canMountEntity((Entity)this, (Entity)entityIn, (boolean)true)) {
            return false;
        }
        if (force || this.func_184228_n(entityIn) && entityIn.func_184219_q(this)) {
            if (this.func_184218_aH()) {
                this.func_184210_p();
            }
            this.field_184239_as = entityIn;
            this.field_184239_as.func_184200_o(this);
            return true;
        }
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return this.field_184245_j <= 0;
    }

    public void func_184226_ay() {
        for (int i = this.field_184244_h.size() - 1; i >= 0; --i) {
            this.field_184244_h.get(i).func_184210_p();
        }
    }

    public void func_184210_p() {
        if (this.field_184239_as != null) {
            Entity entity = this.field_184239_as;
            if (!ForgeEventFactory.canMountEntity((Entity)this, (Entity)entity, (boolean)false)) {
                return;
            }
            this.field_184239_as = null;
            entity.func_184225_p(this);
        }
    }

    protected void func_184200_o(Entity passenger) {
        if (passenger.func_184187_bx() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (!this.field_70170_p.field_72995_K && passenger instanceof EntityPlayer && !(this.func_184179_bs() instanceof EntityPlayer)) {
            this.field_184244_h.add(0, passenger);
        } else {
            this.field_184244_h.add(passenger);
        }
    }

    protected void func_184225_p(Entity passenger) {
        if (passenger.func_184187_bx() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        this.field_184244_h.remove((Object)passenger);
        passenger.field_184245_j = 60;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_208000_a(float yaw, int pitch) {
        this.func_70034_d(yaw);
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public Vec3d func_70040_Z() {
        return this.func_174806_f(this.field_70125_A, this.field_70177_z);
    }

    public Vec2f func_189653_aC() {
        return new Vec2f(this.field_70125_A, this.field_70177_z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_189651_aD() {
        return Vec3d.func_189984_a(this.func_189653_aC());
    }

    public void func_181015_d(BlockPos pos) {
        if (this.field_71088_bW > 0) {
            this.field_71088_bW = this.func_82147_ab();
        } else {
            if (!this.field_70170_p.field_72995_K && !pos.equals((Object)this.field_181016_an)) {
                this.field_181016_an = new BlockPos((Vec3i)pos);
                BlockPattern.PatternHelper blockpattern$patternhelper = ((BlockPortal)Blocks.field_150427_aO).func_181089_f(this.field_70170_p, this.field_181016_an);
                double d0 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)blockpattern$patternhelper.func_181117_a().func_177952_p() : (double)blockpattern$patternhelper.func_181117_a().func_177958_n();
                double d1 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? this.field_70161_v : this.field_70165_t;
                d1 = Math.abs(MathHelper.func_181160_c((double)(d1 - (double)(blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 1 : 0)), (double)d0, (double)(d0 - (double)blockpattern$patternhelper.func_181118_d())));
                double d2 = MathHelper.func_181160_c((double)(this.field_70163_u - 1.0), (double)blockpattern$patternhelper.func_181117_a().func_177956_o(), (double)(blockpattern$patternhelper.func_181117_a().func_177956_o() - blockpattern$patternhelper.func_181119_e()));
                this.field_181017_ao = new Vec3d(d1, d2, 0.0);
                this.field_181018_ap = blockpattern$patternhelper.func_177669_b();
            }
            this.field_71087_bX = true;
        }
    }

    public int func_82147_ab() {
        return 300;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
    }

    public Iterable<ItemStack> func_184214_aD() {
        return field_190535_b;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return field_190535_b;
    }

    public Iterable<ItemStack> func_184209_aF() {
        return Iterables.concat(this.func_184214_aD(), this.func_184193_aE());
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }

    public boolean func_70027_ad() {
        boolean flag = this.field_70170_p != null && this.field_70170_p.field_72995_K;
        return !this.field_70178_ae && (this.field_190534_ay > 0 || flag && this.func_70083_f(0));
    }

    public boolean func_184218_aH() {
        return this.func_184187_bx() != null;
    }

    public boolean func_184207_aI() {
        return !this.func_184188_bt().isEmpty();
    }

    @Deprecated
    public boolean func_205710_ba() {
        return true;
    }

    public boolean func_70093_af() {
        return this.func_70083_f(1);
    }

    public void func_70095_a(boolean sneaking) {
        this.func_70052_a(1, sneaking);
    }

    public boolean func_70051_ag() {
        return this.func_70083_f(3);
    }

    public void func_70031_b(boolean sprinting) {
        this.func_70052_a(3, sprinting);
    }

    public boolean func_203007_ba() {
        return this.func_70083_f(4);
    }

    public void func_204711_a(boolean p_204711_1_) {
        this.func_70052_a(4, p_204711_1_);
    }

    public boolean func_184202_aL() {
        return this.field_184238_ar || this.field_70170_p.field_72995_K && this.func_70083_f(6);
    }

    public void func_184195_f(boolean glowingIn) {
        this.field_184238_ar = glowingIn;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.field_184238_ar);
        }
    }

    public boolean func_82150_aj() {
        return this.func_70083_f(5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_98034_c(EntityPlayer player) {
        if (player.func_175149_v()) {
            return false;
        }
        Team team = this.func_96124_cp();
        return team != null && player != null && player.func_96124_cp() == team && team.func_98297_h() ? false : this.func_82150_aj();
    }

    @Nullable
    public Team func_96124_cp() {
        return this.field_70170_p.func_96441_U().func_96509_i(this.func_195047_I_());
    }

    public boolean func_184191_r(Entity entityIn) {
        return this.func_184194_a(entityIn.func_96124_cp());
    }

    public boolean func_184194_a(Team teamIn) {
        return this.func_96124_cp() != null ? this.func_96124_cp().func_142054_a(teamIn) : false;
    }

    public void func_82142_c(boolean invisible) {
        this.func_70052_a(5, invisible);
    }

    protected boolean func_70083_f(int flag) {
        return (this.field_70180_af.func_187225_a(field_184240_ax) & 1 << flag) != 0;
    }

    protected void func_70052_a(int flag, boolean set) {
        byte b0 = this.field_70180_af.func_187225_a(field_184240_ax);
        if (set) {
            this.field_70180_af.func_187227_b(field_184240_ax, (byte)(b0 | 1 << flag));
        } else {
            this.field_70180_af.func_187227_b(field_184240_ax, (byte)(b0 & ~(1 << flag)));
        }
    }

    public int func_205010_bg() {
        return 300;
    }

    public int func_70086_ai() {
        return this.field_70180_af.func_187225_a(field_184241_ay);
    }

    public void func_70050_g(int air) {
        this.field_70180_af.func_187227_b(field_184241_ay, air);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        ++this.field_190534_ay;
        if (this.field_190534_ay == 0) {
            this.func_70015_d(8);
        }
        this.func_70097_a(DamageSource.field_180137_b, 5.0f);
    }

    public void func_203002_i(boolean downwards) {
        this.field_70181_x = downwards ? Math.max(-0.9, this.field_70181_x - 0.03) : Math.min(1.8, this.field_70181_x + 0.1);
    }

    public void func_203004_j(boolean downwards) {
        this.field_70181_x = downwards ? Math.max(-0.3, this.field_70181_x - 0.03) : Math.min(0.7, this.field_70181_x + 0.06);
        this.field_70143_R = 0.0f;
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
    }

    protected boolean func_145771_j(double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        double d0 = x - (double)blockpos.func_177958_n();
        double d1 = y - (double)blockpos.func_177956_o();
        double d2 = z - (double)blockpos.func_177952_p();
        if (this.field_70170_p.func_195586_b(null, this.func_174813_aQ())) {
            return false;
        }
        EnumFacing enumfacing = EnumFacing.UP;
        double d3 = Double.MAX_VALUE;
        if (!this.field_70170_p.func_175665_u(blockpos.func_177976_e()) && d0 < d3) {
            d3 = d0;
            enumfacing = EnumFacing.WEST;
        }
        if (!this.field_70170_p.func_175665_u(blockpos.func_177974_f()) && 1.0 - d0 < d3) {
            d3 = 1.0 - d0;
            enumfacing = EnumFacing.EAST;
        }
        if (!this.field_70170_p.func_175665_u(blockpos.func_177978_c()) && d2 < d3) {
            d3 = d2;
            enumfacing = EnumFacing.NORTH;
        }
        if (!this.field_70170_p.func_175665_u(blockpos.func_177968_d()) && 1.0 - d2 < d3) {
            d3 = 1.0 - d2;
            enumfacing = EnumFacing.SOUTH;
        }
        if (!this.field_70170_p.func_175665_u(blockpos.func_177984_a()) && 1.0 - d1 < d3) {
            d3 = 1.0 - d1;
            enumfacing = EnumFacing.UP;
        }
        float f = this.field_70146_Z.nextFloat() * 0.2f + 0.1f;
        float f1 = enumfacing.func_176743_c().func_179524_a();
        if (enumfacing.func_176740_k() == EnumFacing.Axis.X) {
            this.field_70159_w = f1 * f;
            this.field_70181_x *= 0.75;
            this.field_70179_y *= 0.75;
        } else if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            this.field_70159_w *= 0.75;
            this.field_70181_x = f1 * f;
            this.field_70179_y *= 0.75;
        } else if (enumfacing.func_176740_k() == EnumFacing.Axis.Z) {
            this.field_70159_w *= 0.75;
            this.field_70181_x *= 0.75;
            this.field_70179_y = f1 * f;
        }
        return true;
    }

    public void func_70110_aj() {
        this.field_70134_J = true;
        this.field_70143_R = 0.0f;
    }

    private static void func_207712_c(ITextComponent p_207712_0_) {
        p_207712_0_.func_211710_a(p_211515_0_ -> p_211515_0_.func_150241_a((ClickEvent)null)).func_150253_a().forEach(Entity::func_207712_c);
    }

    public ITextComponent func_200200_C_() {
        ITextComponent itextcomponent = this.func_200201_e();
        if (itextcomponent != null) {
            ITextComponent itextcomponent1 = itextcomponent.func_212638_h();
            Entity.func_207712_c(itextcomponent1);
            return itextcomponent1;
        }
        return this.func_200600_R().func_212546_e();
    }

    @Nullable
    public Entity[] func_70021_al() {
        return null;
    }

    public boolean func_70028_i(Entity entityIn) {
        return this == entityIn;
    }

    public float func_70079_am() {
        return 0.0f;
    }

    public void func_70034_d(float rotation) {
    }

    public void func_181013_g(float offset) {
    }

    public boolean func_70075_an() {
        return true;
    }

    public boolean func_85031_j(Entity entityIn) {
        return false;
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", ((Object)((Object)this)).getClass().getSimpleName(), this.func_200200_C_().func_150261_e(), this.field_145783_c, this.field_70170_p == null ? "~NULL~" : this.field_70170_p.func_72912_H().func_76065_j(), this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean func_180431_b(DamageSource source) {
        return this.field_83001_bt && source != DamageSource.field_76380_i && !source.func_180136_u();
    }

    public boolean func_190530_aW() {
        return this.field_83001_bt;
    }

    public void func_184224_h(boolean isInvulnerable) {
        this.field_83001_bt = isInvulnerable;
    }

    public void func_82149_j(Entity entityIn) {
        this.func_70012_b(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, entityIn.field_70177_z, entityIn.field_70125_A);
    }

    public void func_180432_n(Entity entityIn) {
        NBTTagCompound nbttagcompound = entityIn.func_189511_e(new NBTTagCompound());
        nbttagcompound.func_82580_o("Dimension");
        this.func_70020_e(nbttagcompound);
        this.field_71088_bW = entityIn.field_71088_bW;
        this.field_181016_an = entityIn.field_181016_an;
        this.field_181017_ao = entityIn.field_181017_ao;
        this.field_181018_ap = entityIn.field_181018_ap;
    }

    @Nullable
    public Entity func_212321_a(DimensionType p_212321_1_) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return null;
        }
        return this.changeDimension(p_212321_1_, this.func_184102_h().func_71218_a(p_212321_1_).func_85176_s());
    }

    @Nullable
    public Entity changeDimension(DimensionType p_212321_1_, ITeleporter teleporter) {
        if (!ForgeHooks.onTravelToDimension((Entity)this, (DimensionType)p_212321_1_)) {
            return null;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            BlockPos blockpos;
            this.field_70170_p.field_72984_F.func_76320_a("changeDimension");
            MinecraftServer minecraftserver = this.func_184102_h();
            DimensionType dimensiontype = this.field_71093_bK;
            WorldServer worldserver = minecraftserver.func_71218_a(dimensiontype);
            WorldServer worldserver1 = minecraftserver.func_71218_a(p_212321_1_);
            this.field_71093_bK = p_212321_1_;
            if (dimensiontype == DimensionType.THE_END && p_212321_1_ == DimensionType.THE_END && teleporter.isVanilla()) {
                worldserver1 = minecraftserver.func_71218_a(DimensionType.OVERWORLD);
                this.field_71093_bK = DimensionType.OVERWORLD;
            }
            this.field_70170_p.removeEntity(this, true);
            this.revive();
            this.field_70170_p.field_72984_F.func_76320_a("reposition");
            if (p_212321_1_ == DimensionType.THE_END && teleporter.isVanilla()) {
                blockpos = worldserver1.func_180504_m();
            } else {
                double moveFactor = worldserver.field_73011_w.getMovementFactor() / worldserver1.field_73011_w.getMovementFactor();
                double d0 = MathHelper.func_151237_a((double)(this.field_70165_t * moveFactor), (double)(worldserver1.func_175723_af().func_177726_b() + 16.0), (double)(worldserver1.func_175723_af().func_177728_d() - 16.0));
                double d1 = MathHelper.func_151237_a((double)(this.field_70161_v * moveFactor), (double)(worldserver1.func_175723_af().func_177736_c() + 16.0), (double)(worldserver1.func_175723_af().func_177733_e() - 16.0));
                d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
                d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
                float f = this.field_70177_z;
                this.func_70012_b(d0, this.field_70163_u, d1, 90.0f, 0.0f);
                teleporter.placeEntity((World)worldserver1, this, f);
                blockpos = new BlockPos(this);
            }
            worldserver.func_72866_a(this, false);
            this.field_70170_p.field_72984_F.func_76318_c("reloading");
            Object entity = this.func_200600_R().func_200721_a(worldserver1);
            if (entity != null) {
                ((Entity)((Object)entity)).func_180432_n(this);
                if (dimensiontype == DimensionType.THE_END && p_212321_1_ == DimensionType.THE_END && teleporter.isVanilla()) {
                    BlockPos blockpos1 = worldserver1.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, worldserver1.func_175694_M());
                    ((Entity)((Object)entity)).func_174828_a(blockpos1, ((Entity)((Object)entity)).field_70177_z, ((Entity)((Object)entity)).field_70125_A);
                } else {
                    ((Entity)((Object)entity)).func_174828_a(blockpos, ((Entity)((Object)entity)).field_70177_z, ((Entity)((Object)entity)).field_70125_A);
                }
                boolean flag = ((Entity)((Object)entity)).field_98038_p;
                ((Entity)((Object)entity)).field_98038_p = true;
                worldserver1.func_72838_d((Entity)((Object)entity));
                ((Entity)((Object)entity)).field_98038_p = flag;
                worldserver1.func_72866_a((Entity)((Object)entity), false);
            }
            this.remove(false);
            this.field_70170_p.field_72984_F.func_76319_b();
            worldserver.func_82742_i();
            worldserver1.func_82742_i();
            this.field_70170_p.field_72984_F.func_76319_b();
            return entity;
        }
        return null;
    }

    public boolean func_184222_aU() {
        return true;
    }

    public float func_180428_a(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, IBlockState blockStateIn, IFluidState p_180428_5_, float p_180428_6_) {
        return p_180428_6_;
    }

    public boolean func_174816_a(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, IBlockState blockStateIn, float p_174816_5_) {
        return true;
    }

    public int func_82143_as() {
        return 3;
    }

    public Vec3d func_181014_aG() {
        return this.field_181017_ao;
    }

    public EnumFacing func_181012_aH() {
        return this.field_181018_ap;
    }

    public boolean func_145773_az() {
        return false;
    }

    public void func_85029_a(CrashReportCategory category) {
        category.func_189529_a("Entity Type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> EntityType.func_200718_a(this.func_200600_R()) + " (" + ((Object)((Object)this)).getClass().getCanonicalName() + ")"));
        category.func_71507_a("Entity ID", this.field_145783_c);
        category.func_189529_a("Entity Name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.func_200200_C_().getString()));
        category.func_71507_a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.field_70165_t, this.field_70163_u, this.field_70161_v));
        category.func_71507_a("Entity's Block location", CrashReportCategory.func_184876_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)));
        category.func_71507_a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.field_70159_w, this.field_70181_x, this.field_70179_y));
        category.func_189529_a("Entity's Passengers", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.func_184188_bt().toString()));
        category.func_189529_a("Entity's Vehicle", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.func_184187_bx().toString()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return this.func_70027_ad();
    }

    public void func_184221_a(UUID uniqueIdIn) {
        this.field_96093_i = uniqueIdIn;
        this.field_189513_ar = this.field_96093_i.toString();
    }

    public UUID func_110124_au() {
        return this.field_96093_i;
    }

    public String func_189512_bd() {
        return this.field_189513_ar;
    }

    public String func_195047_I_() {
        return this.field_189513_ar;
    }

    public boolean func_96092_aw() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static double func_184183_bd() {
        return field_70155_l;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_184227_b(double renderDistWeight) {
        field_70155_l = renderDistWeight;
    }

    public ITextComponent func_145748_c_() {
        return ScorePlayerTeam.func_200541_a((Team)this.func_96124_cp(), (ITextComponent)this.func_200200_C_()).func_211710_a(p_211516_1_ -> p_211516_1_.func_150209_a(this.func_174823_aP()).func_179989_a(this.func_189512_bd()));
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        this.field_70180_af.func_187227_b(field_184242_az, Optional.ofNullable(name));
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.field_70180_af.func_187225_a(field_184242_az).orElse(null);
    }

    public boolean func_145818_k_() {
        return this.field_70180_af.func_187225_a(field_184242_az).isPresent();
    }

    public void func_174805_g(boolean alwaysRenderNameTag) {
        this.field_70180_af.func_187227_b(field_184233_aA, alwaysRenderNameTag);
    }

    public boolean func_174833_aM() {
        return this.field_70180_af.func_187225_a(field_184233_aA);
    }

    public void func_70634_a(double x, double y, double z) {
        this.field_184237_aG = true;
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.field_70170_p.func_72866_a(this, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_94059_bO() {
        return this.func_174833_aM();
    }

    public void func_184206_a(DataParameter<?> key) {
    }

    public EnumFacing func_174811_aO() {
        return EnumFacing.func_176733_a(this.field_70177_z);
    }

    public EnumFacing func_184172_bi() {
        return this.func_174811_aO();
    }

    protected HoverEvent func_174823_aP() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        ResourceLocation resourcelocation = EntityType.func_200718_a(this.func_200600_R());
        nbttagcompound.func_74778_a("id", this.func_189512_bd());
        if (resourcelocation != null) {
            nbttagcompound.func_74778_a("type", resourcelocation.toString());
        }
        nbttagcompound.func_74778_a("name", ITextComponent.Serializer.func_150696_a((ITextComponent)this.func_200200_C_()));
        return new HoverEvent(HoverEvent.Action.SHOW_ENTITY, (ITextComponent)new TextComponentString(nbttagcompound.toString()));
    }

    public boolean func_174827_a(EntityPlayerMP player) {
        return true;
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.field_70121_D;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ();
    }

    public void func_174826_a(AxisAlignedBB bb) {
        this.field_70121_D = bb;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f;
    }

    public boolean func_174832_aS() {
        return this.field_174835_g;
    }

    public void func_174821_h(boolean outsideBorder) {
        this.field_174835_g = outsideBorder;
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        return false;
    }

    public void func_145747_a(ITextComponent component) {
    }

    public BlockPos func_180425_c() {
        return new BlockPos(this);
    }

    public Vec3d func_174791_d() {
        return new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public World func_130014_f_() {
        return this.field_70170_p;
    }

    @Nullable
    public MinecraftServer func_184102_h() {
        return this.field_70170_p.func_73046_m();
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    public boolean func_180427_aV() {
        return false;
    }

    protected void func_174815_a(EntityLivingBase entityLivingBaseIn, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            EnchantmentHelper.func_151384_a((EntityLivingBase)entityIn, entityLivingBaseIn);
        }
        EnchantmentHelper.func_151385_b(entityLivingBaseIn, entityIn);
    }

    public void func_184178_b(EntityPlayerMP player) {
    }

    public void func_184203_c(EntityPlayerMP player) {
    }

    public float func_184229_a(Rotation transformRotation) {
        float f = MathHelper.func_76142_g((float)this.field_70177_z);
        switch (transformRotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 270.0f;
            }
            case CLOCKWISE_90: {
                return f + 90.0f;
            }
        }
        return f;
    }

    public float func_184217_a(Mirror transformMirror) {
        float f = MathHelper.func_76142_g((float)this.field_70177_z);
        switch (transformMirror) {
            case LEFT_RIGHT: {
                return -f;
            }
            case FRONT_BACK: {
                return 180.0f - f;
            }
        }
        return f;
    }

    public boolean func_184213_bq() {
        return false;
    }

    public boolean func_184189_br() {
        boolean flag = this.field_184237_aG;
        this.field_184237_aG = false;
        return flag;
    }

    @Nullable
    public Entity func_184179_bs() {
        return null;
    }

    public List<Entity> func_184188_bt() {
        return this.field_184244_h.isEmpty() ? Collections.emptyList() : Lists.newArrayList(this.field_184244_h);
    }

    public boolean func_184196_w(Entity entityIn) {
        for (Entity entity : this.func_184188_bt()) {
            if (!entity.equals((Object)entityIn)) continue;
            return true;
        }
        return false;
    }

    public boolean func_205708_a(Class<? extends Entity> p_205708_1_) {
        for (Entity entity : this.func_184188_bt()) {
            if (!p_205708_1_.isAssignableFrom(((Object)((Object)entity)).getClass())) continue;
            return true;
        }
        return false;
    }

    public Collection<Entity> func_184182_bu() {
        HashSet set = Sets.newHashSet();
        for (Entity entity : this.func_184188_bt()) {
            set.add(entity);
            entity.func_200604_a(false, set);
        }
        return set;
    }

    public boolean func_200601_bK() {
        HashSet set = Sets.newHashSet();
        this.func_200604_a(true, set);
        return set.size() == 1;
    }

    private void func_200604_a(boolean playersOnly, Set<Entity> p_200604_2_) {
        for (Entity entity : this.func_184188_bt()) {
            if (!playersOnly || EntityPlayerMP.class.isAssignableFrom(((Object)((Object)entity)).getClass())) {
                p_200604_2_.add(entity);
            }
            entity.func_200604_a(playersOnly, p_200604_2_);
        }
    }

    public Entity func_184208_bv() {
        Entity entity = this;
        while (entity.func_184218_aH()) {
            entity = entity.func_184187_bx();
        }
        return entity;
    }

    public boolean func_184223_x(Entity entityIn) {
        return this.func_184208_bv() == entityIn.func_184208_bv();
    }

    public boolean func_184215_y(Entity entityIn) {
        for (Entity entity : this.func_184188_bt()) {
            if (entity.equals((Object)entityIn)) {
                return true;
            }
            if (!entity.func_184215_y(entityIn)) continue;
            return true;
        }
        return false;
    }

    public boolean func_184186_bw() {
        Entity entity = this.func_184179_bs();
        if (entity instanceof EntityPlayer) {
            return ((EntityPlayer)entity).func_175144_cb();
        }
        return !this.field_70170_p.field_72995_K;
    }

    @Nullable
    public Entity func_184187_bx() {
        return this.field_184239_as;
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.NORMAL;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    protected int func_190531_bD() {
        return 1;
    }

    public CommandSource func_195051_bN() {
        return new CommandSource((ICommandSource)this, new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), this.func_189653_aC(), this.field_70170_p instanceof WorldServer ? (WorldServer)this.field_70170_p : null, this.func_184840_I(), this.func_200200_C_().getString(), this.func_145748_c_(), this.field_70170_p.func_73046_m(), this);
    }

    protected int func_184840_I() {
        return 0;
    }

    public boolean func_211513_k(int p_211513_1_) {
        return this.func_184840_I() >= p_211513_1_;
    }

    public boolean func_195039_a() {
        return this.field_70170_p.func_82736_K().func_82766_b("sendCommandFeedback");
    }

    public boolean func_195040_b() {
        return true;
    }

    public boolean func_195041_r_() {
        return true;
    }

    public void func_200602_a(EntityAnchorArgument.Type p_200602_1_, Vec3d p_200602_2_) {
        Vec3d vec3d = p_200602_1_.func_201017_a(this);
        double d0 = p_200602_2_.field_72450_a - vec3d.field_72450_a;
        double d1 = p_200602_2_.field_72448_b - vec3d.field_72448_b;
        double d2 = p_200602_2_.field_72449_c - vec3d.field_72449_c;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        this.field_70125_A = MathHelper.func_76142_g((float)((float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875))));
        this.field_70177_z = MathHelper.func_76142_g((float)((float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
        this.func_70034_d(this.field_70177_z);
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
    }

    public boolean func_210500_b(Tag<Fluid> p_210500_1_) {
        int j1;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186664_h(0.001);
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)axisalignedbb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        if (!this.field_70170_p.func_175663_a(i, k, i1, j, l, j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f), true)) {
            return false;
        }
        double d0 = 0.0;
        boolean flag = this.func_96092_aw();
        boolean flag1 = false;
        Vec3d vec3d = Vec3d.field_186680_a;
        int k1 = 0;
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = k; i2 < l; ++i2) {
                    for (int j2 = i1; j2 < j1; ++j2) {
                        double d1;
                        blockpos$pooledmutableblockpos.func_181079_c(l1, i2, j2);
                        IFluidState ifluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$pooledmutableblockpos);
                        if (!ifluidstate.func_206884_a(p_210500_1_) || !((d1 = (double)((float)i2 + ifluidstate.func_206885_f())) >= axisalignedbb.field_72338_b)) continue;
                        flag1 = true;
                        d0 = Math.max(d1 - axisalignedbb.field_72338_b, d0);
                        if (!flag) continue;
                        Vec3d vec3d1 = ifluidstate.func_206887_a(this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos);
                        if (d0 < 0.4) {
                            vec3d1 = vec3d1.func_186678_a(d0);
                        }
                        vec3d = vec3d.func_178787_e(vec3d1);
                        ++k1;
                    }
                }
            }
        }
        if (vec3d.func_72433_c() > 0.0) {
            if (k1 > 0) {
                vec3d = vec3d.func_186678_a(1.0 / (double)k1);
            }
            if (!(this instanceof EntityPlayer)) {
                vec3d = vec3d.func_72432_b();
            }
            double d2 = 0.014;
            this.field_70159_w += vec3d.field_72450_a * 0.014;
            this.field_70181_x += vec3d.field_72448_b * 0.014;
            this.field_70179_y += vec3d.field_72449_c * 0.014;
        }
        this.field_211517_W = d0;
        return flag1;
    }

    public double func_212107_bY() {
        return this.field_211517_W;
    }

    public void canUpdate(boolean value) {
        this.canUpdate = value;
    }

    public boolean canUpdate() {
        return this.canUpdate;
    }

    public Collection<EntityItem> captureDrops() {
        return this.captureDrops;
    }

    public Collection<EntityItem> captureDrops(Collection<EntityItem> value) {
        Collection<EntityItem> ret = this.captureDrops;
        this.captureDrops = value;
        return ret;
    }

    public NBTTagCompound getEntityData() {
        if (this.entityData == null) {
            this.entityData = new NBTTagCompound();
        }
        return this.entityData;
    }

    public boolean canTrample(IBlockState state, BlockPos pos, float fallDistance) {
        return this.field_70170_p.field_73012_v.nextFloat() < fallDistance - 0.5f && this instanceof EntityLivingBase && (this instanceof EntityPlayer || ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) && this.field_70130_N * this.field_70130_N * this.field_70131_O > 0.512f;
    }

    public final boolean isAddedToWorld() {
        return this.isAddedToWorld;
    }

    public void onAddedToWorld() {
        this.isAddedToWorld = true;
    }

    public void onRemovedFromWorld() {
        this.isAddedToWorld = false;
    }

    public void revive() {
        this.field_70128_L = false;
        this.reviveCaps();
    }

    static {
        field_184240_ax = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187191_a);
        field_184241_ay = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187192_b);
        field_184242_az = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_200544_f);
        field_184233_aA = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187198_h);
        field_184234_aB = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187198_h);
        field_189655_aD = EntityDataManager.func_187226_a(Entity.class, DataSerializers.field_187198_h);
    }
}

