/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentArrowDamage;
import net.minecraft.enchantment.EnchantmentArrowFire;
import net.minecraft.enchantment.EnchantmentArrowInfinite;
import net.minecraft.enchantment.EnchantmentArrowKnockback;
import net.minecraft.enchantment.EnchantmentBindingCurse;
import net.minecraft.enchantment.EnchantmentChanneling;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.enchantment.EnchantmentDigging;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentFireAspect;
import net.minecraft.enchantment.EnchantmentFishingSpeed;
import net.minecraft.enchantment.EnchantmentFrostWalker;
import net.minecraft.enchantment.EnchantmentImpaling;
import net.minecraft.enchantment.EnchantmentKnockback;
import net.minecraft.enchantment.EnchantmentLootBonus;
import net.minecraft.enchantment.EnchantmentLoyalty;
import net.minecraft.enchantment.EnchantmentMending;
import net.minecraft.enchantment.EnchantmentOxygen;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.enchantment.EnchantmentRiptide;
import net.minecraft.enchantment.EnchantmentSweepingEdge;
import net.minecraft.enchantment.EnchantmentThorns;
import net.minecraft.enchantment.EnchantmentUntouching;
import net.minecraft.enchantment.EnchantmentVanishingCurse;
import net.minecraft.enchantment.EnchantmentWaterWalker;
import net.minecraft.enchantment.EnchantmentWaterWorker;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Enchantment
extends ForgeRegistryEntry<Enchantment> {
    private final EntityEquipmentSlot[] field_185263_a;
    private final Rarity field_77333_a;
    @Nullable
    public EnumEnchantmentType field_77351_y;
    @Nullable
    protected String field_77350_z;

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static Enchantment func_185262_c(int id) {
        return IRegistry.field_212628_q.func_148754_a(id);
    }

    protected Enchantment(Rarity rarityIn, EnumEnchantmentType typeIn, EntityEquipmentSlot[] slots) {
        this.field_77333_a = rarityIn;
        this.field_77351_y = typeIn;
        this.field_185263_a = slots;
    }

    public List<ItemStack> func_185260_a(EntityLivingBase entityIn) {
        ArrayList list = Lists.newArrayList();
        for (EntityEquipmentSlot entityequipmentslot : this.field_185263_a) {
            ItemStack itemstack = entityIn.func_184582_a(entityequipmentslot);
            if (itemstack.func_190926_b()) continue;
            list.add(itemstack);
        }
        return list;
    }

    public Rarity func_77324_c() {
        return this.field_77333_a;
    }

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 1;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 1 + enchantmentLevel * 10;
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 5;
    }

    public int func_77318_a(int level, DamageSource source) {
        return 0;
    }

    public float func_152376_a(int level, CreatureAttribute creatureType) {
        return 0.0f;
    }

    public final boolean func_191560_c(Enchantment enchantmentIn) {
        return this.func_77326_a(enchantmentIn) && enchantmentIn.func_77326_a(this);
    }

    protected boolean func_77326_a(Enchantment ench) {
        return this != ench;
    }

    protected String func_210771_f() {
        if (this.field_77350_z == null) {
            this.field_77350_z = Util.func_200697_a((String)"enchantment", (ResourceLocation)IRegistry.field_212628_q.func_177774_c(this));
        }
        return this.field_77350_z;
    }

    public String func_77320_a() {
        return this.func_210771_f();
    }

    public ITextComponent func_200305_d(int p_200305_1_) {
        TextComponentTranslation itextcomponent = new TextComponentTranslation(this.func_77320_a(), new Object[0]);
        if (this.func_190936_d()) {
            itextcomponent.func_211708_a(TextFormatting.RED);
        } else {
            itextcomponent.func_211708_a(TextFormatting.GRAY);
        }
        if (p_200305_1_ != 1 || this.func_77325_b() != 1) {
            itextcomponent.func_150258_a(" ").func_150257_a((ITextComponent)new TextComponentTranslation("enchantment.level." + p_200305_1_, new Object[0]));
        }
        return itextcomponent;
    }

    public boolean func_92089_a(ItemStack stack) {
        return this.canApplyAtEnchantingTable(stack);
    }

    public void func_151368_a(EntityLivingBase user, Entity target, int level) {
    }

    public void func_151367_b(EntityLivingBase user, Entity attacker, int level) {
    }

    public boolean func_185261_e() {
        return false;
    }

    public boolean func_190936_d() {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.canApplyAtEnchantingTable(this);
    }

    public boolean isAllowedOnBooks() {
        return true;
    }

    public static void func_185257_f() {
        EntityEquipmentSlot[] aentityequipmentslot = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
        Enchantment.func_210770_a("protection", (Enchantment)new EnchantmentProtection(Rarity.COMMON, EnchantmentProtection.Type.ALL, aentityequipmentslot));
        Enchantment.func_210770_a("fire_protection", (Enchantment)new EnchantmentProtection(Rarity.UNCOMMON, EnchantmentProtection.Type.FIRE, aentityequipmentslot));
        Enchantment.func_210770_a("feather_falling", (Enchantment)new EnchantmentProtection(Rarity.UNCOMMON, EnchantmentProtection.Type.FALL, aentityequipmentslot));
        Enchantment.func_210770_a("blast_protection", (Enchantment)new EnchantmentProtection(Rarity.RARE, EnchantmentProtection.Type.EXPLOSION, aentityequipmentslot));
        Enchantment.func_210770_a("projectile_protection", (Enchantment)new EnchantmentProtection(Rarity.UNCOMMON, EnchantmentProtection.Type.PROJECTILE, aentityequipmentslot));
        Enchantment.func_210770_a("respiration", (Enchantment)new EnchantmentOxygen(Rarity.RARE, aentityequipmentslot));
        Enchantment.func_210770_a("aqua_affinity", (Enchantment)new EnchantmentWaterWorker(Rarity.RARE, aentityequipmentslot));
        Enchantment.func_210770_a("thorns", (Enchantment)new EnchantmentThorns(Rarity.VERY_RARE, aentityequipmentslot));
        Enchantment.func_210770_a("depth_strider", (Enchantment)new EnchantmentWaterWalker(Rarity.RARE, aentityequipmentslot));
        Enchantment.func_210770_a("frost_walker", new EnchantmentFrostWalker(Rarity.RARE, EntityEquipmentSlot.FEET));
        Enchantment.func_210770_a("binding_curse", (Enchantment)new EnchantmentBindingCurse(Rarity.VERY_RARE, aentityequipmentslot));
        Enchantment.func_210770_a("sharpness", (Enchantment)new EnchantmentDamage(Rarity.COMMON, 0, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("smite", (Enchantment)new EnchantmentDamage(Rarity.UNCOMMON, 1, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("bane_of_arthropods", (Enchantment)new EnchantmentDamage(Rarity.UNCOMMON, 2, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("knockback", (Enchantment)new EnchantmentKnockback(Rarity.UNCOMMON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("fire_aspect", (Enchantment)new EnchantmentFireAspect(Rarity.RARE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("looting", (Enchantment)new EnchantmentLootBonus(Rarity.RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("sweeping", (Enchantment)new EnchantmentSweepingEdge(Rarity.RARE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("efficiency", (Enchantment)new EnchantmentDigging(Rarity.COMMON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("silk_touch", (Enchantment)new EnchantmentUntouching(Rarity.VERY_RARE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("unbreaking", (Enchantment)new EnchantmentDurability(Rarity.UNCOMMON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("fortune", (Enchantment)new EnchantmentLootBonus(Rarity.RARE, EnumEnchantmentType.DIGGER, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("power", (Enchantment)new EnchantmentArrowDamage(Rarity.COMMON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("punch", (Enchantment)new EnchantmentArrowKnockback(Rarity.RARE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("flame", (Enchantment)new EnchantmentArrowFire(Rarity.RARE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("infinity", (Enchantment)new EnchantmentArrowInfinite(Rarity.VERY_RARE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("luck_of_the_sea", (Enchantment)new EnchantmentLootBonus(Rarity.RARE, EnumEnchantmentType.FISHING_ROD, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("lure", (Enchantment)new EnchantmentFishingSpeed(Rarity.RARE, EnumEnchantmentType.FISHING_ROD, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("loyalty", (Enchantment)new EnchantmentLoyalty(Rarity.UNCOMMON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("impaling", (Enchantment)new EnchantmentImpaling(Rarity.RARE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("riptide", (Enchantment)new EnchantmentRiptide(Rarity.RARE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("channeling", (Enchantment)new EnchantmentChanneling(Rarity.VERY_RARE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND}));
        Enchantment.func_210770_a("mending", (Enchantment)new EnchantmentMending(Rarity.RARE, EntityEquipmentSlot.values()));
        Enchantment.func_210770_a("vanishing_curse", (Enchantment)new EnchantmentVanishingCurse(Rarity.VERY_RARE, EntityEquipmentSlot.values()));
    }

    private static void func_210770_a(String nameIn, Enchantment enchantmentIn) {
        IRegistry.field_212628_q.func_82595_a(new ResourceLocation(nameIn), enchantmentIn);
    }

    public static enum Rarity {
        COMMON(10),
        UNCOMMON(5),
        RARE(2),
        VERY_RARE(1);

        private final int field_185275_e;

        private Rarity(int rarityWeight) {
            this.field_185275_e = rarityWeight;
        }

        public int func_185270_a() {
            return this.field_185275_e;
        }
    }
}

