/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderDefault;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.shader.ShaderLoader;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.client.util.JsonBlendingMode;
import net.minecraft.client.util.JsonException;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ShaderManager
implements AutoCloseable {
    private static final Logger field_148003_a = LogManager.getLogger();
    private static final ShaderDefault field_148001_b = new ShaderDefault();
    private static ShaderManager field_148002_c;
    private static int field_147999_d;
    private final Map<String, Object> field_147997_f = Maps.newHashMap();
    private final List<String> field_147998_g = Lists.newArrayList();
    private final List<Integer> field_148010_h = Lists.newArrayList();
    private final List<ShaderUniform> field_148011_i = Lists.newArrayList();
    private final List<Integer> field_148008_j = Lists.newArrayList();
    private final Map<String, ShaderUniform> field_148009_k = Maps.newHashMap();
    private final int field_148006_l;
    private final String field_148007_m;
    private final boolean field_148004_n;
    private boolean field_148005_o;
    private final JsonBlendingMode field_148016_p;
    private final List<Integer> field_148015_q;
    private final List<String> field_148014_r;
    private final ShaderLoader field_148013_s;
    private final ShaderLoader field_148012_t;

    public ShaderManager(IResourceManager resourceManager, String programName) throws IOException {
        ResourceLocation rl = ResourceLocation.func_208304_a((String)programName);
        ResourceLocation resourcelocation = new ResourceLocation(rl.func_110624_b(), "shaders/program/" + rl.func_110623_a() + ".json");
        this.field_148007_m = programName;
        IResource iresource = null;
        try {
            JsonArray jsonarray2;
            JsonArray jsonarray1;
            iresource = resourceManager.func_199002_a(resourcelocation);
            JsonObject jsonobject = JsonUtils.func_212743_a((Reader)new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8));
            String s = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"vertex");
            String s1 = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"fragment");
            JsonArray jsonarray = JsonUtils.func_151213_a((JsonObject)jsonobject, (String)"samplers", (JsonArray)null);
            if (jsonarray != null) {
                int i = 0;
                for (Object jsonelement : jsonarray) {
                    try {
                        this.func_147996_a((JsonElement)jsonelement);
                    }
                    catch (Exception exception2) {
                        JsonException jsonexception1 = JsonException.func_151379_a((Exception)exception2);
                        jsonexception1.func_151380_a("samplers[" + i + "]");
                        throw jsonexception1;
                    }
                    ++i;
                }
            }
            if ((jsonarray1 = JsonUtils.func_151213_a((JsonObject)jsonobject, (String)"attributes", (JsonArray)null)) != null) {
                int j = 0;
                this.field_148015_q = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                this.field_148014_r = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                for (Iterator jsonelement1 : jsonarray1) {
                    try {
                        this.field_148014_r.add(JsonUtils.func_151206_a((JsonElement)jsonelement1, (String)"attribute"));
                    }
                    catch (Exception exception1) {
                        JsonException jsonexception2 = JsonException.func_151379_a((Exception)exception1);
                        jsonexception2.func_151380_a("attributes[" + j + "]");
                        throw jsonexception2;
                    }
                    ++j;
                }
            } else {
                this.field_148015_q = null;
                this.field_148014_r = null;
            }
            if ((jsonarray2 = JsonUtils.func_151213_a((JsonObject)jsonobject, (String)"uniforms", (JsonArray)null)) != null) {
                int k = 0;
                for (JsonElement jsonelement2 : jsonarray2) {
                    try {
                        this.func_147987_b(jsonelement2);
                    }
                    catch (Exception exception) {
                        JsonException jsonexception3 = JsonException.func_151379_a((Exception)exception);
                        jsonexception3.func_151380_a("uniforms[" + k + "]");
                        throw jsonexception3;
                    }
                    ++k;
                }
            }
            this.field_148016_p = JsonBlendingMode.func_148110_a((JsonObject)JsonUtils.func_151218_a((JsonObject)jsonobject, (String)"blend", (JsonObject)null));
            this.field_148004_n = JsonUtils.func_151209_a((JsonObject)jsonobject, (String)"cull", (boolean)true);
            this.field_148013_s = ShaderLoader.func_195655_a(resourceManager, ShaderLoader.ShaderType.VERTEX, s);
            this.field_148012_t = ShaderLoader.func_195655_a(resourceManager, ShaderLoader.ShaderType.FRAGMENT, s1);
            this.field_148006_l = ShaderLinkHelper.func_148074_b().func_148078_c();
            ShaderLinkHelper.func_148074_b().func_148075_b(this);
            this.func_147990_i();
            if (this.field_148014_r != null) {
                for (String s2 : this.field_148014_r) {
                    int l = OpenGlHelper.func_153164_b(this.field_148006_l, s2);
                    this.field_148015_q.add(l);
                }
            }
        }
        catch (Exception exception3) {
            JsonException jsonexception = JsonException.func_151379_a((Exception)exception3);
            jsonexception.func_151381_b(resourcelocation.func_110623_a());
            throw jsonexception;
        }
        finally {
            IOUtils.closeQuietly((Closeable)iresource);
        }
        this.func_147985_d();
    }

    @Override
    public void close() {
        for (ShaderUniform shaderuniform : this.field_148011_i) {
            shaderuniform.close();
        }
        ShaderLinkHelper.func_148074_b().func_148077_a(this);
    }

    public void func_147993_b() {
        OpenGlHelper.func_153161_d(0);
        field_147999_d = -1;
        field_148002_c = null;
        for (int i = 0; i < this.field_148010_h.size(); ++i) {
            if (this.field_147997_f.get(this.field_147998_g.get(i)) == null) continue;
            GlStateManager.func_179138_g((int)(OpenGlHelper.field_77478_a + i));
            GlStateManager.func_179144_i((int)0);
        }
    }

    public void func_147995_c() {
        this.field_148005_o = false;
        field_148002_c = this;
        this.field_148016_p.func_148109_a();
        if (this.field_148006_l != field_147999_d) {
            OpenGlHelper.func_153161_d(this.field_148006_l);
            field_147999_d = this.field_148006_l;
        }
        if (this.field_148004_n) {
            GlStateManager.func_179089_o();
        } else {
            GlStateManager.func_179129_p();
        }
        for (int i = 0; i < this.field_148010_h.size(); ++i) {
            if (this.field_147997_f.get(this.field_147998_g.get(i)) == null) continue;
            GlStateManager.func_179138_g((int)(OpenGlHelper.field_77478_a + i));
            GlStateManager.func_179098_w();
            Object object = this.field_147997_f.get(this.field_147998_g.get(i));
            int j = -1;
            if (object instanceof Framebuffer) {
                j = ((Framebuffer)object).field_147617_g;
            } else if (object instanceof ITextureObject) {
                j = ((ITextureObject)object).func_110552_b();
            } else if (object instanceof Integer) {
                j = (Integer)object;
            }
            if (j == -1) continue;
            GlStateManager.func_179144_i((int)j);
            OpenGlHelper.func_153163_f(OpenGlHelper.func_153194_a(this.field_148006_l, this.field_147998_g.get(i)), i);
        }
        for (ShaderUniform shaderuniform : this.field_148011_i) {
            shaderuniform.func_148093_b();
        }
    }

    public void func_147985_d() {
        this.field_148005_o = true;
    }

    @Nullable
    public ShaderUniform func_147991_a(String name) {
        return this.field_148009_k.get(name);
    }

    public ShaderDefault func_195653_b(String p_195653_1_) {
        ShaderUniform shaderuniform = this.func_147991_a(p_195653_1_);
        return shaderuniform == null ? field_148001_b : shaderuniform;
    }

    private void func_147990_i() {
        int i = 0;
        int j = 0;
        while (i < this.field_147998_g.size()) {
            String s = this.field_147998_g.get(i);
            int k = OpenGlHelper.func_153194_a(this.field_148006_l, s);
            if (k == -1) {
                field_148003_a.warn("Shader {}could not find sampler named {} in the specified shader program.", (Object)this.field_148007_m, (Object)s);
                this.field_147997_f.remove(s);
                this.field_147998_g.remove(j);
                --j;
            } else {
                this.field_148010_h.add(k);
            }
            ++i;
            ++j;
        }
        for (ShaderUniform shaderuniform : this.field_148011_i) {
            String s1 = shaderuniform.func_148086_a();
            int l = OpenGlHelper.func_153194_a(this.field_148006_l, s1);
            if (l == -1) {
                field_148003_a.warn("Could not find uniform named {} in the specified shader program.", (Object)s1);
                continue;
            }
            this.field_148008_j.add(l);
            shaderuniform.func_148084_b(l);
            this.field_148009_k.put(s1, shaderuniform);
        }
    }

    private void func_147996_a(JsonElement element) {
        JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)element, (String)"sampler");
        String s = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"name");
        if (!JsonUtils.func_151205_a((JsonObject)jsonobject, (String)"file")) {
            this.field_147997_f.put(s, null);
            this.field_147998_g.add(s);
        } else {
            this.field_147998_g.add(s);
        }
    }

    public void func_147992_a(String name, Object samplerTexture) {
        if (this.field_147997_f.containsKey(name)) {
            this.field_147997_f.remove(name);
        }
        this.field_147997_f.put(name, samplerTexture);
        this.func_147985_d();
    }

    private void func_147987_b(JsonElement element) throws JsonException {
        JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)element, (String)"uniform");
        String s = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"name");
        int i = ShaderUniform.func_148085_a((String)JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"type"));
        int j = JsonUtils.func_151203_m((JsonObject)jsonobject, (String)"count");
        float[] afloat = new float[Math.max(j, 16)];
        JsonArray jsonarray = JsonUtils.func_151214_t((JsonObject)jsonobject, (String)"values");
        if (jsonarray.size() != j && jsonarray.size() > 1) {
            throw new JsonException("Invalid amount of values specified (expected " + j + ", found " + jsonarray.size() + ")");
        }
        int k = 0;
        for (JsonElement jsonelement : jsonarray) {
            try {
                afloat[k] = JsonUtils.func_151220_d((JsonElement)jsonelement, (String)"value");
            }
            catch (Exception exception) {
                JsonException jsonexception = JsonException.func_151379_a((Exception)exception);
                jsonexception.func_151380_a("values[" + k + "]");
                throw jsonexception;
            }
            ++k;
        }
        if (j > 1 && jsonarray.size() == 1) {
            while (k < j) {
                afloat[k] = afloat[0];
                ++k;
            }
        }
        int l = j > 1 && j <= 4 && i < 8 ? j - 1 : 0;
        ShaderUniform shaderuniform = new ShaderUniform(s, i + l, j, this);
        if (i <= 3) {
            shaderuniform.func_148083_a((int)afloat[0], (int)afloat[1], (int)afloat[2], (int)afloat[3]);
        } else if (i <= 7) {
            shaderuniform.func_148092_b(afloat[0], afloat[1], afloat[2], afloat[3]);
        } else {
            shaderuniform.func_148097_a(afloat);
        }
        this.field_148011_i.add(shaderuniform);
    }

    public ShaderLoader func_147989_e() {
        return this.field_148013_s;
    }

    public ShaderLoader func_147994_f() {
        return this.field_148012_t;
    }

    public int func_147986_h() {
        return this.field_148006_l;
    }

    static {
        field_147999_d = -1;
    }
}

