/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.IForgeTextureAtlasSprite;

@OnlyIn(value=Dist.CLIENT)
public class TextureAtlasSprite
implements IForgeTextureAtlasSprite {
    private final ResourceLocation field_110984_i;
    protected final int field_130223_c;
    protected final int field_130224_d;
    protected NativeImage[] field_195670_c;
    @Nullable
    protected int[] field_195671_d;
    @Nullable
    protected int[] field_195672_e;
    protected NativeImage[] field_176605_b;
    private AnimationMetadataSection field_110982_k;
    protected boolean field_130222_e;
    protected int field_110975_c;
    protected int field_110974_d;
    private float field_110979_l;
    private float field_110980_m;
    private float field_110977_n;
    private float field_110978_o;
    protected int field_110973_g;
    protected int field_110983_h;
    private static final int[] field_195673_r = new int[4];
    private static final float[] field_195674_s = (float[])Util.func_200696_a((Object)new float[256], p_203415_0_ -> {
        for (int i = 0; i < ((float[])p_203415_0_).length; ++i) {
            p_203415_0_[i] = (float)Math.pow((float)i / 255.0f, 2.2);
        }
    });

    protected TextureAtlasSprite(ResourceLocation locationIn, int widthIn, int heightIn) {
        this.field_110984_i = locationIn;
        this.field_130223_c = widthIn;
        this.field_130224_d = heightIn;
    }

    protected TextureAtlasSprite(ResourceLocation locationIn, PngSizeInfo sizeIn, @Nullable AnimationMetadataSection animationMetadataIn) {
        this.field_110984_i = locationIn;
        if (animationMetadataIn != null) {
            int i;
            this.field_130224_d = this.field_130223_c = (i = Math.min(sizeIn.field_188533_a, sizeIn.field_188534_b));
        } else {
            if (sizeIn.field_188534_b != sizeIn.field_188533_a) {
                throw new RuntimeException("broken aspect ratio and not an animation");
            }
            this.field_130223_c = sizeIn.field_188533_a;
            this.field_130224_d = sizeIn.field_188534_b;
        }
        this.field_110982_k = animationMetadataIn;
    }

    private void func_195666_b(int level) {
        NativeImage[] anativeimage = new NativeImage[level + 1];
        anativeimage[0] = this.field_195670_c[0];
        if (level > 0) {
            boolean flag = false;
            block0: for (int i = 0; i < this.field_195670_c[0].func_195702_a(); ++i) {
                for (int j = 0; j < this.field_195670_c[0].func_195714_b(); ++j) {
                    if (this.field_195670_c[0].func_195709_a(i, j) >> 24 != 0) continue;
                    flag = true;
                    break block0;
                }
            }
            for (int k1 = 1; k1 <= level; ++k1) {
                if (this.field_195670_c.length > k1 && this.field_195670_c[k1] != null) {
                    anativeimage[k1] = this.field_195670_c[k1];
                    continue;
                }
                NativeImage nativeimage1 = anativeimage[k1 - 1];
                int width = nativeimage1.func_195702_a() >> 1;
                int height = nativeimage1.func_195714_b() >> 1;
                if (width > 0 && height > 0) {
                    NativeImage nativeimage = new NativeImage(width, height, false);
                    int k = nativeimage.func_195702_a();
                    int l = nativeimage.func_195714_b();
                    for (int i1 = 0; i1 < k; ++i1) {
                        for (int j1 = 0; j1 < l; ++j1) {
                            nativeimage.func_195700_a(i1, j1, TextureAtlasSprite.func_195661_b(nativeimage1.func_195709_a(i1 * 2 + 0, j1 * 2 + 0), nativeimage1.func_195709_a(i1 * 2 + 1, j1 * 2 + 0), nativeimage1.func_195709_a(i1 * 2 + 0, j1 * 2 + 1), nativeimage1.func_195709_a(i1 * 2 + 1, j1 * 2 + 1), flag));
                        }
                    }
                    anativeimage[k1] = nativeimage;
                    continue;
                }
                anativeimage[k1] = nativeimage1;
            }
            for (int l1 = level + 1; l1 < this.field_195670_c.length; ++l1) {
                if (this.field_195670_c[l1] == null) continue;
                this.field_195670_c[l1].close();
            }
        }
        this.field_195670_c = anativeimage;
    }

    private static int func_195661_b(int col0, int col1, int col2, int col3, boolean transparent) {
        if (transparent) {
            TextureAtlasSprite.field_195673_r[0] = col0;
            TextureAtlasSprite.field_195673_r[1] = col1;
            TextureAtlasSprite.field_195673_r[2] = col2;
            TextureAtlasSprite.field_195673_r[3] = col3;
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (int i1 = 0; i1 < 4; ++i1) {
                if (field_195673_r[i1] >> 24 == 0) continue;
                f += TextureAtlasSprite.func_195660_c(field_195673_r[i1] >> 24);
                f1 += TextureAtlasSprite.func_195660_c(field_195673_r[i1] >> 16);
                f2 += TextureAtlasSprite.func_195660_c(field_195673_r[i1] >> 8);
                f3 += TextureAtlasSprite.func_195660_c(field_195673_r[i1] >> 0);
            }
            int i2 = (int)(Math.pow(f /= 4.0f, 0.45454545454545453) * 255.0);
            int j1 = (int)(Math.pow(f1 /= 4.0f, 0.45454545454545453) * 255.0);
            int k1 = (int)(Math.pow(f2 /= 4.0f, 0.45454545454545453) * 255.0);
            int l1 = (int)(Math.pow(f3 /= 4.0f, 0.45454545454545453) * 255.0);
            if (i2 < 96) {
                i2 = 0;
            }
            return i2 << 24 | j1 << 16 | k1 << 8 | l1;
        }
        int i = TextureAtlasSprite.func_195669_a(col0, col1, col2, col3, 24);
        int j = TextureAtlasSprite.func_195669_a(col0, col1, col2, col3, 16);
        int k = TextureAtlasSprite.func_195669_a(col0, col1, col2, col3, 8);
        int l = TextureAtlasSprite.func_195669_a(col0, col1, col2, col3, 0);
        return i << 24 | j << 16 | k << 8 | l;
    }

    private static int func_195669_a(int col0, int col1, int col2, int col3, int bitOffset) {
        float f = TextureAtlasSprite.func_195660_c(col0 >> bitOffset);
        float f1 = TextureAtlasSprite.func_195660_c(col1 >> bitOffset);
        float f2 = TextureAtlasSprite.func_195660_c(col2 >> bitOffset);
        float f3 = TextureAtlasSprite.func_195660_c(col3 >> bitOffset);
        float f4 = (float)((double)((float)Math.pow((double)(f + f1 + f2 + f3) * 0.25, 0.45454545454545453)));
        return (int)((double)f4 * 255.0);
    }

    private static float func_195660_c(int colorIn) {
        return field_195674_s[colorIn & 0xFF];
    }

    private void func_195659_d(int index) {
        int i = 0;
        int j = 0;
        if (this.field_195671_d != null) {
            i = this.field_195671_d[index] * this.field_130223_c;
            j = this.field_195672_e[index] * this.field_130224_d;
        }
        this.func_195667_a(i, j, this.field_195670_c);
    }

    private void func_195667_a(int xOffsetIn, int yOffsetIn, NativeImage[] framesIn) {
        for (int i = 0; i < this.field_195670_c.length && this.field_130223_c >> i > 0 && this.field_130224_d >> i > 0; ++i) {
            framesIn[i].func_195706_a(i, this.field_110975_c >> i, this.field_110974_d >> i, xOffsetIn >> i, yOffsetIn >> i, this.field_130223_c >> i, this.field_130224_d >> i, this.field_195670_c.length > 1);
        }
    }

    public void func_110971_a(int inX, int inY, int originInX, int originInY, boolean rotatedIn) {
        this.field_110975_c = originInX;
        this.field_110974_d = originInY;
        this.field_130222_e = rotatedIn;
        this.field_110979_l = (float)originInX / (float)((double)inX);
        this.field_110980_m = (float)(originInX + this.field_130223_c) / (float)((double)inX);
        this.field_110977_n = (float)originInY / (float)inY;
        this.field_110978_o = (float)(originInY + this.field_130224_d) / (float)inY;
    }

    public int func_94211_a() {
        return this.field_130223_c;
    }

    public int func_94216_b() {
        return this.field_130224_d;
    }

    public float func_94209_e() {
        return this.field_110979_l;
    }

    public float func_94212_f() {
        return this.field_110980_m;
    }

    public float func_94214_a(double u) {
        float f = this.field_110980_m - this.field_110979_l;
        return this.field_110979_l + f * (float)u / 16.0f;
    }

    public float func_188537_a(float u) {
        float f = this.field_110980_m - this.field_110979_l;
        return (u - this.field_110979_l) / f * 16.0f;
    }

    public float func_94206_g() {
        return this.field_110977_n;
    }

    public float func_94210_h() {
        return this.field_110978_o;
    }

    public float func_94207_b(double v) {
        float f = this.field_110978_o - this.field_110977_n;
        return this.field_110977_n + f * (float)v / 16.0f;
    }

    public float func_188536_b(float v) {
        float f = this.field_110978_o - this.field_110977_n;
        return (v - this.field_110977_n) / f * 16.0f;
    }

    public ResourceLocation func_195668_m() {
        return this.field_110984_i;
    }

    public void func_94219_l() {
        ++this.field_110983_h;
        if (this.field_110983_h >= this.field_110982_k.func_110472_a(this.field_110973_g)) {
            int i = this.field_110982_k.func_110468_c(this.field_110973_g);
            int j = this.field_110982_k.func_110473_c() == 0 ? this.func_110970_k() : this.field_110982_k.func_110473_c();
            this.field_110973_g = (this.field_110973_g + 1) % j;
            this.field_110983_h = 0;
            int k = this.field_110982_k.func_110468_c(this.field_110973_g);
            if (i != k && k >= 0 && k < this.func_110970_k()) {
                this.func_195659_d(k);
            }
        } else if (this.field_110982_k.func_177219_e()) {
            this.func_180599_n();
        }
    }

    private void func_180599_n() {
        int j;
        int k;
        double d0 = 1.0 - (double)this.field_110983_h / (double)this.field_110982_k.func_110472_a(this.field_110973_g);
        int i = this.field_110982_k.func_110468_c(this.field_110973_g);
        if (i != (k = this.field_110982_k.func_110468_c((this.field_110973_g + 1) % (j = this.field_110982_k.func_110473_c() == 0 ? this.func_110970_k() : this.field_110982_k.func_110473_c()))) && k >= 0 && k < this.func_110970_k()) {
            if (this.field_176605_b == null || this.field_176605_b.length != this.field_195670_c.length) {
                if (this.field_176605_b != null) {
                    for (NativeImage nativeimage : this.field_176605_b) {
                        if (nativeimage == null) continue;
                        nativeimage.close();
                    }
                }
                this.field_176605_b = new NativeImage[this.field_195670_c.length];
            }
            for (int j2 = 0; j2 < this.field_195670_c.length; ++j2) {
                int k2 = this.field_130223_c >> j2;
                int l2 = this.field_130224_d >> j2;
                if (this.field_176605_b[j2] == null) {
                    this.field_176605_b[j2] = new NativeImage(k2, l2, false);
                }
                for (int i3 = 0; i3 < l2; ++i3) {
                    for (int l = 0; l < k2; ++l) {
                        int i1 = this.func_195665_a(i, j2, l, i3);
                        int j1 = this.func_195665_a(k, j2, l, i3);
                        int k1 = this.func_188535_a(d0, i1 >> 16 & 0xFF, j1 >> 16 & 0xFF);
                        int l1 = this.func_188535_a(d0, i1 >> 8 & 0xFF, j1 >> 8 & 0xFF);
                        int i2 = this.func_188535_a(d0, i1 & 0xFF, j1 & 0xFF);
                        this.field_176605_b[j2].func_195700_a(l, i3, i1 & 0xFF000000 | k1 << 16 | l1 << 8 | i2);
                    }
                }
            }
            this.func_195667_a(0, 0, this.field_176605_b);
        }
    }

    private int func_188535_a(double factor, int to, int from) {
        return (int)(factor * (double)to + (1.0 - factor) * (double)from);
    }

    public int func_110970_k() {
        return this.field_195671_d == null ? 0 : this.field_195671_d.length;
    }

    public void func_195664_a(IResource resource, int count) throws IOException {
        NativeImage nativeimage = NativeImage.func_195713_a((InputStream)resource.func_199027_b());
        this.field_195670_c = new NativeImage[count];
        this.field_195670_c[0] = nativeimage;
        int i = this.field_110982_k != null && this.field_110982_k.func_110474_b() != -1 ? nativeimage.func_195702_a() / this.field_110982_k.func_110474_b() : nativeimage.func_195702_a() / this.field_130223_c;
        int j = this.field_110982_k != null && this.field_110982_k.func_110471_a() != -1 ? nativeimage.func_195714_b() / this.field_110982_k.func_110471_a() : nativeimage.func_195714_b() / this.field_130224_d;
        if (this.field_110982_k != null && this.field_110982_k.func_110473_c() > 0) {
            int k1 = (Integer)this.field_110982_k.func_130073_e().stream().max(Integer::compareTo).get() + 1;
            this.field_195671_d = new int[k1];
            this.field_195672_e = new int[k1];
            Arrays.fill(this.field_195671_d, -1);
            Arrays.fill(this.field_195672_e, -1);
            Iterator iterator = this.field_110982_k.func_130073_e().iterator();
            while (iterator.hasNext()) {
                int k2;
                int i2 = (Integer)iterator.next();
                if (i2 >= i * j) {
                    throw new RuntimeException("invalid frameindex " + i2);
                }
                int j2 = i2 / i;
                this.field_195671_d[i2] = k2 = i2 % i;
                this.field_195672_e[i2] = j2;
            }
        } else {
            ArrayList list = Lists.newArrayList();
            int k = i * j;
            this.field_195671_d = new int[k];
            this.field_195672_e = new int[k];
            for (int l = 0; l < j; ++l) {
                int i1 = 0;
                while (i1 < i) {
                    int j1 = l * i + i1;
                    this.field_195671_d[j1] = i1++;
                    this.field_195672_e[j1] = l;
                    list.add(new AnimationFrame(j1, -1));
                }
            }
            int l1 = 1;
            boolean flag = false;
            if (this.field_110982_k != null) {
                l1 = this.field_110982_k.func_110469_d();
                flag = this.field_110982_k.func_177219_e();
            }
            this.field_110982_k = new AnimationMetadataSection((List)list, this.field_130223_c, this.field_130224_d, l1, flag);
        }
    }

    public void func_147963_d(int level) {
        try {
            this.func_195666_b(level);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Generating mipmaps for frame");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Frame being iterated");
            crashreportcategory.func_189529_a("Frame sizes", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
                StringBuilder stringbuilder = new StringBuilder();
                for (NativeImage nativeimage : this.field_195670_c) {
                    if (stringbuilder.length() > 0) {
                        stringbuilder.append(", ");
                    }
                    stringbuilder.append(nativeimage == null ? "null" : nativeimage.func_195702_a() + "x" + nativeimage.func_195714_b());
                }
                return stringbuilder.toString();
            }));
            throw new ReportedException(crashreport);
        }
    }

    public void func_130103_l() {
        if (this.field_195670_c != null) {
            for (NativeImage nativeimage : this.field_195670_c) {
                if (nativeimage == null) continue;
                nativeimage.close();
            }
        }
        this.field_195670_c = null;
        if (this.field_176605_b != null) {
            for (NativeImage nativeimage1 : this.field_176605_b) {
                if (nativeimage1 == null) continue;
                nativeimage1.close();
            }
        }
        this.field_176605_b = null;
    }

    public boolean func_130098_m() {
        return this.field_110982_k != null && this.field_110982_k.func_110473_c() > 1;
    }

    public String toString() {
        int i = this.field_195671_d == null ? 0 : this.field_195671_d.length;
        return "TextureAtlasSprite{name='" + this.field_110984_i + '\'' + ", frameCount=" + i + ", rotated=" + this.field_130222_e + ", x=" + this.field_110975_c + ", y=" + this.field_110974_d + ", height=" + this.field_130224_d + ", width=" + this.field_130223_c + ", u0=" + this.field_110979_l + ", u1=" + this.field_110980_m + ", v0=" + this.field_110977_n + ", v1=" + this.field_110978_o + '}';
    }

    private int func_195665_a(int frameIndex, int levelIn, int xIn, int yIn) {
        return this.field_195670_c[levelIn].func_195709_a(xIn + (this.field_195671_d[frameIndex] * this.field_130223_c >> levelIn), yIn + (this.field_195672_e[frameIndex] * this.field_130224_d >> levelIn));
    }

    public boolean func_195662_a(int frameIndex, int pixelX, int pixelY) {
        return (this.field_195670_c[0].func_195709_a(pixelX + this.field_195671_d[frameIndex] * this.field_130223_c, pixelY + this.field_195672_e[frameIndex] * this.field_130224_d) >> 24 & 0xFF) == 0;
    }

    public void func_195663_q() {
        this.func_195659_d(0);
    }

    public int getPixelRGBA(int frameIndex, int x, int y) {
        return this.field_195670_c[frameIndex].func_195709_a(x + this.field_195671_d[frameIndex] * this.field_130223_c, y + this.field_195672_e[frameIndex] * this.field_130224_d);
    }
}

