/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BakedQuadRetextured;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimpleBakedModel
implements IBakedModel {
    protected final List<BakedQuad> field_177563_a;
    protected final Map<EnumFacing, List<BakedQuad>> field_177561_b;
    protected final boolean field_177562_c;
    protected final boolean field_177559_d;
    protected final TextureAtlasSprite field_177560_e;
    protected final ItemCameraTransforms field_177558_f;
    protected final ItemOverrideList field_188620_g;

    public SimpleBakedModel(List<BakedQuad> generalQuadsIn, Map<EnumFacing, List<BakedQuad>> faceQuadsIn, boolean ambientOcclusionIn, boolean gui3dIn, TextureAtlasSprite textureIn, ItemCameraTransforms cameraTransformsIn, ItemOverrideList itemOverrideListIn) {
        this.field_177563_a = generalQuadsIn;
        this.field_177561_b = faceQuadsIn;
        this.field_177562_c = ambientOcclusionIn;
        this.field_177559_d = gui3dIn;
        this.field_177560_e = textureIn;
        this.field_177558_f = cameraTransformsIn;
        this.field_188620_g = itemOverrideListIn;
    }

    @Override
    public List<BakedQuad> func_200117_a(@Nullable IBlockState state, @Nullable EnumFacing side, Random rand) {
        return side == null ? this.field_177563_a : this.field_177561_b.get((Object)side);
    }

    @Override
    public boolean func_177555_b() {
        return this.field_177562_c;
    }

    @Override
    public boolean func_177556_c() {
        return this.field_177559_d;
    }

    @Override
    public boolean func_188618_c() {
        return false;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.field_177560_e;
    }

    @Override
    public ItemCameraTransforms func_177552_f() {
        return this.field_177558_f;
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return this.field_188620_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final List<BakedQuad> field_177656_a = Lists.newArrayList();
        private final Map<EnumFacing, List<BakedQuad>> field_177654_b = Maps.newEnumMap(EnumFacing.class);
        private final ItemOverrideList field_188646_c;
        private final boolean field_177655_c;
        private TextureAtlasSprite field_177652_d;
        private final boolean field_177653_e;
        private final ItemCameraTransforms field_177651_f;

        public Builder(ModelBlock model, ItemOverrideList overrides) {
            this(model.func_178309_b(), model.func_178311_c(), model.func_181682_g(), overrides);
        }

        public Builder(IBlockState p_i48189_1_, IBakedModel p_i48189_2_, TextureAtlasSprite p_i48189_3_, Random p_i48189_4_, long p_i48189_5_) {
            this(p_i48189_2_.isAmbientOcclusion(p_i48189_1_), p_i48189_2_.func_177556_c(), p_i48189_2_.func_177552_f(), p_i48189_2_.func_188617_f());
            this.field_177652_d = p_i48189_2_.func_177554_e();
            for (EnumFacing enumfacing : EnumFacing.values()) {
                p_i48189_4_.setSeed(p_i48189_5_);
                for (BakedQuad bakedquad : p_i48189_2_.func_200117_a(p_i48189_1_, enumfacing, p_i48189_4_)) {
                    this.func_177650_a(enumfacing, new BakedQuadRetextured(bakedquad, p_i48189_3_));
                }
            }
            p_i48189_4_.setSeed(p_i48189_5_);
            for (BakedQuad bakedquad1 : p_i48189_2_.func_200117_a(p_i48189_1_, null, p_i48189_4_)) {
                this.func_177648_a(new BakedQuadRetextured(bakedquad1, p_i48189_3_));
            }
        }

        private Builder(boolean ambientOcclusion, boolean gui3d, ItemCameraTransforms transforms, ItemOverrideList overrides) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                this.field_177654_b.put(enumfacing, Lists.newArrayList());
            }
            this.field_188646_c = overrides;
            this.field_177655_c = ambientOcclusion;
            this.field_177653_e = gui3d;
            this.field_177651_f = transforms;
        }

        public Builder func_177650_a(EnumFacing facing, BakedQuad quad) {
            this.field_177654_b.get((Object)facing).add(quad);
            return this;
        }

        public Builder func_177648_a(BakedQuad quad) {
            this.field_177656_a.add(quad);
            return this;
        }

        public Builder func_177646_a(TextureAtlasSprite texture) {
            this.field_177652_d = texture;
            return this;
        }

        public IBakedModel func_177645_b() {
            if (this.field_177652_d == null) {
                throw new RuntimeException("Missing particle!");
            }
            return new SimpleBakedModel(this.field_177656_a, this.field_177654_b, this.field_177655_c, this.field_177653_e, this.field_177652_d, this.field_177651_f, this.field_188646_c);
        }
    }
}

