/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerArrow;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCape;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerDeadmau5Head;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerEntityOnShoulder;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerSpinAttackEffect;
import net.minecraft.client.renderer.entity.model.ModelBase;
import net.minecraft.client.renderer.entity.model.ModelBiped;
import net.minecraft.client.renderer.entity.model.ModelPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class RenderPlayer
extends RenderLivingBase<AbstractClientPlayer> {
    private float field_205127_a;

    public RenderPlayer(RenderManager renderManager) {
        this(renderManager, false);
    }

    public RenderPlayer(RenderManager renderManager, boolean useSmallArms) {
        super(renderManager, (ModelBase)new ModelPlayer(0.0f, useSmallArms), 0.5f);
        this.func_177094_a(new LayerBipedArmor(this));
        this.func_177094_a(new LayerHeldItem(this));
        this.func_177094_a(new LayerArrow((RenderLivingBase)this));
        this.func_177094_a(new LayerDeadmau5Head(this));
        this.func_177094_a(new LayerCape(this));
        this.func_177094_a(new LayerCustomHead(this.func_177087_b().field_78116_c));
        this.func_177094_a(new LayerElytra((RenderLivingBase)this));
        this.func_177094_a(new LayerEntityOnShoulder(renderManager));
        this.func_177094_a(new LayerSpinAttackEffect(this));
    }

    public ModelPlayer func_177087_b() {
        return (ModelPlayer)super.func_177087_b();
    }

    @Override
    public void func_76986_a(AbstractClientPlayer entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderPlayerEvent.Pre((EntityPlayer)entity, this, partialTicks, x, y, z))) {
            return;
        }
        if (!entity.func_175144_cb() || this.field_76990_c.field_78734_h == entity) {
            double d0 = y;
            if (entity.func_70093_af()) {
                d0 = y - 0.125;
            }
            this.func_177137_d(entity);
            GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
            super.func_76986_a(entity, x, d0, z, entityYaw, partialTicks);
            GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderPlayerEvent.Post((EntityPlayer)entity, this, partialTicks, x, y, z));
    }

    private void func_177137_d(AbstractClientPlayer clientPlayer) {
        ModelPlayer modelplayer = this.func_177087_b();
        if (clientPlayer.func_175149_v()) {
            modelplayer.func_178719_a(false);
            modelplayer.field_78116_c.field_78806_j = true;
            modelplayer.field_178720_f.field_78806_j = true;
        } else {
            ItemStack itemstack = clientPlayer.func_184614_ca();
            ItemStack itemstack1 = clientPlayer.func_184592_cb();
            modelplayer.func_178719_a(true);
            modelplayer.field_178720_f.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.HAT);
            modelplayer.field_178730_v.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.JACKET);
            modelplayer.field_178733_c.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.LEFT_PANTS_LEG);
            modelplayer.field_178731_d.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.RIGHT_PANTS_LEG);
            modelplayer.field_178734_a.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.LEFT_SLEEVE);
            modelplayer.field_178732_b.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.RIGHT_SLEEVE);
            modelplayer.field_78117_n = clientPlayer.func_70093_af();
            ModelBiped.ArmPose modelbiped$armpose = this.func_212499_a(clientPlayer, itemstack);
            ModelBiped.ArmPose modelbiped$armpose1 = this.func_212499_a(clientPlayer, itemstack1);
            if (clientPlayer.func_184591_cq() == EnumHandSide.RIGHT) {
                modelplayer.field_187076_m = modelbiped$armpose;
                modelplayer.field_187075_l = modelbiped$armpose1;
            } else {
                modelplayer.field_187076_m = modelbiped$armpose1;
                modelplayer.field_187075_l = modelbiped$armpose;
            }
        }
    }

    public ResourceLocation func_110775_a(AbstractClientPlayer entity) {
        return entity.func_110306_p();
    }

    @Override
    protected void func_77041_b(AbstractClientPlayer entitylivingbaseIn, float partialTickTime) {
        float f = 0.9375f;
        GlStateManager.func_179152_a((float)0.9375f, (float)0.9375f, (float)0.9375f);
    }

    protected void func_188296_a(AbstractClientPlayer entityIn, double x, double y, double z, String name, double distanceSq) {
        Scoreboard scoreboard;
        ScoreObjective scoreobjective;
        if (distanceSq < 100.0 && (scoreobjective = (scoreboard = entityIn.func_96123_co()).func_96539_a(2)) != null) {
            Score score = scoreboard.func_96529_a(entityIn.func_195047_I_(), scoreobjective);
            this.func_147906_a(entityIn, score.func_96652_c() + " " + scoreobjective.func_96678_d().func_150254_d(), x, y, z, 64);
            y += (double)((float)this.func_76983_a().field_78288_b * 1.15f * 0.025f);
        }
        super.func_188296_a((Entity)entityIn, x, y, z, name, distanceSq);
    }

    public void func_177138_b(AbstractClientPlayer clientPlayer) {
        float f = 1.0f;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        float f1 = 0.0625f;
        ModelPlayer modelplayer = this.func_177087_b();
        this.func_177137_d(clientPlayer);
        GlStateManager.func_179147_l();
        modelplayer.field_78095_p = 0.0f;
        modelplayer.field_78117_n = false;
        modelplayer.field_205061_a = 0.0f;
        modelplayer.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)clientPlayer);
        modelplayer.field_178723_h.field_78795_f = 0.0f;
        modelplayer.field_178723_h.func_78785_a(0.0625f);
        modelplayer.field_178732_b.field_78795_f = 0.0f;
        modelplayer.field_178732_b.func_78785_a(0.0625f);
        GlStateManager.func_179084_k();
    }

    public void func_177139_c(AbstractClientPlayer clientPlayer) {
        float f = 1.0f;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        float f1 = 0.0625f;
        ModelPlayer modelplayer = this.func_177087_b();
        this.func_177137_d(clientPlayer);
        GlStateManager.func_179147_l();
        modelplayer.field_78117_n = false;
        modelplayer.field_78095_p = 0.0f;
        modelplayer.field_205061_a = 0.0f;
        modelplayer.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)clientPlayer);
        modelplayer.field_178724_i.field_78795_f = 0.0f;
        modelplayer.field_178724_i.func_78785_a(0.0625f);
        modelplayer.field_178734_a.field_78795_f = 0.0f;
        modelplayer.field_178734_a.func_78785_a(0.0625f);
        GlStateManager.func_179084_k();
    }

    @Override
    protected void func_77039_a(AbstractClientPlayer entityLivingBaseIn, double x, double y, double z) {
        if (entityLivingBaseIn.func_70089_S() && entityLivingBaseIn.func_70608_bn()) {
            super.func_77039_a(entityLivingBaseIn, x + (double)entityLivingBaseIn.field_71079_bU, y + (double)entityLivingBaseIn.field_71082_cx, z + (double)entityLivingBaseIn.field_71089_bV);
        } else {
            super.func_77039_a(entityLivingBaseIn, x, y, z);
        }
    }

    @Override
    protected void func_77043_a(AbstractClientPlayer entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        float f = entityLiving.func_205015_b(partialTicks);
        if (entityLiving.func_70089_S() && entityLiving.func_70608_bn()) {
            GlStateManager.func_179114_b((float)entityLiving.func_71051_bG(), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.func_77037_a(entityLiving), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (entityLiving.func_184613_cA()) {
            super.func_77043_a(entityLiving, ageInTicks, rotationYaw, partialTicks);
            float f1 = (float)entityLiving.func_184599_cB() + partialTicks;
            float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.func_204805_cN()) {
                GlStateManager.func_179114_b((float)(f2 * (-90.0f - entityLiving.field_70125_A)), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            Vec3d vec3d = entityLiving.func_70676_i(partialTicks);
            double d0 = entityLiving.field_70159_w * entityLiving.field_70159_w + entityLiving.field_70179_y * entityLiving.field_70179_y;
            double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (entityLiving.field_70159_w * vec3d.field_72450_a + entityLiving.field_70179_y * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = entityLiving.field_70159_w * vec3d.field_72449_c - entityLiving.field_70179_y * vec3d.field_72450_a;
                GlStateManager.func_179114_b((float)((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        } else if (f > 0.0f) {
            super.func_77043_a(entityLiving, ageInTicks, rotationYaw, partialTicks);
            float f3 = this.func_205126_b(entityLiving.field_70125_A, -90.0f - entityLiving.field_70125_A, f);
            if (!entityLiving.func_203007_ba()) {
                f3 = this.func_77034_a(this.field_205127_a, 0.0f, 1.0f - f);
            }
            GlStateManager.func_179114_b((float)f3, (float)1.0f, (float)0.0f, (float)0.0f);
            if (entityLiving.func_203007_ba()) {
                this.field_205127_a = f3;
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.3f);
            }
        } else {
            super.func_77043_a(entityLiving, ageInTicks, rotationYaw, partialTicks);
        }
    }

    private float func_205126_b(float p_205126_1_, float p_205126_2_, float p_205126_3_) {
        return p_205126_1_ + (p_205126_2_ - p_205126_1_) * p_205126_3_;
    }

    private ModelBiped.ArmPose func_212499_a(AbstractClientPlayer p_212499_1_, ItemStack p_212499_2_) {
        if (p_212499_2_.func_190926_b()) {
            return ModelBiped.ArmPose.EMPTY;
        }
        if (p_212499_1_.func_184605_cv() > 0) {
            EnumAction enumaction = p_212499_2_.func_77975_n();
            if (enumaction == EnumAction.BLOCK) {
                return ModelBiped.ArmPose.BLOCK;
            }
            if (enumaction == EnumAction.BOW) {
                return ModelBiped.ArmPose.BOW_AND_ARROW;
            }
            if (enumaction == EnumAction.SPEAR) {
                return ModelBiped.ArmPose.THROW_SPEAR;
            }
        }
        return ModelBiped.ArmPose.ITEM;
    }
}

