/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAbstractSkull;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSign;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ChunkRenderContainer;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderList;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VboRenderList;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.IRenderChunkFactory;
import net.minecraft.client.renderer.chunk.ListedRenderChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBoneMeal;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.CloudRenderer;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class WorldRenderer
implements IWorldEventListener,
AutoCloseable,
IResourceManagerReloadListener {
    private static final Logger field_147599_m = LogManager.getLogger();
    private static final ResourceLocation field_110927_h = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation field_110928_i = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation field_110925_j = new ResourceLocation("textures/environment/clouds.png");
    private static final ResourceLocation field_110926_k = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation field_175006_g = new ResourceLocation("textures/misc/forcefield.png");
    public static final EnumFacing[] field_200006_a = EnumFacing.values();
    private final Minecraft field_72777_q;
    private final TextureManager field_72770_i;
    private final RenderManager field_175010_j;
    private WorldClient field_72769_h;
    private Set<RenderChunk> field_175009_l = Sets.newLinkedHashSet();
    private List<ContainerLocalRenderInformation> field_72755_R = Lists.newArrayListWithCapacity((int)69696);
    private final Set<TileEntity> field_181024_n = Sets.newHashSet();
    private ViewFrustum field_175008_n;
    private int field_72772_v = -1;
    private int field_72771_w = -1;
    private int field_72781_x = -1;
    private final VertexFormat field_175014_r;
    private VertexBuffer field_175013_s;
    private VertexBuffer field_175012_t;
    private VertexBuffer field_175011_u;
    private final int field_204606_x = 28;
    private boolean field_204607_y = true;
    private int field_204608_z = -1;
    private VertexBuffer field_204601_A;
    private int field_72773_u;
    private final Map<Integer, DestroyBlockProgress> field_72738_E = Maps.newHashMap();
    private final Map<BlockPos, ISound> field_147593_P = Maps.newHashMap();
    private final TextureAtlasSprite[] field_94141_F = new TextureAtlasSprite[10];
    private Framebuffer field_175015_z;
    private ShaderGroup field_174991_A;
    private double field_174992_B = Double.MIN_VALUE;
    private double field_174993_C = Double.MIN_VALUE;
    private double field_174987_D = Double.MIN_VALUE;
    private int field_174988_E = Integer.MIN_VALUE;
    private int field_174989_F = Integer.MIN_VALUE;
    private int field_174990_G = Integer.MIN_VALUE;
    private double field_174997_H = Double.MIN_VALUE;
    private double field_174998_I = Double.MIN_VALUE;
    private double field_174999_J = Double.MIN_VALUE;
    private double field_175000_K = Double.MIN_VALUE;
    private double field_174994_L = Double.MIN_VALUE;
    private int field_204602_S = Integer.MIN_VALUE;
    private int field_204603_T = Integer.MIN_VALUE;
    private int field_204604_U = Integer.MIN_VALUE;
    private Vec3d field_204605_V = Vec3d.field_186680_a;
    private int field_204800_W = -1;
    private ChunkRenderDispatcher field_174995_M;
    private ChunkRenderContainer field_174996_N;
    private int field_72739_F = -1;
    private int field_72740_G = 2;
    private int field_72748_H;
    private int field_72749_I;
    private int field_72750_J;
    private boolean field_175002_T;
    private ClippingHelper field_175001_U;
    private final Vector4f[] field_175004_V = new Vector4f[8];
    private final Vector3d field_175003_W = new Vector3d();
    private boolean field_175005_X;
    private IRenderChunkFactory field_175007_a;
    private double field_147596_f;
    private double field_147597_g;
    private double field_147602_h;
    private boolean field_147595_R = true;
    private boolean field_184386_ad;
    private final Set<BlockPos> field_184387_ae = Sets.newHashSet();

    public WorldRenderer(Minecraft mcIn) {
        this.field_72777_q = mcIn;
        this.field_175010_j = mcIn.func_175598_ae();
        this.field_72770_i = mcIn.func_110434_K();
        this.field_72770_i.func_110577_a(field_175006_g);
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_179144_i((int)0);
        this.func_174971_n();
        this.field_175005_X = OpenGlHelper.func_176075_f();
        if (this.field_175005_X) {
            this.field_174996_N = new VboRenderList();
            this.field_175007_a = RenderChunk::new;
        } else {
            this.field_174996_N = new RenderList();
            this.field_175007_a = ListedRenderChunk::new;
        }
        this.field_175014_r = new VertexFormat();
        this.field_175014_r.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.POSITION, 3));
        this.func_174963_q();
        this.func_174980_p();
        this.func_174964_o();
    }

    @Override
    public void close() {
        if (this.field_174991_A != null) {
            this.field_174991_A.close();
        }
    }

    @Override
    public void func_195410_a(IResourceManager resourceManager) {
        this.func_174971_n();
    }

    private void func_174971_n() {
        TextureMap texturemap = this.field_72777_q.func_147117_R();
        this.field_94141_F[0] = texturemap.func_195424_a(ModelBakery.field_207770_h);
        this.field_94141_F[1] = texturemap.func_195424_a(ModelBakery.field_207771_i);
        this.field_94141_F[2] = texturemap.func_195424_a(ModelBakery.field_207772_j);
        this.field_94141_F[3] = texturemap.func_195424_a(ModelBakery.field_207773_k);
        this.field_94141_F[4] = texturemap.func_195424_a(ModelBakery.field_207774_l);
        this.field_94141_F[5] = texturemap.func_195424_a(ModelBakery.field_207775_m);
        this.field_94141_F[6] = texturemap.func_195424_a(ModelBakery.field_207776_n);
        this.field_94141_F[7] = texturemap.func_195424_a(ModelBakery.field_207777_o);
        this.field_94141_F[8] = texturemap.func_195424_a(ModelBakery.field_207778_p);
        this.field_94141_F[9] = texturemap.func_195424_a(ModelBakery.field_207779_q);
    }

    public void func_174966_b() {
        if (OpenGlHelper.field_148824_g) {
            if (ShaderLinkHelper.func_148074_b() == null) {
                ShaderLinkHelper.func_148076_a();
            }
            ResourceLocation resourcelocation = new ResourceLocation("shaders/post/entity_outline.json");
            try {
                this.field_174991_A = new ShaderGroup(this.field_72777_q.func_110434_K(), this.field_72777_q.func_195551_G(), this.field_72777_q.func_147110_a(), resourcelocation);
                this.field_174991_A.func_148026_a(this.field_72777_q.field_195558_d.func_198109_k(), this.field_72777_q.field_195558_d.func_198091_l());
                this.field_175015_z = this.field_174991_A.func_177066_a("final");
            }
            catch (IOException ioexception) {
                field_147599_m.warn("Failed to load shader: {}", (Object)resourcelocation, (Object)ioexception);
                this.field_174991_A = null;
                this.field_175015_z = null;
            }
            catch (JsonSyntaxException jsonsyntaxexception) {
                field_147599_m.warn("Failed to load shader: {}", (Object)resourcelocation, (Object)jsonsyntaxexception);
                this.field_174991_A = null;
                this.field_175015_z = null;
            }
        } else {
            this.field_174991_A = null;
            this.field_175015_z = null;
        }
    }

    public void func_174975_c() {
        if (this.func_174985_d()) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            this.field_175015_z.func_178038_a(this.field_72777_q.field_195558_d.func_198109_k(), this.field_72777_q.field_195558_d.func_198091_l(), false);
            GlStateManager.func_179084_k();
        }
    }

    protected boolean func_174985_d() {
        return this.field_175015_z != null && this.field_174991_A != null && this.field_72777_q.field_71439_g != null;
    }

    private void func_174964_o() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.field_175011_u != null) {
            this.field_175011_u.func_177362_c();
        }
        if (this.field_72781_x >= 0) {
            GLAllocation.func_74523_b((int)this.field_72781_x);
            this.field_72781_x = -1;
        }
        if (this.field_175005_X) {
            this.field_175011_u = new VertexBuffer(this.field_175014_r);
            this.func_174968_a(bufferbuilder, -16.0f, true);
            bufferbuilder.func_178977_d();
            bufferbuilder.func_178965_a();
            this.field_175011_u.func_181722_a(bufferbuilder.func_178966_f());
        } else {
            this.field_72781_x = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.field_72781_x, (int)4864);
            this.func_174968_a(bufferbuilder, -16.0f, true);
            tessellator.func_78381_a();
            GlStateManager.func_187415_K();
        }
    }

    private void func_174980_p() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.field_175012_t != null) {
            this.field_175012_t.func_177362_c();
        }
        if (this.field_72771_w >= 0) {
            GLAllocation.func_74523_b((int)this.field_72771_w);
            this.field_72771_w = -1;
        }
        if (this.field_175005_X) {
            this.field_175012_t = new VertexBuffer(this.field_175014_r);
            this.func_174968_a(bufferbuilder, 16.0f, false);
            bufferbuilder.func_178977_d();
            bufferbuilder.func_178965_a();
            this.field_175012_t.func_181722_a(bufferbuilder.func_178966_f());
        } else {
            this.field_72771_w = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.field_72771_w, (int)4864);
            this.func_174968_a(bufferbuilder, 16.0f, false);
            tessellator.func_78381_a();
            GlStateManager.func_187415_K();
        }
    }

    private void func_174968_a(BufferBuilder bufferBuilderIn, float posY, boolean reverseX) {
        int i = 64;
        int j = 6;
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float f = k;
                float f1 = k + 64;
                if (reverseX) {
                    f1 = k;
                    f = k + 64;
                }
                bufferBuilderIn.func_181662_b(f, posY, l).func_181675_d();
                bufferBuilderIn.func_181662_b(f1, posY, l).func_181675_d();
                bufferBuilderIn.func_181662_b(f1, posY, l + 64).func_181675_d();
                bufferBuilderIn.func_181662_b(f, posY, l + 64).func_181675_d();
            }
        }
    }

    private void func_174963_q() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.field_175013_s != null) {
            this.field_175013_s.func_177362_c();
        }
        if (this.field_72772_v >= 0) {
            GLAllocation.func_74523_b((int)this.field_72772_v);
            this.field_72772_v = -1;
        }
        if (this.field_175005_X) {
            this.field_175013_s = new VertexBuffer(this.field_175014_r);
            this.func_180444_a(bufferbuilder);
            bufferbuilder.func_178977_d();
            bufferbuilder.func_178965_a();
            this.field_175013_s.func_181722_a(bufferbuilder.func_178966_f());
        } else {
            this.field_72772_v = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_179094_E();
            GlStateManager.func_187423_f((int)this.field_72772_v, (int)4864);
            this.func_180444_a(bufferbuilder);
            tessellator.func_78381_a();
            GlStateManager.func_187415_K();
            GlStateManager.func_179121_F();
        }
    }

    private void func_180444_a(BufferBuilder bufferBuilderIn) {
        Random random = new Random(10842L);
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = 0.0;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferBuilderIn.func_181662_b(d5 + d25, d6 + d23, d7 + d26).func_181675_d();
            }
        }
    }

    public void func_72732_a(@Nullable WorldClient worldClientIn) {
        if (this.field_72769_h != null) {
            this.field_72769_h.func_72848_b(this);
        }
        this.field_174992_B = Double.MIN_VALUE;
        this.field_174993_C = Double.MIN_VALUE;
        this.field_174987_D = Double.MIN_VALUE;
        this.field_174988_E = Integer.MIN_VALUE;
        this.field_174989_F = Integer.MIN_VALUE;
        this.field_174990_G = Integer.MIN_VALUE;
        this.field_175010_j.func_78717_a(worldClientIn);
        this.field_72769_h = worldClientIn;
        if (worldClientIn != null) {
            worldClientIn.func_72954_a(this);
            this.func_72712_a();
        } else {
            this.field_175009_l.clear();
            this.field_72755_R.clear();
            if (this.field_175008_n != null) {
                this.field_175008_n.func_178160_a();
                this.field_175008_n = null;
            }
            if (this.field_174995_M != null) {
                this.field_174995_M.func_188244_g();
            }
            this.field_174995_M = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_72712_a() {
        if (this.field_72769_h != null) {
            Entity entity;
            if (this.field_174995_M == null) {
                this.field_174995_M = new ChunkRenderDispatcher();
            }
            this.field_147595_R = true;
            this.field_204607_y = true;
            BlockLeaves.func_196475_b(this.field_72777_q.field_71474_y.field_74347_j);
            this.field_72739_F = this.field_72777_q.field_71474_y.field_151451_c;
            boolean flag = this.field_175005_X;
            this.field_175005_X = OpenGlHelper.func_176075_f();
            if (flag && !this.field_175005_X) {
                this.field_174996_N = new RenderList();
                this.field_175007_a = ListedRenderChunk::new;
            } else if (!flag && this.field_175005_X) {
                this.field_174996_N = new VboRenderList();
                this.field_175007_a = RenderChunk::new;
            }
            if (flag != this.field_175005_X) {
                this.func_174963_q();
                this.func_174980_p();
                this.func_174964_o();
            }
            if (this.field_175008_n != null) {
                this.field_175008_n.func_178160_a();
            }
            this.func_174986_e();
            Set<TileEntity> set = this.field_181024_n;
            synchronized (set) {
                this.field_181024_n.clear();
            }
            this.field_175008_n = new ViewFrustum((World)this.field_72769_h, this.field_72777_q.field_71474_y.field_151451_c, this, this.field_175007_a);
            if (this.field_72769_h != null && (entity = this.field_72777_q.func_175606_aa()) != null) {
                this.field_175008_n.func_178163_a(entity.field_70165_t, entity.field_70161_v);
            }
            this.field_72740_G = 2;
        }
    }

    protected void func_174986_e() {
        this.field_175009_l.clear();
        this.field_174995_M.func_178514_b();
    }

    public void func_72720_a(int width, int height) {
        this.func_174979_m();
        if (OpenGlHelper.field_148824_g && this.field_174991_A != null) {
            this.field_174991_A.func_148026_a(width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_180446_a(Entity renderViewEntity, ICamera camera, float partialTicks) {
        int pass = MinecraftForgeClient.getRenderPass();
        if (this.field_72740_G > 0) {
            if (pass > 0) {
                return;
            }
            --this.field_72740_G;
        } else {
            double d0 = renderViewEntity.field_70169_q + (renderViewEntity.field_70165_t - renderViewEntity.field_70169_q) * (double)partialTicks;
            double d1 = renderViewEntity.field_70167_r + (renderViewEntity.field_70163_u - renderViewEntity.field_70167_r) * (double)partialTicks;
            double d2 = renderViewEntity.field_70166_s + (renderViewEntity.field_70161_v - renderViewEntity.field_70166_s) * (double)partialTicks;
            this.field_72769_h.field_72984_F.func_76320_a("prepare");
            TileEntityRendererDispatcher.field_147556_a.func_190056_a(this.field_72769_h, this.field_72777_q.func_110434_K(), this.field_72777_q.field_71466_p, this.field_72777_q.func_175606_aa(), this.field_72777_q.field_71476_x, partialTicks);
            this.field_175010_j.func_180597_a(this.field_72769_h, this.field_72777_q.field_71466_p, this.field_72777_q.func_175606_aa(), this.field_72777_q.field_147125_j, this.field_72777_q.field_71474_y, partialTicks);
            if (pass == 0) {
                this.field_72748_H = 0;
                this.field_72749_I = 0;
                this.field_72750_J = 0;
            }
            Entity entity = this.field_72777_q.func_175606_aa();
            double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            TileEntityRendererDispatcher.field_147554_b = d3;
            TileEntityRendererDispatcher.field_147555_c = d4;
            TileEntityRendererDispatcher.field_147552_d = d5;
            this.field_175010_j.func_178628_a(d3, d4, d5);
            this.field_72777_q.field_71460_t.func_180436_i();
            this.field_72769_h.field_72984_F.func_76318_c("global");
            if (pass == 0) {
                this.field_72748_H = this.field_72769_h.func_212419_R();
            }
            for (int i = 0; i < this.field_72769_h.field_73007_j.size(); ++i) {
                Entity entity1 = (Entity)((Object)this.field_72769_h.field_73007_j.get(i));
                if (!entity1.shouldRenderInPass(pass)) continue;
                ++this.field_72749_I;
                if (!entity1.func_145770_h(d0, d1, d2)) continue;
                this.field_175010_j.func_188388_a(entity1, partialTicks, false);
            }
            this.field_72769_h.field_72984_F.func_76318_c("entities");
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            Throwable throwable = null;
            try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
                for (ContainerLocalRenderInformation containerLocalRenderInformation : this.field_72755_R) {
                    Chunk chunk = this.field_72769_h.func_175726_f(containerLocalRenderInformation.field_178036_a.func_178568_j());
                    ClassInheritanceMultiMap<Entity> classinheritancemultimap = chunk.func_177429_s()[containerLocalRenderInformation.field_178036_a.func_178568_j().func_177956_o() / 16];
                    if (classinheritancemultimap.isEmpty()) continue;
                    for (Entity entity2 : classinheritancemultimap) {
                        boolean flag1;
                        boolean flag;
                        if (!entity2.shouldRenderInPass(pass) || !(flag = this.field_175010_j.func_178635_a(entity2, camera, d0, d1, d2) || entity2.func_184215_y(this.field_72777_q.field_71439_g))) continue;
                        boolean bl = flag1 = this.field_72777_q.func_175606_aa() instanceof EntityLivingBase && ((EntityLivingBase)this.field_72777_q.func_175606_aa()).func_70608_bn();
                        if (entity2 == this.field_72777_q.func_175606_aa() && this.field_72777_q.field_71474_y.field_74320_O == 0 && !flag1 || entity2.field_70163_u >= 0.0 && entity2.field_70163_u < 256.0 && !this.field_72769_h.func_175667_e((BlockPos)blockpos$pooledmutableblockpos.func_189535_a(entity2))) continue;
                        ++this.field_72749_I;
                        this.field_175010_j.func_188388_a(entity2, partialTicks, false);
                        if (this.func_184383_a(entity2, entity, camera)) {
                            list.add(entity2);
                        }
                        if (!this.field_175010_j.func_188390_b(entity2)) continue;
                        list1.add(entity2);
                    }
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            if (!list1.isEmpty()) {
                for (Entity entity2 : list1) {
                    this.field_175010_j.func_188389_a(entity2, partialTicks);
                }
            }
            if (pass == 0 && this.func_174985_d() && (!list.isEmpty() || this.field_184386_ad)) {
                this.field_72769_h.field_72984_F.func_76318_c("entityOutlines");
                this.field_175015_z.func_147614_f();
                boolean bl = this.field_184386_ad = !list.isEmpty();
                if (!list.isEmpty()) {
                    GlStateManager.func_179143_c((int)519);
                    GlStateManager.func_179106_n();
                    this.field_175015_z.func_147610_a(false);
                    RenderHelper.func_74518_a();
                    this.field_175010_j.func_178632_c(true);
                    for (int j = 0; j < list.size(); ++j) {
                        this.field_175010_j.func_188388_a((Entity)((Object)list.get(j)), partialTicks, false);
                    }
                    this.field_175010_j.func_178632_c(false);
                    RenderHelper.func_74519_b();
                    GlStateManager.func_179132_a((boolean)false);
                    this.field_174991_A.func_148018_a(partialTicks);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179127_m();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179142_g();
                    GlStateManager.func_179143_c((int)515);
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179141_d();
                }
                this.field_72777_q.func_147110_a().func_147610_a(false);
            }
            this.field_72769_h.field_72984_F.func_76318_c("blockentities");
            RenderHelper.func_74519_b();
            TileEntityRendererDispatcher.field_147556_a.preDrawBatch();
            for (ContainerLocalRenderInformation containerLocalRenderInformation : this.field_72755_R) {
                List list2 = containerLocalRenderInformation.field_178036_a.func_178571_g().func_178485_b();
                if (list2.isEmpty()) continue;
                for (TileEntity tileentity1 : list2) {
                    if (!tileentity1.shouldRenderInPass(pass) || !camera.func_78546_a(tileentity1.getRenderBoundingBox())) continue;
                    TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileentity1, partialTicks, -1);
                }
            }
            Iterator<DestroyBlockProgress> iterator = this.field_181024_n;
            synchronized (iterator) {
                for (TileEntity tileentity : this.field_181024_n) {
                    if (!tileentity.shouldRenderInPass(pass) || !camera.func_78546_a(tileentity.getRenderBoundingBox())) continue;
                    TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileentity, partialTicks, -1);
                }
            }
            TileEntityRendererDispatcher.field_147556_a.drawBatch(pass);
            this.func_180443_s();
            for (DestroyBlockProgress destroyBlockProgress : this.field_72738_E.values()) {
                BlockPos blockpos = destroyBlockProgress.func_180246_b();
                IBlockState iBlockState = this.field_72769_h.func_180495_p(blockpos);
                if (!iBlockState.hasTileEntity()) continue;
                TileEntity tileentity2 = this.field_72769_h.func_175625_s(blockpos);
                if (tileentity2 instanceof TileEntityChest && iBlockState.func_177229_b((IProperty)BlockChest.field_196314_b) == ChestType.LEFT) {
                    blockpos = blockpos.func_177972_a(((EnumFacing)((Object)iBlockState.func_177229_b((IProperty)BlockChest.field_176459_a))).func_176746_e());
                    tileentity2 = this.field_72769_h.func_175625_s(blockpos);
                }
                if (tileentity2 == null || !iBlockState.func_191057_i()) continue;
                TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileentity2, partialTicks, destroyBlockProgress.func_73106_e());
            }
            this.func_174969_t();
            this.field_72777_q.field_71460_t.func_175072_h();
            this.field_72777_q.field_71424_I.func_76319_b();
        }
    }

    private boolean func_184383_a(Entity entityIn, Entity viewer, ICamera camera) {
        boolean flag;
        boolean bl = flag = viewer instanceof EntityLivingBase && ((EntityLivingBase)viewer).func_70608_bn();
        if (entityIn == viewer && this.field_72777_q.field_71474_y.field_74320_O == 0 && !flag) {
            return false;
        }
        if (entityIn.func_184202_aL()) {
            return true;
        }
        if (this.field_72777_q.field_71439_g.func_175149_v() && this.field_72777_q.field_71474_y.field_178883_an.func_151470_d() && entityIn instanceof EntityPlayer) {
            return entityIn.field_70158_ak || camera.func_78546_a(entityIn.func_174813_aQ()) || entityIn.func_184215_y(this.field_72777_q.field_71439_g);
        }
        return false;
    }

    public String func_72735_c() {
        int i = this.field_175008_n.field_178164_f.length;
        int j = this.func_184382_g();
        return String.format("C: %d/%d %sD: %d, L: %d, %s", j, i, this.field_72777_q.field_175612_E ? "(s) " : "", this.field_72739_F, this.field_184387_ae.size(), this.field_174995_M == null ? "null" : this.field_174995_M.func_178504_a());
    }

    protected int func_184382_g() {
        int i = 0;
        for (ContainerLocalRenderInformation worldrenderer$containerlocalrenderinformation : this.field_72755_R) {
            CompiledChunk compiledchunk = ((ContainerLocalRenderInformation)worldrenderer$containerlocalrenderinformation).field_178036_a.field_178590_b;
            if (compiledchunk == CompiledChunk.field_178502_a || compiledchunk.func_178489_a()) continue;
            ++i;
        }
        return i;
    }

    public String func_72723_d() {
        return "E: " + this.field_72749_I + "/" + this.field_72748_H + ", B: " + this.field_72750_J;
    }

    public void func_195473_a(Entity entityIn, float partialTicks, ICamera camera, int frameCount, boolean playerSpectator) {
        if (this.field_72777_q.field_71474_y.field_151451_c != this.field_72739_F) {
            this.func_72712_a();
        }
        this.field_72769_h.field_72984_F.func_76320_a("camera");
        double d0 = entityIn.field_70165_t - this.field_174992_B;
        double d1 = entityIn.field_70163_u - this.field_174993_C;
        double d2 = entityIn.field_70161_v - this.field_174987_D;
        if (this.field_174988_E != entityIn.field_70176_ah || this.field_174989_F != entityIn.field_70162_ai || this.field_174990_G != entityIn.field_70164_aj || d0 * d0 + d1 * d1 + d2 * d2 > 16.0) {
            this.field_174992_B = entityIn.field_70165_t;
            this.field_174993_C = entityIn.field_70163_u;
            this.field_174987_D = entityIn.field_70161_v;
            this.field_174988_E = entityIn.field_70176_ah;
            this.field_174989_F = entityIn.field_70162_ai;
            this.field_174990_G = entityIn.field_70164_aj;
            this.field_175008_n.func_178163_a(entityIn.field_70165_t, entityIn.field_70161_v);
        }
        this.field_72769_h.field_72984_F.func_76318_c("renderlistcamera");
        double d3 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d4 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d5 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        this.field_174996_N.func_178004_a(d3, d4, d5);
        this.field_72769_h.field_72984_F.func_76318_c("cull");
        if (this.field_175001_U != null) {
            Frustum frustum = new Frustum(this.field_175001_U);
            frustum.func_78547_a(this.field_175003_W.field_181059_a, this.field_175003_W.field_181060_b, this.field_175003_W.field_181061_c);
            camera = frustum;
        }
        this.field_72777_q.field_71424_I.func_76318_c("culling");
        BlockPos blockpos1 = new BlockPos(d3, d4 + (double)entityIn.func_70047_e(), d5);
        RenderChunk renderchunk = this.field_175008_n.func_178161_a(blockpos1);
        BlockPos blockpos = new BlockPos(MathHelper.func_76128_c((double)(d3 / 16.0)) * 16, MathHelper.func_76128_c((double)(d4 / 16.0)) * 16, MathHelper.func_76128_c((double)(d5 / 16.0)) * 16);
        float f = entityIn.func_195050_f(partialTicks);
        float f1 = entityIn.func_195046_g(partialTicks);
        this.field_147595_R = this.field_147595_R || !this.field_175009_l.isEmpty() || entityIn.field_70165_t != this.field_174997_H || entityIn.field_70163_u != this.field_174998_I || entityIn.field_70161_v != this.field_174999_J || (double)f != this.field_175000_K || (double)f1 != this.field_174994_L;
        this.field_174997_H = entityIn.field_70165_t;
        this.field_174998_I = entityIn.field_70163_u;
        this.field_174999_J = entityIn.field_70161_v;
        this.field_175000_K = f;
        this.field_174994_L = f1;
        boolean flag = this.field_175001_U != null;
        this.field_72777_q.field_71424_I.func_76318_c("update");
        if (!flag && this.field_147595_R) {
            this.field_147595_R = false;
            this.field_72755_R = Lists.newArrayList();
            ArrayDeque queue = Queues.newArrayDeque();
            Entity.func_184227_b(MathHelper.func_151237_a((double)((double)this.field_72777_q.field_71474_y.field_151451_c / 8.0), (double)1.0, (double)2.5));
            boolean flag1 = this.field_72777_q.field_175612_E;
            if (renderchunk != null) {
                boolean flag2 = false;
                ContainerLocalRenderInformation worldrenderer$containerlocalrenderinformation3 = new ContainerLocalRenderInformation(renderchunk, null, 0);
                Set<EnumFacing> set1 = this.func_174978_c(blockpos1);
                if (set1.size() == 1) {
                    Vector3f vector3f = this.func_195474_a(entityIn, partialTicks);
                    EnumFacing enumfacing = EnumFacing.func_176737_a(vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c()).func_176734_d();
                    set1.remove((Object)enumfacing);
                }
                if (set1.isEmpty()) {
                    flag2 = true;
                }
                if (flag2 && !playerSpectator) {
                    this.field_72755_R.add(worldrenderer$containerlocalrenderinformation3);
                } else {
                    if (playerSpectator && this.field_72769_h.func_180495_p(blockpos1).func_200015_d((IBlockReader)this.field_72769_h, blockpos1)) {
                        flag1 = false;
                    }
                    renderchunk.func_178577_a(frameCount);
                    queue.add(worldrenderer$containerlocalrenderinformation3);
                }
            } else {
                int i = blockpos1.func_177956_o() > 0 ? 248 : 8;
                for (int j = -this.field_72739_F; j <= this.field_72739_F; ++j) {
                    for (int k = -this.field_72739_F; k <= this.field_72739_F; ++k) {
                        RenderChunk renderchunk1 = this.field_175008_n.func_178161_a(new BlockPos((j << 4) + 8, i, (k << 4) + 8));
                        if (renderchunk1 == null || !camera.func_78546_a(renderchunk1.field_178591_c.func_72321_a(0.0, blockpos1.func_177956_o() > 0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY, 0.0))) continue;
                        renderchunk1.func_178577_a(frameCount);
                        queue.add(new ContainerLocalRenderInformation(renderchunk1, null, 0));
                    }
                }
            }
            this.field_72777_q.field_71424_I.func_76320_a("iteration");
            while (!queue.isEmpty()) {
                ContainerLocalRenderInformation worldrenderer$containerlocalrenderinformation1 = (ContainerLocalRenderInformation)queue.poll();
                RenderChunk renderchunk3 = worldrenderer$containerlocalrenderinformation1.field_178036_a;
                EnumFacing enumfacing2 = worldrenderer$containerlocalrenderinformation1.field_178034_b;
                this.field_72755_R.add(worldrenderer$containerlocalrenderinformation1);
                for (EnumFacing enumfacing1 : field_200006_a) {
                    RenderChunk renderchunk2 = this.func_181562_a(blockpos, renderchunk3, enumfacing1);
                    if (flag1 && worldrenderer$containerlocalrenderinformation1.func_189560_a(enumfacing1.func_176734_d()) || flag1 && enumfacing2 != null && !renderchunk3.func_178571_g().func_178495_a(enumfacing2.func_176734_d(), enumfacing1) || renderchunk2 == null || !renderchunk2.func_178577_a(frameCount) || !camera.func_78546_a(renderchunk2.field_178591_c)) continue;
                    ContainerLocalRenderInformation worldrenderer$containerlocalrenderinformation = new ContainerLocalRenderInformation(renderchunk2, enumfacing1, worldrenderer$containerlocalrenderinformation1.field_178032_d + 1);
                    worldrenderer$containerlocalrenderinformation.func_189561_a(worldrenderer$containerlocalrenderinformation1.field_178035_c, enumfacing1);
                    queue.add(worldrenderer$containerlocalrenderinformation);
                }
            }
            this.field_72777_q.field_71424_I.func_76319_b();
        }
        this.field_72777_q.field_71424_I.func_76318_c("captureFrustum");
        if (this.field_175002_T) {
            this.func_174984_a(d3, d4, d5);
            this.field_175002_T = false;
        }
        this.field_72777_q.field_71424_I.func_76318_c("rebuildNear");
        Set<RenderChunk> set = this.field_175009_l;
        this.field_175009_l = Sets.newLinkedHashSet();
        for (ContainerLocalRenderInformation worldrenderer$containerlocalrenderinformation2 : this.field_72755_R) {
            boolean flag3;
            RenderChunk renderchunk4 = worldrenderer$containerlocalrenderinformation2.field_178036_a;
            if (!renderchunk4.func_178569_m() && !set.contains(renderchunk4)) continue;
            this.field_147595_R = true;
            BlockPos blockpos2 = renderchunk4.func_178568_j().func_177982_a(8, 8, 8);
            boolean bl = flag3 = blockpos2.func_177951_i((Vec3i)blockpos1) < 768.0;
            if (ForgeMod.alwaysSetupTerrainOffThread || !renderchunk4.func_188281_o() && !flag3) {
                this.field_175009_l.add(renderchunk4);
                continue;
            }
            this.field_72777_q.field_71424_I.func_76320_a("build near");
            this.field_174995_M.func_178505_b(renderchunk4);
            renderchunk4.func_188282_m();
            this.field_72777_q.field_71424_I.func_76319_b();
        }
        this.field_175009_l.addAll(set);
        this.field_72777_q.field_71424_I.func_76319_b();
    }

    private Set<EnumFacing> func_174978_c(BlockPos pos) {
        VisGraph visgraph = new VisGraph();
        BlockPos blockpos = new BlockPos(pos.func_177958_n() >> 4 << 4, pos.func_177956_o() >> 4 << 4, pos.func_177952_p() >> 4 << 4);
        Chunk chunk = this.field_72769_h.func_175726_f(blockpos);
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)blockpos, (BlockPos)blockpos.func_177982_a(15, 15, 15))) {
            if (!chunk.func_180495_p((BlockPos)blockpos$mutableblockpos).func_200015_d((IBlockReader)this.field_72769_h, (BlockPos)blockpos$mutableblockpos)) continue;
            visgraph.func_178606_a((BlockPos)blockpos$mutableblockpos);
        }
        return visgraph.func_178609_b(pos);
    }

    @Nullable
    private RenderChunk func_181562_a(BlockPos playerPos, RenderChunk renderChunkBase, EnumFacing facing) {
        BlockPos blockpos = renderChunkBase.func_181701_a(facing);
        if (MathHelper.func_76130_a((int)(playerPos.func_177958_n() - blockpos.func_177958_n())) > this.field_72739_F * 16) {
            return null;
        }
        if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256) {
            return MathHelper.func_76130_a((int)(playerPos.func_177952_p() - blockpos.func_177952_p())) > this.field_72739_F * 16 ? null : this.field_175008_n.func_178161_a(blockpos);
        }
        return null;
    }

    private void func_174984_a(double x, double y, double z) {
    }

    protected Vector3f func_195474_a(Entity entityIn, double partialTicks) {
        float f = (float)((double)entityIn.field_70127_C + (double)(entityIn.field_70125_A - entityIn.field_70127_C) * partialTicks);
        float f1 = (float)((double)entityIn.field_70126_B + (double)(entityIn.field_70177_z - entityIn.field_70126_B) * partialTicks);
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2) {
            f += 180.0f;
        }
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        return new Vector3f(f3 * f4, f5, f2 * f4);
    }

    public int func_195464_a(BlockRenderLayer blockLayerIn, double partialTicks, Entity entityIn) {
        RenderHelper.func_74518_a();
        if (blockLayerIn == BlockRenderLayer.TRANSLUCENT) {
            this.field_72777_q.field_71424_I.func_76320_a("translucent_sort");
            double d0 = entityIn.field_70165_t - this.field_147596_f;
            double d1 = entityIn.field_70163_u - this.field_147597_g;
            double d2 = entityIn.field_70161_v - this.field_147602_h;
            if (d0 * d0 + d1 * d1 + d2 * d2 > 1.0) {
                this.field_147596_f = entityIn.field_70165_t;
                this.field_147597_g = entityIn.field_70163_u;
                this.field_147602_h = entityIn.field_70161_v;
                int k = 0;
                for (ContainerLocalRenderInformation worldrenderer$containerlocalrenderinformation : this.field_72755_R) {
                    if (!((ContainerLocalRenderInformation)worldrenderer$containerlocalrenderinformation).field_178036_a.field_178590_b.func_178492_d(blockLayerIn) || k++ >= 15) continue;
                    this.field_174995_M.func_178509_c(worldrenderer$containerlocalrenderinformation.field_178036_a);
                }
            }
            this.field_72777_q.field_71424_I.func_76319_b();
        }
        this.field_72777_q.field_71424_I.func_76320_a("filterempty");
        int l = 0;
        boolean flag = blockLayerIn == BlockRenderLayer.TRANSLUCENT;
        int i1 = flag ? this.field_72755_R.size() - 1 : 0;
        int i = flag ? -1 : this.field_72755_R.size();
        int j1 = flag ? -1 : 1;
        for (int j = i1; j != i; j += j1) {
            RenderChunk renderchunk = this.field_72755_R.get(j).field_178036_a;
            if (renderchunk.func_178571_g().func_178491_b(blockLayerIn)) continue;
            ++l;
            this.field_174996_N.func_178002_a(renderchunk, blockLayerIn);
        }
        this.field_72777_q.field_71424_I.func_194339_b(() -> "render_" + blockLayerIn);
        this.func_174982_a(blockLayerIn);
        this.field_72777_q.field_71424_I.func_76319_b();
        return l;
    }

    private void func_174982_a(BlockRenderLayer blockLayerIn) {
        this.field_72777_q.field_71460_t.func_180436_i();
        if (OpenGlHelper.func_176075_f()) {
            GlStateManager.func_187410_q((int)32884);
            OpenGlHelper.func_77472_b(OpenGlHelper.field_77478_a);
            GlStateManager.func_187410_q((int)32888);
            OpenGlHelper.func_77472_b(OpenGlHelper.field_77476_b);
            GlStateManager.func_187410_q((int)32888);
            OpenGlHelper.func_77472_b(OpenGlHelper.field_77478_a);
            GlStateManager.func_187410_q((int)32886);
        }
        this.field_174996_N.func_178001_a(blockLayerIn);
        if (OpenGlHelper.func_176075_f()) {
            for (VertexFormatElement vertexformatelement : DefaultVertexFormats.field_176600_a.func_177343_g()) {
                VertexFormatElement.EnumUsage vertexformatelement$enumusage = vertexformatelement.func_177375_c();
                int i = vertexformatelement.func_177369_e();
                switch (vertexformatelement$enumusage) {
                    case POSITION: {
                        GlStateManager.func_187429_p((int)32884);
                        break;
                    }
                    case UV: {
                        OpenGlHelper.func_77472_b(OpenGlHelper.field_77478_a + i);
                        GlStateManager.func_187429_p((int)32888);
                        OpenGlHelper.func_77472_b(OpenGlHelper.field_77478_a);
                        break;
                    }
                    case COLOR: {
                        GlStateManager.func_187429_p((int)32886);
                        GlStateManager.func_179117_G();
                    }
                }
            }
        }
        this.field_72777_q.field_71460_t.func_175072_h();
    }

    private void func_174965_a(Iterator<DestroyBlockProgress> iteratorIn) {
        while (iteratorIn.hasNext()) {
            DestroyBlockProgress destroyblockprogress = iteratorIn.next();
            int i = destroyblockprogress.func_82743_f();
            if (this.field_72773_u - i <= 400) continue;
            iteratorIn.remove();
        }
    }

    public void func_72734_e() {
        ++this.field_72773_u;
        if (this.field_72773_u % 20 == 0) {
            this.func_174965_a(this.field_72738_E.values().iterator());
        }
        if (!this.field_184387_ae.isEmpty() && !this.field_174995_M.func_188248_h() && this.field_175009_l.isEmpty()) {
            Iterator<BlockPos> iterator = this.field_184387_ae.iterator();
            while (iterator.hasNext()) {
                BlockPos blockpos = iterator.next();
                iterator.remove();
                int i = blockpos.func_177958_n();
                int j = blockpos.func_177956_o();
                int k = blockpos.func_177952_p();
                this.func_184385_a(i - 1, j - 1, k - 1, i + 1, j + 1, k + 1, false);
            }
        }
    }

    private void func_180448_r() {
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        GlStateManager.func_179132_a((boolean)false);
        this.field_72770_i.func_110577_a(field_110926_k);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (int i = 0; i < 6; ++i) {
            GlStateManager.func_179094_E();
            if (i == 1) {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (i == 2) {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (i == 3) {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (i == 4) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (i == 5) {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(0.0, 0.0).func_181669_b(40, 40, 40, 255).func_181675_d();
            bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(0.0, 16.0).func_181669_b(40, 40, 40, 255).func_181675_d();
            bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(16.0, 16.0).func_181669_b(40, 40, 40, 255).func_181675_d();
            bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(16.0, 0.0).func_181669_b(40, 40, 40, 255).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
    }

    public void func_195465_a(float partialTicks) {
        IRenderHandler renderer = this.field_72769_h.func_201675_m().getSkyRenderer();
        if (renderer != null) {
            renderer.render(partialTicks, this.field_72769_h, this.field_72777_q);
            return;
        }
        if (this.field_72777_q.field_71441_e.field_73011_w.func_186058_p() == DimensionType.THE_END) {
            this.func_180448_r();
        } else if (this.field_72777_q.field_71441_e.field_73011_w.func_76569_d()) {
            GlStateManager.func_179090_x();
            Vec3d vec3d = this.field_72769_h.func_72833_a(this.field_72777_q.func_175606_aa(), partialTicks);
            float f = (float)vec3d.field_72450_a;
            float f1 = (float)vec3d.field_72448_b;
            float f2 = (float)vec3d.field_72449_c;
            GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179127_m();
            GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
            if (this.field_175005_X) {
                this.field_175012_t.func_177359_a();
                GlStateManager.func_187410_q((int)32884);
                GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
                this.field_175012_t.func_177358_a(7);
                this.field_175012_t.func_177361_b();
                GlStateManager.func_187429_p((int)32884);
            } else {
                GlStateManager.func_179148_o((int)this.field_72771_w);
            }
            GlStateManager.func_179106_n();
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderHelper.func_74518_a();
            float[] afloat = this.field_72769_h.field_73011_w.func_76560_a(this.field_72769_h.func_72826_c(partialTicks), partialTicks);
            if (afloat != null) {
                GlStateManager.func_179090_x();
                GlStateManager.func_179103_j((int)7425);
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)this.field_72769_h.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                float f3 = afloat[0];
                float f4 = afloat[1];
                float f5 = afloat[2];
                bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                bufferbuilder.func_181662_b(0.0, 100.0, 0.0).func_181666_a(f3, f4, f5, afloat[3]).func_181675_d();
                int i = 16;
                for (int j = 0; j <= 16; ++j) {
                    float f6 = (float)j * ((float)Math.PI * 2) / 16.0f;
                    float f7 = MathHelper.func_76126_a((float)f6);
                    float f8 = MathHelper.func_76134_b((float)f6);
                    bufferbuilder.func_181662_b(f7 * 120.0f, f8 * 120.0f, -f8 * 40.0f * afloat[3]).func_181666_a(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
                }
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
                GlStateManager.func_179103_j((int)7424);
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            float f11 = 1.0f - this.field_72769_h.func_72867_j(partialTicks);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(this.field_72769_h.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            float f12 = 30.0f;
            this.field_72770_i.func_110577_a(field_110928_i);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(-f12, 100.0, -f12).func_187315_a(0.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(f12, 100.0, -f12).func_187315_a(1.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(f12, 100.0, f12).func_187315_a(1.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(-f12, 100.0, f12).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            f12 = 20.0f;
            this.field_72770_i.func_110577_a(field_110927_h);
            int k = this.field_72769_h.func_72853_d();
            int l = k % 4;
            int i1 = k / 4 % 2;
            float f13 = (float)(l + 0) / 4.0f;
            float f14 = (float)(i1 + 0) / 2.0f;
            float f15 = (float)(l + 1) / 4.0f;
            float f9 = (float)(i1 + 1) / 2.0f;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(-f12, -100.0, f12).func_187315_a(f15, f9).func_181675_d();
            bufferbuilder.func_181662_b(f12, -100.0, f12).func_187315_a(f13, f9).func_181675_d();
            bufferbuilder.func_181662_b(f12, -100.0, -f12).func_187315_a(f13, f14).func_181675_d();
            bufferbuilder.func_181662_b(-f12, -100.0, -f12).func_187315_a(f15, f14).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179090_x();
            float f10 = this.field_72769_h.func_72880_h(partialTicks) * f11;
            if (f10 > 0.0f) {
                GlStateManager.func_179131_c((float)f10, (float)f10, (float)f10, (float)f10);
                if (this.field_175005_X) {
                    this.field_175013_s.func_177359_a();
                    GlStateManager.func_187410_q((int)32884);
                    GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
                    this.field_175013_s.func_177358_a(7);
                    this.field_175013_s.func_177361_b();
                    GlStateManager.func_187429_p((int)32884);
                } else {
                    GlStateManager.func_179148_o((int)this.field_72772_v);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179127_m();
            GlStateManager.func_179121_F();
            GlStateManager.func_179090_x();
            GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
            double d0 = this.field_72777_q.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - this.field_72769_h.func_72919_O();
            if (d0 < 0.0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)12.0f, (float)0.0f);
                if (this.field_175005_X) {
                    this.field_175011_u.func_177359_a();
                    GlStateManager.func_187410_q((int)32884);
                    GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
                    this.field_175011_u.func_177358_a(7);
                    this.field_175011_u.func_177361_b();
                    GlStateManager.func_187429_p((int)32884);
                } else {
                    GlStateManager.func_179148_o((int)this.field_72781_x);
                }
                GlStateManager.func_179121_F();
            }
            if (this.field_72769_h.field_73011_w.func_76561_g()) {
                GlStateManager.func_179124_c((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
            } else {
                GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)(-((float)(d0 - 16.0))), (float)0.0f);
            GlStateManager.func_179148_o((int)this.field_72781_x);
            GlStateManager.func_179121_F();
            GlStateManager.func_179098_w();
            GlStateManager.func_179132_a((boolean)true);
        }
    }

    public void func_195466_a(float partialTicks, double viewEntityX, double viewEntityY, double viewEntityZ) {
        if (CloudRenderer.renderClouds((int)this.field_72773_u, (float)partialTicks, (WorldClient)this.field_72769_h, (Minecraft)this.field_72777_q)) {
            return;
        }
        if (this.field_72777_q.field_71441_e.field_73011_w.func_76569_d()) {
            float f = 12.0f;
            float f1 = 4.0f;
            double d0 = 2.0E-4;
            double d1 = ((float)this.field_72773_u + partialTicks) * 0.03f;
            double d2 = (viewEntityX + d1) / 12.0;
            double d3 = this.field_72769_h.field_73011_w.func_76571_f() - (float)viewEntityY + 0.33f;
            double d4 = viewEntityZ / 12.0 + (double)0.33f;
            d2 -= (double)(MathHelper.func_76128_c((double)(d2 / 2048.0)) * 2048);
            d4 -= (double)(MathHelper.func_76128_c((double)(d4 / 2048.0)) * 2048);
            float f2 = (float)(d2 - (double)MathHelper.func_76128_c((double)d2));
            float f3 = (float)(d3 / 4.0 - (double)MathHelper.func_76128_c((double)(d3 / 4.0))) * 4.0f;
            float f4 = (float)(d4 - (double)MathHelper.func_76128_c((double)d4));
            Vec3d vec3d = this.field_72769_h.func_72824_f(partialTicks);
            int i = (int)Math.floor(d2);
            int j = (int)Math.floor(d3 / 4.0);
            int k = (int)Math.floor(d4);
            if (i != this.field_204602_S || j != this.field_204603_T || k != this.field_204604_U || this.field_72777_q.field_71474_y.func_181147_e() != this.field_204800_W || this.field_204605_V.func_72436_e(vec3d) > 2.0E-4) {
                this.field_204602_S = i;
                this.field_204603_T = j;
                this.field_204604_U = k;
                this.field_204605_V = vec3d;
                this.field_204800_W = this.field_72777_q.field_71474_y.func_181147_e();
                this.field_204607_y = true;
            }
            if (this.field_204607_y) {
                this.field_204607_y = false;
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                if (this.field_204601_A != null) {
                    this.field_204601_A.func_177362_c();
                }
                if (this.field_204608_z >= 0) {
                    GLAllocation.func_74523_b((int)this.field_204608_z);
                    this.field_204608_z = -1;
                }
                if (this.field_175005_X) {
                    this.field_204601_A = new VertexBuffer(DefaultVertexFormats.field_181712_l);
                    this.func_204600_a(bufferbuilder, d2, d3, d4, vec3d);
                    bufferbuilder.func_178977_d();
                    bufferbuilder.func_178965_a();
                    this.field_204601_A.func_181722_a(bufferbuilder.func_178966_f());
                } else {
                    this.field_204608_z = GLAllocation.func_74526_a((int)1);
                    GlStateManager.func_187423_f((int)this.field_204608_z, (int)4864);
                    this.func_204600_a(bufferbuilder, d2, d3, d4, vec3d);
                    tessellator.func_78381_a();
                    GlStateManager.func_187415_K();
                }
            }
            GlStateManager.func_179129_p();
            this.field_72770_i.func_110577_a(field_110925_j);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)12.0f, (float)1.0f, (float)12.0f);
            GlStateManager.func_179109_b((float)(-f2), (float)f3, (float)(-f4));
            if (this.field_175005_X && this.field_204601_A != null) {
                int i1;
                this.field_204601_A.func_177359_a();
                GlStateManager.func_187410_q((int)32884);
                GlStateManager.func_187410_q((int)32888);
                OpenGlHelper.func_77472_b(OpenGlHelper.field_77478_a);
                GlStateManager.func_187410_q((int)32886);
                GlStateManager.func_187410_q((int)32885);
                GlStateManager.func_187420_d((int)3, (int)5126, (int)28, (int)0);
                GlStateManager.func_187405_c((int)2, (int)5126, (int)28, (int)12);
                GlStateManager.func_187406_e((int)4, (int)5121, (int)28, (int)20);
                GlStateManager.func_204611_f((int)5120, (int)28, (int)24);
                for (int k1 = i1 = this.field_204800_W == 2 ? 0 : 1; k1 < 2; ++k1) {
                    if (k1 == 0) {
                        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    this.field_204601_A.func_177358_a(7);
                }
                this.field_204601_A.func_177361_b();
                GlStateManager.func_187429_p((int)32884);
                GlStateManager.func_187429_p((int)32888);
                GlStateManager.func_187429_p((int)32886);
                GlStateManager.func_187429_p((int)32885);
                OpenGlHelper.func_176072_g(OpenGlHelper.field_176089_P, 0);
            } else if (this.field_204608_z >= 0) {
                int l;
                for (int j1 = l = this.field_204800_W == 2 ? 0 : 1; j1 < 2; ++j1) {
                    if (j1 == 0) {
                        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    GlStateManager.func_179148_o((int)this.field_204608_z);
                }
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179117_G();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179089_o();
        }
    }

    private void func_204600_a(BufferBuilder bufferIn, double cloudsX, double cloudsY, double cloudsZ, Vec3d cloudsColor) {
        float f = 4.0f;
        float f1 = 0.00390625f;
        int i = 8;
        int j = 4;
        float f2 = 9.765625E-4f;
        float f3 = (float)MathHelper.func_76128_c((double)cloudsX) * 0.00390625f;
        float f4 = (float)MathHelper.func_76128_c((double)cloudsZ) * 0.00390625f;
        float f5 = (float)cloudsColor.field_72450_a;
        float f6 = (float)cloudsColor.field_72448_b;
        float f7 = (float)cloudsColor.field_72449_c;
        float f8 = f5 * 0.9f;
        float f9 = f6 * 0.9f;
        float f10 = f7 * 0.9f;
        float f11 = f5 * 0.7f;
        float f12 = f6 * 0.7f;
        float f13 = f7 * 0.7f;
        float f14 = f5 * 0.8f;
        float f15 = f6 * 0.8f;
        float f16 = f7 * 0.8f;
        bufferIn.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        float f17 = (float)Math.floor(cloudsY / 4.0) * 4.0f;
        if (this.field_204800_W == 2) {
            for (int k = -3; k <= 4; ++k) {
                for (int l = -3; l <= 4; ++l) {
                    float f18 = k * 8;
                    float f19 = l * 8;
                    if (f17 > -5.0f) {
                        bufferIn.func_181662_b(f18 + 0.0f, f17 + 0.0f, f19 + 8.0f).func_187315_a((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_181666_a(f11, f12, f13, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        bufferIn.func_181662_b(f18 + 8.0f, f17 + 0.0f, f19 + 8.0f).func_187315_a((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_181666_a(f11, f12, f13, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        bufferIn.func_181662_b(f18 + 8.0f, f17 + 0.0f, f19 + 0.0f).func_187315_a((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_181666_a(f11, f12, f13, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        bufferIn.func_181662_b(f18 + 0.0f, f17 + 0.0f, f19 + 0.0f).func_187315_a((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_181666_a(f11, f12, f13, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    }
                    if (f17 <= 5.0f) {
                        bufferIn.func_181662_b(f18 + 0.0f, f17 + 4.0f - 9.765625E-4f, f19 + 8.0f).func_187315_a((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_181666_a(f5, f6, f7, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        bufferIn.func_181662_b(f18 + 8.0f, f17 + 4.0f - 9.765625E-4f, f19 + 8.0f).func_187315_a((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_181666_a(f5, f6, f7, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        bufferIn.func_181662_b(f18 + 8.0f, f17 + 4.0f - 9.765625E-4f, f19 + 0.0f).func_187315_a((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_181666_a(f5, f6, f7, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        bufferIn.func_181662_b(f18 + 0.0f, f17 + 4.0f - 9.765625E-4f, f19 + 0.0f).func_187315_a((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_181666_a(f5, f6, f7, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    }
                    if (k > -1) {
                        for (int i1 = 0; i1 < 8; ++i1) {
                            bufferIn.func_181662_b(f18 + (float)i1 + 0.0f, f17 + 0.0f, f19 + 8.0f).func_187315_a((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_181666_a(f8, f9, f10, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferIn.func_181662_b(f18 + (float)i1 + 0.0f, f17 + 4.0f, f19 + 8.0f).func_187315_a((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_181666_a(f8, f9, f10, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferIn.func_181662_b(f18 + (float)i1 + 0.0f, f17 + 4.0f, f19 + 0.0f).func_187315_a((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_181666_a(f8, f9, f10, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferIn.func_181662_b(f18 + (float)i1 + 0.0f, f17 + 0.0f, f19 + 0.0f).func_187315_a((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_181666_a(f8, f9, f10, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (k <= 1) {
                        for (int j2 = 0; j2 < 8; ++j2) {
                            bufferIn.func_181662_b(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 0.0f, f19 + 8.0f).func_187315_a((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_181666_a(f8, f9, f10, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferIn.func_181662_b(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 4.0f, f19 + 8.0f).func_187315_a((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).func_181666_a(f8, f9, f10, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferIn.func_181662_b(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 4.0f, f19 + 0.0f).func_187315_a((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_181666_a(f8, f9, f10, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferIn.func_181662_b(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 0.0f, f19 + 0.0f).func_187315_a((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).func_181666_a(f8, f9, f10, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (l > -1) {
                        for (int k2 = 0; k2 < 8; ++k2) {
                            bufferIn.func_181662_b(f18 + 0.0f, f17 + 4.0f, f19 + (float)k2 + 0.0f).func_187315_a((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).func_181666_a(f14, f15, f16, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            bufferIn.func_181662_b(f18 + 8.0f, f17 + 4.0f, f19 + (float)k2 + 0.0f).func_187315_a((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).func_181666_a(f14, f15, f16, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            bufferIn.func_181662_b(f18 + 8.0f, f17 + 0.0f, f19 + (float)k2 + 0.0f).func_187315_a((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).func_181666_a(f14, f15, f16, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            bufferIn.func_181662_b(f18 + 0.0f, f17 + 0.0f, f19 + (float)k2 + 0.0f).func_187315_a((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).func_181666_a(f14, f15, f16, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                        }
                    }
                    if (l > 1) continue;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        bufferIn.func_181662_b(f18 + 0.0f, f17 + 4.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).func_187315_a((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).func_181666_a(f14, f15, f16, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                        bufferIn.func_181662_b(f18 + 8.0f, f17 + 4.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).func_187315_a((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).func_181666_a(f14, f15, f16, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                        bufferIn.func_181662_b(f18 + 8.0f, f17 + 0.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).func_187315_a((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).func_181666_a(f14, f15, f16, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                        bufferIn.func_181662_b(f18 + 0.0f, f17 + 0.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).func_187315_a((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).func_181666_a(f14, f15, f16, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                    }
                }
            }
        } else {
            boolean j1 = true;
            int k1 = 32;
            for (int l1 = -32; l1 < 32; l1 += 32) {
                for (int i2 = -32; i2 < 32; i2 += 32) {
                    bufferIn.func_181662_b(l1 + 0, f17, i2 + 32).func_187315_a((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).func_181666_a(f5, f6, f7, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    bufferIn.func_181662_b(l1 + 32, f17, i2 + 32).func_187315_a((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).func_181666_a(f5, f6, f7, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    bufferIn.func_181662_b(l1 + 32, f17, i2 + 0).func_187315_a((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).func_181666_a(f5, f6, f7, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    bufferIn.func_181662_b(l1 + 0, f17, i2 + 0).func_187315_a((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).func_181666_a(f5, f6, f7, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                }
            }
        }
    }

    public void func_174967_a(long finishTimeNano) {
        this.field_147595_R |= this.field_174995_M.func_178516_a(finishTimeNano);
        if (!this.field_175009_l.isEmpty()) {
            RenderChunk renderchunk;
            boolean flag;
            Iterator<RenderChunk> iterator = this.field_175009_l.iterator();
            while (iterator.hasNext() && (flag = (renderchunk = iterator.next()).func_188281_o() ? this.field_174995_M.func_178505_b(renderchunk) : this.field_174995_M.func_178507_a(renderchunk))) {
                renderchunk.func_188282_m();
                iterator.remove();
                long i = finishTimeNano - Util.func_211178_c();
                if (i >= 0L) continue;
                break;
            }
        }
    }

    public void func_180449_a(Entity entityIn, float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        WorldBorder worldborder = this.field_72769_h.func_175723_af();
        double d0 = this.field_72777_q.field_71474_y.field_151451_c * 16;
        if (!(entityIn.field_70165_t < worldborder.func_177728_d() - d0 && entityIn.field_70165_t > worldborder.func_177726_b() + d0 && entityIn.field_70161_v < worldborder.func_177733_e() - d0 && entityIn.field_70161_v > worldborder.func_177736_c() + d0)) {
            double d1 = 1.0 - worldborder.func_177745_a(entityIn) / d0;
            d1 = Math.pow(d1, 4.0);
            double d2 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
            double d3 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
            double d4 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            this.field_72770_i.func_110577_a(field_175006_g);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179094_E();
            int i = worldborder.func_177734_a().func_177766_a();
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)((float)d1));
            GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
            GlStateManager.func_179088_q();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179141_d();
            GlStateManager.func_179129_p();
            float f3 = (float)(Util.func_211177_b() % 3000L) / 3000.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 128.0f;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_178969_c(-d2, -d3, -d4);
            double d5 = Math.max((double)MathHelper.func_76128_c((double)(d4 - d0)), worldborder.func_177736_c());
            double d6 = Math.min((double)MathHelper.func_76143_f((double)(d4 + d0)), worldborder.func_177733_e());
            if (d2 > worldborder.func_177728_d() - d0) {
                float f7 = 0.0f;
                double d7 = d5;
                while (d7 < d6) {
                    double d8 = Math.min(1.0, d6 - d7);
                    float f8 = (float)d8 * 0.5f;
                    bufferbuilder.func_181662_b(worldborder.func_177728_d(), 256.0, d7).func_187315_a(f3 + f7, f3 + 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(worldborder.func_177728_d(), 256.0, d7 + d8).func_187315_a(f3 + f8 + f7, f3 + 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(worldborder.func_177728_d(), 0.0, d7 + d8).func_187315_a(f3 + f8 + f7, f3 + 128.0f).func_181675_d();
                    bufferbuilder.func_181662_b(worldborder.func_177728_d(), 0.0, d7).func_187315_a(f3 + f7, f3 + 128.0f).func_181675_d();
                    d7 += 1.0;
                    f7 += 0.5f;
                }
            }
            if (d2 < worldborder.func_177726_b() + d0) {
                float f9 = 0.0f;
                double d9 = d5;
                while (d9 < d6) {
                    double d12 = Math.min(1.0, d6 - d9);
                    float f12 = (float)d12 * 0.5f;
                    bufferbuilder.func_181662_b(worldborder.func_177726_b(), 256.0, d9).func_187315_a(f3 + f9, f3 + 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(worldborder.func_177726_b(), 256.0, d9 + d12).func_187315_a(f3 + f12 + f9, f3 + 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(worldborder.func_177726_b(), 0.0, d9 + d12).func_187315_a(f3 + f12 + f9, f3 + 128.0f).func_181675_d();
                    bufferbuilder.func_181662_b(worldborder.func_177726_b(), 0.0, d9).func_187315_a(f3 + f9, f3 + 128.0f).func_181675_d();
                    d9 += 1.0;
                    f9 += 0.5f;
                }
            }
            d5 = Math.max((double)MathHelper.func_76128_c((double)(d2 - d0)), worldborder.func_177726_b());
            d6 = Math.min((double)MathHelper.func_76143_f((double)(d2 + d0)), worldborder.func_177728_d());
            if (d4 > worldborder.func_177733_e() - d0) {
                float f10 = 0.0f;
                double d10 = d5;
                while (d10 < d6) {
                    double d13 = Math.min(1.0, d6 - d10);
                    float f13 = (float)d13 * 0.5f;
                    bufferbuilder.func_181662_b(d10, 256.0, worldborder.func_177733_e()).func_187315_a(f3 + f10, f3 + 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(d10 + d13, 256.0, worldborder.func_177733_e()).func_187315_a(f3 + f13 + f10, f3 + 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(d10 + d13, 0.0, worldborder.func_177733_e()).func_187315_a(f3 + f13 + f10, f3 + 128.0f).func_181675_d();
                    bufferbuilder.func_181662_b(d10, 0.0, worldborder.func_177733_e()).func_187315_a(f3 + f10, f3 + 128.0f).func_181675_d();
                    d10 += 1.0;
                    f10 += 0.5f;
                }
            }
            if (d4 < worldborder.func_177736_c() + d0) {
                float f11 = 0.0f;
                double d11 = d5;
                while (d11 < d6) {
                    double d14 = Math.min(1.0, d6 - d11);
                    float f14 = (float)d14 * 0.5f;
                    bufferbuilder.func_181662_b(d11, 256.0, worldborder.func_177736_c()).func_187315_a(f3 + f11, f3 + 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(d11 + d14, 256.0, worldborder.func_177736_c()).func_187315_a(f3 + f14 + f11, f3 + 0.0f).func_181675_d();
                    bufferbuilder.func_181662_b(d11 + d14, 0.0, worldborder.func_177736_c()).func_187315_a(f3 + f14 + f11, f3 + 128.0f).func_181675_d();
                    bufferbuilder.func_181662_b(d11, 0.0, worldborder.func_177736_c()).func_187315_a(f3 + f11, f3 + 128.0f).func_181675_d();
                    d11 += 1.0;
                    f11 += 0.5f;
                }
            }
            tessellator.func_78381_a();
            bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179089_o();
            GlStateManager.func_179118_c();
            GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
            GlStateManager.func_179113_r();
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
            GlStateManager.func_179132_a((boolean)true);
        }
    }

    private void func_180443_s() {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-1.0f, (float)-10.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
    }

    private void func_174969_t() {
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public void func_174981_a(Tessellator tessellatorIn, BufferBuilder bufferBuilderIn, Entity entityIn, float partialTicks) {
        double d0 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d1 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d2 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        if (!this.field_72738_E.isEmpty()) {
            this.field_72770_i.func_110577_a(TextureMap.field_110575_b);
            this.func_180443_s();
            bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            bufferBuilderIn.func_178969_c(-d0, -d1, -d2);
            bufferBuilderIn.func_78914_f();
            Iterator<DestroyBlockProgress> iterator = this.field_72738_E.values().iterator();
            while (iterator.hasNext()) {
                double d5;
                double d4;
                boolean hasBreak;
                DestroyBlockProgress destroyblockprogress = iterator.next();
                BlockPos blockpos = destroyblockprogress.func_180246_b();
                Block block = this.field_72769_h.func_180495_p(blockpos).func_177230_c();
                TileEntity te = this.field_72769_h.func_175625_s(blockpos);
                boolean bl = hasBreak = block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockSign || block instanceof BlockAbstractSkull;
                if (!hasBreak) {
                    boolean bl2 = hasBreak = te != null && te.canRenderBreaking();
                }
                if (hasBreak) continue;
                double d3 = (double)blockpos.func_177958_n() - d0;
                if (d3 * d3 + (d4 = (double)blockpos.func_177956_o() - d1) * d4 + (d5 = (double)blockpos.func_177952_p() - d2) * d5 > 1024.0) {
                    iterator.remove();
                    continue;
                }
                IBlockState iblockstate = this.field_72769_h.func_180495_p(blockpos);
                if (iblockstate.isAir((IBlockReader)this.field_72769_h, blockpos)) continue;
                int i = destroyblockprogress.func_73106_e();
                TextureAtlasSprite textureatlassprite = this.field_94141_F[i];
                BlockRendererDispatcher blockrendererdispatcher = this.field_72777_q.func_175602_ab();
                blockrendererdispatcher.func_175020_a(iblockstate, blockpos, textureatlassprite, this.field_72769_h);
            }
            tessellatorIn.func_78381_a();
            bufferBuilderIn.func_178969_c(0.0, 0.0, 0.0);
            this.func_174969_t();
        }
    }

    public void func_72731_b(EntityPlayer player, RayTraceResult movingObjectPositionIn, int execute, float partialTicks) {
        BlockPos blockpos;
        IBlockState iblockstate;
        if (execute == 0 && movingObjectPositionIn.field_72313_a == RayTraceResult.Type.BLOCK && !(iblockstate = this.field_72769_h.func_180495_p(blockpos = movingObjectPositionIn.func_178782_a())).isAir((IBlockReader)this.field_72769_h, blockpos) && this.field_72769_h.func_175723_af().func_177746_a(blockpos)) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)Math.max(2.5f, (float)this.field_72777_q.field_195558_d.func_198109_k() / 1920.0f * 2.5f));
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)0.999f);
            double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            WorldRenderer.func_195463_b(iblockstate.func_196954_c((IBlockReader)this.field_72769_h, blockpos), (double)blockpos.func_177958_n() - d0, (double)blockpos.func_177956_o() - d1, (double)blockpos.func_177952_p() - d2, 0.0f, 0.0f, 0.0f, 0.4f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    public static void func_195470_a(VoxelShape voxelShapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
        List list = voxelShapeIn.func_197756_d();
        int i = MathHelper.func_76143_f((double)((double)list.size() / 3.0));
        for (int j = 0; j < list.size(); ++j) {
            AxisAlignedBB axisalignedbb = (AxisAlignedBB)list.get(j);
            float f = ((float)j % (float)i + 1.0f) / (float)i;
            float f1 = j / i;
            float f2 = f * (float)(f1 == 0.0f ? 1 : 0);
            float f3 = f * (float)(f1 == 1.0f ? 1 : 0);
            float f4 = f * (float)(f1 == 2.0f ? 1 : 0);
            WorldRenderer.func_195463_b(VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb.func_72317_d(0.0, 0.0, 0.0)), xIn, yIn, zIn, f2, f3, f4, 1.0f);
        }
    }

    public static void func_195463_b(VoxelShape voxelShapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        voxelShapeIn.func_197754_a((p_195468_11_, p_195468_13_, p_195468_15_, p_195468_17_, p_195468_19_, p_195468_21_) -> {
            bufferbuilder.func_181662_b(p_195468_11_ + xIn, p_195468_13_ + yIn, p_195468_15_ + zIn).func_181666_a(red, green, blue, alpha).func_181675_d();
            bufferbuilder.func_181662_b(p_195468_17_ + xIn, p_195468_19_ + yIn, p_195468_21_ + zIn).func_181666_a(red, green, blue, alpha).func_181675_d();
        });
        tessellator.func_78381_a();
    }

    public static void func_189697_a(AxisAlignedBB box, float red, float green, float blue, float alpha) {
        WorldRenderer.func_189694_a(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f, red, green, blue, alpha);
    }

    public static void func_189694_a(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        WorldRenderer.func_189698_a(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, red, green, blue, alpha);
        tessellator.func_78381_a();
    }

    public static void func_189698_a(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
    }

    public static void func_189696_b(AxisAlignedBB aabb, float red, float green, float blue, float alpha) {
        WorldRenderer.func_189695_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f, red, green, blue, alpha);
    }

    public static void func_189695_b(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        WorldRenderer.func_189693_b(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, red, green, blue, alpha);
        tessellator.func_78381_a();
    }

    public static void func_189693_b(BufferBuilder builder, double x1, double y1, double z1, double x2, double y2, double z2, float red, float green, float blue, float alpha) {
        builder.func_181662_b(x1, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
    }

    private void func_184385_a(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean updateImmediately) {
        this.field_175008_n.func_187474_a(minX, minY, minZ, maxX, maxY, maxZ, updateImmediately);
    }

    public void func_184376_a(IBlockReader worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        this.func_184385_a(i - 1, j - 1, k - 1, i + 1, j + 1, k + 1, (flags & 8) != 0);
    }

    public void func_174959_b(BlockPos pos) {
        this.field_184387_ae.add(pos.func_185334_h());
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.func_184385_a(x1 - 1, y1 - 1, z1 - 1, x2 + 1, y2 + 1, z2 + 1, false);
    }

    public void func_184377_a(@Nullable SoundEvent soundIn, BlockPos pos) {
        ISound isound = this.field_147593_P.get(pos);
        if (isound != null) {
            this.field_72777_q.func_147118_V().func_147683_b(isound);
            this.field_147593_P.remove(pos);
        }
        if (soundIn != null) {
            ItemRecord itemrecord = ItemRecord.func_185074_a((SoundEvent)soundIn);
            if (itemrecord != null) {
                this.field_72777_q.field_71456_v.func_73833_a(itemrecord.func_200299_h().func_150254_d());
            }
            SimpleSound simplesound = SimpleSound.func_184372_a((SoundEvent)soundIn, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
            this.field_147593_P.put(pos, (ISound)simplesound);
            this.field_72777_q.func_147118_V().func_147682_a((ISound)simplesound);
        }
        this.func_193054_a(this.field_72769_h, pos, soundIn != null);
    }

    private void func_193054_a(World worldIn, BlockPos pos, boolean isPartying) {
        for (EntityLivingBase entitylivingbase : worldIn.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_186662_g(3.0))) {
            entitylivingbase.func_191987_a(pos, isPartying);
        }
    }

    public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_195461_a(IParticleData particleData, boolean alwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.func_195462_a(particleData, alwaysRender, false, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_195462_a(IParticleData particleData, boolean ignoreRange, boolean minimizeLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        try {
            this.func_195469_b(particleData, ignoreRange, minimizeLevel, x, y, z, xSpeed, ySpeed, zSpeed);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception while adding particle");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being added");
            crashreportcategory.func_71507_a("ID", particleData.func_197554_b().func_197570_d());
            crashreportcategory.func_71507_a("Parameters", particleData.func_197555_a());
            crashreportcategory.func_189529_a("Position", (ICrashReportDetail<String>)((ICrashReportDetail)() -> CrashReportCategory.func_85074_a(x, y, z)));
            throw new ReportedException(crashreport);
        }
    }

    private <T extends IParticleData> void func_195467_a(T particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.func_195461_a(particleData, particleData.func_197554_b().func_197575_f(), x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Nullable
    private Particle func_195471_b(IParticleData particleData, boolean alwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        return this.func_195469_b(particleData, alwaysRender, false, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Nullable
    private Particle func_195469_b(IParticleData particleData, boolean alwaysRender, boolean minimizeLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        Entity entity = this.field_72777_q.func_175606_aa();
        if (this.field_72777_q != null && entity != null && this.field_72777_q.field_71452_i != null) {
            int i = this.func_190572_a(minimizeLevel);
            double d0 = entity.field_70165_t - x;
            double d1 = entity.field_70163_u - y;
            double d2 = entity.field_70161_v - z;
            if (alwaysRender) {
                return this.field_72777_q.field_71452_i.func_199280_a(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
            }
            if (d0 * d0 + d1 * d1 + d2 * d2 > 1024.0) {
                return null;
            }
            return i > 1 ? null : this.field_72777_q.field_71452_i.func_199280_a(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        }
        return null;
    }

    private int func_190572_a(boolean minimiseLevel) {
        int i = this.field_72777_q.field_71474_y.field_74362_aa;
        if (minimiseLevel && i == 2 && this.field_72769_h.field_73012_v.nextInt(10) == 0) {
            i = 1;
        }
        if (i == 1 && this.field_72769_h.field_73012_v.nextInt(3) == 0) {
            i = 2;
        }
        return i;
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
    }

    public void func_72728_f() {
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
        switch (soundID) {
            case 1023: 
            case 1028: 
            case 1038: {
                Entity entity = this.field_72777_q.func_175606_aa();
                if (entity == null) break;
                double d0 = (double)pos.func_177958_n() - entity.field_70165_t;
                double d1 = (double)pos.func_177956_o() - entity.field_70163_u;
                double d2 = (double)pos.func_177952_p() - entity.field_70161_v;
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                double d4 = entity.field_70165_t;
                double d5 = entity.field_70163_u;
                double d6 = entity.field_70161_v;
                if (d3 > 0.0) {
                    d4 += d0 / d3 * 2.0;
                    d5 += d1 / d3 * 2.0;
                    d6 += d2 / d3 * 2.0;
                }
                if (soundID == 1023) {
                    this.field_72769_h.func_184134_a(d4, d5, d6, SoundEvents.field_187855_gD, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                if (soundID == 1038) {
                    this.field_72769_h.func_184134_a(d4, d5, d6, SoundEvents.field_193782_bq, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                this.field_72769_h.func_184134_a(d4, d5, d6, SoundEvents.field_187522_aL, SoundCategory.HOSTILE, 5.0f, 1.0f, false);
            }
        }
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
        Random random = this.field_72769_h.field_73012_v;
        switch (type) {
            case 1000: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187574_as, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1001: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187576_at, SoundCategory.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1002: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187578_au, SoundCategory.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1003: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187528_aR, SoundCategory.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1004: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187634_bp, SoundCategory.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1005: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187611_cI, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1006: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187875_gN, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1007: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187879_gP, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1008: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187613_bi, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1009: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f, false);
                break;
            }
            case 1010: {
                if (Item.func_150899_d(data) instanceof ItemRecord) {
                    this.field_72769_h.func_184149_a(blockPosIn, ((ItemRecord)Item.func_150899_d(data)).func_185075_h());
                    break;
                }
                this.field_72769_h.func_184149_a(blockPosIn, null);
                break;
            }
            case 1011: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187608_cH, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1012: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1013: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187877_gO, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1014: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187610_bh, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1015: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187559_bL, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1016: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187557_bK, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1017: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187527_aQ, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1018: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187606_E, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1019: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187927_ha, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1020: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187928_hb, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1021: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187929_hc, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1022: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187926_gz, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1024: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187853_gC, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1025: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187744_z, SoundCategory.NEUTRAL, 0.05f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1026: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187945_hs, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1027: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187941_ho, SoundCategory.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1029: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187680_c, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1030: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1031: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.3f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1032: {
                this.field_72777_q.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187812_eh, (float)(random.nextFloat() * 0.4f + 0.8f)));
                break;
            }
            case 1033: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187542_ac, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1034: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187540_ab, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1035: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187621_J, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1036: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187614_cJ, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1037: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1039: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_203257_fu, SoundCategory.HOSTILE, 0.3f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1040: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_204783_kG, SoundCategory.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1041: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_207378_dT, SoundCategory.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 2000: {
                EnumFacing enumfacing = EnumFacing.func_82600_a(data);
                int i = enumfacing.func_82601_c();
                int j1 = enumfacing.func_96559_d();
                int j = enumfacing.func_82599_e();
                double d13 = (double)blockPosIn.func_177958_n() + (double)i * 0.6 + 0.5;
                double d15 = (double)blockPosIn.func_177956_o() + (double)j1 * 0.6 + 0.5;
                double d16 = (double)blockPosIn.func_177952_p() + (double)j * 0.6 + 0.5;
                for (int l1 = 0; l1 < 10; ++l1) {
                    double d18 = random.nextDouble() * 0.2 + 0.01;
                    double d21 = d13 + (double)i * 0.01 + (random.nextDouble() - 0.5) * (double)j * 0.5;
                    double d23 = d15 + (double)j1 * 0.01 + (random.nextDouble() - 0.5) * (double)j1 * 0.5;
                    double d25 = d16 + (double)j * 0.01 + (random.nextDouble() - 0.5) * (double)i * 0.5;
                    double d26 = (double)i * d18 + random.nextGaussian() * 0.01;
                    double d27 = (double)j1 * d18 + random.nextGaussian() * 0.01;
                    double d9 = (double)j * d18 + random.nextGaussian() * 0.01;
                    this.func_195467_a(Particles.field_197601_L, d21, d23, d25, d26, d27, d9);
                }
                break;
            }
            case 2001: {
                IBlockState iblockstate = Block.func_196257_b(data);
                if (!iblockstate.isAir((IBlockReader)this.field_72769_h, blockPosIn)) {
                    SoundType soundtype = iblockstate.getSoundType(this.field_72769_h, blockPosIn, null);
                    this.field_72769_h.func_184156_a(blockPosIn, soundtype.func_185845_c(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                }
                this.field_72777_q.field_71452_i.func_180533_a(blockPosIn, iblockstate);
                break;
            }
            case 2002: 
            case 2007: {
                double d10 = blockPosIn.func_177958_n();
                double d11 = blockPosIn.func_177956_o();
                double d12 = blockPosIn.func_177952_p();
                for (int k1 = 0; k1 < 8; ++k1) {
                    this.func_195467_a(new ItemParticleData(Particles.field_197591_B, new ItemStack(Items.field_185155_bH)), d10, d11, d12, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
                }
                float f5 = (float)(data >> 16 & 0xFF) / 255.0f;
                float f = (float)(data >> 8 & 0xFF) / 255.0f;
                float f1 = (float)(data >> 0 & 0xFF) / 255.0f;
                BasicParticleType iparticledata = type == 2007 ? Particles.field_197590_A : Particles.field_197620_m;
                for (int l = 0; l < 100; ++l) {
                    double d17 = random.nextDouble() * 4.0;
                    double d20 = random.nextDouble() * Math.PI * 2.0;
                    double d4 = Math.cos(d20) * d17;
                    double d6 = 0.01 + random.nextDouble() * 0.5;
                    double d8 = Math.sin(d20) * d17;
                    Particle particle1 = this.func_195471_b((IParticleData)iparticledata, iparticledata.func_197554_b().func_197575_f(), d10 + d4 * 0.1, d11 + 0.3, d12 + d8 * 0.1, d4, d6, d8);
                    if (particle1 == null) continue;
                    float f4 = 0.75f + random.nextFloat() * 0.25f;
                    particle1.func_70538_b(f5 * f4, f * f4, f1 * f4);
                    particle1.func_70543_e((float)d17);
                }
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187825_fO, SoundCategory.NEUTRAL, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2003: {
                double d0 = (double)blockPosIn.func_177958_n() + 0.5;
                double d1 = blockPosIn.func_177956_o();
                double d2 = (double)blockPosIn.func_177952_p() + 0.5;
                for (int k = 0; k < 8; ++k) {
                    this.func_195467_a(new ItemParticleData(Particles.field_197591_B, new ItemStack(Items.field_151061_bv)), d0, d1, d2, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
                }
                for (double d14 = 0.0; d14 < Math.PI * 2; d14 += 0.15707963267948966) {
                    this.func_195467_a(Particles.field_197599_J, d0 + Math.cos(d14) * 5.0, d1 - 0.4, d2 + Math.sin(d14) * 5.0, Math.cos(d14) * -5.0, 0.0, Math.sin(d14) * -5.0);
                    this.func_195467_a(Particles.field_197599_J, d0 + Math.cos(d14) * 5.0, d1 - 0.4, d2 + Math.sin(d14) * 5.0, Math.cos(d14) * -7.0, 0.0, Math.sin(d14) * -7.0);
                }
                break;
            }
            case 2004: {
                for (int i2 = 0; i2 < 20; ++i2) {
                    double d19 = (double)blockPosIn.func_177958_n() + 0.5 + ((double)this.field_72769_h.field_73012_v.nextFloat() - 0.5) * 2.0;
                    double d22 = (double)blockPosIn.func_177956_o() + 0.5 + ((double)this.field_72769_h.field_73012_v.nextFloat() - 0.5) * 2.0;
                    double d24 = (double)blockPosIn.func_177952_p() + 0.5 + ((double)this.field_72769_h.field_73012_v.nextFloat() - 0.5) * 2.0;
                    this.field_72769_h.func_195594_a((IParticleData)Particles.field_197601_L, d19, d22, d24, 0.0, 0.0, 0.0);
                    this.field_72769_h.func_195594_a((IParticleData)Particles.field_197631_x, d19, d22, d24, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 2005: {
                ItemBoneMeal.func_195965_a(this.field_72769_h, blockPosIn, data);
                break;
            }
            case 2006: {
                for (int i1 = 0; i1 < 200; ++i1) {
                    float f2 = random.nextFloat() * 4.0f;
                    float f3 = random.nextFloat() * ((float)Math.PI * 2);
                    double d3 = MathHelper.func_76134_b((float)f3) * f2;
                    double d5 = 0.01 + random.nextDouble() * 0.5;
                    double d7 = MathHelper.func_76126_a((float)f3) * f2;
                    Particle particle = this.func_195471_b((IParticleData)Particles.field_197616_i, false, (double)blockPosIn.func_177958_n() + d3 * 0.1, (double)blockPosIn.func_177956_o() + 0.3, (double)blockPosIn.func_177952_p() + d7 * 0.1, d3, d5, d7);
                    if (particle == null) continue;
                    particle.func_70543_e(f2);
                }
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187523_aM, SoundCategory.HOSTILE, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 3000: {
                this.field_72769_h.func_195590_a((IParticleData)Particles.field_197626_s, true, (double)blockPosIn.func_177958_n() + 0.5, (double)blockPosIn.func_177956_o() + 0.5, (double)blockPosIn.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187598_bd, SoundCategory.BLOCKS, 10.0f, (1.0f + (this.field_72769_h.field_73012_v.nextFloat() - this.field_72769_h.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
                break;
            }
            case 3001: {
                this.field_72769_h.func_184156_a(blockPosIn, SoundEvents.field_187525_aO, SoundCategory.HOSTILE, 64.0f, 0.8f + this.field_72769_h.field_73012_v.nextFloat() * 0.3f, false);
            }
        }
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        if (progress >= 0 && progress < 10) {
            DestroyBlockProgress destroyblockprogress = this.field_72738_E.get(breakerId);
            if (destroyblockprogress == null || destroyblockprogress.func_180246_b().func_177958_n() != pos.func_177958_n() || destroyblockprogress.func_180246_b().func_177956_o() != pos.func_177956_o() || destroyblockprogress.func_180246_b().func_177952_p() != pos.func_177952_p()) {
                destroyblockprogress = new DestroyBlockProgress(breakerId, pos);
                this.field_72738_E.put(breakerId, destroyblockprogress);
            }
            destroyblockprogress.func_73107_a(progress);
            destroyblockprogress.func_82744_b(this.field_72773_u);
        } else {
            this.field_72738_E.remove(breakerId);
        }
    }

    public boolean func_184384_n() {
        return this.field_175009_l.isEmpty() && this.field_174995_M.func_188247_f();
    }

    public void func_174979_m() {
        this.field_147595_R = true;
        this.field_204607_y = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_181023_a(Collection<TileEntity> tileEntitiesToRemove, Collection<TileEntity> tileEntitiesToAdd) {
        Set<TileEntity> set = this.field_181024_n;
        synchronized (set) {
            this.field_181024_n.removeAll(tileEntitiesToRemove);
            this.field_181024_n.addAll(tileEntitiesToAdd);
        }
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }

    @OnlyIn(value=Dist.CLIENT)
    class ContainerLocalRenderInformation {
        private final RenderChunk field_178036_a;
        private final EnumFacing field_178034_b;
        private byte field_178035_c;
        private final int field_178032_d;

        private ContainerLocalRenderInformation(@Nullable RenderChunk renderChunkIn, EnumFacing facingIn, int counterIn) {
            this.field_178036_a = renderChunkIn;
            this.field_178034_b = facingIn;
            this.field_178032_d = counterIn;
        }

        public void func_189561_a(byte dir, EnumFacing facingIn) {
            this.field_178035_c = (byte)(this.field_178035_c | dir | 1 << facingIn.ordinal());
        }

        public boolean func_189560_a(EnumFacing facingIn) {
            return (this.field_178035_c & 1 << facingIn.ordinal()) > 0;
        }
    }
}

